/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.data;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.RB;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.rpf.Context;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DataModel {
    public static final String RB_KEY = "DataModel.";
    public String name;
    public HashMap varLookup = new HashMap();
    private int rows;
    private int columns;
    private ArrayList labels;
    private ArrayList types;
    private Object[] columnList;
    public double computedXMin = Double.NaN;
    public double computedXMax = Double.NaN;
    public double computedYMin = Double.NaN;
    public double computedYMax = Double.NaN;
    public double computedX2Min = Double.NaN;
    public double computedX2Max = Double.NaN;
    public double computedY2Min = Double.NaN;
    public double computedY2Max = Double.NaN;
    public boolean minMaxComputed = false;
    public HashMap maxGroupsPerCategory;
    public int maxNumJitteredPoints = -1;
    public static final SASFormat defaultFormat = SASFormat.getInstance((String)"BEST6.");
    private OLAPDataSetInterface olapData = null;
    private OLAPVariableFactory olapFactory = null;
    public String xCategoryVar = null;
    public String x2CategoryVar = null;
    public String yCategoryVar = null;
    public String y2CategoryVar = null;
    private Context rpfContext = null;
    private boolean specializedData = false;
    private static final int MAX_CACHED_FORMATTED_VALUE = 25;

    public DataModel() {
        this(null);
    }

    public DataModel(String name) {
        this.name = name;
        this.labels = new ArrayList();
        this.types = new ArrayList();
    }

    public OLAPDataSetInterface getOLAPData() {
        return this.olapData;
    }

    public void setOLAPData(OLAPDataSetInterface olap) {
        this.olapData = olap;
    }

    public boolean isOLAP() {
        return this.olapData != null;
    }

    public OLAPVariableFactory getOLAPVarFactory() {
        if (!this.isOLAP()) {
            return null;
        }
        if (this.olapFactory == null) {
            try {
                this.olapFactory = new OLAPVariableFactory((ResultSetInterface)this.olapData);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return this.olapFactory;
    }

    public Context getRPFContext() {
        return this.rpfContext;
    }

    public void setRPFContext(Context context) {
        this.rpfContext = context;
    }

    public Collection getRPFRules() {
        if (this.rpfContext == null | this.rpfContext.isEmpty()) {
            return null;
        }
        return this.rpfContext.getRules();
    }

    public static String formatNumber(double d) {
        return defaultFormat.format((Object)new Double(d)).trim();
    }

    public static String formatNumber(Double d) {
        return defaultFormat.format((Object)d).trim();
    }

    public void setSize(int rows, int cols) {
        this.rows = rows;
        this.columns = cols;
        this.columnList = new Object[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            ColumnMetadata cmd = (ColumnMetadata)this.labels.get(i);
            int nobs = cmd.getNobs();
            if (nobs == Integer.MAX_VALUE) {
                nobs = rows;
                cmd.setNobs(rows);
            }
            this.columnList[i] = this.types.get(i) == Double.class ? new DoubleArray(rows, nobs) : new StringArray(rows, nobs);
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public void addColumn(Class varClass, Object label) {
        this.types.add(varClass);
        this.labels.add(label);
    }

    public void addStringColumn(String name, String label, String fmt, int len, int nobs) {
        this.types.add(String.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 2);
        cmd.setLabel(label);
        if (fmt != null) {
            cmd.setFormat(fmt);
        }
        cmd.setLength(len);
        cmd.setNobs(nobs);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, nobs);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        newColumnList[this.columns - 1] = new StringArray(new String[nobs]);
        this.columnList = newColumnList;
    }

    public void appendStringColumnData(String name, char[] colData) {
        int col = this.getColumn(name);
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(col);
        int len = cmd.getLength();
        StringArray sa = (StringArray)this.columnList[col];
        int cnt = cmd.lastAddedObs;
        int nmiss = 0;
        int i = 0;
        int offset = 0;
        while (i < colData.length) {
            String str = new String(colData, offset, len);
            if (str.trim().length() == 0) {
                str = null;
                ++nmiss;
            }
            sa.values[cnt++] = str;
            ++i;
            offset += len;
        }
        cmd.setMissings(nmiss + cmd.getMissings());
        cmd.lastAddedObs += colData.length / len;
    }

    public void addStringColumn(String name, String label, String fmt, int len, int nmiss, int nobs, char[] colData) {
        this.types.add(String.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 2);
        cmd.setLabel(label);
        if (fmt != null) {
            cmd.setFormat(fmt);
        }
        cmd.setMissings(nmiss);
        cmd.setLength(len);
        cmd.setNobs(nobs);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, nobs);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        String[] strs = new String[nobs];
        int cnt = 0;
        int offset = 0;
        for (int i = 0; i < colData.length; ++i) {
            if (colData[i] != '\u0000') continue;
            strs[cnt++] = i == offset ? null : new String(colData, offset, i - offset);
            offset = i + 1;
        }
        newColumnList[this.columns - 1] = new StringArray(strs);
        this.columnList = newColumnList;
    }

    public void addStringColumn(String name, String label, String fmt, int len, int nmiss, String[] colData) {
        this.types.add(String.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 2);
        cmd.setLabel(label);
        if (fmt != null) {
            cmd.setFormat(fmt);
        }
        cmd.setMissings(nmiss);
        cmd.setLength(len);
        cmd.setNobs(colData.length);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, colData.length);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        newColumnList[this.columns - 1] = new StringArray(colData);
        this.columnList = newColumnList;
    }

    public void addStringColumn(String name, String label, String format, int nobs) {
        this.types.add(String.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 2);
        cmd.setLabel(label);
        cmd.setFormat(format);
        cmd.setNobs(nobs);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, nobs);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        newColumnList[this.columns - 1] = new StringArray(this.rows, nobs);
        this.columnList = newColumnList;
    }

    public void addDoubleColumn(String name, String label, String fmt, double min, double max, int nmiss, double[] colData) {
        this.types.add(Double.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 1);
        cmd.setLabel(label);
        if (fmt != null) {
            cmd.setFormat(fmt);
        }
        cmd.setMin(min);
        cmd.setMax(max);
        cmd.setMissings(nmiss);
        cmd.setNobs(colData.length);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, colData.length);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        newColumnList[this.columns - 1] = new DoubleArray(colData);
        this.columnList = newColumnList;
    }

    public void addDoubleColumn(String name, String label, String format, int nobs) {
        this.types.add(Double.class);
        ColumnMetadata cmd = new ColumnMetadata(name, 1);
        cmd.setLabel(label);
        cmd.setFormat(format);
        cmd.setNobs(nobs);
        this.labels.add(cmd);
        this.varLookup.put(name, new Integer(this.columns));
        ++this.columns;
        this.rows = Math.max(this.rows, nobs);
        Object[] newColumnList = new Object[this.columns];
        for (int i = 0; i < this.columns - 1; ++i) {
            newColumnList[i] = this.columnList[i];
        }
        newColumnList[this.columns - 1] = new DoubleArray(this.rows, nobs, Double.NaN);
        this.columnList = newColumnList;
    }

    public void setColumnMetaData(String colName, double min, double max, int nmiss) {
        int col = this.getColumn(colName);
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(col);
        cmd.setMissings(nmiss);
        cmd.setMin(min);
        cmd.setMax(max);
    }

    public void setColumnLabel(int index, Object label) {
        this.labels.set(index, label);
    }

    public Object getColumnLabel(int index) {
        return this.labels.get(index);
    }

    public Object[] getColumnLabels() {
        Object[] labs = new Object[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            labs[i] = this.getColumnLabel(i);
        }
        return labs;
    }

    public Class getColumnClass(int index) {
        return (Class)this.types.get(index);
    }

    public void setColumnClass(int index, Class c) {
        this.types.set(index, c);
    }

    public Class[] getColumnClasses() {
        Class[] cls = new Class[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            cls[i] = this.getColumnClass(i);
        }
        return cls;
    }

    public String[] getColumnAsClassColumn(int index) {
        if (this.getColumnClass(index) == Double.class) {
            return this.getDoubleAsClassColumn(index);
        }
        return this.getStringAsClassColumn(index);
    }

    public String[] getColumnAsClassColumn(int index, boolean includeMissing) {
        if (this.getColumnClass(index) == Double.class) {
            return this.getDoubleAsClassColumn(index, includeMissing);
        }
        return this.getStringAsClassColumn(index, includeMissing);
    }

    public double[] getDoubleColumn(int index) {
        return ((DoubleArray)this.columnList[index]).values;
    }

    public String[] getDoubleAsClassColumn(int index) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((DoubleArray)this.columnList[index]).toStringArray(format);
    }

    public String[] getDoubleAsClassColumn(int index, boolean includeMissing) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((DoubleArray)this.columnList[index]).toStringArray(format, includeMissing);
    }

    public String[] getDoubleAsClassColumn(int index, boolean includeMissing, boolean update) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((DoubleArray)this.columnList[index]).toStringArray(format, includeMissing, update);
    }

    public String[] getStringColumn(int index) {
        return ((StringArray)this.columnList[index]).values;
    }

    public String[] getStringAsClassColumn(int index) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((StringArray)this.columnList[index]).toStringArray(format);
    }

    public String[] getStringAsClassColumn(int index, boolean includeMissing) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((StringArray)this.columnList[index]).toStringArray(format, includeMissing);
    }

    public String[] getStringAsClassColumn(int index, boolean includeMissing, boolean update) {
        ColumnMetadata cmd = (ColumnMetadata)this.getColumnLabel(index);
        SASFormat format = cmd.getFormat();
        return ((StringArray)this.columnList[index]).toStringArray(format, includeMissing, update);
    }

    public void setStringValueAt(String s, int r, int c) {
        ((StringArray)this.columnList[c]).values[r] = s;
    }

    public void setDoubleValueAt(double d, int r, int c) {
        ((DoubleArray)this.columnList[c]).values[r] = d;
    }

    public Object getColumn(int c) {
        return this.columnList[c];
    }

    public void setColumn(int c, Object o) {
        this.columnList[c] = o;
    }

    public boolean hasColumn(String varID) {
        Object o = this.varLookup.get(varID);
        return o != null;
    }

    public int getColumn(String varID) {
        Object o = this.varLookup.get(varID);
        if (o == null) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "var.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)varID), false);
            return 0;
        }
        if (!(o instanceof Integer)) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "var.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)varID), false);
            return 0;
        }
        return (Integer)o;
    }

    public int getColumnValueCount(int col) {
        ColumnMetadata cmd = (ColumnMetadata)this.labels.get(col);
        return cmd.getNobs();
    }

    public String[] getUpdatedColumnAsClassColumn(int index) {
        if (this.getColumnClass(index) == Double.class) {
            return this.getDoubleAsClassColumn(index, true, true);
        }
        return this.getStringAsClassColumn(index, true, true);
    }

    public boolean isSpecializedData() {
        return this.specializedData;
    }

    public void setSpecializedData(boolean specialized) {
        this.specializedData = specialized;
    }

    public static class DoubleArray {
        public double[] values;
        private String[] classes;
        private int nobs;
        private boolean includeMissing = false;

        public DoubleArray(int size, int nobs) {
            this.nobs = nobs;
            this.values = new double[size];
            int start = 0;
            if (nobs != Integer.MAX_VALUE) {
                start = nobs;
            }
            for (int i = start; i < size; ++i) {
                this.values[i] = Double.NaN;
            }
        }

        public DoubleArray(int size, int nobs, double defaultValue) {
            this.nobs = nobs;
            this.values = new double[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = defaultValue;
            }
        }

        public DoubleArray(double[] values) {
            this.nobs = values.length;
            this.values = values;
        }

        public String[] toStringArray(SASFormat format) {
            return this.toStringArray(format, false, false);
        }

        public String[] toStringArray(SASFormat format, boolean includeMissing) {
            return this.toStringArray(format, includeMissing, false);
        }

        public String[] toStringArray(SASFormat format, boolean includeMissing, boolean update) {
            SASFormat fmt;
            SASFormat sASFormat = fmt = format != null ? format : defaultFormat;
            if (update || this.classes == null || includeMissing != this.includeMissing) {
                this.classes = new String[this.values.length];
                HashMap<Double, String> hm = new HashMap<Double, String>();
                String formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim();
                if (formattedMiss == null || formattedMiss.equals(".")) {
                    formattedMiss = StatGraph.missingOption;
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] != this.values[i]) {
                        if (includeMissing) {
                            this.classes[i] = formattedMiss;
                            continue;
                        }
                        this.classes[i] = null;
                        continue;
                    }
                    Double dv = new Double(this.values[i]);
                    if (hm != null && hm.containsKey(dv)) {
                        this.classes[i] = (String)hm.get(dv);
                        continue;
                    }
                    this.classes[i] = fmt.format((Object)dv).trim();
                    if (hm == null) continue;
                    if (hm.size() < 25) {
                        hm.put(dv, this.classes[i]);
                        continue;
                    }
                    hm = null;
                }
                this.includeMissing = includeMissing;
            }
            return this.classes;
        }
    }

    public static class StringArray {
        public String[] values;
        private String[] classes;
        private int nobs;
        private boolean includeMissing = false;

        public StringArray(int size, int nobs) {
            this.nobs = nobs;
            this.values = new String[size];
        }

        public StringArray(String[] values) {
            this.nobs = values.length;
            this.values = values;
        }

        public String[] toStringArray(SASFormat format) {
            return this.toStringArray(format, false, false);
        }

        public String[] toStringArray(SASFormat format, boolean includeMissing) {
            return this.toStringArray(format, includeMissing, false);
        }

        public String[] toStringArray(SASFormat format, boolean includeMissing, boolean update) {
            if (update || this.classes == null || includeMissing != this.includeMissing) {
                this.classes = new String[this.values.length];
                HashMap<String, String> hm = null;
                String formattedMiss = null;
                if (format != null) {
                    formattedMiss = format.format((Object)" ").trim();
                    if (formattedMiss == null || formattedMiss.length() == 0) {
                        formattedMiss = StatGraph.missingCharacter;
                    }
                    hm = new HashMap<String, String>();
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == null || this.values[i].length() == 0) {
                        if (includeMissing) {
                            if (format == null) {
                                this.classes[i] = StatGraph.missingCharacter;
                                continue;
                            }
                            this.classes[i] = formattedMiss;
                            continue;
                        }
                        this.classes[i] = null;
                        continue;
                    }
                    if (format != null) {
                        if (hm != null && hm.containsKey(this.values[i])) {
                            this.classes[i] = (String)hm.get(this.values[i]);
                            continue;
                        }
                        this.classes[i] = format.format((Object)this.values[i]);
                        if (hm == null) continue;
                        if (hm.size() < 25) {
                            hm.put(this.values[i], this.classes[i]);
                            continue;
                        }
                        hm = null;
                        continue;
                    }
                    this.classes[i] = this.values[i];
                }
                this.includeMissing = includeMissing;
            }
            return this.classes;
        }
    }
}

