/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.data;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Vector;

public final class CRD {
    protected DataModel srcModel = null;
    protected RoleColumnMap srcMap;
    protected int sortRole = -1;
    public String[] allWhereExpressions = null;
    public String whereExpression = null;
    public StringVariable[] whereVars = null;
    public boolean whereVarsOnSeparateModel = false;
    public boolean whereIncludeMissingClass = true;
    public int[] subsetObs = null;
    public int subsetObsCount;

    public int getSortRole() {
        return this.sortRole;
    }

    public void setSortRole(int role) {
        this.sortRole = role;
    }

    public DataModel getSrcModel() {
        return this.srcModel;
    }

    public void setSrcModel(DataModel aSrcModel) {
        this.srcModel = aSrcModel;
    }

    public OLAPDataSetInterface getOLAPData() {
        return this.srcModel.getOLAPData();
    }

    public OLAPVariableFactory getOLAPVarFactory() {
        return this.srcModel.getOLAPVarFactory();
    }

    public RoleColumnMap getSrcMap() {
        return this.srcMap;
    }

    public void setSrcMap(RoleColumnMap aSrcMap) {
        this.srcMap = aSrcMap;
    }

    public int getRowCount() {
        return this.srcModel.getRowCount();
    }

    public int getColumnCount() {
        return 3000;
    }

    public boolean isAvailable(int role) {
        if (this.srcModel == null) {
            return false;
        }
        return this.srcMap.isRoleMapped(role);
    }

    protected int crdcol2srccol(int col) {
        if (col < 3000) {
            return this.srcMap.getColumn(col);
        }
        return -1;
    }

    public void setColumnLabel(int col, Object label) {
        int mapcol = this.crdcol2srccol(col);
        if (mapcol == -1) {
            return;
        }
        this.srcModel.setColumnLabel(mapcol, label);
    }

    public Object getColumnLabel(int col) {
        int mapcol = this.crdcol2srccol(col);
        if (mapcol == -1) {
            return "";
        }
        return this.srcModel.getColumnLabel(mapcol);
    }

    public Class getColumnClass(int col) {
        int mapcol = this.crdcol2srccol(col);
        if (mapcol == -1) {
            return Double.class;
        }
        return this.srcModel.getColumnClass(mapcol);
    }

    public SASFormat getColumnFormat(short role) {
        int mapcol = this.crdcol2srccol(role);
        if (mapcol == -1) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.srcModel.getColumnLabel(mapcol);
        return cmd.getFormat();
    }

    public double getColumnMin(short role) {
        int mapcol = this.crdcol2srccol(role);
        if (mapcol == -1) {
            return Double.MAX_VALUE;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.srcModel.getColumnLabel(mapcol);
        return cmd.getMin();
    }

    public double getColumnMax(short role) {
        int mapcol = this.crdcol2srccol(role);
        if (mapcol == -1) {
            return -1.7976931348623157E308;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.srcModel.getColumnLabel(mapcol);
        return cmd.getMax();
    }

    public String getColumnName(short role) {
        if (StatGraph.isOLAP()) {
            return this.srcMap.getOLAPRole(role);
        }
        int mapcol = this.crdcol2srccol(role);
        if (mapcol == -1) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.srcModel.getColumnLabel(mapcol);
        return cmd.getName();
    }

    public double[] getDoubleColumn(int role) {
        return this.srcModel.getDoubleColumn(this.crdcol2srccol(role));
    }

    public String[] getDoubleAsClassColumn(int role) {
        int col = this.crdcol2srccol(role);
        return this.srcModel.getDoubleAsClassColumn(col);
    }

    public String[] getDoubleAsClassColumn(int role, boolean includeMissing) {
        int col = this.crdcol2srccol(role);
        return this.srcModel.getDoubleAsClassColumn(col, includeMissing);
    }

    public String[] getStringColumn(int role) {
        return this.srcModel.getStringColumn(this.crdcol2srccol(role));
    }

    public String[] getStringAsClassColumn(int role) {
        return this.srcModel.getStringAsClassColumn(this.crdcol2srccol(role));
    }

    public String[] getStringAsClassColumn(int role, boolean includeMissing) {
        return this.srcModel.getStringAsClassColumn(this.crdcol2srccol(role), includeMissing);
    }

    public int getMaxStringLength(int role) {
        int maxLen = 0;
        String[] values = this.getStringColumn(role);
        if (values == null || values.length == 0) {
            return 0;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            maxLen = Math.max(maxLen, values[i].length());
        }
        return maxLen;
    }

    public int getColumn(short role) {
        return this.crdcol2srccol(role);
    }

    public void sortByRole(short role) {
        DataModel old_dm = this.getSrcModel();
        DataModel dm = new DataModel();
        int obs = old_dm.getRowCount();
        int cols = old_dm.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            Object[] newVals;
            Object[] oldVals;
            ColumnMetadata cmd = (ColumnMetadata)old_dm.getColumnLabel(c);
            if (cmd.getType() == 1) {
                oldVals = old_dm.getDoubleColumn(c);
                newVals = new double[obs];
                System.arraycopy(oldVals, 0, newVals, 0, obs);
                dm.addDoubleColumn(cmd.getName(), cmd.getLabel(), cmd.getFormat() == null ? null : cmd.getFormat().getName(), cmd.getMin(), cmd.getMax(), cmd.getMissings(), (double[])newVals);
                continue;
            }
            oldVals = old_dm.getStringColumn(c);
            newVals = new String[obs];
            System.arraycopy(oldVals, 0, newVals, 0, obs);
            dm.addStringColumn(cmd.getName(), cmd.getLabel(), cmd.getFormat() == null ? null : cmd.getFormat().getName(), cmd.getLength(), cmd.getMissings(), (String[])newVals);
        }
        this.setSrcModel(dm);
        boolean numeric = this.getColumnClass(role) == Double.class;
        double[] sortDVals = numeric ? this.getDoubleColumn(role) : null;
        String[] sortSVals = numeric ? null : this.getStringAsClassColumn(role);
        for (int i = 0; i < obs; ++i) {
            for (int j = 0; j < obs - 1 - i; ++j) {
                boolean swapping;
                if (numeric && sortDVals[j] != sortDVals[j] || !numeric && sortSVals[j] == null) continue;
                if (numeric) {
                    swapping = sortDVals[j + 1] != sortDVals[j + 1] || sortDVals[j + 1] < sortDVals[j];
                } else {
                    boolean bl = swapping = sortSVals[j + 1] == null || sortSVals[j].compareTo(sortSVals[j + 1]) > 0;
                }
                if (!swapping) continue;
                for (int c = 0; c < dm.getColumnCount(); ++c) {
                    ColumnMetadata cmd = (ColumnMetadata)dm.getColumnLabel(c);
                    if (cmd.getType() == 1) {
                        double[] dVals = dm.getDoubleColumn(c);
                        double swapDouble = dVals[j];
                        dVals[j] = dVals[j + 1];
                        dVals[j + 1] = swapDouble;
                        continue;
                    }
                    String[] sVals = dm.getStringColumn(c);
                    String swapString = sVals[j];
                    sVals[j] = sVals[j + 1];
                    sVals[j + 1] = swapString;
                }
            }
        }
    }

    public void sortByRoles(short[] roles, int[] orders) {
        int i;
        int i2;
        if (roles == null || orders == null || roles.length != orders.length) {
            return;
        }
        DataModel old_dm = this.getSrcModel();
        DataModel dm = new DataModel();
        int obs = old_dm.getRowCount();
        int cols = old_dm.getColumnCount();
        RoleColumnMap map = this.getSrcMap();
        ArrayList<Integer> sortRoleColumns = new ArrayList<Integer>();
        int[] sortRoles = new int[roles.length];
        int[] sortTypes = new int[roles.length];
        int numSortRoles = 0;
        for (int i3 = 0; i3 < roles.length; ++i3) {
            int col;
            if (!map.isRoleMapped(roles[i3]) || (col = map.getColumn(roles[i3])) < 0 || col >= cols || sortRoleColumns.contains(col)) continue;
            sortRoleColumns.add(col);
            sortRoles[numSortRoles] = roles[i3];
            sortTypes[numSortRoles] = orders[i3];
            ++numSortRoles;
        }
        ArrayList<Variable> allVars = new ArrayList<Variable>();
        int[] sortVarIndex = new int[numSortRoles];
        int[] varSortOrder = new int[numSortRoles];
        int[] columnOld2New = new int[cols];
        int nCol = 0;
        for (i2 = 0; i2 < cols; ++i2) {
            NumericVectorVariable outVar;
            if (!map.isColumnMapped(i2)) continue;
            if (sortRoleColumns.contains(i2)) {
                boolean numeric;
                int sortIdx = sortRoleColumns.indexOf(i2);
                int role = sortRoles[sortIdx];
                boolean bl = numeric = this.getColumnClass(role) == Double.class;
                if (numeric) {
                    outVar = new NumericVectorVariable();
                    outVar.connectFrom(this.getDoubleColumn(role));
                } else {
                    outVar = new StringVectorVariable();
                    ((StringVectorVariable)outVar).connectFrom(this.getStringColumn(role));
                }
                sortVarIndex[numSortRoles - 1 - sortIdx] = nCol;
                varSortOrder[numSortRoles - 1 - sortIdx] = sortTypes[sortIdx];
            } else {
                ColumnMetadata cmd = (ColumnMetadata)old_dm.getColumnLabel(i2);
                if (cmd.getType() == 1) {
                    outVar = new NumericVectorVariable();
                    outVar.connectFrom(old_dm.getDoubleColumn(i2));
                } else {
                    outVar = new StringVectorVariable();
                    ((StringVectorVariable)outVar).connectFrom(old_dm.getStringColumn(i2));
                }
            }
            allVars.add((Variable)outVar);
            columnOld2New[i2] = nCol++;
        }
        if (this.whereExpression != null) {
            for (i2 = 0; i2 < this.whereVars.length; ++i2) {
                if (this.whereVars[i2] == null) continue;
                int wcol = old_dm.getColumn(this.whereVars[i2].getName());
                StringVectorVariable sv = new StringVectorVariable();
                sv.setName(this.whereVars[i2].getName());
                sv.connectFrom(old_dm.getColumnAsClassColumn(wcol));
                allVars.add((Variable)sv);
            }
        }
        ArrayList<Variable> sortedVars = Overlay.sortVariables(allVars, sortVarIndex, varSortOrder);
        if (this.whereExpression != null) {
            for (i = 0; i < this.whereVars.length; ++i) {
                if (this.whereVars[i] == null) continue;
                this.whereVars[i] = (StringVariable)sortedVars.get(nCol);
                ++nCol;
            }
        }
        for (i = 0; i < cols; ++i) {
            int n;
            Object[] newVals;
            if (!map.isColumnMapped(i)) continue;
            ColumnMetadata cmd = (ColumnMetadata)old_dm.getColumnLabel(i);
            int c = columnOld2New[i];
            if (cmd.getType() == 1) {
                NumericVariable nv = (NumericVariable)sortedVars.get(c);
                newVals = new double[obs];
                for (n = 0; n < obs; ++n) {
                    try {
                        newVals[n] = nv.value.getValue(n);
                        continue;
                    }
                    catch (MissingValueException e) {
                        newVals[n] = Double.NaN;
                    }
                }
                dm.addDoubleColumn(cmd.getName(), cmd.getLabel(), cmd.getFormat() == null ? null : cmd.getFormat().getName(), cmd.getMin(), cmd.getMax(), cmd.getMissings(), (double[])newVals);
                continue;
            }
            StringVariable sv = (StringVariable)sortedVars.get(c);
            newVals = new String[obs];
            for (n = 0; n < obs; ++n) {
                try {
                    newVals[n] = (double)sv.value.getValue(n);
                    continue;
                }
                catch (MissingValueException e) {
                    newVals[n] = (double)null;
                }
            }
            dm.addStringColumn(cmd.getName(), cmd.getLabel(), cmd.getFormat() == null ? null : cmd.getFormat().getName(), cmd.getLength(), cmd.getMissings(), (String[])newVals);
        }
        Vector columnList = map.getColumnList();
        for (int i4 = 0; i4 < columnList.size(); ++i4) {
            if (columnList.get(i4) == null) continue;
            int old_c = (Integer)columnList.get(i4);
            int new_c = columnOld2New[old_c];
            map.map(i4, new_c);
        }
        this.setSrcModel(dm);
    }
}

