/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class StyledLineBorder
extends AbstractBorder {
    private LineAttrs lineStyle;
    private BasicStroke stroke;
    private static Border blackLine;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new StyledLineBorder(Color.black);
        }
        return blackLine;
    }

    public StyledLineBorder(Color color) {
        this(color, 1, 1);
    }

    public StyledLineBorder(Color color, int thickness) {
        this(color, 1, thickness);
    }

    public StyledLineBorder(Color color, int style, int thickness) {
        this.lineStyle = new LineAttrs(style);
        this.lineStyle.setColor(color);
        this.lineStyle.setWidth(thickness);
        this.stroke = StatGraph.getStroke(style, thickness);
    }

    public StyledLineBorder(LineAttrs aStyle) {
        this.lineStyle = aStyle;
        this.stroke = StatGraph.getStroke(this.lineStyle.getLinePattern(), this.lineStyle.getWidth());
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.lineStyle.getWidth() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setColor(this.lineStyle.getColor());
        g2d.setStroke(this.stroke);
        int thickness = this.lineStyle.getWidth();
        g2d.drawRect(x + thickness / 2, y + thickness / 2, width - thickness, height - thickness);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int thickness = this.lineStyle.getWidth();
        return new Insets(thickness, thickness, thickness, thickness);
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }
}

