/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayDimension;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.AxisSet;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

public class SimpleExtrudedOverlayComposite
extends Simple2DOverlayComposite
implements MarginInterface {
    protected double zOffsetMin = 0.0;
    protected double zOffsetMax = 0.0;
    private int depth;
    protected boolean fastRender = false;
    private NetworkRoot networkRoot;
    private AxisSet axisSet;
    private Grid floorGrid;
    private Grid backGrid;
    private Grid sideGrid;
    private Grid floorGrid2;
    private Grid backGrid2;
    private Grid sideGrid2;
    private Wall sideWall;
    private Wall floor;
    private double[] view;
    private double extrusionDepth = 100.0 * StatGraph.dataDPIScaleFactor;

    public void setFastRender(boolean b) {
        this.fastRender = b;
    }

    public boolean isFastRender() {
        return this.fastRender;
    }

    public void setSideWall(Wall side) {
        this.sideWall = side;
    }

    public Wall getSideWall() {
        return this.sideWall;
    }

    public void setFloor(Wall floor) {
        this.floor = floor;
    }

    public Wall getFloor() {
        return this.floor;
    }

    @Override
    public synchronized void setEncoders() {
        if (this.axisSet == null) {
            this.networkRoot = new NetworkRoot(this.channel);
            this.axisSet = new AxisSet((ANetworkRoot)this.networkRoot);
            this.axisSet.setProjection(2);
            this.axisSet.setDisplayZAxis(true);
            this.axisSet.setupLighting();
            this.axisSet.setFitScreen(true);
        }
        boolean hasXAxis = false;
        boolean hasYAxis = false;
        NumericMap xMap = null;
        NumericMap yMap = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            PositionEncoder pe;
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            boolean primary = ((VRectAxis)a).getPrimary();
            DataRange range = a.getDataRange(dim);
            Encoder currEncoder = a.getEncoder(a.getDimension());
            if (currEncoder instanceof PositionEncoder) {
                pe = (PositionEncoder)currEncoder;
                pe.setRange(range);
            } else {
                pe = new PositionEncoder(range);
            }
            pe.setReversed(a.isReverse());
            switch (a.getType()) {
                case 1: {
                    pe.setType(1);
                    break;
                }
                case 5: {
                    pe.setType(2);
                    break;
                }
                case 6: {
                    if (a.getTickValueOrder() == 1) {
                        pe.setOrder(1);
                        break;
                    }
                    if (a.getTickValueOrder() == 2) {
                        pe.setOrder(2);
                        break;
                    }
                    pe.setOrder(0);
                    break;
                }
            }
            RectangularAxis vtkAxis = null;
            if (((VRectAxis)a).getVTKAxis() == null) {
                NumericMap map = (NumericMap)pe.getValueMap();
                if (dim == 1) {
                    if (primary) {
                        vtkAxis = this.axisSet.newXAxis(map);
                        hasXAxis = true;
                    } else {
                        vtkAxis = this.axisSet.newX2Axis(map);
                        xMap = map;
                    }
                } else if (dim == 2) {
                    if (primary) {
                        vtkAxis = this.axisSet.newYAxis(map);
                        hasYAxis = true;
                    } else {
                        vtkAxis = this.axisSet.newY2Axis(map);
                        yMap = map;
                    }
                } else if (dim == 3) {
                    vtkAxis = this.axisSet.newZAxis(map);
                }
                ((VRectAxis)a).setVTKAxis(vtkAxis);
                if (a.isVisible()) {
                    this.axisSet.getNetworkRoot().addElement((Element)vtkAxis);
                }
            }
            a.setEncoder(a.getDimension(), pe);
            Vector odv = (Vector)this.A2ODV.get(a);
            if (odv == null) continue;
            byte d = 0;
            for (int j = 0; j < odv.size(); ++j) {
                OverlayDimension od = (OverlayDimension)odv.elementAt(j);
                Overlay o = od.getOverlay();
                d = od.getDimension();
                o.setEncoder(d, pe);
            }
        }
        if (!hasXAxis && xMap != null) {
            RectangularAxis i = this.axisSet.newXAxis(xMap);
        }
        if (!hasYAxis && yMap != null) {
            RectangularAxis i = this.axisSet.newYAxis(yMap);
        }
        if (this.wall.isVisible() || this.isGridLineVisible()) {
            NumericMap xmap = null;
            NumericMap ymap = null;
            NumericMap zmap = null;
            NumericMap xmap2 = null;
            NumericMap ymap2 = null;
            LineAttrs xGrid = null;
            LineAttrs yGrid = null;
            LineAttrs zGrid = null;
            boolean xVis = false;
            boolean yVis = false;
            boolean zVis = false;
            LineAttrs xGrid2 = null;
            LineAttrs yGrid2 = null;
            boolean xVis2 = false;
            boolean yVis2 = false;
            for (int i = 0; i < this.axes.size(); ++i) {
                VRectAxis a = (VRectAxis)this.axes.get(i);
                PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
                if (a.getDimension() == 1) {
                    if (a.getPrimary()) {
                        xmap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                        xGrid = a.getGridStyle();
                        xVis = a.isGridVisible();
                        continue;
                    }
                    xmap2 = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                    xGrid2 = a.getGridStyle();
                    xVis2 = a.isGridVisible();
                    continue;
                }
                if (a.getDimension() == 2) {
                    if (a.getPrimary()) {
                        ymap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                        yGrid = a.getGridStyle();
                        yVis = a.isGridVisible();
                        continue;
                    }
                    ymap2 = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                    yGrid2 = a.getGridStyle();
                    yVis2 = a.isGridVisible();
                    continue;
                }
                if (a.getDimension() != 3) continue;
                zmap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                zGrid = a.getGridStyle();
                zVis = a.isGridVisible();
            }
            if (this.sideGrid == null) {
                this.sideGrid = this.axisSet.newSideGrid(ymap, zmap);
                this.sideGrid.getStyle().setLinkedLineAttributes(false);
                this.sideGrid.getStyle().setBackgroundOn(this.sideWall.isFillOn());
                this.sideGrid.getStyle().setBorderOn(this.sideWall.isEdgeOn());
                this.sideGrid.getStyle().getBorderLineStyle().setColor(this.sideWall.getEdgeStyle().getColor());
                this.sideGrid.getStyle().getBorderLineStyle().setWidth(this.sideWall.getEdgeStyle().getWidth());
                this.sideGrid.getStyle().getBorderLineStyle().setStippleFactor(this.sideWall.getEdgeStyle().getStippleFactor());
                this.sideGrid.getStyle().getBorderLineStyle().setStipplePattern(this.sideWall.getEdgeStyle().getStipplePattern());
                this.sideGrid.getStyle().setBackgroundColor(Overlay.applyTransparency(this.sideWall.getFillStyle().getColor(), this.sideWall.getFillStyle().getTransparency()));
                this.sideGrid.getStyle().getHorizontalMajorLineStyle().setVisible(yVis);
                if (yGrid != null) {
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setColor(yGrid.getColor());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid.getWidth());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid.getStippleFactor());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid.getStipplePattern());
                }
                this.sideGrid.getStyle().getVerticalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setColor(zGrid.getColor());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.sideGrid);
            }
            if (yVis2 && this.sideGrid2 == null) {
                this.sideGrid2 = this.axisSet.newSideGrid2(ymap2, zmap);
                this.sideGrid2.getStyle().setLinkedLineAttributes(false);
                this.sideGrid2.getStyle().setBackgroundOn(false);
                this.sideGrid2.getStyle().setBorderOn(false);
                this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setVisible(yVis2);
                if (yGrid2 != null) {
                    this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setColor(yGrid2.getColor());
                    this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid2.getWidth());
                    this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid2.getStippleFactor());
                    this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid2.getStipplePattern());
                }
                this.sideGrid2.getStyle().getVerticalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.sideGrid2.getStyle().getVerticalMajorLineStyle().setColor(zGrid.getColor());
                    this.sideGrid2.getStyle().getVerticalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.sideGrid2.getStyle().getVerticalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.sideGrid2.getStyle().getVerticalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.sideGrid2);
            }
            if (this.floorGrid == null) {
                this.floorGrid = this.axisSet.newFloorGrid(zmap, xmap);
                this.floorGrid.getStyle().setLinkedLineAttributes(false);
                this.floorGrid.getStyle().setBackgroundOn(this.floor.isFillOn());
                this.floorGrid.getStyle().setBorderOn(this.floor.isEdgeOn());
                this.floorGrid.getStyle().getBorderLineStyle().setColor(this.floor.getEdgeStyle().getColor());
                this.floorGrid.getStyle().getBorderLineStyle().setWidth(this.floor.getEdgeStyle().getWidth());
                this.floorGrid.getStyle().getBorderLineStyle().setStippleFactor(this.floor.getEdgeStyle().getStippleFactor());
                this.floorGrid.getStyle().getBorderLineStyle().setStipplePattern(this.floor.getEdgeStyle().getStipplePattern());
                this.floorGrid.getStyle().setBackgroundColor(Overlay.applyTransparency(this.floor.getFillStyle().getColor(), this.floor.getFillStyle().getTransparency()));
                this.floorGrid.getStyle().getHorizontalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setColor(zGrid.getColor());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.floorGrid.getStyle().getVerticalMajorLineStyle().setVisible(xVis);
                if (xGrid != null) {
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setColor(xGrid.getColor());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setWidth(xGrid.getWidth());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid.getStippleFactor());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.floorGrid);
            }
            if (xVis2 && this.floorGrid2 == null) {
                this.floorGrid2 = this.axisSet.newFloorGrid2(zmap, xmap2);
                this.floorGrid2.getStyle().setLinkedLineAttributes(false);
                this.floorGrid2.getStyle().setBackgroundOn(false);
                this.floorGrid2.getStyle().setBorderOn(false);
                this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setColor(zGrid.getColor());
                    this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.floorGrid2.getStyle().getVerticalMajorLineStyle().setVisible(xVis2);
                if (xGrid2 != null) {
                    this.floorGrid2.getStyle().getVerticalMajorLineStyle().setColor(xGrid2.getColor());
                    this.floorGrid2.getStyle().getVerticalMajorLineStyle().setWidth(xGrid2.getWidth());
                    this.floorGrid2.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid2.getStippleFactor());
                    this.floorGrid2.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid2.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.floorGrid2);
            }
            if (this.backGrid == null) {
                this.backGrid = this.axisSet.newBackGrid(ymap, xmap);
                this.backGrid.getStyle().setLinkedLineAttributes(false);
                this.backGrid.getStyle().setBackgroundOn(this.wall.isFillOn());
                this.backGrid.getStyle().setBorderOn(this.wall.isEdgeOn());
                this.backGrid.getStyle().getBorderLineStyle().setColor(this.wall.getEdgeStyle().getColor());
                this.backGrid.getStyle().getBorderLineStyle().setWidth(this.wall.getEdgeStyle().getWidth());
                this.backGrid.getStyle().getBorderLineStyle().setStippleFactor(this.wall.getEdgeStyle().getStippleFactor());
                this.backGrid.getStyle().getBorderLineStyle().setStipplePattern(this.wall.getEdgeStyle().getStipplePattern());
                this.backGrid.getStyle().setBackgroundColor(Overlay.applyTransparency(this.wall.getFillStyle().getColor(), this.wall.getFillStyle().getTransparency()));
                this.backGrid.getStyle().getHorizontalMajorLineStyle().setVisible(yVis);
                if (yGrid != null) {
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setColor(yGrid.getColor());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid.getWidth());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid.getStippleFactor());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid.getStipplePattern());
                }
                this.backGrid.getStyle().getVerticalMajorLineStyle().setVisible(xVis);
                if (xGrid != null) {
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setColor(xGrid.getColor());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setWidth(xGrid.getWidth());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid.getStippleFactor());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.backGrid);
            }
            if ((xVis2 || yVis2) && this.backGrid2 == null) {
                this.backGrid2 = this.axisSet.newBackGrid2(ymap2, xmap2);
                this.backGrid2.getStyle().setLinkedLineAttributes(false);
                this.backGrid2.getStyle().setBackgroundOn(false);
                this.backGrid2.getStyle().setBorderOn(false);
                this.backGrid2.getStyle().getHorizontalMajorLineStyle().setVisible(yVis2);
                if (yGrid2 != null) {
                    this.backGrid2.getStyle().getHorizontalMajorLineStyle().setColor(yGrid2.getColor());
                    this.backGrid2.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid2.getWidth());
                    this.backGrid2.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid2.getStippleFactor());
                    this.backGrid2.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid2.getStipplePattern());
                }
                this.backGrid2.getStyle().getVerticalMajorLineStyle().setVisible(xVis2);
                if (xGrid2 != null) {
                    this.backGrid2.getStyle().getVerticalMajorLineStyle().setColor(xGrid2.getColor());
                    this.backGrid2.getStyle().getVerticalMajorLineStyle().setWidth(xGrid2.getWidth());
                    this.backGrid2.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid2.getStippleFactor());
                    this.backGrid2.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid2.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.backGrid2);
            }
        }
    }

    private boolean isGridLineVisible() {
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!a.isGridVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateEncoders() {
        int anum = this.axes.size();
        double outMin = 0.0;
        double outMax = 0.0;
        double lowerLim = 0.0;
        double upperLim = 0.0;
        double xSize = 1.0;
        double ySize = 1.0;
        double zSize = 1.0;
        double minStride = Double.MAX_VALUE;
        for (int i = 0; i < anum; ++i) {
            int n;
            DataRange dr;
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            boolean primary = ((VRectAxis)a).getPrimary();
            if (dim == 1) {
                if (primary) {
                    outMin = this.innerMargin.left;
                    outMax = this.innerRegion.width + this.innerMargin.left;
                    lowerLim = 0.0;
                    upperLim = outMax + (double)this.innerMargin.right;
                    xSize = upperLim - lowerLim;
                } else {
                    outMin = this.innerMargin2.left;
                    outMax = this.innerRegion2.width + this.innerMargin2.left;
                    lowerLim = 0.0;
                    upperLim = outMax + (double)this.innerMargin2.right;
                    xSize = upperLim - lowerLim;
                }
            } else if (dim == 2) {
                if (primary) {
                    outMin = this.innerMargin.bottom;
                    outMax = this.innerRegion.height + this.innerMargin.bottom;
                    lowerLim = 0.0;
                    upperLim = outMax + (double)this.innerMargin.top;
                    ySize = upperLim - lowerLim;
                } else {
                    outMin = this.innerMargin2.bottom;
                    outMax = this.innerRegion2.height + this.innerMargin2.bottom;
                    lowerLim = 0.0;
                    upperLim = outMax + (double)this.innerMargin2.top;
                    ySize = upperLim - lowerLim;
                }
            } else if (dim == 3) {
                outMin = this.zOffsetMax;
                outMax = (double)this.depth - this.zOffsetMin;
                lowerLim = 0.0;
                upperLim = this.depth;
                zSize = upperLim - lowerLim;
            }
            PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
            if (outMin != pe.getOutputMin() || outMax != pe.getOutputMax() || lowerLim != pe.getLowerLimit() || upperLim != pe.getUpperLimit()) {
                pe.setOutputMin(outMin);
                pe.setOutputMax(outMax);
                pe.setLowerLimit(lowerLim);
                pe.setUpperLimit(upperLim);
                a.setEncoder(a.getDimension(), pe);
                pe.getValueMap().init((AInitAction)new InitAction(null));
            }
            if ((dr = pe.getInput()) instanceof DiscreteRange && (n = ((DiscreteRange)dr).getValuesSize()) > 1) {
                double s = (pe.getOutputMax() - pe.getOutputMin()) / (double)(n - 1);
                minStride = Math.min(s, minStride);
            }
            ((VRectAxis)a).getVTKAxis().setLength(upperLim - lowerLim);
        }
        if (minStride != Double.MAX_VALUE) {
            this.extrusionDepth = minStride;
        }
        int onum = this.overlays.size();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            o.setExtrusionDepth(this.extrusionDepth);
        }
        zSize = this.extrusionDepth;
        this.axisSet.setSize(xSize, ySize, zSize);
        NumericProperty xOffset = null;
        NumericProperty yOffset = null;
        NumericProperty zOffset = null;
        NumericProperty x2Offset = null;
        NumericProperty y2Offset = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (a.getDimension() == 1) {
                if (a.getPrimary()) {
                    xOffset = a.getVTKAxis().labelOffset;
                    continue;
                }
                x2Offset = a.getVTKAxis().labelOffset;
                continue;
            }
            if (a.getDimension() == 2) {
                if (a.getPrimary()) {
                    yOffset = a.getVTKAxis().labelOffset;
                    continue;
                }
                y2Offset = a.getVTKAxis().labelOffset;
                continue;
            }
            if (a.getDimension() != 3) continue;
            zOffset = a.getVTKAxis().labelOffset;
        }
        if (this.backGrid != null) {
            if (yOffset != null) {
                this.backGrid.horizontalLineOffset.connectFrom(yOffset);
            }
            if (xOffset != null) {
                this.backGrid.verticalLineOffset.connectFrom(xOffset);
            }
        }
        if (this.sideGrid != null) {
            if (yOffset != null) {
                this.sideGrid.horizontalLineOffset.connectFrom(yOffset);
            }
            if (zOffset != null) {
                this.sideGrid.verticalLineOffset.connectFrom(zOffset);
            }
        }
        if (this.floorGrid != null) {
            if (zOffset != null) {
                this.floorGrid.horizontalLineOffset.connectFrom(zOffset);
            }
            if (xOffset != null) {
                this.floorGrid.verticalLineOffset.connectFrom((NumericPipe)xOffset);
            }
        }
        if (this.backGrid2 != null) {
            if (y2Offset != null) {
                this.backGrid2.horizontalLineOffset.connectFrom(y2Offset);
            }
            if (x2Offset != null) {
                this.backGrid2.verticalLineOffset.connectFrom((NumericPipe)x2Offset);
            }
        }
        if (this.sideGrid2 != null) {
            if (y2Offset != null) {
                this.sideGrid2.horizontalLineOffset.connectFrom((NumericPipe)y2Offset);
            }
            if (zOffset != null) {
                this.sideGrid2.verticalLineOffset.connectFrom((NumericPipe)zOffset);
            }
        }
        if (this.floorGrid2 != null) {
            if (zOffset != null) {
                this.floorGrid2.horizontalLineOffset.connectFrom((NumericPipe)zOffset);
            }
            if (x2Offset != null) {
                this.floorGrid2.verticalLineOffset.connectFrom((NumericPipe)x2Offset);
            }
        }
    }

    public Rectangle getFrontFaceOuterRegion() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = 0.0;
        d[1] = this.axisSet.getSize().y;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x;
        d[1] = 0.0;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    public Rectangle getBackFaceOuterRegion() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = 0.0;
        d[1] = this.axisSet.getSize().y;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x;
        d[1] = 0.0;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    public Rectangle getFrontFaceInnerRegion() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = this.innerMargin.left;
        d[1] = this.axisSet.getSize().y - (double)this.innerMargin.top;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x - (double)this.innerMargin.right;
        d[1] = this.innerMargin.bottom;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    public Rectangle getBackFaceInnerRegion() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = this.innerMargin.left;
        d[1] = this.axisSet.getSize().y - (double)this.innerMargin.top;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x - (double)this.innerMargin.right;
        d[1] = this.innerMargin.bottom;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    public Rectangle getFrontFaceInnerRegion2() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = this.innerMargin2.left;
        d[1] = this.axisSet.getSize().y - (double)this.innerMargin2.top;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x - (double)this.innerMargin2.right;
        d[1] = this.innerMargin2.bottom;
        d[2] = this.axisSet.getSize().z;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    public Rectangle getBackFaceInnerRegion2() {
        double[] d = new double[3];
        double[] ul = new double[3];
        double[] lr = new double[3];
        d[0] = this.innerMargin2.left;
        d[1] = this.axisSet.getSize().y - (double)this.innerMargin2.top;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, ul);
        d[0] = this.axisSet.getSize().x - (double)this.innerMargin2.right;
        d[1] = this.innerMargin2.bottom;
        d[2] = 0.0;
        this.networkRoot.getChannel().gluProject(d, lr);
        Rectangle or = new Rectangle();
        or.x = (int)(ul[0] + 0.5);
        or.y = (int)(ul[1] + 0.5);
        or.width = (int)(lr[0] - ul[0] + 1.0 + 0.5);
        or.height = (int)(lr[1] - ul[1] + 1.0 + 0.5);
        return or;
    }

    @Override
    protected void initLabeling(Graphics g) {
        int i;
        int left = Math.max(this.innerMargin.left, this.innerMargin2.left);
        int top = Math.max(this.innerMargin.top, this.innerMargin2.top);
        int bottom = Math.max(this.innerMargin.bottom, this.innerMargin2.bottom);
        int iw = Math.min(this.innerRegion.width, this.innerRegion2.width);
        int ih = Math.min(this.innerRegion.height, this.innerRegion2.height);
        for (i = 0; i < this.overlays.size(); ++i) {
            LineChartOverlay lineChart;
            Overlay ov = (Overlay)this.overlays.get(i);
            if (ov instanceof ScatterOverlay) {
                ScatterOverlay scat = (ScatterOverlay)ov;
                boolean needConnect = false;
                if (scat.isLabelVisible() && scat.isLabelCollisionAvoidance() || scat.isObstacle()) {
                    if (this.pmgr == null) {
                        this.pmgr = new PointLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), ih);
                    }
                    scat.setPointLabelLayout(new PointLabelLayout());
                    this.pmgr.addLayout(scat.getPointLabelLayout());
                    needConnect = true;
                }
                if (scat.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), new Rectangle(left, bottom, iw, ih));
                    }
                    CurveLabelLayout cl = new CurveLabelLayout();
                    cl.setLocation(scat.getCurveLabelLocation());
                    cl.setPosition(scat.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(scat.getCurveLabelStyle().getFont()));
                    scat.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                    needConnect = true;
                }
                if (scat.isPointCurveLabeled()) {
                    if (this.pcmgr == null) {
                        this.pcmgr = new PointLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), ih, true);
                    }
                    scat.setPointCurveLabelLayout(new PointLabelLayout());
                    this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                    needConnect = true;
                }
                if (!needConnect) continue;
                scat.connectNetwork();
                continue;
            }
            if (ov instanceof ReferenceLineOverlay) {
                ReferenceLineOverlay line = (ReferenceLineOverlay)ov;
                line.setClipRect(this.outerRegion);
                if (line.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), new Rectangle(left, bottom, iw, ih));
                    }
                    CurveLabelLayout cl = new CurveLabelLayout();
                    cl.setLocation(line.getCurveLabelLocation());
                    cl.setPosition(line.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(line.getLabelStyle().getFont()));
                    line.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                }
                if (!line.isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), ih);
                }
                line.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(line.getPointLabelLayout());
                continue;
            }
            if (ov instanceof BarOverlay) {
                BarOverlay bar = (BarOverlay)ov;
                if (!bar.isDataLabeled()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(0, 0, this.outerRegion.width, this.outerRegion.height), ih);
                }
                bar.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(bar.getPointLabelLayout());
                continue;
            }
            if (!(ov instanceof LineChartOverlay) || !(lineChart = (LineChartOverlay)ov).isVertexLabelOn()) continue;
            if (this.pmgr == null) {
                this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
            }
            lineChart.setPointLabelLayout(new PointLabelLayout());
            this.pmgr.addLayout(lineChart.getPointLabelLayout());
        }
        if (this.cmgr != null) {
            this.cmgr.xRotated = this.xCLOverlapped;
            this.cmgr.x2Rotated = this.x2CLOverlapped;
        }
        if (this.pcmgr != null) {
            this.pcmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pcmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pcmgr.setHLabelShiftDelta(0);
            this.pcmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            this.pcmgr.layoutReady = true;
        }
        if (this.pmgr != null) {
            this.pmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pmgr.setHLabelShiftDelta(this.hLabelShiftDelta);
            this.pmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            switch (this.showPointLabels) {
                default: {
                    break;
                }
                case 1: {
                    this.showAllPointLabels();
                    break;
                }
                case 2: {
                    this.hideAllPointLabels();
                    break;
                }
                case 3: {
                    for (i = 0; i < this.getOverlays().size(); ++i) {
                        Overlay plot = (Overlay)this.getOverlays().get(i);
                        if (plot.getInitialHideLabelObs() == null) continue;
                        plot.hidePointLabels(plot.getInitialHideLabelObs());
                    }
                }
            }
            this.pmgr.layoutReady = true;
        }
        this.labelingInited = true;
    }

    @Override
    public synchronized void drawParts(Graphics g) {
        Overlay o;
        int i;
        if (this.channel == null) {
            return;
        }
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (!this.labelingInited) {
            this.initLabeling(g);
        } else {
            this.updateLabelingBounds();
        }
        this.channel.glClear(2);
        boolean textAntialiased = this.channel.glIsEnabled(14);
        if (this.axisDisplayAntialiased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
        if (!this.fastRender) {
            this.channel.glDisable(4);
            this.networkRoot.draw(this.channel);
        } else {
            AbstractAxis a;
            boolean[] labelsOn = new boolean[this.axes.size()];
            Font[] titleFont = new Font[this.axes.size()];
            if (this.axesVisible) {
                for (int i2 = 0; i2 < this.axes.size(); ++i2) {
                    a = (AbstractAxis)this.axes.get(i2);
                    if (!a.isVisible()) continue;
                    AxisStyle as = a.getAxisStyle();
                    labelsOn[i2] = as.isLabelsOn();
                    titleFont[i2] = as.getTitleStyle().getFont();
                    as.setLabelsOn(false);
                    as.getTitleStyle().setFont(new Font("Lucida", titleFont[i2].getStyle(), titleFont[i2].getSize()));
                }
            }
            boolean side_vline = false;
            boolean side_hline = false;
            boolean side_wall = false;
            boolean back_vline = false;
            boolean back_hline = false;
            boolean back_wall = false;
            boolean floor_vline = false;
            boolean floor_hline = false;
            boolean floor_wall = false;
            if (this.sideGrid != null) {
                side_wall = this.sideGrid.getStyle().isBackgroundOn();
                side_hline = this.sideGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                side_vline = this.sideGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.sideGrid, false, false, false);
            }
            if (this.backGrid != null) {
                back_wall = this.backGrid.getStyle().isBackgroundOn();
                back_hline = this.backGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                back_vline = this.backGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.backGrid, false, false, false);
            }
            if (this.floorGrid != null) {
                floor_wall = this.floorGrid.getStyle().isBackgroundOn();
                floor_hline = this.floorGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                floor_vline = this.floorGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.floorGrid, false, false, false);
            }
            this.channel.glDisable(4);
            this.networkRoot.draw(this.channel);
            if (this.axesVisible) {
                for (int i3 = 0; i3 < this.axes.size(); ++i3) {
                    a = (AbstractAxis)this.axes.get(i3);
                    if (!a.isVisible()) continue;
                    AxisStyle as = a.getAxisStyle();
                    as.setLabelsOn(labelsOn[i3]);
                    as.getTitleStyle().setFont(titleFont[i3]);
                }
            }
            if (this.sideGrid != null) {
                this.setGridsVisible(this.sideGrid, side_wall, side_hline, side_vline);
            }
            if (this.backGrid != null) {
                this.setGridsVisible(this.backGrid, back_wall, back_hline, back_vline);
            }
            if (this.floorGrid != null) {
                this.setGridsVisible(this.floorGrid, floor_wall, floor_hline, floor_vline);
            }
        }
        this.channel.glEnable(4);
        int onum = this.overlays.size();
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || o.getOverlayPosition() != 1) continue;
            o.draw(g);
        }
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || o.getOverlayPosition() != 2) continue;
            o.draw(g);
        }
        this.channel.glPushMatrix();
        this.channel.glTranslate(0.0, 0.0, this.extrusionDepth);
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || o.getOverlayPosition() != 0) continue;
            o.draw(g);
        }
        this.channel.glPopMatrix();
        if (this.curveLabelsOn) {
            for (i = 0; i < onum; ++i) {
                o = (Overlay)this.overlays.get(i);
                if (!o.isVisible() || o.getOverlayPosition() != 1) continue;
                o.drawNoneClipped(g);
            }
            for (i = 0; i < onum; ++i) {
                o = (Overlay)this.overlays.get(i);
                if (!o.isVisible() || o.getOverlayPosition() != 2) continue;
                o.drawNoneClipped(g);
            }
            this.channel.glPushMatrix();
            this.channel.glTranslate(0.0, 0.0, this.extrusionDepth);
            for (i = 0; i < onum; ++i) {
                o = (Overlay)this.overlays.get(i);
                if (!o.isVisible() || o.getOverlayPosition() != 0) continue;
                o.drawNoneClipped(g);
            }
            this.channel.glPopMatrix();
        }
        if (textAntialiased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
    }

    @Override
    public void drawSelection(Graphics g) {
    }

    private void setGridsVisible(Grid grid, boolean wall, boolean hLine, boolean vLine) {
        if (grid != null) {
            grid.getStyle().setBackgroundOn(wall);
            grid.getStyle().getHorizontalMajorLineStyle().setVisible(hLine);
            grid.getStyle().getVerticalMajorLineStyle().setVisible(vLine);
        }
    }

    @Override
    public ProbeResult probe(Point p, Dimension d) {
        return null;
    }

    @Override
    protected void tryProbe(Overlay elem, Point p, Dimension d, Stack nameStack) {
    }

    @Override
    public ImageMap getImageMap() {
        return null;
    }

    protected void setView() {
        if (this.axisSet != null && this.view == null) {
            this.view = this.axisSet.getView();
        }
    }

    public Grid getSideGrid() {
        return this.sideGrid;
    }

    public Grid getBackGrid() {
        return this.backGrid;
    }

    public Grid getFloorGrid() {
        return this.floorGrid;
    }

    public void invalidateView() {
        this.view = null;
    }

    public AxisSet getAxisSet() {
        return this.axisSet;
    }
}

