/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayDimension;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BiVarHistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SurfaceOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.AxisSet;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.util.Stack;
import java.util.Vector;

public class Simple3DOverlayComposite
extends Simple2DOverlayComposite
implements MarginInterface {
    protected double zOffsetMin = 0.0;
    protected double zOffsetMax = 0.0;
    protected int depth;
    protected boolean fastRender = false;
    private NetworkRoot networkRoot;
    private NetworkRoot networkRoot2;
    protected AxisSet axisSet;
    private Grid floorGrid;
    private Grid backGrid;
    private Grid sideGrid;
    private Box wireBox;
    private double[] view;
    private Box tmpBox = null;

    public void setFastRender(boolean b) {
        this.fastRender = b;
    }

    public boolean isFastRender() {
        return this.fastRender;
    }

    @Override
    public synchronized void setEncoders() {
        if (this.axisSet == null) {
            this.networkRoot = new NetworkRoot(this.channel);
            this.axisSet = new AxisSet((ANetworkRoot)this.networkRoot);
            this.axisSet.setProjection(1);
            this.axisSet.setupLighting();
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            PositionEncoder pe;
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            DataRange range = a.getDataRange(dim);
            Encoder currEncoder = a.getEncoder(a.getDimension());
            if (currEncoder instanceof PositionEncoder) {
                pe = (PositionEncoder)currEncoder;
                pe.setRange(range);
            } else {
                pe = new PositionEncoder(range);
                if (dim == 3) {
                    pe.setReversed(true);
                }
            }
            switch (a.getType()) {
                case 1: {
                    pe.setType(1);
                    break;
                }
                case 5: {
                    pe.setType(2);
                    break;
                }
                case 6: {
                    if (a.getTickValueOrder() == 1) {
                        pe.setOrder(1);
                        break;
                    }
                    if (a.getTickValueOrder() == 2) {
                        pe.setOrder(2);
                        break;
                    }
                    pe.setOrder(0);
                    break;
                }
            }
            RectangularAxis vtkAxis = null;
            if (((VRectAxis)a).getVTKAxis() == null) {
                NumericMap map = (NumericMap)pe.getValueMap();
                if (dim == 1) {
                    vtkAxis = this.axisSet.newXAxis(map);
                } else if (dim == 2) {
                    vtkAxis = this.axisSet.newYAxis(map);
                } else if (dim == 3) {
                    vtkAxis = this.axisSet.newZAxis(map);
                }
                ((VRectAxis)a).setVTKAxis(vtkAxis);
                this.axisSet.getNetworkRoot().addElement((Element)vtkAxis);
            }
            a.setEncoder(a.getDimension(), pe);
            Vector odv = (Vector)this.A2ODV.get(a);
            if (odv == null) continue;
            byte d = 0;
            for (int j = 0; j < odv.size(); ++j) {
                OverlayDimension od = (OverlayDimension)odv.elementAt(j);
                Overlay o = od.getOverlay();
                d = od.getDimension();
                o.setEncoder(d, pe);
            }
        }
        if (this.wall.isVisible() || this.isGridLineVisible()) {
            NumericMap xmap = null;
            NumericMap ymap = null;
            NumericMap zmap = null;
            LineAttrs xGrid = null;
            LineAttrs yGrid = null;
            LineAttrs zGrid = null;
            boolean xVis = false;
            boolean yVis = false;
            boolean zVis = false;
            for (int i = 0; i < this.axes.size(); ++i) {
                VRectAxis a = (VRectAxis)this.axes.get(i);
                PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
                if (a.getDimension() == 1) {
                    xmap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                    xGrid = a.getGridStyle();
                    xVis = a.isGridVisible();
                    continue;
                }
                if (a.getDimension() == 2) {
                    ymap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                    yGrid = a.getGridStyle();
                    yVis = a.isGridVisible();
                    continue;
                }
                if (a.getDimension() != 3) continue;
                zmap = pe.getAxisLabelMap() != null ? (NumericMap)pe.getAxisLabelMap() : (NumericMap)pe.getValueMap();
                zGrid = a.getGridStyle();
                zVis = a.isGridVisible();
            }
            if (this.sideGrid == null) {
                this.sideGrid = this.axisSet.newSideGrid(ymap, zmap);
                this.sideGrid.getStyle().setLinkedLineAttributes(false);
                this.sideGrid.getStyle().setBackgroundOn(this.wall.isFillOn());
                this.sideGrid.getStyle().setBorderOn(this.wall.isEdgeOn());
                this.sideGrid.getStyle().getBorderLineStyle().setColor(this.wall.getEdgeStyle().getColor());
                this.sideGrid.getStyle().getBorderLineStyle().setWidth(this.wall.getEdgeStyle().getWidth());
                this.sideGrid.getStyle().getBorderLineStyle().setStippleFactor(this.wall.getEdgeStyle().getStippleFactor());
                this.sideGrid.getStyle().getBorderLineStyle().setStipplePattern(this.wall.getEdgeStyle().getStipplePattern());
                this.sideGrid.getStyle().setBackgroundColor(this.wall.getFillStyle().getColor());
                this.sideGrid.getStyle().getHorizontalMajorLineStyle().setVisible(yVis);
                if (yGrid != null) {
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setColor(yGrid.getColor());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid.getWidth());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid.getStippleFactor());
                    this.sideGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid.getStipplePattern());
                }
                this.sideGrid.getStyle().getVerticalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setColor(zGrid.getColor());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.sideGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.sideGrid);
            }
            if (this.floorGrid == null) {
                this.floorGrid = this.axisSet.newFloorGrid(zmap, xmap);
                this.floorGrid.getStyle().setLinkedLineAttributes(false);
                this.floorGrid.getStyle().setBackgroundOn(this.wall.isFillOn());
                this.floorGrid.getStyle().setBorderOn(this.wall.isEdgeOn());
                this.floorGrid.getStyle().getBorderLineStyle().setColor(this.wall.getEdgeStyle().getColor());
                this.floorGrid.getStyle().getBorderLineStyle().setWidth(this.wall.getEdgeStyle().getWidth());
                this.floorGrid.getStyle().getBorderLineStyle().setStippleFactor(this.wall.getEdgeStyle().getStippleFactor());
                this.floorGrid.getStyle().getBorderLineStyle().setStipplePattern(this.wall.getEdgeStyle().getStipplePattern());
                this.floorGrid.getStyle().setBackgroundColor(this.wall.getFillStyle().getColor());
                this.floorGrid.getStyle().getHorizontalMajorLineStyle().setVisible(zVis);
                if (zGrid != null) {
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setColor(zGrid.getColor());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setWidth(zGrid.getWidth());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(zGrid.getStippleFactor());
                    this.floorGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(zGrid.getStipplePattern());
                }
                this.floorGrid.getStyle().getVerticalMajorLineStyle().setVisible(xVis);
                if (xGrid != null) {
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setColor(xGrid.getColor());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setWidth(xGrid.getWidth());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid.getStippleFactor());
                    this.floorGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.floorGrid);
            }
            if (this.backGrid == null) {
                this.backGrid = this.axisSet.newBackGrid(ymap, xmap);
                this.backGrid.getStyle().setLinkedLineAttributes(false);
                this.backGrid.getStyle().setBackgroundOn(this.wall.isFillOn());
                this.backGrid.getStyle().setBorderOn(this.wall.isEdgeOn());
                this.backGrid.getStyle().getBorderLineStyle().setColor(this.wall.getEdgeStyle().getColor());
                this.backGrid.getStyle().getBorderLineStyle().setWidth(this.wall.getEdgeStyle().getWidth());
                this.backGrid.getStyle().getBorderLineStyle().setStippleFactor(this.wall.getEdgeStyle().getStippleFactor());
                this.backGrid.getStyle().getBorderLineStyle().setStipplePattern(this.wall.getEdgeStyle().getStipplePattern());
                this.backGrid.getStyle().setBackgroundColor(this.wall.getFillStyle().getColor());
                this.backGrid.getStyle().getHorizontalMajorLineStyle().setVisible(yVis);
                if (yGrid != null) {
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setColor(yGrid.getColor());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setWidth(yGrid.getWidth());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setStippleFactor(yGrid.getStippleFactor());
                    this.backGrid.getStyle().getHorizontalMajorLineStyle().setStipplePattern(yGrid.getStipplePattern());
                }
                this.backGrid.getStyle().getVerticalMajorLineStyle().setVisible(xVis);
                if (xGrid != null) {
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setColor(xGrid.getColor());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setWidth(xGrid.getWidth());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setStippleFactor(xGrid.getStippleFactor());
                    this.backGrid.getStyle().getVerticalMajorLineStyle().setStipplePattern(xGrid.getStipplePattern());
                }
                this.networkRoot.addElement((Element)this.backGrid);
            }
        }
        if (this.wall.isCube() && this.wireBox == null) {
            this.wireBox = this.axisSet.newWireBox();
            LineAttrs edgeStyle = this.wall.getEdgeStyle();
            this.wireBox.color.setValue(edgeStyle.getColor());
            this.wireBox.edgePattern.setValue(edgeStyle.getLinePattern());
            this.wireBox.edgeWidth.setValue(edgeStyle.getWidth());
            this.networkRoot2 = new NetworkRoot(this.channel);
            this.networkRoot2.addElement((Element)this.wireBox);
        }
    }

    private boolean isGridLineVisible() {
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!a.isGridVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateEncoders() {
        int anum = this.axes.size();
        double outMin = 0.0;
        double outMax = 0.0;
        double lowerLim = 0.0;
        double upperLim = 0.0;
        double xSize = 1.0;
        double ySize = 1.0;
        double zSize = 1.0;
        boolean updateAxisLength = false;
        for (int i = 0; i < anum; ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1) {
                outMin = this.innerMargin.left;
                outMax = this.innerRegion.width + this.innerMargin.left;
                lowerLim = 0.0;
                upperLim = outMax + (double)this.innerMargin.right;
                xSize = upperLim - lowerLim;
                updateAxisLength = ((VRectAxis)a).getVTKAxis().getLength() != xSize;
            } else if (dim == 2) {
                outMin = this.innerMargin.bottom;
                outMax = this.innerRegion.height + this.innerMargin.bottom;
                lowerLim = 0.0;
                upperLim = outMax + (double)this.innerMargin.top;
                ySize = upperLim - lowerLim;
                updateAxisLength = ((VRectAxis)a).getVTKAxis().getLength() != ySize;
            } else if (dim == 3) {
                outMin = this.zOffsetMax;
                outMax = (double)this.depth - this.zOffsetMin;
                lowerLim = 0.0;
                upperLim = this.depth;
                zSize = upperLim - lowerLim;
                updateAxisLength = ((VRectAxis)a).getVTKAxis().getLength() != zSize;
            }
            PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
            if (outMin != pe.getOutputMin() || outMax != pe.getOutputMax() || lowerLim != pe.getLowerLimit() || upperLim != pe.getUpperLimit()) {
                pe.setOutputMin(outMin);
                pe.setOutputMax(outMax);
                pe.setLowerLimit(lowerLim);
                pe.setUpperLimit(upperLim);
                a.setEncoder(a.getDimension(), pe);
                pe.getValueMap().init((AInitAction)new InitAction(null));
            }
            if (!updateAxisLength) continue;
            ((VRectAxis)a).getVTKAxis().setLength(upperLim - lowerLim);
        }
        this.axisSet.setSize(xSize, ySize, zSize);
        NumericProperty xOffset = null;
        NumericProperty yOffset = null;
        NumericProperty zOffset = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (a.getDimension() == 1) {
                xOffset = a.getVTKAxis().labelOffset;
                continue;
            }
            if (a.getDimension() == 2) {
                yOffset = a.getVTKAxis().labelOffset;
                continue;
            }
            if (a.getDimension() != 3) continue;
            zOffset = a.getVTKAxis().labelOffset;
        }
        if (this.backGrid != null) {
            if (yOffset != null) {
                this.backGrid.horizontalLineOffset.connectFrom(yOffset);
            }
            if (xOffset != null) {
                this.backGrid.verticalLineOffset.connectFrom(xOffset);
            }
        }
        if (this.sideGrid != null) {
            if (yOffset != null) {
                this.sideGrid.horizontalLineOffset.connectFrom(yOffset);
            }
            if (zOffset != null) {
                this.sideGrid.verticalLineOffset.connectFrom(zOffset);
            }
        }
        if (this.floorGrid != null) {
            if (zOffset != null) {
                this.floorGrid.horizontalLineOffset.connectFrom(zOffset);
            }
            if (xOffset != null) {
                this.floorGrid.verticalLineOffset.connectFrom((NumericPipe)xOffset);
            }
        }
    }

    @Override
    public void updatePrefs() {
        int bottom;
        int left;
        double xOffSet = 0.0;
        double yOffSet = 0.0;
        double zOffset = 0.0;
        double offset = 0.0;
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            offset = o.getPreferredOffset((byte)1);
            if (offset > 0.0) {
                xOffSet = Math.max(xOffSet, Math.ceil(offset / 2.0));
            }
            if ((offset = o.getPreferredOffset((byte)2)) > 0.0) {
                yOffSet = Math.max(yOffSet, Math.ceil(offset / 2.0));
            }
            if (!((offset = o.getPreferredOffset((byte)3)) > 0.0)) continue;
            zOffset = Math.max(zOffset, Math.ceil(offset / 2.0));
        }
        this.zOffsetMin = Math.max(this.zOffsetMin, zOffset);
        this.zOffsetMax = Math.max(this.zOffsetMax, zOffset);
        int right = left = (int)Math.max(xOffSet, zOffset);
        int top = bottom = (int)yOffSet;
        double xStartOffset = Double.MAX_VALUE;
        double xEndOffset = Double.MAX_VALUE;
        double yStartOffset = Double.MAX_VALUE;
        double yEndOffset = Double.MAX_VALUE;
        double zStartOffset = Double.MAX_VALUE;
        double zEndOffset = Double.MAX_VALUE;
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1) {
                xStartOffset = Math.min(xStartOffset, a.getAbsStartOffset());
                xEndOffset = Math.min(xEndOffset, a.getAbsEndOffset());
                continue;
            }
            if (dim == 2) {
                yStartOffset = Math.min(yStartOffset, a.getAbsStartOffset());
                yEndOffset = Math.min(yEndOffset, a.getAbsEndOffset());
                continue;
            }
            if (dim != 3) continue;
            zStartOffset = Math.min(zStartOffset, a.getAbsStartOffset());
            zEndOffset = Math.min(zEndOffset, a.getAbsEndOffset());
        }
        if (xStartOffset >= 0.0 && xStartOffset != Double.MAX_VALUE) {
            left = (int)xStartOffset;
        }
        if (xEndOffset >= 0.0 && xEndOffset != Double.MAX_VALUE) {
            right = (int)xEndOffset;
        }
        if (yStartOffset >= 0.0 && yStartOffset != Double.MAX_VALUE) {
            bottom = (int)yStartOffset;
        }
        if (yEndOffset >= 0.0 && yEndOffset != Double.MAX_VALUE) {
            top = (int)yEndOffset;
        }
        if (zStartOffset >= 0.0 && zStartOffset != Double.MAX_VALUE) {
            this.zOffsetMin = zStartOffset;
        }
        if (zEndOffset >= 0.0 && zEndOffset != Double.MAX_VALUE) {
            this.zOffsetMax = zEndOffset;
        }
        this.setInnerMargin(new Insets(top, left, bottom, right));
    }

    @Override
    protected void updateRegions() {
        super.updateRegions();
        this.depth = Math.max(this.outerRegion.width, this.outerRegion.height);
    }

    @Override
    public synchronized void drawParts(Graphics g) {
        if (this.channel == null) {
            return;
        }
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (!this.visible) {
            return;
        }
        this.channel.glClear(2);
        boolean textAntialiased = this.channel.glIsEnabled(14);
        if (this.axisDisplayAntialiased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
        if (!this.fastRender) {
            this.channel.glDisable(4);
            this.networkRoot.draw(this.channel);
        } else {
            AbstractAxis a;
            boolean[] labelsOn = new boolean[this.axes.size()];
            Font[] titleFont = new Font[this.axes.size()];
            if (this.axesVisible) {
                for (int i = 0; i < this.axes.size(); ++i) {
                    a = (AbstractAxis)this.axes.get(i);
                    if (!a.isVisible()) continue;
                    AxisStyle as = a.getAxisStyle();
                    labelsOn[i] = as.isLabelsOn();
                    titleFont[i] = as.getTitleStyle().getFont();
                    as.setLabelsOn(false);
                    as.getTitleStyle().setFont(new Font("Lucida", titleFont[i].getStyle(), titleFont[i].getSize()));
                }
            }
            boolean side_vline = false;
            boolean side_hline = false;
            boolean side_wall = false;
            boolean back_vline = false;
            boolean back_hline = false;
            boolean back_wall = false;
            boolean floor_vline = false;
            boolean floor_hline = false;
            boolean floor_wall = false;
            if (this.sideGrid != null) {
                side_wall = this.sideGrid.getStyle().isBackgroundOn();
                side_hline = this.sideGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                side_vline = this.sideGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.sideGrid, false, false, false);
            }
            if (this.backGrid != null) {
                back_wall = this.backGrid.getStyle().isBackgroundOn();
                back_hline = this.backGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                back_vline = this.backGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.backGrid, false, false, false);
            }
            if (this.floorGrid != null) {
                floor_wall = this.floorGrid.getStyle().isBackgroundOn();
                floor_hline = this.floorGrid.getStyle().getHorizontalMajorLineStyle().isVisible();
                floor_vline = this.floorGrid.getStyle().getVerticalMajorLineStyle().isVisible();
                this.setGridsVisible(this.floorGrid, false, false, false);
            }
            this.channel.glDisable(4);
            this.networkRoot.draw(this.channel);
            if (this.axesVisible) {
                for (int i = 0; i < this.axes.size(); ++i) {
                    a = (AbstractAxis)this.axes.get(i);
                    if (!a.isVisible()) continue;
                    AxisStyle as = a.getAxisStyle();
                    as.setLabelsOn(labelsOn[i]);
                    as.getTitleStyle().setFont(titleFont[i]);
                }
            }
            if (this.sideGrid != null) {
                this.setGridsVisible(this.sideGrid, side_wall, side_hline, side_vline);
            }
            if (this.backGrid != null) {
                this.setGridsVisible(this.backGrid, back_wall, back_hline, back_vline);
            }
            if (this.floorGrid != null) {
                this.setGridsVisible(this.floorGrid, floor_wall, floor_hline, floor_vline);
            }
        }
        if (textAntialiased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
        this.channel.glEnable(4);
        int onum = this.overlays.size();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isVisible()) continue;
            if (o instanceof SurfaceOverlay) {
                SurfaceOverlay vs = (SurfaceOverlay)o;
                if (this.fastRender) {
                    vs.enableFastRender();
                } else {
                    vs.disableFastRender();
                }
            }
            boolean fillOn = true;
            boolean edgeOn = false;
            if (o instanceof BiVarHistogramOverlay) {
                BiVarHistogramOverlay bvh = (BiVarHistogramOverlay)o;
                fillOn = bvh.isFillOn();
                edgeOn = bvh.isEdgeOn();
                if (this.fastRender) {
                    bvh.setFillOn(false);
                    bvh.setEdgeOn(true);
                }
            }
            o.draw(g);
            if (!(o instanceof BiVarHistogramOverlay)) continue;
            BiVarHistogramOverlay bvh = (BiVarHistogramOverlay)o;
            bvh.setFillOn(fillOn);
            bvh.setEdgeOn(edgeOn);
        }
        if (this.wall.isCube()) {
            this.networkRoot2.draw(this.channel);
        }
    }

    @Override
    public void drawSelection(Graphics g) {
    }

    private void setGridsVisible(Grid grid, boolean wall, boolean hLine, boolean vLine) {
        if (grid != null) {
            grid.getStyle().setBackgroundOn(wall);
            grid.getStyle().getHorizontalMajorLineStyle().setVisible(hLine);
            grid.getStyle().getVerticalMajorLineStyle().setVisible(vLine);
        }
    }

    @Override
    public ProbeResult probe(Point p, Dimension d) {
        return null;
    }

    protected void tryProbe(Point p, Dimension d, Stack nameStack) {
    }

    @Override
    public ImageMap getImageMap() {
        return null;
    }

    protected void setView(double azimuth, double incline, double zoom) {
        if (this.axisSet != null) {
            this.axisSet.setZoom(zoom);
            if (this.view == null) {
                if (this.wireBox != null) {
                    this.networkRoot.addElement((Element)this.wireBox);
                }
                boolean addTmpBox = false;
                if (!this.wall.isVisible() && !this.isGridLineVisible() && this.wireBox == null) {
                    if (this.tmpBox == null) {
                        this.tmpBox = this.axisSet.newWireBox();
                    }
                    this.networkRoot.addElement((Element)this.tmpBox);
                    addTmpBox = true;
                }
                this.view = this.axisSet.getView(azimuth, incline);
                if (this.wireBox != null) {
                    this.networkRoot.removeElement((Element)this.wireBox);
                }
                if (addTmpBox) {
                    this.networkRoot.removeElement((Element)this.tmpBox);
                }
            }
            this.axisSet.setView(azimuth, incline, this.view[2]);
        }
    }

    public Grid getSideGrid() {
        return this.sideGrid;
    }

    public Grid getBackGrid() {
        return this.backGrid;
    }

    public Grid getFloorGrid() {
        return this.floorGrid;
    }

    public Box getWireBox() {
        return this.wireBox;
    }

    public void invalidateView() {
        this.view = null;
    }
}

