/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class RegionContainer
extends AbstractSGComponent {
    private RegionLayout layout = new RegionLayout();
    private double halign = 0.0;
    private double valign = 0.0;
    private double hsize = 1.0;
    private double vsize = 1.0;
    private String alignAnchor = "topleft";
    private float hanchor = 0.5f;
    private float vanchor = 0.5f;

    public RegionContainer() {
        this.setLayout(this.layout);
        this.setOpaque(false);
    }

    public void add(Component c, int index, String name) {
        this.layout.addLayoutComponent(name, c);
        if ("Inset".equalsIgnoreCase(name)) {
            if (this.getComponentCount() > 0) {
                Component[] comps = this.getComponents();
                this.removeAll();
                this.add(c, 0);
                for (int i = 0; i < comps.length; ++i) {
                    this.add(comps[i], i + 1);
                }
            } else {
                this.add(c, index);
            }
        } else {
            this.add(c, index);
        }
    }

    public void remove(Component c, String name) {
        this.layout.removeLayoutComponent(name, c);
        super.remove(c);
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, -1, "Plot");
        return comp;
    }

    public Component addLegend(Component c) {
        this.layout.addLayoutComponent("Legend", c);
        return super.add(c, 0);
    }

    public void removeLegend(Component c) {
        this.layout.removeLayoutComponent("Legend", c);
        super.remove(c);
    }

    public Component addSidebar(Component c) {
        this.layout.addLayoutComponent("Sidebar", c);
        return super.add(c, 0);
    }

    public void removeSidebar(Component c) {
        this.layout.removeLayoutComponent("Sidebar", c);
        super.remove(c);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public Insets getPreferredOuterMargin() {
        Insets borderInsets = this.getInsets();
        RegionLayout layout = (RegionLayout)this.getLayout();
        Insets si = layout.getSurroundingInsets();
        borderInsets.left += si.left;
        borderInsets.right += si.right;
        borderInsets.top += si.top;
        borderInsets.bottom += si.bottom;
        return borderInsets;
    }

    public double getHAlign() {
        return this.halign;
    }

    public void setHAlign(double halign) {
        this.halign = halign;
    }

    public double getVAlign() {
        return this.valign;
    }

    public void setVAlign(double valign) {
        this.valign = valign;
    }

    public double getHSize() {
        return this.hsize;
    }

    public void setHSize(double hsize) {
        this.hsize = hsize;
    }

    public double getVSize() {
        return this.vsize;
    }

    public void setVSize(double vsize) {
        this.vsize = vsize;
    }

    public String getAlignAnchor() {
        return this.alignAnchor;
    }

    public void setAlignAnchor(String alignAnchor) {
        this.alignAnchor = alignAnchor;
    }

    public float getHAnchor() {
        return this.hanchor;
    }

    public void setHAnchor(float hanchor) {
        this.hanchor = hanchor;
    }

    public float getVAnchor() {
        return this.vanchor;
    }

    public void setVAnchor(float vanchor) {
        this.vanchor = vanchor;
    }

    public Dimension getPreferredDataAreaSize() {
        Container parent = this.getParent();
        Dimension rs = parent.getSize();
        if (rs.width == 0 && rs.height == 0) {
            if (parent.getParent() != null) {
                rs = parent.getParent().getSize();
                rs.width = (int)((double)rs.width * 0.875);
                rs.height = (int)((double)rs.height * 0.875);
            }
            return rs;
        }
        Insets pi = parent.getInsets();
        rs.width -= pi.left + pi.right;
        rs.height -= pi.top + pi.bottom;
        return rs;
    }

    public String getLayoutComponentName(Component comp) {
        return this.layout.getLayoutComponentName(comp);
    }
}

