/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.CompositeComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.SimpleExtrudedOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellAlignmentInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.ler.LargestEmptyRectangle;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;

public class OverlayLayout
implements LayoutManager2 {
    JComponent base;
    ArrayList addOns = new ArrayList();
    ArrayList titles = new ArrayList();
    ArrayList footnotes = new ArrayList();
    ArrayList legends = new ArrayList();
    ArrayList sidebars = new ArrayList();
    JComponent globalLegend = null;
    String globalLegendPosition = "bottom";
    LargestEmptyRectangle ler = new LargestEmptyRectangle();
    private int _pad = 5;
    public static Rectangle largestRect = null;

    public void setDataAreaPad(int aPad) {
        this._pad = aPad;
    }

    private int getDataAreaPad() {
        return (int)Math.ceil((double)this._pad * StatGraph.getGapScaleFactor());
    }

    @Override
    public void addLayoutComponent(Component comp, Object obj) {
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return parent.getAlignmentX();
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return parent.getAlignmentY();
    }

    @Override
    public void invalidateLayout(Container parent) {
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("Base")) {
            this.base = (JComponent)comp;
        } else if (name.equals("AddOn")) {
            this.addOns.add(comp);
        } else if (name.equals("Title")) {
            this.titles.add(comp);
        } else if (name.equals("Footnote")) {
            this.footnotes.add(comp);
        } else if (name.equals("Sidebar")) {
            this.sidebars.add(comp);
        } else if (name.equals("GlobalLegend")) {
            this.globalLegend = (JComponent)comp;
        } else {
            this.legends.add(comp);
        }
    }

    public void removeLayoutComponent(String name, Component comp) {
        if (name.equals("Base")) {
            this.base = null;
        } else if (name.equals("AddOn")) {
            this.addOns.remove(comp);
        } else if (name.equals("Title")) {
            this.titles.remove(comp);
        } else if (name.equals("Footnote")) {
            this.footnotes.remove(comp);
        } else if (name.equals("Sidebar")) {
            this.sidebars.remove(comp);
        } else if (name.equals("GlobalLegend") && this.globalLegend == comp) {
            this.globalLegend = null;
        } else {
            this.legends.remove(comp);
        }
    }

    public String getLayoutComponentName(Component comp) {
        if (comp == this.base) {
            return "Base";
        }
        if (this.addOns.contains(comp)) {
            return "AddOn";
        }
        if (this.titles.contains(comp)) {
            return "Title";
        }
        if (this.footnotes.contains(comp)) {
            return "Footnote";
        }
        return "Legend";
    }

    protected Insets getSurroundingInsets() {
        Dimension d;
        int i;
        Component c;
        int i2;
        Insets insets = new Insets(0, 0, 0, 0);
        for (i2 = 0; i2 < this.titles.size(); ++i2) {
            c = (Component)this.titles.get(i2);
            if (!c.isVisible()) continue;
            insets.top += c.getPreferredSize().height;
        }
        for (i2 = 0; i2 < this.footnotes.size(); ++i2) {
            c = (Component)this.footnotes.get(i2);
            if (!c.isVisible()) continue;
            insets.bottom += c.getPreferredSize().height;
        }
        if (this.globalLegend != null && this.globalLegend.isVisible()) {
            int pad = 0;
            if (this.globalLegendPosition.equals("bottom")) {
                insets.bottom += this.globalLegend.getPreferredSize().height + pad;
            } else if (this.globalLegendPosition.equals("top")) {
                insets.top += this.globalLegend.getPreferredSize().height + pad;
            } else if (this.globalLegendPosition.equals("left")) {
                insets.left += this.globalLegend.getPreferredSize().width + pad;
            } else {
                insets.right += this.globalLegend.getPreferredSize().width + pad;
            }
        }
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        for (i = 0; i < this.legends.size(); ++i) {
            c = (Component)this.legends.get(i);
            d = c.getPreferredSize();
            if (c.getAlignmentY() == 0.0f) {
                top = Math.max(top, d.height);
                continue;
            }
            if (c.getAlignmentY() == 1.0f) {
                bottom = Math.max(bottom, d.height);
                continue;
            }
            if (c.getAlignmentX() == 0.0f) {
                left = Math.max(left, d.width);
                continue;
            }
            if (c.getAlignmentX() != 1.0f) continue;
            right = Math.max(right, d.width);
        }
        for (i = 0; i < this.sidebars.size(); ++i) {
            c = (Component)this.sidebars.get(i);
            d = c.getPreferredSize();
            if (c.getAlignmentY() == 0.0f) {
                top += d.height;
                continue;
            }
            if (c.getAlignmentY() == 1.0f) {
                bottom += d.height;
                continue;
            }
            if (c.getAlignmentX() == 0.0f) {
                left += d.width;
                continue;
            }
            if (c.getAlignmentX() != 1.0f) continue;
            right += d.width;
        }
        insets.left += left;
        insets.right += right;
        insets.top += top;
        insets.bottom += bottom;
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension size = parent.getSize();
            if (size.width == 0 || size.height == 0) {
                return;
            }
            Insets bi = parent.getInsets();
            Insets insets = new Insets(bi.top, bi.left, bi.bottom, bi.right);
            Insets si = this.getSurroundingInsets();
            insets.left += si.left;
            insets.right += si.right;
            insets.top += si.top;
            insets.bottom += si.bottom;
            if (this.base != null) {
                if (this.base instanceof CompositeComponent) {
                    ((CompositeComponent)this.base).setSurroundingInsets(si);
                }
                this.base.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
            }
            Rectangle ir = null;
            Rectangle or = null;
            Rectangle ir_f = null;
            Rectangle or_f = null;
            Rectangle ir_b = null;
            Rectangle or_b = null;
            boolean oblique = false;
            if (this.base instanceof CompositeComponent) {
                CompositeComponent cc = (CompositeComponent)this.base;
                Simple2DOverlayComposite oc = cc.getComposite();
                Insets om = oc.getOuterMargin();
                Insets fm = oc.getFringeMargin();
                ir = new Rectangle(om.left + insets.left, om.top + insets.top, size.width - om.left - om.right - insets.left - insets.right, size.height - om.top - om.bottom - insets.top - insets.bottom);
                or = new Rectangle(om.left + fm.left + insets.left, om.top + fm.top + insets.top, size.width - om.left - fm.left - om.right - fm.right - insets.left - insets.right, size.height - om.top - fm.top - om.bottom - fm.bottom - insets.top - insets.bottom);
                or.x += this.getDataAreaPad();
                or.y += this.getDataAreaPad();
                or.width -= 2 * this.getDataAreaPad();
                or.height -= 2 * this.getDataAreaPad();
                if (((CompositeComponent)this.base).isObliqueProjection()) {
                    oblique = true;
                    SimpleExtrudedOverlayComposite sc = (SimpleExtrudedOverlayComposite)((CompositeComponent)this.base).getComposite();
                    ir_f = sc.getFrontFaceOuterRegion();
                    ir_f.x += fm.left + insets.left;
                    ir_f.y += fm.top + insets.top;
                    or_f = new Rectangle(ir_f);
                    or_f.x += this.getDataAreaPad();
                    or_f.y += this.getDataAreaPad();
                    or_f.width -= 2 * this.getDataAreaPad();
                    or_f.height -= 2 * this.getDataAreaPad();
                    ir_b = sc.getBackFaceOuterRegion();
                    ir_b.x += fm.left + insets.left;
                    ir_b.y += fm.top + insets.top;
                    or_b = new Rectangle(ir_b);
                    or_b.x += this.getDataAreaPad();
                    or_b.y += this.getDataAreaPad();
                    or_b.width -= 2 * this.getDataAreaPad();
                    or_b.height -= 2 * this.getDataAreaPad();
                }
            }
            if (oblique) {
                or = or_b;
                ir = ir_b;
            }
            int topStart = bi.top;
            for (int i = 0; i < this.titles.size(); ++i) {
                Component e = (Component)this.titles.get(i);
                if (!e.isVisible()) continue;
                Dimension d2 = e.getPreferredSize();
                if (e instanceof Entry) {
                    if (e.getAlignmentX() == 0.0f) {
                        e.setBounds(bi.left, topStart, d2.width, d2.height);
                    } else if (e.getAlignmentX() == 1.0f) {
                        e.setBounds(size.width - bi.right - d2.width, topStart, d2.width, d2.height);
                    } else if (ir != null) {
                        e.setBounds(ir.x + ir.width / 2 - d2.width / 2, topStart, d2.width, d2.height);
                    } else {
                        e.setBounds(bi.left + size.width / 2 - d2.width / 2, topStart, d2.width, d2.height);
                    }
                } else {
                    if (e instanceof EntryComposite) {
                        EntryComposite ec = (EntryComposite)e;
                        JComponent center = null;
                        for (int j = 0; j < ec.getComponents().length; ++j) {
                            JComponent c = (JComponent)ec.getComponent(j);
                            if (c.getAlignmentX() == 0.0f || c.getAlignmentX() == 1.0f) continue;
                            center = c;
                            break;
                        }
                        if (center != null && ir != null) {
                            float cx = 0.5f;
                            if (!ec.isCenterOnGraph()) {
                                Dimension ps = center.getPreferredSize();
                                cx = (float)(ir.x - bi.left + ir.width / 2 - ps.width / 2) / (float)(size.width - bi.left - bi.right - ps.width);
                                if (cx < 0.0f || cx > 1.0f) {
                                    cx = 0.5f;
                                }
                            }
                            center.setAlignmentX(cx);
                        }
                    }
                    e.setBounds(bi.left, topStart, size.width - bi.left - bi.right, d2.height);
                }
                topStart += d2.height;
            }
            if (oblique) {
                or = or_f;
                ir = ir_f;
            }
            int bottomStart = size.height - bi.bottom;
            for (int i = this.footnotes.size() - 1; i >= 0; --i) {
                Component e = (Component)this.footnotes.get(i);
                if (!e.isVisible()) continue;
                d = e.getPreferredSize();
                bottomStart -= d.height;
                if (e instanceof Entry) {
                    if (e.getAlignmentX() == 0.0f) {
                        e.setBounds(bi.left, bottomStart, d.width, d.height);
                        continue;
                    }
                    if (e.getAlignmentX() == 1.0f) {
                        e.setBounds(size.width - bi.right - d.width, bottomStart, d.width, d.height);
                        continue;
                    }
                    if (ir != null) {
                        e.setBounds(ir.x + ir.width / 2 - d.width / 2, bottomStart, d.width, d.height);
                        continue;
                    }
                    e.setBounds(bi.left + size.width / 2 - d.width / 2, bottomStart, d.width, d.height);
                    continue;
                }
                if (e instanceof EntryComposite) {
                    EntryComposite ec = (EntryComposite)e;
                    JComponent center = null;
                    for (int j = 0; j < ec.getComponents().length; ++j) {
                        JComponent c = (JComponent)ec.getComponent(j);
                        if (c.getAlignmentX() == 0.0f || c.getAlignmentX() == 1.0f) continue;
                        center = c;
                        break;
                    }
                    if (center != null && ir != null) {
                        float cx = 0.5f;
                        if (!ec.isCenterOnGraph()) {
                            Dimension ps = center.getPreferredSize();
                            cx = (float)(ir.x - bi.left + ir.width / 2 - ps.width / 2) / (float)(size.width - bi.left - bi.right - ps.width);
                            if (cx < 0.0f || cx > 1.0f) {
                                cx = 0.5f;
                            }
                        }
                        center.setAlignmentX(cx);
                    }
                }
                e.setBounds(bi.left, bottomStart, size.width - bi.left - bi.right, d.height);
            }
            if (this.globalLegend != null && this.globalLegend.isVisible()) {
                Dimension d3 = this.globalLegend.getPreferredSize();
                if (this.globalLegendPosition.equals("bottom")) {
                    int x;
                    int width = Math.min(d3.width, size.width - bi.left - bi.right);
                    bottomStart -= d3.height;
                    if (this.globalLegend.getAlignmentX() == 0.0f) {
                        x = bi.left;
                    } else if (this.globalLegend.getAlignmentX() == 1.0f) {
                        x = size.width - bi.right - width;
                    } else {
                        x = ir.x + ir.width / 2 - width / 2;
                        if (x + width > size.width - bi.right) {
                            x = bi.left + (size.width - bi.left - bi.right) / 2 - width / 2;
                        }
                    }
                    this.globalLegend.setBounds(x, bottomStart, width, d3.height);
                } else if (this.globalLegendPosition.equals("top")) {
                    int x;
                    int width = Math.min(d3.width, size.width - bi.left - bi.right);
                    if (this.globalLegend.getAlignmentX() == 0.0f) {
                        x = bi.left;
                    } else if (this.globalLegend.getAlignmentX() == 1.0f) {
                        x = size.width - bi.right - width;
                    } else {
                        x = ir.x + ir.width / 2 - width / 2;
                        if (x + width > size.width - bi.right) {
                            x = bi.left + (size.width - bi.left - bi.right) / 2 - width / 2;
                        }
                    }
                    this.globalLegend.setBounds(x, topStart, width, d3.height);
                    topStart += d3.height;
                } else if (this.globalLegendPosition.equals("right")) {
                    int y;
                    int height = Math.min(d3.height, size.height - bi.top - bi.bottom);
                    if (this.globalLegend.getAlignmentY() == 0.0f) {
                        y = bi.top;
                    } else if (this.globalLegend.getAlignmentY() == 1.0f) {
                        y = size.height - bi.bottom - height;
                    } else {
                        y = ir.y + ir.height / 2 - height / 2;
                        if (y + height > size.height - bi.bottom) {
                            y = bi.top + (size.height - bi.top - bi.bottom) / 2 - height / 2;
                        }
                    }
                    this.globalLegend.setBounds(size.width - bi.right - d3.width, y, d3.width, height);
                } else {
                    int y;
                    int height = Math.min(d3.height, size.height - bi.top - bi.bottom);
                    if (this.globalLegend.getAlignmentY() == 0.0f) {
                        y = bi.top;
                    } else if (this.globalLegend.getAlignmentY() == 1.0f) {
                        y = size.height - bi.bottom - height;
                    } else {
                        y = ir.y + ir.height / 2 - height / 2;
                        if (y + height > size.height - bi.bottom) {
                            y = bi.top + (size.height - bi.top - bi.bottom) / 2 - height / 2;
                        }
                    }
                    this.globalLegend.setBounds(bi.left, y, d3.width, height);
                }
            }
            for (int i = 0; i < this.legends.size(); ++i) {
                Component l = (Component)this.legends.get(i);
                d = l.getPreferredSize();
                if (oblique) {
                    if (l.getAlignmentY() == 1.0f) {
                        or = or_f;
                        ir = ir_f;
                    } else if (l.getAlignmentY() == 0.0f) {
                        or = or_b;
                        ir = ir_b;
                    } else if (l.getAlignmentX() == 0.0f) {
                        or = or_f;
                        ir = ir_f;
                    } else {
                        or = or_b;
                        ir = ir_b;
                    }
                }
                if (l instanceof LegendComponent) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f || l.getAlignmentX() == 1.0f) {
                            d.height = ir.height;
                        } else if (l.getAlignmentY() == 0.0f || l.getAlignmentY() == 1.0f) {
                            d.width = ir.width;
                        }
                    } else if (l.getAlignmentX() == 0.0f || l.getAlignmentX() == 1.0f) {
                        d.height = size.height;
                    } else if (l.getAlignmentY() == 0.0f || l.getAlignmentY() == 1.0f) {
                        d.width = size.width;
                    }
                }
                if (l.getAlignmentY() == 0.0f) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f) {
                            l.setBounds(ir.x, topStart, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentX() == 1.0f) {
                            l.setBounds(ir.x + ir.width - d.width, topStart, d.width, d.height);
                            continue;
                        }
                        l.setBounds(ir.x + ir.width / 2 - d.width / 2, topStart, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 0.0f) {
                        l.setBounds(bi.left, topStart, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 1.0f) {
                        l.setBounds(bi.left + size.width - d.width, topStart, d.width, d.height);
                        continue;
                    }
                    l.setBounds(bi.left + size.width / 2 - d.width / 2, topStart, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 1.0f) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f) {
                            l.setBounds(ir.x, bottomStart - d.height, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentX() == 1.0f) {
                            l.setBounds(ir.x + ir.width - d.width, bottomStart - d.height, d.width, d.height);
                            continue;
                        }
                        l.setBounds(ir.x + ir.width / 2 - d.width / 2, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 0.0f) {
                        l.setBounds(0, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 1.0f) {
                        l.setBounds(size.width - d.width, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    l.setBounds(size.width / 2 - d.width / 2, bottomStart - d.height, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentX() == 0.0f) {
                    if (ir != null) {
                        if (l.getAlignmentY() == 0.0f) {
                            l.setBounds(bi.left, ir.y, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentY() == 1.0f) {
                            l.setBounds(bi.left, ir.y + ir.height - d.height, d.width, d.height);
                            continue;
                        }
                        l.setBounds(bi.left, ir.y + ir.height / 2 - d.height / 2, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 0.0f) {
                        l.setBounds(bi.left, bi.top, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 1.0f) {
                        l.setBounds(bi.left, bi.top + size.height - d.height, d.width, d.height);
                        continue;
                    }
                    l.setBounds(bi.left, bi.top + size.height / 2 - d.height / 2, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentX() != 1.0f) continue;
                if (ir != null) {
                    if (l.getAlignmentY() == 0.0f) {
                        l.setBounds(size.width - bi.right - d.width, ir.y, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 1.0f) {
                        l.setBounds(size.width - bi.right - d.width, ir.y + ir.height - d.height, d.width, d.height);
                        continue;
                    }
                    l.setBounds(size.width - bi.right - d.width, ir.y + ir.height / 2 - d.height / 2, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 0.0f) {
                    l.setBounds(size.width - bi.right - d.width, 0, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 1.0f) {
                    l.setBounds(size.width - bi.right - d.width, size.height - d.height, d.width, d.height);
                    continue;
                }
                l.setBounds(size.width - bi.right - d.width, size.height / 2 - d.height / 2, d.width, d.height);
            }
            topStart = bi.top + si.top;
            bottomStart = size.height - bi.bottom - si.bottom;
            int leftStart = bi.left + si.left;
            int rightStart = size.width - bi.right - si.right;
            for (int i = 0; i < this.sidebars.size(); ++i) {
                Component sb = (Component)this.sidebars.get(i);
                Dimension d4 = sb.getPreferredSize();
                if (oblique) {
                    if (sb.getAlignmentY() == 1.0f) {
                        or = or_f;
                        ir = ir_f;
                    } else if (sb.getAlignmentY() == 0.0f) {
                        or = or_b;
                        ir = ir_b;
                    } else if (sb.getAlignmentX() == 0.0f) {
                        or = or_f;
                        ir = ir_f;
                    } else {
                        or = or_b;
                        ir = ir_b;
                    }
                }
                if (sb instanceof EntryComposite) {
                    EntryComposite entry = (EntryComposite)sb;
                    JComponent center = null;
                    for (int j = 0; j < entry.getComponents().length; ++j) {
                        JComponent c = (JComponent)entry.getComponent(j);
                        if (c.getAlignmentX() == 0.0f || c.getAlignmentX() == 1.0f) continue;
                        center = c;
                        break;
                    }
                    if (center != null && ir != null) {
                        Dimension ps = center.getPreferredSize();
                        float cx = (float)(ir.x + ir.width / 2 - ps.width / 2) / (float)(size.width - ps.width);
                        center.setAlignmentX(cx);
                    }
                    if (sb.getAlignmentY() == 0.0f) {
                        sb.setBounds(bi.left, topStart - d4.height, size.width - bi.left - bi.right, d4.height);
                        topStart -= d4.height;
                        continue;
                    }
                    sb.setBounds(bi.left, bottomStart, size.width - bi.left - bi.right, d4.height);
                    bottomStart += d4.height;
                    continue;
                }
                if (sb.getAlignmentY() == 0.0f) {
                    if (ir != null) {
                        sb.setBounds(ir.x + ir.width / 2 - d4.width / 2, topStart - d4.height, d4.width, d4.height);
                    } else {
                        sb.setBounds(bi.left + size.width / 2 - d4.width / 2, topStart - d4.height, d4.width, d4.height);
                    }
                    topStart -= d4.height;
                    continue;
                }
                if (sb.getAlignmentY() == 1.0f) {
                    if (ir != null) {
                        sb.setBounds(ir.x + ir.width / 2 - d4.width / 2, bottomStart, d4.width, d4.height);
                    } else {
                        sb.setBounds(size.width / 2 - d4.width / 2, bottomStart, d4.width, d4.height);
                    }
                    bottomStart += d4.height;
                    continue;
                }
                if (sb.getAlignmentX() == 0.0f) {
                    if (ir != null) {
                        sb.setBounds(leftStart - d4.width, ir.y + ir.height / 2 - d4.height / 2, d4.width, d4.height);
                    } else {
                        sb.setBounds(leftStart - d4.width, bi.top + size.height / 2 - d4.height / 2, d4.width, d4.height);
                    }
                    leftStart -= d4.width;
                    continue;
                }
                if (sb.getAlignmentX() != 1.0f) continue;
                if (ir != null) {
                    sb.setBounds(rightStart, ir.y + ir.height / 2 - d4.height / 2, d4.width, d4.height);
                } else {
                    sb.setBounds(rightStart, size.height / 2 - d4.height / 2, d4.width, d4.height);
                }
                rightStart += d4.width;
            }
            if (oblique) {
                or = or_f;
                ir = ir_f;
            }
            Rectangle or_sav = null;
            if (or != null) {
                or_sav = new Rectangle();
                or_sav.x = or.x;
                or_sav.y = or.y;
                or_sav.width = or.width;
                or_sav.height = or.height;
            }
            for (int i = 0; i < this.addOns.size(); ++i) {
                int y;
                int x;
                BaseOverlayContainer boc;
                Component c = (Component)this.addOns.get(i);
                if (or == null && c instanceof BaseOverlayContainer && (boc = (BaseOverlayContainer)c).getComposite() != null) {
                    c.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
                    continue;
                }
                Dimension cp = c.getPreferredSize();
                int w = size.width - bi.left - bi.right;
                int h = size.height - bi.top - bi.bottom;
                if (w > 0 && h > 0) {
                    cp.width = Math.min(w, cp.width);
                    cp.height = Math.min(h, cp.height);
                }
                if (c instanceof EntryComposite && ((AbstractSGComponent)c).getAutoAlignStartegy() == 0) {
                    cp.width = or != null ? or.width : w;
                }
                if (or != null) {
                    if (c instanceof CellAlignmentInterface) {
                        if (c instanceof BaseOverlayContainer) {
                            BaseOverlayContainer boc2 = (BaseOverlayContainer)c;
                            if (boc2.getComposite() != null && boc2.getComposite().getOverlays().size() > 0) {
                                or.x -= this.getDataAreaPad();
                                or.width += 2 * this.getDataAreaPad();
                                or.y -= this.getDataAreaPad();
                                or.height += 2 * this.getDataAreaPad();
                                if (boc2.getUserHeight() < 0) {
                                    cp.height = or.height;
                                }
                                if (boc2.getUserWidth() < 0) {
                                    cp.width = or.width;
                                }
                            } else {
                                CellAlignmentInterface cai = (CellAlignmentInterface)c;
                                if (cai.isFractionalHAlignment()) {
                                    or.x -= this.getDataAreaPad();
                                    or.width += 2 * this.getDataAreaPad();
                                }
                                if (cai.isFractionalVAlignment()) {
                                    or.y -= this.getDataAreaPad();
                                    or.height += 2 * this.getDataAreaPad();
                                }
                            }
                        } else {
                            CellAlignmentInterface cai = (CellAlignmentInterface)c;
                            if (cai.isFractionalHAlignment()) {
                                or.x -= this.getDataAreaPad();
                                or.width += 2 * this.getDataAreaPad();
                            }
                            if (cai.isFractionalVAlignment()) {
                                or.y -= this.getDataAreaPad();
                                or.height += 2 * this.getDataAreaPad();
                            }
                        }
                    }
                    x = or.x + cp.width / 2 + (int)((double)((float)(or.width - cp.width) * c.getAlignmentX()) + 0.5) - cp.width / 2;
                    y = or.y + cp.height / 2 + (int)((double)((float)(or.height - cp.height) * c.getAlignmentY()) + 0.5) - cp.height / 2;
                    or.x = or_sav.x;
                    or.y = or_sav.y;
                    or.width = or_sav.width;
                    or.height = or_sav.height;
                } else {
                    x = (int)((double)((float)(w - cp.width) * c.getAlignmentX()) + 0.5) + bi.left;
                    y = (int)((double)((float)(h - cp.height) * c.getAlignmentY()) + 0.5) + bi.top;
                }
                c.setBounds(x, y, cp.width, cp.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoAlignInsets(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            if (size.width == 0 || size.height == 0 || this.base == null || !(this.base instanceof CompositeComponent)) {
                return;
            }
            Insets bi = parent.getInsets();
            Insets insets = new Insets(bi.top, bi.left, bi.bottom, bi.right);
            Insets si = this.getSurroundingInsets();
            insets.left += si.left;
            insets.right += si.right;
            insets.top += si.top;
            insets.bottom += si.bottom;
            CompositeComponent cc = (CompositeComponent)this.base;
            Simple2DOverlayComposite soc = cc.getComposite();
            Insets om = soc.getOuterMargin();
            int pad = this.getDataAreaPad();
            Insets im = new Insets(pad, pad, pad, pad);
            Rectangle ir = new Rectangle(om.left + im.left + insets.left, om.top + im.top + insets.top, size.width - om.left - im.left - om.right - im.right - insets.left - insets.right, size.height - om.top - im.top - om.bottom - im.bottom - insets.top - insets.bottom);
            ArrayList<Component> assigned = new ArrayList<Component>();
            for (int i = 0; i < this.addOns.size(); ++i) {
                Component c = (Component)this.addOns.get(i);
                if (!(c instanceof CellAlignmentInterface)) continue;
                CellAlignmentInterface sgc = (CellAlignmentInterface)c;
                if (sgc.getAutoAlignStartegy() == 0) {
                    assigned.add(c);
                    continue;
                }
                Dimension cp = c.getPreferredSize();
                if (sgc.getAutoAlignStartegy() == 2) {
                    Rectangle r;
                    this.ler.setBounds(ir);
                    soc.populateDataPoints(this.ler);
                    if (!this.ler.isPopulated()) {
                        assigned.add(c);
                        continue;
                    }
                    largestRect = r = this.ler.getLERectangle(c.getBounds());
                    float cx = (float)(r.getCenterX() - (double)(cp.width / 2)) / (float)(ir.width - cp.width);
                    float cy = (float)(r.getCenterY() - (double)(cp.height / 2)) / (float)(ir.height - cp.height);
                    ((JComponent)c).setAlignmentX(cx);
                    ((JComponent)c).setAlignmentY(cy);
                    assigned.add(c);
                    continue;
                }
                String[] preferred = sgc.getPreferredLocations();
                int w = size.width - bi.left - bi.right;
                int h = size.height - bi.top - bi.bottom;
                if (w > 0 && h > 0) {
                    cp.width = Math.min(w, cp.width);
                    cp.height = Math.min(h, cp.height);
                }
                Point[] loc = new Point[preferred.length];
                float[] alignX = new float[preferred.length];
                float[] alignY = new float[preferred.length];
                this.getAutoAlignInfo(preferred, ir, cp, loc, alignX, alignY);
                boolean foundLocation = false;
                int minHitsLocation = 0;
                int minHits = Integer.MAX_VALUE;
                for (int ii = 0; ii < loc.length; ++ii) {
                    Rectangle bbox = new Rectangle(loc[ii], cp);
                    if (this.isOverlappingAssigned(assigned, ir, alignX[ii], alignY[ii], bbox)) continue;
                    ArrayList probeList = soc.extendedProbe(loc[ii], cp);
                    if (probeList == null || probeList.size() == 0) {
                        ((JComponent)c).setAlignmentX(alignX[ii]);
                        ((JComponent)c).setAlignmentY(alignY[ii]);
                        foundLocation = true;
                        break;
                    }
                    int cnt = 0;
                    for (int jj = 0; jj < probeList.size(); ++jj) {
                        ProbeResult[] pr = (ProbeResult[])probeList.get(jj);
                        cnt += pr.length;
                    }
                    if (cnt >= minHits) continue;
                    minHits = cnt;
                    minHitsLocation = ii;
                }
                if (!foundLocation) {
                    ((JComponent)c).setAlignmentX(alignX[minHitsLocation]);
                    ((JComponent)c).setAlignmentY(alignY[minHitsLocation]);
                }
                assigned.add(c);
            }
        }
    }

    private Rectangle getAlignedBBox(Rectangle ir, JComponent comp) {
        float ax = comp.getAlignmentX();
        float ay = comp.getAlignmentY();
        Dimension cp = comp.getPreferredSize();
        Point p = ax == 0.0f && ay == 0.0f ? new Point(ir.x, ir.y) : (ax == 1.0f && ay == 0.0f ? new Point(ir.x + ir.width - cp.width, ir.y) : (ax == 1.0f && ay == 1.0f ? new Point(ir.x + ir.width - cp.width, ir.y + ir.height - cp.height) : (ax == 0.0f && ay == 1.0f ? new Point(ir.x, ir.y + ir.height - cp.height) : (ax == 0.5f && ay == 0.0f ? new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y) : (ax == 1.0f && ay == 0.5f ? new Point(ir.x + ir.width - cp.width, ir.y + ir.height / 2 - cp.height / 2) : (ax == 0.5f && ay == 1.0f ? new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y + ir.height - cp.height) : (ax == 0.0f && ay == 0.5f ? new Point(ir.x, ir.y + ir.height / 2 - cp.height / 2) : new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y + ir.height / 2 - cp.height / 2))))))));
        return new Rectangle(p, cp);
    }

    private boolean isOverlappingAssigned(ArrayList assigned, Rectangle ir, float ax, float ay, Rectangle bbox) {
        for (int i = 0; i < assigned.size(); ++i) {
            JComponent prev = (JComponent)assigned.get(i);
            if (prev.getAlignmentX() == ax && prev.getAlignmentY() == ay) {
                return true;
            }
            Rectangle prevBBox = this.getAlignedBBox(ir, prev);
            if (!bbox.intersects(prevBBox)) continue;
            return true;
        }
        return false;
    }

    private void getAutoAlignInfo(String[] preferred, Rectangle ir, Dimension cp, Point[] loc, float[] ax, float[] ay) {
        for (int i = 0; i < preferred.length; ++i) {
            String p = preferred[i];
            if (p.equalsIgnoreCase("TOPLEFT")) {
                loc[i] = new Point(ir.x, ir.y);
                ax[i] = 0.0f;
                ay[i] = 0.0f;
            } else if (p.equalsIgnoreCase("TOPRIGHT")) {
                loc[i] = new Point(ir.x + ir.width - cp.width, ir.y);
                ax[i] = 1.0f;
                ay[i] = 0.0f;
            } else if (p.equalsIgnoreCase("BOTTOMRIGHT")) {
                loc[i] = new Point(ir.x + ir.width - cp.width, ir.y + ir.height - cp.height);
                ax[i] = 1.0f;
                ay[i] = 1.0f;
            } else if (p.equalsIgnoreCase("BOTTOMLEFT")) {
                loc[i] = new Point(ir.x, ir.y + ir.height - cp.height);
                ax[i] = 0.0f;
                ay[i] = 1.0f;
            } else if (p.equalsIgnoreCase("TOP")) {
                loc[i] = new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y);
                ax[i] = 0.5f;
                ay[i] = 0.0f;
            } else if (p.equalsIgnoreCase("RIGHT")) {
                loc[i] = new Point(ir.x + ir.width - cp.width, ir.y + ir.height / 2 - cp.height / 2);
                ax[i] = 1.0f;
                ay[i] = 0.5f;
            } else if (p.equalsIgnoreCase("BOTTOM")) {
                loc[i] = new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y + ir.height - cp.height);
                ax[i] = 0.5f;
                ay[i] = 1.0f;
            } else if (p.equalsIgnoreCase("LEFT")) {
                loc[i] = new Point(ir.x, ir.y + ir.height / 2 - cp.height / 2);
                ax[i] = 0.0f;
                ay[i] = 0.5f;
            } else if (p.equalsIgnoreCase("CENTER")) {
                loc[i] = new Point(ir.x + ir.width / 2 - cp.width / 2, ir.y + ir.height / 2 - cp.height / 2);
                ax[i] = 0.5f;
                ay[i] = 0.5f;
            } else {
                loc[i] = new Point(ir.x, ir.y);
                ax[i] = 0.0f;
                ay[i] = 0.0f;
            }
            if (this.base == null) continue;
            loc[i].x -= this.base.getBounds().x;
            loc[i].y -= this.base.getBounds().y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.base.getPreferredSize();
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(String name, Component comp, int pos) {
        if (name.equals("Base")) {
            this.base = (JComponent)comp;
        } else if (name.equals("AddOn")) {
            if (pos == -1 || pos >= this.addOns.size()) {
                this.addOns.add(comp);
            } else {
                this.addOns.add(pos, comp);
            }
        } else if (name.equals("Title")) {
            if (pos == -1 || pos >= this.titles.size()) {
                this.titles.add(comp);
            } else {
                this.titles.add(pos, comp);
            }
        } else if (name.equals("Footnote")) {
            if (pos == -1 || pos >= this.footnotes.size()) {
                this.footnotes.add(comp);
            } else {
                this.footnotes.add(pos, comp);
            }
        } else {
            this.legends.add(comp);
        }
    }

    public ArrayList getTitlesArray() {
        return this.titles;
    }

    public ArrayList getFootnotesArray() {
        return this.footnotes;
    }

    public ArrayList getAddOnsArray() {
        return this.addOns;
    }

    public ArrayList getLegendArray() {
        return this.legends;
    }
}

