/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RB;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.event.SelectionEvent;
import com.sas.graphics.applets.statgraph.sgchart.event.SelectionListener;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportEvent;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.GridAxis;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.CopyToClipboard;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;

public class OverlayContainer
extends BaseOverlayContainer
implements ActionListener,
KeyListener,
ViewportListener {
    private static final int CONTINUOUS_RANGE = 0;
    private static final int DISCRETE_RANGE = 1;
    private static final int BINNED_RANGE = 2;
    public static final int X = 0;
    public static final int X2 = 1;
    public static final int Y = 2;
    public static final int Y2 = 3;
    private static final int NUM_AXIS = 4;
    private static final int NUM_X = 2;
    private static final int NUM_Y = 2;
    public static final int INDICATOR_SIZE = 15;
    private double[] offsetMin = new double[4];
    private double[] offsetMax = new double[4];
    private double[] dataMin = new double[4];
    private double[] dataMax = new double[4];
    private double[] viewportMin = new double[4];
    private double[] viewportMax = new double[4];
    private Vector[] discreteValue = new Vector[4];
    private double[] strideValue = new double[4];
    private double[] startOffset = new double[4];
    private double[] strideOffset = new double[4];
    private int[] rangeType = new int[4];
    private AbstractAxis[] axis = new AbstractAxis[4];
    private boolean[] viewporting = new boolean[4];
    private boolean[] userSetTick = new boolean[4];
    private boolean[] userTickPriority = new boolean[4];
    private double[] accumulatedChange = new double[4];
    private boolean initViewport = false;
    protected Rectangle rubberband = null;
    protected boolean dragged;
    private boolean exited = false;
    private boolean popupOn = false;
    public static final int PAN = 0;
    public static final int ZOOM = 1;
    public static final int ZOOM_MIN = 2;
    public static final int ZOOM_MAX = 3;
    public static int zoomPanStatus = 0;
    public static JPopupMenu axisPopup = null;
    public static ActionListener axisListener = null;
    public static int keyCode;
    private JPopupMenu chartPopup = null;
    private Cursor defaultCursor;
    private Rectangle[] axisArea = new Rectangle[4];
    private boolean updateAxisArea = true;
    private int zoomPanAxisID = -1;
    private HashMap viewportListener;
    private boolean sync_x = true;
    private boolean sync_y = false;
    protected boolean mouseOnChart = false;
    private Color indicatorColor;
    private double zoomPoint = Double.NaN;
    private int currentZoomPanStatus = zoomPanStatus;
    private UserViewportParams[] userViewportParams = new UserViewportParams[4];
    protected boolean setUserViewport = false;
    protected boolean resetting = false;
    private ToolTipManager ttm;
    private static long tipStartTime;
    private static String tipText;
    private boolean showToolTip = false;
    public static Cursor panOpenLRCursor;
    public static Cursor panOpenUDCursor;
    public static Cursor panClosedLRCursor;
    public static Cursor panClosedUDCursor;
    public static Cursor zoomLRCursor;
    public static Cursor zoomUDCursor;
    private ArrayList selectionListener;
    public static final String RB_KEY = "OverlayContainer.";
    protected boolean isEditor = false;
    protected boolean enableComputeIntervals = true;

    public OverlayContainer(boolean view2D) {
        this(view2D, false, false);
    }

    public OverlayContainer(boolean view2D, boolean softwareBuffered, boolean interactive) {
        this(view2D, softwareBuffered, interactive, false);
    }

    public OverlayContainer(boolean view2D, boolean softwareBuffered, boolean interactive, boolean noComposite) {
        super(view2D, softwareBuffered, interactive, noComposite);
        if (!noComposite) {
            this.addKeyListener(this);
            this.defaultCursor = this.getCursor();
        }
    }

    public void setInitViewport(boolean b) {
        this.initViewport = b;
    }

    public void setUpdateAxisArea(boolean b) {
        this.updateAxisArea = b;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.updateAxisArea = true;
        super.setBounds(x, y, w, h);
    }

    @Override
    public void paint(Graphics g) {
        if (this.initViewport) {
            this.initViewport();
        }
        if (this.isViewportEnabled() && this.updateAxisArea) {
            this.computeAxisArea();
        }
        if (this.isViewportEnabled() && !this.isEditor) {
            this.drawViewportIndicator(g);
        }
        if (this.setUserViewport) {
            int i;
            double[] offsetMin = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] offsetMax = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            for (i = 0; i < 4; ++i) {
                if (this.userViewportParams[i] == null || !this.userViewportParams[i].hasUserSetViewport()) continue;
                if (!Double.isNaN(this.userViewportParams[i].offsetMin)) {
                    offsetMin[i] = this.userViewportParams[i].offsetMin;
                    this.offsetMin[i] = this.userViewportParams[i].offsetMin;
                }
                if (Double.isNaN(this.userViewportParams[i].offsetMax)) continue;
                offsetMax[i] = this.userViewportParams[i].offsetMax;
                this.offsetMax[i] = this.userViewportParams[i].offsetMax;
            }
            this.getComposite().userOffsetMin = offsetMin;
            this.getComposite().userOffsetMax = offsetMax;
            for (i = 0; i < 4; ++i) {
                this.setUserViewport(i);
            }
        }
        super.paint(g);
        if (this.isGraphComposite()) {
            Insets margin = this.getMargin();
            g.translate(margin.left, margin.top);
            this.getComposite().drawSelection(g);
            g.translate(-margin.left, -margin.top);
        }
    }

    protected Insets getMargin() {
        Insets I = this.ol.getSurroundingInsets();
        Insets om = new Insets(I.top + this.getInsets().top, I.left + this.getInsets().left, I.bottom + this.getInsets().bottom, I.right + this.getInsets().right);
        return om;
    }

    @Override
    protected void performMouseClicked(MouseEvent e) {
        if (!this.isGraphComposite() || e.getButton() != 1) {
            return;
        }
        int x = e.getX() - this.getMargin().left;
        int y = e.getY() - this.getMargin().top;
        ProbeResult pr = this.getComposite().probe(new Point(x, y), new Dimension(3, 3));
        boolean extended = e.isControlDown();
        this.updateSelection(pr, extended);
        this.repaint();
    }

    @Override
    protected void performMousePressed(MouseEvent e) {
        if (!this.isViewportEnabled()) {
            return;
        }
        if (e.isPopupTrigger()) {
            this.bringUpPopupMenu(e);
        } else if (this.zoomPanAxisID > -1) {
            this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
            this.setZoomPanCursor(this.currentZoomPanStatus, true);
            if (this.currentZoomPanStatus == 1) {
                this.zoomPoint = this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1 ? (double)(this.prevx - this.axisArea[this.zoomPanAxisID].x) / (double)this.axisArea[this.zoomPanAxisID].width : 1.0 - (double)(this.prevy - this.axisArea[this.zoomPanAxisID].y) / (double)this.axisArea[this.zoomPanAxisID].height;
            }
            for (int i = 0; i < 4; ++i) {
                this.accumulatedChange[i] = 0.0;
            }
        }
    }

    @Override
    protected void performMouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.bringUpPopupMenu(e);
            return;
        }
        if (this.dragged) {
            if (this.mouseOnChart) {
                if (e.isShiftDown() || this.isEditor) {
                    this.probe = null;
                    this.updateViewport();
                } else {
                    int x = this.rubberband.x - this.getMargin().left;
                    int y = this.rubberband.y - this.getMargin().top;
                    ArrayList pr = this.getComposite().extendedProbe(new Point(x, y), new Dimension(this.rubberband.width, this.rubberband.height));
                    this.updateSelection(pr, e.isControlDown());
                }
            }
            this.dragged = false;
            this.postZoomPanProcess(true);
        }
        if (this.exited) {
            this.zoomPanAxisID = -1;
        } else {
            this.getZoomPanInfo(e.getX(), e.getY());
            this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
            this.setZoomPanCursor(this.currentZoomPanStatus, false);
        }
    }

    @Override
    protected void performMouseEntered(MouseEvent e) {
        if (this.isViewportEnabled()) {
            this.requestFocusInWindow();
        }
        this.exited = false;
    }

    @Override
    protected void performMouseExited(MouseEvent e) {
        if (!this.dragged && !this.popupOn) {
            this.zoomPanAxisID = -1;
        }
        this.exited = true;
    }

    @Override
    protected void performMouseDragged(MouseEvent e) {
        if (this.cc.isView2D()) {
            if (this.zoomPanAxisID != -1) {
                boolean userSync;
                boolean bl = userSync = this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1 ? this.sync_x : this.sync_y;
                boolean sync = userSync ? userSync : !e.isShiftDown() || !e.isControlDown();
                this.preZoomPanProcess(true);
                this.zoomPanAxis(e.getPoint(), this.currentZoomPanStatus, sync);
            } else if (this.mouseOnChart) {
                if (e.isShiftDown()) {
                    this.dragRubberband(e.getPoint(), false);
                } else {
                    this.dragRubberband(e.getPoint(), true);
                }
            }
            return;
        }
    }

    @Override
    protected void performMouseMoved(MouseEvent e) {
        this.getZoomPanInfo(e.getX(), e.getY());
        this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
        this.setZoomPanCursor(this.currentZoomPanStatus, false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.zoomPanAxisID == -1 || this.dragged) {
            return;
        }
        if (keyCode == e.getKeyCode()) {
            return;
        }
        keyCode = e.getKeyCode();
        if (keyCode == 16) {
            this.setZoomPanCursor(0, false);
        } else if (keyCode == 17) {
            this.setZoomPanCursor(1, false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (keyCode != -1 && !this.dragged) {
            this.setZoomPanCursor(zoomPanStatus, false);
        }
        keyCode = -1;
    }

    public boolean isViewportEnabled() {
        return this.cc != null && this.cc.isView2D() && (this.viewporting[0] || this.viewporting[1] || this.viewporting[2] || this.viewporting[3]);
    }

    public void setViewportEnabled(boolean enable) {
        this.initViewport = enable;
        for (int i = 0; i < 4; ++i) {
            this.viewporting[i] = enable;
        }
    }

    public boolean isViewportEnabled(int axisID) {
        return this.viewporting[axisID];
    }

    public void setViewportEnabled(int axisID, boolean enable) {
        this.viewporting[axisID] = enable;
        this.initViewport = this.isViewportEnabled();
    }

    public boolean isViewportSynchronized(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.sync_x;
            }
            case 2: {
                return this.sync_y;
            }
        }
        return false;
    }

    public void setViewportSynchronized(byte dimension, boolean sync) {
        switch (dimension) {
            case 1: {
                this.sync_x = sync;
                break;
            }
            case 2: {
                this.sync_y = sync;
                break;
            }
        }
    }

    public void addViewportListener(int axisID, ViewportListener listener) {
        if (listener == null) {
            return;
        }
        if (this.viewportListener == null) {
            this.viewportListener = new HashMap();
        }
        boolean[] id = this.viewportListener.containsKey(listener) ? (boolean[])this.viewportListener.get(listener) : new boolean[4];
        id[axisID] = true;
        this.viewportListener.put(listener, id);
    }

    public void removeViewportListener(int axisID, ViewportListener listener) {
        if (this.viewportListener == null || listener == null) {
            return;
        }
        if (this.viewportListener.containsKey(listener)) {
            boolean[] id = (boolean[])this.viewportListener.get(listener);
            id[axisID] = false;
            boolean remove = true;
            for (int i = 0; i < 4; ++i) {
                if (!id[i]) continue;
                remove = false;
                break;
            }
            if (remove) {
                this.viewportListener.remove(listener);
            }
        }
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (evt.source == this) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (Double.isNaN(evt.min[i]) || Double.isNaN(evt.max[i]) || this.viewportMin[i] == evt.min[i] && this.viewportMax[i] == evt.max[i] && this.startOffset[i] == evt.startOffset[i] && this.strideOffset[i] == evt.strideOffset[i]) continue;
            this.viewportMin[i] = evt.min[i];
            this.viewportMax[i] = evt.max[i];
            this.startOffset[i] = evt.startOffset[i];
            this.strideOffset[i] = evt.strideOffset[i];
            if (evt.mode == 2) {
                this.zoomPanAxisID = i;
                this.currentZoomPanStatus = 0;
            } else if (evt.mode == 3) {
                this.zoomPanAxisID = i;
                this.currentZoomPanStatus = 1;
            }
            this.setViewport(i);
            this.zoomPanAxisID = -1;
            this.currentZoomPanStatus = zoomPanStatus;
        }
        this.probe = null;
        this.dirty = true;
        this.repaint();
        if (evt.source instanceof GridAxis) {
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
        }
    }

    private void fireViewportEvent(int axisID) {
        if (this.viewportListener == null) {
            return;
        }
        double[] min = new double[4];
        double[] max = new double[4];
        double[] start = new double[4];
        double[] stride = new double[4];
        for (int i = 0; i < 4; ++i) {
            min[i] = Double.NaN;
            max[i] = Double.NaN;
            start[i] = 0.0;
            stride[i] = 0.0;
        }
        Iterator iter = this.viewportListener.keySet().iterator();
        ViewportEvent evt = new ViewportEvent((Object)this, min, max, start, stride);
        while (iter.hasNext()) {
            ViewportListener listener = (ViewportListener)iter.next();
            boolean[] id = (boolean[])this.viewportListener.get(listener);
            if (!(listener instanceof GridAxis) || !id[axisID]) continue;
            min[axisID] = this.viewportMin[axisID];
            max[axisID] = this.viewportMax[axisID];
            start[axisID] = this.startOffset[axisID];
            stride[axisID] = this.strideOffset[axisID];
            listener.viewportChanged(evt);
        }
    }

    private void fireViewportEvent() {
        if (this.viewportListener == null) {
            return;
        }
        double[] min = new double[4];
        double[] max = new double[4];
        double[] start = new double[4];
        double[] stride = new double[4];
        Iterator iter = this.viewportListener.keySet().iterator();
        int mode = 1;
        if (this.zoomPanAxisID > -1 && this.currentZoomPanStatus == 0) {
            mode = 2;
        } else if (this.zoomPanAxisID > -1 && this.currentZoomPanStatus == 1) {
            mode = 3;
        }
        ViewportEvent evt = new ViewportEvent((Object)this, mode, min, max, start, stride);
        while (iter.hasNext()) {
            boolean fire = false;
            ViewportListener listener = (ViewportListener)iter.next();
            boolean[] id = (boolean[])this.viewportListener.get(listener);
            for (int i = 0; i < 4; ++i) {
                if (id[i] && this.axis[i] != null) {
                    min[i] = this.viewportMin[i];
                    max[i] = this.viewportMax[i];
                    start[i] = this.startOffset[i];
                    stride[i] = this.strideOffset[i];
                    fire = true;
                    continue;
                }
                min[i] = Double.NaN;
                max[i] = Double.NaN;
                start[i] = 0.0;
                stride[i] = 0.0;
            }
            if (!fire) continue;
            listener.viewportChanged(evt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.popupOn = false;
        if (evt.getActionCommand().equalsIgnoreCase("Pan")) {
            zoomPanStatus = 0;
            OverlayContainer.setSelectedItemInPopUp(axisPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("Zoom")) {
            zoomPanStatus = 1;
            OverlayContainer.setSelectedItemInPopUp(axisPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("Reset")) {
            this.resetViewport();
        } else if (evt.getActionCommand().equalsIgnoreCase("150")) {
            this.setZoomFactor(150.0);
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("200")) {
            this.setZoomFactor(200.0);
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("250")) {
            this.setZoomFactor(250.0);
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("300")) {
            this.setZoomFactor(300.0);
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("ResetAll")) {
            this.resetting = true;
            this.getComposite().userOffsetMin = null;
            this.getComposite().userOffsetMax = null;
            this.setZoomFactor(100.0);
            this.getComposite().dynamic = false;
            for (int i = 0; i < 4; ++i) {
                if (!(this.axis[i] instanceof VRectAxis)) continue;
                ((VRectAxis)this.axis[i]).setDynamic(false);
            }
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
        } else if (evt.getActionCommand().equalsIgnoreCase("Copy")) {
            Component parent = this.getStatGraphPanel();
            if (parent != null && parent instanceof StatGraphPanel) {
                CopyToClipboard.toClipboard((JComponent)((JComponent)parent));
            }
            OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
        }
        this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
        this.setZoomPanCursor(this.currentZoomPanStatus, false);
    }

    private void initViewport() {
        if (this.getComposite() == null) {
            return;
        }
        Object[] axes = this.getComposite().getAxes();
        for (int i = 0; i < axes.length; ++i) {
            AbstractAxis a = (AbstractAxis)axes[i];
            if (a.getDimension() == 1) {
                if (a instanceof VRectAxis && ((VRectAxis)a).getPrimary()) {
                    this.axis[0] = a;
                    continue;
                }
                this.axis[1] = a;
                continue;
            }
            if (a.getDimension() != 2) continue;
            if (a instanceof VRectAxis && ((VRectAxis)a).getPrimary()) {
                this.axis[2] = a;
                continue;
            }
            this.axis[3] = a;
        }
        for (int i = 0; i < 4; ++i) {
            byte dim;
            byte by = dim = i < 2 ? (byte)1 : 2;
            if (this.axis[i] == null) continue;
            DataRange dr = this.axis[i].getDataRange(dim);
            if (dr instanceof ContinuousRange) {
                this.dataMin[i] = ((ContinuousRange)dr).getMin();
                this.dataMax[i] = ((ContinuousRange)dr).getMax();
                this.rangeType[i] = 0;
            } else if (dr instanceof SimpleBinnedRange) {
                if (dr.getDual() instanceof ContinuousRange) {
                    this.dataMin[i] = ((ContinuousRange)dr.getDual()).getMin();
                    this.dataMax[i] = ((ContinuousRange)dr.getDual()).getMax();
                } else {
                    this.dataMin[i] = ((SimpleBinnedRange)dr).getFirstMidpoint();
                    this.dataMax[i] = ((SimpleBinnedRange)dr).getLastMidpoint();
                    if (((SimpleBinnedRange)dr).isEndLabels()) {
                        int n = i;
                        this.dataMin[n] = this.dataMin[n] - 0.5 * ((SimpleBinnedRange)dr).getBinSize();
                        int n2 = i;
                        this.dataMax[n2] = this.dataMax[n2] + 0.5 * ((SimpleBinnedRange)dr).getBinSize();
                    }
                }
                this.rangeType[i] = 2;
            } else if (dr instanceof CustomBinnedRange) {
                if (dr.getDual() instanceof ContinuousRange) {
                    this.dataMin[i] = ((ContinuousRange)dr.getDual()).getMin();
                    this.dataMax[i] = ((ContinuousRange)dr.getDual()).getMax();
                } else {
                    this.dataMin[i] = ((CustomBinnedRange)dr).getMin();
                    this.dataMax[i] = ((CustomBinnedRange)dr).getMax();
                }
                this.rangeType[i] = 2;
            } else if (dr instanceof DiscreteRange) {
                this.dataMin[i] = 0.0;
                this.dataMax[i] = ((DiscreteRange)dr).getValuesSize() - 1;
                this.discreteValue[i] = ((DiscreteRange)dr).getValues();
                this.rangeType[i] = 1;
                PositionEncoder pe = (PositionEncoder)this.axis[i].getEncoder(dim);
                if (pe != null) {
                    this.strideValue[i] = ((StringToNumericMap)pe.getValueMap()).getStrideValue();
                }
            }
            this.viewportMin[i] = this.dataMin[i];
            this.viewportMax[i] = this.dataMax[i];
            this.startOffset[i] = 0.0;
            this.strideOffset[i] = 0.0;
            if (this.axis[i] instanceof VRectAxis && ((VRectAxis)this.axis[i]).getTicks() != null && this.getComposite().getSquareFormat() == Simple2DOverlayComposite.EQUATED_NONE) {
                this.userSetTick[i] = true;
            }
            this.userTickPriority[i] = ((VRectAxis)this.axis[i]).getTickValuePriority();
            if (this.axis[i].getType() != 1 && (!(this.axis[i] instanceof VRectAxis) || !((VRectAxis)this.axis[i]).isBrokenAxis())) continue;
            this.viewporting[i] = false;
        }
        OverlayContainer.loadCustomCursors();
        this.indicatorColor = OverlayContainer.computeShadedColor(this.getBackground());
        if (this.chartPopup == null) {
            this.chartPopup = OverlayContainer.createChartPopupMenu();
        }
        OverlayContainer.addListenerToPopup(this.chartPopup, this);
        if (this.ttm == null) {
            this.ttm = ToolTipManager.sharedInstance();
        }
        this.ttm.registerComponent(this);
        this.ttm.setInitialDelay(0);
        this.ttm.setDismissDelay(10000);
        this.initViewport = false;
    }

    protected void setUserViewport(int axisID) {
        VRectGridLines rgl;
        Vector glv;
        Object dr;
        byte dim;
        if (!this.isViewportEnabled()) {
            return;
        }
        if (this.axis[axisID] == null) {
            return;
        }
        ((VRectAxis)this.axis[axisID]).setDynamic(true);
        this.getComposite().dynamic = true;
        byte by = dim = axisID < 2 ? (byte)1 : 2;
        if (this.rangeType[axisID] == 0) {
            if (this.userViewportParams[axisID] != null && this.userViewportParams[axisID].hasUserSetViewport(this.rangeType[axisID])) {
                this.viewportMin[axisID] = this.userViewportParams[axisID].viewportMin;
                this.viewportMax[axisID] = this.userViewportParams[axisID].viewportMax;
            } else {
                this.viewportMin[axisID] = this.dataMin[axisID];
                this.viewportMax[axisID] = this.dataMax[axisID];
            }
            dr = new ContinuousRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension()));
            dr.setMin(this.viewportMin[axisID]);
            dr.setMax(this.viewportMax[axisID]);
            if (!this.userSetTick[axisID]) {
                if (this.userViewportParams[axisID] != null && this.userViewportParams[axisID].hasUserSetViewport(this.rangeType[axisID])) {
                    ((VRectAxis)this.axis[axisID]).setTicks(this.userViewportParams[axisID].viewportTicks);
                } else {
                    ((VRectAxis)this.axis[axisID]).setTicks(null);
                }
            } else {
                ((VRectAxis)this.axis[axisID]).setTickValuePriority(false);
            }
            this.axis[axisID].setUseRange(null, false);
            this.axis[axisID].setInputDataRange((DataRange)dr);
            if (this.axis[axisID] instanceof VRectAxis) {
                PositionEncoder pe;
                if (((VRectAxis)this.axis[axisID]).getAxisLabelMap() != null && ((VRectAxis)this.axis[axisID]).getTicks() == null) {
                    ContinuousRangeToNumericMap axisMap = ((VRectAxis)this.axis[axisID]).getAxisLabelMap();
                    pe = new PositionEncoder((DataRange)dr);
                    if (pe.getValueMap() instanceof ContinuousRangeToNumericMap) {
                        ContinuousRangeToNumericMap peMap = (ContinuousRangeToNumericMap)pe.getValueMap();
                        peMap.setLabelCount(axisMap.getLabelCount());
                        pe.setOutputMin(axisMap.getOutputMin());
                        pe.setOutputMax(axisMap.getOutputMax());
                    }
                } else {
                    pe = (PositionEncoder)this.axis[axisID].getEncoder(dim);
                }
                glv = (Vector)this.getComposite().A2GLV.get(this.axis[axisID]);
                if (glv != null) {
                    for (int j = 0; j < glv.size(); ++j) {
                        rgl = (VRectGridLines)glv.elementAt(j);
                        rgl.setEncoder(pe);
                        if (((VRectAxis)this.axis[axisID]).getTicks() != null) {
                            rgl.setTicks(((VRectAxis)this.axis[axisID]).getTicks());
                            rgl.setTickValuePriority(((VRectAxis)this.axis[axisID]).getTickValuePriority());
                            continue;
                        }
                        rgl.setTicks(null);
                    }
                }
            }
        } else if (this.rangeType[axisID] == 2) {
            if (this.userViewportParams[axisID] != null && this.userViewportParams[axisID].hasUserSetViewport(this.rangeType[axisID])) {
                this.viewportMin[axisID] = this.userViewportParams[axisID].viewportMin;
                this.viewportMax[axisID] = this.userViewportParams[axisID].viewportMax;
            } else {
                this.viewportMin[axisID] = this.dataMin[axisID];
                this.viewportMax[axisID] = this.dataMax[axisID];
            }
            dr = this.axis[axisID].getDataRange(this.axis[axisID].getDimension()) instanceof SimpleBinnedRange ? new SimpleBinnedRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension())) : new CustomBinnedRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension()));
            ((ContinuousRange)dr.getDual()).setMin(this.viewportMin[axisID]);
            ((ContinuousRange)dr.getDual()).setMax(this.viewportMax[axisID]);
            double[] ticks = this.userViewportParams[axisID] != null && this.userViewportParams[axisID].hasUserSetViewport(this.rangeType[axisID]) ? this.userViewportParams[axisID].viewportTicks : VRectAxis.getBinTickList((BinnedRange)dr);
            if (this.axis[axisID] instanceof VRectAxis) {
                ((VRectAxis)this.axis[axisID]).setTicks(ticks);
            }
            this.axis[axisID].setUseRange(null, false);
            this.axis[axisID].setInputDataRange((DataRange)dr);
            glv = (Vector)this.getComposite().A2GLV.get(this.axis[axisID]);
            if (glv != null) {
                for (int j = 0; j < glv.size(); ++j) {
                    rgl = (VRectGridLines)glv.elementAt(j);
                    rgl.setTicks(ticks);
                }
            }
        } else if (this.rangeType[axisID] == 1) {
            if (this.userViewportParams[axisID] != null && this.userViewportParams[axisID].hasUserSetViewport(this.rangeType[axisID])) {
                this.startOffset[axisID] = this.userViewportParams[axisID].startOffset;
                this.strideOffset[axisID] = this.userViewportParams[axisID].strideOffset;
            } else {
                this.startOffset[axisID] = 0.0;
                this.strideOffset[axisID] = 0.0;
            }
            PositionEncoder pe = (PositionEncoder)this.axis[axisID].getEncoder(dim);
            pe.setStrideOffset(this.strideOffset[axisID]);
            pe.setStartOffset(this.startOffset[axisID]);
            ((VRectAxis)this.axis[axisID]).setFitStrategy(null);
            ((VRectAxis)this.axis[axisID]).getVTKAxis().setForceFitAlgorithm(null);
            this.axis[axisID].setEncoder(dim, pe);
        }
        ArrayList overlays = this.getComposite().getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            ((Overlay)overlays.get(i)).updateNetwork();
        }
        this.setUserViewport = false;
    }

    private void setViewport(int axisID) {
        VRectGridLines rgl;
        Vector glv;
        Object dr;
        byte dim;
        if (!this.isViewportEnabled()) {
            return;
        }
        if (this.axis[axisID] == null) {
            return;
        }
        if (this.resetting) {
            ((VRectAxis)this.axis[axisID]).setTickValuePriority(this.userTickPriority[axisID]);
        }
        ((VRectAxis)this.axis[axisID]).setDynamic(!this.resetting);
        boolean bl = this.getComposite().dynamic = !this.resetting;
        if (this.userViewportParams[axisID] == null) {
            this.userViewportParams[axisID] = new UserViewportParams();
        }
        this.userViewportParams[axisID].viewportMin = this.viewportMin[axisID];
        this.userViewportParams[axisID].viewportMax = this.viewportMax[axisID];
        this.userViewportParams[axisID].viewportTicks = null;
        this.userViewportParams[axisID].startOffset = 0.0;
        this.userViewportParams[axisID].strideOffset = 0.0;
        this.userViewportParams[axisID].offsetMin = this.offsetMin[axisID];
        this.userViewportParams[axisID].offsetMax = this.offsetMax[axisID];
        byte by = dim = axisID < 2 ? (byte)1 : 2;
        if (this.rangeType[axisID] == 0) {
            dr = new ContinuousRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension()));
            dr.setMin(this.viewportMin[axisID]);
            dr.setMax(this.viewportMax[axisID]);
            if (!this.userSetTick[axisID]) {
                if (!this.enableComputeIntervals && ((VRectAxis)this.axis[axisID]).getMajorInterval() != null || this.zoomPanAxisID > -1 && this.currentZoomPanStatus == 0 && this.axis[axisID].getType() == 0) {
                    double intv = ((VRectAxis)this.axis[axisID]).getMajorInterval().getSize();
                    double start = ((VRectAxis)this.axis[axisID]).getTicks() != null ? ((VRectAxis)this.axis[axisID]).getTicks()[0] : (((VRectAxis)this.axis[axisID]).getAxisLabelMap() != null ? ((VRectAxis)this.axis[axisID]).getAxisLabelMap().getInputMin() : ((ContinuousRange)this.axis[axisID].getDataRange(dim)).getMin());
                    if (this.viewportMin[axisID] < start) {
                        while (start - this.viewportMin[axisID] >= intv) {
                            start -= intv;
                        }
                    } else {
                        while (start < this.viewportMin[axisID]) {
                            start += intv;
                        }
                    }
                    int num = (int)((this.viewportMax[axisID] - start) / intv) + 1;
                    double[] ticks = new double[num];
                    for (int i = 0; i < num; ++i) {
                        ticks[i] = start + (double)i * intv;
                    }
                    ((VRectAxis)this.axis[axisID]).setTicks(ticks);
                    this.userViewportParams[axisID].viewportTicks = ticks;
                } else {
                    ((VRectAxis)this.axis[axisID]).setTicks(null);
                }
            } else {
                ((VRectAxis)this.axis[axisID]).setTickValuePriority(false);
            }
            this.axis[axisID].setUseRange(null, false);
            this.axis[axisID].setInputDataRange((DataRange)dr);
            if (this.axis[axisID] instanceof VRectAxis) {
                PositionEncoder pe;
                if (((VRectAxis)this.axis[axisID]).getAxisLabelMap() != null && ((VRectAxis)this.axis[axisID]).getTicks() == null) {
                    ContinuousRangeToNumericMap axisMap = ((VRectAxis)this.axis[axisID]).getAxisLabelMap();
                    pe = new PositionEncoder((DataRange)dr);
                    if (pe.getValueMap() instanceof ContinuousRangeToNumericMap) {
                        ContinuousRangeToNumericMap peMap = (ContinuousRangeToNumericMap)pe.getValueMap();
                        peMap.setLabelCount(axisMap.getLabelCount());
                        pe.setOutputMin(axisMap.getOutputMin());
                        pe.setOutputMax(axisMap.getOutputMax());
                    }
                } else {
                    pe = (PositionEncoder)this.axis[axisID].getEncoder(dim);
                }
                glv = (Vector)this.getComposite().A2GLV.get(this.axis[axisID]);
                if (glv != null) {
                    for (int j = 0; j < glv.size(); ++j) {
                        rgl = (VRectGridLines)glv.elementAt(j);
                        rgl.setEncoder(pe);
                        if (((VRectAxis)this.axis[axisID]).getTicks() != null) {
                            rgl.setTicks(((VRectAxis)this.axis[axisID]).getTicks());
                            rgl.setTickValuePriority(((VRectAxis)this.axis[axisID]).getTickValuePriority());
                            continue;
                        }
                        rgl.setTicks(null);
                    }
                }
            }
        } else if (this.rangeType[axisID] == 2) {
            dr = this.axis[axisID].getDataRange(this.axis[axisID].getDimension()) instanceof SimpleBinnedRange ? new SimpleBinnedRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension())) : new CustomBinnedRange(this.axis[axisID].getDataRange(this.axis[axisID].getDimension()));
            ((ContinuousRange)dr.getDual()).setMin(this.viewportMin[axisID]);
            ((ContinuousRange)dr.getDual()).setMax(this.viewportMax[axisID]);
            double[] ticks = VRectAxis.getBinTickList((BinnedRange)dr);
            if (this.axis[axisID] instanceof VRectAxis) {
                ((VRectAxis)this.axis[axisID]).setTicks(ticks);
            }
            this.userViewportParams[axisID].viewportTicks = ticks;
            this.axis[axisID].setUseRange(null, false);
            this.axis[axisID].setInputDataRange((DataRange)dr);
            glv = (Vector)this.getComposite().A2GLV.get(this.axis[axisID]);
            if (glv != null) {
                for (int j = 0; j < glv.size(); ++j) {
                    rgl = (VRectGridLines)glv.elementAt(j);
                    rgl.setTicks(ticks);
                }
            }
        } else if (this.rangeType[axisID] == 1) {
            PositionEncoder pe = (PositionEncoder)this.axis[axisID].getEncoder(dim);
            pe.setStartOffset(this.startOffset[axisID]);
            pe.setStrideOffset(this.strideOffset[axisID]);
            this.userViewportParams[axisID].startOffset = this.startOffset[axisID];
            this.userViewportParams[axisID].strideOffset = this.strideOffset[axisID];
            ((VRectAxis)this.axis[axisID]).setFitStrategy(null);
            ((VRectAxis)this.axis[axisID]).getVTKAxis().setForceFitAlgorithm(null);
            this.axis[axisID].setEncoder(dim, pe);
        }
        ArrayList overlays = this.getComposite().getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            ((Overlay)overlays.get(i)).updateNetwork();
        }
        this.resetting = false;
    }

    private void updateViewport() {
        ContinuousRangeToNumericMap map;
        int id;
        this.currentZoomPanStatus = -1;
        for (id = 0; id < 2; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0 || this.rangeType[id] == 2) {
                map = (ContinuousRangeToNumericMap)this.axis[id].getEncoder((byte)1).getValueMap();
                if (this.axis[id].isReverse()) {
                    this.viewportMax[id] = map.getInverseValue((double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x));
                    this.viewportMin[id] = map.getInverseValue((double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x + this.rubberband.width));
                } else {
                    this.viewportMin[id] = map.getInverseValue((double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x));
                    this.viewportMax[id] = map.getInverseValue((double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x + this.rubberband.width));
                }
            } else if (this.rangeType[id] == 1) {
                map = (StringToNumericMap)this.axis[id].getEncoder((byte)1).getValueMap();
                String[] values = map.getInverseValues((double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x), (double)(this.rubberband.x - this.getMargin().left - this.getComposite().innerRegion.x + this.rubberband.width));
                if (values != null && values.length > 0) {
                    int i;
                    for (i = 0; i < this.discreteValue[id].size(); ++i) {
                        if (!this.discreteValue[id].elementAt(i).equals(values[0])) continue;
                        this.viewportMin[id] = i;
                        break;
                    }
                    for (i = this.discreteValue[id].size() - 1; i >= 0; --i) {
                        if (!this.discreteValue[id].elementAt(i).equals(values[values.length - 1])) continue;
                        this.viewportMax[id] = i;
                        break;
                    }
                } else {
                    double first = Double.NaN;
                    try {
                        first = map.getValue(this.discreteValue[id].elementAt(0));
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    double last = Double.NaN;
                    try {
                        last = map.getValue(this.discreteValue[id].elementAt(this.discreteValue[id].size() - 1));
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    if (!Double.isNaN(first) && Double.isNaN(last)) {
                        this.viewportMax[id] = -1.0;
                        this.viewportMin[id] = -2.0;
                    } else if (Double.isNaN(first) && !Double.isNaN(last)) {
                        this.viewportMin[id] = this.discreteValue[id].size();
                        this.viewportMax[id] = this.discreteValue[id].size() + 1;
                    } else if (!Double.isNaN(first) && !Double.isNaN(last)) {
                        if ((double)(this.rubberband.x - this.getComposite().innerRegion.x) < first) {
                            this.viewportMax[id] = -1.0;
                            this.viewportMin[id] = -2.0;
                        } else {
                            this.viewportMin[id] = this.discreteValue[id].size();
                            this.viewportMax[id] = this.discreteValue[id].size() + 1;
                        }
                    } else if (this.viewportMin[id] < 0.0) {
                        this.viewportMax[id] = -1.0;
                        this.viewportMin[id] = -2.0;
                    } else {
                        this.viewportMin[id] = this.discreteValue[id].size();
                        this.viewportMax[id] = this.discreteValue[id].size() + 1;
                    }
                }
            }
            this.setViewport(id);
        }
        for (id = 2; id < 4; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0) {
                map = (ContinuousRangeToNumericMap)this.axis[id].getEncoder((byte)2).getValueMap();
                if (this.axis[id].isReverse()) {
                    this.viewportMin[id] = this.dataMin[id] + this.dataMax[id] - map.getInverseValue((double)(this.rubberband.y - this.getMargin().top - this.getComposite().innerRegion.y));
                    this.viewportMax[id] = this.dataMin[id] + this.dataMax[id] - map.getInverseValue((double)(this.rubberband.y - this.getMargin().top - this.getComposite().innerRegion.y + this.rubberband.height));
                } else {
                    this.viewportMax[id] = this.dataMin[id] + this.dataMax[id] - map.getInverseValue((double)(this.rubberband.y - this.getMargin().top - this.getComposite().innerRegion.y));
                    this.viewportMin[id] = this.dataMin[id] + this.dataMax[id] - map.getInverseValue((double)(this.rubberband.y - this.getMargin().top - this.getComposite().innerRegion.y + this.rubberband.height));
                }
            } else if (this.rangeType[id] == 1) {
                int y2;
                int y1;
                map = (StringToNumericMap)this.axis[id].getEncoder((byte)2).getValueMap();
                String[] values = map.getInverseValues((double)(y1 = (y2 = this.getComposite().innerRegion.height - (this.rubberband.y - this.getComposite().innerRegion.y)) - this.rubberband.height), (double)y2);
                if (values != null && values.length > 0) {
                    int i;
                    for (i = 0; i < this.discreteValue[id].size(); ++i) {
                        if (!this.discreteValue[id].elementAt(i).equals(values[0])) continue;
                        this.viewportMin[id] = i;
                        break;
                    }
                    for (i = this.discreteValue[id].size() - 1; i >= 0; --i) {
                        if (!this.discreteValue[id].elementAt(i).equals(values[values.length - 1])) continue;
                        this.viewportMax[id] = i;
                        break;
                    }
                } else {
                    double first = Double.NaN;
                    try {
                        first = map.getValue(this.discreteValue[id].elementAt(0));
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    double last = Double.NaN;
                    try {
                        last = map.getValue(this.discreteValue[id].elementAt(this.discreteValue[id].size() - 1));
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    if (!Double.isNaN(first) && Double.isNaN(last)) {
                        this.viewportMax[id] = -1.0;
                        this.viewportMin[id] = -2.0;
                    } else if (Double.isNaN(first) && !Double.isNaN(last)) {
                        this.viewportMin[id] = this.discreteValue[id].size();
                        this.viewportMax[id] = this.discreteValue[id].size() + 1;
                    } else if (!Double.isNaN(first) && !Double.isNaN(last)) {
                        if ((double)y2 < first) {
                            this.viewportMax[id] = -1.0;
                            this.viewportMin[id] = -2.0;
                        } else {
                            this.viewportMin[id] = this.discreteValue[id].size();
                            this.viewportMax[id] = this.discreteValue[id].size() + 1;
                        }
                    } else if (this.viewportMin[id] < 0.0) {
                        this.viewportMax[id] = -1.0;
                        this.viewportMin[id] = -2.0;
                    } else {
                        this.viewportMin[id] = this.discreteValue[id].size();
                        this.viewportMax[id] = this.discreteValue[id].size() + 1;
                    }
                }
            }
            this.setViewport(id);
        }
        this.fireViewportEvent();
        OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
    }

    protected void dragRubberband(Point pt, boolean sel) {
        if (!sel && !this.isViewportEnabled()) {
            return;
        }
        if (Math.abs(pt.x - this.prevx) < 5 || Math.abs(pt.y - this.prevy) < 5) {
            return;
        }
        if (this.rubberband == null) {
            this.rubberband = new Rectangle();
        }
        if (this.rubberband != null) {
            int y2;
            int y1;
            int x2;
            int x1;
            Graphics g = this.getGraphics();
            if (this.dragged) {
                g.setColor(Color.black);
                g.setXORMode(Color.white);
                g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
            }
            if (sel || this.viewporting[0]) {
                x1 = Math.min(this.prevx, pt.x);
                x2 = Math.max(this.prevx, pt.x);
                x1 = Math.max(x1, this.getComposite().innerRegion.x + this.getMargin().left);
                x2 = Math.min(x2, this.getComposite().innerRegion.x + this.getComposite().innerRegion.width + this.getMargin().left);
            } else {
                x1 = this.getComposite().innerRegion.x + this.getMargin().left;
                x2 = this.getComposite().innerRegion.x + this.getComposite().innerRegion.width + this.getMargin().left;
            }
            if (sel || this.viewporting[2]) {
                y1 = Math.min(this.prevy, pt.y);
                y2 = Math.max(this.prevy, pt.y);
                y1 = Math.max(y1, this.getComposite().innerRegion.y + this.getMargin().top);
                y2 = Math.min(y2, this.getComposite().innerRegion.y + this.getComposite().innerRegion.height + this.getMargin().top);
            } else {
                y1 = this.getComposite().innerRegion.y + this.getMargin().top;
                y2 = this.getComposite().innerRegion.y + this.getComposite().innerRegion.height + this.getMargin().top;
            }
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
            g.dispose();
            this.dragged = true;
        }
    }

    private void computeAxisArea() {
        int wd;
        int ht;
        if (!this.updateAxisArea) {
            return;
        }
        Channel ch = this.getComposite().getChannel();
        if (this.axis[0] != null && ((VRectAxis)this.axis[0]).getVTKAxis() != null) {
            ht = (int)((VRectAxis)this.axis[0]).getVTKAxis().getMetrics(ch).getOutsideLength();
            if (this.axisArea[0] == null) {
                this.axisArea[0] = new Rectangle();
            }
            this.axisArea[0].x = this.getComposite().outerRegion.x + this.getComposite().overlayMargin.left + this.getMargin().left;
            this.axisArea[0].width = this.getComposite().outerRegion.width - this.getComposite().overlayMargin.left - this.getComposite().overlayMargin.right;
            this.axisArea[0].y = this.getComposite().outerRegion.y + this.getComposite().outerRegion.height + this.getMargin().top;
            this.axisArea[0].height = ht;
            this.offsetMin[0] = this.getComposite().getInnerMargin().left;
            this.offsetMax[0] = this.getComposite().getInnerMargin().right;
        }
        if (this.axis[1] != null && ((VRectAxis)this.axis[1]).getVTKAxis() != null) {
            ht = (int)((VRectAxis)this.axis[1]).getVTKAxis().getMetrics(ch).getOutsideLength();
            if (this.axisArea[1] == null) {
                this.axisArea[1] = new Rectangle();
            }
            this.axisArea[1].x = this.getComposite().outerRegion.x + this.getComposite().overlayMargin.left + this.getMargin().left;
            this.axisArea[1].width = this.getComposite().outerRegion.width - this.getComposite().overlayMargin.left - this.getComposite().overlayMargin.right;
            this.axisArea[1].y = this.getComposite().outerRegion.y - ht + this.getMargin().top;
            this.axisArea[1].height = ht;
            this.offsetMin[1] = this.getComposite().getInnerMargin2().left;
            this.offsetMax[1] = this.getComposite().getInnerMargin2().right;
        }
        if (this.axis[2] != null && ((VRectAxis)this.axis[2]).getVTKAxis() != null) {
            wd = (int)((VRectAxis)this.axis[2]).getVTKAxis().getMetrics(ch).getOutsideLength();
            if (this.axisArea[2] == null) {
                this.axisArea[2] = new Rectangle();
            }
            this.axisArea[2].x = this.getComposite().outerRegion.x - wd + this.getMargin().left;
            this.axisArea[2].width = wd;
            this.axisArea[2].y = this.getComposite().outerRegion.y + this.getComposite().overlayMargin.top + this.getMargin().top;
            this.axisArea[2].height = this.getComposite().outerRegion.height - this.getComposite().overlayMargin.top - this.getComposite().overlayMargin.bottom;
            this.offsetMin[2] = this.getComposite().getInnerMargin().top;
            this.offsetMax[2] = this.getComposite().getInnerMargin().bottom;
        }
        if (this.axis[3] != null && ((VRectAxis)this.axis[3]).getVTKAxis() != null) {
            wd = (int)((VRectAxis)this.axis[3]).getVTKAxis().getMetrics(ch).getOutsideLength();
            if (this.axisArea[3] == null) {
                this.axisArea[3] = new Rectangle();
            }
            this.axisArea[3].x = this.getComposite().outerRegion.x + this.getComposite().outerRegion.width + this.getMargin().left;
            this.axisArea[3].width = wd;
            this.axisArea[3].y = this.getComposite().outerRegion.y + this.getComposite().overlayMargin.top + this.getMargin().top;
            this.axisArea[3].height = this.getComposite().outerRegion.height - this.getComposite().overlayMargin.top - this.getComposite().overlayMargin.bottom;
            this.offsetMin[3] = this.getComposite().getInnerMargin2().top;
            this.offsetMax[3] = this.getComposite().getInnerMargin2().bottom;
        }
        this.updateAxisArea = false;
    }

    private void getZoomPanInfo(int x, int y) {
        this.zoomPanAxisID = -1;
        this.mouseOnChart = false;
        if (!this.isViewportEnabled()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.viewporting[i] || this.axisArea[i] == null || !this.axisArea[i].contains(x, y)) continue;
            this.zoomPanAxisID = i;
            break;
        }
        if (this.zoomPanAxisID == -1 && this.getComposite().outerRegion.contains(x -= this.getMargin().left, y -= this.getMargin().top)) {
            this.mouseOnChart = true;
        }
    }

    private void setZoomPanCursor(int zoomPanStatus, boolean mouseDown) {
        Cursor zoomPanCursor = this.defaultCursor;
        if (this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1) {
            zoomPanCursor = zoomPanStatus == 0 ? (mouseDown ? panClosedLRCursor : panOpenLRCursor) : zoomLRCursor;
        } else if (this.zoomPanAxisID == 2 || this.zoomPanAxisID == 3) {
            zoomPanCursor = zoomPanStatus == 0 ? (mouseDown ? panClosedUDCursor : panOpenUDCursor) : zoomUDCursor;
        }
        this.setCursor(zoomPanCursor);
    }

    /*
     * Unable to fully structure code
     */
    protected void zoomPanGraph(Point pt, int zoomPanStatus, boolean sync) {
        block10: for (id = 0; id < 4; ++id) {
            if (this.axis[id] == null || this.axisArea[id] == null || !this.viewporting[id]) continue;
            zoomLimit = this.rangeType[id] == 1 ? 0.0 : (this.dataMax[id] - this.dataMin[id]) * 0.001;
            ratio = 0.0;
            dpix = 0.0;
            dval = 0.0;
            switch (id) {
                case 0: 
                case 1: {
                    ratio = (this.dataMax[id] - this.dataMin[id]) / (double)this.axisArea[id].width;
                    dpix = this.axis[id].isReverse() != false ? (double)(this.prevx - pt.x) : (double)(pt.x - this.prevx);
                    dval = dpix * ratio;
                    break;
                }
                case 2: 
                case 3: {
                    ratio = (this.dataMax[id] - this.dataMin[id]) / (double)this.axisArea[id].height;
                    dpix = this.axis[id].isReverse() != false ? (double)(this.prevy - pt.y) : (double)(pt.y - this.prevy);
                    dval = dpix * ratio;
                    break;
                }
            }
            if (this.rangeType[id] == 1) {
                this.accumulatedChange[id] = this.axis[id].isReverse() != false ? dpix : -dpix;
                pe = (PositionEncoder)this.axis[id].getEncoder(this.axis[id].getDimension());
                n = this.discreteValue[id].size();
                if (zoomPanStatus == 0) {
                    this.startOffset[id] = pe.getStartOffset() + this.accumulatedChange[id];
                    this.startOffset[id] = Math.min(this.startOffset[id], this.strideOffset[id] * 0.5);
                    this.startOffset[id] = Math.max(this.startOffset[id], this.strideOffset[id] * 0.5 - (double)n * this.strideOffset[id]);
                } else if (zoomPanStatus == 1) {
                    startOffsetChange = -this.accumulatedChange[id] * (double)n * this.zoomPoint;
                    if (pe.getStrideOffset() - this.accumulatedChange[id] >= 0.0) {
                        this.strideOffset[id] = pe.getStrideOffset() - this.accumulatedChange[id];
                        this.startOffset[id] = pe.getStrideOffset() - startOffsetChange;
                    }
                }
            } else if (dval == 0.0) continue;
            vrange = this.viewportMax[id] - this.viewportMin[id];
            switch (zoomPanStatus) {
                case 2: {
                    v0 = id;
                    this.viewportMin[v0] = this.viewportMin[v0] - dval;
                    this.viewportMin[id] = Math.min(this.viewportMin[id], this.viewportMax[id]);
                    ** GOTO lbl79
                }
                case 3: {
                    v1 = id;
                    this.viewportMax[v1] = this.viewportMax[v1] - dval;
                    this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    ** GOTO lbl79
                }
                case 1: {
                    this.zoomPoint = this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1 ? (double)(this.prevx - this.axisArea[id].x) / (double)this.axisArea[id].width : 1.0 - (double)(this.prevy - this.axisArea[id].y) / (double)this.axisArea[id].height;
                    if (this.zoomPoint < 0.05) {
                        if (vrange <= zoomLimit && dval < 0.0) continue block10;
                        v2 = id;
                        this.viewportMin[v2] = this.viewportMin[v2] - dval * (1.0 - this.zoomPoint);
                        this.viewportMin[id] = Math.min(this.viewportMin[id], this.viewportMax[id]);
                    } else if (this.zoomPoint > 0.95) {
                        if (vrange <= zoomLimit && dval > 0.0) continue block10;
                        v3 = id;
                        this.viewportMax[v3] = this.viewportMax[v3] - dval * this.zoomPoint;
                        this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    } else {
                        if (vrange <= zoomLimit && dval < 0.0) continue block10;
                        focusPoint = this.viewportMin[id] + this.zoomPoint * vrange;
                        this.viewportMin[id] = focusPoint - this.zoomPoint * (vrange += dval);
                        this.viewportMax[id] = focusPoint + (1.0 - this.zoomPoint) * vrange;
                        this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    }
                    this.viewportMin[id] = Math.max(this.viewportMin[id], this.dataMin[id]);
                    this.viewportMax[id] = Math.min(this.viewportMax[id], this.dataMax[id]);
                    ** GOTO lbl79
                }
                case 0: {
                    if (dval < 0.0) {
                        v4 = id;
                        this.viewportMin[v4] = this.viewportMin[v4] + dval;
                        this.viewportMin[id] = Math.max(this.viewportMin[id], this.dataMin[id]);
                        this.viewportMax[id] = this.viewportMin[id] + vrange;
                    } else {
                        v5 = id;
                        this.viewportMax[v5] = this.viewportMax[v5] + dval;
                        this.viewportMax[id] = Math.min(this.viewportMax[id], this.dataMax[id]);
                        this.viewportMin[id] = this.viewportMax[id] - vrange;
                    }
                }
lbl79:
                // 6 sources

                default: {
                    this.setViewport(id);
                }
            }
        }
        this.probe = null;
        this.dirty = true;
        this.repaint();
        this.prevx = pt.x;
        this.prevy = pt.y;
        this.fireViewportEvent();
    }

    /*
     * Unable to fully structure code
     */
    private void zoomPanAxis(Point pt, int zoomPanStatus, boolean sync) {
        if (this.zoomPanAxisID == -1) {
            return;
        }
        if (sync) {
            if (this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1) {
                start = 0;
                end = 1;
            } else {
                start = 2;
                end = 3;
            }
        } else {
            start = end = this.zoomPanAxisID;
        }
        block10: for (id = start; id <= end; ++id) {
            if (this.axis[id] == null || this.axisArea[id] == null) continue;
            zoomLimit = this.rangeType[id] == 1 ? 0.0 : (this.dataMax[id] - this.dataMin[id]) * 0.001;
            ratio = 0.0;
            dpix = 0.0;
            dval = 0.0;
            switch (id) {
                case 0: 
                case 1: {
                    ratio = (this.dataMax[id] - this.dataMin[id]) / (double)this.axisArea[id].width;
                    dpix = this.axis[id].isReverse() != false ? (double)(this.prevx - pt.x) : (double)(pt.x - this.prevx);
                    dval = -dpix * ratio;
                    break;
                }
                case 2: 
                case 3: {
                    ratio = (this.dataMax[id] - this.dataMin[id]) / (double)this.axisArea[id].height;
                    dpix = this.axis[id].isReverse() != false ? (double)(this.prevy - pt.y) : (double)(pt.y - this.prevy);
                    dval = dpix * ratio;
                    break;
                }
            }
            if (this.rangeType[id] == 1) {
                this.accumulatedChange[id] = this.axis[id].isReverse() != false ? dpix : -dpix;
                pe = (PositionEncoder)this.axis[id].getEncoder(this.axis[id].getDimension());
                n = this.discreteValue[id].size();
                if (zoomPanStatus == 0) {
                    this.startOffset[id] = pe.getStartOffset() + this.accumulatedChange[id];
                    this.startOffset[id] = Math.min(this.startOffset[id], this.strideOffset[id] * 0.5);
                    this.startOffset[id] = Math.max(this.startOffset[id], this.strideOffset[id] * 0.5 - (double)n * this.strideOffset[id]);
                } else if (this.currentZoomPanStatus == 1) {
                    startOffsetChange = -this.accumulatedChange[id] * (double)n * this.zoomPoint;
                    if (pe.getStrideOffset() - this.accumulatedChange[id] >= 0.0) {
                        this.strideOffset[id] = pe.getStrideOffset() - this.accumulatedChange[id];
                        this.startOffset[id] = pe.getStartOffset() - startOffsetChange;
                    }
                }
            } else if (dval == 0.0) continue;
            vrange = this.viewportMax[id] - this.viewportMin[id];
            switch (zoomPanStatus) {
                case 2: {
                    v0 = id;
                    this.viewportMin[v0] = this.viewportMin[v0] - dval;
                    this.viewportMin[id] = Math.min(this.viewportMin[id], this.viewportMax[id]);
                    ** GOTO lbl89
                }
                case 3: {
                    v1 = id;
                    this.viewportMax[v1] = this.viewportMax[v1] - dval;
                    this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    ** GOTO lbl89
                }
                case 1: {
                    if (this.zoomPoint < 0.05) {
                        if (vrange <= zoomLimit && dval < 0.0) continue block10;
                        v2 = id;
                        this.viewportMin[v2] = this.viewportMin[v2] - dval * (1.0 - this.zoomPoint);
                        this.viewportMin[id] = Math.min(this.viewportMin[id], this.viewportMax[id]);
                    } else if (this.zoomPoint > 0.95) {
                        if (vrange <= zoomLimit && dval > 0.0) continue block10;
                        v3 = id;
                        this.viewportMax[v3] = this.viewportMax[v3] - dval * this.zoomPoint;
                        this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    } else {
                        if (vrange <= zoomLimit && dval < 0.0) continue block10;
                        focusPoint = this.viewportMin[id] + this.zoomPoint * vrange;
                        this.viewportMin[id] = focusPoint - this.zoomPoint * (vrange += dval);
                        this.viewportMax[id] = focusPoint + (1.0 - this.zoomPoint) * vrange;
                        this.viewportMax[id] = Math.max(this.viewportMax[id], this.viewportMin[id]);
                    }
                    this.viewportMin[id] = Math.max(this.viewportMin[id], this.dataMin[id]);
                    this.viewportMax[id] = Math.min(this.viewportMax[id], this.dataMax[id]);
                    ** GOTO lbl89
                }
                case 0: {
                    if (dval < 0.0) {
                        v4 = id;
                        this.viewportMin[v4] = this.viewportMin[v4] + dval;
                        this.viewportMin[id] = Math.max(this.viewportMin[id], this.dataMin[id]);
                        this.viewportMax[id] = this.viewportMin[id] + vrange;
                    } else {
                        v5 = id;
                        this.viewportMax[v5] = this.viewportMax[v5] + dval;
                        this.viewportMax[id] = Math.min(this.viewportMax[id], this.dataMax[id]);
                        this.viewportMin[id] = this.viewportMax[id] - vrange;
                    }
                }
lbl89:
                // 6 sources

                default: {
                    this.setViewport(id);
                }
            }
        }
        this.probe = null;
        this.dirty = true;
        this.repaint();
        this.prevx = pt.x;
        this.prevy = pt.y;
        this.fireViewportEvent();
        OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
        this.dragged = true;
    }

    protected void resetDefaultViewport() {
        this.resetViewport();
    }

    private void resetViewport() {
        this.resetting = true;
        this.currentZoomPanStatus = -1;
        this.getComposite().userOffsetMin = null;
        this.getComposite().userOffsetMax = null;
        if (this.zoomPanAxisID == -1) {
            for (int i = 0; i < 4; ++i) {
                this.viewportMin[i] = this.dataMin[i];
                this.viewportMax[i] = this.dataMax[i];
                this.startOffset[i] = 0.0;
                this.strideOffset[i] = 0.0;
                this.setViewport(i);
            }
        } else {
            int start = this.zoomPanAxisID;
            int end = this.zoomPanAxisID;
            if (this.zoomPanAxisID == 0 || this.zoomPanAxisID == 1) {
                if (this.sync_x) {
                    start = 0;
                    end = 1;
                }
            } else if (this.sync_y) {
                start = 2;
                end = 3;
            }
            for (int i = start; i <= end; ++i) {
                this.viewportMin[i] = this.dataMin[i];
                this.viewportMax[i] = this.dataMax[i];
                this.startOffset[i] = 0.0;
                this.strideOffset[i] = 0.0;
                this.setViewport(i);
            }
        }
        this.dirty = true;
        this.postZoomPanProcess(true);
        this.repaint();
        this.fireViewportEvent();
        OverlayContainer.setSelectedItemInPopUp(this.chartPopup, null);
    }

    private void setZoomFactor(double fac) {
        this.currentZoomPanStatus = -1;
        double scale = 100.0 / fac;
        for (int id = 0; id < 4; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            double drange = this.dataMax[id] - this.dataMin[id];
            double mid = 0.5 * (this.dataMin[id] + this.dataMax[id]);
            this.viewportMin[id] = mid - 0.5 * drange * scale;
            this.viewportMax[id] = mid + 0.5 * drange * scale;
            this.viewportMax[id] = Math.max(this.viewportMin[id], this.viewportMax[id]);
            if (this.rangeType[id] == 1) {
                int n = this.discreteValue[id].size();
                this.strideOffset[id] = this.strideValue[id] * (1.0 / scale - 1.0);
                this.startOffset[id] = -this.strideOffset[id] * (double)n * 0.5;
            }
            this.fireViewportEvent(id);
            this.setViewport(id);
        }
        this.dirty = true;
        this.postZoomPanProcess(false);
        this.repaint();
    }

    private void drawViewportIndicator(Graphics g) {
        int i;
        g.setColor(this.indicatorColor);
        int size = 15;
        for (i = 0; i < 2; ++i) {
            int y2;
            if (!this.isShowIndicator(i)) continue;
            int y1 = i == 0 ? (y2 = this.axisArea[i].y) : (y2 = this.axisArea[i].y + this.axisArea[i].height - size);
            g.fillRect(this.axisArea[i].x, y1, this.axisArea[i].width - 1, size);
        }
        for (i = 2; i < 4; ++i) {
            int x2;
            if (!this.isShowIndicator(i)) continue;
            int x1 = i == 2 ? (x2 = this.axisArea[i].x + this.axisArea[i].width - size) : (x2 = this.axisArea[i].x);
            g.fillRect(x1, this.axisArea[i].y, size, this.axisArea[i].height - 1);
        }
    }

    private boolean isShowIndicator(int axisID) {
        return this.zoomPanAxisID == axisID && this.viewporting[axisID] && this.axis[axisID] != null && this.axis[axisID].isVisible();
    }

    protected void bringUpPopupMenu(MouseEvent e) {
        if (!this.isViewportEnabled()) {
            return;
        }
        if (this.zoomPanAxisID != -1) {
            if (axisPopup == null) {
                axisPopup = OverlayContainer.createAxisPopupMenu();
            }
            if (axisListener != this) {
                OverlayContainer.removeListenerFromPopup(axisPopup, axisListener);
                OverlayContainer.addListenerToPopup(axisPopup, this);
                axisListener = this;
                if (axisPopup.getParent() != null && axisPopup.getParent() != this) {
                    axisPopup.getParent().remove(axisPopup);
                    this.add(axisPopup);
                }
            }
            axisPopup.show(e.getComponent(), e.getX(), e.getY());
        } else if (this.mouseOnChart) {
            if (this.chartPopup.getParent() != null && this.chartPopup.getParent() != this) {
                this.chartPopup.getParent().remove(this.chartPopup);
                this.add(this.chartPopup);
            }
            this.chartPopup.show(e.getComponent(), e.getX(), e.getY());
        }
        this.popupOn = true;
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListener == null) {
            this.selectionListener = new ArrayList();
        }
        if (l != null && !this.selectionListener.contains(l)) {
            this.selectionListener.add(l);
        }
    }

    public void removeSelectionListener(SelectionListener l) {
        if (this.selectionListener == null) {
            return;
        }
        if (l != null && this.selectionListener.contains(l)) {
            this.selectionListener.remove(l);
        }
    }

    protected void updateSelection(ArrayList prList, boolean extended) {
        if (!extended) {
            this.unselectedAll();
        }
        if (prList == null || prList.size() < 1) {
            return;
        }
        int size = prList.size();
        for (int i = 0; i < prList.size(); ++i) {
            ProbeResult[] pr = (ProbeResult[])prList.get(i);
            Overlay ov = (Overlay)pr[0].getElement();
            if (ov.isHighlight()) continue;
            --size;
        }
        Object[] overlays = new Object[size];
        int[][] currObs = new int[size][];
        int idx = 0;
        for (int i = 0; i < prList.size(); ++i) {
            ProbeResult[] pr = (ProbeResult[])prList.get(i);
            Overlay ov = (Overlay)pr[0].getElement();
            if (!ov.isHighlight()) continue;
            int[] prevObs = ov.getSelection();
            if (extended && prevObs != null) {
                int j;
                int prevSize = prevObs.length;
                int[] newObs = this.getProbeableObs(ov, pr);
                int selSize = newObs.length;
                block2: for (int j2 = 0; j2 < newObs.length; ++j2) {
                    for (int k = 0; k < prevObs.length; ++k) {
                        if (prevObs[k] != newObs[j2]) continue;
                        prevObs[k] = -1;
                        --prevSize;
                        newObs[j2] = -1;
                        --selSize;
                        continue block2;
                    }
                }
                currObs[idx] = new int[prevSize + selSize];
                int ii = 0;
                for (j = 0; j < prevObs.length; ++j) {
                    if (prevObs[j] < 0) continue;
                    currObs[idx][ii] = prevObs[j];
                    ++ii;
                }
                for (j = 0; j < newObs.length; ++j) {
                    if (newObs[j] < 0) continue;
                    currObs[idx][ii] = newObs[j];
                    ++ii;
                }
                ov.setSelection(currObs[idx]);
            } else {
                currObs[idx] = this.getProbeableObs(ov, pr);
                ov.setSelection(currObs[idx]);
            }
            overlays[idx] = ov.getID();
            ++idx;
        }
        this.fireSelectionEvent(new SelectionEvent(overlays, currObs));
    }

    private int[] getProbeableObs(Overlay overlay, ProbeResult[] pr) {
        ArrayList<ProbeResult> al = new ArrayList<ProbeResult>();
        for (int i = 0; i < pr.length; ++i) {
            if (pr[i].getProbe() == null) continue;
            al.add(pr[i]);
        }
        int[] obs = new int[al.size()];
        for (int i = 0; i < obs.length; ++i) {
            obs[i] = ((ProbeResult)al.get(i)).getRow();
        }
        return obs;
    }

    protected void updateSelection(ProbeResult pr, boolean extended) {
        if (!extended) {
            this.unselectedAll();
        }
        if (pr == null) {
            return;
        }
        Overlay ov = (Overlay)pr.getElement();
        if (!ov.isHighlight()) {
            return;
        }
        int[] currObs = ov.getSelection();
        if (extended && currObs != null) {
            int exclude = -1;
            for (int i = 0; i < currObs.length; ++i) {
                if (currObs[i] != pr.getRow()) continue;
                exclude = i;
            }
            if (exclude >= 0) {
                int i;
                int[] obs = new int[currObs.length - 1];
                int idx = 0;
                for (i = 0; i < exclude; ++i) {
                    obs[idx] = currObs[i];
                    ++idx;
                }
                for (i = exclude + 1; i < currObs.length; ++i) {
                    obs[idx] = currObs[i];
                    ++idx;
                }
                currObs = obs;
            } else {
                int[] obs = new int[currObs.length + 1];
                int idx = 0;
                for (int i = 0; i < currObs.length; ++i) {
                    obs[idx] = currObs[i];
                    ++idx;
                }
                obs[idx] = pr.getRow();
                currObs = obs;
            }
        } else {
            currObs = new int[]{pr.getRow()};
        }
        ov.setSelection(currObs);
        this.fireSelectionEvent(new SelectionEvent(ov.getID(), currObs));
    }

    protected void unselectedAll() {
        int onum = this.getComposite().overlays.size();
        for (int i = 0; i < onum; ++i) {
            ((Overlay)this.getComposite().overlays.get(i)).setSelection(null);
        }
        this.fireSelectionEvent(null);
    }

    private void fireSelectionEvent(SelectionEvent evt) {
        if (this.selectionListener == null) {
            return;
        }
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            ((SelectionListener)this.selectionListener.get(i)).selectionPerformed(evt);
        }
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent evt) {
        return new Point(evt.getX(), evt.getY() + 30);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setBackground(new Color(255, 255, 225));
        toolTip.setForeground(Color.black);
        if (StatGraph.useFontManager) {
            toolTip.setFont(FontManager.getFont((String)"Arial", (int)1, (int)12));
        } else {
            toolTip.setFont(new Font("Arial", 1, 12));
        }
        toolTip.setBorder(new LineBorder(Color.black, 1));
        return toolTip;
    }

    public static void loadCustomCursors() {
        Image image;
        URL url;
        Class<StatGraph> theClass = StatGraph.class;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (panOpenLRCursor == null) {
            url = theClass.getResource("sgchart/res/PanOpenLR.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            panOpenLRCursor = tk.createCustomCursor(image, new Point(5, 5), "MoveOpen");
        }
        if (panOpenUDCursor == null) {
            url = theClass.getResource("sgchart/res/PanOpenUD.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            panOpenUDCursor = tk.createCustomCursor(image, new Point(5, 5), "MoveClosed");
        }
        if (panClosedLRCursor == null) {
            url = theClass.getResource("sgchart/res/PanClosedLR.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            panClosedLRCursor = tk.createCustomCursor(image, new Point(5, 5), "MoveOpen");
        }
        if (panClosedUDCursor == null) {
            url = theClass.getResource("sgchart/res/PanClosedUD.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            panClosedUDCursor = tk.createCustomCursor(image, new Point(5, 5), "MoveClosed");
        }
        if (zoomLRCursor == null) {
            url = theClass.getResource("sgchart/res/ZoomLR.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            zoomLRCursor = tk.createCustomCursor(image, new Point(5, 5), "ZoomLR");
        }
        if (zoomUDCursor == null) {
            url = theClass.getResource("sgchart/res/ZoomUD.gif");
            image = Toolkit.getDefaultToolkit().getImage(url);
            zoomUDCursor = tk.createCustomCursor(image, new Point(5, 5), "zoomUD");
        }
    }

    public static Color computeShadedColor(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float fac = (double)hsb[2] > 0.5 ? 0.85f : 1.15f;
        Color newCol = Color.getHSBColor(hsb[0], hsb[1], Math.min(1.0f, hsb[2] * fac));
        Color shadedColor = new Color(newCol.getRed(), newCol.getGreen(), newCol.getBlue(), 100);
        return shadedColor;
    }

    public static JPopupMenu createAxisPopupMenu() {
        Locale currentLocale = Locale.getDefault();
        StatGraph.setSystemLocale();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "pan.txt"));
        mi.setMnemonic(80);
        mi.setActionCommand("Pan");
        mi.setSelected(true);
        menu.add(mi);
        mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "zoom.txt"));
        mi.setMnemonic(90);
        mi.setActionCommand("Zoom");
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem(RB.getStringResource(RB_KEY, "resetAxis.txt"));
        mi.setMnemonic(82);
        mi.setActionCommand("Reset");
        menu.add(mi);
        Locale.setDefault(currentLocale);
        return menu;
    }

    public static JPopupMenu createChartPopupMenu() {
        Locale currentLocale = Locale.getDefault();
        StatGraph.setSystemLocale();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "zoom150.txt"));
        mi.setActionCommand("150");
        menu.add(mi);
        mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "zoom200.txt"));
        mi.setActionCommand("200");
        menu.add(mi);
        mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "zoom250.txt"));
        mi.setActionCommand("250");
        menu.add(mi);
        mi = new JCheckBoxMenuItem(RB.getStringResource(RB_KEY, "zoom300.txt"));
        mi.setActionCommand("300");
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem(RB.getStringResource(RB_KEY, "resetAll.txt"));
        mi.setMnemonic(82);
        mi.setActionCommand("ResetAll");
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem(RB.getStringResource(RB_KEY, "copy.txt"));
        mi.setMnemonic(67);
        mi.setActionCommand("Copy");
        menu.add(mi);
        Locale.setDefault(currentLocale);
        return menu;
    }

    public static void addListenerToPopup(JPopupMenu popup, ActionListener listener) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            JMenuItem mi;
            if (!(popup.getComponent(i) instanceof JMenuItem) || (mi = (JMenuItem)popup.getComponent(i)).getActionCommand().equalsIgnoreCase("Copy") && mi.getActionListeners() != null && mi.getActionListeners().length > 0) continue;
            mi.addActionListener(listener);
        }
    }

    public static void removeListenerFromPopup(JPopupMenu popup, ActionListener listener) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(popup.getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)popup.getComponent(i);
            mi.removeActionListener(listener);
        }
    }

    public static void setSelectedItemInPopUp(JPopupMenu popup, JMenuItem item) {
        if (popup == null) {
            return;
        }
        int count = popup.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!(popup.getComponent(i) instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)popup.getComponent(i);
            if (mi == item) {
                mi.setSelected(true);
                continue;
            }
            mi.setSelected(false);
        }
    }

    public static int getCurrentZoomPanStatus() {
        int status = keyCode == 16 ? 0 : (keyCode == 17 ? 1 : zoomPanStatus);
        return status;
    }

    public void setChartPopupMenu(JPopupMenu m) {
        this.chartPopup = m;
    }

    private Component getStatGraphPanel() {
        Container comp;
        for (comp = this.getParent(); comp != null && !(comp instanceof StatGraphPanel); comp = comp.getParent()) {
        }
        return comp;
    }

    public void preZoomPanProcess(boolean propagate) {
        if (this.getComposite().hasCurveLabels()) {
            this.getComposite().setCurveLabelsOn(false);
        }
        ArrayList ovs = this.getComposite().getOverlays();
        for (int i = 0; i < ovs.size(); ++i) {
            ((Overlay)ovs.get(i)).unsetDataSkin();
        }
        if (!propagate) {
            return;
        }
        if (this.viewportListener != null) {
            for (ViewportListener listener : this.viewportListener.keySet()) {
                if (!(listener instanceof OverlayContainer)) continue;
                ((OverlayContainer)listener).preZoomPanProcess(false);
            }
        }
    }

    public void postZoomPanProcess(boolean propagate) {
        int i;
        if (this.getComposite().hasCurveLabels()) {
            this.getComposite().setCurveLabelsOn(true);
            ArrayList overlays = this.getComposite().getOverlays();
            for (i = 0; overlays != null && i < overlays.size(); ++i) {
                ((Overlay)overlays.get(i)).updateCurveLabelElements();
            }
        }
        ArrayList ovs = this.getComposite().getOverlays();
        for (i = 0; i < ovs.size(); ++i) {
            ((Overlay)ovs.get(i)).resetDataSkin();
        }
        this.getComposite().resize();
        this.updateAxisArea = true;
        this.dirty = true;
        if (this.mlList.count() > 0) {
            MarginChangeEvent mce = new MarginChangeEvent((Object)this);
            this.mlList.marginChanged(mce);
            this.invalidate();
        }
        if (!propagate) {
            return;
        }
        if (this.viewportListener != null) {
            for (ViewportListener listener : this.viewportListener.keySet()) {
                if (!(listener instanceof OverlayContainer)) continue;
                ((OverlayContainer)listener).postZoomPanProcess(false);
            }
        }
    }

    protected VRectAxis getRectAxisAt(int x, int y) {
        if (this.updateAxisArea) {
            this.setRectAxis();
        }
        for (int i = 0; i < 4; ++i) {
            if (this.axisArea[i] == null || !this.axisArea[i].contains(x, y)) continue;
            return (VRectAxis)this.axis[i];
        }
        return null;
    }

    private void setRectAxis() {
        Object[] axes = this.getComposite().getAxes();
        for (int i = 0; i < axes.length; ++i) {
            AbstractAxis a = (AbstractAxis)axes[i];
            if (a.getDimension() == 1) {
                if (a instanceof VRectAxis && ((VRectAxis)a).getPrimary()) {
                    this.axis[0] = a;
                    continue;
                }
                this.axis[1] = a;
                continue;
            }
            if (a.getDimension() != 2) continue;
            if (a instanceof VRectAxis && ((VRectAxis)a).getPrimary()) {
                this.axis[2] = a;
                continue;
            }
            this.axis[3] = a;
        }
        this.computeAxisArea();
        if (this.axis[0] instanceof VRectAxis) {
            Insets extent = ((VRectAxis)this.axis[0]).getLabelExtent();
            if (extent.left > 0 || extent.right > 0) {
                this.axisArea[0].grow((extent.left + extent.right) / 2, 0);
                this.axisArea[0].translate(-extent.left / 2 + extent.right / 2, 0);
            }
        }
        if (this.axis[1] instanceof VRectAxis) {
            Insets extent = ((VRectAxis)this.axis[1]).getLabelExtent();
            if (extent.left > 0 || extent.right > 0) {
                this.axisArea[1].grow((extent.left + extent.right) / 2, 0);
                this.axisArea[1].translate(-extent.left / 2 + extent.right / 2, 0);
            }
        }
        if (this.axis[2] instanceof VRectAxis) {
            Insets extent = ((VRectAxis)this.axis[2]).getLabelExtent();
            if (extent.top > 0 || extent.bottom > 0) {
                this.axisArea[2].grow(0, (extent.top + extent.bottom) / 2);
                this.axisArea[2].translate(0, -extent.top / 2 + extent.bottom / 2);
            }
        }
        if (this.axis[3] instanceof VRectAxis) {
            Insets extent = ((VRectAxis)this.axis[3]).getLabelExtent();
            if (extent.top > 0 || extent.bottom > 0) {
                this.axisArea[3].grow(0, (extent.top + extent.bottom) / 2);
                this.axisArea[3].translate(0, -extent.top / 2 + extent.bottom / 2);
            }
        }
    }

    public Rectangle getAxisArea(int axisType) {
        if (this.updateAxisArea) {
            this.setRectAxis();
        }
        return this.axisArea[axisType];
    }

    public void hideAllPointLabels() {
        this.getComposite().hideAllPointLabels();
    }

    public void showAllPointLabels() {
        this.getComposite().showAllPointLabels();
    }

    public void hidePointLabels(Overlay overlay, int[] indices) {
        overlay.hidePointLabels(indices);
    }

    public void layoutPointLabels() {
        this.layoutPointLabels(false);
    }

    public void layoutPointLabels(boolean relayout) {
        if (this.getComposite().getPointLabelLayoutManager() != null) {
            if (relayout) {
                this.getComposite().getPointLabelLayoutManager().initGraph();
            }
            this.dirty = true;
            this.repaint();
        }
    }

    public void setProbe(Probe probe) {
        this.probe = probe;
    }

    public UserViewportParams getUserViewportParams(int axisID) {
        return this.userViewportParams[axisID];
    }

    public void setUserViewportParams(UserViewportParams params, int axisID) {
        this.userViewportParams[axisID] = params;
        if (params.hasUserSetViewport()) {
            this.setUserViewport = true;
            this.setViewportEnabled(axisID, true);
        }
    }

    public void resetUserViewportParams() {
        for (int i = 0; i < 4; ++i) {
            if (this.userViewportParams[i] == null) continue;
            this.userViewportParams[i].reset();
        }
    }

    protected void zoomGraph(Point fromPt, Point toPt, boolean sync) {
        Rectangle r = this.getComposite().getInnerRegion();
        double[] zoom = new double[]{this.getMaxZoomForX() * 0.1 * (toPt.getX() - fromPt.getX()) / (double)r.width, this.getMaxZoomForY() * 0.1 * (fromPt.getY() - toPt.getY()) / (double)r.height};
        double xfactor = this.getViewZoomFactor(0);
        double yfactor = this.getViewZoomFactor(2);
        double adjXZoom = Math.max(100.0, xfactor + 100.0 * zoom[0]);
        double adjYZoom = Math.max(100.0, yfactor + 100.0 * zoom[1]);
        this.setViewZoomFactor(adjXZoom, adjYZoom, toPt, false);
    }

    protected void panGraph(Point fromPt, Point toPt, boolean stayInLimit) {
        Rectangle r = this.getComposite().getInnerRegion();
        double viewsize = 0.0;
        for (int id = 0; id < 4; ++id) {
            int dpix;
            double dval;
            if (this.axis[id] == null || this.axisArea[id] == null || !this.viewporting[id]) continue;
            double vrange = this.viewportMax[id] - this.viewportMin[id];
            switch (id) {
                case 0: 
                case 1: {
                    dval = (fromPt.getX() - toPt.getX()) * vrange / r.getWidth();
                    dpix = toPt.x - fromPt.x;
                    viewsize = r.width;
                    break;
                }
                case 2: 
                case 3: {
                    dval = (toPt.getY() - fromPt.getY()) * vrange / r.getHeight();
                    dpix = toPt.y - fromPt.y;
                    viewsize = r.getHeight();
                    break;
                }
                default: {
                    dval = 0.0;
                    dpix = 0;
                    viewsize = r.getWidth();
                }
            }
            if (this.rangeType[id] == 1) {
                this.accumulatedChange[id] = this.axis[id].isReverse() ? (double)(-dpix) : (double)dpix;
                PositionEncoder pe = (PositionEncoder)this.axis[id].getEncoder(this.axis[id].getDimension());
                int n = this.discreteValue[id].size();
                this.startOffset[id] = pe.getStartOffset() + this.accumulatedChange[id];
                if (stayInLimit) {
                    this.startOffset[id] = Math.min(this.startOffset[id], 0.0);
                    double offset = viewsize - this.strideValue[id] * (double)n;
                    this.startOffset[id] = Math.max(this.startOffset[id], viewsize - (this.strideValue[id] + this.strideOffset[id]) * (double)n - offset);
                }
            } else {
                this.viewportMin[id] = this.viewportMin[id] + dval;
                if (stayInLimit) {
                    this.viewportMin[id] = Math.max(this.dataMin[id], this.viewportMin[id]);
                    this.viewportMin[id] = Math.min(this.viewportMin[id], this.dataMax[id] - vrange);
                }
                this.viewportMax[id] = this.viewportMin[id] + vrange;
            }
            this.setViewport(id);
        }
        this.dirty = true;
        this.repaint();
        this.fireViewportEvent();
    }

    protected double getViewZoomFactor(int axisid) {
        double scale = 1000.0;
        for (int id = 0; id < 4; ++id) {
            if (axisid != -1 && ((id == 0 || id == 1) && (axisid == 2 || axisid == 3) || (axisid == 0 || axisid == 1) && (id == 2 || id == 3)) || this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 1) {
                scale = (this.strideOffset[id] + this.strideValue[id]) * 100.0 / this.strideValue[id];
                continue;
            }
            double drange = this.dataMax[id] - this.dataMin[id];
            double vrange = this.viewportMax[id] - this.viewportMin[id];
            scale = Math.min(drange * 100.0 / vrange, scale);
        }
        return scale;
    }

    protected void setViewZoomFactor(double xfac, double yfac, Point pt) {
        this.setViewZoomFactor(xfac, yfac, pt, true);
    }

    protected void setViewZoomFactor(double xfac, double yfac, Point pt, boolean postProcess) {
        this.currentZoomPanStatus = -1;
        double xscale = xfac / 100.0;
        double yscale = yfac / 100.0;
        Rectangle r = this.getComposite().innerRegion;
        for (int id = 0; id < 4; ++id) {
            double zoomPoint;
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            double scale = id == 0 || id == 1 ? xscale : yscale;
            double size = 1.0;
            double pixOffset = 0.0;
            if (id == 0 || id == 1) {
                size = r.getWidth();
                pixOffset = pt.getX() - r.getX();
                zoomPoint = pixOffset / size;
            } else {
                size = r.getHeight();
                pixOffset = pt.getY() - r.getY();
                zoomPoint = 1.0 - pixOffset / size;
            }
            if (this.rangeType[id] == 1) {
                int n = this.discreteValue[id].size();
                double offset = size - this.strideValue[id] * (double)n;
                double oldTotal = (this.strideValue[id] + this.strideOffset[id]) * (double)n + offset;
                double start = (this.startOffset[id] - pixOffset) / oldTotal;
                this.strideOffset[id] = Math.max(0.0, this.strideValue[id] * (scale - 1.0));
                double total = (this.strideValue[id] + this.strideOffset[id]) * (double)n + offset;
                this.startOffset[id] = start * total + pixOffset;
                this.startOffset[id] = Math.max(this.startOffset[id], -total + size);
                this.startOffset[id] = Math.min(this.startOffset[id], 0.0);
            } else {
                scale = 1.0 / scale;
                double drange = this.dataMax[id] - this.dataMin[id];
                double mid = this.viewportMin[id] + zoomPoint * (this.viewportMax[id] - this.viewportMin[id]);
                this.viewportMin[id] = mid - zoomPoint * drange * scale;
                this.viewportMin[id] = Math.max(this.dataMin[id], this.viewportMin[id]);
                this.viewportMin[id] = Math.min(this.viewportMin[id], this.dataMax[id] - drange * scale);
                this.viewportMax[id] = this.viewportMin[id] + drange * scale;
            }
            this.fireViewportEvent(id);
            this.setViewport(id);
        }
        this.dirty = true;
        if (postProcess) {
            this.postZoomPanProcess(false);
        }
        this.repaint();
    }

    protected void updateRubberBandViewport() {
        double rbnum;
        double rbmax;
        double rbmin;
        double vrange;
        int id;
        this.currentZoomPanStatus = -1;
        Point midPoint = new Point(this.rubberband.x + this.rubberband.width / 2, this.rubberband.y + this.rubberband.height / 2);
        Rectangle r = this.getComposite().innerRegion;
        double xscale = 1.0;
        double yscale = 1.0;
        for (id = 0; id < 2; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0 || this.rangeType[id] == 2) {
                vrange = this.viewportMax[id] - this.viewportMin[id];
                rbmin = this.viewportMin[id] + vrange * (this.rubberband.getX() - r.getX()) / r.getWidth();
                rbmax = rbmin + vrange * this.rubberband.getWidth() / r.getWidth();
                xscale = 100.0 * (this.dataMax[id] - this.dataMin[id]) / (rbmax - rbmin);
                break;
            }
            if (this.rangeType[id] != 1) continue;
            rbnum = this.rubberband.getWidth() / (this.strideValue[id] + this.strideOffset[id]);
            xscale = 100.0 * (double)this.discreteValue[id].size() / rbnum;
            break;
        }
        for (id = 2; id < 4; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0) {
                vrange = this.viewportMax[id] - this.viewportMin[id];
                rbmin = this.viewportMin[id] + vrange * (r.getY() + r.getHeight() - this.rubberband.getY() - this.rubberband.getHeight()) / r.getHeight();
                rbmax = this.viewportMin[id] + vrange * (r.getY() + r.getHeight() - this.rubberband.getY()) / r.getHeight();
                yscale = 100.0 * (this.dataMax[id] - this.dataMin[id]) / (rbmax - rbmin);
                break;
            }
            if (this.rangeType[id] != 1) continue;
            rbnum = this.rubberband.getHeight() / (this.strideValue[id] + this.strideOffset[id]);
            yscale = 100.0 * (double)this.discreteValue[id].size() / rbnum;
            break;
        }
        Point viewcenter = new Point(r.x + r.width / 2, r.y + r.height / 2);
        this.panGraph(midPoint, viewcenter, false);
        this.enableComputeIntervals = true;
        this.setViewZoomFactor(xscale, yscale, viewcenter);
    }

    public double getMaxZoomForX() {
        double coeff = 100.0;
        for (int id = 0; id < 2; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0 || this.rangeType[id] == 2) break;
            if (this.rangeType[id] != 1) continue;
            coeff = this.discreteValue[id].size();
            break;
        }
        return coeff;
    }

    public double getMaxZoomForY() {
        double coeff = 100.0;
        for (int id = 2; id < 4; ++id) {
            if (this.axis[id] == null || !this.viewporting[id]) continue;
            if (this.rangeType[id] == 0 || this.rangeType[id] == 2) break;
            if (this.rangeType[id] != 1) continue;
            coeff = this.discreteValue[id].size();
            break;
        }
        return coeff;
    }

    static {
        tipStartTime = -1L;
        tipText = null;
    }

    public class UserViewportParams {
        public double[] viewportTicks = null;
        public double viewportMin = Double.NaN;
        public double viewportMax = Double.NaN;
        public double startOffset = Double.NaN;
        public double strideOffset = Double.NaN;
        public double offsetMin = Double.NaN;
        public double offsetMax = Double.NaN;

        public boolean hasUserSetViewport(int type) {
            if (type == 1) {
                return !Double.isNaN(this.startOffset) && !Double.isNaN(this.strideOffset);
            }
            return !Double.isNaN(this.viewportMin) && !Double.isNaN(this.viewportMax);
        }

        public boolean hasUserSetViewport() {
            if (!Double.isNaN(this.startOffset) && !Double.isNaN(this.strideOffset)) {
                return true;
            }
            return !Double.isNaN(this.viewportMin) && !Double.isNaN(this.viewportMax);
        }

        public void reset() {
            this.viewportTicks = null;
            this.viewportMin = Double.NaN;
            this.viewportMax = Double.NaN;
            this.startOffset = Double.NaN;
            this.strideOffset = Double.NaN;
            this.offsetMin = Double.NaN;
            this.offsetMax = Double.NaN;
        }
    }
}

