/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.SizeAndSpace;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.CompositeComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayLayout;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple3DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.SimpleExtrudedOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellAlignmentInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.ExtrudedCellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridLabelInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListenerList;
import com.sas.graphics.applets.statgraph.sgchart.grid.OneDPlotInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;

public class BaseOverlayContainer
extends AbstractSGComponent
implements ExtrudedCellItemInterface,
MouseListener,
MouseMotionListener,
MarginListener,
AnnotationContainer,
OneDPlotInterface,
GridLabelInterface {
    private boolean axesVisible = true;
    protected CompositeComponent cc;
    protected MarginListenerList mlList = new MarginListenerList();
    OverlayLayout ol = new OverlayLayout();
    private boolean interactive = true;
    protected Image backbuffer;
    protected boolean dirty = true;
    private boolean ignoreMarginChange = false;
    boolean insetsPlaced = false;
    protected int prevx;
    protected int prevy;
    protected int currentx;
    int currenty;
    int currentrow;
    protected Probe probe;

    public BaseOverlayContainer(boolean view2D) {
        this(view2D, false, false);
    }

    public BaseOverlayContainer(boolean view2D, boolean softwareBuffered, boolean interactive) {
        this(view2D, softwareBuffered, interactive, false);
    }

    public BaseOverlayContainer(boolean view2D, boolean softwareBuffered, boolean interactive, boolean noComposite) {
        this.interactive = interactive;
        this.setLayout(this.ol);
        if (!noComposite) {
            this.cc = new CompositeComponent(view2D, softwareBuffered, interactive);
            this.ol.addLayoutComponent("Base", this.cc);
            this.add(this.cc);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setDoubleBuffered(false);
        this.setPreferredSize(new Dimension(2000, 2000));
        this.setMinimumSize(new Dimension(80, 60));
    }

    public boolean isGraphComposite() {
        return this.cc != null && this.cc.getComposite() != null && this.getLayout() instanceof OverlayLayout;
    }

    public boolean isGraphContained() {
        if (!this.isGraphComposite()) {
            return false;
        }
        return this.getComposite().getNumOverlays() > 0;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isGraphContained()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isGraphContained()) {
            return super.getPreferredSize();
        }
        int wLeft = 0;
        int wCenter = 0;
        int wRight = 0;
        int hTop = 0;
        int hCenter = 0;
        int hBottom = 0;
        Dimension d = new Dimension();
        for (int i = 0; i < this.ol.addOns.size(); ++i) {
            JComponent c = (JComponent)this.ol.addOns.get(i);
            Dimension pc = c.getPreferredSize();
            if (c.getAlignmentX() == 0.0f) {
                wLeft = Math.max(wLeft, pc.width);
            } else if (c.getAlignmentX() == 1.0f) {
                wRight = Math.max(wRight, pc.width);
            } else {
                wCenter = Math.max(wCenter, pc.width);
            }
            if (c.getAlignmentY() == 0.0f) {
                hTop = Math.max(hTop, pc.height);
                continue;
            }
            if (c.getAlignmentY() == 1.0f) {
                hBottom = Math.max(hBottom, pc.height);
                continue;
            }
            hCenter = Math.max(hCenter, pc.height);
        }
        int wExtra = 0;
        if (wCenter != 0 && (wLeft != 0 || wRight != 0)) {
            wExtra = (int)((double)Math.abs(wRight - wLeft) + 0.5);
        }
        d.width = wLeft + wCenter + wRight + wExtra;
        d.height = hTop + hCenter + hBottom;
        Insets in = this.getInsets();
        d.width += in.left + in.right;
        d.height += in.top + in.bottom;
        if (0 <= this.getUserWidth()) {
            d.width = this.getUserWidth();
        }
        if (0 <= this.getUserHeight()) {
            d.height = this.getUserHeight();
        }
        return d;
    }

    @Override
    public Component add(Component comp) {
        if (comp == this.cc) {
            return super.add(comp);
        }
        return this.add(comp, 0);
    }

    @Override
    public Component add(Component c, int index) {
        this.ol.addLayoutComponent("AddOn", c);
        return super.add(c, index);
    }

    public Component add(Component c, int index, String name) {
        this.ol.addLayoutComponent(name, c);
        return super.add(c, index);
    }

    public int getTitleCount() {
        return this.ol.titles.size();
    }

    public Component getTitle(int i) {
        return (Component)this.ol.titles.get(i);
    }

    public Component addTitle(Component c) {
        this.ol.addLayoutComponent("Title", c);
        return super.add(c, 0);
    }

    public int getFootnoteCount() {
        return this.ol.footnotes.size();
    }

    public Component getFootnote(int i) {
        return (Component)this.ol.footnotes.get(i);
    }

    public Component addFootnote(Component c) {
        this.ol.addLayoutComponent("Footnote", c);
        return super.add(c, 0);
    }

    public int getLegendCount() {
        return this.ol.legends.size();
    }

    public Component getLegend(int i) {
        return (Component)this.ol.legends.get(i);
    }

    public Component addLegend(Component c) {
        this.ol.addLayoutComponent("Legend", c);
        return super.add(c, 0);
    }

    public void removeLegend(Component c) {
        this.ol.removeLayoutComponent("Legend", c);
        super.remove(c);
    }

    public Component addSidebar(Component c) {
        this.ol.addLayoutComponent("Sidebar", c);
        return super.add(c, 0);
    }

    public void removeSidebar(Component c) {
        this.ol.removeLayoutComponent("Sidebar", c);
        super.remove(c);
    }

    public Component addGlobalLegend(Component c, String position) {
        this.ol.addLayoutComponent("GlobalLegend", c);
        this.ol.globalLegendPosition = position;
        return super.add(c, 0);
    }

    public void removeGlobalLegend(Component c) {
        this.ol.removeLayoutComponent("GlobalLegend", c);
        super.remove(c);
    }

    public String getLayoutComponentName(Component comp) {
        return this.ol.getLayoutComponentName(comp);
    }

    @Override
    public void remove(Component comp) {
        String name = this.ol.getLayoutComponentName(comp);
        this.ol.removeLayoutComponent(name, comp);
        super.remove(comp);
    }

    public CompositeComponent getBaseComponent() {
        return this.cc;
    }

    public Insets getPreferredInnerMargin() {
        if (this.isGraphComposite()) {
            return this.getComposite().getPreferredInnerMargin();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Insets getPreferredOuterMargin() {
        Insets borderInsets = this.getInsets();
        OverlayLayout layout = (OverlayLayout)this.getLayout();
        Insets si = layout.getSurroundingInsets();
        borderInsets.left += si.left;
        borderInsets.right += si.right;
        borderInsets.top += si.top;
        borderInsets.bottom += si.bottom;
        if (this.isGraphComposite()) {
            Insets prefOuter = this.getComposite().getPreferredOuterMargin();
            return new Insets(prefOuter.top + borderInsets.top, prefOuter.left + borderInsets.left, prefOuter.bottom + borderInsets.bottom, prefOuter.right + borderInsets.right);
        }
        return borderInsets;
    }

    public void setInnerMargin(Insets margin) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.isGraphComposite()) {
            this.getComposite().setInnerMargin(margin);
            Container parent = this.getParent();
            if (parent instanceof TrellisPlot && ((TrellisPlot)parent).isFinalLayout()) {
                this.getComposite().updateEncoders();
                return;
            }
            if (this.mlList.count() > 0) {
                Insets old_om = this.getComposite().getPreferredOuterMargin();
                Insets old_im = this.getComposite().getPreferredInnerMargin();
                this.getComposite().updateEncoders();
                this.getComposite().updatePrefs();
                this.getComposite().updateEncoders();
                if (!this.getComposite().getPreferredOuterMargin().equals(old_om) || !this.getComposite().getPreferredInnerMargin().equals(old_im)) {
                    this.mlList.marginChanged(new MarginChangeEvent((Object)this));
                }
            }
        }
    }

    public void setOuterMargin(Insets margin) {
        if (this.isGraphComposite()) {
            Insets borderInsets = this.getInsets();
            OverlayLayout layout = (OverlayLayout)this.getLayout();
            Insets si = layout.getSurroundingInsets();
            margin.left -= si.left;
            margin.right -= si.right;
            margin.top -= si.top;
            margin.bottom -= si.bottom;
            Insets m = new Insets(margin.top - borderInsets.top, margin.left - borderInsets.left, margin.bottom - borderInsets.bottom, margin.right - borderInsets.right);
            Insets m_old = this.getComposite().getOuterMargin();
            this.getComposite().setOuterMargin(m);
            if (!(m.equals(m_old) || layout.addOns.size() <= 0 && layout.legends.size() <= 0 && layout.sidebars.size() <= 0)) {
                this.doLayout();
            }
        }
    }

    public Insets getPreferredInnerMargin2() {
        if (this.isGraphComposite()) {
            return this.getComposite().getPreferredInnerMargin2();
        }
        return new Insets(0, 0, 0, 0);
    }

    public void setInnerMargin2(Insets margin) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.isGraphComposite()) {
            this.getComposite().setInnerMargin2(margin);
            Container parent = this.getParent();
            if (parent instanceof TrellisPlot && ((TrellisPlot)parent).isFinalLayout()) {
                this.getComposite().updateEncoders();
                return;
            }
            if (this.mlList.count() > 0) {
                Insets old_om = this.getComposite().getPreferredOuterMargin();
                Insets old_im = this.getComposite().getPreferredInnerMargin2();
                this.getComposite().updateEncoders();
                this.getComposite().updatePrefs();
                this.getComposite().updateEncoders();
                if (!this.getComposite().getPreferredOuterMargin().equals(old_om) || !this.getComposite().getPreferredInnerMargin2().equals(old_im)) {
                    this.mlList.marginChanged(new MarginChangeEvent((Object)this));
                }
            }
        }
    }

    public Insets getInnerMargin2() {
        if (this.isGraphComposite()) {
            return this.getComposite().getInnerMargin2();
        }
        return new Insets(0, 0, 0, 0);
    }

    public void setInnerMargins(Insets margin, Insets margin2) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.isGraphComposite()) {
            this.getComposite().setInnerMargin(margin, margin2);
            Container parent = this.getParent();
            if (parent instanceof TrellisPlot && ((TrellisPlot)parent).isFinalLayout()) {
                this.getComposite().updateEncoders();
                return;
            }
            if (this.mlList.count() > 0) {
                Insets old_om = this.getComposite().getPreferredOuterMargin();
                Insets old_im = this.getComposite().getPreferredInnerMargin();
                Insets old_im2 = this.getComposite().getPreferredInnerMargin2();
                this.getComposite().updateEncoders();
                this.getComposite().updatePrefs();
                this.getComposite().updateEncoders();
                if (!(this.getComposite().getPreferredOuterMargin().equals(old_om) && this.getComposite().getPreferredInnerMargin().equals(old_im) && this.getComposite().getPreferredInnerMargin2().equals(old_im2))) {
                    this.mlList.marginChanged(new MarginChangeEvent((Object)this));
                }
            }
        }
    }

    public void addMarginListener(MarginListener listener) {
        if (this.isGraphComposite()) {
            this.mlList.add(listener);
            this.getComposite().setMarginChangeListened(true);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        this.mlList.remove(listener);
    }

    public int getNumRanges(byte dim) {
        if (!this.isGraphComposite()) {
            return 0;
        }
        Object[] axes = this.getComposite().getAxes();
        int count = 0;
        for (int i = 0; i < axes.length; ++i) {
            AbstractAxis a = (AbstractAxis)axes[i];
            if (a.getDimension() != dim) continue;
            ++count;
        }
        return count;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        if (!this.isGraphComposite()) {
            return null;
        }
        Object[] axes = this.getComposite().getAxes();
        int cnt = 0;
        for (int i = 0; i < axes.length; ++i) {
            AbstractAxis a = (AbstractAxis)axes[i];
            if (a.getDimension() != dim) continue;
            if (cnt == index) {
                return this.getComposite().getInputRange(a);
            }
            ++cnt;
        }
        return null;
    }

    public DataRangeInterface getRangeSource(byte dim, boolean primary) {
        if (!this.isGraphComposite()) {
            return null;
        }
        Object[] axes = this.getComposite().getAxes();
        for (int i = 0; i < axes.length; ++i) {
            VRectAxis a = (VRectAxis)axes[i];
            if (a.getDimension() != dim || a.getPrimary() != primary) continue;
            return this.getComposite().getInputRange(a);
        }
        return null;
    }

    public Simple2DOverlayComposite getComposite() {
        if (this.cc == null) {
            return null;
        }
        return this.cc.getComposite();
    }

    public void setComposite(Simple2DOverlayComposite c) {
        c.setAxesVisible(this.axesVisible);
        if (this.cc != null) {
            this.cc.setComposite(c);
        }
        c.addMarginListener(this);
    }

    public void setAxesVisible(boolean axesVisible) {
        this.axesVisible = axesVisible;
        if (this.isGraphComposite()) {
            this.getComposite().setAxesVisible(axesVisible);
        }
    }

    public boolean getAxesVisible() {
        return this.axesVisible;
    }

    public Insets getInnerMargin() {
        if (this.isGraphComposite()) {
            return this.getComposite().getInnerMargin();
        }
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getBaseOuterMargin() {
        Insets border = this.getInsets();
        if (this.isGraphComposite()) {
            Insets om = this.getComposite().getOuterMargin();
            return new Insets(border.top + om.top, border.left + om.left, border.bottom + om.bottom, border.right + om.right);
        }
        return border;
    }

    public Insets getOuterMargin() {
        Insets om = this.getBaseOuterMargin();
        OverlayLayout layout = (OverlayLayout)this.getLayout();
        Insets si = layout.getSurroundingInsets();
        om.left += si.left;
        om.right += si.right;
        om.top += si.top;
        om.bottom += si.bottom;
        return om;
    }

    public Dimension getPreferredDataAreaSize() {
        return this.getPreferredDataAreaSize(true);
    }

    public Dimension getPreferredDataAreaSize(boolean doSetBounds) {
        int h;
        int w;
        Container parent = this.getParent();
        Dimension rs = parent.getSize();
        if (rs.width == 0 && rs.height == 0) {
            if (parent.getParent() != null) {
                rs = parent.getParent().getSize();
                rs.width = (int)((double)rs.width * 0.875);
                rs.height = (int)((double)rs.height * 0.875);
            }
            return rs;
        }
        Insets pi = parent.getInsets();
        rs.width -= pi.left + pi.right;
        rs.height -= pi.top + pi.bottom;
        Insets insets = this.getInsets();
        if (!this.isGraphComposite()) {
            return new Dimension(rs.width - insets.left - insets.right, rs.height - insets.top - insets.bottom);
        }
        Simple2DOverlayComposite oc = this.getComposite();
        if (doSetBounds) {
            this.ignoreMarginChange = oc.getSquareFormat() != Simple2DOverlayComposite.EQUATED_NONE;
            oc.setBounds(0, 0, rs.width, rs.height, rs.height);
            this.ignoreMarginChange = false;
        }
        Insets om = oc.getPreferredOuterMargin();
        if (oc.getAxesVisible()) {
            w = rs.width - om.left - om.right - 4 - insets.left - insets.right;
            h = rs.height - om.top - om.bottom - 10 - insets.top - insets.bottom;
        } else {
            w = rs.width - om.left - om.right - insets.left - insets.right;
            h = rs.height - om.top - om.bottom - insets.top - insets.bottom;
        }
        return new Dimension(w, h);
    }

    public void setRange(byte dim, int index, DataRange range) {
        if (!this.isGraphComposite()) {
            return;
        }
        Object[] axes = this.getComposite().getAxes();
        AbstractAxis target = null;
        int cnt = 0;
        for (int i = 0; i < axes.length; ++i) {
            AbstractAxis a = (AbstractAxis)axes[i];
            if (a.getDimension() != dim) continue;
            if (index == cnt) {
                target = a;
                break;
            }
            ++cnt;
        }
        if (target != null) {
            DataRange origRange = ((VRectAxis)target).getDataRange(dim);
            if (range != null && origRange != null) {
                String keepLab = origRange.getLabel();
                range = (DataRange)range.cloneRange();
                range.setLabel(keepLab);
            }
            target.setUseRange(range);
        }
    }

    public void setRange(byte dim, boolean primary, DataRange range) {
        if (!this.isGraphComposite()) {
            return;
        }
        Object[] axes = this.getComposite().getAxes();
        AbstractAxis target = null;
        AbstractAxis mirror = null;
        for (int i = 0; i < axes.length; ++i) {
            VRectAxis a = (VRectAxis)axes[i];
            if (a.getDimension() == dim && a.getPrimary() == primary) {
                target = a;
                continue;
            }
            if (a.getDimension() != dim || a.getPrimary() == primary || !a.isSecondary()) continue;
            mirror = a;
        }
        if (target != null) {
            DataRange origRange = target.getDataRange(dim);
            if (range != null && origRange != null) {
                String keepLab = origRange.getLabel();
                range = (DataRange)range.cloneRange();
                range.setLabel(keepLab);
            }
            target.setUseRange(range);
            if (mirror != null) {
                mirror.setUseRange(range);
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        super.setBounds(x, y, w, h);
        if (this.interactive && w > 0 && h > 0 && (this.backbuffer == null || w != oldWidth || h != oldHeight)) {
            this.backbuffer = new BufferedImage(w, h, 2);
        }
        this.invalidate();
        this.validate();
        this.dirty = true;
        this.insetsPlaced = false;
        if (this.needAutoAlignment()) {
            this.ol.autoAlignInsets(this);
            this.doLayout();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.cc != null) {
            this.cc.setBackground(color);
        }
    }

    public void enableMarginPrefCalc() {
    }

    public void disableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        if (this.isGraphComposite()) {
            if (this.getComposite().getSquareFormat() != Simple2DOverlayComposite.EQUATED_NONE || this.getComposite() instanceof Simple3DOverlayComposite) {
                return false;
            }
            return !(this.getComposite().getAspectRatio() > 0.0);
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.insetsPlaced && this.needAutoAlignment()) {
            JComponent c;
            int i;
            this.insetsPlaced = true;
            ArrayList<JComponent> hiden = new ArrayList<JComponent>();
            for (i = 0; i < this.ol.addOns.size(); ++i) {
                c = (JComponent)this.ol.addOns.get(i);
                if (!c.isVisible() || !(c instanceof CellAlignmentInterface) || ((CellAlignmentInterface)c).getAutoAlignStartegy() == 0) continue;
                c.setVisible(false);
                hiden.add(c);
            }
            super.paint(g);
            for (i = 0; i < hiden.size(); ++i) {
                c = (JComponent)hiden.get(i);
                c.setVisible(true);
            }
            this.ol.autoAlignInsets(this);
            this.doLayout();
        }
        super.paint(g);
        if (this.probe != null) {
            this.probe.draw(g, this.currentx, this.currenty, this.currentrow);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.backbuffer != null) {
            if (this.probe == null) {
                Graphics gg = g.create();
                if (this.dirty) {
                    Graphics bgc = this.backbuffer.getGraphics();
                    if (gg instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)gg;
                        AffineTransform at = g2.getTransform();
                        double scalex = at.getScaleX();
                        double scaley = at.getScaleY();
                        if ((double)this.getWidth() > (double)this.backbuffer.getWidth(null) / scalex || (double)this.getHeight() > (double)this.backbuffer.getHeight(null) / scaley) {
                            this.backbuffer = new BufferedImage((int)Math.ceil((double)this.getWidth() * scalex), (int)Math.ceil((double)this.getHeight() * scaley), 2);
                            bgc = this.backbuffer.getGraphics();
                        }
                        if (scalex != 1.0 || scaley != 1.0) {
                            AffineTransform at2 = new AffineTransform();
                            at2.scale(scalex, scaley);
                            ((Graphics2D)bgc).setTransform(at2);
                            AffineTransform at3 = new AffineTransform();
                            at3.scale(1.0 / scalex, 1.0 / scaley);
                            g2.transform(at3);
                        }
                    }
                    Composite composite = ((Graphics2D)bgc).getComposite();
                    ((Graphics2D)bgc).setComposite(AlphaComposite.getInstance(1, 0.0f));
                    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
                    ((Graphics2D)bgc).fill(rect);
                    ((Graphics2D)bgc).setComposite(composite);
                    super.paintComponent(bgc);
                    gg.drawImage(this.backbuffer, 0, 0, null);
                    gg.dispose();
                    bgc.dispose();
                    this.dirty = false;
                } else {
                    if (gg instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)gg;
                        AffineTransform at = g2.getTransform();
                        double scalex = at.getScaleX();
                        double scaley = at.getScaleY();
                        if (scalex != 1.0 || scaley != 1.0) {
                            AffineTransform at3 = new AffineTransform();
                            at3.scale(1.0 / scalex, 1.0 / scaley);
                            g2.transform(at3);
                        }
                    }
                    gg.drawImage(this.backbuffer, 0, 0, null);
                    gg.dispose();
                }
            } else {
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }

    public void paint2(Graphics g) {
        if (!this.insetsPlaced && this.needAutoAlignment()) {
            this.insetsPlaced = true;
            super.paint(g);
            this.ol.autoAlignInsets(this);
            this.doLayout();
        }
        if (this.backbuffer != null) {
            if (this.probe == null) {
                Graphics gg = g.create();
                if (this.dirty) {
                    Graphics bgc = this.backbuffer.getGraphics();
                    if (gg instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)gg;
                        AffineTransform at = g2.getTransform();
                        double scalex = at.getScaleX();
                        double scaley = at.getScaleY();
                        if ((double)this.getWidth() > (double)this.backbuffer.getWidth(null) / scalex || (double)this.getHeight() > (double)this.backbuffer.getHeight(null) / scaley) {
                            this.backbuffer = new BufferedImage((int)Math.ceil((double)this.getWidth() * scalex), (int)Math.ceil((double)this.getHeight() * scaley), 2);
                            bgc = this.backbuffer.getGraphics();
                        }
                        if (scalex != 1.0 || scaley != 1.0) {
                            AffineTransform at2 = new AffineTransform();
                            at2.scale(scalex, scaley);
                            ((Graphics2D)bgc).setTransform(at2);
                            AffineTransform at3 = new AffineTransform();
                            at3.scale(1.0 / scalex, 1.0 / scaley);
                            g2.transform(at3);
                        }
                    }
                    Composite composite = ((Graphics2D)bgc).getComposite();
                    ((Graphics2D)bgc).setComposite(AlphaComposite.getInstance(1, 0.0f));
                    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
                    ((Graphics2D)bgc).fill(rect);
                    ((Graphics2D)bgc).setComposite(composite);
                    super.paint(bgc);
                    gg.drawImage(this.backbuffer, 0, 0, null);
                    gg.dispose();
                    bgc.dispose();
                    this.dirty = false;
                } else {
                    if (gg instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)gg;
                        AffineTransform at = g2.getTransform();
                        double scalex = at.getScaleX();
                        double scaley = at.getScaleY();
                        if (scalex != 1.0 || scaley != 1.0) {
                            AffineTransform at3 = new AffineTransform();
                            at3.scale(1.0 / scalex, 1.0 / scaley);
                            g2.transform(at3);
                        }
                    }
                    gg.drawImage(this.backbuffer, 0, 0, null);
                    gg.dispose();
                }
            } else {
                g.drawImage(this.backbuffer, 0, 0, null);
                this.probe.draw(g, this.currentx, this.currenty, this.currentrow);
            }
        } else {
            super.paint(g);
        }
    }

    private boolean needAutoAlignment() {
        for (int i = 0; i < this.ol.addOns.size(); ++i) {
            JComponent c = (JComponent)this.ol.addOns.get(i);
            if (!(c instanceof CellAlignmentInterface) || ((CellAlignmentInterface)c).getAutoAlignStartegy() == 0) continue;
            return true;
        }
        return false;
    }

    private void setLeastOverlappedComponentsVisible(boolean visible) {
        for (int i = 0; i < this.ol.addOns.size(); ++i) {
            JComponent c = (JComponent)this.ol.addOns.get(i);
            if (!(c instanceof CellAlignmentInterface) || ((CellAlignmentInterface)c).getAutoAlignStartegy() == 0) continue;
            c.setVisible(visible);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.performMouseClicked(e);
    }

    protected void performMouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevx = e.getX();
        this.prevy = e.getY();
        this.performMousePressed(e);
    }

    protected void performMousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.cc != null) {
            this.cc.setFastRender(false);
        }
        this.performMouseReleased(e);
        this.dirty = true;
        this.repaint();
    }

    protected void performMouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.performMouseEntered(e);
    }

    protected void performMouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.performMouseExited(e);
        this.probe = null;
        this.repaint();
    }

    protected void performMouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            return;
        }
        this.performMouseDragged(e);
        if (this.cc.isView2D() || !e.isControlDown()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int dx = this.prevx - x;
        int dy = this.prevy - y;
        double dAzimuth = (double)dx * 360.0 / (double)this.getWidth();
        double dInclination = (double)dy * 360.0 / (double)this.getHeight();
        if (this.cc != null) {
            this.cc.setFastRender(true);
            this.cc.setViewAngles(this.cc.getAzimuth() + (float)dAzimuth, this.cc.getInclination() + (float)dInclination);
        }
        this.probe = null;
        this.dirty = true;
        this.repaint();
        this.prevx = x;
        this.prevy = y;
    }

    protected void performMouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object elem;
        if (!this.isGraphComposite()) {
            return;
        }
        Insets si = ((OverlayLayout)this.getLayout()).getSurroundingInsets();
        this.currentx = e.getX() - this.getInsets().left - si.left;
        this.currenty = e.getY() - this.getInsets().top - si.top;
        Insets insets = this.getInsets();
        Rectangle area = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        ProbeResult pr = this.getComposite().probe(new Point(this.currentx, this.currenty), new Dimension(3, 3));
        this.probe = null;
        if (pr != null && (elem = pr.getElement()) != null) {
            this.probe = pr.getProbe();
            if (this.probe != null) {
                this.probe.setBackgroundColor(new Color(255, 255, 225));
                this.probe.setViewport(area.x, area.y, area.width, area.height);
                this.currentrow = pr.getRow();
            }
        }
        this.performMouseMoved(e);
        this.repaint();
    }

    protected void performMouseMoved(MouseEvent e) {
    }

    public void marginChanged(MarginChangeEvent mce) {
        if (this.ignoreMarginChange) {
            return;
        }
        OverlayLayout layout = (OverlayLayout)this.getLayout();
        layout.invalidateLayout(this);
        this.doLayout();
    }

    public Component addTitle(Component c, int location) {
        this.ol.addLayoutComponent("Title", c, location);
        return super.add(c, 0);
    }

    public Component addFootnote(Component c, int location) {
        this.ol.addLayoutComponent("Footnote", c, location);
        return super.add(c, 0);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public ArrayList getAllFootnotes() {
        return this.ol.getFootnotesArray();
    }

    public ArrayList getAllTitles() {
        return this.ol.getTitlesArray();
    }

    public ArrayList getAllAddOns() {
        return this.ol.getAddOnsArray();
    }

    public Insets getSurroundingInsets() {
        return ((OverlayLayout)this.getLayout()).getSurroundingInsets();
    }

    public boolean isValidContainer() {
        return this.getWidth() > 0 && this.getHeight() > 0 && StatGraph.getRootPanel(this) != null;
    }

    public Container getPrimaryContainer() {
        return this;
    }

    private boolean isTrimmed(String str) {
        if (str == null) {
            return false;
        }
        return str.length() == str.trim().length();
    }

    public Point2D.Double getScreenPoint(PointAndSpace p, double dataDPIScaleFactor) {
        double[] w;
        ValueMap map;
        VRectAxis axis;
        int i;
        if (!this.isValidContainer()) {
            return null;
        }
        double xs = 0.0;
        double ys = 0.0;
        int orgx = this.cc == null ? this.getX() : this.cc.getX();
        int orgy = this.cc == null ? this.getY() : this.cc.getY();
        Point offsets = this.containerOffsets();
        double xd = p.x instanceof Number ? ((Number)p.x).doubleValue() : -2.147483648E9;
        double yd = p.y instanceof Number ? ((Number)p.y).doubleValue() : -2.147483648E9;
        xs = xd;
        ys = yd;
        Container parent = StatGraph.getRootPanel(this);
        Simple2DOverlayComposite soc = this.getComposite();
        boolean view3D = soc instanceof Simple3DOverlayComposite;
        if (p.xSpace == 8 || xd != -2.147483648E9) {
            block6 : switch (p.xSpace) {
                case 1: {
                    xs = xd * (double)parent.getWidth() / 100.0;
                    break;
                }
                case 3: {
                    xs = xd * (double)this.getWidth() / 100.0;
                    xs += (double)offsets.x;
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        xs = -2.147483648E9;
                        break;
                    }
                    xs = soc.outerRegion.getX() + xd * soc.outerRegion.getWidth() / 100.0;
                    xs += (double)offsets.x;
                    xs += (double)orgx;
                    break;
                }
                case 7: {
                    xs = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 1 || axis.getPrimary() != p.xPrimary) continue;
                        xs = p.xPrimary ? soc.innerRegion.getX() + xd * soc.innerRegion.getWidth() / 100.0 : soc.innerRegion2.getX() + xd * soc.innerRegion2.getWidth() / 100.0;
                        xs += (double)offsets.x;
                        xs += (double)orgx;
                        break block6;
                    }
                    break;
                }
                case 8: {
                    xs = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getInputDataRange() == null || axis.getDimension() != 1 || axis.getPrimary() != p.xPrimary) continue;
                        map = axis.getEncoder((byte)1).getValueMap();
                        try {
                            if (map instanceof StringToNumericMap) {
                                if (p.x instanceof String && StatGraph.isNumber((String)p.x) && this.isTrimmed((String)p.x)) {
                                    try {
                                        SASFormat format = axis.getInputDataRange().getColumnFormat();
                                        if (format != null) {
                                            p.x = format.format((Object)Double.parseDouble((String)p.x)).trim();
                                        }
                                        ((StringToNumericMap)map).getValue(p.x);
                                    }
                                    catch (MissingValueException format) {
                                        // empty catch block
                                    }
                                }
                                if (p.x instanceof Number) {
                                    double dv = ((Number)p.x).doubleValue();
                                    int vv = (int)Math.round(dv);
                                    vv = Math.max(0, Math.min(vv, ((StringToNumericMap)map).getUniqueValueCount() - 1));
                                    p.xOffset = dv - (double)vv;
                                    p.x = ((StringToNumericMap)map).label.getValue(vv);
                                } else {
                                    try {
                                        double dv = ((StringToNumericMap)map).getValue(p.x);
                                    }
                                    catch (MissingValueException e) {
                                        p.x = StringToNumericMap.trimTrailing((String)((String)p.x));
                                    }
                                }
                                xs = p.xPrimary ? soc.innerRegion.getX() + ((StringToNumericMap)map).getValue(p.x) + ((StringToNumericMap)map).getStrideValue() * p.xOffset : soc.innerRegion2.getX() + ((StringToNumericMap)map).getValue(p.x) + ((StringToNumericMap)map).getStrideValue() * p.xOffset;
                            } else {
                                if (p.x instanceof String && StatGraph.isNumber((String)p.x)) {
                                    p.x = new Double((String)p.x);
                                    xd = ((Number)p.x).doubleValue();
                                }
                                if (p.x instanceof Number) {
                                    if (axis.getEncoder((byte)1) instanceof BrokenPositionEncoder) {
                                        xs = this.getScreenPositionOnBrokenAxis((BrokenPositionEncoder)axis.getEncoder((byte)1), xd);
                                        xs = p.xPrimary ? soc.innerRegion.getX() + xs : soc.innerRegion2.getX() + xs;
                                    } else {
                                        xs = p.xPrimary ? soc.innerRegion.getX() + ((ContinuousRangeToNumericMap)map).getValue(xd) : soc.innerRegion2.getX() + ((ContinuousRangeToNumericMap)map).getValue(xd);
                                    }
                                } else {
                                    xs = p.xPrimary ? soc.innerRegion.getX() : soc.innerRegion2.getX();
                                }
                            }
                            double[] d = new double[]{0.0, 0.0, 0.5};
                            w = new double[3];
                            soc.getChannel().gluProject(d, w);
                            d[0] = 1.0;
                            d[1] = 0.0;
                            d[2] = 0.5;
                            double[] w1 = new double[3];
                            soc.getChannel().gluProject(d, w1);
                            double w2sXFac = w1[0] - w[0];
                            xs *= w2sXFac;
                            xs += (double)(offsets.x + orgx);
                        }
                        catch (MissingValueException ee) {
                            xs = -2.147483648E9;
                        }
                        catch (IllegalArgumentException ee) {
                            xs = -2.147483648E9;
                        }
                        break block6;
                    }
                    break;
                }
                case 0: {
                    xs = dataDPIScaleFactor * xd;
                    break;
                }
                case 2: {
                    xs = dataDPIScaleFactor * xd;
                    xs += (double)offsets.x;
                    break;
                }
                case 4: {
                    if (soc == null || view3D) {
                        xs = -2.147483648E9;
                        break;
                    }
                    xs = soc.outerRegion.getX() + dataDPIScaleFactor * xd;
                    xs += (double)offsets.x;
                    xs += (double)orgx;
                    break;
                }
                case 6: {
                    xs = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 1 || axis.getPrimary() != p.xPrimary) continue;
                        xs = p.xPrimary ? soc.innerRegion.getX() + dataDPIScaleFactor * xd : soc.innerRegion2.getX() + dataDPIScaleFactor * xd;
                        xs += (double)offsets.x;
                        xs += (double)orgx;
                        break block6;
                    }
                    break;
                }
            }
        }
        if (p.ySpace == 8 || yd != -2.147483648E9) {
            block17 : switch (p.ySpace) {
                case 1: {
                    ys = (100.0 - yd) * (double)parent.getHeight() / 100.0;
                    break;
                }
                case 3: {
                    int y1 = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        y1 += this.getTitle(i).getHeight();
                    }
                    int y2 = 0;
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        y2 += this.getFootnote(i).getHeight();
                    }
                    ys = (100.0 - yd) * (double)(this.getHeight() - y1 - y2) / 100.0;
                    ys += (double)(offsets.y + y1);
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        ys = -2.147483648E9;
                        break;
                    }
                    ys = soc.outerRegion.getY() + (100.0 - yd) * soc.outerRegion.getHeight() / 100.0;
                    ys += (double)offsets.y;
                    ys += (double)orgy;
                    break;
                }
                case 7: {
                    ys = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 2 || axis.getPrimary() != p.yPrimary) continue;
                        ys = p.yPrimary ? soc.innerRegion.getY() + (100.0 - yd) * soc.innerRegion.getHeight() / 100.0 : soc.innerRegion2.getY() + (100.0 - yd) * soc.innerRegion2.getHeight() / 100.0;
                        ys += (double)offsets.y;
                        ys += (double)orgy;
                        break block17;
                    }
                    break;
                }
                case 8: {
                    ys = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getInputDataRange() == null || axis.getDimension() != 2 || axis.getPrimary() != p.yPrimary) continue;
                        map = axis.getEncoder((byte)2).getValueMap();
                        try {
                            if (map instanceof StringToNumericMap) {
                                if (p.y instanceof String && StatGraph.isNumber((String)p.y) && this.isTrimmed((String)p.y)) {
                                    try {
                                        SASFormat format = axis.getInputDataRange().getColumnFormat();
                                        if (format != null) {
                                            p.y = format.format((Object)Double.parseDouble((String)p.y)).trim();
                                        }
                                        ((StringToNumericMap)map).getValue(p.y);
                                    }
                                    catch (MissingValueException format) {
                                        // empty catch block
                                    }
                                }
                                if (p.y instanceof Number) {
                                    double dv = ((Number)p.y).doubleValue();
                                    int vv = (int)Math.round(dv);
                                    vv = Math.max(0, Math.min(vv, ((StringToNumericMap)map).getUniqueValueCount() - 1));
                                    p.y = ((StringToNumericMap)map).label.getValue(vv);
                                    p.yOffset = dv - (double)vv;
                                } else {
                                    try {
                                        double dv = ((StringToNumericMap)map).getValue(p.y);
                                    }
                                    catch (MissingValueException e) {
                                        p.y = StringToNumericMap.trimTrailing((String)((String)p.y));
                                    }
                                }
                                ys = p.yPrimary ? soc.innerRegion.getY() + soc.innerRegion.getHeight() - ((StringToNumericMap)map).getValue(p.y) - ((StringToNumericMap)map).getStrideValue() * p.yOffset : soc.innerRegion2.getY() + soc.innerRegion2.getHeight() - ((StringToNumericMap)map).getValue(p.y) - ((StringToNumericMap)map).getStrideValue() * p.yOffset;
                            } else {
                                if (p.y instanceof String && StatGraph.isNumber((String)p.y)) {
                                    p.y = new Double((String)p.y);
                                    yd = ((Number)p.y).doubleValue();
                                }
                                if (p.y instanceof Number) {
                                    if (axis.getEncoder((byte)2) instanceof BrokenPositionEncoder) {
                                        ys = this.getScreenPositionOnBrokenAxis((BrokenPositionEncoder)axis.getEncoder((byte)2), yd);
                                        ys = p.xPrimary ? soc.innerRegion.getY() + (double)soc.innerRegion.height - ys : soc.innerRegion2.getY() + (double)soc.innerRegion2.height - ys;
                                    } else {
                                        ys = p.yPrimary ? soc.innerRegion.getY() + (double)soc.innerRegion.height - ((ContinuousRangeToNumericMap)map).getValue(yd) : soc.innerRegion2.getY() + (double)soc.innerRegion2.height - ((ContinuousRangeToNumericMap)map).getValue(yd);
                                    }
                                } else {
                                    ys = p.yPrimary ? soc.innerRegion.getY() + (double)soc.innerRegion.height : soc.innerRegion2.getY() + (double)soc.innerRegion2.height;
                                }
                            }
                            double[] d = new double[]{0.0, 0.0, 0.5};
                            w = new double[3];
                            soc.getChannel().gluProject(d, w);
                            d[1] = 1.0;
                            d[0] = 0.0;
                            d[2] = 0.5;
                            double[] w1 = new double[3];
                            soc.getChannel().gluProject(d, w1);
                            double w2sY = w[1] - w1[1];
                            ys *= w2sY;
                            ys += (double)(offsets.y + orgy);
                        }
                        catch (MissingValueException ee) {
                            ys = -2.147483648E9;
                        }
                        catch (IllegalArgumentException ee) {
                            ys = -2.147483648E9;
                        }
                        break block17;
                    }
                    break;
                }
                case 0: {
                    ys = (double)parent.getHeight() - dataDPIScaleFactor * yd;
                    break;
                }
                case 2: {
                    int y1 = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        y1 += this.getTitle(i).getHeight();
                    }
                    int y2 = 0;
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        y2 += this.getFootnote(i).getHeight();
                    }
                    ys = (double)(this.getHeight() - y1 - y2) - dataDPIScaleFactor * yd;
                    ys += (double)(offsets.y + y1);
                    break;
                }
                case 4: {
                    if (soc == null || view3D) {
                        ys = -2.147483648E9;
                        break;
                    }
                    ys = soc.outerRegion.getY() + (soc.outerRegion.getHeight() - dataDPIScaleFactor * yd);
                    ys += (double)offsets.y;
                    ys += (double)orgy;
                    break;
                }
                case 6: {
                    ys = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (i = 0; i < soc.axes.size(); ++i) {
                        axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 2 || axis.getPrimary() != p.yPrimary) continue;
                        ys = p.yPrimary ? soc.innerRegion.getY() + (soc.innerRegion.getHeight() - dataDPIScaleFactor * yd) : soc.innerRegion2.getY() + (soc.innerRegion2.getHeight() - dataDPIScaleFactor * yd);
                        ys += (double)offsets.y;
                        ys += (double)orgy;
                        break block17;
                    }
                    break;
                }
            }
        }
        return new Point2D.Double(xs, ys);
    }

    private int getScreenPositionOnBrokenAxis(BrokenPositionEncoder encoder, double val) {
        ContinuousRange[] cr = encoder.getInputRanges();
        int numRan = cr.length;
        int idx = 0;
        boolean inGap = false;
        if (val < cr[0].getMin()) {
            idx = 0;
        } else if (val > cr[numRan - 1].getMax()) {
            idx = numRan - 1;
        } else {
            for (int i = 0; i < numRan; ++i) {
                double min = cr[i].getMin();
                double max = cr[i].getMax();
                if (val >= min && val <= max) {
                    idx = i;
                    break;
                }
                if (!(val < min)) continue;
                idx = i;
                inGap = true;
                break;
            }
        }
        if (encoder.isReversed()) {
            idx = numRan - 1 - idx;
        }
        ContinuousRangeToNumericMap[] maps = encoder.getRangeOutputMaps();
        double sval = inGap ? (encoder.isReversed() ? maps[idx].getOutputMax() + (double)BrokenPositionEncoder.BROKEN_GAP * 0.5 + BrokenPositionEncoder.RESERVED_OFFSET : maps[idx].getOutputMin() - (double)BrokenPositionEncoder.BROKEN_GAP * 0.5 - BrokenPositionEncoder.RESERVED_OFFSET) : maps[idx].getValue(val);
        return (int)sval;
    }

    private double getDataPositionOnBrokenAxis(BrokenPositionEncoder encoder, double sval) {
        double val;
        ContinuousRangeToNumericMap[] maps = encoder.getRangeOutputMaps();
        int numRan = maps.length;
        int idx = 0;
        boolean inGap = false;
        if (sval < maps[0].getOutputMin()) {
            idx = 0;
        } else if (sval > maps[numRan - 1].getOutputMax()) {
            idx = numRan - 1;
        } else {
            for (int i = 0; i < numRan; ++i) {
                double min = maps[i].getOutputMin();
                double max = maps[i].getOutputMax();
                if (sval >= min && sval <= max) {
                    idx = i;
                    break;
                }
                if (!(sval < min)) continue;
                idx = i;
                inGap = true;
                break;
            }
        }
        ContinuousRange[] cr = encoder.getInputRanges();
        if (inGap) {
            if (encoder.isReversed()) {
                idx = numRan - 1 - idx;
                val = cr[idx].getMax() + (cr[idx + 1].getMin() - cr[idx].getMax()) * 0.5;
            } else {
                val = cr[idx].getMin() - (cr[idx].getMin() - cr[idx - 1].getMax()) * 0.5;
            }
        } else {
            val = maps[idx].getInverseValue(sval);
        }
        return val;
    }

    private Point containerOffsets() {
        int x = 0;
        int y = 0;
        Container parent = StatGraph.getRootPanel(this);
        for (Container container = this.getParent(); container != parent; container = container.getParent()) {
            x += container.getX();
            y += container.getY();
        }
        return new Point(x += this.getX(), y += this.getY());
    }

    public Rectangle getDataBoundingBox() {
        Simple2DOverlayComposite soc = this.getComposite();
        boolean view3D = soc instanceof Simple3DOverlayComposite;
        if (soc == null || view3D) {
            return null;
        }
        Point offsets = this.containerOffsets();
        int xs = offsets.x + this.cc.getX() + (int)soc.outerRegion.getX();
        int ys = offsets.y + this.cc.getY() + (int)soc.outerRegion.getY();
        return new Rectangle(xs, ys, (int)soc.outerRegion.getWidth(), (int)soc.outerRegion.getHeight());
    }

    public Point2D.Double getScreenSize(SizeAndSpace size, double dataDPIScaleFactor) {
        if (!this.isValidContainer()) {
            return null;
        }
        double xs = 0.0;
        double ys = 0.0;
        Container parent = StatGraph.getRootPanel(this);
        Simple2DOverlayComposite soc = this.getComposite();
        boolean view3D = soc instanceof Simple3DOverlayComposite;
        if (Double.isNaN(size.width)) {
            xs = 2.147483647E9;
        } else {
            block0 : switch (size.widthSpace) {
                case 1: {
                    xs = size.width * (double)parent.getWidth() / 100.0;
                    break;
                }
                case 3: {
                    xs = size.width * (double)this.getWidth() / 100.0;
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        xs = -2.147483648E9;
                        break;
                    }
                    xs = size.width * soc.outerRegion.getWidth() / 100.0;
                    break;
                }
                case 7: {
                    if (soc == null || view3D) {
                        xs = -2.147483648E9;
                        break;
                    }
                    if (size.widthPrimary) {
                        xs = size.width * soc.innerRegion.getWidth() / 100.0;
                        break;
                    }
                    xs = size.width * soc.innerRegion2.getWidth() / 100.0;
                    break;
                }
                case 8: {
                    xs = -2.147483648E9;
                    if (soc == null || view3D) break;
                    for (int i = 0; i < soc.axes.size(); ++i) {
                        VRectAxis axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 1 || axis.getPrimary() != size.widthPrimary) continue;
                        ValueMap map = axis.getEncoder((byte)1).getValueMap();
                        if (map instanceof StringToNumericMap) {
                            double stride = ((StringToNumericMap)map).getStrideValue();
                            xs = stride * size.width;
                        } else {
                            ContinuousRangeToNumericMap cmap = (ContinuousRangeToNumericMap)map;
                            if (axis.getEncoder((byte)1) instanceof BrokenPositionEncoder) {
                                cmap = ((BrokenPositionEncoder)axis.getEncoder((byte)1)).getRangeOutputMaps()[0];
                            }
                            double x1 = cmap.getInputMin();
                            double x2 = x1 + size.width;
                            double ds1 = cmap.getValue(x1);
                            double ds2 = cmap.getValue(x2);
                            xs = ds2 - ds1;
                        }
                        double[] d = new double[]{0.0, 0.0, 0.5};
                        double[] w = new double[3];
                        soc.getChannel().gluProject(d, w);
                        d[0] = 1.0;
                        d[1] = 0.0;
                        d[2] = 0.5;
                        double[] w1 = new double[3];
                        soc.getChannel().gluProject(d, w1);
                        double w2sXFac = w1[0] - w[0];
                        xs *= w2sXFac;
                        break block0;
                    }
                    break;
                }
                case 0: {
                    xs = dataDPIScaleFactor * size.width;
                }
            }
        }
        if (Double.isNaN(size.height)) {
            ys = 2.147483647E9;
        } else {
            block8 : switch (size.heightSpace) {
                case 1: {
                    ys = size.height * (double)parent.getHeight() / 100.0;
                    break;
                }
                case 3: {
                    int i;
                    int yo = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        yo += this.getTitle(i).getHeight();
                    }
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        yo += this.getFootnote(i).getHeight();
                    }
                    ys = size.height * (double)(this.getHeight() - yo) / 100.0;
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        ys = -2.147483648E9;
                        break;
                    }
                    ys = size.height * soc.outerRegion.getHeight() / 100.0;
                    break;
                }
                case 7: {
                    if (soc == null || view3D) {
                        ys = -2.147483648E9;
                        break;
                    }
                    if (size.heightPrimary) {
                        ys = size.height * soc.innerRegion.getHeight() / 100.0;
                        break;
                    }
                    ys = size.height * soc.innerRegion2.getHeight() / 100.0;
                    break;
                }
                case 8: {
                    if (soc == null || view3D) {
                        ys = -2.147483648E9;
                        break;
                    }
                    for (int i = 0; i < soc.axes.size(); ++i) {
                        VRectAxis axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 2 || axis.getPrimary() != size.heightPrimary) continue;
                        ValueMap map = axis.getEncoder((byte)2).getValueMap();
                        if (map instanceof StringToNumericMap) {
                            double stride = ((StringToNumericMap)map).getStrideValue();
                            ys = size.height * stride;
                        } else {
                            ContinuousRangeToNumericMap cmap = (ContinuousRangeToNumericMap)map;
                            if (axis.getEncoder((byte)2) instanceof BrokenPositionEncoder) {
                                cmap = ((BrokenPositionEncoder)axis.getEncoder((byte)2)).getRangeOutputMaps()[0];
                            }
                            double y1 = cmap.getInputMin();
                            double y2 = y1 + size.height;
                            double ds1 = cmap.getValue(y1);
                            double ds2 = cmap.getValue(y2);
                            ys = ds2 - ds1;
                        }
                        double[] d = new double[]{0.0, 0.0, 0.5};
                        double[] w = new double[3];
                        soc.getChannel().gluProject(d, w);
                        d[0] = 0.0;
                        d[1] = 1.0;
                        d[2] = 0.5;
                        double[] w1 = new double[3];
                        soc.getChannel().gluProject(d, w1);
                        double w2sYFac = w[1] - w1[1];
                        ys *= w2sYFac;
                        break block8;
                    }
                    break;
                }
                case 0: {
                    ys = dataDPIScaleFactor * size.height;
                }
            }
        }
        return new Point2D.Double(xs, ys);
    }

    public boolean isDataValueSupported() {
        return this.cc != null && this.cc.isView2D();
    }

    public boolean isWallSpaceSupported() {
        return this.cc != null && this.cc.isView2D();
    }

    public void update(PointAndSpace p, double dataDPIScaleFactor, Point2D.Double screen) {
        int y1;
        Container parent = StatGraph.getRootPanel(this);
        Simple2DOverlayComposite soc = this.getComposite();
        Point offsets = this.containerOffsets();
        boolean view3D = soc instanceof Simple3DOverlayComposite;
        boolean invalidX = false;
        boolean invalidY = false;
        if (soc == null || view3D) {
            switch (p.xSpace) {
                case 1: {
                    p.x = new Double(screen.x * 100.0 / (double)parent.getWidth());
                    break;
                }
                default: {
                    p.x = new Double(screen.x * 100.0 / (double)parent.getWidth());
                    break;
                }
                case 8: {
                    p.x = null;
                    break;
                }
                case 0: {
                    p.x = new Double(screen.x / dataDPIScaleFactor);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    p.x = new Double((screen.x - (double)offsets.x) / dataDPIScaleFactor);
                }
            }
            switch (p.ySpace) {
                case 1: {
                    p.y = new Double(100.0 - screen.y * 100.0 / (double)parent.getHeight());
                    break;
                }
                default: {
                    int i;
                    int y12 = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        y12 += this.getTitle(i).getHeight();
                    }
                    int y2 = 0;
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        y2 += this.getFootnote(i).getHeight();
                    }
                    p.y = new Double(100.0 - (screen.y - (double)offsets.y - (double)y12) * 100.0 / (double)(this.getHeight() - y12 - y2));
                    break;
                }
                case 8: {
                    p.y = null;
                    break;
                }
                case 0: {
                    p.y = new Double(((double)parent.getHeight() - screen.y) / dataDPIScaleFactor);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    int i;
                    int y13 = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        y13 += this.getTitle(i).getHeight();
                    }
                    int y2 = 0;
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        y2 += this.getFootnote(i).getHeight();
                    }
                    p.y = new Double(((double)(this.getHeight() - (y13 + y2)) - (screen.y - (double)offsets.y - (double)y13)) / dataDPIScaleFactor);
                }
            }
            return;
        }
        p.xOffset = 0.0;
        p.yOffset = 0.0;
        block12 : switch (p.xSpace) {
            case 1: {
                p.x = new Double(screen.x * 100.0 / (double)parent.getWidth());
                break;
            }
            case 3: {
                p.x = new Double((screen.x - (double)offsets.x) * 100.0 / (double)this.getWidth());
                break;
            }
            case 5: {
                p.x = new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.outerRegion.getX()) * 100.0 / soc.outerRegion.getWidth());
                break;
            }
            case 7: {
                if (p.xPrimary) {
                    p.x = new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.innerRegion.getX()) * 100.0 / soc.innerRegion.getWidth());
                    break;
                }
                p.x = new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.innerRegion2.getX()) * 100.0 / soc.innerRegion2.getWidth());
                break;
            }
            case 8: {
                for (int i = 0; i < soc.axes.size(); ++i) {
                    VRectAxis axis = (VRectAxis)soc.axes.get(i);
                    if (axis.getDimension() != 1 || axis.getPrimary() != p.xPrimary) continue;
                    double xs = screen.x - (double)offsets.x - (double)this.cc.getX();
                    double[] d = new double[]{0.0, 0.0, 0.5};
                    double[] w = new double[3];
                    soc.getChannel().gluUnProject(d, w);
                    d[0] = 1.0;
                    d[1] = 0.0;
                    d[2] = 0.5;
                    double[] w1 = new double[3];
                    soc.getChannel().gluUnProject(d, w1);
                    double s2wXFac = w1[0] - w[0];
                    xs *= s2wXFac;
                    xs = p.xPrimary ? (xs -= soc.innerRegion.getX()) : (xs -= soc.innerRegion2.getX());
                    ValueMap map = axis.getEncoder((byte)1).getValueMap();
                    if (map instanceof StringToNumericMap) {
                        StringToNumericMap sm = (StringToNumericMap)map;
                        double min = sm.getOutputMin();
                        double max = sm.getOutputMax();
                        double stride = sm.getStrideValue();
                        String[] values = sm.getInverseValues(min, max);
                        if (values == null || values.length == 0) {
                            invalidX = true;
                            break block12;
                        }
                        int index = 0;
                        if (xs < min) {
                            p.x = values[0];
                            p.xOffset = (xs - min) / stride;
                            break block12;
                        }
                        if (xs > max) {
                            index = values.length - 1;
                            p.x = values[index];
                            p.xOffset = (xs - max) / stride;
                            break block12;
                        }
                        index = (int)Math.round((xs - min) / stride);
                        p.x = values[index];
                        p.xOffset = (xs - (min + (double)index * stride)) / stride;
                        break block12;
                    }
                    if (axis.getEncoder((byte)1) instanceof BrokenPositionEncoder) {
                        p.x = new Double(this.getDataPositionOnBrokenAxis((BrokenPositionEncoder)axis.getEncoder((byte)1), xs));
                        break block12;
                    }
                    p.x = new Double(((ContinuousRangeToNumericMap)map).getInverseValue(xs));
                    break block12;
                }
                break;
            }
            case 0: {
                p.x = new Double(screen.x / dataDPIScaleFactor);
                break;
            }
            case 2: {
                p.x = new Double((screen.x - (double)offsets.x) / dataDPIScaleFactor);
                break;
            }
            case 4: {
                p.x = new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.outerRegion.getX()) / dataDPIScaleFactor);
                break;
            }
            case 6: {
                p.x = p.xPrimary ? new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.innerRegion.getX()) / dataDPIScaleFactor) : new Double((screen.x - (double)offsets.x - (double)this.cc.getX() - soc.innerRegion2.getX()) / dataDPIScaleFactor);
            }
        }
        if (invalidX) {
            p.xSpace = 3;
            p.x = new Double((screen.x - (double)offsets.x) * 100.0 / (double)this.getWidth());
        }
        block23 : switch (p.ySpace) {
            case 1: {
                p.y = new Double(100.0 - screen.y * 100.0 / (double)parent.getHeight());
                break;
            }
            case 3: {
                int i;
                y1 = 0;
                for (i = 0; i < this.getTitleCount(); ++i) {
                    y1 += this.getTitle(i).getHeight();
                }
                int y2 = 0;
                for (i = 0; i < this.getFootnoteCount(); ++i) {
                    y2 += this.getFootnote(i).getHeight();
                }
                p.y = new Double(100.0 - (screen.y - (double)offsets.y - (double)y1) * 100.0 / (double)(this.getHeight() - y1 - y2));
                break;
            }
            case 5: {
                p.y = new Double(100.0 - (screen.y - (double)offsets.y - (double)this.cc.getY() - soc.outerRegion.getY()) * 100.0 / soc.outerRegion.getHeight());
                break;
            }
            case 7: {
                if (p.yPrimary) {
                    p.y = new Double(100.0 - (screen.y - (double)offsets.y - (double)this.cc.getY() - soc.innerRegion.getY()) * 100.0 / soc.innerRegion.getHeight());
                    break;
                }
                p.y = new Double(100.0 - (screen.y - (double)offsets.y - (double)this.cc.getY() - soc.innerRegion2.getY()) * 100.0 / soc.innerRegion2.getHeight());
                break;
            }
            case 8: {
                for (int i = 0; i < soc.axes.size(); ++i) {
                    VRectAxis axis = (VRectAxis)soc.axes.get(i);
                    if (axis.getDimension() != 2 || axis.getPrimary() != p.yPrimary) continue;
                    ValueMap map = axis.getEncoder((byte)2).getValueMap();
                    double ys = screen.getY() - (double)offsets.y - (double)this.cc.getY();
                    double[] d = new double[]{0.0, 0.0, 0.5};
                    double[] w = new double[3];
                    soc.getChannel().gluUnProject(d, w);
                    d[0] = 0.0;
                    d[1] = 1.0;
                    d[2] = 0.5;
                    double[] w1 = new double[3];
                    soc.getChannel().gluUnProject(d, w1);
                    double s2wYFac = w[1] - w1[1];
                    ys *= s2wYFac;
                    double d2 = ys = p.yPrimary ? (double)soc.innerRegion.height - (ys - soc.innerRegion.getY()) : (double)soc.innerRegion2.height - (ys - soc.innerRegion2.getY());
                    if (map instanceof StringToNumericMap) {
                        StringToNumericMap sm = (StringToNumericMap)map;
                        double min = sm.getOutputMin();
                        double max = sm.getOutputMax();
                        double stride = sm.getStrideValue();
                        String[] values = sm.getInverseValues(min, max);
                        if (values == null || values.length == 0) {
                            invalidY = true;
                            break block23;
                        }
                        int index = 0;
                        if (ys < min) {
                            p.y = values[0];
                            p.yOffset = (ys - min) / stride;
                            break block23;
                        }
                        if (ys > max) {
                            index = values.length - 1;
                            p.y = values[index];
                            p.yOffset = (ys - max) / stride;
                            break block23;
                        }
                        index = (int)Math.round((ys - min) / stride);
                        p.y = values[index];
                        p.yOffset = (ys - (min + (double)index * stride)) / stride;
                        break block23;
                    }
                    if (axis.getEncoder((byte)2) instanceof BrokenPositionEncoder) {
                        p.y = new Double(this.getDataPositionOnBrokenAxis((BrokenPositionEncoder)axis.getEncoder((byte)2), ys));
                        break block23;
                    }
                    p.y = new Double(((ContinuousRangeToNumericMap)map).getInverseValue(ys));
                    break block23;
                }
                break;
            }
            case 0: {
                p.y = new Double(((double)parent.getHeight() - screen.y) / dataDPIScaleFactor);
                break;
            }
            case 2: {
                int i;
                y1 = 0;
                for (i = 0; i < this.getTitleCount(); ++i) {
                    y1 += this.getTitle(i).getHeight();
                }
                int y2 = 0;
                for (i = 0; i < this.getFootnoteCount(); ++i) {
                    y2 += this.getFootnote(i).getHeight();
                }
                p.y = new Double(((double)(this.getHeight() - (y1 + y2)) - (screen.y - (double)offsets.y - (double)y1)) / dataDPIScaleFactor);
                break;
            }
            case 4: {
                p.y = new Double((soc.outerRegion.getHeight() - (screen.y - (soc.outerRegion.getY() + (double)offsets.y + (double)this.cc.getY()))) / dataDPIScaleFactor);
                break;
            }
            case 6: {
                p.y = p.yPrimary ? new Double((soc.innerRegion.getHeight() - (screen.y - (soc.innerRegion.getY() + (double)offsets.y + (double)this.cc.getY()))) / dataDPIScaleFactor) : new Double((soc.innerRegion2.getHeight() - (screen.y - (soc.innerRegion2.getY() + (double)offsets.y + (double)this.cc.getY()))) / dataDPIScaleFactor);
            }
        }
        if (invalidY) {
            int i;
            p.ySpace = 3;
            y1 = 0;
            for (i = 0; i < this.getTitleCount(); ++i) {
                y1 += this.getTitle(i).getHeight();
            }
            int y2 = 0;
            for (i = 0; i < this.getFootnoteCount(); ++i) {
                y2 += this.getFootnote(i).getHeight();
            }
            p.y = new Double(100.0 - (screen.getY() - (double)offsets.y - (double)y1) * 100.0 / (double)(this.getHeight() - y1 - y2));
        }
    }

    public void update(SizeAndSpace size, double dataDPIScaleFactor, Point2D.Double newSize) {
        Container parent;
        Simple2DOverlayComposite soc = this.getComposite();
        boolean invalidX = false;
        boolean invalidY = false;
        boolean view3D = soc instanceof Simple3DOverlayComposite;
        if (newSize.getX() == 2.147483647E9) {
            size.width = Double.NaN;
        } else {
            block0 : switch (size.widthSpace) {
                case 1: {
                    parent = StatGraph.getRootPanel(this);
                    size.width = 100.0 * newSize.getX() / (double)parent.getWidth();
                    break;
                }
                case 3: {
                    size.width = newSize.getX() * 100.0 / (double)this.getWidth();
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        size.width = newSize.getX() * 100.0 / (double)this.getWidth();
                        break;
                    }
                    size.width = newSize.getX() * 100.0 / soc.outerRegion.getWidth();
                    break;
                }
                case 7: {
                    if (soc == null || view3D) {
                        size.width = newSize.getX() * 100.0 / (double)this.getWidth();
                        break;
                    }
                    if (size.widthPrimary) {
                        size.width = newSize.getX() * 100.0 / soc.innerRegion.getWidth();
                        break;
                    }
                    size.width = newSize.getX() * 100.0 / soc.innerRegion2.getWidth();
                    break;
                }
                case 8: {
                    if (soc == null || view3D) {
                        size.width = 0.0;
                        break;
                    }
                    double[] d = new double[]{0.0, 0.0, 0.5};
                    double[] w = new double[3];
                    soc.getChannel().gluUnProject(d, w);
                    d[0] = 1.0;
                    d[1] = 0.0;
                    d[2] = 0.5;
                    double[] w1 = new double[3];
                    soc.getChannel().gluUnProject(d, w1);
                    double s2wXFac = w1[0] - w[0];
                    double newWidth = newSize.getX() * s2wXFac;
                    for (int i = 0; i < soc.axes.size(); ++i) {
                        VRectAxis axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 1 || axis.getPrimary() != size.widthPrimary) continue;
                        ValueMap map = axis.getEncoder((byte)1).getValueMap();
                        if (map instanceof StringToNumericMap) {
                            StringToNumericMap sm = (StringToNumericMap)map;
                            double min = sm.getOutputMin();
                            double max = sm.getOutputMax();
                            double stride = sm.getStrideValue();
                            String[] values = sm.getInverseValues(min, max);
                            if (values == null || values.length == 0) {
                                invalidX = true;
                                break block0;
                            }
                            size.width = newWidth / stride;
                            break block0;
                        }
                        ContinuousRangeToNumericMap cmap = (ContinuousRangeToNumericMap)map;
                        if (axis.getEncoder((byte)1) instanceof BrokenPositionEncoder) {
                            cmap = ((BrokenPositionEncoder)axis.getEncoder((byte)1)).getRangeOutputMaps()[0];
                        }
                        double x1 = cmap.getOutputMin();
                        double x2 = x1 + newWidth;
                        double ds1 = cmap.getInverseValue(x1);
                        double ds2 = cmap.getInverseValue(x2);
                        size.width = ds2 - ds1;
                        break block0;
                    }
                    break;
                }
                case 0: {
                    size.width = newSize.getX() / dataDPIScaleFactor;
                }
            }
        }
        if (invalidX) {
            size.widthSpace = 3;
            size.width = newSize.getX() * 100.0 / (double)this.getWidth();
        }
        if (size.height == 2.147483647E9) {
            size.height = Double.NaN;
        } else {
            block8 : switch (size.heightSpace) {
                case 1: {
                    parent = StatGraph.getRootPanel(this);
                    size.height = newSize.getY() * 100.0 / (double)parent.getHeight();
                    break;
                }
                case 3: {
                    int i;
                    int yo = 0;
                    for (i = 0; i < this.getTitleCount(); ++i) {
                        yo += this.getTitle(i).getHeight();
                    }
                    for (i = 0; i < this.getFootnoteCount(); ++i) {
                        yo += this.getFootnote(i).getHeight();
                    }
                    size.height = newSize.getY() * 100.0 / (double)(this.getHeight() - yo);
                    break;
                }
                case 5: {
                    if (soc == null || view3D) {
                        size.height = newSize.getY() * 100.0 / (double)this.getHeight();
                        break;
                    }
                    size.height = newSize.getY() * 100.0 / soc.outerRegion.getHeight();
                    break;
                }
                case 7: {
                    if (soc == null || view3D) {
                        size.height = newSize.getY() * 100.0 / (double)this.getHeight();
                        break;
                    }
                    if (size.heightPrimary) {
                        size.height = newSize.getY() * 100.0 / soc.innerRegion.getHeight();
                        break;
                    }
                    size.height = newSize.getY() * 100.0 / soc.innerRegion2.getHeight();
                    break;
                }
                case 8: {
                    if (soc == null || view3D) {
                        size.height = 0.0;
                        break;
                    }
                    double[] d = new double[]{0.0, 0.0, 0.5};
                    double[] w = new double[3];
                    soc.getChannel().gluUnProject(d, w);
                    d[0] = 0.0;
                    d[1] = 1.0;
                    d[2] = 0.5;
                    double[] w1 = new double[3];
                    soc.getChannel().gluUnProject(d, w1);
                    double s2wYFac = w[1] - w1[1];
                    double newHeight = newSize.getY() * s2wYFac;
                    for (int i = 0; i < soc.axes.size(); ++i) {
                        VRectAxis axis = (VRectAxis)soc.axes.get(i);
                        if (axis.getDimension() != 2 || axis.getPrimary() != size.heightPrimary) continue;
                        ValueMap map = axis.getEncoder((byte)2).getValueMap();
                        if (map instanceof StringToNumericMap) {
                            StringToNumericMap sm = (StringToNumericMap)map;
                            double min = sm.getOutputMin();
                            double max = sm.getOutputMax();
                            double stride = sm.getStrideValue();
                            String[] values = sm.getInverseValues(min, max);
                            if (values == null || values.length == 0) {
                                invalidY = true;
                                break block8;
                            }
                            size.height = newHeight / stride;
                            break block8;
                        }
                        ContinuousRangeToNumericMap cmap = (ContinuousRangeToNumericMap)map;
                        if (axis.getEncoder((byte)2) instanceof BrokenPositionEncoder) {
                            cmap = ((BrokenPositionEncoder)axis.getEncoder((byte)2)).getRangeOutputMaps()[0];
                        }
                        double y1 = cmap.getInputMin();
                        double y2 = y1 + newHeight;
                        double ds1 = cmap.getInverseValue(y1);
                        double ds2 = cmap.getInverseValue(y2);
                        size.height = ds2 - ds1;
                        break block8;
                    }
                    break;
                }
                case 0: {
                    size.height = newSize.getY() / dataDPIScaleFactor;
                }
            }
        }
        if (invalidY) {
            int i;
            size.heightSpace = 3;
            int yo = 0;
            for (i = 0; i < this.getTitleCount(); ++i) {
                yo += this.getTitle(i).getHeight();
            }
            for (i = 0; i < this.getFootnoteCount(); ++i) {
                yo += this.getFootnote(i).getHeight();
            }
            size.height = newSize.getY() * 100.0 / (double)(this.getHeight() - yo);
        }
    }

    public double[] convertDataToDouble(PointAndSpace p) {
        StringToNumericMap sm;
        ValueMap map;
        VRectAxis axis;
        int i;
        Container parent = StatGraph.getRootPanel(this);
        Simple2DOverlayComposite soc = this.getComposite();
        Point offsets = this.containerOffsets();
        double[] values = new double[2];
        boolean doublex = p.x instanceof Number;
        boolean doubley = p.y instanceof Number;
        if (doublex) {
            values[0] = ((Number)p.x).doubleValue();
        } else {
            for (i = 0; i < soc.axes.size(); ++i) {
                double xval;
                axis = (VRectAxis)soc.axes.get(i);
                if (axis.getDimension() != 1 || axis.getPrimary() != p.xPrimary || !((map = axis.getEncoder((byte)1).getValueMap()) instanceof StringToNumericMap)) continue;
                sm = (StringToNumericMap)map;
                try {
                    xval = Math.round((sm.getValue(p.x) - sm.getStartValue()) / sm.getStrideValue());
                }
                catch (MissingValueException e) {
                    xval = 0.0;
                }
                values[0] = xval + p.xOffset;
                break;
            }
        }
        if (doubley) {
            values[1] = ((Number)p.y).doubleValue();
        } else {
            for (i = 0; i < soc.axes.size(); ++i) {
                double yval;
                axis = (VRectAxis)soc.axes.get(i);
                if (axis.getDimension() != 2 || axis.getPrimary() != p.yPrimary || !((map = axis.getEncoder((byte)2).getValueMap()) instanceof StringToNumericMap)) continue;
                sm = (StringToNumericMap)map;
                try {
                    yval = Math.round((sm.getValue(p.x) - sm.getStartValue()) / sm.getStrideValue());
                }
                catch (MissingValueException e) {
                    yval = 0.0;
                }
                values[1] = yval + p.yOffset;
                break;
            }
        }
        return values;
    }

    public Rectangle getGraphBounds() {
        Container parent = StatGraph.getRootPanel(this);
        return parent.getBounds();
    }

    public Rectangle getFrontFaceOuterRegion() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getFrontFaceOuterRegion() : this.getComposite().getOuterRegion();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public Rectangle getBackFaceOuterRegion() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getBackFaceOuterRegion() : this.getComposite().getOuterRegion();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public Rectangle getFrontFaceInnerRegion() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getFrontFaceInnerRegion() : this.getComposite().getInnerRegion();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public Rectangle getBackFaceInnerRegion() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getBackFaceInnerRegion() : this.getComposite().getInnerRegion();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public Rectangle getFrontFaceInnerRegion2() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getFrontFaceInnerRegion2() : this.getComposite().getInnerRegion2();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public Rectangle getBackFaceInnerRegion2() {
        Rectangle r = this.getComposite() instanceof SimpleExtrudedOverlayComposite ? ((SimpleExtrudedOverlayComposite)this.getComposite()).getBackFaceInnerRegion2() : this.getComposite().getInnerRegion2();
        return new Rectangle(r.x + this.getBounds().x, r.y + this.getBounds().y, r.width, r.height);
    }

    public boolean isOneDimensional() {
        Simple2DOverlayComposite soc = this.getComposite();
        return soc != null ? soc.isOneDimensional() : false;
    }

    public boolean isDataOnHorizontalSide() {
        Simple2DOverlayComposite soc = this.getComposite();
        return soc != null ? soc.isDataOnHorizontalSide() : false;
    }

    public int getPreferredSizeOnDataLessSide() {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return -1;
        }
        Insets in = this.getInsets();
        OverlayLayout ol = (OverlayLayout)this.getLayout();
        Insets si = ol.getSurroundingInsets();
        in.left += si.left;
        in.right += si.right;
        in.top += si.top;
        in.bottom += si.bottom;
        if (this.isDataOnHorizontalSide()) {
            return soc.getPreferredSizeOnDataLessSide() + in.top + in.bottom;
        }
        return soc.getPreferredSizeOnDataLessSide() + in.left + in.right;
    }

    public Insets getGridLabelMargin() {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return new Insets(0, 0, 0, 0);
        }
        return soc.getGridLabelMargin();
    }

    public boolean hasGridLabel() {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return false;
        }
        return soc.hasGridLabel();
    }

    public void setLeftGridLabelMaxWidth(double w) {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return;
        }
        soc.setLeftGridLabelMaxWidth(w);
    }

    public void setRightGridLabelMaxWidth(double w) {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return;
        }
        soc.setRightGridLabelMaxWidth(w);
    }

    public void setGridLabelOffsets(int top, int left, int bottom, int right) {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return;
        }
        soc.setGridLabelOffsets(top, left, bottom, right);
    }

    public void addGridLabelEntry(Component entry) {
        Simple2DOverlayComposite soc = this.getComposite();
        if (soc == null) {
            return;
        }
        soc.addGridLabelEntry(entry);
    }
}

