/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellAlignmentInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.OuterPadBorder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public abstract class AbstractSGComponent
extends JPanel
implements CellAlignmentInterface {
    protected boolean _isHorizontal = false;
    protected boolean _isHOriginRight = false;
    protected boolean _isVOriginTop = false;
    protected int _userWidth = -1;
    protected int _userHeight = -1;
    protected int autoAlignStrategy = 0;
    protected String[] preferredLocations = new String[]{"TOPLEFT", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMRIGHT", "TOP", "RIGHT", "BOTTOM", "LEFT", "CENTER"};
    protected boolean fracHAlign = false;
    protected boolean fracVAlign = false;
    private boolean opaque = false;

    public AbstractSGComponent() {
        this.setOpaque(false);
    }

    public AbstractSGComponent(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setOpaque(false);
    }

    public Color getOpaqueBackground() {
        for (Container ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if ((!(ancestor instanceof AbstractSGComponent) || !((AbstractSGComponent)ancestor).isComponentOpaque()) && !ancestor.isOpaque()) continue;
            return ancestor.getBackground();
        }
        return super.getBackground();
    }

    @Override
    public Color getBackground() {
        if (this.isComponentOpaque()) {
            return super.getBackground();
        }
        return this.getOpaqueBackground();
    }

    public boolean isHorizontal() {
        return this._isHorizontal;
    }

    public void setHorizontal(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
    }

    public boolean isHOriginRight() {
        return this._isHOriginRight;
    }

    public void setHOriginRight(boolean isHOriginRight) {
        this._isHOriginRight = isHOriginRight;
    }

    public boolean isVOriginTop() {
        return this._isVOriginTop;
    }

    public void setVOriginTop(boolean isVOriginTop) {
        this._isVOriginTop = isVOriginTop;
    }

    public int getUserWidth() {
        return this._userWidth;
    }

    public void setUserWidth(int userWidth) {
        this._userWidth = userWidth;
    }

    public int getUserHeight() {
        return this._userHeight;
    }

    public void setUserHeight(int userHeight) {
        this._userHeight = userHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension d = super.getPreferredSize();
        if (0 <= this.getUserWidth()) {
            d.width = this.getUserWidth();
        }
        if (0 <= this.getUserHeight()) {
            d.height = this.getUserHeight();
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (0 <= this.getUserWidth()) {
            d.width = this.getUserWidth();
        }
        if (0 <= this.getUserHeight()) {
            d.height = this.getUserHeight();
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (0 <= this.getUserWidth()) {
            d.width = this.getUserWidth();
        }
        if (0 <= this.getUserHeight()) {
            d.height = this.getUserHeight();
        }
        return d;
    }

    public int getAutoAlignStartegy() {
        return this.autoAlignStrategy;
    }

    public void setAutoAlignStrategy(int autoAlignStrategy) {
        this.autoAlignStrategy = autoAlignStrategy;
    }

    public String[] getPreferredLocations() {
        return this.preferredLocations;
    }

    public void setPreferredLocations(String[] preferredLocations) {
        this.preferredLocations = preferredLocations;
    }

    public boolean isFractionalHAlignment() {
        return this.fracHAlign;
    }

    public void setFractionalHAlignment(boolean fracHAlign) {
        this.fracHAlign = fracHAlign;
    }

    public boolean isFractionalVAlignment() {
        return this.fracVAlign;
    }

    public void setFractionalVAlignment(boolean fracVAlign) {
        this.fracVAlign = fracVAlign;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.opaque) {
            g.setColor(this.getBackground());
            Border border = this.getBorder();
            while (border instanceof CompoundBorder) {
                Border outer = ((CompoundBorder)border).getOutsideBorder();
                if (outer == null) continue;
                border = outer;
            }
            if (border instanceof OuterPadBorder) {
                Insets pad = border.getBorderInsets(this);
                g.fillRect(pad.left, pad.top, this.getWidth() - pad.left - pad.right, this.getHeight() - pad.top - pad.bottom);
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        super.paintComponent(g);
    }

    @Override
    public void setOpaque(boolean o) {
        this.opaque = o;
        super.setOpaque(false);
    }

    public boolean isComponentOpaque() {
        return this.opaque;
    }
}

