/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.axis;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ARectangle;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.LineSegment;
import java.awt.Color;
import java.awt.Graphics;

public final class Wall {
    private boolean fillOn = true;
    private FillAttrs fillStyle = new FillAttrs(Color.white);
    private boolean cube = true;
    private boolean edgeOn = true;
    private LineAttrs edgeStyle = new LineAttrs();
    private Channel channel;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean twoD = true;
    private LineAttrs axisLineStyle = new LineAttrs();
    private boolean xAxisLineOn = false;
    private boolean x2AxisLineOn = false;
    private boolean yAxisLineOn = false;
    private boolean y2AxisLineOn = false;

    public Wall() {
        this(true);
    }

    public Wall(boolean b) {
        this.twoD = b;
    }

    public void set2D(boolean b) {
        this.twoD = b;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isVisible() {
        return this.fillOn || this.edgeOn;
    }

    public void drawFill(Graphics g) {
        if (this.channel == null || !this.fillOn) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            this.channel.setSubpixelRendering(false);
        }
        if (this.twoD) {
            this.channel.glPolygonMode(3);
            double sXHalf = this.width / 2;
            double sYHalf = this.height / 2;
            Vec3d center = new Vec3d();
            ARectangle.computeCenter((double)this.width, (double)this.height, (int)5, (Vec3d)center);
            this.channel.glColor(this.fillStyle.getColor());
            this.channel.glRect(center.x - sXHalf, center.y - sYHalf, center.x + sXHalf, center.y + sYHalf);
        } else {
            Box.drawBox((Channel)this.channel, (double)this.width, (double)this.height, (double)this.height, (Color)this.fillStyle.getColor(), (Color)this.edgeStyle.getColor(), (int)3, (this.edgeOn && !this.cube ? 1 : 0) != 0, (boolean)true, (boolean)true);
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    private boolean isAnyAxisLineOn() {
        return this.yAxisLineOn || this.y2AxisLineOn || this.x2AxisLineOn || this.xAxisLineOn;
    }

    public void drawOutline(Graphics g) {
        if (this.channel == null || !this.edgeOn && !this.isAnyAxisLineOn()) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            this.channel.setSubpixelRendering(false);
        }
        if (this.twoD) {
            int lengthOffset;
            Color edgeColor = this.edgeStyle.getColor();
            double edgeThickness = this.edgeStyle.getWidth();
            int edgeFactor = this.edgeStyle.getStippleFactor();
            int edgePattern = this.edgeStyle.getStipplePattern();
            int topOffset = (int)edgeThickness / 2;
            int bottomOffset = (int)(edgeThickness - 1.0) / 2;
            int leftOffset = topOffset;
            int rightOffset = bottomOffset;
            int n = lengthOffset = edgeThickness > 1.0 ? 1 : 0;
            if (this.edgeOn) {
                LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)bottomOffset, (double)0.0, (double)(this.width + lengthOffset), (double)bottomOffset, (double)0.0, (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
                LineSegment.drawLineSegment((Channel)this.channel, (double)(this.width - rightOffset), (double)0.0, (double)0.0, (double)(this.width - rightOffset), (double)this.height, (double)0.0, (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
                LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)(this.height - topOffset), (double)0.0, (double)this.width, (double)(this.height - topOffset), (double)0.0, (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
                LineSegment.drawLineSegment((Channel)this.channel, (double)leftOffset, (double)0.0, (double)0.0, (double)leftOffset, (double)this.height, (double)0.0, (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            }
            if (this.isAnyAxisLineOn()) {
                Color lineColor = this.axisLineStyle.getColor();
                double lineThickness = this.axisLineStyle.getWidth();
                int lineFactor = this.axisLineStyle.getStippleFactor();
                int linePattern = this.axisLineStyle.getStipplePattern();
                topOffset = (int)lineThickness / 2;
                bottomOffset = (int)(lineThickness - 1.0) / 2;
                leftOffset = topOffset;
                rightOffset = bottomOffset;
                int n2 = lengthOffset = lineThickness > 1.0 ? 1 : 0;
                if (this.yAxisLineOn) {
                    LineSegment.drawLineSegment((Channel)this.channel, (double)leftOffset, (double)this.height, (double)0.0, (double)leftOffset, (double)0.0, (double)0.0, (Color)lineColor, (double)lineThickness, (int)linePattern, (int)lineFactor);
                }
                if (this.y2AxisLineOn) {
                    LineSegment.drawLineSegment((Channel)this.channel, (double)(this.width - rightOffset), (double)0.0, (double)0.0, (double)(this.width - rightOffset), (double)this.height, (double)0.0, (Color)lineColor, (double)lineThickness, (int)linePattern, (int)lineFactor);
                }
                if (this.x2AxisLineOn) {
                    LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)(this.height - topOffset), (double)0.0, (double)this.width, (double)(this.height - topOffset), (double)0.0, (Color)lineColor, (double)lineThickness, (int)linePattern, (int)lineFactor);
                }
                if (this.xAxisLineOn) {
                    LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)bottomOffset, (double)0.0, (double)(this.width + lengthOffset), (double)bottomOffset, (double)0.0, (Color)lineColor, (double)lineThickness, (int)linePattern, (int)lineFactor);
                }
            }
        } else if (!this.cube) {
            Box.drawBox((Channel)this.channel, (double)this.width, (double)this.height, (double)this.height, (Color)this.edgeStyle.getColor(), (Color)this.edgeStyle.getColor(), (int)3, (boolean)true, (boolean)false, (boolean)true);
        } else {
            int w = this.width;
            int h = this.height;
            Color edgeColor = this.edgeStyle.getColor();
            double edgeThickness = this.edgeStyle.getWidth();
            int edgeFactor = this.edgeStyle.getStippleFactor();
            int edgePattern = this.edgeStyle.getStipplePattern();
            LineSegment.drawLineSegment((Channel)this.channel, (double)(-w / 2), (double)0.0, (double)(-h / 2), (double)(w / 2), (double)0.0, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(-w / 2), (double)0.0, (double)(-h / 2), (double)(-w / 2), (double)0.0, (double)(h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(w / 2), (double)0.0, (double)(-h / 2), (double)(w / 2), (double)h, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(w / 2), (double)0.0, (double)(h / 2), (double)(w / 2), (double)h, (double)(h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(w / 2), (double)h, (double)(h / 2), (double)(w / 2), (double)h, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(w / 2), (double)h, (double)(h / 2), (double)(-w / 2), (double)h, (double)(h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(-w / 2), (double)h, (double)(h / 2), (double)(-w / 2), (double)h, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(-w / 2), (double)0.0, (double)(-h / 2), (double)(-w / 2), (double)h, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
            LineSegment.drawLineSegment((Channel)this.channel, (double)(-w / 2), (double)h, (double)(-h / 2), (double)(w / 2), (double)h, (double)(-h / 2), (Color)edgeColor, (double)edgeThickness, (int)edgePattern, (int)edgeFactor);
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean aFill) {
        this.fillOn = aFill;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillAttrs aStyle) {
        this.fillStyle = aStyle;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean aEdge) {
        this.edgeOn = aEdge;
    }

    public boolean isCube() {
        return this.cube;
    }

    public void setCube(boolean b) {
        this.cube = b;
    }

    public LineAttrs getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(LineAttrs style) {
        this.edgeStyle = style;
    }

    public LineAttrs getAxisLineStyle() {
        return this.axisLineStyle;
    }

    public void setAxisLineStyle(LineAttrs axisLineStyle) {
        this.axisLineStyle = axisLineStyle;
    }

    public boolean isXAxisLineOn() {
        return this.xAxisLineOn;
    }

    public void setXAxisLineOn(boolean xAxisLineOn) {
        this.xAxisLineOn = xAxisLineOn;
    }

    public boolean isYAxisLineOn() {
        return this.yAxisLineOn;
    }

    public void setYAxisLineOn(boolean yAxisLineOn) {
        this.yAxisLineOn = yAxisLineOn;
    }

    public boolean isY2AxisLineOn() {
        return this.y2AxisLineOn;
    }

    public void setY2AxisLineOn(boolean y2AxisLineOn) {
        this.y2AxisLineOn = y2AxisLineOn;
    }

    public boolean isX2AxisLineOn() {
        return this.x2AxisLineOn;
    }

    public void setX2AxisLineOn(boolean x2AxisLineOn) {
        this.x2AxisLineOn = x2AxisLineOn;
    }
}

