/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.axis;

import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToLogarithmicMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousTimeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Rectangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

public final class VRectGridLines
extends AbstractGridLines {
    private byte dimension = 1;
    private byte direction = (byte)2;
    private double start = 0.0;
    private double end = 0.0;
    private LineSegment line = new LineSegment();
    private LineAttrs minorLineStyle = new LineAttrs();
    protected double[] ticks = null;
    protected int[] visibleTickIndices = null;
    protected boolean tickValuePriority = false;
    private boolean minorGridOn = false;
    private int minorTickCount = -1;
    private boolean shownAtMidpoint = true;
    private boolean greenBarOn = false;
    private Color[] greenBarColor = null;
    private NumericPipe positionOffset = null;
    private NumericPipe minorPositionOffset = null;
    private boolean drawMajorGrid = true;
    private boolean drawMinorGrid = true;
    private double[] visibleTickRange = null;

    public double[] getTicks() {
        return this.ticks;
    }

    public boolean isShownAtMidpoint() {
        return this.shownAtMidpoint;
    }

    public void setShownAtMidpoint(boolean b) {
        this.shownAtMidpoint = b;
    }

    public void setTicks(double[] t) {
        this.ticks = t;
        this.needConnect = true;
    }

    public void setVisibleTickIndices(int[] indices) {
        this.visibleTickIndices = indices;
        this.needConnect = true;
    }

    public void setVisibleTickRange(double[] range) {
        this.visibleTickRange = range;
        this.needConnect = true;
    }

    public void setDimension(byte dimension) {
        this.dimension = dimension;
        this.needConnect = true;
    }

    public byte getDimension() {
        return this.dimension;
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setDirection(byte direction) {
        this.direction = direction;
        this.needConnect = true;
    }

    public void setStart(double start) {
        this.start = start;
        this.needConnect = true;
    }

    public double getStart() {
        return this.start;
    }

    public void setEnd(double end) {
        this.end = end;
        this.needConnect = true;
    }

    public double getEnd() {
        return this.end;
    }

    @Override
    public void setEncoder(PositionEncoder encoder) {
        this.encoder = encoder;
        this.needConnect = true;
    }

    public Insets getExtent() {
        Insets zeros = new Insets(0, 0, 0, 0);
        return zeros;
    }

    public boolean isMinorTicksOn() {
        return this.isMinorGridOn();
    }

    public void setMinorTicksOn(boolean on) {
        this.setMinorGridOn(on);
    }

    public boolean isMinorGridOn() {
        return this.minorGridOn;
    }

    public void setMinorGridOn(boolean on) {
        this.minorGridOn = on;
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int count) {
        this.minorTickCount = count;
    }

    public LineAttrs getMinorLineStyle() {
        return this.minorLineStyle;
    }

    public void setMinorLineStyle(LineAttrs aLineStyle) {
        this.minorLineStyle = aLineStyle;
    }

    public void setGreenBarOn(boolean b) {
        this.greenBarOn = b;
    }

    public boolean isGreenBarOn() {
        return this.greenBarOn;
    }

    public void setGreenBarColor(Color[] c) {
        this.greenBarColor = c;
    }

    public Color[] getGreenBarColor() {
        return this.greenBarColor;
    }

    private boolean canGreenBarBeDrawn() {
        return this.greenBarOn && this.greenBarColor != null && this.encoder.getValueMap() instanceof StringToNumericMap;
    }

    private boolean connect() {
        NumericVector posPipe;
        if (this.encoder == null) {
            return false;
        }
        if (this.canGreenBarBeDrawn()) {
            return this.connectGreenBar();
        }
        this.line.color.setValue(this.lineStyle.getColor());
        this.line.lineWidth.setValue((double)this.lineStyle.getWidth());
        this.line.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
        ValueMap map = this.encoder.getValueMap();
        if (!(map instanceof NumericMap)) {
            return false;
        }
        NumericMap nm = (NumericMap)map;
        nm.init(new AInitAction(null));
        if (this.ticks == null) {
            if (this.visibleTickIndices == null) {
                posPipe = this.positionOffset != null ? this.positionOffset : (!this.shownAtMidpoint && nm instanceof StringToNumericMap ? VRectAxis.getCategoryBoundries(this.encoder, this.encoder.isReversed()) : nm.uniqueValue);
            } else {
                posPipe = new NumericVector();
                if (this.positionOffset != null) {
                    try {
                        for (int i = 0; i < this.visibleTickIndices.length; ++i) {
                            posPipe.addValue(this.positionOffset.getValue(this.visibleTickIndices[i]));
                        }
                    }
                    catch (MissingValueException i) {}
                } else if (!this.shownAtMidpoint && nm instanceof StringToNumericMap) {
                    posPipe = VRectAxis.getCategoryBoundriesInBetween(this.encoder, this.encoder.isReversed(), this.visibleTickIndices);
                } else {
                    try {
                        int count = nm instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)nm).getLabelCount() : ((StringToNumericMap)nm).getUniqueValueCount();
                        boolean reverseUV = !(nm.uniqueValue.getValue(count - 1) > nm.uniqueValue.getValue(0));
                        for (int i = 0; i < this.visibleTickIndices.length; ++i) {
                            if (this.encoder.isReversed() && reverseUV) {
                                posPipe.addValue(nm.uniqueValue.getValue(count - 1 - this.visibleTickIndices[i]));
                                continue;
                            }
                            posPipe.addValue(nm.uniqueValue.getValue(this.visibleTickIndices[i]));
                        }
                    }
                    catch (MissingValueException count) {}
                }
            }
        } else {
            posPipe = new NumericVector();
            if (!(nm instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)nm;
            double eps = VRectAxis.getPrecisionDelta(this.ticks);
            double dMin = Math.min(crnm.getInputMin(), crnm.getInputMax()) - eps;
            double dMax = Math.max(crnm.getInputMin(), crnm.getInputMax()) + eps;
            if (this.visibleTickIndices == null) {
                for (int i = 0; i < this.ticks.length; ++i) {
                    if (!this.tickValuePriority && (!(this.ticks[i] >= dMin) || !(this.ticks[i] <= dMax))) continue;
                    posPipe.addValue(crnm.getValue(this.ticks[i]));
                }
            } else {
                int i;
                int offset = 0;
                if (!this.tickValuePriority) {
                    if (this.encoder.isReversed()) {
                        for (i = this.ticks.length - 1; i >= 0; --i) {
                            if (!(this.ticks[i] >= dMin) || !(this.ticks[i] <= dMax)) continue;
                            offset = i;
                            break;
                        }
                    } else {
                        for (i = 0; i < this.ticks.length; ++i) {
                            if (!(this.ticks[i] >= dMin) || !(this.ticks[i] <= dMax)) continue;
                            offset = i;
                            break;
                        }
                    }
                }
                for (i = 0; i < this.visibleTickIndices.length; ++i) {
                    if (this.encoder.isReversed()) {
                        posPipe.addValue(crnm.getValue(this.ticks[offset - this.visibleTickIndices[i]]));
                        continue;
                    }
                    posPipe.addValue(crnm.getValue(this.ticks[offset + this.visibleTickIndices[i]]));
                }
            }
        }
        if (nm instanceof StringToNumericMap && this.visibleTickRange != null && (this.encoder.getStartOffset() != 0.0 || this.encoder.getStrideOffset() != 0.0)) {
            posPipe = this.trimDiscreteGridlines((StringToNumericMap)nm, (NumericPipe)posPipe);
        }
        switch (this.direction) {
            case 1: {
                this.line.beginX.setValue(this.start);
                this.line.endX.setValue(this.end);
                break;
            }
            case 2: {
                this.line.beginY.setValue(this.start);
                this.line.endY.setValue(this.end);
                break;
            }
            case 3: {
                this.line.beginZ.setValue(this.start);
                this.line.endZ.setValue(this.end);
            }
        }
        switch (this.dimension) {
            case 1: {
                this.line.beginX.connectFrom((NumericPipe)posPipe);
                this.line.endX.connectFrom((NumericPipe)posPipe);
                break;
            }
            case 2: {
                this.line.beginY.connectFrom((NumericPipe)posPipe);
                this.line.endY.connectFrom((NumericPipe)posPipe);
                break;
            }
            case 3: {
                this.line.beginZ.connectFrom((NumericPipe)posPipe);
                this.line.endZ.connectFrom((NumericPipe)posPipe);
            }
        }
        this.root.removeAllElements();
        this.root.addElement((Element)this.line);
        if (this.minorGridOn) {
            NumericVector minorPipe;
            LineSegment minorLine;
            block72: {
                minorLine = new LineSegment();
                this.minorRoot.removeAllElements();
                this.minorRoot.addElement((Element)minorLine);
                minorLine.color.setValue(this.minorLineStyle.getColor());
                minorLine.lineWidth.setValue((double)this.minorLineStyle.getWidth());
                minorLine.setStipple(this.minorLineStyle.getStipplePattern(), this.minorLineStyle.getStippleFactor());
                minorPipe = new NumericVector();
                if (this.minorPositionOffset != null) {
                    minorPipe = this.minorPositionOffset;
                } else if (map instanceof ContinuousRangeToLogarithmicMap) {
                    ContinuousRangeToLogarithmicMap crtlm = (ContinuousRangeToLogarithmicMap)map;
                    try {
                        for (int i = 0; i < crtlm.getMinorTickCount(); ++i) {
                            minorPipe.addValue(crtlm.uniqueMinorValue.getValue(i));
                        }
                    }
                    catch (MissingValueException i) {}
                } else if (map instanceof ContinuousTimeToNumericMap) {
                    ContinuousTimeToNumericMap crtlm = (ContinuousTimeToNumericMap)map;
                    try {
                        if (crtlm.getMinorTickCount() > 0) {
                            for (int i = 0; i < crtlm.getMinorTickCount(); ++i) {
                                minorPipe.addValue(crtlm.uniqueMinorValue.getValue(i));
                            }
                            break block72;
                        }
                        posPipe.init(new AInitAction());
                        int n = posPipe.getValueCount();
                        try {
                            double lastOffset = posPipe.getValue(0);
                            for (int i = 1; i < n; ++i) {
                                double currOffset = posPipe.getValue(i);
                                minorPipe.addValue((lastOffset + currOffset) * 0.5);
                                lastOffset = currOffset;
                            }
                        }
                        catch (MissingValueException missingValueException) {
                        }
                    }
                    catch (MissingValueException n) {}
                } else {
                    NumericVector minor = this.getLinearMinorTickOffset((NumericPipe)posPipe, posPipe.getValueCount());
                    if (minor != null) {
                        try {
                            for (int i = 0; i < minor.getValueCount(); ++i) {
                                minorPipe.addValue(minor.getValue(i));
                            }
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                    }
                }
            }
            switch (this.direction) {
                case 1: {
                    minorLine.beginX.setValue(this.start);
                    minorLine.endX.setValue(this.end);
                    break;
                }
                case 2: {
                    minorLine.beginY.setValue(this.start);
                    minorLine.endY.setValue(this.end);
                    break;
                }
                case 3: {
                    minorLine.beginZ.setValue(this.start);
                    minorLine.endZ.setValue(this.end);
                }
            }
            switch (this.dimension) {
                case 1: {
                    minorLine.beginX.connectFrom((NumericPipe)minorPipe);
                    minorLine.endX.connectFrom((NumericPipe)minorPipe);
                    break;
                }
                case 2: {
                    minorLine.beginY.connectFrom((NumericPipe)minorPipe);
                    minorLine.endY.connectFrom((NumericPipe)minorPipe);
                    break;
                }
                case 3: {
                    minorLine.beginZ.connectFrom((NumericPipe)minorPipe);
                    minorLine.endZ.connectFrom((NumericPipe)minorPipe);
                }
            }
        }
        this.needConnect = false;
        return true;
    }

    private boolean connectGreenBar() {
        StringToNumericMap map = (StringToNumericMap)this.encoder.getValueMap();
        map.init(new AInitAction(null));
        NumericPipe posPipe = map.uniqueValue;
        Rectangle greenBar = new Rectangle();
        greenBar.set2D(true);
        greenBar.fillOn.setValue(true);
        greenBar.edgeOn.setValue(false);
        greenBar.origin.setValue(5);
        ColorVector colVec = new ColorVector();
        NumericVector startVec = new NumericVector();
        NumericVector sizeVec = new NumericVector();
        int n = map.getUniqueValueCount();
        double stride2 = map.getStrideValue() * 0.5;
        double lowerLimit = this.encoder.getLowerLimit();
        double upperLimit = this.encoder.getUpperLimit();
        if (this.encoder.isReversed()) {
            double v1 = upperLimit;
            for (int i = n - 1; i >= 0; --i) {
                double v0;
                try {
                    double v = posPipe.getValue(i);
                    if (i == n - 1) {
                        v1 = Math.min(v + stride2, upperLimit);
                    }
                    v0 = Math.max(v - stride2, lowerLimit);
                }
                catch (MissingValueException e) {
                    v0 = v1;
                }
                if (this.greenBarColor[(n - 1 - i) % 2] != null) {
                    startVec.addValue(v0);
                    sizeVec.addValue(v1 - v0);
                    colVec.addValue(this.greenBarColor[(n - 1 - i) % 2]);
                }
                v1 = v0;
            }
        } else {
            double v0 = lowerLimit;
            for (int i = 0; i < n; ++i) {
                double v1;
                try {
                    double v = posPipe.getValue(i);
                    if (i == 0) {
                        v0 = Math.max(v - stride2, lowerLimit);
                    }
                    v1 = Math.min(v + stride2, upperLimit);
                }
                catch (MissingValueException e) {
                    v1 = v0;
                }
                if (this.greenBarColor[i % 2] != null) {
                    startVec.addValue(v0);
                    sizeVec.addValue(v1 - v0);
                    colVec.addValue(this.greenBarColor[i % 2]);
                }
                v0 = v1;
            }
        }
        greenBar.color.connectFrom((ColorPipe)colVec);
        greenBar.edgeColor.connectFrom((ColorPipe)colVec);
        switch (this.direction) {
            case 1: {
                greenBar.coordX.setValue(this.start);
                greenBar.sizeX.setValue(this.end - this.start);
                break;
            }
            case 2: {
                greenBar.coordY.setValue(this.start);
                greenBar.sizeY.setValue(this.end - this.start);
                break;
            }
        }
        switch (this.dimension) {
            case 1: {
                greenBar.coordX.connectFrom((NumericPipe)startVec);
                greenBar.sizeX.connectFrom((NumericPipe)sizeVec);
                break;
            }
            case 2: {
                greenBar.coordY.connectFrom((NumericPipe)startVec);
                greenBar.sizeY.connectFrom((NumericPipe)sizeVec);
                break;
            }
        }
        this.root.removeAllElements();
        this.root.addElement((Element)greenBar);
        this.needConnect = false;
        return true;
    }

    public NumericPipe trimDiscreteGridlines(StringToNumericMap map, NumericPipe np) {
        NumericVector nv = new NumericVector();
        np.init(new AInitAction(null));
        int count = map.getUniqueValueCount();
        for (int i = 0; i < count; ++i) {
            try {
                double d = np.getValue(i);
                if (!(d >= this.visibleTickRange[0]) || !(d <= this.visibleTickRange[1])) continue;
                nv.addValue(d);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return nv;
    }

    private NumericVector getLinearMinorTickOffset(NumericPipe majorOffset, int majorTickCount) {
        if (majorTickCount < 2 || this.minorTickCount <= 0) {
            return null;
        }
        NumericMap map = (NumericMap)this.encoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return null;
        }
        double min = ((ContinuousPoint)this.gridMin).getValue();
        double max = ((ContinuousPoint)this.gridMax).getValue();
        NumericVector offset = new NumericVector();
        majorOffset.init(new AInitAction());
        try {
            double major1 = majorOffset.getValue(0);
            double major2 = majorOffset.getValue(1);
            if (major1 > major2) {
                NumericVector temp = new NumericVector(majorTickCount);
                for (int i = majorTickCount - 1; i >= 0; --i) {
                    temp.addValue(majorOffset.getValue(i));
                }
                majorOffset = temp;
                major1 = majorOffset.getValue(0);
                major2 = majorOffset.getValue(1);
            }
            double majorInterval = major2 - major1;
            double minorTickSpace = majorInterval / (double)(this.minorTickCount + 1);
            double limit = major1 - majorInterval;
            if (limit < min) {
                limit = min;
            }
            if (limit < major1) {
                int n = 0;
                for (double first = major1 - minorTickSpace; limit < first; first -= minorTickSpace) {
                    ++n;
                }
                for (int i = n; i > 0; --i) {
                    offset.addValue(major1 - (double)i * minorTickSpace);
                }
            }
            for (int i = 0; i < majorTickCount - 1; ++i) {
                double major = majorOffset.getValue(i);
                for (int ii = 1; ii <= this.minorTickCount; ++ii) {
                    offset.addValue(major + (double)ii * minorTickSpace);
                }
            }
            double lastMajor = majorOffset.getValue(majorTickCount - 1);
            limit = lastMajor + majorInterval;
            if (limit > max) {
                limit = max;
            }
            if (lastMajor < limit) {
                for (double last = lastMajor + minorTickSpace; last < limit; last += minorTickSpace) {
                    offset.addValue(last);
                }
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return offset;
    }

    public void draw(Graphics g) {
        if (this.root == null) {
            return;
        }
        Channel channel = this.root.getChannel();
        if (this.needConnect && !this.connect()) {
            return;
        }
        if (this.drawMajorGrid) {
            this.root.draw(channel);
        }
        if (this.drawMinorGrid && this.minorGridOn) {
            this.minorRoot.draw(channel);
        }
    }

    public void setPositionOffset(NumericPipe offset) {
        this.positionOffset = offset;
    }

    public void setMinorPositionOffset(NumericPipe offset) {
        this.minorPositionOffset = offset;
    }

    public boolean isTickValuePriority() {
        return this.tickValuePriority;
    }

    public void setTickValuePriority(boolean tickValuePriority) {
        this.tickValuePriority = tickValuePriority;
    }

    public boolean isDrawMajorGrid() {
        return this.drawMajorGrid;
    }

    public void setDrawMajorGrid(boolean drawMajorGrid) {
        this.drawMajorGrid = drawMajorGrid;
    }

    public boolean isDrawMinorGrid() {
        return this.drawMinorGrid;
    }

    public void setDrawMinorGrid(boolean drawMinorGrid) {
        this.drawMinorGrid = drawMinorGrid;
    }
}

