/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.axis;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.RB;
import com.sas.graphics.applets.statgraph.sgchart.axis.RectAxisParams;
import com.sas.graphics.applets.statgraph.sgchart.axis.TickInterval;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverviewAxisComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.util.DateTimeTickSpacer;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AAxis;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToLogarithmicMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousTimeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.text.Format;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

public final class VRectAxis
extends AbstractAxis
implements AAxis.PostFitProcessor {
    public static final String RB_KEY = "VRectAxis.";
    public static final byte TOP = 0;
    public static final byte BOTTOM = 1;
    public static final byte LEFT = 0;
    public static final byte RIGHT = 2;
    public static final byte FRONT = 0;
    public static final byte BACK = 4;
    public static int OFFSET_BY_AUTO = 0;
    public static int OFFSET_BY_TICKVALUES = 1;
    public static int OFFSET_BY_NUMBER = 2;
    public static int OFFSET_MARGIN = 3;
    private byte position;
    private boolean primary = true;
    private double startOffset = 0.0;
    private double endOffset = 0.0;
    private int minOffsetBy = OFFSET_BY_AUTO;
    private int maxOffsetBy = OFFSET_BY_AUTO;
    private boolean forcedAutoOffset = false;
    private Encoder encoder;
    private int majorNum = 0;
    private TickInterval majorInterval;
    private boolean integerTicks = false;
    private NetworkRoot networkRoot;
    private NetworkRoot root2;
    private RectangularAxis vtkAxis;
    private RectAxisParams params = new RectAxisParams();
    protected SASFormat valueFormat;
    protected SASFormat labelFormat;
    private double userStartOffset = -1.0;
    private double userEndOffset = -1.0;
    private double startCoverage = 0.3;
    private double endCoverage = 0.3;
    private ContinuousRangeToNumericMap axisLabelMap;
    private String[] discreteTicks = null;
    private double[] ticks = null;
    private String[] tickLabels = null;
    private double[] userTicks = null;
    private String[] userTickLabels = null;
    private int nTicks = 6;
    private String tickLabeling = null;
    private String[] compoundFitPolicy = null;
    private StringVector tickVal;
    private NumericVector tickPos;
    private boolean extractScale = false;
    private int tickLabelMaxWidth = -1;
    private int tickLabelMaxDecimals = -1;
    private int tickLabelPreferredDecimals = -1;
    private boolean scientificScale = false;
    private boolean reformat;
    private int tickLabelOffset;
    private String fitStrategy;
    private boolean honorFitStrategy;
    private boolean truncatedTitle;
    private String titleSuffix;
    private boolean thinKeepEnd;
    private boolean titlePositionedAtMax = false;
    private boolean reducedTitleSpace;
    private boolean recomputeTitleSize = false;
    private static Insets zeroInsets = new Insets(0, 0, 0, 0);
    private double gapShrinkScale = 1.0;
    private DateTimeTickSpacer timeTickSpacer;
    public static final int LOG_EXPAND = 0;
    public static final int LOG_EXPONENT = 1;
    public static final int LOG_LINEAR = 2;
    public static final int LOG_AUTO = 3;
    private double logarithmBase = 10.0;
    private int logTickIntervalStyle = 3;
    private int userLogTickIntervalStyle = 3;
    private int userReqMinorNumForLog = -1;
    private ContinuousRangeToLogarithmicMap logMap;
    private int userReqMinorNum = -1;
    private VRectAxis mirrorAxis = null;
    private boolean secondary = false;
    private boolean gridVisible = false;
    private LineAttrs gridStyle = null;
    private Vector glv;
    private LineAttrs minorGridStyle = null;
    private static final double E_MIN = 1.0E-6;
    private static final double E_MAX = 1000000.0;
    boolean useDataFormat = false;
    String[] yFit = new String[]{"thin"};
    public static final int AXISLEGEND_NONE = 0;
    public static final int AXISLEGEND_AUTOMATIC = 1;
    public static final int AXISLEGEND_ALWAYS = 2;
    private int axisLegendFitPolicy = 0;
    private boolean ticksShownAtMidpoint = true;
    private boolean majorTicksOn = true;
    private boolean tickBoxOn = false;
    private boolean greenBarOn = false;
    private Color[] greenBarColor = null;
    public static final int ROTATION_DIAGONAL = 0;
    public static final int ROTATION_VERTICAL = 1;
    public static final int ROTATION_DIAGONAL2 = 2;
    private int tickValueRotation = 0;
    private boolean rotateAlways = false;
    private ArrayList notes = new ArrayList();
    private int labelPosition = 1;
    private Insets labelExtent = new Insets(0, 0, 0, 0);
    private String[] stackedLabels = null;
    private Color background = null;
    private boolean displayStackedLabels = false;
    private int mpc = 0;
    private boolean minorGridOn = false;
    private boolean minorTicksOn = false;
    private boolean compressExtender = false;
    private int tickValueAlignment = -1;
    private double allocatedSize = Double.NaN;
    private boolean splitAlways = false;
    private char[] splitChar = new char[]{' '};
    private int multilineJustification = -1;
    private boolean splitCharDrop = true;
    private double labelSplitWidth = Double.NaN;
    public static final int TICKVALUELIST_POLICY_LIST = 0;
    public static final int TICKVALUELIST_POLICY_UNION = 1;
    public static final int TICKVALUELIST_POLICY_INTERSECTION = 2;
    public static final int TICKVALUELIST_POLICY_DATA = 3;
    private int tickValueListPolicy = 0;
    private boolean titleFit = true;
    private boolean labelsFit = true;
    private int titleFitPolicy = 0;
    private char[] titleSplitChar = new char[]{' '};
    private int multilineTitleJustification = -1;
    private boolean titleSplitCharDrop = true;
    private double titleSplitWidth = Double.NaN;
    private static char invisibleChar = (char)8199;
    private boolean initialFitting = true;
    private String name;
    private OverviewAxisComposite composite = null;
    private double displayMin = Double.NaN;
    private double displayMax = Double.NaN;
    private boolean overviewAxisOn = true;
    private boolean brokenAxis = false;
    private ContinuousRange[] inputRanges = null;
    private ContinuousRange[] outputRanges = null;
    private double[][] tickValues;
    private double[][] minorTickValues;
    private String theTimeFormatName;
    private double axisLineOffsetCoverage = 1.0;
    private boolean hotelText = false;
    public static final int HASH_NONE = 0;
    public static final int HASH_BRACKET = 1;
    public static final int HASH_SLANTED_RIGHT = 2;
    public static final int HASH_SLANTED_LEFT = 3;
    public static final int HASH_SQUIGGLE = 4;
    public static final int HASH_SPARK = 5;
    public static final int HASH_NOTCH = 6;
    public static final int HASH_Z = 7;
    private int brokenAxisHash = 0;
    private int spaceForInnerMargin = 0;

    public VRectAxis(byte dim) {
        this(dim, true);
    }

    public VRectAxis(byte dim, boolean visible) {
        this.setVisible(visible);
        this.setDimension(dim);
        switch (dim) {
            case 1: {
                AxisStyle xStyle = new AxisStyle();
                xStyle.getLabelStyle().setHorizontalJustification(1);
                xStyle.getLabelStyle().setVerticalJustification(0);
                this.setAxisStyle(xStyle);
                break;
            }
            case 2: {
                AxisStyle yStyle = new AxisStyle();
                yStyle.getLabelStyle().setHorizontalJustification(2);
                yStyle.getLabelStyle().setVerticalJustification(1);
                yStyle.getTitleStyle().setAngle(90.0);
                this.setAxisStyle(yStyle);
                break;
            }
            case 3: {
                AxisStyle zStyle = new AxisStyle();
                zStyle.getLabelStyle().setHorizontalJustification(1);
                zStyle.getLabelStyle().setVerticalJustification(0);
                this.setAxisStyle(zStyle);
                this.setPrimary(false);
            }
        }
    }

    public void setAxisLineOffsetCoverage(double c) {
        this.axisLineOffsetCoverage = c;
    }

    public double getAxisLineOffsetCoverage() {
        return this.axisLineOffsetCoverage;
    }

    public void setBrokenAxis(boolean b) {
        this.brokenAxis = b;
    }

    public boolean isBrokenAxis() {
        return this.brokenAxis && (this.getType() == 0 || this.getType() == 5);
    }

    public void setInputDataRanges(ContinuousRange[] ranges) {
        this.inputRanges = ranges;
        if (this.inputRange != null) {
            this.updateOutputRange();
        }
    }

    public ContinuousRange[] getInputDataRanges() {
        return this.inputRanges;
    }

    public ContinuousRange[] getOutputRanges() {
        return this.outputRanges;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public String[] getStackedLabels() {
        return this.stackedLabels;
    }

    public void setStackedLabels(String[] labels) {
        this.stackedLabels = labels;
    }

    public void setDisplayStackedLabels(boolean b) {
        this.displayStackedLabels = b;
    }

    public boolean isDisplayStackedLabels() {
        return this.displayStackedLabels && this.dimension == 2;
    }

    public void setLabelPosition(int pos) {
        this.labelPosition = pos;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setGreenBarOn(boolean b) {
        this.greenBarOn = b;
    }

    public boolean isGreenBarOn() {
        return this.greenBarOn;
    }

    public void setGreenBarColor(Color[] c) {
        this.greenBarColor = c;
    }

    public Color[] getGreenBarColor() {
        return this.greenBarColor;
    }

    public boolean isTicksShownAtMidpoint() {
        return this.ticksShownAtMidpoint;
    }

    public void setTicksShownAtMidpoint(boolean b) {
        this.ticksShownAtMidpoint = b;
    }

    public boolean isTickBoxOn() {
        return this.tickBoxOn;
    }

    public void setTickBoxOn(boolean b) {
        this.tickBoxOn = b;
    }

    public boolean isMajorTicksOn() {
        return this.majorTicksOn;
    }

    public void setMajorTicksOn(boolean b) {
        this.majorTicksOn = b;
    }

    public boolean isMajorTickMarksOn() {
        return this.axisStyle.isMajorTickMarksOn() || this.axisStyle.isTickBoxOn() || this.axisStyle.getTickBoxBackground() != null;
    }

    public void setSplitChar(char[] c) {
        this.splitChar = c;
    }

    public char[] getSplitChar() {
        return this.splitChar;
    }

    public void setMultilineJustification(int just) {
        this.multilineJustification = just;
    }

    public int getMultilineJustification() {
        return this.multilineJustification;
    }

    public void setSplitCharDrop(boolean b) {
        this.splitCharDrop = b;
    }

    public boolean isSplitCharDrop() {
        return this.splitCharDrop;
    }

    public void setTickValueAlignment(int align) {
        this.tickValueAlignment = align;
    }

    public int getTickValueAlignment() {
        return this.tickValueAlignment;
    }

    public void setAllocatedSize(double size) {
        this.allocatedSize = size;
    }

    public double getAllocatedSize() {
        return this.allocatedSize;
    }

    public int getAxisLegendFitPolicy() {
        return this.axisLegendFitPolicy;
    }

    public void setAxisLegendFitPolicy(int policy) {
        this.axisLegendFitPolicy = policy;
    }

    public void setGapShrinkScale(double scale) {
        this.gapShrinkScale = scale;
    }

    public int getNTicks() {
        return this.nTicks;
    }

    public void setNTicks(int aInt) {
        this.nTicks = aInt;
    }

    public boolean isUseDataFormat() {
        return this.useDataFormat;
    }

    public void setUseDataFormat(boolean b) {
        this.useDataFormat = b;
    }

    public void setValueFormat(SASFormat format) {
        this.valueFormat = format;
    }

    public SASFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setLabelFormat(SASFormat format) {
        this.labelFormat = format;
    }

    public void clearFitStrategy() {
        this.fitStrategy = null;
        this.forcedAutoOffset = false;
    }

    public void setGridlines(Vector glv) {
        this.glv = glv;
    }

    public void setTickValueRotation(int rotation) {
        this.tickValueRotation = rotation;
    }

    public int getTickValueRotation() {
        return this.tickValueRotation;
    }

    public void setTickLabeling(String policy) {
        this.honorFitStrategy = false;
        this.thinKeepEnd = false;
        String rotate = "";
        this.compoundFitPolicy = null;
        if (this.tickValueRotation == 0) {
            rotate = this.primary ? "angle315" : "angle45";
        } else if (this.tickValueRotation == 2) {
            rotate = this.primary ? "angle45" : "angle315";
        } else if (this.tickValueRotation == 1) {
            String string = rotate = this.primary ? "angle90" : "angle90";
        }
        if (policy.equalsIgnoreCase("THIN")) {
            this.tickLabeling = "thin";
            this.thinKeepEnd = true;
        } else if (policy.equalsIgnoreCase("STAGGER")) {
            this.tickLabeling = "stagger";
        } else if (policy.equalsIgnoreCase("TRUNCATE")) {
            this.tickLabeling = "truncate";
        } else if (policy.equalsIgnoreCase("SPLITALWAYS")) {
            this.tickLabeling = "extendedsplitalways";
            this.splitAlways = true;
        } else if (policy.equalsIgnoreCase("SPLIT")) {
            this.tickLabeling = "extendedsplit";
        } else if (policy.equalsIgnoreCase("SPLITTHIN")) {
            this.tickLabeling = "extendedsplitthin";
        } else if (policy.equalsIgnoreCase("SPLITALWAYSTHIN")) {
            this.tickLabeling = "extendedsplitalwaysthin";
            this.splitAlways = true;
        } else if (policy.equalsIgnoreCase("SPLITROTATE")) {
            this.tickLabeling = "extendedsplit" + rotate;
            this.honorFitStrategy = true;
            this.compoundFitPolicy = new String[]{"extendedsplit", rotate};
        } else if (policy.equalsIgnoreCase("ROTATE")) {
            this.tickLabeling = rotate;
            this.honorFitStrategy = true;
        } else if (policy.equalsIgnoreCase("ROTATETHIN")) {
            this.tickLabeling = rotate + "thin";
            this.honorFitStrategy = true;
        } else if (policy.equalsIgnoreCase("STAGGERROTATE")) {
            this.tickLabeling = "stagger" + rotate;
            this.compoundFitPolicy = new String[]{"stagger", rotate};
        } else if (policy.equalsIgnoreCase("STAGGERTHIN")) {
            this.tickLabeling = "staggerthin";
        } else if (policy.equalsIgnoreCase("ROTATETRUNCATE")) {
            this.tickLabeling = rotate + "truncate";
            this.honorFitStrategy = true;
        } else if (policy.equalsIgnoreCase("STAGGERTRUNCATE")) {
            this.tickLabeling = "staggertruncate";
        } else if (policy.equalsIgnoreCase("STAGGERTRUNCATEDROP")) {
            this.tickLabeling = "staggertruncatedropnolabels";
        } else if (policy.equalsIgnoreCase("TRUNCATESTAGGER")) {
            this.tickLabeling = "truncatestagger";
        } else if (policy.equalsIgnoreCase("TRUNCATEROTATE")) {
            this.tickLabeling = "truncate" + rotate;
            this.compoundFitPolicy = new String[]{"truncate", rotate};
        } else if (policy.equalsIgnoreCase("TRUNCATETHIN")) {
            this.tickLabeling = "truncatethin";
        } else if (policy.equalsIgnoreCase("PERCENTILETHINFROMMIN")) {
            this.tickLabeling = this.isReverse() ? "thin_end_to_beginning" : "thin_beginning_to_end";
        } else if (policy.equalsIgnoreCase("PERCENTILETHINFROMMEDIAN")) {
            this.tickLabeling = "thin_inside_to_outside";
        } else if (policy.equalsIgnoreCase("PERCENTILETHINFROMMAX")) {
            this.tickLabeling = this.isReverse() ? "thin_beginning_to_end" : "thin_end_to_beginning";
        } else if (policy.equalsIgnoreCase("THINLOGARITHMIC")) {
            this.tickLabeling = this.isReverse() ? "thin_beginning_to_end" : "thin_end_to_beginning";
        } else if (policy.equalsIgnoreCase("NONE")) {
            this.tickLabeling = "";
        } else if (policy.equalsIgnoreCase("ROTATEALWAYS")) {
            this.fitStrategy = this.tickLabeling = rotate;
            this.honorFitStrategy = true;
            this.rotateAlways = true;
        } else if (policy.equalsIgnoreCase("ROTATEALWAYSDROP")) {
            this.fitStrategy = this.tickLabeling = rotate + "undoforcefit" + "nolabels";
            this.honorFitStrategy = true;
            this.rotateAlways = true;
        } else if (policy.equalsIgnoreCase("STACKEDALWAYS")) {
            this.tickLabeling = "extendedsplitalways";
            this.splitAlways = true;
            this.hotelText = true;
        } else if (policy.equalsIgnoreCase("STACKEDALWAYSTHIN")) {
            this.tickLabeling = "extendedsplitalwaysthin";
            this.splitAlways = true;
            this.hotelText = true;
        } else {
            StatGraph.printOptionError("TICKVALUEFITPOLICY", policy);
        }
    }

    public String getFitPolicy() {
        return this.tickLabeling;
    }

    public void setFitPolicy(String str) {
        this.tickLabeling = str;
    }

    public void setCompoundFitPolicy(String[] str) {
        this.compoundFitPolicy = str;
    }

    public String[] getCompoundFitPolicy() {
        return this.compoundFitPolicy;
    }

    public boolean isHonorFitStartegy() {
        return this.honorFitStrategy;
    }

    public void setHonorFitStartegy(boolean b) {
        this.honorFitStrategy = b;
    }

    public boolean isRotateAlways() {
        return this.rotateAlways;
    }

    public void setRotateAlways(boolean b) {
        this.rotateAlways = b;
    }

    public boolean isSplitAlways() {
        return this.splitAlways;
    }

    public void setSplitAlways(boolean b) {
        this.splitAlways = b;
    }

    public boolean isHotelText() {
        return this.hotelText;
    }

    public void setHotelText(boolean b) {
        this.hotelText = b;
    }

    public ContinuousRangeToNumericMap getAxisLabelMap() {
        return this.axisLabelMap;
    }

    public byte getPosition() {
        return this.position;
    }

    public void setPosition(byte aPosition) {
        this.position = aPosition;
    }

    public void setTitlePositionedAtMax(boolean atMax) {
        this.titlePositionedAtMax = atMax;
    }

    public boolean isTitlePositionedAtMax() {
        return this.titlePositionedAtMax;
    }

    public int getTitleFitPolicy() {
        return this.titleFitPolicy;
    }

    public void setTitleFitPolicy(int policy) {
        this.titleFitPolicy = policy;
    }

    public void setTitleSplitChar(char[] c) {
        this.titleSplitChar = c;
    }

    public char[] getTitleSplitChar() {
        return this.titleSplitChar;
    }

    public void setMultilineTitleJustification(int just) {
        this.multilineTitleJustification = just;
    }

    public int getMultilineTitleJustification() {
        return this.multilineTitleJustification;
    }

    public void setTitleSplitCharDrop(boolean b) {
        this.titleSplitCharDrop = b;
    }

    public boolean isTitleSplitCharDrop() {
        return this.titleSplitCharDrop;
    }

    public boolean isIntegerTicks() {
        return this.integerTicks;
    }

    public void setIntegerTicks(boolean aBoolean) {
        this.integerTicks = aBoolean;
    }

    public void setReducedTitleSpace(boolean b) {
        this.reducedTitleSpace = b;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        int lo;
        int ao;
        if (this.isBrokenAxis()) {
            this.setEncoder(dimension, encoder, this.outputRanges);
            return;
        }
        if (dimension != this.dimension) {
            return;
        }
        Encoder oldE = this.encoder;
        this.encoder = encoder;
        if (encoder == null) {
            return;
        }
        if (encoder.equals(oldE)) {
            return;
        }
        DataRange range = encoder.getInput();
        if (range == null) {
            return;
        }
        if (range instanceof ContinuousRange && this.inputRange instanceof SimpleBinnedRange) {
            this.inputRange = new ContinuousRange(this.inputRange);
        }
        if (range instanceof StubRange || range instanceof DiscreteRange && ((DiscreteRange)range).isEmpty()) {
            this.visible = false;
            return;
        }
        double length = 1.0;
        PositionEncoder pe = (PositionEncoder)encoder;
        length = pe.getOutputMax() - pe.getOutputMin();
        NumericMap map = (NumericMap)encoder.getValueMap();
        if (map == null || length == 0.0) {
            return;
        }
        pe.setMPC(this.mpc);
        boolean eFormat = false;
        this.reformat = false;
        if (this.useDataFormat) {
            this.valueFormat = range.getFormat();
        }
        if (range instanceof ContinuousRange || range.getDual() instanceof ContinuousRange) {
            SASFormat sasFmt;
            GTKFormat mapfmt;
            ContinuousRange cr = null;
            if (range instanceof ContinuousRange) {
                cr = (ContinuousRange)range;
                this.reformat = true;
            } else {
                cr = (ContinuousRange)range.getDual();
                cr.setFormat(range.getFormat());
            }
            SASFormat fmt = cr.getFormat();
            if (this.valueFormat != null) {
                mapfmt = new GTKFormat((Format)this.valueFormat);
                this.reformat = false;
            } else if (fmt != null) {
                mapfmt = new GTKFormat((Format)fmt);
                if (!this.isGGOODSupportedFormat(fmt)) {
                    this.reformat = false;
                }
            } else {
                double r = Math.abs(cr.getMax() - cr.getMin());
                fmt = r != 0.0 && r < 1.0E-9 ? SASFormat.getInstance((String)"E8.") : DataModel.defaultFormat;
                mapfmt = new GTKFormat((Format)fmt);
            }
            map.setFormat(mapfmt);
            if (mapfmt != null && (sasFmt = (SASFormat)mapfmt.getFormats()[0]).getName().toUpperCase().charAt(0) == 'E' && (sasFmt.getName().length() == 1 || sasFmt.getName().length() >= 2 && Character.isDigit(sasFmt.getName().charAt(1)))) {
                eFormat = true;
            }
            if (this.reformat && this.getType() == 0) {
                this.reformat = this.isReformatPossible();
            }
            if (this.getType() == 1) {
                ContinuousRangeToLogarithmicMap crtlm = (ContinuousRangeToLogarithmicMap)map;
                crtlm.setZeroRangeOutput(2);
                crtlm.setBase(this.logarithmBase);
                crtlm.setExtractScale(this.logTickIntervalStyle == 1);
                crtlm.setUniformTickValues(this.logTickIntervalStyle == 2);
                if (this.isLogTimeAxis(fmt)) {
                    if (this.valueFormat == null) {
                        mapfmt = new GTKFormat((Format)SASFormat.getInstance((String)this.timeTickSpacer.getFormatName(true)));
                    }
                    crtlm.setFormat(mapfmt);
                    double[] t = this.timeTickSpacer.getTickValues();
                    if (t[0] <= 0.0) {
                        t[0] = cr.getMin();
                    }
                    crtlm.setMajorTickValues(t);
                    if (this.params.getMinorNum() > 0) {
                        crtlm.setMinorTickValues(this.timeTickSpacer.getMinorTickValues());
                    }
                } else {
                    if (this.logTickIntervalStyle == 1) {
                        mapfmt = new GTKFormat((Format)DataModel.defaultFormat);
                    } else if (this.reformat) {
                        if (this.isNamedFormat(fmt)) {
                            int w = fmt.getFormatDescription().getMaxWidth();
                            int d = fmt.getDecimalWidth();
                            fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                            fmt.setInsertBlanks(false);
                            mapfmt = new GTKFormat((Format)fmt);
                        } else if (this.logarithmBase == 10.0 && (this.logTickIntervalStyle == 0 || this.logTickIntervalStyle == 3) && (cr.getMax() >= 1000000.0 || cr.getMin() <= 1.0E-6)) {
                            mapfmt = new GTKFormat((Format)SASFormat.getInstance((String)"E8"));
                            eFormat = true;
                        } else {
                            mapfmt = new GTKFormat((Format)DataModel.defaultFormat);
                        }
                    }
                    crtlm.setFormat(mapfmt);
                    crtlm.setMajorTickValues(this.logMap.getMajorTickValues());
                    if (this.params.getMinorNum() > 0) {
                        crtlm.setMinorTickValues(this.logMap.getMinorTickValues());
                    } else {
                        crtlm.setMinorTickValues(null);
                    }
                }
            } else if (this.getType() == 5 && fmt != null && fmt instanceof SASDateTimeFormat && this.ticks == null) {
                ContinuousTimeToNumericMap cttnm = (ContinuousTimeToNumericMap)map;
                if (this.valueFormat == null) {
                    mapfmt = new GTKFormat((Format)SASFormat.getInstance((String)this.timeTickSpacer.getFormatName(true)));
                    if (!fmt.getName().equals(this.timeTickSpacer.getFormatName(true))) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "tgood.fmt.txt"));
                        this.issueSASNote(msg.toString((Object)fmt.getName()));
                    }
                }
                if (this.timeTickSpacer.isInvalidUserMinorInterval()) {
                    this.issueSASNote(RB.getStringResource(RB_KEY, "minorinterval.txt"));
                }
                cttnm.setFormat(mapfmt);
                if (this.dynamic && this.params.getMinorNum() <= 0) {
                    cttnm.setMajorTickValues(this.trimTimeTickvalues(cr, this.timeTickSpacer.getTickValues()));
                } else {
                    cttnm.setMajorTickValues(this.timeTickSpacer.getTickValues());
                }
                if (this.params.getMinorNum() > 0) {
                    cttnm.setMinorTickValues(this.timeTickSpacer.getMinorTickValues());
                }
                if (dimension == 1 && this.params.isSplitTickValue() && this.valueFormat == null) {
                    cttnm.setSplitDateTime(true);
                }
            } else {
                this.setType(0);
                ContinuousRangeToNumericMap crtnm = (ContinuousRangeToNumericMap)map;
                crtnm.setZeroRangeOutput(2);
                BinnedRange sbr = null;
                if (this.inputRange instanceof BinnedRange) {
                    this.axisLabelMap = null;
                    if (range instanceof BinnedRange) {
                        sbr = (BinnedRange)range;
                    } else if (range.getDual() instanceof BinnedRange) {
                        sbr = (BinnedRange)range.getDual();
                    }
                } else if (range instanceof BinnedRange) {
                    this.axisLabelMap = null;
                    sbr = (BinnedRange)range;
                }
                if (sbr != null) {
                    this.setTicks(VRectAxis.getBinTickList(sbr));
                } else {
                    crtnm.setLabelCount(this.majorNum);
                }
            }
        } else if (range instanceof DiscreteRange) {
            GTKFormat mapfmt;
            this.setType(6);
            SASFormat fmt = range.getFormat();
            if (this.valueFormat != null && this.valueFormat.isCharacterFormat()) {
                mapfmt = new GTKFormat((Format)this.valueFormat);
                map.setFormat(mapfmt);
            } else if (fmt != null && fmt.isCharacterFormat()) {
                mapfmt = new GTKFormat((Format)fmt);
                map.setFormat(mapfmt);
            }
            if (StatGraph.MPC > 0 || pe.getMPC() > 0) {
                int numCategories = StatGraph.MPC > 0 ? StatGraph.MPC : pe.getMPC();
                DiscreteRange dr = (DiscreteRange)range;
                if (dr.getValuesSize() < numCategories) {
                    dr.setMPCBlankCount(numCategories - dr.getValuesSize());
                    Vector oldValues = dr.getValues();
                    Vector newValues = new Vector();
                    for (int i = 0; i < numCategories; ++i) {
                        if (i < oldValues.size()) {
                            newValues.addElement(oldValues.elementAt(i));
                            continue;
                        }
                        newValues.addElement("");
                    }
                    dr.setValues(newValues);
                }
            }
        }
        if (this.vtkAxis == null) {
            if (dimension == 1) {
                this.vtkAxis = RectangularAxis.getXAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else if (dimension == 2) {
                this.vtkAxis = RectangularAxis.getYAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else if (dimension == 3) {
                this.vtkAxis = RectangularAxis.getZAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else {
                return;
            }
            this.vtkAxis.setSVGRender(StatGraph.VGF);
        }
        String suffix = "";
        if (this.vtkAxis != null) {
            ContinuousRangeToNumericMap crnm;
            int i;
            if (this.getType() == 1) {
                ContinuousRangeToLogarithmicMap crtlm = (ContinuousRangeToLogarithmicMap)map;
                if (eFormat) {
                    crtlm.init((AInitAction)new InitAction(null));
                    this.vtkAxis.labels.connectFrom(this.getTrimmedLabel(crtlm.label, crtlm.getLabelCount()));
                } else {
                    this.vtkAxis.labels.connectFrom(crtlm.label);
                }
                this.vtkAxis.labelOffset.connectFrom(crtlm.uniqueValue);
                if (this.params.getMinorNum() > 0) {
                    this.vtkAxis.minorTickOffset.connectFrom(crtlm.uniqueMinorValue);
                }
            } else if (this.getType() == 6) {
                int mpc = ((DiscreteRange)range).getMPCBlankCount();
                if (mpc == 0) {
                    if (this.tickLabels != null) {
                        int i2;
                        this.tickVal = new StringVector();
                        int neededLabelCount = ((DiscreteRange)range).getValuesSize();
                        int userLabelCount = this.tickLabels.length;
                        if (this.isReverse()) {
                            for (i2 = neededLabelCount - 1; i2 >= 0; --i2) {
                                if (i2 >= userLabelCount) {
                                    try {
                                        this.tickVal.addValue(map.label.getValue(i2));
                                    }
                                    catch (MissingValueException e) {
                                        this.tickVal.addValue("");
                                    }
                                    continue;
                                }
                                this.tickVal.addValue(this.tickLabels[i2].trim());
                            }
                        } else {
                            for (i2 = 0; i2 < neededLabelCount; ++i2) {
                                if (i2 < userLabelCount) {
                                    this.tickVal.addValue(this.tickLabels[i2].trim());
                                    continue;
                                }
                                try {
                                    this.tickVal.addValue(map.label.getValue(i2));
                                    continue;
                                }
                                catch (MissingValueException e) {
                                    this.tickVal.addValue("");
                                }
                            }
                        }
                        this.vtkAxis.labels.connectFrom((StringPipe)this.tickVal);
                    } else {
                        this.vtkAxis.labels.connectFrom(map.label);
                    }
                    this.vtkAxis.labelOffset.connectFrom(map.uniqueValue);
                } else {
                    int size = ((DiscreteRange)range).getValuesSize() - mpc;
                    this.tickVal = new StringVector(size);
                    this.tickPos = new NumericVector(size);
                    map.init(new AInitAction(null));
                    try {
                        for (int i3 = 0; i3 < size; ++i3) {
                            if (this.tickLabels != null) {
                                if (i3 < this.tickLabels.length) {
                                    this.tickVal.addValue(this.tickLabels[i3].trim());
                                } else {
                                    try {
                                        this.tickVal.addValue(map.label.getValue(i3));
                                    }
                                    catch (MissingValueException e) {
                                        this.tickVal.addValue("");
                                    }
                                }
                            } else {
                                this.tickVal.addValue(map.label.getValue(i3));
                            }
                            this.tickPos.addValue(map.uniqueValue.getValue(i3));
                        }
                    }
                    catch (MissingValueException i3) {
                        // empty catch block
                    }
                    this.vtkAxis.labels.connectFrom((StringPipe)this.tickVal);
                    this.vtkAxis.labelOffset.connectFrom((NumericPipe)this.tickPos);
                }
                if (!this.ticksShownAtMidpoint) {
                    NumericPipe np = VRectAxis.getCategoryBoundries((PositionEncoder)encoder, this.isReverse());
                    this.vtkAxis.majorTickOffset.connectFrom(np);
                }
                if (this.dynamic) {
                    this.trimDiscreteTickvalues(((DiscreteRange)range).getValuesSize());
                }
                if (this.hotelText) {
                    this.vtkAxis.setHotelText(true);
                }
            } else if (this.axisLabelMap != null && this.ticks == null) {
                ContinuousRangeToNumericMap crnm2 = (ContinuousRangeToNumericMap)map;
                this.axisLabelMap.setOutputMin(crnm2.getValue(this.axisLabelMap.getInputMin()));
                this.axisLabelMap.setOutputMax(crnm2.getValue(this.axisLabelMap.getInputMax()));
                if (this.reformat) {
                    double min = this.axisLabelMap.getInputMin();
                    double max = this.axisLabelMap.getInputMax();
                    double inc = this.majorInterval.getSize();
                    Object[] gGoodLabels = this.getGGoodLabels(min, max, inc, this.axisLabelMap.getLabelCount());
                    StringVector labels = (StringVector)gGoodLabels[0];
                    suffix = (String)gGoodLabels[1];
                    this.vtkAxis.labels.connectFrom((StringPipe)labels);
                } else {
                    this.axisLabelMap.setFormat(map.getFormat());
                    this.vtkAxis.labels.connectFrom(this.getAxisLabels((NumericMap)this.axisLabelMap, eFormat));
                }
                this.vtkAxis.labelOffset.connectFrom(this.axisLabelMap.uniqueValue);
                this.connectMinorTickOffset(this.axisLabelMap.uniqueValue, this.axisLabelMap.getLabelCount());
                encoder.setAxisLabelMap((ValueMap)this.axisLabelMap);
            } else if (this.ticks != null) {
                ContinuousRangeToNumericMap crnm3;
                this.vtkAxis.minorTickOffset.setValue(0.0);
                int majorTickCount = 0;
                if (this.tickLabels != null) {
                    GTKFormat tickFmt = map.getFormat();
                    if (!this.isUniformTicks() && !this.isNamedFormat((SASFormat)tickFmt.getFormats()[0])) {
                        tickFmt = new GTKFormat((Format)DataModel.defaultFormat);
                    }
                    this.tickVal = new StringVector(this.ticks.length);
                    this.tickPos = new NumericVector(this.ticks.length);
                    crnm3 = (ContinuousRangeToNumericMap)map;
                    int userLabelCount = this.tickLabels.length;
                    double eps = VRectAxis.getPrecisionDelta(this.ticks);
                    double dMin = Math.min(crnm3.getInputMin(), crnm3.getInputMax()) - eps;
                    double dMax = Math.max(crnm3.getInputMin(), crnm3.getInputMax()) + eps;
                    for (i = 0; i < this.ticks.length; ++i) {
                        if (!this.tickValuePriority && (this.ticks[i] < dMin || this.ticks[i] > dMax)) continue;
                        if (!Double.isNaN(this.origin) && this.ticks[i] == this.origin) {
                            if (this.isLabelOrigin()) {
                                if (i < userLabelCount) {
                                    this.tickVal.addValue(this.tickLabels[i].trim());
                                } else if (eFormat) {
                                    this.tickVal.addValue(NumericFormat.getTrimmedValue((String)tickFmt.format((Object)new Double(this.ticks[i])).trim()));
                                } else {
                                    this.tickVal.addValue(tickFmt.format((Object)new Double(this.ticks[i])).trim());
                                }
                            } else {
                                this.tickVal.addValue("");
                            }
                        } else if (i < userLabelCount) {
                            this.tickVal.addValue(this.tickLabels[i].trim());
                        } else if (eFormat) {
                            this.tickVal.addValue(NumericFormat.getTrimmedValue((String)tickFmt.format((Object)new Double(this.ticks[i])).trim()));
                        } else {
                            this.tickVal.addValue(tickFmt.format((Object)new Double(this.ticks[i])).trim());
                        }
                        this.tickPos.addValue(crnm3.getValue(this.ticks[i]));
                        ++majorTickCount;
                    }
                    this.vtkAxis.labels.connectFrom((StringPipe)this.tickVal);
                    this.vtkAxis.labelOffset.connectFrom((NumericPipe)this.tickPos);
                } else if (this.reformat && this.isUniformTicks()) {
                    double min = this.ticks[0];
                    double max = this.ticks[this.ticks.length - 1];
                    double inc = this.ticks[1] - this.ticks[0];
                    Object[] gGoodLabels = this.getGGoodLabels(min, max, inc, this.ticks.length);
                    StringVector labels = (StringVector)gGoodLabels[0];
                    suffix = (String)gGoodLabels[1];
                    this.tickVal = new StringVector(this.ticks.length);
                    this.tickPos = new NumericVector(this.ticks.length);
                    crnm = (ContinuousRangeToNumericMap)map;
                    this.tickLabelOffset = -1;
                    double eps = VRectAxis.getPrecisionDelta(this.ticks);
                    double dMin = Math.min(crnm.getInputMin(), crnm.getInputMax()) - eps;
                    double dMax = Math.max(crnm.getInputMin(), crnm.getInputMax()) + eps;
                    for (int i4 = 0; i4 < this.ticks.length; ++i4) {
                        if (!this.tickValuePriority && (this.ticks[i4] < dMin || this.ticks[i4] > dMax)) continue;
                        this.tickPos.addValue(crnm.getValue(this.ticks[i4]));
                        try {
                            this.tickVal.addValue(labels.getValue(i4));
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                        if (this.isReverse()) {
                            this.tickLabelOffset = i4;
                        } else if (this.tickLabelOffset == -1) {
                            this.tickLabelOffset = i4;
                        }
                        ++majorTickCount;
                    }
                    this.vtkAxis.labels.connectFrom((StringPipe)this.tickVal);
                    this.vtkAxis.labelOffset.connectFrom((NumericPipe)this.tickPos);
                } else {
                    GTKFormat tickFmt = map.getFormat();
                    if (this.valueFormat == null && !this.isUniformTicks() && !this.isNamedFormat((SASFormat)tickFmt.getFormats()[0])) {
                        tickFmt = new GTKFormat((Format)DataModel.defaultFormat);
                    }
                    this.tickVal = new StringVector(this.ticks.length);
                    this.tickPos = new NumericVector(this.ticks.length);
                    crnm3 = (ContinuousRangeToNumericMap)map;
                    double eps = VRectAxis.getPrecisionDelta(this.ticks);
                    double dMin = Math.min(crnm3.getInputMin(), crnm3.getInputMax()) - eps;
                    double dMax = Math.max(crnm3.getInputMin(), crnm3.getInputMax()) + eps;
                    for (int i5 = 0; i5 < this.ticks.length; ++i5) {
                        if (!this.tickValuePriority && (this.ticks[i5] < dMin || this.ticks[i5] > dMax)) continue;
                        if (!Double.isNaN(this.origin) && this.ticks[i5] == this.origin) {
                            if (this.isLabelOrigin()) {
                                if (eFormat) {
                                    this.tickVal.addValue(NumericFormat.getTrimmedValue((String)tickFmt.format((Object)new Double(this.ticks[i5])).trim()));
                                } else {
                                    this.tickVal.addValue(tickFmt.format((Object)new Double(this.ticks[i5])).trim());
                                }
                            } else {
                                this.tickVal.addValue("");
                            }
                        } else if (eFormat) {
                            this.tickVal.addValue(NumericFormat.getTrimmedValue((String)tickFmt.format((Object)new Double(this.ticks[i5])).trim()));
                        } else {
                            this.tickVal.addValue(tickFmt.format((Object)new Double(this.ticks[i5])).trim());
                        }
                        this.tickPos.addValue(crnm3.getValue(this.ticks[i5]));
                        ++majorTickCount;
                    }
                    this.vtkAxis.labels.connectFrom((StringPipe)this.tickVal);
                    this.vtkAxis.labelOffset.connectFrom((NumericPipe)this.tickPos);
                }
                if (this.ticks.length > 0) {
                    ContinuousRangeToNumericMap aMap = new ContinuousRangeToNumericMap();
                    aMap.setInputMin(this.ticks[0]);
                    aMap.setInputMax(this.ticks[this.ticks.length - 1]);
                    aMap.setLabelCount(this.ticks.length);
                    aMap.init(new AInitAction(null));
                    encoder.setAxisLabelMap((ValueMap)aMap);
                    if (this.isUniformTicks()) {
                        this.connectMinorTickOffset((NumericPipe)this.tickPos, majorTickCount);
                    } else {
                        this.getRectAxisParams().setMinorNum(0);
                        if (this.isMinorTicksOn() || this.isMinorGridOn()) {
                            this.issueSASNote(RB.getStringResource(RB_KEY, "minorticks.txt"));
                        }
                    }
                }
            } else {
                if (this.reformat) {
                    double min = ((ContinuousRange)range).getMin();
                    double max = ((ContinuousRange)range).getMax();
                    double inc = this.majorInterval.getSize();
                    Object[] gGoodLabels = this.getGGoodLabels(min, max, inc, ((ContinuousRangeToNumericMap)map).getLabelCount());
                    StringVector labels = (StringVector)gGoodLabels[0];
                    suffix = (String)gGoodLabels[1];
                    NumericVector offsets = new NumericVector();
                    if (this.isReverse() || this.getDimension() == 3) {
                        crnm = (ContinuousRangeToNumericMap)map;
                        for (i = 0; i < crnm.getLabelCount(); ++i) {
                            offsets.addValue(crnm.getValue(min + inc * (double)i));
                        }
                    } else {
                        offsets = map.uniqueValue;
                    }
                    this.vtkAxis.labels.connectFrom((StringPipe)labels);
                    this.vtkAxis.labelOffset.connectFrom((NumericPipe)offsets);
                    this.connectMinorTickOffset((NumericPipe)offsets, ((ContinuousRangeToNumericMap)map).getLabelCount());
                } else {
                    this.vtkAxis.labels.connectFrom(this.getAxisLabels(map, eFormat));
                    this.vtkAxis.labelOffset.connectFrom(map.uniqueValue);
                    this.connectMinorTickOffset(map.uniqueValue, ((ContinuousRangeToNumericMap)map).getLabelCount());
                }
                if (map instanceof ContinuousTimeToNumericMap) {
                    ContinuousTimeToNumericMap timeMap = (ContinuousTimeToNumericMap)map;
                    if (this.params.getMinorNum() > 0) {
                        this.vtkAxis.minorTickOffset.connectFrom(timeMap.uniqueMinorValue);
                    }
                    if (timeMap.isSplitDateTime()) {
                        this.vtkAxis.secondaryLabels.connectFrom(timeMap.secondaryLabel);
                        this.vtkAxis.getStyle().setSecondaryLabelsOn(this.vtkAxis.getStyle().isLabelsOn());
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    }
                }
            }
            ao = 0;
            lo = 0;
            switch (dimension) {
                case 1: {
                    ao = 1;
                    lo = 2;
                    break;
                }
                case 2: {
                    ao = 2;
                    lo = 1;
                    break;
                }
                case 3: {
                    ao = 3;
                    lo = 2;
                }
            }
        } else {
            return;
        }
        this.vtkAxis.setOrientation(ao);
        this.vtkAxis.setLabelOrientation(lo);
        this.vtkAxis.setStyle(this.axisStyle);
        if (this.getType() == 0) {
            if (this.isMinorTicksOn() && this.params.getMinorNum() > 0 && this.isMajorTicksOn()) {
                this.axisStyle.setMinorTickMarksOn(true);
                this.axisStyle.getMinorTickStyle().setMinorTickCount(this.params.getMinorNum());
            } else {
                this.axisStyle.setMinorTickMarksOn(false);
                this.axisStyle.getMinorTickStyle().setMinorTickCount(0);
            }
        }
        if (this.isTickBoxOn()) {
            if (this.isMajorTicksOn()) {
                this.axisStyle.setMajorTickMarksOn(false);
                this.setTicksShownAtMidpoint(false);
            } else {
                this.axisStyle.setTickBoxOn(false);
                this.axisStyle.setTickBoxBackground(null);
            }
        }
        this.axisStyle.getMajorTickStyle().setLength(0.4);
        this.axisStyle.getMinorTickStyle().setLength(0.2);
        this.axisStyle.setHorizontalLabelSpace(0.25);
        this.axisStyle.setVerticalLabelSpace(0.25);
        double scale = 1.0;
        if (StatGraph.gapScaleFactor < 1.0) {
            scale = StatGraph.gapScaleFactor;
        }
        scale *= this.gapShrinkScale;
        switch (dimension) {
            case 1: {
                if (!this.reducedTitleSpace && (this.isMajorTickMarksOn() || this.axisStyle.isLabelsOn() || this.axisStyle.isMinorTickMarksOn())) {
                    this.axisStyle.setTitleSpace(0.5 * scale);
                } else {
                    this.axisStyle.setTitleSpace(0.1 * scale);
                }
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setVerticalJustification(0);
                        break;
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(3);
                    break;
                }
                if (this.labelPosition == 0) {
                    this.vtkAxis.setAutoAlignTitle(true);
                    this.axisStyle.setTitleEndSpace(this.axisStyle.getTitleSpace());
                    this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() * 0.5);
                    this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setVerticalJustification(3);
                        break;
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                if (this.labelPosition != 2) break;
                this.vtkAxis.setAutoAlignTitle(true);
                this.axisStyle.setTitleEndSpace(this.axisStyle.getTitleSpace());
                this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() * 0.5);
                this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setVerticalJustification(3);
                    break;
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(0);
                break;
            }
            case 2: {
                if (!this.reducedTitleSpace && (this.isMajorTickMarksOn() || this.axisStyle.isLabelsOn() || this.axisStyle.isMinorTickMarksOn())) {
                    this.axisStyle.setTitleSpace(1.0 * scale);
                } else {
                    this.axisStyle.setTitleSpace(0.2 * scale);
                }
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    } else {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(1);
                    if (!this.hotelText) break;
                    this.vtkAxis.setHotelText(true);
                    this.axisStyle.getTitleStyle().setAngle(0.0);
                    this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                    this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() + 0.5 * scale);
                    break;
                }
                if (this.labelPosition == 0) {
                    this.vtkAxis.setAutoAlignTitle(true);
                    this.vtkAxis.getStyle().setTitleEndSpace(this.axisStyle.getTitleSpace() * 0.5);
                    this.axisStyle.getTitleStyle().setAngle(0.0);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                    } else {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                if (this.labelPosition != 2) break;
                this.vtkAxis.setAutoAlignTitle(true);
                this.vtkAxis.getStyle().setTitleEndSpace(this.axisStyle.getTitleSpace() * 0.5);
                this.axisStyle.getTitleStyle().setAngle(0.0);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                } else {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(3);
                break;
            }
            case 3: {
                this.axisStyle.setTitleSpace(1.0 * scale);
                this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(3);
                break;
            }
        }
        if (this.axisStyle.isMajorTickMarksOn() && this.params.getMinorNum() > 0 && this.isMinorTicksOn()) {
            this.axisStyle.setMinorTickMarksOn(true);
        }
        if (this.axisStyle.isMinorTickMarksOn() || this.getType() == 1) {
            this.axisStyle.setShowThinnedTicks(true);
        } else {
            this.axisStyle.setShowThinnedTicks(false);
        }
        this.vtkAxis.labelColor.setValue(this.axisStyle.getLabelStyle().getColor());
        this.vtkAxis.setPrimary(this.primary);
        this.vtkAxis.setLineOffset(-this.startOffset);
        this.vtkAxis.setLength(this.startOffset + length + this.endOffset);
        this.vtkAxis.setDataLength(length);
        this.vtkAxis.setAxisLineOffsetCoverage(this.axisLineOffsetCoverage);
        this.vtkAxis.setCompressLowExtender(this.compressExtender && this.minOffsetBy != OFFSET_BY_TICKVALUES);
        this.vtkAxis.setCompressHighExtender(this.compressExtender && this.maxOffsetBy != OFFSET_BY_TICKVALUES);
        char[] titleSplitCharInUse = this.titleSplitChar;
        if (suffix != null && suffix.trim().length() > 0 && (this.titleFitPolicy == 1 || this.titleFitPolicy == 2)) {
            suffix = invisibleChar + suffix;
            titleSplitCharInUse = new char[this.titleSplitChar.length + 1];
            for (int i = 0; i < this.titleSplitChar.length; ++i) {
                titleSplitCharInUse[i] = this.titleSplitChar[i];
            }
            titleSplitCharInUse[this.titleSplitChar.length] = invisibleChar;
        }
        if (!this.useTitle.equals("")) {
            if (this.labelFormat != null) {
                if (this.labelFormat.isCharacterFormat()) {
                    this.vtkAxis.title.setValue(this.getAxisTitle(this.labelFormat.format((Object)this.useTitle), suffix));
                } else {
                    this.vtkAxis.title.setValue(this.getAxisTitle(this.labelFormat.format((Object)new Double(this.useTitle)), suffix));
                }
            } else {
                this.vtkAxis.title.setValue(this.getAxisTitle(this.useTitle, suffix));
            }
        } else if (this.isDisplayStackedLabels() && this.stackedLabels != null && this.stackedLabels.length > 0) {
            String[] adjStackedLabels;
            if (suffix == null || suffix.trim().length() == 0) {
                adjStackedLabels = this.stackedLabels;
            } else {
                adjStackedLabels = new String[this.stackedLabels.length];
                for (int i = 0; i < this.stackedLabels.length; ++i) {
                    adjStackedLabels[i] = this.getAxisTitle(this.stackedLabels[i], suffix);
                }
            }
            this.vtkAxis.title.setValue(adjStackedLabels[0]);
            this.vtkAxis.setTitleList(adjStackedLabels);
        } else if (this.labelFormat != null) {
            if (this.labelFormat.isCharacterFormat()) {
                this.vtkAxis.title.setValue(this.getAxisTitle(this.labelFormat.format((Object)range.getLabel()), suffix));
            } else {
                this.vtkAxis.title.setValue(this.getAxisTitle(this.labelFormat.format((Object)new Double(range.getLabel())), suffix));
            }
        } else {
            this.vtkAxis.title.setValue(this.getAxisTitle(range.getLabel(), suffix));
        }
        if (this.labelPosition == 3 && !this.shortTitle.equals("")) {
            this.vtkAxis.shortTitle.setValue(this.getAxisTitle(this.shortTitle, suffix));
        }
        if (suffix != null && suffix.length() > 0) {
            this.vtkAxis.setTitleTruncateEndCount(suffix.length());
        }
        this.vtkAxis.setTitlePosition(this.labelPosition);
        this.vtkAxis.setTitleFitPolicy(this.titleFitPolicy);
        this.vtkAxis.setTitleSplitChar(titleSplitCharInUse);
        this.vtkAxis.setTitleSplitCharDrop(this.titleSplitCharDrop);
        this.vtkAxis.setMultilineTitleJustification(this.multilineTitleJustification);
        this.vtkAxis.setTruncateStartCount(12);
        this.vtkAxis.setTruncateEndCount(0);
        this.vtkAxis.setTruncateAngleStartCount(20);
        this.vtkAxis.setTruncateAngleEndCount(0);
        if (dimension != 1) {
            this.honorFitStrategy = false;
            this.thinKeepEnd = false;
            if (this.tickLabeling != null && this.tickLabeling.equals("")) {
                this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
                this.yFit = new String[]{this.tickLabeling};
            } else {
                if (dimension == 2) {
                    this.yFit = new String[]{"thin"};
                }
                switch (this.getType()) {
                    case 0: {
                        if (this.tickLabeling != null && (this.tickLabeling.equals("thin_beginning_to_end") || this.tickLabeling.equals("thin_inside_to_outside") || this.tickLabeling.equals("thin_end_to_beginning"))) {
                            this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
                            if (dimension != 2) break;
                            this.yFit = new String[]{this.tickLabeling};
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                        break;
                    }
                    case 5: {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                        break;
                    }
                    case 6: {
                        if (this.tickLabeling != null && this.tickLabeling.contains("extendedsplit")) {
                            if (this.splitAlways) {
                                this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
                            } else {
                                this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
                            }
                            if (dimension == 2) {
                                this.yFit = new String[]{this.tickLabeling};
                            }
                            this.honorFitStrategy = true;
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                        break;
                    }
                    case 1: {
                        if (this.logTickIntervalStyle == 2) {
                            this.vtkAxis.setFitAlgorithm(new String[]{"thin_end_to_beginning"});
                            if (dimension != 2) break;
                            this.yFit = new String[]{"thin_end_to_beginning"};
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    }
                }
            }
        } else if (this.tickLabeling != null) {
            if (this.compoundFitPolicy != null) {
                this.vtkAxis.setFitAlgorithm(this.compoundFitPolicy);
            } else {
                this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
            }
            if (this.rotateAlways) {
                this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
            }
            if (this.splitAlways) {
                this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
            }
        } else {
            switch (this.getType()) {
                default: {
                    this.honorFitStrategy = false;
                    this.thinKeepEnd = true;
                    this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    break;
                }
                case 6: {
                    this.honorFitStrategy = true;
                    this.thinKeepEnd = false;
                    if (this.tickValueRotation == 0) {
                        if (this.primary) {
                            this.vtkAxis.setFitAlgorithm(new String[]{"angle315"});
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"angle45"});
                        break;
                    }
                    if (this.tickValueRotation == 2) {
                        if (this.primary) {
                            this.vtkAxis.setFitAlgorithm(new String[]{"angle45"});
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"angle315"});
                        break;
                    }
                    if (this.tickValueRotation != 1) break;
                    this.vtkAxis.setFitAlgorithm(new String[]{"angle90"});
                }
            }
        }
        if (dimension == 2 && this.getType() == 1 && this.logTickIntervalStyle == 2) {
            FontMetrics fm = StatGraph.getFontMetrics(this.vtkAxis.getStyle().getLabelStyle().getFont());
            this.vtkAxis.setLabelMargin(fm.getHeight());
        } else {
            this.vtkAxis.setLabelMargin((int)Math.ceil(5.0 * StatGraph.getGapScaleFactor()));
        }
        if (this.tickLabeling != null && this.tickLabeling.contains("extendedsplit")) {
            this.vtkAxis.setLabelSplitChar(this.splitChar);
            this.vtkAxis.setLabelSplitCharDrop(this.splitCharDrop);
            this.vtkAxis.setMultilineLabelJustification(this.multilineJustification);
            this.vtkAxis.setMaximumAllocatedSize(this.allocatedSize);
        }
        this.vtkAxis.setLabelAlignment(this.tickValueAlignment);
        this.vtkAxis.setPostFitProcessor((AAxis.PostFitProcessor)this);
        this.titleSuffix = suffix;
    }

    public void trimDiscreteTickvalues(int count) {
        StringVector sv = new StringVector();
        NumericVector nv = new NumericVector();
        this.vtkAxis.init(new AInitAction(null));
        double dataLength = ((PositionEncoder)this.encoder).getOutputMax() - ((PositionEncoder)this.encoder).getOutputMin();
        for (int i = 0; i < count; ++i) {
            try {
                double d = this.vtkAxis.labelOffset.getValue(i);
                String s = this.vtkAxis.labels.getValue(i);
                if (!(d >= -this.startOffset) || !(d <= dataLength + this.endOffset)) continue;
                nv.addValue(d);
                sv.addValue(s);
                continue;
            }
            catch (MissingValueException d) {
                // empty catch block
            }
        }
        this.vtkAxis.labelOffset.connectFrom((NumericPipe)nv);
        this.vtkAxis.labels.connectFrom((StringPipe)sv);
        if (this.glv != null) {
            for (int j = 0; j < this.glv.size(); ++j) {
                VRectGridLines rgl = (VRectGridLines)this.glv.elementAt(j);
                rgl.setVisibleTickRange(new double[]{-this.startOffset, this.vtkAxis.getDataLength() + this.endOffset});
            }
        }
    }

    public double[] trimTimeTickvalues(ContinuousRange cr, double[] tickvalues) {
        double min = cr.getMin();
        double max = cr.getMax();
        ArrayList<Double> al = new ArrayList<Double>();
        for (int i = 0; i < tickvalues.length; ++i) {
            if (!(tickvalues[i] >= min) || !(tickvalues[i] <= max)) continue;
            al.add(tickvalues[i]);
        }
        double[] trimmedValues = new double[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            trimmedValues[i] = (Double)al.get(i);
        }
        return trimmedValues;
    }

    private void connectMinorTickOffset(NumericPipe majorOffset, int majorTickCount) {
        if (!this.minorTicksOn || this.params.getMinorNum() <= 0 || majorTickCount < 2) {
            return;
        }
        NumericMap map = (NumericMap)this.encoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return;
        }
        double min = ((ContinuousRangeToNumericMap)map).getOutputMin();
        double max = ((ContinuousRangeToNumericMap)map).getOutputMax();
        int minorTickCount = this.axisStyle.getMinorTickStyle().getMinorTickCount();
        NumericVector offset = new NumericVector();
        majorOffset.init(new AInitAction());
        try {
            double major1 = majorOffset.getValue(0);
            double major2 = majorOffset.getValue(1);
            if (major1 > major2) {
                NumericVector temp = new NumericVector(majorTickCount);
                for (int i = majorTickCount - 1; i >= 0; --i) {
                    temp.addValue(majorOffset.getValue(i));
                }
                majorOffset = temp;
                major1 = majorOffset.getValue(0);
                major2 = majorOffset.getValue(1);
            }
            double majorInterval = major2 - major1;
            double minorTickSpace = majorInterval / (double)(minorTickCount + 1);
            double limit = major1 - majorInterval;
            if (limit < min) {
                limit = min;
            }
            if (limit < major1) {
                int n = 0;
                for (double first = major1 - minorTickSpace; limit < first; first -= minorTickSpace) {
                    ++n;
                }
                for (int i = n; i > 0; --i) {
                    offset.addValue(major1 - (double)i * minorTickSpace);
                }
            }
            for (int i = 0; i < majorTickCount - 1; ++i) {
                double major = majorOffset.getValue(i);
                for (int ii = 1; ii <= minorTickCount; ++ii) {
                    offset.addValue(major + (double)ii * minorTickSpace);
                }
            }
            double lastMajor = majorOffset.getValue(majorTickCount - 1);
            limit = lastMajor + majorInterval;
            if (limit > max) {
                limit = max;
            }
            if (lastMajor < limit) {
                for (double last = lastMajor + minorTickSpace; last < limit; last += minorTickSpace) {
                    offset.addValue(last);
                }
            }
            this.vtkAxis.minorTickOffset.connectFrom((NumericPipe)offset);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private void issueSASNote(String aNote) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (!((String)this.notes.get(i)).equals(aNote)) continue;
            return;
        }
        this.notes.add(aNote);
        StatGraph.printNote(aNote);
    }

    private String getAxisTitle(String title, String suffix) {
        String newTitle = title == null ? (suffix == null || suffix.trim().length() == 0 ? title : suffix) : (suffix == null || suffix.trim().length() == 0 ? title : title + suffix);
        return newTitle;
    }

    private StringPipe getAxisLabels(NumericMap map, boolean eFormat) {
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return map.label;
        }
        if (Double.isNaN(this.origin)) {
            if (eFormat) {
                ((ContinuousRangeToNumericMap)map).init((AInitAction)new InitAction(null));
                this.vtkAxis.labels.connectFrom(this.getTrimmedLabel(((ContinuousRangeToNumericMap)map).label, ((ContinuousRangeToNumericMap)map).getLabelCount()));
            } else {
                return map.label;
            }
        }
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)map;
        crnm.init(new AInitAction(null));
        StringVector labels = new StringVector();
        double mappedOrigin = crnm.getValue(this.origin);
        try {
            for (int i = 0; i < crnm.getLabelCount(); ++i) {
                double v = crnm.uniqueValue.getValue(i);
                if (v == mappedOrigin) {
                    if (this.isLabelOrigin()) {
                        if (eFormat) {
                            labels.addValue(NumericFormat.getTrimmedValue((String)crnm.label.getValue(i)));
                            continue;
                        }
                        labels.addValue(crnm.label.getValue(i));
                        continue;
                    }
                    labels.addValue("");
                    continue;
                }
                if (eFormat) {
                    labels.addValue(NumericFormat.getTrimmedValue((String)crnm.label.getValue(i)));
                    continue;
                }
                labels.addValue(crnm.label.getValue(i));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return labels;
    }

    private boolean isInfiniteRange(double min, double max) {
        return max - min >= 1.0E308;
    }

    private boolean isReformatPossible(double[][] tickValues) {
        double[] ticks_sav = this.ticks;
        boolean reformat = true;
        for (int i = 0; i < tickValues.length; ++i) {
            this.ticks = tickValues[i];
            if (this.isReformatPossible()) continue;
            reformat = false;
            break;
        }
        this.ticks = ticks_sav;
        return reformat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReformatPossible() {
        int userDec;
        boolean scaling;
        double inc;
        double max;
        double min;
        if (this.ticks != null) {
            if (!this.isUniformTicks()) return false;
            min = this.ticks[0];
            max = this.ticks[this.ticks.length - 1];
            inc = this.ticks[1] - this.ticks[0];
        } else if (this.axisLabelMap != null) {
            min = this.axisLabelMap.getInputMin();
            max = this.axisLabelMap.getInputMax();
            inc = this.majorInterval.getSize();
        } else {
            min = ((ContinuousRange)this.encoder.getInput()).getMin();
            max = ((ContinuousRange)this.encoder.getInput()).getMax();
            inc = this.majorInterval.getSize();
        }
        if (this.isInfiniteRange(min, max)) {
            return false;
        }
        boolean bl = scaling = this.extractScale && this.vtkAxis != null && this.vtkAxis.getStyle().isTitleOn();
        if (!(inc < 1.0) || scaling) return true;
        int sign = min < 0.0 ? 1 : 0;
        int dec = -((int)Math.floor(Math.log(inc) / Math.log(10.0)));
        inc *= Math.pow(10.0, dec);
        double err = 1.0E-8;
        for (int count = 0; Math.abs(inc - (double)((int)(inc + err))) > err && count < 8; ++count) {
            ++dec;
            inc *= 10.0;
        }
        double absMax = Math.abs(max);
        int intWidth = absMax <= 1.0 ? 1 : (int)(Math.log(absMax) / Math.log(10.0)) + 1;
        int maxWidth = sign + intWidth + dec + 1;
        int userWidth = this.tickLabelMaxWidth < 0 ? 8 : this.tickLabelMaxWidth;
        int n = userDec = this.tickLabelMaxDecimals < 0 ? 6 : this.tickLabelMaxDecimals;
        return maxWidth <= userWidth && dec <= userDec;
    }

    private StringPipe getTrimmedLabel(StringPipe label, int count) {
        StringVector newLabel = new StringVector();
        try {
            for (int i = 0; i < count; ++i) {
                newLabel.addValue(NumericFormat.getTrimmedValue((String)label.getValue(i)));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return newLabel;
    }

    private Object[] getGGoodLabels(double min, double max, double inc, int labelCount) {
        String baseName;
        boolean scaling = this.extractScale && this.vtkAxis.getStyle().isTitleOn() && !this.isBrokenAxis();
        boolean groupBy3 = !this.scientificScale;
        Object[] info = NumericFormat.getGGoodFormat((double)min, (double)max, (double)inc, (int)this.tickLabelMaxWidth, (int)this.tickLabelMaxDecimals, (int)this.tickLabelPreferredDecimals, (boolean)scaling, (boolean)groupBy3);
        SASFormat fmt = (SASFormat)info[0];
        int power = 0;
        if (info[1] != null) {
            power = ((Number)info[1]).intValue();
        }
        double scale = Math.pow(10.0, -power);
        SASFormat originalFormat = this.encoder.getInput().getFormat();
        String string = baseName = originalFormat == null || !this.isNamedFormat(originalFormat) ? null : originalFormat.getBaseFormatName();
        if (baseName != null) {
            int d;
            int w = originalFormat.getFormatDescription().getMaxWidth();
            if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                d = fmt.getDecimalWidth();
                if (originalFormat.isPercent()) {
                    if (scaling && !groupBy3) {
                        power += 2;
                        scale /= 100.0;
                    } else {
                        d -= 2;
                        d = Math.max(0, d);
                    }
                }
            } else {
                d = originalFormat.getDecimalWidth();
                power = 0;
                scale = 1.0;
            }
            fmt = SASFormat.getInstance((String)(baseName + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
            fmt.setInsertBlanks(false);
        }
        Locale currentLocale = Locale.getDefault();
        StatGraph.setSessionLocale();
        String suffix = " ";
        switch (power) {
            case 0: {
                suffix = "";
                break;
            }
            case 1: {
                suffix = suffix + RB.getStringResource(RB_KEY, "ten.txt");
                break;
            }
            case 2: {
                suffix = suffix + RB.getStringResource(RB_KEY, "hundred.txt");
                break;
            }
            case 3: {
                suffix = suffix + RB.getStringResource(RB_KEY, "thousand.txt");
                break;
            }
            case 6: {
                suffix = suffix + RB.getStringResource(RB_KEY, "million.txt");
                break;
            }
            case 9: {
                suffix = suffix + RB.getStringResource(RB_KEY, "billion.txt");
                break;
            }
            case 12: {
                suffix = suffix + RB.getStringResource(RB_KEY, "trillion.txt");
                break;
            }
            case -6: {
                suffix = suffix + RB.getStringResource(RB_KEY, "millionth.txt");
                break;
            }
            case -9: {
                suffix = suffix + RB.getStringResource(RB_KEY, "billionth.txt");
                break;
            }
            case -12: {
                suffix = suffix + RB.getStringResource(RB_KEY, "trillionth.txt");
                break;
            }
            default: {
                Message message = new Message(RB.getStringResource(RB_KEY, "exponent.fmt.txt"));
                suffix = suffix + message.toString((Object)Integer.toString(power));
            }
        }
        Locale.setDefault(currentLocale);
        double[] v = new double[labelCount];
        v[0] = min * scale;
        for (int i = 1; i < labelCount; ++i) {
            v[i] = v[i - 1] + inc * scale;
        }
        v = NumericFormat.processValues((double[])v, (double)(inc * scale));
        boolean eFormat = fmt.getName().startsWith("E") || fmt.getName().startsWith("e");
        StringVector labels = new StringVector();
        for (int i = 0; i < labelCount; ++i) {
            if (!Double.isNaN(this.origin) && v[i] == this.origin) {
                if (this.isLabelOrigin()) {
                    if (eFormat) {
                        labels.addValue(NumericFormat.getTrimmedValue((String)fmt.format((Object)new Double(v[i])).trim()));
                        continue;
                    }
                    labels.addValue(fmt.format((Object)new Double(v[i])).trim());
                    continue;
                }
                labels.addValue("");
                continue;
            }
            if (eFormat) {
                labels.addValue(NumericFormat.getTrimmedValue((String)fmt.format((Object)new Double(v[i])).trim()));
                continue;
            }
            labels.addValue(fmt.format((Object)new Double(v[i])).trim());
        }
        Object[] obj = new Object[]{labels, suffix};
        return obj;
    }

    public void setRectAxisParams(RectAxisParams params) {
        this.params = params;
    }

    @Override
    public void setAxisStyle(AxisStyle style) {
        if (style == null) {
            return;
        }
        AxisStyle oldAS = new AxisStyle(this.axisStyle);
        this.axisStyle = style;
        if (!this.axisStyle.equals(oldAS) && this.vtkAxis != null) {
            this.vtkAxis.setStyle(this.axisStyle);
            this.vtkAxis.labelColor.setValue(this.axisStyle.getLabelStyle().getColor());
        }
        this.axisStyle.setSecondaryLabelStyle(this.axisStyle.getLabelStyle());
    }

    public Channel getChannel() {
        return this.networkRoot.getChannel();
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
        channel.gluLookAt(0.5, 0.5, 0.0, 0.5, 0.0, 0.0, 0.0);
        channel.glViewport(0, 0, 1, 1);
        channel.glOrtho(0.0, 1.0, 0.0, 1.0, -10.0, 10.0);
    }

    public void setChannel2(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
        Channel channel2 = new Channel((Component)new Panel(), 2);
        channel2.gluLookAt(0.5, 0.5, 0.0, 0.5, 0.0, 0.0, 0.0);
        channel2.glViewport(0, 0, 1, 1);
        channel2.glOrtho(0.0, 1.0, 0.0, 1.0, -10.0, 10.0);
        this.root2 = new NetworkRoot(channel2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.vtkAxis == null) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        AxisStyle style = this.vtkAxis.getStyle();
        boolean titleOn = style.isTitleOn();
        boolean labelOn = style.isLabelsOn();
        boolean majorTicksOn = style.isMajorTickMarksOn();
        boolean minorTicksOn = style.isMinorTickMarksOn();
        if (!this.titleFit) {
            style.setTitleOn(false);
            style.setLabelsOn(false);
            style.setMajorTickMarksOn(false);
            style.setMinorTickMarksOn(false);
        }
        if (this.getDimension() == 1 && this.fitStrategy != null) {
            if (this.fitStrategy.trim().length() > 0) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            } else if (this.honorFitStrategy) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            }
        }
        if (this.getDimension() == 2 && this.honorFitStrategy && this.fitStrategy != null) {
            this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
        }
        if (this.dimension == 1 && this.tickLabeling != null && this.tickLabeling.contains("extendedsplit")) {
            this.vtkAxis.setFixedLabelSplitWidth(this.labelSplitWidth);
        }
        if (this.truncatedTitle || this.recomputeTitleSize) {
            boolean needTitleSize;
            boolean bl = needTitleSize = this.dimension == 1 && this.multilineTitleJustification == 2 || this.dimension == 2 && this.multilineTitleJustification == 0;
            if (this.titleFitPolicy == 0 || needTitleSize) {
                AxisMetrics tam = this.vtkAxis.getMetrics(this.networkRoot.getChannel());
                this.vtkAxis.setMaximumTitleSize(this.getMaximumTitleSize(tam));
            }
            if (this.titleFitPolicy == 1 || this.titleFitPolicy == 2) {
                this.vtkAxis.setTitleSplitWidth(this.titleSplitWidth);
            }
            this.recomputeTitleSize = false;
            if (!this.shortTitle.equals("")) {
                this.vtkAxis.shortTitle.setValue(this.getAxisTitle(this.shortTitle, this.titleSuffix));
            }
        }
        VRectAxis vRectAxis = this;
        synchronized (vRectAxis) {
            this.networkRoot.draw(this.networkRoot.getChannel());
        }
        if (!this.titleFit) {
            style.setTitleOn(titleOn);
            style.setLabelsOn(labelOn);
            style.setMajorTickMarksOn(majorTicksOn);
            style.setMinorTickMarksOn(minorTicksOn);
        }
        if (!this.labelsFit && this.axisStyle.isLabelsOn()) {
            this.issueSASNote(RB.getStringResource(RB_KEY, "labelthinned.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLabels(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.titleFit) {
            return;
        }
        if (this.vtkAxis == null) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        if (this.getDimension() == 1 && this.fitStrategy != null) {
            if (this.fitStrategy.trim().length() > 0) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            } else if (this.honorFitStrategy) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            }
        }
        if (this.getDimension() == 2 && this.honorFitStrategy && this.fitStrategy != null) {
            this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
        }
        if (this.dimension == 1 && this.tickLabeling != null && this.tickLabeling.contains("extendedsplit")) {
            this.vtkAxis.setFixedLabelSplitWidth(this.labelSplitWidth);
        }
        boolean titleOn = this.vtkAxis.getStyle().isTitleOn();
        this.vtkAxis.getStyle().setTitleOn(false);
        VRectAxis vRectAxis = this;
        synchronized (vRectAxis) {
            this.networkRoot.draw(this.networkRoot.getChannel());
        }
        this.vtkAxis.getStyle().setTitleOn(titleOn);
        if (!this.labelsFit && this.axisStyle.isLabelsOn()) {
            this.issueSASNote(RB.getStringResource(RB_KEY, "labelthinned.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTitle(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.vtkAxis == null) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        if (!this.vtkAxis.getStyle().isTitleOn()) {
            return;
        }
        if (this.truncatedTitle || this.recomputeTitleSize) {
            boolean needTitleSize;
            boolean bl = needTitleSize = this.dimension == 1 && this.multilineTitleJustification == 2 || this.dimension == 2 && this.multilineTitleJustification == 0;
            if (this.titleFitPolicy == 0 || needTitleSize) {
                AxisMetrics tam = this.vtkAxis.getMetrics(this.networkRoot.getChannel());
                this.vtkAxis.setMaximumTitleSize(this.getMaximumTitleSize(tam));
            }
            if (this.titleFitPolicy == 1 || this.titleFitPolicy == 2) {
                this.vtkAxis.setTitleSplitWidth(this.titleSplitWidth);
            }
            this.recomputeTitleSize = false;
            if (!this.shortTitle.equals("")) {
                this.vtkAxis.shortTitle.setValue(this.getAxisTitle(this.shortTitle, this.titleSuffix));
            }
        }
        boolean labelsOn = this.vtkAxis.getStyle().isLabelsOn();
        boolean lineOn = this.vtkAxis.getStyle().isAxisLineOn();
        boolean majorTicksOn = this.vtkAxis.getStyle().isMajorTickMarksOn();
        boolean minorTicksOn = this.vtkAxis.getStyle().isMinorTickMarksOn();
        this.vtkAxis.getStyle().setLabelsOn(false);
        this.vtkAxis.getStyle().setAxisLineOn(false);
        this.vtkAxis.getStyle().setMajorTickMarksOn(false);
        this.vtkAxis.getStyle().setMinorTickMarksOn(false);
        VRectAxis vRectAxis = this;
        synchronized (vRectAxis) {
            this.networkRoot.draw(this.networkRoot.getChannel());
        }
        this.vtkAxis.getStyle().setLabelsOn(labelsOn);
        this.vtkAxis.getStyle().setAxisLineOn(lineOn);
        this.vtkAxis.getStyle().setMajorTickMarksOn(majorTicksOn);
        this.vtkAxis.getStyle().setMinorTickMarksOn(minorTicksOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBackground(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.vtkAxis == null) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        if (this.getBackground() == null) {
            return;
        }
        boolean labelsOn = this.vtkAxis.getStyle().isLabelsOn();
        boolean lineOn = this.vtkAxis.getStyle().isAxisLineOn();
        boolean majorTicksOn = this.vtkAxis.getStyle().isMajorTickMarksOn();
        boolean minorTicksOn = this.vtkAxis.getStyle().isMinorTickMarksOn();
        boolean titleOn = this.vtkAxis.getStyle().isTitleOn();
        if (!(labelsOn || majorTicksOn || minorTicksOn || titleOn)) {
            return;
        }
        this.vtkAxis.getStyle().setLabelsOn(false);
        this.vtkAxis.getStyle().setAxisLineOn(false);
        this.vtkAxis.getStyle().setMajorTickMarksOn(false);
        this.vtkAxis.getStyle().setMinorTickMarksOn(false);
        this.vtkAxis.getStyle().setTitleOn(false);
        this.vtkAxis.getStyle().setBackground(this.background);
        VRectAxis vRectAxis = this;
        synchronized (vRectAxis) {
            this.networkRoot.draw(this.networkRoot.getChannel());
        }
        this.vtkAxis.getStyle().setLabelsOn(labelsOn);
        this.vtkAxis.getStyle().setAxisLineOn(lineOn);
        this.vtkAxis.getStyle().setMajorTickMarksOn(majorTicksOn);
        this.vtkAxis.getStyle().setMinorTickMarksOn(minorTicksOn);
        this.vtkAxis.getStyle().setTitleOn(titleOn);
        this.vtkAxis.getStyle().setBackground(null);
    }

    public Insets getLabelExtent() {
        return this.labelExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Insets getExtent() {
        AxisMetrics am;
        this.labelExtent.bottom = 0;
        this.labelExtent.top = 0;
        this.labelExtent.right = 0;
        this.labelExtent.left = 0;
        if (this.vtkAxis == null || !this.visible || this.networkRoot == null) {
            return (Insets)zeroInsets.clone();
        }
        AxisStyle sty = this.vtkAxis.getStyle();
        if (!(sty.isAxisLineOn() || this.isMajorTickMarksOn() || sty.isMinorTickMarksOn() || sty.isLabelsOn() || sty.isTitleOn())) {
            if (this.composite == null) {
                return (Insets)zeroInsets.clone();
            }
            return this.composite.getExtent((Insets)zeroInsets.clone());
        }
        if (this.minOffsetBy == OFFSET_BY_TICKVALUES) {
            this.setStartOffset(0.0);
        }
        if (this.maxOffsetBy == OFFSET_BY_TICKVALUES) {
            this.setEndOffset(0.0);
        }
        Vec3d maxSize = this.vtkAxis.getMaximumSize();
        this.vtkAxis.setMaximumSize(null);
        this.axisStyle.setTitlePositionedAtMax(false);
        this.vtkAxis.setFixedLabelSplitWidth(Double.NaN);
        this.vtkAxis.setTitleSplitWidth(Double.NaN);
        PositionEncoder pe = (PositionEncoder)this.encoder;
        double top = 0.0;
        double left = 0.0;
        double bottom = 0.0;
        double right = 0.0;
        NetworkRoot networkRoot = this.networkRoot;
        synchronized (networkRoot) {
            if (this.root2 == null) {
                boolean reset;
                Channel channel = this.networkRoot.getChannel();
                String title = this.vtkAxis.title.getValue();
                if (this.axisStyle.isTitleOn() && title != null && title.trim().equals("")) {
                    this.vtkAxis.title.setValue("HACK");
                }
                boolean bl = reset = !this.rotateAlways && !this.splitAlways;
                if (this.thinKeepEnd) {
                    if (this.fitStrategy != null && this.fitStrategy.equals("thin")) {
                        this.vtkAxis.setForceFitAlgorithm("thinkeepend");
                        reset = false;
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thinkeepend"});
                    }
                } else if (this.getDimension() == 2) {
                    if (this.yFit[0].contains("extendedsplit")) {
                        this.vtkAxis.setFitAlgorithm(new String[]{"extendedsplit"});
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{""});
                    }
                }
                if (!this.forcedAutoOffset && reset) {
                    this.vtkAxis.setForceFitAlgorithm(null);
                }
                if (this.rotateAlways && this.tickLabeling.endsWith("nolabels")) {
                    if (this.initialFitting) {
                        this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
                    } else if (this.fitStrategy != null && this.fitStrategy.equals("nolabels")) {
                        this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
                    }
                }
                am = this.vtkAxis.getMetrics(channel);
                if (!this.rotateAlways || this.rotateAlways && this.tickLabeling.endsWith("nolabels")) {
                    this.fitStrategy = am.getFittingAlgorithm();
                }
                if (this.thinKeepEnd) {
                    if (this.fitStrategy != null && this.fitStrategy.equals("thinkeepend")) {
                        this.fitStrategy = "thin";
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    }
                } else if (this.getDimension() == 2) {
                    this.vtkAxis.setFitAlgorithm(this.yFit);
                    if (this.fitStrategy != null && this.fitStrategy.equals("extendedsplit")) {
                        this.fitStrategy = this.yFit[0];
                    }
                }
                if (this.honorFitStrategy && this.fitStrategy != null && (this.fitStrategy.toUpperCase().startsWith("ANGLE") || this.fitStrategy.toUpperCase().startsWith("EXTENDEDSPLITANGLE")) && (this.minOffsetBy == OFFSET_BY_TICKVALUES || this.maxOffsetBy == OFFSET_BY_TICKVALUES)) {
                    this.minOffsetBy = OFFSET_BY_AUTO;
                    this.maxOffsetBy = OFFSET_BY_AUTO;
                    this.forcedAutoOffset = true;
                }
                this.vtkAxis.title.setValue(title);
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    this.vtkAxis.setMaximumTitleSize(this.getMaximumTitleSize(am));
                    this.vtkAxis.setTitleSplitWidth(Double.NaN);
                    AxisMetrics tam = this.vtkAxis.getMetricsTitleOnly(channel);
                    this.truncatedTitle = this.titleFitPolicy == 0 ? tam.isTitleTruncated() : tam.isTitleSplit();
                    this.titleSplitWidth = this.vtkAxis.getTitleSplitWidth();
                }
                if (this.truncatedTitle && (this.titleFitPolicy == 1 || this.titleFitPolicy == 2)) {
                    am = this.vtkAxis.getMetrics(channel);
                }
                this.labelSplitWidth = this.vtkAxis.getLabelSplitWidth();
            } else {
                boolean reset;
                this.networkRoot.removeAllElements();
                String title = this.vtkAxis.title.getValue();
                if (this.axisStyle.isTitleOn() && title != null && title.trim().equals("")) {
                    this.vtkAxis.title.setValue("HACK");
                }
                this.root2.addElement((Element)this.vtkAxis);
                boolean textAntialiased = this.networkRoot.getChannel().glIsEnabled(14);
                if (textAntialiased) {
                    this.root2.getChannel().glEnable(14);
                } else {
                    this.root2.getChannel().glDisable(14);
                }
                boolean bl = reset = !this.rotateAlways && !this.splitAlways;
                if (this.thinKeepEnd) {
                    if (this.fitStrategy != null && this.fitStrategy.equals("thin")) {
                        this.vtkAxis.setForceFitAlgorithm("thinkeepend");
                        reset = false;
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thinkeepend"});
                    }
                } else if (this.getDimension() == 2) {
                    if (this.yFit[0].contains("extendedsplit")) {
                        this.vtkAxis.setFitAlgorithm(new String[]{"extendedsplit"});
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{""});
                    }
                }
                if (!this.forcedAutoOffset && reset) {
                    this.vtkAxis.setForceFitAlgorithm(null);
                }
                if (this.rotateAlways && this.tickLabeling.endsWith("nolabels")) {
                    if (this.initialFitting) {
                        this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
                    } else if (this.fitStrategy != null && this.fitStrategy.equals("nolabels")) {
                        this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
                    }
                }
                am = this.vtkAxis.getMetrics(this.root2.getChannel());
                if (!this.rotateAlways || this.rotateAlways && this.tickLabeling.endsWith("nolabels")) {
                    this.fitStrategy = am.getFittingAlgorithm();
                }
                if (this.thinKeepEnd) {
                    if (this.fitStrategy != null && this.fitStrategy.equals("thinkeepend")) {
                        this.fitStrategy = "thin";
                    } else {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    }
                } else if (this.getDimension() == 2) {
                    this.vtkAxis.setFitAlgorithm(this.yFit);
                    if (this.fitStrategy != null && this.fitStrategy.equals("extendedsplit")) {
                        this.fitStrategy = this.yFit[0];
                    }
                }
                if (this.honorFitStrategy && this.fitStrategy != null && (this.fitStrategy.toUpperCase().startsWith("ANGLE") || this.fitStrategy.toUpperCase().startsWith("EXTENDEDSPLITANGLE")) && (this.minOffsetBy == OFFSET_BY_TICKVALUES || this.maxOffsetBy == OFFSET_BY_TICKVALUES)) {
                    this.minOffsetBy = OFFSET_BY_AUTO;
                    this.maxOffsetBy = OFFSET_BY_AUTO;
                    this.forcedAutoOffset = true;
                }
                this.root2.removeAllElements();
                this.vtkAxis.title.setValue(title);
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    this.vtkAxis.setMaximumTitleSize(this.getMaximumTitleSize(am));
                    this.vtkAxis.setTitleSplitWidth(Double.NaN);
                    AxisMetrics tam = this.vtkAxis.getMetricsTitleOnly(this.root2.getChannel());
                    this.truncatedTitle = this.titleFitPolicy == 0 ? tam.isTitleTruncated() : tam.isTitleSplit();
                    this.titleSplitWidth = this.vtkAxis.getTitleSplitWidth();
                }
                if (this.truncatedTitle && (this.titleFitPolicy == 1 || this.titleFitPolicy == 2)) {
                    am = this.vtkAxis.getMetrics(this.root2.getChannel());
                }
                this.networkRoot.addElement((Element)this.vtkAxis);
                if (this.dimension == 1) {
                    double newLabelSplitWidth = this.vtkAxis.getLabelSplitWidth();
                    double diff = newLabelSplitWidth - this.labelSplitWidth;
                    int delta = 1;
                    if (Double.isNaN(this.labelSplitWidth) || diff > 0.0 || diff < (double)(-delta)) {
                        this.labelSplitWidth = newLabelSplitWidth;
                    }
                }
            }
        }
        this.vtkAxis.setMaximumSize(maxSize);
        this.axisStyle.setTitlePositionedAtMax(this.titlePositionedAtMax);
        this.recomputeTitleSize = false;
        if (this.dimension == 1) {
            top = am.getInsideLength();
            bottom = am.getOutsideLength() + 1.0;
            if (!this.primary) {
                top = am.getOutsideLength() + 1.0;
                bottom = am.getInsideLength();
            }
            left = am.getLowExtender();
            right = am.getHighExtender();
            if (this.labelPosition == 0) {
                this.labelExtent.left = this.isCompressExtender() ? (int)this.getTitleWidth(this.networkRoot.getChannel()) : (int)this.getTitleWidth(this.networkRoot.getChannel()) + OFFSET_MARGIN;
            } else if (this.labelPosition == 2) {
                this.labelExtent.right = this.isCompressExtender() ? (int)this.getTitleWidth(this.networkRoot.getChannel()) : (int)this.getTitleWidth(this.networkRoot.getChannel()) + OFFSET_MARGIN;
            }
            if (this.fitStrategy != null && this.fitStrategy.startsWith("angle90thin")) {
                if (this.primary) {
                    bottom += 2.0;
                } else {
                    top += 2.0;
                }
            }
        } else if (this.dimension == 2) {
            left = am.getOutsideLength() + 1.0;
            right = am.getInsideLength();
            if (!this.primary) {
                left = am.getInsideLength();
                right = am.getOutsideLength() + 1.0;
            }
            bottom = am.getLowExtender();
            top = am.getHighExtender();
            if (this.labelPosition == 0) {
                this.labelExtent.bottom = this.isCompressExtender() ? (int)this.getTitleHeight(this.networkRoot.getChannel()) : (int)this.getTitleHeight(this.networkRoot.getChannel()) + OFFSET_MARGIN;
            } else if (this.labelPosition == 2) {
                this.labelExtent.top = this.isCompressExtender() ? (int)this.getTitleHeight(this.networkRoot.getChannel()) : (int)this.getTitleHeight(this.networkRoot.getChannel()) + OFFSET_MARGIN;
            }
        }
        if (this.titleSuffix != null && this.titleSuffix.length() > 0) {
            this.titleFit = this.vtkAxis.isDisplayTitleFit();
            if (!this.titleFit) {
                if (this.composite != null) {
                    return this.composite.getExtent(new Insets(0, 0, 0, 0));
                }
                return new Insets(0, 0, 0, 0);
            }
        } else {
            this.titleFit = true;
        }
        if (this.composite != null) {
            return this.composite.getExtent(new Insets((int)top, (int)left, (int)bottom, (int)right));
        }
        return new Insets((int)top, (int)left, (int)bottom, (int)right);
    }

    private Vec3d getMaximumTitleSize(AxisMetrics am) {
        double titleW;
        double titleH;
        double lowExt = this.minOffsetBy == OFFSET_BY_TICKVALUES ? 0.0 : am.getLowExtender();
        double highExt = this.maxOffsetBy == OFFSET_BY_TICKVALUES ? 0.0 : am.getHighExtender();
        double minExtender = Math.min(lowExt, highExt);
        if (this.getDimension() == 1) {
            titleH = am.getHeight();
            titleW = am.getLineLength();
            titleW += minExtender * 2.0;
            titleW += 1.0;
        } else {
            titleW = am.getWidth();
            titleH = am.getLineLength();
            titleH += minExtender * 2.0;
        }
        return new Vec3d(titleW, titleH, 0.0);
    }

    public void recomputeTitleSize(boolean b) {
        this.recomputeTitleSize = b;
    }

    @Override
    public synchronized void updateOutputRange() {
        if (this.isBrokenAxis()) {
            this.outputRanges = this.clearUpInputRanges();
            if (this.outputRanges != null) {
                this.updateOutputRange(this.outputRanges);
                return;
            }
            this.inputRanges = null;
            this.setBrokenAxis(false);
        }
        DataRange oldRange = this.outputRange;
        DataRange newRange = null;
        DataRange valRange = this.inputRange;
        if (this.useRange != null) {
            valRange = this.useRange;
        } else if (this.inputRange == null) {
            this.outputRange = valRange = new DiscreteRange();
            return;
        }
        boolean autoMin = this.params.getAutoMin();
        DataPoint minPt = this.params.getMinimum();
        boolean autoMax = this.params.getAutoMax();
        DataPoint maxPt = this.params.getMaximum();
        boolean autoMajorNum = this.params.getAutoMajorNum();
        int reqMajorNum = this.params.getMajorNum();
        if (!autoMajorNum && reqMajorNum < 1) {
            autoMajorNum = true;
        }
        boolean autoMajorInterval = this.params.getAutoMajorInterval();
        TickInterval reqMajorInterval = this.params.getMajorInterval();
        if (!autoMajorInterval && reqMajorInterval == null) {
            autoMajorInterval = true;
        }
        if (this.userReqMinorNum >= 0) {
            this.params.setMinorNum(this.userReqMinorNum);
        } else if (this.userReqMinorNumForLog >= 0) {
            this.params.setMinorNum(this.userReqMinorNumForLog);
        }
        int reqMinorNum = this.params.getMinorNum();
        if (reqMinorNum > 0 && this.vtkAxis != null) {
            this.vtkAxis.getStyle().getMinorTickStyle().setMinorTickCount(reqMinorNum);
        }
        if (valRange instanceof ContinuousRange) {
            double inMax;
            ContinuousRange cr1 = (ContinuousRange)valRange;
            double inMin = cr1.getMin();
            if (inMin > (inMax = cr1.getMax())) {
                return;
            }
            if (!this.dynamic && !this.tickValuePriority) {
                if (!Double.isNaN(this.viewportMin)) {
                    inMin = this.viewportMin;
                }
                if (!Double.isNaN(this.viewportMax)) {
                    inMax = this.viewportMax;
                }
            }
            if (inMin <= 0.0 && this.getType() == 1) {
                this.setType(0);
                this.setTicks(null);
                this.setTickLabeling("THIN");
                StatGraph.printNote(RB.getStringResource(RB_KEY, "logToLinear.txt"));
            }
            if (!(this.getType() != 5 || cr1.getFormat() != null && cr1.getFormat() instanceof SASDateTimeFormat)) {
                this.setType(0);
                this.setTickLabeling("THIN");
                StatGraph.printNote(RB.getStringResource(RB_KEY, "timeToLinear2.txt"));
            }
            if (this.getType() == 5 && this.ticks == null && !ZxAxis.isValidDateTime((double[])new double[]{inMin, inMax}, (SASFormat)cr1.getFormat())) {
                this.setType(0);
                this.setTickLabeling("THIN");
                StatGraph.printNote(RB.getStringResource(RB_KEY, "timeToLinear.txt"));
            }
            if (this.getType() == 5 && this.ticks != null) {
                this.getRectAxisParams().setMinorNum(0);
            }
            if (this.userTicks != null && !this.tickValuePriority) {
                int i;
                double eps = VRectAxis.getPrecisionDelta(this.userTicks);
                double dMin = Math.min(inMin, inMax) - eps;
                double dMax = Math.max(inMin, inMax) + eps;
                int start = 0;
                int end = this.userTicks.length - 1;
                for (int i2 = 0; i2 < this.userTicks.length; ++i2) {
                    if (this.userTicks[i2] < dMin) {
                        ++start;
                    }
                    if (!(this.userTicks[i2] > dMax)) continue;
                    --end;
                }
                int idx = 0;
                this.ticks = new double[end - start + 1];
                for (i = start; i <= end; ++i) {
                    this.ticks[idx++] = this.userTicks[i];
                }
                if (this.userTickLabels != null) {
                    idx = 0;
                    this.tickLabels = new String[end - start + 1];
                    for (i = start; i <= end; ++i) {
                        this.tickLabels[idx++] = this.userTickLabels[i];
                    }
                }
            }
            double minVal = 0.0;
            if (!autoMin) {
                if (minPt == null) {
                    minVal = inMin;
                } else if (!(minPt instanceof ContinuousPoint)) {
                    autoMin = true;
                } else {
                    minVal = ((ContinuousPoint)minPt).getValue();
                }
            }
            double maxVal = 0.0;
            if (!autoMax) {
                if (maxPt == null) {
                    maxVal = inMax;
                } else if (!(maxPt instanceof ContinuousPoint)) {
                    autoMax = true;
                } else {
                    maxVal = ((ContinuousPoint)maxPt).getValue();
                }
            }
            ContinuousRange cr2 = new ContinuousRange((DataRange)cr1);
            SASFormat fmt = cr1.getFormat();
            if (this.getType() == 1) {
                if (this.isLogTimeAxis(fmt)) {
                    if (this.timeTickSpacer == null) {
                        this.timeTickSpacer = new DateTimeTickSpacer();
                    }
                    this.timeTickSpacer.setDataMin(inMin);
                    this.timeTickSpacer.setDataMax(inMax);
                    this.timeTickSpacer.getTickSpacingInfo().setFormat(fmt);
                    this.timeTickSpacer.getTickSpacingInfo().setMaxMinorTicks(reqMinorNum);
                    this.timeTickSpacer.getTickSpacingInfo().setMinorIntervalCode(this.params.getMinorTimeInterval());
                    this.timeTickSpacer.getTickSpacingInfo().setHonorMinorTickFormat(false);
                    this.timeTickSpacer.getPreference().setAutoInterval(true);
                    this.timeTickSpacer.getTickSpacingInfo().setMaxTicks(-1);
                    this.timeTickSpacer.doTickSpacing();
                    if (this.timeTickSpacer.getTickMin() > 0.0) {
                        cr2.setMin(this.timeTickSpacer.getTickMin());
                    } else {
                        cr2.setMin(inMin);
                    }
                    cr2.setMax(this.timeTickSpacer.getTickMax());
                    newRange = cr2;
                } else {
                    if (this.logMap == null) {
                        this.logMap = new ContinuousRangeToLogarithmicMap();
                    }
                    this.logTickIntervalStyle = this.userLogTickIntervalStyle;
                    if (this.logTickIntervalStyle == 3 && this.isLinearIntervalRequired(inMin, inMax)) {
                        this.logTickIntervalStyle = 2;
                        this.setTickLabeling("THINLOGARITHMIC");
                        if (this.params.getMinorNum() > 0) {
                            this.userReqMinorNumForLog = this.params.getMinorNum();
                        }
                        this.getRectAxisParams().setMinorNum(0);
                    }
                    if (this.logTickIntervalStyle != 2) {
                        this.tickLabeling = null;
                    }
                    this.logMap.setInputMin(inMin);
                    this.logMap.setInputMax(inMax);
                    this.logMap.setBase(this.logarithmBase);
                    this.logMap.setUniformTickValues(this.logTickIntervalStyle == 2);
                    this.logMap.setMinorTickMarksOn(reqMinorNum > 0);
                    this.logMap.setMinorTickCountPerInterval(this.userReqMinorNum);
                    if (this.logTickIntervalStyle == 2) {
                        this.logMap.setMaximumMajorTickCount(10);
                    } else {
                        this.logMap.setMaximumMajorTickCount(this.nTicks * 2 + 1);
                    }
                    this.logMap.setThresholdMin(this.startCoverage);
                    this.logMap.setThresholdMax(this.endCoverage);
                    if (this.ticks == null) {
                        this.logMap.computeMajorTickValues();
                    } else {
                        this.logMap.setMajorTickValues(this.ticks);
                        if (this.logTickIntervalStyle != 1) {
                            this.logTickIntervalStyle = 2;
                            this.setTickLabeling("THINLOGARITHMIC");
                        }
                        if (this.logMap.getMinorTickValues() == null) {
                            this.getRectAxisParams().setMinorNum(0);
                            if (this.isMinorTicksOn() || this.isMinorGridOn()) {
                                this.issueSASNote(RB.getStringResource(RB_KEY, "minorticks.txt"));
                            }
                        }
                    }
                    cr2.setMin(this.logMap.getInputMin());
                    cr2.setMax(this.logMap.getInputMax());
                    newRange = cr2;
                }
                this.axisLabelMap = null;
            } else if (this.getType() == 5 && fmt != null && fmt instanceof SASDateTimeFormat && this.ticks == null) {
                if (this.timeTickSpacer == null) {
                    this.timeTickSpacer = new DateTimeTickSpacer();
                }
                this.timeTickSpacer.setDataMin(inMin);
                this.timeTickSpacer.setDataMax(inMax);
                this.timeTickSpacer.getTickSpacingInfo().setFormat(fmt);
                this.timeTickSpacer.getTickSpacingInfo().setMaxMinorTicks(reqMinorNum);
                this.timeTickSpacer.getTickSpacingInfo().setMinorIntervalCode(this.params.getMinorTimeInterval());
                this.timeTickSpacer.getTickSpacingInfo().setHonorMinorTickFormat(false);
                if (this.params.getTimeInterval() == 0) {
                    this.timeTickSpacer.getPreference().setAutoInterval(true);
                    this.timeTickSpacer.getTickSpacingInfo().setMaxTicks(-1);
                } else {
                    this.timeTickSpacer.getPreference().setAutoInterval(false);
                    this.timeTickSpacer.getTickSpacingInfo().setInterval(this.params.getTimeInterval(), this.params.getTimeIntervalMultiplier());
                }
                this.timeTickSpacer.doTickSpacing();
                double minTick = this.dynamic && reqMinorNum <= 0 ? inMin : this.timeTickSpacer.getTickMin();
                double maxTick = this.dynamic && reqMinorNum <= 0 ? inMax : this.timeTickSpacer.getTickMax();
                cr2.setMin(minTick);
                cr2.setMax(maxTick);
                newRange = cr2;
                this.axisLabelMap = null;
            } else {
                this.setType(0);
                if (this.ticks != null) {
                    double inputMin = this.isViewportSet() || this.ticks.length == 0 ? inMin : Math.min(this.ticks[0], inMin);
                    double inputMax = this.isViewportSet() || this.ticks.length == 0 ? inMax : Math.max(this.ticks[this.ticks.length - 1], inMax);
                    cr2.setMin(inputMin);
                    cr2.setMax(inputMax);
                    newRange = cr2;
                    this.majorNum = this.ticks.length;
                } else if (this.isInfiniteRange(inMin, inMax)) {
                    cr2.setMin(inMin);
                    cr2.setMax(inMax);
                    newRange = cr2;
                    this.setTicks(new double[]{inMin, inMax});
                    this.majorNum = 2;
                } else if (!(autoMin || autoMax || autoMajorNum)) {
                    cr2.setMin(minVal);
                    cr2.setMax(maxVal);
                    newRange = cr2;
                    this.majorNum = reqMajorNum;
                    this.majorInterval = new TickInterval((maxVal - minVal) / (double)(this.majorNum - 1));
                } else if (autoMin && autoMax && autoMajorNum) {
                    if (inMin == Double.MAX_VALUE || inMax == -1.7976931348623157E308) {
                        return;
                    }
                    if (inMin == inMax) {
                        this.axisLabelMap = null;
                        this.majorNum = 1;
                        this.majorInterval = new TickInterval(0.0);
                        cr2.setMin(inMin);
                        cr2.setMax(inMax);
                        newRange = cr2;
                    } else {
                        double interval;
                        double maxTick;
                        int tickInt;
                        double minTick;
                        if (autoMajorInterval) {
                            double[] val = this.integerTicks ? ZxAxis.ziaxis((long)((long)Math.floor(inMin)), (long)((long)Math.ceil(inMax)), (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8) : ZxAxis.znaxis((double)inMin, (double)inMax, (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8);
                            minTick = val[0];
                            tickInt = (int)(val[2] - 1.0);
                            maxTick = minTick + val[1] * (double)tickInt;
                            interval = val[1];
                        } else {
                            interval = reqMajorInterval.getSize();
                            minTick = Math.floor(inMin / interval + 1.0E-6) * interval;
                            maxTick = Math.ceil(inMax / interval - 1.0E-6) * interval;
                            tickInt = (int)Math.floor((maxTick - minTick) / interval + 1.0E-6);
                        }
                        if (inMin < minTick) {
                            minTick -= interval;
                            ++tickInt;
                        }
                        if (inMax > maxTick) {
                            maxTick += interval;
                            ++tickInt;
                        }
                        int cnt = tickInt + 1;
                        double min = 0.0;
                        double max = 0.0;
                        double firstTick = 0.0;
                        double lastTick = 0.0;
                        if (inMin - minTick <= this.startCoverage * interval || cnt <= 2) {
                            min = minTick;
                            firstTick = minTick;
                        } else {
                            min = inMin;
                            firstTick = minTick + interval;
                            --cnt;
                        }
                        if (maxTick - inMax <= this.endCoverage * interval || cnt <= 2) {
                            max = maxTick;
                            lastTick = maxTick;
                        } else {
                            max = inMax;
                            lastTick = maxTick - interval;
                            --cnt;
                        }
                        cr2.setMin(min);
                        cr2.setMax(max);
                        if (min != minTick || max != maxTick) {
                            if (this.axisLabelMap == null) {
                                this.axisLabelMap = new ContinuousRangeToNumericMap();
                            }
                            this.axisLabelMap.setInputMin(firstTick);
                            this.axisLabelMap.setInputMax(lastTick);
                            this.axisLabelMap.setLabelCount(cnt);
                        } else {
                            this.axisLabelMap = null;
                        }
                        newRange = cr2;
                        this.majorNum = tickInt + 1;
                        this.majorInterval = new TickInterval((maxTick - minTick) / (double)tickInt);
                    }
                } else if (autoMin && autoMax && !autoMajorNum) {
                    double[] val = this.integerTicks ? ZxAxis.ziaxis((long)((long)inMin), (long)((long)inMax), (boolean)true, (boolean)false, (int)reqMajorNum, (double)0.2, (double)0.8) : ZxAxis.znaxis((double)inMin, (double)inMax, (boolean)true, (boolean)false, (int)reqMajorNum, (double)0.2, (double)0.8);
                    double minTick = val[0];
                    int tickInt = (int)(val[2] - 1.0);
                    double maxTick = minTick + val[1] * (double)tickInt;
                    int calcTickNum = tickInt + 1;
                    if (calcTickNum < reqMajorNum) {
                        int diff = reqMajorNum - calcTickNum;
                        int pre = diff / 2;
                        int post = diff - pre;
                        minTick -= (double)pre * val[1];
                        maxTick += (double)post * val[1];
                    }
                    cr2.setMin(minTick);
                    cr2.setMax(maxTick);
                    newRange = cr2;
                    this.majorNum = reqMajorNum;
                    this.majorInterval = new TickInterval((maxTick - minTick) / (double)(this.majorNum - 1));
                }
            }
        } else {
            this.setType(6);
            newRange = valRange;
        }
        if (newRange != null && newRange.equals((Object)oldRange) && !this.isViewportSet()) {
            newRange = oldRange;
        }
        this.outputRange = newRange;
        byte dim = this.dimension;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
            if (this.encoder != null && rce.getType() == 3) {
                this.encoder.setInput(newRange);
                this.setEncoder(dim, this.encoder);
            }
        }
    }

    public RectAxisParams getRectAxisParams() {
        return this.params;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        if (dimension != this.dimension) {
            return null;
        }
        return this.encoder;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean aPrimary) {
        boolean oldp = this.primary;
        this.primary = aPrimary;
        if (this.primary != oldp && this.vtkAxis != null) {
            this.vtkAxis.setPrimary(this.primary);
        }
    }

    public double getStartOffset() {
        return this.startOffset;
    }

    public double getUserStartOffset() {
        return this.userStartOffset;
    }

    public void setUserStartOffset(double offset) {
        this.userStartOffset = offset;
    }

    public double getAbsStartOffset() {
        if (this.userStartOffset < 0.0) {
            return this.userStartOffset;
        }
        PositionEncoder pe = (PositionEncoder)this.encoder;
        double axisLength = pe.getUpperLimit() - pe.getLowerLimit() - (double)this.spaceForInnerMargin;
        return axisLength * this.userStartOffset;
    }

    public double getUserEndOffset() {
        return this.userEndOffset;
    }

    public void setUserEndOffset(double offset) {
        this.userEndOffset = offset;
    }

    public double getAbsEndOffset() {
        if (this.userEndOffset < 0.0) {
            return this.userEndOffset;
        }
        PositionEncoder pe = (PositionEncoder)this.encoder;
        double axisLength = pe.getUpperLimit() - pe.getLowerLimit() - (double)this.spaceForInnerMargin;
        return axisLength * this.userEndOffset;
    }

    public void setStartOffset(double aStartOffset) {
        double oldOffset = this.startOffset;
        this.startOffset = aStartOffset;
        if (this.startOffset != oldOffset && this.vtkAxis != null) {
            this.vtkAxis.setLineOffset(-this.startOffset);
            PositionEncoder pe = (PositionEncoder)this.encoder;
            double length = pe.getOutputMax() - pe.getOutputMin();
            this.vtkAxis.setLength(this.startOffset + length + this.endOffset);
            this.vtkAxis.setDataLength(length);
        }
    }

    public double getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(double aEndOffset) {
        double oldOffset = this.endOffset;
        this.endOffset = aEndOffset;
        if (this.endOffset != oldOffset && this.vtkAxis != null) {
            PositionEncoder pe = (PositionEncoder)this.encoder;
            double length = pe.getOutputMax() - pe.getOutputMin();
            this.vtkAxis.setLength(this.startOffset + length + this.endOffset);
            this.vtkAxis.setDataLength(length);
        }
    }

    public int getMinOffsetBy() {
        return this.minOffsetBy;
    }

    public void setMinOffsetBy(int by) {
        this.minOffsetBy = by;
    }

    public int getMaxOffsetBy() {
        return this.maxOffsetBy;
    }

    public void setMaxOffsetBy(int by) {
        this.maxOffsetBy = by;
    }

    public double getStartCoverage() {
        return this.startCoverage;
    }

    public void setStartCoverage(double coverage) {
        this.startCoverage = coverage;
    }

    public double getEndCoverage() {
        return this.endCoverage;
    }

    public void setEndCoverage(double coverage) {
        this.endCoverage = coverage;
    }

    public int getMajorNum() {
        return this.majorNum;
    }

    public TickInterval getMajorInterval() {
        return this.majorInterval;
    }

    public void setTickValuePriority(boolean b) {
        this.tickValuePriority = b;
    }

    public boolean getTickValuePriority() {
        return this.tickValuePriority;
    }

    public String[] getDiscreteTicks() {
        return this.discreteTicks;
    }

    public void setDiscreteTicks(String[] userTicks) {
        if (userTicks != null) {
            int i;
            ArrayList<String> ut = new ArrayList<String>();
            for (i = 0; i < userTicks.length; ++i) {
                if (userTicks[i].trim().length() == 0) {
                    userTicks[i] = userTicks[i].trim();
                }
                if (ut.contains(userTicks[i])) continue;
                ut.add(userTicks[i]);
            }
            if (ut.size() > 0) {
                this.discreteTicks = new String[ut.size()];
                for (i = 0; i < ut.size(); ++i) {
                    this.discreteTicks[i] = (String)ut.get(i);
                }
                return;
            }
        }
        this.discreteTicks = null;
    }

    public double[] getTicks() {
        return this.userTicks;
    }

    public void setTicks(double[] userTicks) {
        this.userTicks = userTicks;
        this.ticks = this.userTicks;
    }

    public String[] getTickLabels() {
        return this.userTickLabels;
    }

    public void setTickLabels(String[] userLabels) {
        this.userTickLabels = userLabels;
        this.tickLabels = this.userTickLabels;
    }

    public boolean isExtractScale() {
        return this.extractScale;
    }

    public void setExtractScale(boolean extract) {
        this.extractScale = extract;
    }

    public boolean isScientificScale() {
        return this.scientificScale;
    }

    public void setScientificScale(boolean b) {
        this.scientificScale = b;
    }

    public int getTickLabelMaxWidth() {
        return this.tickLabelMaxWidth;
    }

    public void setTicklabelMaxWidth(int w) {
        this.tickLabelMaxWidth = w;
    }

    public int getTickLabelMaxDecimals() {
        return this.tickLabelMaxDecimals;
    }

    public void setTicklabelMaxDecimals(int n) {
        this.tickLabelMaxDecimals = n;
    }

    public int getTickLabelPreferredDecimals() {
        return this.tickLabelPreferredDecimals;
    }

    public void setTicklabelPreferredDecimals(int n) {
        this.tickLabelPreferredDecimals = n;
    }

    public double getLogarithmBase() {
        return this.logarithmBase;
    }

    public void setLogarithmBase(double base) {
        this.logarithmBase = base;
    }

    public int getLogTickIntervalStyle() {
        return this.logTickIntervalStyle;
    }

    public void setLogTickIntervalStyle(int style) {
        this.userLogTickIntervalStyle = this.logTickIntervalStyle = style;
    }

    public void setMinorNum(int num) {
        this.params.setMinorNum(num);
        this.userReqMinorNum = -1;
    }

    public int getMinorNum() {
        return this.params.getMinorNum();
    }

    private boolean isUniformTicks() {
        if (this.ticks.length < 2) {
            return false;
        }
        double inc = this.ticks[1] - this.ticks[0];
        for (int i = 1; i < this.ticks.length - 1; ++i) {
            if (!(Math.abs(this.ticks[i + 1] - this.ticks[i] - inc) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private boolean isNamedFormat(SASFormat fmt) {
        return NumericFormat.isNamedFormat((SASFormat)fmt);
    }

    private boolean isGGOODSupportedFormat(SASFormat fmt) {
        if (NumericFormat.isNamedFormat((SASFormat)fmt)) {
            return fmt.isNumericFormat() && fmt.getFormatDescription().isDecimalWidthSupported();
        }
        return true;
    }

    private boolean isLogTimeAxis(SASFormat fmt) {
        return fmt != null && fmt instanceof SASDateTimeFormat && this.ticks == null && this.userLogTickIntervalStyle == 2;
    }

    private boolean isLinearIntervalRequired(double min, double max) {
        if (this.logTickIntervalStyle != 3) {
            return false;
        }
        double logMin = Math.log(min) / Math.log(this.logarithmBase);
        int nLo = (int)Math.floor(logMin);
        double logMax = Math.log(max) / Math.log(this.logarithmBase);
        int nHi = (int)Math.ceil(logMax);
        int nTicks = nHi - nLo + 1;
        if (nTicks < 3) {
            return true;
        }
        double interval = 1.0;
        if (logMin - (double)nLo > this.startCoverage * interval) {
            --nTicks;
        }
        if ((double)nHi - logMax > this.endCoverage * interval) {
            --nTicks;
        }
        return nTicks < 3;
    }

    public RectangularAxis getVTKAxis() {
        return this.vtkAxis;
    }

    public void setVTKAxis(RectangularAxis axis) {
        this.vtkAxis = axis;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isViewportSet() {
        return this.dynamic || !this.tickValuePriority && (!Double.isNaN(this.viewportMin) || !Double.isNaN(this.viewportMax));
    }

    public static double[] getBinTickList(BinnedRange br) {
        if (br instanceof SimpleBinnedRange) {
            return VRectAxis.getBinTickList((SimpleBinnedRange)br);
        }
        return VRectAxis.getBinTickList((CustomBinnedRange)br);
    }

    private static double[] getBinTickList(SimpleBinnedRange sbr) {
        if (!(sbr.getDual() instanceof ContinuousRange)) {
            return null;
        }
        double min = ((ContinuousRange)sbr.getDual()).getMin();
        double max = ((ContinuousRange)sbr.getDual()).getMax();
        double first = sbr.getFirstMidpoint();
        double size = sbr.getBinSize();
        double v = 0.0;
        int numTicks = 0;
        double delta = size * 0.001;
        for (int i = 0; i < sbr.getNumBins(); ++i) {
            v = first + size * (double)i;
            if (sbr.isEndLabels()) {
                v -= 0.5 * size;
            }
            if (!(v >= min - delta) || !(v <= max + delta)) continue;
            ++numTicks;
        }
        if (sbr.isEndLabels() && v + size >= min - delta && v + size <= max + delta) {
            ++numTicks;
        }
        double[] ticks = new double[numTicks];
        int idx = 0;
        for (int i = 0; i < sbr.getNumBins(); ++i) {
            v = first + size * (double)i;
            if (sbr.isEndLabels()) {
                v -= 0.5 * size;
            }
            if (!(v >= min - delta) || !(v <= max + delta)) continue;
            ticks[idx] = v;
            ++idx;
        }
        if (sbr.isEndLabels() && v + size >= min - delta && v + size <= max + delta) {
            ticks[idx] = v + size;
        }
        ticks = NumericFormat.processValues((double[])ticks, (double)size);
        return ticks;
    }

    private static double[] getBinTickList(CustomBinnedRange cbr) {
        double[] ticks;
        if (!(cbr.getDual() instanceof ContinuousRange)) {
            return null;
        }
        if (cbr.isEndLabels()) {
            double[] boundaries = cbr.getBoundaries();
            ticks = new double[boundaries.length];
            for (int i = 0; i < boundaries.length; ++i) {
                ticks[i] = boundaries[i];
            }
        } else {
            double[] midpoints = cbr.getMidpoints();
            ticks = new double[midpoints.length];
            for (int i = 0; i < midpoints.length; ++i) {
                ticks[i] = midpoints[i];
            }
        }
        return ticks;
    }

    public VRectAxis getMirrorAxis() {
        return this.mirrorAxis;
    }

    public void setMirrorAxis(VRectAxis axis) {
        this.mirrorAxis = axis;
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    public void setSecondary(boolean b) {
        this.secondary = b;
    }

    public boolean isOriginOn() {
        if (this.encoder == null) {
            return false;
        }
        NumericMap map = (NumericMap)this.encoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        double min = ((ContinuousRangeToNumericMap)map).getInputMin();
        double max = ((ContinuousRangeToNumericMap)map).getInputMax();
        if (!this.isReverse() && !Double.isNaN(this.origin) && this.origin >= min && this.origin <= max) {
            return true;
        }
        return this.isReverse() && !Double.isNaN(this.origin) && this.origin >= max && this.origin <= min;
    }

    public double getOutputOrigin() {
        double output = Double.NaN;
        if (Double.isNaN(this.origin)) {
            return output;
        }
        NumericMap map = (NumericMap)this.encoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return output;
        }
        return ((ContinuousRangeToNumericMap)map).getValue(this.origin);
    }

    public double getTitleHeight(Channel channel) {
        AxisStyle style = this.vtkAxis.getStyle();
        String text = this.vtkAxis.title.getValue();
        if (!style.isTitleOn() || text == null || text.length() == 0) {
            return 0.0;
        }
        TextStyle lStyle = style.getLabelStyle();
        channel.glSelect2DFont(lStyle.getFont());
        double labelHeight = channel.glGetTextHeight();
        TextStyle tStyle = style.getTitleStyle();
        Bbox titleBox = new Bbox();
        channel.glSelect2DFont(tStyle.getFont());
        channel.glGetText2DBbox(text, 0.0, 0.0, 0.0, (int)tStyle.getAngle(), titleBox);
        double height = this.labelPosition == 1 || this.labelPosition == 3 ? style.getTitleSpace() * labelHeight + (titleBox.ymax - titleBox.ymin) : style.getTitleEndSpace() * labelHeight + (titleBox.ymax - titleBox.ymin);
        if (this.isDisplayStackedLabels() && this.stackedLabels != null && this.stackedLabels.length > 1) {
            for (int i = 1; i < this.stackedLabels.length; ++i) {
                if (this.stackedLabels[i] == null || this.stackedLabels[i].length() == 0) continue;
                channel.glGetText2DBbox(this.stackedLabels[i], 0.0, 0.0, 0.0, (int)tStyle.getAngle(), titleBox);
                height += titleBox.ymax - titleBox.ymin;
            }
        }
        return height;
    }

    public double getTitleWidth(Channel channel) {
        AxisStyle style = this.vtkAxis.getStyle();
        String text = this.vtkAxis.title.getValue();
        if (!style.isTitleOn() || text == null || text.length() == 0) {
            return 0.0;
        }
        TextStyle lStyle = style.getLabelStyle();
        channel.glSelect2DFont(lStyle.getFont());
        double labelHeight = channel.glGetTextHeight();
        TextStyle tStyle = style.getTitleStyle();
        Bbox titleBox = new Bbox();
        channel.glSelect2DFont(tStyle.getFont());
        channel.glGetText2DBbox(text, 0.0, 0.0, 0.0, (int)tStyle.getAngle(), titleBox);
        if (this.labelPosition == 1 || this.labelPosition == 3) {
            return style.getTitleSpace() * labelHeight + (titleBox.xmax - titleBox.xmin);
        }
        return style.getTitleEndSpace() * labelHeight + (titleBox.xmax - titleBox.xmin);
    }

    public void updateGridLines(Vector glv) {
        if (this.vtkAxis == null || glv == null) {
            return;
        }
        this.glv = glv;
        for (int j = 0; j < glv.size(); ++j) {
            VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
            rgl.setVisibleTickIndices(null);
        }
        this.vtkAxis.setInvokePostFitProcessorDuringGetMetrics(true);
        if (this.getDimension() == 1 && this.fitStrategy != null) {
            if (this.fitStrategy.trim().length() > 0) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            } else if (this.honorFitStrategy) {
                this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
            }
        }
        if (this.getDimension() == 2 && this.honorFitStrategy && this.fitStrategy != null) {
            this.vtkAxis.setForceFitAlgorithm(this.fitStrategy);
        }
        this.vtkAxis.getMetrics(this.networkRoot.getChannel());
        this.vtkAxis.setInvokePostFitProcessorDuringGetMetrics(false);
    }

    public void postFitUpdate(AAxis.PostFitContext postFitContext) {
        double v;
        int i;
        ContinuousRangeToNumericMap crnm;
        Object[] gGoodLabels;
        double inc;
        double max;
        double min;
        boolean bl = this.labelsFit = !postFitContext.labelsHaveBeenThinned();
        if (this.labelsFit) {
            return;
        }
        if (!postFitContext.isRendering() && !this.isBrokenAxis()) {
            if (this.glv != null) {
                int[] index = postFitContext.getVisibleLabelIndices();
                for (int j = 0; j < this.glv.size(); ++j) {
                    VRectGridLines rgl = (VRectGridLines)this.glv.elementAt(j);
                    rgl.setVisibleTickIndices(index);
                }
            }
            return;
        }
        if (this.getType() != 0 || this.tickLabeling == "thin_inside_to_outside" || this.tickLabeling == "thin_end_to_beginning" || this.tickLabeling == "thin_beginning_to_end") {
            return;
        }
        int[] index = postFitContext.getVisibleLabelIndices();
        if (index.length < 2) {
            return;
        }
        String suffix = "";
        StringVector labels = null;
        NumericVector offsets = null;
        int labelCount = index.length;
        if (this.ticks == null && this.reformat) {
            min = this.axisLabelMap != null ? this.axisLabelMap.getInputMin() : ((ContinuousRange)this.encoder.getInput()).getMin();
            max = this.axisLabelMap != null ? this.axisLabelMap.getInputMax() : ((ContinuousRange)this.encoder.getInput()).getMax();
            inc = this.majorInterval.getSize();
            if (this.isReverse()) {
                min = max - inc * (double)index[index.length - 1];
                max -= inc * (double)index[0];
            } else {
                max = min + inc * (double)index[index.length - 1];
                min += inc * (double)index[0];
            }
            inc = (double)(index[1] - index[0]) * inc;
            gGoodLabels = this.getGGoodLabels(min, max, inc, labelCount);
            labels = (StringVector)gGoodLabels[0];
            suffix = (String)gGoodLabels[1];
            offsets = new NumericVector(labelCount);
            crnm = this.axisLabelMap != null ? this.axisLabelMap : (ContinuousRangeToNumericMap)this.encoder.getValueMap();
            for (i = 0; i < labelCount; ++i) {
                v = min + inc * (double)i;
                offsets.addValue(crnm.getValue(v));
            }
        }
        if (this.tickLabels == null && this.ticks != null && this.isUniformTicks() && this.reformat) {
            min = this.isReverse() ? this.ticks[this.tickLabelOffset - index[index.length - 1]] : this.ticks[this.tickLabelOffset + index[0]];
            max = this.isReverse() ? this.ticks[this.tickLabelOffset - index[0]] : this.ticks[this.tickLabelOffset + index[index.length - 1]];
            inc = this.isReverse() ? this.ticks[this.tickLabelOffset - index[0]] - this.ticks[this.tickLabelOffset - index[1]] : this.ticks[this.tickLabelOffset + index[1]] - this.ticks[this.tickLabelOffset + index[0]];
            gGoodLabels = this.getGGoodLabels(min, max, inc, labelCount);
            labels = (StringVector)gGoodLabels[0];
            suffix = (String)gGoodLabels[1];
            offsets = new NumericVector(labelCount);
            crnm = (ContinuousRangeToNumericMap)this.encoder.getValueMap();
            for (i = 0; i < labelCount; ++i) {
                v = min + inc * (double)i;
                offsets.addValue(crnm.getValue(v));
            }
        }
        if (labels != null && offsets != null) {
            String[] newLabels = new String[labelCount];
            double[] newOffsets = new double[labelCount];
            for (int i2 = 0; i2 < labelCount; ++i2) {
                try {
                    newLabels[i2] = labels.getValue(i2);
                    newOffsets[i2] = offsets.getValue(i2);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            postFitContext.setDisplayLabels(newLabels, newOffsets);
            if (this.isMinorTicksOn()) {
                this.connectMinorTickOffset((NumericPipe)offsets, labelCount);
            }
        }
        if (suffix != null && suffix.trim().length() > 0 && (this.titleFitPolicy == 1 || this.titleFitPolicy == 2)) {
            suffix = invisibleChar + suffix;
        }
        if (this.vtkAxis.getStyle().isTitleOn() && this.extractScale && this.reformat) {
            String newTitle = !this.useTitle.equals("") ? (this.labelFormat != null ? (this.labelFormat.isCharacterFormat() ? this.getAxisTitle(this.labelFormat.format((Object)this.useTitle), suffix) : this.getAxisTitle(this.labelFormat.format((Object)new Double(this.useTitle)), suffix)) : this.getAxisTitle(this.useTitle, suffix)) : (this.labelFormat != null ? (this.labelFormat.isCharacterFormat() ? this.getAxisTitle(this.labelFormat.format((Object)this.encoder.getInput().getLabel()), suffix) : this.getAxisTitle(this.labelFormat.format((Object)new Double(this.encoder.getInput().getLabel())), suffix)) : this.getAxisTitle(this.encoder.getInput().getLabel(), suffix));
            String newShortTitle = !this.shortTitle.equals("") ? this.getAxisTitle(this.shortTitle, suffix) : null;
            postFitContext.setDisplayTitles(newTitle, newShortTitle);
        }
    }

    public boolean postFitRequired() {
        if (this.getType() != 0 || this.tickLabeling == "thin_inside_to_outside" || this.tickLabeling == "thin_end_to_beginning" || this.tickLabeling == "thin_beginning_to_end") {
            return false;
        }
        return this.reformat && (this.ticks == null || this.ticks != null && this.isUniformTicks() && this.tickLabels == null);
    }

    static NumericPipe getCategoryBoundries(PositionEncoder encoder, boolean reversed) {
        return VRectAxis.getCategoryBoundriesInBetween(encoder, reversed, null);
    }

    static boolean isTickVisible(double tick, PositionEncoder encoder) {
        if (tick > encoder.getUpperLimit()) {
            return false;
        }
        return !(tick < encoder.getLowerLimit());
    }

    static NumericPipe getCategoryBoundries(PositionEncoder encoder, boolean reversed, int[] visibleTickIndices) {
        StringToNumericMap stnm = (StringToNumericMap)encoder.getValueMap();
        double halfStride = stnm.getStrideValue() / 2.0;
        NumericVector nv = new NumericVector();
        if (visibleTickIndices == null) {
            for (int i = 0; i < stnm.getUniqueValueCount(); ++i) {
                try {
                    double tick;
                    if (reversed) {
                        tick = stnm.uniqueValue.getValue(i) - halfStride;
                        if (VRectAxis.isTickVisible(tick, encoder)) {
                            nv.addValue(tick);
                        }
                        if (i != stnm.getUniqueValueCount() - 1 || !VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(i) + halfStride, encoder)) continue;
                        nv.addValue(tick);
                        continue;
                    }
                    if (i == 0 && VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(i) - halfStride, encoder)) {
                        nv.addValue(tick);
                    }
                    if (!VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(i) + halfStride, encoder)) continue;
                    nv.addValue(tick);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < visibleTickIndices.length; ++i) {
                try {
                    double tick;
                    int idx = visibleTickIndices[i];
                    if (reversed) {
                        if (i == visibleTickIndices.length - 1 && VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(idx) + halfStride, encoder)) {
                            nv.addValue(tick);
                        }
                        if (!VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(idx) - halfStride, encoder)) continue;
                        nv.addValue(tick);
                        continue;
                    }
                    if (i == 0 && VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(idx) - halfStride, encoder)) {
                        nv.addValue(tick);
                    }
                    if (!VRectAxis.isTickVisible(tick = stnm.uniqueValue.getValue(idx) + halfStride, encoder)) continue;
                    nv.addValue(tick);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        return nv;
    }

    static NumericPipe getCategoryBoundriesInBetween(PositionEncoder encoder, boolean reversed, int[] visibleTickIndices) {
        StringToNumericMap stnm = (StringToNumericMap)encoder.getValueMap();
        double halfStride = stnm.getStrideValue() / 2.0;
        NumericVector nv = new NumericVector();
        for (int i = 0; i < stnm.getUniqueValueCount() - 1; ++i) {
            try {
                double tick = stnm.uniqueValue.getValue(i) + halfStride;
                if (!VRectAxis.isTickVisible(tick, encoder)) continue;
                nv.addValue(tick);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return nv;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public LineAttrs getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(LineAttrs gridStyle) {
        this.gridStyle = gridStyle;
    }

    public LineAttrs getMinorGridStyle() {
        return this.minorGridStyle;
    }

    public void setMinorGridStyle(LineAttrs gridStyle) {
        this.minorGridStyle = gridStyle;
    }

    public int getMPC() {
        return this.mpc;
    }

    public void setMPC(int mpc) {
        this.mpc = mpc;
    }

    public void setMinorTicksOn(boolean on) {
        this.minorTicksOn = on;
    }

    public boolean isMinorTicksOn() {
        return this.minorTicksOn;
    }

    public void setMinorGridOn(boolean on) {
        this.minorGridOn = on;
    }

    public boolean isMinorGridOn() {
        return this.minorGridOn;
    }

    public void setUserReqMinorNum(int n) {
        this.userReqMinorNum = n;
    }

    public int getUserReqMinorNum() {
        return this.userReqMinorNum;
    }

    public void setCompressExtender(boolean b) {
        this.compressExtender = b;
    }

    public boolean isCompressExtender() {
        return this.compressExtender;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public void setComposite(OverviewAxisComposite composite) {
        this.composite = composite;
    }

    public OverviewAxisComposite getComposite() {
        if (!this.visible) {
            return null;
        }
        return this.composite;
    }

    public void setDisplayMin(double min) {
        this.displayMin = min;
    }

    public double getDisplayMin() {
        return this.displayMin;
    }

    public void setDisplayMax(double max) {
        this.displayMax = max;
    }

    public double getDisplayMax() {
        return this.displayMax;
    }

    public void setOverviewAxisOn(boolean on) {
        this.overviewAxisOn = on;
    }

    public boolean isOverviewAxisOn() {
        return this.overviewAxisOn;
    }

    public void setFitStrategy(String strategy) {
        this.fitStrategy = strategy;
    }

    public String getFitStrategy() {
        return this.fitStrategy;
    }

    public void setTickValueListPolicy(int policy) {
        this.tickValueListPolicy = policy;
    }

    public int getTickValueListPolicy() {
        return this.tickValueListPolicy;
    }

    public void setInitialFitting(boolean initial) {
        this.initialFitting = initial;
    }

    private ContinuousRange[] clearUpInputRanges() {
        if (this.inputRanges == null || this.inputRange == null) {
            return this.inputRanges;
        }
        if (this.inputRange instanceof SimpleBinnedRange) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "includeranges.txt"));
            return null;
        }
        ContinuousRange[] r = new ContinuousRange[this.inputRanges.length];
        int n = 0;
        for (int i = 0; i < this.inputRanges.length; ++i) {
            double max;
            double min = this.inputRanges[i].getMin();
            if (min == BrokenPositionEncoder.DATA_MIN) {
                min = ((ContinuousRange)this.inputRange).getMin();
            }
            if ((max = this.inputRanges[i].getMax()) == BrokenPositionEncoder.DATA_MAX) {
                max = ((ContinuousRange)this.inputRange).getMax();
            }
            if (!(max >= min)) continue;
            r[n] = new ContinuousRange(min, max);
            r[n].setMinExclude(this.inputRanges[i].isMinExclude());
            r[n].setMaxExclude(this.inputRanges[i].isMaxExclude());
            ++n;
        }
        if (n < 1) {
            return null;
        }
        if (n < this.inputRanges.length) {
            ContinuousRange[] r2 = new ContinuousRange[n];
            for (int i = 0; i < n; ++i) {
                r2[i] = r[i];
            }
            return r2;
        }
        return r;
    }

    private void updateOutputRange(ContinuousRange[] inputRanges) {
        this.outputRange = null;
        if (this.inputRange == null || inputRanges == null) {
            return;
        }
        double MIN = Double.MAX_VALUE;
        double MAX = -1.7976931348623157E308;
        int numRanges = inputRanges.length;
        ArrayList[] tickList = new ArrayList[numRanges];
        double[] firstTick = new double[numRanges];
        double[] lastTick = new double[numRanges];
        SASFormat fmt = this.inputRange.getFormat();
        if (this.getType() == 5 && fmt != null && fmt instanceof SASDateTimeFormat && this.ticks == null) {
            int i;
            double inMax;
            double inMin;
            if (this.timeTickSpacer == null) {
                this.timeTickSpacer = new DateTimeTickSpacer();
            }
            ZxAxis.Interval[] interval = new ZxAxis.Interval[numRanges];
            ZxAxis.Interval[] interval2 = new ZxAxis.Interval[numRanges];
            String[] format = new String[numRanges];
            for (int i2 = 0; i2 < numRanges; ++i2) {
                inMin = inputRanges[i2].getMin();
                if (inMin > (inMax = inputRanges[i2].getMax())) {
                    return;
                }
                if (inMin < MIN) {
                    MIN = inMin;
                }
                if (inMax > MAX) {
                    MAX = inMax;
                }
                this.timeTickSpacer.setDataMin(inMin);
                this.timeTickSpacer.setDataMax(inMax);
                this.timeTickSpacer.getTickSpacingInfo().setFormat(fmt);
                this.timeTickSpacer.getTickSpacingInfo().setMaxMinorTicks(this.params.getMinorNum());
                this.timeTickSpacer.getTickSpacingInfo().setMinorIntervalCode(this.params.getMinorTimeInterval());
                this.timeTickSpacer.getTickSpacingInfo().setHonorMinorTickFormat(false);
                if (this.params.getTimeInterval() == 0) {
                    this.timeTickSpacer.getPreference().setAutoInterval(true);
                    this.timeTickSpacer.getTickSpacingInfo().setMaxTicks(-1);
                } else {
                    this.timeTickSpacer.getPreference().setAutoInterval(false);
                    this.timeTickSpacer.getTickSpacingInfo().setInterval(this.params.getTimeInterval(), this.params.getTimeIntervalMultiplier());
                }
                this.timeTickSpacer.doTickSpacing();
                interval[i2] = this.timeTickSpacer.getInterval();
                interval2[i2] = this.timeTickSpacer.getMinorInterval();
                format[i2] = this.timeTickSpacer.getFormatName(true);
            }
            int intCode = interval[0].intcode;
            ZxAxis.Interval minInterval = interval[0];
            ZxAxis.Interval minorInterval = interval2[0];
            this.theTimeFormatName = format[0];
            for (i = 1; i < interval.length; ++i) {
                if (interval[i].intcode >= intCode) continue;
                minInterval = interval[i];
                minorInterval = interval2[i];
                this.theTimeFormatName = format[i];
            }
            this.tickValues = new double[numRanges][];
            for (i = 0; i < numRanges; ++i) {
                inMin = inputRanges[i].getMin();
                double ticknd = ZxAxis.zintck2((ZxAxis.Interval)minInterval, (double)inMin, (double)(inMax = inputRanges[i].getMax()));
                if (Double.isNaN(ticknd) || ticknd > 100.0) {
                    this.tickValues[i] = new double[2];
                    this.tickValues[i][0] = inMin;
                    this.tickValues[i][1] = inMax;
                    continue;
                }
                int ticks = (int)ticknd + 1;
                double xmin = ZxAxis.zintnx2((ZxAxis.Interval)minInterval, (double)inMin, (double)0.0);
                double xmax = ZxAxis.zintnx2((ZxAxis.Interval)minInterval, (double)inMax, (double)0.0);
                if (xmax > inMax) {
                    --ticks;
                }
                if (xmin < inMin) {
                    --ticks;
                }
                this.tickValues[i] = new double[ticks];
                this.tickValues[i][0] = xmin < inMin ? ZxAxis.zintnx2((ZxAxis.Interval)minInterval, (double)xmin, (double)1.0) : xmin;
                for (int j = 1; j < ticks; ++j) {
                    this.tickValues[i][j] = ZxAxis.zintnx2((ZxAxis.Interval)minInterval, (double)this.tickValues[i][j - 1], (double)1.0);
                }
                firstTick[i] = xmin;
                lastTick[i] = xmax < inMax ? ZxAxis.zintnx2((ZxAxis.Interval)minInterval, (double)xmax, (double)1.0) : xmax;
            }
            if (this.params.getMinorNum() > 0 && minorInterval != null) {
                this.minorTickValues = new double[numRanges][];
                for (i = 0; i < numRanges; ++i) {
                    double v;
                    inMin = inputRanges[i].getMin();
                    inMax = inputRanges[i].getMax();
                    double[] major = this.tickValues[i];
                    int tickn = 0;
                    if (firstTick[i] < major[0]) {
                        tickn += (int)ZxAxis.zintck2((ZxAxis.Interval)minorInterval, (double)firstTick[i], (double)major[0]) + 2;
                    }
                    if (lastTick[i] > major[major.length - 1]) {
                        tickn += (int)ZxAxis.zintck2((ZxAxis.Interval)minorInterval, (double)major[major.length - 1], (double)lastTick[i]) + 2;
                    }
                    for (int j = 0; j < major.length - 1; ++j) {
                        tickn += (int)ZxAxis.zintck2((ZxAxis.Interval)minorInterval, (double)major[j], (double)major[j + 1]) + 2;
                    }
                    this.minorTickValues[i] = new double[tickn];
                    int k = 0;
                    if (firstTick[i] < major[0]) {
                        v = firstTick[i];
                        while ((v = ZxAxis.zintnx2((ZxAxis.Interval)minorInterval, (double)v, (double)1.0)) > inMin && v < major[0]) {
                            this.minorTickValues[i][k] = v;
                            ++k;
                        }
                    }
                    for (int j = 0; j < major.length - 1; ++j) {
                        v = major[j];
                        while ((v = ZxAxis.zintnx2((ZxAxis.Interval)minorInterval, (double)v, (double)1.0)) < major[j + 1]) {
                            this.minorTickValues[i][k] = v;
                            ++k;
                        }
                    }
                    if (lastTick[i] > major[major.length - 1]) {
                        v = major[major.length - 1];
                        while ((v = ZxAxis.zintnx2((ZxAxis.Interval)minorInterval, (double)v, (double)1.0)) < inMax) {
                            this.minorTickValues[i][k] = v;
                            ++k;
                        }
                    }
                    if (k >= this.minorTickValues[i].length) continue;
                    double[] nv = new double[k];
                    for (int j = 0; j < k; ++j) {
                        nv[j] = this.minorTickValues[i][j];
                    }
                    this.minorTickValues[i] = nv;
                }
            } else {
                this.params.setMinorNum(0);
            }
        } else {
            int reqMinorNum;
            double inMax;
            double inMin;
            int i;
            double[] interval = new double[numRanges];
            for (i = 0; i < numRanges; ++i) {
                inMin = inputRanges[i].getMin();
                if (inMin > (inMax = inputRanges[i].getMax())) {
                    return;
                }
                if (inMin < MIN) {
                    MIN = inMin;
                }
                if (inMax > MAX) {
                    MAX = inMax;
                }
                if (this.ticks == null) {
                    double[] val = this.integerTicks ? ZxAxis.ziaxis((long)((long)Math.floor(inMin)), (long)((long)Math.ceil(inMax)), (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8) : ZxAxis.znaxis((double)inMin, (double)inMax, (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8);
                    interval[i] = val[1];
                    continue;
                }
                tickList[i] = new ArrayList();
                for (int t = 0; t < this.ticks.length; ++t) {
                    if (!(this.ticks[t] >= inMin) || !(this.ticks[t] <= inMax)) continue;
                    tickList[i].add(this.ticks[t]);
                }
            }
            this.tickValues = new double[numRanges][];
            if (this.ticks != null) {
                for (i = 0; i < numRanges; ++i) {
                    int n = tickList[i].size();
                    this.tickValues[i] = new double[n];
                    if (n <= 0) continue;
                    for (int t = 0; t < n; ++t) {
                        this.tickValues[i][t] = (Double)tickList[i].get(t);
                    }
                    firstTick[i] = this.tickValues[i][0];
                    lastTick[i] = this.tickValues[i][this.tickValues[i].length - 1];
                }
            } else {
                double maxInterval = interval[0];
                double minInterval = interval[0];
                for (int i3 = 1; i3 < interval.length; ++i3) {
                    if (interval[i3] == 0.0) continue;
                    if (interval[i3] < minInterval || minInterval == 0.0) {
                        minInterval = interval[i3];
                    }
                    if (!(interval[i3] > maxInterval) && maxInterval != 0.0) continue;
                    maxInterval = interval[i3];
                }
                int minIntvls = 2;
                double commonInterval = maxInterval;
                boolean tooBig = false;
                for (int i4 = 0; i4 < numRanges; ++i4) {
                    double ran;
                    if (interval[i4] == 0.0 || !((ran = inputRanges[i4].getMax() - inputRanges[i4].getMin()) / commonInterval < (double)minIntvls)) continue;
                    tooBig = true;
                    break;
                }
                if (tooBig) {
                    commonInterval = minInterval;
                }
                this.majorInterval = new TickInterval(commonInterval);
                double err = commonInterval * 1.0E-6;
                for (int i5 = 0; i5 < numRanges; ++i5) {
                    double tv;
                    double maxFac;
                    inMin = inputRanges[i5].getMin();
                    inMax = inputRanges[i5].getMax();
                    if (interval[i5] == 0.0) {
                        this.tickValues[i5] = new double[]{inMin};
                        firstTick[i5] = lastTick[i5] = this.tickValues[i5][0];
                        continue;
                    }
                    double minFac = Math.floor(inMin / commonInterval);
                    if (minFac == (maxFac = Math.ceil(inMax / commonInterval))) {
                        minFac -= 1.0;
                        maxFac += 1.0;
                    }
                    double low = minFac * commonInterval;
                    ArrayList<Double> tl = new ArrayList<Double>();
                    for (tv = low; tv <= inMin - err; tv += commonInterval) {
                    }
                    while (tv < inMax + err) {
                        tl.add(new Double(tv));
                        tv += commonInterval;
                    }
                    if (tl.size() > 100) {
                        this.tickValues[i5] = new double[2];
                        this.tickValues[i5][0] = (Double)tl.get(0);
                        this.tickValues[i5][1] = (Double)tl.get(tl.size() - 1);
                    } else {
                        this.tickValues[i5] = new double[tl.size()];
                        for (int j = 0; j < tl.size(); ++j) {
                            this.tickValues[i5][j] = (Double)tl.get(j);
                        }
                    }
                    this.tickValues[i5] = NumericFormat.processValues((double[])this.tickValues[i5], (double)commonInterval);
                    firstTick[i5] = this.tickValues[i5][0] <= inMin ? this.tickValues[i5][0] : this.tickValues[i5][0] - commonInterval;
                    lastTick[i5] = this.tickValues[i5][this.tickValues[i5].length - 1] >= inMax ? this.tickValues[i5][this.tickValues[i5].length - 1] : this.tickValues[i5][this.tickValues[i5].length - 1] + commonInterval;
                }
            }
            if (this.userReqMinorNum >= 0) {
                this.params.setMinorNum(this.userReqMinorNum);
            }
            if ((reqMinorNum = this.params.getMinorNum()) > 0) {
                this.minorTickValues = new double[numRanges][];
                for (int i6 = 0; i6 < numRanges; ++i6) {
                    int j;
                    double v;
                    inMin = inputRanges[i6].getMin();
                    inMax = inputRanges[i6].getMax();
                    int n = this.tickValues[i6].length;
                    if (n <= 1) {
                        this.minorTickValues[i6] = new double[0];
                        continue;
                    }
                    ArrayList<Double> belowFirst = null;
                    ArrayList<Double> aboveLast = null;
                    int numExtra = 0;
                    if (firstTick[i6] < this.tickValues[i6][0]) {
                        belowFirst = new ArrayList<Double>();
                        double itvl = (this.tickValues[i6][0] - firstTick[i6]) / (double)(reqMinorNum + 1);
                        v = this.tickValues[i6][0] - itvl;
                        while (v > inMin) {
                            belowFirst.add(v);
                            v -= itvl;
                            ++numExtra;
                        }
                    }
                    if (lastTick[i6] > this.tickValues[i6][this.tickValues[i6].length - 1]) {
                        aboveLast = new ArrayList<Double>();
                        double itvl = (lastTick[i6] - this.tickValues[i6][this.tickValues[i6].length - 1]) / (double)(reqMinorNum + 1);
                        v = this.tickValues[i6][this.tickValues[i6].length - 1] + itvl;
                        while (v < inMax) {
                            aboveLast.add(v);
                            v += itvl;
                            ++numExtra;
                        }
                    }
                    this.minorTickValues[i6] = new double[(n - 1) * reqMinorNum + numExtra];
                    int idx = 0;
                    if (belowFirst != null && belowFirst.size() > 0) {
                        for (int j2 = 0; j2 < belowFirst.size(); ++j2) {
                            this.minorTickValues[i6][idx++] = (Double)belowFirst.get(j2);
                        }
                    }
                    double v1 = this.tickValues[i6][0];
                    for (j = 1; j < n; ++j) {
                        double v2 = this.tickValues[i6][j];
                        double itvl = (v2 - v1) / (double)(reqMinorNum + 1);
                        for (int t = 1; t <= reqMinorNum; ++t) {
                            this.minorTickValues[i6][idx++] = v1 + (double)t * itvl;
                        }
                        v1 = v2;
                    }
                    if (aboveLast == null || aboveLast.size() <= 0) continue;
                    for (j = 0; j < aboveLast.size(); ++j) {
                        this.minorTickValues[i6][idx++] = (Double)aboveLast.get(j);
                    }
                }
            }
        }
        this.outputRange = new ContinuousRange(MIN, MAX);
        if (this.inputRange != null) {
            this.outputRange.setLabel(this.inputRange.getLabel());
            this.outputRange.setFormat(this.inputRange.getFormat());
        }
    }

    public void setEncoder(byte dimension, Encoder encoder, ContinuousRange[] inputRanges) {
        int lo;
        int ao;
        if (dimension != this.dimension || inputRanges == null) {
            return;
        }
        Encoder oldE = this.encoder;
        this.encoder = encoder;
        if (encoder == null) {
            return;
        }
        if (encoder.equals(oldE)) {
            return;
        }
        DataRange range = encoder.getInput();
        if (range == null) {
            return;
        }
        double length = 1.0;
        PositionEncoder pe = (PositionEncoder)encoder;
        length = pe.getOutputMax() - pe.getOutputMin();
        NumericMap map = (NumericMap)encoder.getValueMap();
        if (map == null || length == 0.0) {
            return;
        }
        if (this.vtkAxis == null) {
            if (dimension == 1) {
                this.vtkAxis = RectangularAxis.getXAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else if (dimension == 2) {
                this.vtkAxis = RectangularAxis.getYAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else if (dimension == 3) {
                this.vtkAxis = RectangularAxis.getZAxis((NumericMap)map, (double)length);
                this.networkRoot.addElement((Element)this.vtkAxis);
            } else {
                return;
            }
            this.vtkAxis.setSVGRender(StatGraph.VGF);
        }
        if (this.vtkAxis != null) {
            ao = 0;
            lo = 0;
            switch (dimension) {
                case 1: {
                    ao = 1;
                    lo = 2;
                    break;
                }
                case 2: {
                    ao = 2;
                    lo = 1;
                    break;
                }
                case 3: {
                    ao = 3;
                    lo = 2;
                }
            }
        } else {
            return;
        }
        this.vtkAxis.setOrientation(ao);
        this.vtkAxis.setLabelOrientation(lo);
        boolean hasMinorInRanges = true;
        boolean eFormat = false;
        boolean reformat = true;
        if (this.useDataFormat) {
            this.valueFormat = range.getFormat();
        }
        if (range instanceof ContinuousRange) {
            SASFormat sasFmt;
            GTKFormat mapfmt;
            ContinuousRange cr = (ContinuousRange)range;
            SASFormat fmt = cr.getFormat();
            if (this.valueFormat != null) {
                mapfmt = new GTKFormat((Format)this.valueFormat);
                reformat = false;
            } else if (fmt != null) {
                mapfmt = new GTKFormat((Format)fmt);
                if (this.isNamedFormat(fmt)) {
                    reformat = false;
                }
            } else {
                double r = Math.abs(cr.getMax() - cr.getMin());
                fmt = r != 0.0 && r < 1.0E-9 ? SASFormat.getInstance((String)"E8.") : DataModel.defaultFormat;
                mapfmt = new GTKFormat((Format)fmt);
            }
            map.setFormat(mapfmt);
            if (mapfmt != null && (sasFmt = (SASFormat)mapfmt.getFormats()[0]).getName().toUpperCase().charAt(0) == 'E' && (sasFmt.getName().length() == 1 || sasFmt.getName().length() >= 2 && Character.isDigit(sasFmt.getName().charAt(1)))) {
                eFormat = true;
            }
            if (reformat && this.getType() == 0) {
                reformat = this.isReformatPossible(this.tickValues);
            }
            if (this.getType() == 0) {
                this.setType(0);
                ContinuousRangeToNumericMap crtnm = (ContinuousRangeToNumericMap)map;
                crtnm.setZeroRangeOutput(2);
                ContinuousRangeToNumericMap[] outputMaps = ((BrokenPositionEncoder)encoder).getRangeOutputMaps();
                StringVector tickVal = new StringVector();
                NumericVector tickPos = new NumericVector();
                NumericVector minorTickPos = new NumericVector();
                int numRan = inputRanges.length;
                boolean showMinor = this.isMinorTicksOn() && this.params.getMinorNum() > 0 && this.isMajorTicksOn();
                for (int i = 0; i < numRan; ++i) {
                    int idx;
                    int n = idx = this.isReverse() ? numRan - 1 - i : i;
                    if (reformat) {
                        double min = this.tickValues[idx][0];
                        double max = this.tickValues[idx][this.tickValues[idx].length - 1];
                        double inc = this.tickValues[idx][1] - this.tickValues[idx][0];
                        Object[] gGoodLabels = this.getGGoodLabels(min, max, inc, this.tickValues[idx].length);
                        StringVector labels = (StringVector)gGoodLabels[0];
                        for (int j = 0; j < this.tickValues[idx].length; ++j) {
                            try {
                                tickVal.addValue(labels.getValue(j));
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                            tickPos.addValue(outputMaps[i].getValue(this.tickValues[idx][j]));
                        }
                    } else {
                        GTKFormat tickFmt = map.getFormat();
                        if (this.valueFormat == null && !this.isNamedFormat((SASFormat)tickFmt.getFormats()[0])) {
                            tickFmt = new GTKFormat((Format)DataModel.defaultFormat);
                        }
                        for (int j = 0; j < this.tickValues[idx].length; ++j) {
                            if (eFormat) {
                                tickVal.addValue(NumericFormat.getTrimmedValue((String)tickFmt.format((Object)new Double(this.tickValues[idx][j])).trim()));
                            } else {
                                tickVal.addValue(tickFmt.format((Object)new Double(this.tickValues[idx][j])).trim());
                            }
                            tickPos.addValue(outputMaps[i].getValue(this.tickValues[idx][j]));
                        }
                    }
                    if (!showMinor) continue;
                    for (int j = 0; j < this.minorTickValues[idx].length; ++j) {
                        minorTickPos.addValue(outputMaps[i].getValue(this.minorTickValues[idx][j]));
                    }
                }
                this.vtkAxis.labels.connectFrom((StringPipe)tickVal);
                this.vtkAxis.labelOffset.connectFrom((NumericPipe)tickPos);
                this.vtkAxis.setBrokenAxis(true);
                this.vtkAxis.setSegmentMaps(outputMaps);
                if (showMinor && minorTickPos.getValueCount() > 0) {
                    this.vtkAxis.minorTickOffset.connectFrom((NumericPipe)minorTickPos);
                } else {
                    hasMinorInRanges = false;
                }
            }
            if (this.getType() == 5 && fmt != null && fmt instanceof SASDateTimeFormat && this.ticks == null) {
                ContinuousTimeToNumericMap cttnm = (ContinuousTimeToNumericMap)map;
                if (this.valueFormat == null) {
                    mapfmt = new GTKFormat((Format)SASFormat.getInstance((String)this.theTimeFormatName));
                    if (!fmt.getName().equals(this.theTimeFormatName)) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "tgood.fmt.txt"));
                        this.issueSASNote(msg.toString((Object)fmt.getName()));
                    }
                }
                int numRan = inputRanges.length;
                ContinuousRangeToNumericMap[] outputMaps = ((BrokenPositionEncoder)encoder).getRangeOutputMaps();
                StringVector tickVal = new StringVector();
                StringVector tickVal2 = new StringVector();
                NumericVector tickPos = new NumericVector();
                NumericVector minorTickPos = new NumericVector();
                boolean showMinor = this.isMinorTicksOn() && this.params.getMinorNum() > 0 && this.isMajorTicksOn();
                boolean splitDateTime = dimension == 1 && this.params.isSplitTickValue() && this.valueFormat == null;
                for (int i = 0; i < numRan; ++i) {
                    int idx = this.isReverse() ? numRan - 1 - i : i;
                    ContinuousTimeToNumericMap timeMap = (ContinuousTimeToNumericMap)outputMaps[i];
                    timeMap.setFormat(mapfmt);
                    timeMap.setMajorTickValues(this.tickValues[idx]);
                    if (showMinor) {
                        timeMap.setMinorTickValues(this.minorTickValues[idx]);
                    }
                    if (splitDateTime) {
                        timeMap.setSplitDateTime(true);
                    }
                    timeMap.init(new AInitAction(null));
                    NumericPipe major = timeMap.uniqueValue;
                    NumericPipe minor = timeMap.uniqueMinorValue;
                    StringPipe label = timeMap.label;
                    StringPipe label2 = timeMap.secondaryLabel;
                    try {
                        int j;
                        for (j = 0; j < this.tickValues[idx].length; ++j) {
                            tickVal.addValue(label.getValue(j).trim());
                            tickPos.addValue(major.getValue(j));
                            try {
                                if (!timeMap.isSplitDateTime()) continue;
                                tickVal2.addValue(label2.getValue(j).trim());
                                continue;
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                        }
                        if (!showMinor) continue;
                        for (j = 0; j < this.minorTickValues[idx].length; ++j) {
                            minorTickPos.addValue(minor.getValue(j));
                        }
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                cttnm.setFormat(mapfmt);
                if (splitDateTime) {
                    cttnm.setSplitDateTime(true);
                    this.vtkAxis.getStyle().setSecondaryLabelsOn(this.vtkAxis.getStyle().isLabelsOn());
                    this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                }
                this.vtkAxis.labels.connectFrom((StringPipe)tickVal);
                this.vtkAxis.secondaryLabels.connectFrom((StringPipe)tickVal2);
                this.vtkAxis.labelOffset.connectFrom((NumericPipe)tickPos);
                this.vtkAxis.setBrokenAxis(true);
                this.vtkAxis.setSegmentMaps(outputMaps);
                if (showMinor && minorTickPos.getValueCount() > 0) {
                    this.vtkAxis.minorTickOffset.connectFrom((NumericPipe)minorTickPos);
                } else {
                    hasMinorInRanges = false;
                }
            }
        }
        if (!this.useTitle.equals("")) {
            if (this.labelFormat != null) {
                if (this.labelFormat.isCharacterFormat()) {
                    this.vtkAxis.title.setValue(this.labelFormat.format((Object)this.useTitle));
                } else {
                    this.vtkAxis.title.setValue(this.labelFormat.format((Object)new Double(this.useTitle)));
                }
            } else {
                this.vtkAxis.title.setValue(this.useTitle);
            }
        } else if (this.isDisplayStackedLabels() && this.stackedLabels != null && this.stackedLabels.length > 0) {
            this.vtkAxis.title.setValue(this.stackedLabels[0]);
            this.vtkAxis.setTitleList(this.stackedLabels);
        } else if (this.labelFormat != null) {
            if (this.labelFormat.isCharacterFormat()) {
                this.vtkAxis.title.setValue(this.labelFormat.format((Object)range.getLabel()));
            } else {
                this.vtkAxis.title.setValue(this.labelFormat.format((Object)new Double(range.getLabel())));
            }
        } else {
            this.vtkAxis.title.setValue(range.getLabel());
        }
        this.vtkAxis.setStyle(this.axisStyle);
        if (this.isMinorTicksOn() && this.params.getMinorNum() > 0 && this.isMajorTicksOn() && hasMinorInRanges) {
            this.axisStyle.setMinorTickMarksOn(true);
            this.axisStyle.getMinorTickStyle().setMinorTickCount(this.params.getMinorNum());
        } else {
            this.axisStyle.setMinorTickMarksOn(false);
            this.axisStyle.getMinorTickStyle().setMinorTickCount(0);
        }
        if (this.axisStyle.isMinorTickMarksOn()) {
            this.axisStyle.setShowThinnedTicks(true);
        } else {
            this.axisStyle.setShowThinnedTicks(false);
        }
        this.axisStyle.getMajorTickStyle().setLength(0.4);
        this.axisStyle.getMinorTickStyle().setLength(0.2);
        this.axisStyle.setHorizontalLabelSpace(0.25);
        this.axisStyle.setVerticalLabelSpace(0.25);
        double scale = 1.0;
        if (StatGraph.gapScaleFactor < 1.0) {
            scale = StatGraph.gapScaleFactor;
        }
        scale *= this.gapShrinkScale;
        switch (dimension) {
            case 1: {
                if (!this.reducedTitleSpace && (this.isMajorTickMarksOn() || this.axisStyle.isLabelsOn() || this.axisStyle.isMinorTickMarksOn())) {
                    this.axisStyle.setTitleSpace(0.5 * scale);
                } else {
                    this.axisStyle.setTitleSpace(0.1 * scale);
                }
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setVerticalJustification(0);
                        break;
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(3);
                    break;
                }
                if (this.labelPosition == 0) {
                    this.vtkAxis.setAutoAlignTitle(true);
                    this.axisStyle.setTitleEndSpace(this.axisStyle.getTitleSpace());
                    this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() * 0.5);
                    this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setVerticalJustification(3);
                        break;
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                if (this.labelPosition != 2) break;
                this.vtkAxis.setAutoAlignTitle(true);
                this.axisStyle.setTitleEndSpace(this.axisStyle.getTitleSpace());
                this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() * 0.5);
                this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setVerticalJustification(3);
                    break;
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(0);
                break;
            }
            case 2: {
                if (!this.reducedTitleSpace && (this.isMajorTickMarksOn() || this.axisStyle.isLabelsOn() || this.axisStyle.isMinorTickMarksOn())) {
                    this.axisStyle.setTitleSpace(1.0 * scale);
                } else {
                    this.axisStyle.setTitleSpace(0.2 * scale);
                }
                if (this.labelPosition == 1 || this.labelPosition == 3) {
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    } else {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(1);
                    if (!this.hotelText) break;
                    this.vtkAxis.setHotelText(true);
                    this.axisStyle.getTitleStyle().setAngle(0.0);
                    this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                    this.axisStyle.setTitleSpace(this.axisStyle.getTitleSpace() + 0.5 * scale);
                    break;
                }
                if (this.labelPosition == 0) {
                    this.vtkAxis.setAutoAlignTitle(true);
                    this.vtkAxis.getStyle().setTitleEndSpace(this.axisStyle.getTitleSpace() * 0.5);
                    this.axisStyle.getTitleStyle().setAngle(0.0);
                    if (this.primary) {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                    } else {
                        this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                    }
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                if (this.labelPosition != 2) break;
                this.vtkAxis.setAutoAlignTitle(true);
                this.vtkAxis.getStyle().setTitleEndSpace(this.axisStyle.getTitleSpace() * 0.5);
                this.axisStyle.getTitleStyle().setAngle(0.0);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(0);
                } else {
                    this.axisStyle.getTitleStyle().setHorizontalJustification(2);
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(3);
                break;
            }
            case 3: {
                this.axisStyle.setTitleSpace(1.0 * scale);
                this.axisStyle.getTitleStyle().setHorizontalJustification(1);
                if (this.primary) {
                    this.axisStyle.getTitleStyle().setVerticalJustification(0);
                    break;
                }
                this.axisStyle.getTitleStyle().setVerticalJustification(3);
                break;
            }
        }
        this.vtkAxis.labelColor.setValue(this.axisStyle.getLabelStyle().getColor());
        this.vtkAxis.setPrimary(this.primary);
        this.vtkAxis.setLineOffset(-this.startOffset);
        this.vtkAxis.setLength(this.startOffset + length + this.endOffset);
        this.vtkAxis.setDataLength(length);
        this.vtkAxis.setAxisLineOffsetCoverage(this.axisLineOffsetCoverage);
        this.vtkAxis.setCompressLowExtender(this.compressExtender && this.minOffsetBy != OFFSET_BY_TICKVALUES);
        this.vtkAxis.setCompressHighExtender(this.compressExtender && this.maxOffsetBy != OFFSET_BY_TICKVALUES);
        this.vtkAxis.setTitlePosition(this.labelPosition);
        this.vtkAxis.setTitleFitPolicy(this.titleFitPolicy);
        this.vtkAxis.setTitleSplitChar(this.titleSplitChar);
        this.vtkAxis.setTitleSplitCharDrop(this.titleSplitCharDrop);
        this.vtkAxis.setMultilineTitleJustification(this.multilineTitleJustification);
        this.vtkAxis.setTruncateStartCount(12);
        this.vtkAxis.setTruncateEndCount(0);
        this.vtkAxis.setTruncateAngleStartCount(20);
        this.vtkAxis.setTruncateAngleEndCount(0);
        if (dimension != 1) {
            this.honorFitStrategy = false;
            this.thinKeepEnd = false;
            if (this.tickLabeling != null && this.tickLabeling.equals("")) {
                this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
                this.yFit = new String[]{this.tickLabeling};
            } else {
                if (dimension == 2) {
                    this.yFit = new String[]{"thin"};
                }
                switch (this.getType()) {
                    case 0: {
                        if (this.tickLabeling != null && (this.tickLabeling.equals("thin_beginning_to_end") || this.tickLabeling.equals("thin_inside_to_outside") || this.tickLabeling.equals("thin_end_to_beginning"))) {
                            this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
                            if (dimension != 2) break;
                            this.yFit = new String[]{this.tickLabeling};
                            break;
                        }
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                        break;
                    }
                    case 5: {
                        this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
                    }
                }
            }
        } else if (this.tickLabeling != null) {
            if (this.tickLabeling.contains("angle") && !this.tickLabeling.startsWith("angle")) {
                int i = this.tickLabeling.indexOf("angle");
                String tickLabeling1 = this.tickLabeling.substring(0, i);
                String tickLabeling2 = this.tickLabeling.substring(i);
                this.vtkAxis.setFitAlgorithm(new String[]{tickLabeling1, tickLabeling2});
            } else {
                this.vtkAxis.setFitAlgorithm(new String[]{this.tickLabeling});
            }
            if (this.rotateAlways) {
                this.vtkAxis.setForceFitAlgorithm(this.tickLabeling);
            }
        } else {
            switch (this.getType()) {
                default: 
            }
            this.honorFitStrategy = false;
            this.thinKeepEnd = true;
            this.vtkAxis.setFitAlgorithm(new String[]{"thin"});
        }
        this.vtkAxis.setLabelMargin((int)Math.ceil(5.0 * StatGraph.getGapScaleFactor()));
        this.vtkAxis.setLabelAlignment(this.tickValueAlignment);
        this.vtkAxis.setPostFitProcessor((AAxis.PostFitProcessor)this);
    }

    public double[][] getTickValuesOnBrokenAxis() {
        return this.tickValues;
    }

    public double[][] getMinorTickValuesOnBrokenAxis() {
        return this.minorTickValues;
    }

    public static double getPrecisionDelta(double[] ticks) {
        if (ticks == null || ticks.length <= 1) {
            return 0.0;
        }
        double interval = Double.MAX_VALUE;
        for (int i = 0; i < ticks.length - 1; ++i) {
            interval = Math.min(interval, ticks[i + 1] - ticks[i]);
        }
        return 1.0E-6 * interval;
    }

    public int getBrokenAxisHash() {
        return this.brokenAxisHash;
    }

    public void setBrokenAxisHash(int brokenAxisHash) {
        this.brokenAxisHash = brokenAxisHash;
    }

    public void setSpaceForInnerMargin(int space) {
        this.spaceForInnerMargin = space;
    }

    public int getSpaceForInnerMargin() {
        return this.spaceForInnerMargin;
    }
}

