/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class WrapEditorKit
extends StyledEditorKit {
    ViewFactory defaultFactory = new WrapColumnFactory();

    WrapEditorKit() {
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    static class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }
}

