/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.WaterfallParmOverlay;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.SASDateTimeFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WaterFallParmParser {
    protected static final String SHOW_BAR_LABELS = "barLabel";
    protected static final String BAR_WIDTH_PERCENTAGE = "barWidth";
    protected static final String INITIAL_BAR_TICKVALUE = "initialBarTickValue";
    protected static final String INITIAL_BAR_VALUE = "initialBarValue";
    protected static final String FINAL_BAR_TICKVALUE = "finalBarTickValue";
    protected static final String BASELINE_INTERCEPT = "baselineIntercept";
    protected static final String DATA_TRANSPARENCY = "dataTransparency";
    protected static final String RESPONSE_STATISTIC = "stat";
    protected static final String RESPONSE_STATISTIC_SUM_STRING = "SUM";
    protected static final String RESPONSE_STATISTIC_MEAN_STING = "MEAN";
    protected static final String TRENDLINE_POLICY = "trendLineType";
    protected static final String TREND_TO_END_POLICY = "value";
    protected static final String TREND_TO_START_POLICY = "baseline";
    protected static final String BAR_COLOR_POLICY = "barColorPolicy";
    protected static final String STYLE_ELEMENT_BAR_INITIAL = "initialBarAttrs";
    protected static final String STYLE_ELEMENT_BAR_TRANSACTION = "fillAttrs";
    protected static final String STYLE_ELEMENT_BAR_FINAL = "finalBarAttrs";
    protected static final String STYLE_ELEMENT_BAR_LABEL = "barLabelAttrs";
    protected static final String STYLE_ELEMENT_DATA_LABEL = "dataLabelAttrs";
    protected static final String STYLE_ELEMENT_BAR_OUTLINE = "outlineAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE = "trendlineAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE_INCREASING = "trendlineIncreasingAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE_DECREASING = "trendlineDecreasingAttrs";
    protected static final String STYLE_ELEMENT_COLOR_MODEL = "colorModel";
    protected static final String DISPLAY = "display";
    protected static final String BAR_SKIN_TYPE = "skin";
    protected static final String CATEGORY_ROLE = "category";
    protected static final String RESPONSE_ROLE = "response";
    protected static final String DATALABEL_ROLE = "dataLabel";
    public static final String RB_KEY = "WaterfallParser.";

    public static WaterfallParmOverlay load(StatGraph graph, Element elem) {
        WaterfallParmOverlay plot = (WaterfallParmOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new WaterfallParmOverlay();
        }
        return WaterFallParmParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, WaterfallParmOverlay plot, Element element) {
        String attributeValue;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = WaterFallParmParser.setupDataModelAndRoles(plot, graph, element, map);
        if (m == null) {
            return false;
        }
        LayoutOverlayParser.parseGraphOpts(graph, element, plot);
        StatGraph.parseURLOpt(element, m, map, plot);
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (element.hasAttribute("primary")) {
            attributeValue = element.getAttribute("primary");
            plot.setPrimary(attributeValue.equalsIgnoreCase("true"));
        }
        if (!(attributeValue = element.getAttribute(BAR_COLOR_POLICY)).equalsIgnoreCase("")) {
            if ("Chart".equalsIgnoreCase(attributeValue)) {
                plot.setBarColorPolicy(1);
            } else if ("Discrete".equalsIgnoreCase(attributeValue)) {
                plot.setBarColorPolicy(2);
            } else if ("Continuous".equalsIgnoreCase(attributeValue)) {
                plot.setBarColorPolicy(3);
            } else if ("DiscreteGradient".equalsIgnoreCase(attributeValue)) {
                plot.setBarColorPolicy(4);
            } else if ("ContinuousGradient".equalsIgnoreCase(attributeValue)) {
                plot.setBarColorPolicy(5);
            }
        }
        Element barLabelStyleElement = null;
        Element dataLabelStyleElement = null;
        String elementTag = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elementTag = ((Element)node).getTagName();
            if (elementTag.equals("BarLabelAttrs")) {
                barLabelStyleElement = (Element)node;
                continue;
            }
            if (!elementTag.equals("DataLabelAttrs")) continue;
            dataLabelStyleElement = (Element)node;
        }
        FillAttrs initialBarFillAttrs = plot.getInitialBarFillAttrs();
        WaterFallParmParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_INITIAL, "InitialBarAttrs", contextName, initialBarFillAttrs);
        FillAttrs transactionBarFillAttrs = plot.getTransactionBarFillAttrs();
        WaterFallParmParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_TRANSACTION, "FillAttrs", contextName, transactionBarFillAttrs);
        FillAttrs finalBarFillAttrs = plot.getFinalBarFillAttrs();
        WaterFallParmParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_FINAL, "FinalBarAttrs", contextName, finalBarFillAttrs);
        LineAttrs barOutlineAttrs = plot.getBarOutlineAttrs();
        WaterFallParmParser.parseLineAttrs(graph, element, STYLE_ELEMENT_BAR_OUTLINE, "OutlineAttrs", "Outlines", barOutlineAttrs);
        LineAttrs trendlineAttrs = plot.getTrendlineAttrs();
        WaterFallParmParser.parseLineAttrs(graph, element, "trendLineAttrs", "TrendLineAttrs", "Outlines", trendlineAttrs);
        TextStyle barLabelStyle = plot.getBarLabelStyle();
        attributeValue = element.getAttribute(STYLE_ELEMENT_BAR_LABEL);
        GraphStyle.setDefaultTextStyle(graph, attributeValue, barLabelStyle, contextName);
        if (barLabelStyleElement != null) {
            StatGraph.parseTextAttrs(graph, barLabelStyleElement, barLabelStyle);
        }
        TextStyle dataLabelStyle = plot.getDataLabelStyle();
        attributeValue = element.getAttribute(STYLE_ELEMENT_DATA_LABEL);
        GraphStyle.setDefaultTextStyle(graph, attributeValue, dataLabelStyle, contextName);
        if (dataLabelStyleElement != null) {
            StatGraph.parseTextAttrs(graph, dataLabelStyleElement, dataLabelStyle);
        }
        if (!(attributeValue = element.getAttribute(BAR_WIDTH_PERCENTAGE)).equals("")) {
            plot.setBarThicknessAsPercentage(Double.parseDouble(attributeValue));
        }
        if (!(attributeValue = element.getAttribute(DATA_TRANSPARENCY)).equals("")) {
            double transparency = Double.parseDouble(attributeValue);
            plot.setInitialBarTransparency(transparency);
            plot.setTransactionBarTransparency(transparency);
            plot.setFinalBarTransparency(transparency);
        }
        if (!(attributeValue = element.getAttribute(SHOW_BAR_LABELS)).equals("")) {
            plot.setShowBarLabels(Boolean.parseBoolean(attributeValue));
        }
        if ((attributeValue = element.getAttribute(TRENDLINE_POLICY)).equalsIgnoreCase(TREND_TO_START_POLICY)) {
            plot.setTrendlineType(0);
        } else if (attributeValue.equalsIgnoreCase(TREND_TO_END_POLICY)) {
            plot.setTrendlineType(1);
        }
        attributeValue = element.getAttribute(INITIAL_BAR_VALUE);
        if (!attributeValue.equalsIgnoreCase("")) {
            plot.setInitialBarValue(Double.parseDouble(attributeValue));
        }
        if (!(attributeValue = element.getAttribute(INITIAL_BAR_TICKVALUE)).equalsIgnoreCase("")) {
            plot.setInitialBarTickmarkLabel(attributeValue);
        }
        if (!(attributeValue = element.getAttribute(FINAL_BAR_TICKVALUE)).equalsIgnoreCase("")) {
            plot.setFinalBarTickmarkLabel(attributeValue);
        }
        if (!(attributeValue = element.getAttribute(BASELINE_INTERCEPT)).equalsIgnoreCase("")) {
            plot.setBaselineIntercept(Double.parseDouble(attributeValue));
        }
        if (!(attributeValue = element.getAttribute(BAR_SKIN_TYPE)).equalsIgnoreCase("")) {
            if (attributeValue.equalsIgnoreCase("none")) {
                plot.setBarSkinType(0);
            } else if (attributeValue.equalsIgnoreCase("modern")) {
                plot.setBarSkinType(1);
            } else if (attributeValue.equalsIgnoreCase("satin")) {
                plot.setBarSkinType(2);
            }
        }
        if (!(attributeValue = element.getAttribute(DISPLAY)).equalsIgnoreCase("")) {
            plot.setDisplayMode(attributeValue);
        }
        LayoutOverlayParser.parseRoleTipStuff(element, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        attributeValue = element.getAttribute("dataSelectable");
        if (attributeValue.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        plot.setModel(crd);
        graph.style.recordCurrentCounters();
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(graph.style.getContextCount());
        }
        graph.style.resetToCurrentCounters();
        if (crd.isAvailable(2)) {
            switch (plot.getBarColorPolicy()) {
                case 2: 
                case 4: {
                    LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)4);
                    break;
                }
                case 3: 
                case 5: {
                    ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)4, graph, element, plot);
                    if (encoder == null) break;
                    plot.setEncoder((byte)4, encoder);
                }
            }
        }
        return true;
    }

    public static DataModel setupDataModelAndRoles(WaterfallParmOverlay plot, StatGraph graph, Element element, RoleColumnMap map) {
        String dataLabelVariableID;
        int dataLabelColumn;
        String tempString = element.getAttribute(CATEGORY_ROLE);
        String dataName = StatGraph.getDataName(tempString);
        String categoryVariableID = StatGraph.getVarID(tempString);
        tempString = element.getAttribute(RESPONSE_ROLE);
        String responseVariableID = StatGraph.getVarID(tempString);
        DataModel model = graph.getData(dataName);
        int categoryColumn = model.getColumn(categoryVariableID);
        int responseColumn = model.getColumn(responseVariableID);
        if (!StatGraph.checkVariable(CATEGORY_ROLE, model.getColumnLabel(categoryColumn), null, 1, true) || !StatGraph.checkVariable(RESPONSE_ROLE, model.getColumnLabel(responseColumn), Double.class, 1, true)) {
            return null;
        }
        map.map(1, categoryColumn);
        map.map(2, responseColumn);
        plot.addRole("CATEGORY", model.getColumnLabel(categoryColumn));
        plot.addRole("RESPONSE", model.getColumnLabel(responseColumn));
        if (element.hasAttribute(DATALABEL_ROLE) && StatGraph.checkVariable(DATALABEL_ROLE, model.getColumnLabel(dataLabelColumn = model.getColumn(dataLabelVariableID = StatGraph.getVarID(tempString = element.getAttribute(DATALABEL_ROLE)))), null, 1, false)) {
            map.map(5, dataLabelColumn);
            plot.addRole("DATALABEL", model.getColumnLabel(dataLabelColumn));
        }
        LayoutOverlayParser.parseRoleTipStuff(element, model, map, plot);
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        int[] types = new int[3];
        String attributeValue = elem.getAttribute(RESPONSE_ROLE);
        String dataName = StatGraph.getDataName(attributeValue);
        DataModel model = graph.getData(dataName);
        String responseVariableID = StatGraph.getVarID(attributeValue);
        if (responseVariableID.length() > 0) {
            int responseColumnIndex = model.getColumn(responseVariableID);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(responseColumnIndex);
            if (cmd.getType() == 2) {
                return null;
            }
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        } else {
            type = 0;
        }
        attributeValue = elem.getAttribute(CATEGORY_ROLE);
        String categoryVariableID = StatGraph.getVarID(attributeValue);
        if (model == null) {
            model = graph.getData(StatGraph.getDataName(attributeValue));
        }
        if (LayoutOverlayParser.hasTooManyCategories(graph, model, categoryVariableID)) {
            return null;
        }
        attributeValue = elem.getAttribute("orient");
        if (attributeValue.equalsIgnoreCase("Horizontal")) {
            types[0] = type;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }

    private static FillAttrs parseFillAttrs(StatGraph graph, Element elem, String attrName, String attrElemName, String defaultStyleElem, FillAttrs fa) {
        if (fa == null) {
            fa = new FillAttrs();
        }
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute(attrName), fa, defaultStyleElem);
        Element fe = StatGraph.getOptionAttrsElement(elem, attrElemName);
        if (fe != null) {
            StatGraph.parseFillAttrs(graph, fe, fa);
        }
        return fa;
    }

    private static LineAttrs parseLineAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        if (la == null) {
            la = new LineAttrs();
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        return la;
    }
}

