/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.regions.TileRegion;
import com.sas.graphics.common.attrmap.ContinuousRangeColorMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererModel;
import java.awt.Color;
import org.w3c.dom.Element;

public final class TileParser {
    public static TileRegion load(StatGraph graph, Element elem) {
        TileRegion tile = (TileRegion)graph.getObjectFromElement(elem);
        if (tile == null) {
            tile = new TileRegion();
        }
        return TileParser.load(graph, tile, elem) ? tile : null;
    }

    public static boolean load(StatGraph graph, TileRegion tile, Element elem) {
        Element outlineElem;
        boolean success;
        int clrcol;
        graph.addSupportedGraph();
        String dataName = null;
        DataModel m = null;
        RoleColumnMap map = new RoleColumnMap();
        Element tbElem = StatGraph.getOptionAttrsElement(elem, "TileBy");
        String[] tileByVars = StatGraph.parseStringValueList(tbElem, "Value");
        dataName = StatGraph.getDataName(tileByVars[0]);
        boolean olap = false;
        m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        } else {
            olap = true;
        }
        String[] tv = new String[tileByVars.length];
        for (int i = 0; i < tv.length; ++i) {
            tv[i] = StatGraph.getVarID(tileByVars[i]);
        }
        tile.setTileByVars(tv);
        String str = elem.getAttribute("size");
        if (str.length() > 0) {
            String sizeVarID = StatGraph.getVarID(str);
            if (olap) {
                map.map(7, sizeVarID);
                tile.setSizeVariable(sizeVarID);
            } else {
                int scol = m.getColumn(sizeVarID);
                if (StatGraph.checkVariable("SIZE", m.getColumnLabel(scol), Double.class, 1, false)) {
                    tile.setSizeVariable(sizeVarID);
                    tile.addRole("SIZE", m.getColumnLabel(scol));
                }
            }
        }
        if ((str = elem.getAttribute("colorResponse")).length() > 0) {
            String colorVarID = StatGraph.getVarID(str);
            if (olap) {
                tile.setColorResponseVariable(colorVarID);
                map.map(108, colorVarID);
            } else {
                clrcol = m.getColumn(colorVarID);
                if (StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(clrcol), Double.class, 1, false)) {
                    tile.setColorResponseVariable(colorVarID);
                    tile.addRole("COLORRESPONSE", m.getColumnLabel(clrcol));
                }
            }
        } else {
            str = elem.getAttribute("colorGroup");
            if (str.length() > 0) {
                String colorVarID = StatGraph.getVarID(str);
                if (olap) {
                    tile.setColorGroupVariable(colorVarID);
                    map.map(107, colorVarID);
                } else {
                    clrcol = m.getColumn(colorVarID);
                    tile.setColorGroupVariable(colorVarID);
                    tile.addRole("COLORGROUP", m.getColumnLabel(clrcol));
                }
            }
        }
        LayoutRegionParser.parseRoleTipStuff(elem, m, tile);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        tile.setCRD(crd);
        LayoutRegionParser.parseGraphOpts(graph, elem, tile);
        TileChartRendererModel model = tile.getTileModel();
        str = elem.getAttribute("arrangement");
        if (str.equalsIgnoreCase("STANDARD")) {
            model.setLayout(RendererUtil.TileChartLayout.LAYOUT_STANDARD);
        } else if (str.equalsIgnoreCase("TOGGLE")) {
            model.setLayout(RendererUtil.TileChartLayout.LAYOUT_TOGGLE);
        } else if (str.equalsIgnoreCase("FLOW")) {
            model.setLayout(RendererUtil.TileChartLayout.LAYOUT_FLOW);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("ARRANGEMENT", str);
        }
        model.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                model.setStatusLineVisible(true);
            } else {
                model.setStatusLineVisible(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("statustext")) {
                        model.setStatusLineVisible(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("none")) continue;
                    model.setStatusLineVisible(true);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (!((str = elem.getAttribute("colorStat")).equalsIgnoreCase("FREQ") || str.equalsIgnoreCase("PERCENT") || str.equalsIgnoreCase("SUM") || str.equalsIgnoreCase("MEAN") || str.equalsIgnoreCase("PCTSUM"))) {
            if (str.equalsIgnoreCase("MIN")) {
                model.setColorStat(10);
            } else if (str.equalsIgnoreCase("MAX")) {
                model.setColorStat(11);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("COLORSTAT", str);
            }
        }
        if (!((str = elem.getAttribute("sizeStat")).equalsIgnoreCase("FREQ") || str.equalsIgnoreCase("PERCENT") || str.equalsIgnoreCase("SUM") || str.equalsIgnoreCase("MEAN") || str.equalsIgnoreCase("PCTSUM"))) {
            if (str.equalsIgnoreCase("MIN")) {
                model.setSizeStat(10);
            } else if (str.equalsIgnoreCase("MAX")) {
                model.setSizeStat(11);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("SIZESTAT", str);
            }
        }
        if ((str = graph.style.getStyleAttribute("Skins", "dataSkin")) != null && str.length() > 0) {
            TileParser.applyDataSkin(model, str);
        }
        if ((str = elem.getAttribute("dataSkin")).length() > 0 && !(success = TileParser.applyDataSkin(model, str))) {
            StatGraph.printOptionError("DATASKIN", str);
        }
        tile.setDataModel(m);
        str = elem.getAttribute("dataLabelLevel");
        if (StatGraph.isNumber(str)) {
            int level = Integer.parseInt(str);
            if (level > 0 && level <= tileByVars.length) {
                model.setDataLabelLevel(level);
            } else {
                StatGraph.printOptionError("DATALABELLEVEL", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DATALABELLEVEL", str);
        }
        str = elem.getAttribute("detailLevel");
        if (StatGraph.isNumber(str)) {
            int level = Integer.parseInt(str);
            if (level > 0 && level <= tileByVars.length) {
                model.setDetailLevel(level);
            } else {
                StatGraph.printOptionError("DETAILLEVEL", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DETAILLEVEL", str);
        }
        FillAttrs fa = new FillAttrs();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("fillAttrs"), fa, "GraphDataStyleDefault");
        Element fillElem = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        boolean colorDefined = false;
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, fa);
            colorDefined = fillElem.hasAttribute("color");
        }
        tile.setMissingColor(graph.style.getGraphStyle().getFillStyleElement("Missing").getFillColor());
        str = elem.getAttribute("colorResponseAttrVar");
        boolean mapperSet = false;
        if (str.length() > 0 && graph.getRangeAttrVar(str) != null) {
            try {
                model.setColorMapper((ColorMapper)TileParser.createRangeMapper(graph, tile, str));
                mapperSet = true;
            }
            catch (RuntimeException e) {
                StatGraph.printWarning(e.getMessage());
            }
        }
        if (!mapperSet) {
            if (tile.getColorResponseVar() != null) {
                model.setColorMapper((ColorMapper)TileParser.createGTKColorMapper(elem, graph, tile, str, fa));
            } else if (tile.getColorGroupVar() != null) {
                model.setColorMapper((ColorMapper)TileParser.createStringToColorMapper(graph, tile, model, fa, colorDefined));
            } else {
                model.setFillAttrColor(TileParser.applyTransparency(fa));
            }
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), model.getDataLabelTextStyle(), "ValueText");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "DataLabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, model.getDataLabelTextStyle());
        }
        LineAttrs la = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), la, "Outlines");
        if (!elem.hasAttribute("outlineAttrs")) {
            la.setWidth(3);
        }
        if ((outlineElem = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs")) != null) {
            StatGraph.parseLineAttrs(graph, outlineElem, la);
        }
        LineStyle ls = new LineStyle();
        ls.setColor(la.getColor());
        ls.setSASLinePattern(la.getLinePattern());
        ls.setWidth(la.getWidth());
        model.setOutlineLineStyle(ls);
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("statusTextAttrs"), model.getStatusLineTextStyle(), "LabelText");
        Element statusElem = StatGraph.getOptionAttrsElement(elem, "StatusTextAttrs");
        if (statusElem != null) {
            StatGraph.parseTextAttrs(graph, statusElem, model.getStatusLineTextStyle());
        }
        if (graph.dataAntialiased) {
            tile.setAntialiased(graph.updateAAMax(m.getRowCount()));
        } else {
            tile.setAntialiased(false);
        }
        if (graph.imagemapEnabled && tile.isTooltipEnabled()) {
            tile.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        } else {
            tile.setTooltipEnabled(false);
        }
        tile.setSizeLegendItemFillColor(graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault").getFillColor());
        tile.setSizeLegendItemOutlineColor(graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault").getLineColor());
        return true;
    }

    private static Color applyTransparency(FillAttrs fa) {
        Color c = fa.getColor();
        double tr = fa.getTransparency();
        if (c == null || tr <= 0.0) {
            return c;
        }
        int a = (int)(255.0 * (1.0 - tr));
        Color nc = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        return nc;
    }

    private static final ContinuousRangeColorMapper createRangeMapper(StatGraph graph, TileRegion tile, String str) {
        RangeAttrMapper mapper = graph.getRangeAttrVar(str);
        if (mapper == null) {
            return null;
        }
        double[] range = tile.getMinMaxColorResponse();
        ContinuousRangeColorMapper crcm = new ContinuousRangeColorMapper(mapper, range[0], range[1]);
        Color missingColor = crcm.getValue(Double.NaN);
        tile.getTileModel().setMissingColor(missingColor);
        return crcm;
    }

    private static final ContinuousRangeToColorMapper createGTKColorMapper(Element elem, StatGraph graph, TileRegion tile, String str, FillAttrs fa) {
        Color[] colors;
        str = elem.getAttribute("colorModel");
        Color[] cl = graph.style.getRampColors(str, "ThreeColorRamp");
        Element cmElem = StatGraph.getOptionAttrsElement(elem, "ColorModel");
        if (cmElem != null && (colors = StatGraph.parseColorValueList(graph, cmElem, "Value")) != null && colors.length > 0) {
            cl = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
        }
        str = elem.getAttribute("reverseColorModel");
        boolean reverse = str.equalsIgnoreCase("true");
        Color[] rampColors = new Color[cl.length];
        for (int i = 0; i < cl.length; ++i) {
            int idx = reverse ? cl.length - 1 - i : i;
            rampColors[i] = tile.applyDataTransparency(cl[idx], fa);
        }
        ContinuousRangeToColorMapper colorMapper = new ContinuousRangeToColorMapper();
        double[] values = new double[]{0.0, 0.5, 1.0};
        colorMapper.setColorSpectrumColors(rampColors);
        colorMapper.setColorSpectrumValues(values);
        return colorMapper;
    }

    private static final StringToColorMapper createStringToColorMapper(StatGraph graph, TileRegion tile, TileChartRendererModel model, FillAttrs fa, boolean colorDefined) {
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        graph.style.setContextCount(contextCount);
        StringToColorMapper colorMapper = new StringToColorMapper();
        StringVectorVariable sv = (StringVectorVariable)model.getColorVariable();
        String[] gv = new String[sv.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                gv[i] = sv.uniqueValue.getValue(i);
                if (colorDefined) {
                    colorMapper.add(gv[i], tile.applyDataTransparency(fa.getColor(), fa));
                    continue;
                }
                colorMapper.add(gv[i], tile.applyDataTransparency(graph.style.getNextFillColor(), fa));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        colorMapper.input.connectFrom(sv.value);
        return colorMapper;
    }

    private static boolean applyDataSkin(TileChartRendererModel model, String str) {
        if (str.equalsIgnoreCase("crisp")) {
            model.setSkin(RendererUtil.Skin.CRISP);
        } else if (str.equalsIgnoreCase("gloss")) {
            model.setSkin(RendererUtil.Skin.GLOSS);
        } else if (str.equalsIgnoreCase("matte")) {
            model.setSkin(RendererUtil.Skin.MATTE);
        } else if (str.equalsIgnoreCase("pressed")) {
            model.setSkin(RendererUtil.Skin.PRESSED);
        } else if (str.equalsIgnoreCase("sheen")) {
            model.setSkin(RendererUtil.Skin.SHEEN);
        } else if (str.equalsIgnoreCase("none")) {
            model.setSkin(RendererUtil.Skin.NONE);
        } else {
            return false;
        }
        return true;
    }
}

