/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Insets;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TextPlotParser {
    public static final String RB_KEY = "TextPlotParser.";

    public static ScatterOverlay load(StatGraph graph, Element elem) {
        ScatterOverlay plot = (ScatterOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new ScatterOverlay(6);
        }
        return TextPlotParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, ScatterOverlay plot, Element elem) {
        int defaultPad;
        String rotVarID;
        int rotcol;
        String groupVarID;
        int srcol;
        String srVarID;
        int crcol;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = ScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        String str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (plot.getYAxis().equalsIgnoreCase("y2")) {
            plot.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            plot.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        Element textElem = null;
        Element fillElem = null;
        Element outlineElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("TextAttrs")) {
                textElem = (Element)node;
                continue;
            }
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("OutlineAttrs")) continue;
            outlineElem = (Element)node;
        }
        String textVarID = null;
        boolean groupedMarkerSymbol = false;
        str = elem.getAttribute("text");
        if (str.length() > 0) {
            textVarID = StatGraph.getVarID(str);
        }
        if (textVarID == null || textVarID.length() <= 0) {
            return false;
        }
        int textcol = m.getColumn(textVarID);
        map.map(5, textcol);
        plot.addRole("TEXT", m.getColumnLabel(textcol));
        plot.setDefaultMarkerShape((short)-1);
        plot.setLabelsAsMarkers(true);
        plot.setLabelVisible(true);
        plot.setLabelCollisionAvoidance(false);
        boolean gradientColor = false;
        boolean groupedColor = false;
        str = elem.getAttribute("colorResponse");
        String crVarID = StatGraph.getVarID(str);
        if (crVarID.length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
            gradientColor = true;
            map.map(45, crcol);
            map.map(69, crcol);
            plot.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                plot.addAttrVar("MARKERCOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
                plot.addAttrVar("TEXTFILLCOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
            }
            Color missingGradientColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
            plot.setMissingGradientColor(missingGradientColor);
        }
        if ((srVarID = StatGraph.getVarID(str = elem.getAttribute("sizeResponse"))).length() > 0 && StatGraph.checkVariable("SIZERESPONSE", m.getColumnLabel(srcol = m.getColumn(srVarID)), Double.class, 1, false)) {
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(srcol);
            if (cmd.getMax() > 0.0) {
                map.map(7, srcol);
                plot.addRole("SIZERESPONSE", m.getColumnLabel(srcol));
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "sizeresponse.txt"));
            }
        }
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID = StatGraph.getVarID(str = elem.getAttribute("group")), plot.getStmt())) {
            groupVarID = "";
        }
        if (groupVarID.length() > 0) {
            String indexVarID;
            int ii;
            int gcol = m.getColumn(groupVarID);
            map.map(3, gcol);
            if (!gradientColor) {
                map.map(45, gcol);
                map.map(69, gcol);
            }
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            str = elem.getAttribute("groupAttrVar");
            if (str.length() > 0) {
                DiscreteAttrMapper mapper = graph.getDiscreteAttrVar(str);
                if (mapper == null) {
                    mapper = graph.getRangeAttrVar(str);
                }
                plot.addAttrVar("GROUP", (AttrMapper)mapper);
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, plot, "GROUP", groupVarID);
            }
            str = elem.getAttribute("index");
            if (str.length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                if (map.isRoleMapped(45) && !gradientColor) {
                    map.map(41, ii);
                }
                plot.addRole("INDEX", m.getColumnLabel(ii));
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
            if ((str = elem.getAttribute("groupOrder")).length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else if (str.equalsIgnoreCase("ReverseData")) {
                    plot.setGroupOrder(3);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError("GROUPORDER", str);
                }
            } else if (graph.isCASData()) {
                plot.setGroupOrder(1);
            }
            if (graph.isCASData()) {
                plot.setDrawByGroupOrder(true);
            }
            if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
            str = elem.getAttribute("clusterAxis");
            if (str.equalsIgnoreCase("X")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_X);
            } else if (str.equalsIgnoreCase("Y")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_Y);
            } else {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_AUTO);
            }
        }
        plot.setGradientMarkerColor(gradientColor);
        if (!((Element)elem.getParentNode()).getNodeName().equalsIgnoreCase("LayoutPrototype") && (str = elem.getAttribute("outFile")).length() > 0) {
            plot.setDumpFile(str);
            str = elem.getAttribute("outID");
            String outIDVarID = StatGraph.getVarID(str);
            if (outIDVarID.length() > 0) {
                int idi = m.getColumn(outIDVarID);
                map.map(56, idi);
                plot.addRole("OUTID", m.getColumnLabel(idi));
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute("rotate"))) {
            plot.setLabelRotateAngle(Double.parseDouble(str));
        } else if (str.length() > 0 && StatGraph.checkVariable("ROTATE", m.getColumnLabel(rotcol = m.getColumn(rotVarID = StatGraph.getVarID(str))), Double.class, 1, false)) {
            map.map(118, rotcol);
            plot.addRole("ROTATE", m.getColumnLabel(rotcol));
        }
        str = elem.getAttribute("format");
        if (str.length() > 0) {
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt == null) {
                Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"FORMAT", (Object)str));
            } else {
                plot.setLabelFormat(fmt);
            }
        }
        StatGraph.parseURLOpt(elem, m, map, plot);
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        TextPlotParser.parseTextPlotLabelPosition(plot, elem, m, map);
        str = elem.getAttribute("outlinedText");
        if (str.equalsIgnoreCase("true")) {
            plot.setOutlinedMarkerCharacters(true);
        }
        if ((str = elem.getAttribute("splitPolicy")).equalsIgnoreCase("SPLIT")) {
            plot.setDataLabelSplit(true);
            plot.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_SPLIT);
        } else if (str.equalsIgnoreCase("SPLITALWAYS")) {
            plot.setDataLabelSplit(true);
            plot.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_SPLITALWAYS);
        } else if (str.equalsIgnoreCase("NONE")) {
            plot.setDataLabelSplit(false);
            plot.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_NONE);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("SPLITPOLICY", str);
        }
        ScatterParser.parseDataLabelSplitting(plot, elem);
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), plot.getMarkerCharacterStyle(), "DataText");
        if (textElem != null) {
            StatGraph.parseTextAttrs(graph, textElem, plot.getMarkerCharacterStyle());
        }
        plot.setUseLabelColor(StatGraph.isBundleAttributeFixed(elem, "textAttrs", "color"));
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                plot.setLabelBackgroundOn(true);
                plot.setLabelBackgroundEdgeOn(true);
            } else {
                plot.setLabelBackgroundOn(false);
                plot.setLabelBackgroundEdgeOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        plot.setLabelBackgroundEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        plot.setLabelBackgroundOn(true);
                        continue;
                    }
                    plot.setLabelBackgroundOn(false);
                    plot.setLabelBackgroundEdgeOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (gradientColor) {
            boolean userSetTextColor = StatGraph.isBundleAttributeFixed(elem, "textAttrs", "color");
            boolean userSetFillColor = StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color");
            boolean userSetOutineColor = StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color");
            if (userSetFillColor || !plot.isLabelBackgroundOn()) {
                map.unmapRole(69);
            } else if (!userSetTextColor) {
                map.unmapRole(69);
            } else {
                map.unmapRole(45);
            }
            if (!(map.isRoleMapped(69) || plot.isLabelBackgroundEdgeOn() && !userSetOutineColor)) {
                plot.setUseLabelColor(false);
            }
        }
        if (plot.isLabelBackgroundOn()) {
            FillAttrs bf = plot.getMarkerFillStyle();
            String fillAttr = elem.getAttribute("fillAttrs");
            GraphStyle.setDefaultFillStyle(graph, fillAttr, bf, contextName);
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, bf);
            }
            if (map.isRoleMapped(69) && StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color")) {
                map.unmapRole(69);
            }
            plot.setUseLabelBackgroundColor(StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color"));
            plot.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        } else if (map.isRoleMapped(69)) {
            map.unmapRole(69);
        }
        if (plot.isLabelBackgroundEdgeOn()) {
            LineAttrs be = plot.getMarkerOutlineStyle();
            String outlineAttr = elem.getAttribute("outlineAttrs");
            GraphStyle.setDefaultLineStyle(graph, outlineAttr, be, "Outlines");
            if (outlineElem != null) {
                StatGraph.parseLineAttrs(graph, outlineElem, be);
            }
            if (!gradientColor && map.isRoleMapped(45) && StatGraph.isBundleAttributeFixed(elem, "textAttrs", "color") && StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color")) {
                map.unmapRole(45);
            }
            if (map.isRoleMapped(45)) {
                plot.setUseLabelBackgroundEdgeColor(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color"));
            }
        } else if (!gradientColor && map.isRoleMapped(45) && StatGraph.isBundleAttributeFixed(elem, "textAttrs", "color")) {
            map.unmapRole(45);
        }
        FontMetrics fm = StatGraph.getFontMetrics(plot.getMarkerCharacterStyle().getFont());
        int top = defaultPad = fm.getHeight() / 4;
        int left = defaultPad;
        int bottom = defaultPad;
        int right = defaultPad;
        str = elem.getAttribute("pad");
        if (StatGraph.isLineThickness(str)) {
            left = top = graph.unit2GapThickness(str);
            bottom = top;
            right = top;
        } else {
            Element padAttrs = StatGraph.getOptionAttrsElement(elem, "PadAttrs");
            if (padAttrs != null) {
                str = padAttrs.getAttribute("top");
                if (StatGraph.isLineThickness(str)) {
                    top = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("left"))) {
                    left = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("bottom"))) {
                    bottom = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("right"))) {
                    right = graph.unit2GapThickness(str);
                }
            }
        }
        plot.setLabelBackgroundPad(new Insets(top, left, bottom, right));
        if (map.isRoleMapped(7)) {
            String an;
            String en;
            TextAttrs ta = new TextAttrs();
            GraphStyle.setDefaultTextStyle(graph, "", ta, "DataText");
            int minFont = ta.getFont().getSize();
            int maxFont = 3 * minFont;
            str = elem.getAttribute("sizeMin");
            if (StatGraph.isNumber(str)) {
                minFont = graph.unit2FontSize(str);
            } else if (str.indexOf(":") >= 0) {
                en = GraphStyle.parseStyleElementName(str);
                an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    minFont = graph.unit2FontSize(graph.style.getStyleAttribute(en, an));
                }
            }
            str = elem.getAttribute("sizeMax");
            if (StatGraph.isNumber(str)) {
                maxFont = graph.unit2FontSize(str);
            } else if (str.indexOf(":") >= 0) {
                en = GraphStyle.parseStyleElementName(str);
                an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    maxFont = graph.unit2FontSize(graph.style.getStyleAttribute(en, an));
                }
            }
            if (minFont > maxFont) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "sizeminmax.txt"));
                minFont = ta.getFont().getSize();
                maxFont = 3 * minFont;
            }
            plot.setMinFontSize(minFont);
            plot.setMaxFontSize(maxFont);
            str = elem.getAttribute("sizeMaxResponse");
            if (StatGraph.isNumber(str) && Double.parseDouble(str) > 0.0) {
                plot.setSizeMaxResponse(Double.parseDouble(str));
            }
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        str = elem.getAttribute("discreteOffset");
        if (str.length() > 0 && !ScatterParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        if (plot.isTooltipEnabled()) {
            plot.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        plot.setModel(crd);
        str = elem.getAttribute("strip");
        if (str.equalsIgnoreCase("true")) {
            plot.setStripMarkerCharacter(true);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("backlight"))) {
            double d = Double.parseDouble(str);
            if (d >= 0.0 && d <= 1.0) {
                plot.setTextBacklight(d);
            }
        } else if (str.equalsIgnoreCase("auto")) {
            if (!plot.isUseLabelColor() && (crd.isAvailable(3) || gradientColor)) {
                plot.setTextBacklight(0.75);
            } else {
                plot.setTextBacklight(0.5);
            }
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(45)) {
            if (gradientColor) {
                ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)16, graph, elem, plot);
                if (encoder != null) {
                    plot.setEncoder((byte)16, encoder);
                }
            } else {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)16, !groupedColor);
            }
        }
        if (crd.isAvailable(69)) {
            if (gradientColor) {
                ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)24, graph, elem, plot, plot.getMarkerFillStyle().getTransparency());
                if (encoder != null) {
                    plot.setEncoder((byte)24, encoder);
                }
            } else {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)24, plot.getMarkerFillStyle().getTransparency(), !groupedColor);
            }
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    protected static void parseTextPlotLabelPosition(ScatterOverlay plot, Element elem, DataModel m, RoleColumnMap map) {
        boolean baselineCenter = false;
        String str = elem.getAttribute("vCenter");
        if (!str.equalsIgnoreCase("BBOX")) {
            if (str.equalsIgnoreCase("BASELINE")) {
                baselineCenter = true;
            } else if (str.length() > 0) {
                StatGraph.printOptionError("VCENTER", str);
            }
        }
        plot.setTextBaselineCenter(baselineCenter);
        int pos = baselineCenter ? 10 : 4;
        str = elem.getAttribute("position");
        int type = StatGraph.getAttributeType(elem, "position");
        if (str.length() > 0 && type == 0) {
            String posVarID = StatGraph.getVarID(str);
            int poscol = m.getColumn(posVarID);
            if (StatGraph.checkVariable("POSITION", m.getColumnLabel(poscol), String.class, 1, false)) {
                map.map(123, poscol);
                plot.addRole("POSITION", m.getColumnLabel(poscol));
            }
        } else {
            plot.setFixedDataLabelPosition(ScatterOverlay.getTextPosition(str, baselineCenter));
        }
        str = elem.getAttribute("positionOffsetX");
        type = StatGraph.getAttributeType(elem, "positionOffsetX");
        if (str.length() > 0 && type == 0) {
            String posOffXVarID = StatGraph.getVarID(str);
            int posxcol = m.getColumn(posOffXVarID);
            if (StatGraph.checkVariable("POSITIONOFFSETX", m.getColumnLabel(posxcol), Double.class, 1, false)) {
                map.map(37, posxcol);
                plot.addRole("POSITIONOFFSETX", m.getColumnLabel(posxcol));
            }
        } else if (StatGraph.isNumber(str)) {
            plot.setTextPositionOffsetX(Double.parseDouble(str));
        }
        str = elem.getAttribute("positionOffsetY");
        type = StatGraph.getAttributeType(elem, "positionOffsetY");
        if (str.length() > 0 && type == 0) {
            String posOffYVarID = StatGraph.getVarID(str);
            int posycol = m.getColumn(posOffYVarID);
            if (StatGraph.checkVariable("POSITIONOFFSETY", m.getColumnLabel(posycol), Double.class, 1, false)) {
                map.map(38, posycol);
                plot.addRole("POSITIONOFFSETY", m.getColumnLabel(posycol));
            }
        } else if (StatGraph.isNumber(str)) {
            plot.setTextPositionOffsetY(Double.parseDouble(str));
        }
    }
}

