/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class StepParser {
    public static final String RB_KEY = "StepParser.";

    public static ScatterOverlay load(StatGraph graph, Element elem, int autoCurveLabelPosition) {
        ScatterOverlay plot = (ScatterOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new ScatterOverlay(3);
        }
        return StepParser.load(graph, plot, elem, autoCurveLabelPosition) ? plot : null;
    }

    public static boolean load(StatGraph graph, ScatterOverlay plot, Element elem, int autoCurveLabelPosition) {
        int maxVertices;
        String indexVarID;
        int ii;
        String groupVarID;
        String varID;
        int col;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = ScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        String str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        str = elem.getAttribute("lineThicknessResponse");
        String thicknessVarID = StatGraph.getVarID(str);
        if (thicknessVarID.length() > 0 && StatGraph.checkVariable("LINETHICKNESSRESPONSE", m.getColumnLabel(col = m.getColumn(thicknessVarID)), Double.class, 1, false)) {
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(col);
            if (cmd.getMax() > 0.0) {
                double d;
                map.map(119, col);
                plot.addRole("THICKNESS", m.getColumnLabel(col));
                LineAttrs la = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, "", la, "GraphDataStyleDefault");
                double minThickness = la.getWidth();
                double maxThickness = 10.0 * minThickness;
                str = elem.getAttribute("lineThicknessMaxResponse");
                if (StatGraph.isNumber(str)) {
                    plot.setThicknessMaxResponse(Double.parseDouble(str));
                }
                if (StatGraph.isNumber(str = elem.getAttribute("lineThicknessMax")) && (d = (double)graph.unit2LineThickness(str)) >= 0.0) {
                    maxThickness = d;
                }
                if (StatGraph.isNumber(str = elem.getAttribute("lineThicknessMin")) && (d = (double)graph.unit2LineThickness(str)) >= 0.0) {
                    minThickness = d;
                }
                if (minThickness > maxThickness) {
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "thicknessminmax.txt"));
                    minThickness = la.getWidth();
                    maxThickness = 10.0 * minThickness;
                }
                plot.setMaxThickness(maxThickness);
                plot.setMinThickness(minThickness);
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "thicknessresponse.txt"));
            }
        }
        if ((str = elem.getAttribute("arrowHeadShape")).length() > 0) {
            String str2 = elem.getAttribute("arrowHeadShape_type");
            if (str2.equalsIgnoreCase("VARIABLE") && StatGraph.isValidVar(str)) {
                varID = StatGraph.getVarID(str);
                int col2 = m.getColumn(varID);
                map.map(120, col2);
                plot.addRole("ARROWSHAPE", m.getColumnLabel(col2));
            } else if (str2.equalsIgnoreCase("KEYWORD")) {
                plot.setArrowHeadShape(str);
            }
        }
        if ((str = elem.getAttribute("arrowHeadPosition")).length() > 0) {
            String str2 = elem.getAttribute("arrowHeadPosition_type");
            if (str2.equalsIgnoreCase("VARIABLE") && StatGraph.isValidVar(str)) {
                varID = StatGraph.getVarID(str);
                int col3 = m.getColumn(varID);
                map.map(122, col3);
                plot.addRole("ARROWPOSITION", m.getColumnLabel(col3));
            } else if (str2.equalsIgnoreCase("KEYWORD")) {
                plot.setArrowHeadPosition(str);
            }
        }
        if ((str = elem.getAttribute("arrowHeadScale")).length() > 0) {
            double d;
            String str2 = elem.getAttribute("arrowHeadScale_type");
            if (str2.equalsIgnoreCase("VARIABLE") && StatGraph.isValidVar(str)) {
                varID = StatGraph.getVarID(str);
                int col4 = m.getColumn(varID);
                if (StatGraph.checkVariable("ARROWHEADSCALE", m.getColumnLabel(col4), Double.class, 0, false, 1, false)) {
                    map.map(121, col4);
                    plot.addRole("ARROWSCALE", m.getColumnLabel(col4));
                }
            } else if (str2.equalsIgnoreCase("NUMERIC") && StatGraph.isNumber(str) && (d = Double.parseDouble(str)) >= 0.0) {
                plot.setArrowHeadScale(d);
            }
        }
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID = StatGraph.getVarID(str = elem.getAttribute("group")), plot.getStmt())) {
            groupVarID = "";
        }
        Element labelElem = null;
        Element curveLabelElem = null;
        Element lineElem = null;
        Element markerElem = null;
        Element errorElem = null;
        Element markerFillElem = null;
        Element markerOutlineElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("CurveLabelAttrs")) {
                curveLabelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("ErrorBarAttrs")) {
                errorElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs")) {
                markerFillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs")) continue;
            markerOutlineElem = (Element)node;
        }
        String lineAttr = elem.getAttribute("lineAttrs");
        String mrkAttr = elem.getAttribute("markerAttrs");
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("size")) {
            plot.setUseMarkerSize(true);
        }
        if (markerElem != null && markerElem.hasAttribute("weight")) {
            plot.setUseMarkerWeight(true);
        }
        if (!map.isRoleMapped(119) && (lineAttr.length() > 0 || lineElem != null && lineElem.hasAttribute("thickness"))) {
            plot.setUseLineThickness(true);
        } else {
            plot.setUseLineThickness(false);
        }
        plot.setUseMarkerTransparency(StatGraph.isTransparencyFixed(elem, markerElem));
        boolean hasMarkers = StatGraph.parseDisplayMarkers(elem);
        boolean filledOutlinedMarker = false;
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true")) {
            plot.setFilledOutlinedMarker(true);
            filledOutlinedMarker = true;
            if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("color")) {
                plot.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("color")) {
                plot.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("thickness")) {
                plot.setUseMarkerOutlineAttrsThickness(true);
            }
        }
        if (groupVarID.length() > 0) {
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            if (!(lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                map.map(46, gcol);
                groupMapped = true;
            }
            if (!(lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                map.map(36, gcol);
                groupMapped = true;
            }
            if (hasMarkers) {
                groupMapped = StatGraph.mapMarkerRoles(graph, elem, map, markerElem, mrkAttr, gcol, groupMapped, m, plot);
                if (filledOutlinedMarker) {
                    if (!map.isRoleMapped(45) && map.isRoleMapped(46)) {
                        map.map(45, gcol);
                    }
                    if (!(map.isRoleMapped(69) || mrkFillAttr.length() != 0 || markerFillElem != null && markerFillElem.hasAttribute("color"))) {
                        map.map(69, gcol);
                    }
                }
            }
            map.map(3, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            if (groupMapped) {
                str = elem.getAttribute("groupAttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, plot, "GROUP", groupVarID);
                }
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            if (map.isRoleMapped(46) || map.isRoleMapped(45)) {
                map.map(41, ii);
            }
            if (map.isRoleMapped(36)) {
                map.map(43, ii);
            }
            if (map.isRoleMapped(8)) {
                map.map(42, ii);
            }
            plot.addRole("INDEX", m.getColumnLabel(ii));
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else if (str.equalsIgnoreCase("ReverseData")) {
                    plot.setGroupOrder(3);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError("GROUPORDER", str);
                }
            } else if (graph.isCASData()) {
                plot.setGroupOrder(1);
            }
            if (graph.isCASData()) {
                plot.setDrawByGroupOrder(true);
            }
            if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
            str = elem.getAttribute("clusterAxis");
            if (str.equalsIgnoreCase("X")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_X);
            } else if (str.equalsIgnoreCase("Y")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_Y);
            } else {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_AUTO);
            }
        }
        StatGraph.parseURLOpt(elem, m, map, plot);
        str = elem.getAttribute("dataLabel");
        String labelVarID = StatGraph.getVarID(str);
        boolean labelVisible = false;
        boolean labelingEnabled = false;
        if (labelVarID.length() > 0) {
            int lcol = m.getColumn(labelVarID);
            map.map(5, lcol);
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
            int nms = cmd.getNobs() - cmd.getMissings();
            if (nms == 0) {
                labelVisible = false;
                labelingEnabled = false;
            } else {
                Message msg;
                labelVisible = true;
                boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                if (!labelingEnabled) {
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(nms))), false);
                } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                    labelingEnabled = false;
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(cmd.getNobs()))), false);
                }
            }
            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        if ((str = elem.getAttribute("curveLabel")).length() > 0) {
            Message msg;
            int clcol;
            String curveLabelVarID;
            int type = StatGraph.getAttributeType(elem, "curveLabel");
            if (type < 0) {
                if (StatGraph.getDataName(str).length() > 0) {
                    curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        if (groupVarID.length() > 0) {
                            clcol = m.getColumn(curveLabelVarID);
                            map.map(48, clcol);
                            plot.addRole("CURVELABEL", m.getColumnLabel(clcol));
                        } else {
                            Message msg2 = new Message(RB.getStringResource(RB_KEY, "label1.fmt.txt"));
                            StatGraph.printNote(msg2.toString((Object)curveLabelVarID));
                        }
                    }
                } else if (groupVarID.length() > 0) {
                    msg = new Message(RB.getStringResource(RB_KEY, "label2.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                } else {
                    plot.setCurveLabelString(str);
                }
            } else if (type == 0) {
                curveLabelVarID = StatGraph.getVarID(str);
                if (m.hasColumn(curveLabelVarID)) {
                    if (groupVarID.length() > 0) {
                        clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        plot.addRole("CURVELABEL", m.getColumnLabel(clcol));
                    } else {
                        Message msg3 = new Message(RB.getStringResource(RB_KEY, "label1.fmt.txt"));
                        StatGraph.printNote(msg3.toString((Object)curveLabelVarID));
                    }
                }
            } else if (groupVarID.length() > 0) {
                msg = new Message(RB.getStringResource(RB_KEY, "label2.fmt.txt"));
                String val = type == 2 ? str : "'" + str + "'";
                StatGraph.printNote(msg.toString((Object)val));
            } else {
                plot.setCurveLabelString(str);
            }
        }
        ScatterParser.parseCurveLabelSplitting(graph, plot, elem);
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        str = elem.getAttribute("sortRole");
        if (str.length() > 0 && str.equalsIgnoreCase("x")) {
            crd.setSortRole(10);
        }
        if ((str = elem.getAttribute("dataSelectable")).length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        StatGraph.parseDataSkinOpt(graph, elem, plot);
        if (plot.isTooltipEnabled()) {
            plot.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        plot.setModel(crd);
        if (!plot.isDataValid()) {
            graph.removeNamedGraph(plot);
            StatGraph.printWarning(RB.getStringResource("SeriesParser.", "zerothickness.txt"));
            return false;
        }
        str = elem.getAttribute("connectOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("xAxis")) {
                plot.setConnectOrder(1);
            } else if (str.equalsIgnoreCase("xValues")) {
                plot.setConnectOrder(0);
            } else {
                StatGraph.printOptionError("CONNECTORDER", str);
            }
        } else if (graph.isCASData()) {
            plot.setConnectOrder(1);
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (hasMarkers) {
            MarkerAttrs ms = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle(graph, mrkAttr, ms, contextName);
            if (markerElem != null) {
                StatGraph.parseMarkerAttrs(graph, markerElem, ms);
            }
            plot.setDefaultMarkerColor(ms.getColor());
            plot.setMarkerTransparency(ms.getTransparency());
            plot.setDefaultMarkerShape((short)ms.getShape());
            plot.setMinMarkerSize(ms.getSize());
            plot.setMaxMarkerSize(ms.getSize());
            plot.setDefaultMarkerScale(0.0);
            if (filledOutlinedMarker) {
                mrkFillAttr = elem.getAttribute("markerFillAttrs");
                GraphStyle.setDefaultFillStyle(graph, mrkFillAttr, plot.getMarkerFillStyle(), contextName);
                if (markerFillElem != null) {
                    StatGraph.parseFillAttrs(graph, markerFillElem, plot.getMarkerFillStyle());
                }
                mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
                GraphStyle.setDefaultLineStyle(graph, mrkOutlineAttr, plot.getMarkerOutlineStyle(), "Outlines");
                if (markerOutlineElem != null) {
                    StatGraph.parseLineAttrs(graph, markerOutlineElem, plot.getMarkerOutlineStyle());
                }
            }
        } else {
            plot.setDefaultMarkerShape((short)-1);
        }
        GraphStyle.setDefaultDataLineStyle(graph, lineAttr, plot.getLineStyle(), contextName);
        if (lineElem != null) {
            StatGraph.parseLineAttrs(graph, lineElem, plot.getLineStyle());
        }
        if (groupVarID.length() > 0 && StatGraph.isBundleAttributeFixed(elem, "lineAttrs", "color") && !StatGraph.isBundleAttributeFixed(elem, "markerAttrs", "color")) {
            plot.setDefaultMarkerColor(plot.getLineStyle().getColor());
        }
        if ((str = elem.getAttribute("break")).equalsIgnoreCase("true")) {
            plot.setSkipMiss(true);
        }
        if ((str = elem.getAttribute("join")).equalsIgnoreCase("false")) {
            if (plot.isCurveLabeled()) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "join.txt"));
                plot.setStepJoinVisible(true);
            } else {
                plot.setStepJoinVisible(false);
            }
        } else {
            plot.setStepJoinVisible(true);
        }
        str = elem.getAttribute("justify");
        if (str.equalsIgnoreCase("left")) {
            plot.setStepPlacement((byte)0);
        } else if (str.equalsIgnoreCase("center")) {
            plot.setStepPlacement((byte)2);
        } else if (str.equalsIgnoreCase("right")) {
            plot.setStepPlacement((byte)1);
        } else {
            plot.setStepPlacement((byte)0);
            if (str.length() > 0) {
                StatGraph.printOptionError("JUSTIFY", str);
            }
        }
        plot.setJoinVisible(true);
        plot.setJoinType((byte)2);
        if (labelVisible) {
            int position = ScatterParser.parseDataLabelPosition(elem);
            if (position != -1) {
                labelingEnabled = false;
                plot.setFixedDataLabelPosition(position);
                ScatterParser.parseDataLabelSplitting(plot, elem);
            }
            plot.setLabelVisible(true);
            plot.setLabelCollisionAvoidance(labelingEnabled);
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), plot.getLabelStyle(), "DataText");
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(plot.getLineStyle().getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs(graph, labelElem, plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if (graph.isSALabeling()) {
            plot.setProtectedStep(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        } else {
            plot.setProtectedStep(labelVisible);
        }
        str = elem.getAttribute("discreteOffset");
        if (str.length() > 0 && !StepParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        str = elem.getAttribute("errorBarCapShape");
        if (str.equalsIgnoreCase("none")) {
            plot.setErrorCapVisible(false);
        } else if (str.equalsIgnoreCase("serif")) {
            plot.setErrorCapVisible(true);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("errorBarCapeShape", str);
        } else {
            str = graph.style.getStyleAttribute("Error", "capStyle");
            if (str != null && str.length() > 0) {
                if (str.equalsIgnoreCase("none")) {
                    plot.setErrorCapVisible(false);
                } else if (str.equalsIgnoreCase("serif")) {
                    plot.setErrorCapVisible(true);
                }
            }
        }
        str = elem.getAttribute("errorBarCapScale");
        if (StatGraph.isNumber(str)) {
            plot.setCapScale(Double.parseDouble(str));
        }
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("errorBarAttrs"), plot.getErrorBarStyle(), "Error");
        int useErrorBarStyle = plot.getUseErrorBarStyle();
        if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "errorBarAttrs", "color")) {
            useErrorBarStyle |= 1;
        }
        if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "errorBarAttrs", "pattern")) {
            useErrorBarStyle |= 2;
        }
        if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "errorBarAttrs", "thickness")) {
            useErrorBarStyle |= 4;
        }
        plot.setUseErrorBarStyle(useErrorBarStyle);
        if (graph.style.isCycleAttrs()) {
            plot.getErrorBarStyle().setColor(plot.getLineStyle().getColor());
            plot.getErrorBarStyle().setLinePattern(plot.getLineStyle().getLinePattern());
            plot.getErrorBarStyle().setWidth(plot.getLineStyle().getWidth());
        }
        if (errorElem != null) {
            StatGraph.parseLineAttrs(graph, errorElem, plot.getErrorBarStyle());
        }
        if ((str = elem.getAttribute("curveLabelLocation")).equalsIgnoreCase("INSIDE")) {
            plot.setCurveLabelLocation(0);
        } else if (str.equalsIgnoreCase("OUTSIDE")) {
            if (BandParser.isUnderLatticeLayout(elem)) {
                plot.setCurveLabelLocation(0);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "outsidelabel.txt"));
            } else {
                plot.setCurveLabelLocation(1);
            }
        } else {
            plot.setCurveLabelLocation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("CURVELABELLOCATION", str);
            }
        }
        str = elem.getAttribute("curveLabelPosition");
        if (str.equalsIgnoreCase("MIN")) {
            plot.setCurveLabelPosition(0);
        } else if (str.equalsIgnoreCase("MAX")) {
            plot.setCurveLabelPosition(1);
        } else if (str.equalsIgnoreCase("START") && plot.getCurveLabelLocation() == 0) {
            plot.setCurveLabelPosition(2);
        } else if (str.equalsIgnoreCase("END") && plot.getCurveLabelLocation() == 0) {
            plot.setCurveLabelPosition(3);
        } else if (str.equalsIgnoreCase("AUTO") && plot.getCurveLabelLocation() == 1) {
            plot.setCurveLabelPosition(autoCurveLabelPosition);
        } else {
            if (plot.getCurveLabelLocation() == 1) {
                plot.setCurveLabelPosition(autoCurveLabelPosition);
            } else {
                plot.setCurveLabelPosition(3);
            }
            if (str.length() > 0) {
                StatGraph.printOptionError("CURVELABELPOSITION", str);
            }
        }
        if (plot.isCurveLabeled()) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("curveLabelAttrs"), plot.getCurveLabelStyle(), "ValueText");
            if (graph.style.isCycleAttrs()) {
                plot.getCurveLabelStyle().setColor(plot.getLineStyle().getColor());
            }
            if (curveLabelElem != null) {
                StatGraph.parseTextAttrs(graph, curveLabelElem, plot.getCurveLabelStyle());
            }
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "curveLabelAttrs", "color")) {
                plot.setUseCurveLabelColor(true);
            }
        }
        ScatterParser.parseSelectionColor(plot, graph);
        ScatterParser.parseLabelVisibles(plot, elem);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.contrastColorCnt;
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)17);
        }
        if (crd.isAvailable(45)) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.contrastColorCnt = startContrastColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)16, plot.getMarkerTransparency());
        }
        if (crd.isAvailable(69)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)24, plot.getMarkerTransparency());
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)6);
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (crd.isAvailable(26)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)7);
        }
        if (crd.isAvailable(27)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)8);
        }
        if (crd.isAvailable(28)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)9);
        }
        if (crd.isAvailable(29)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)10);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        if (!StatGraph.suppressWarningMsg && (maxVertices = plot.getMaxVerticesPerGroup(graph.linePatternOBSMax)) > graph.linePatternOBSMax) {
            graph.removeNamedGraph(plot);
            Message msg = new Message(RB.getStringResource("SeriesParser.", "linepatternmax.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)elem.getAttribute("_stmt").toUpperCase(), (Object)String.valueOf(StatGraph.roundToNextHundreds(maxVertices))), false);
            return false;
        }
        return true;
    }

    static boolean isDiscreteOffsetSupported(ScatterOverlay plot) {
        return plot.isDiscreteX();
    }
}

