/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DataParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.event.SelectionListener;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class StatGraphParser {
    private InputSource dataSource;
    private InputSource viewSource;
    private SelectionListener selectionListener = null;
    private ArrayList labels = new ArrayList();
    private ArrayList styles = new ArrayList();
    private Document xmlDocument = null;
    private int numComps;
    private Locale systemLocale = Locale.getDefault();
    private Locale sessionLocale = null;

    public StatGraphParser(File data, File view, SelectionListener listener) {
        FileInputStream dataStream = null;
        FileInputStream viewStream = null;
        try {
            dataStream = new FileInputStream(data);
            viewStream = new FileInputStream(view);
        }
        catch (FileNotFoundException e) {
            StatGraph.printDebug("XML file(s) not found.");
        }
        this.dataSource = new InputSource(new BufferedInputStream(dataStream));
        this.viewSource = new InputSource(new BufferedInputStream(viewStream));
        this.selectionListener = listener;
        this.xmlDocument = this.loadXML();
    }

    public StatGraphParser(File data, File view) {
        this(data, view, null);
    }

    public StatGraphParser(InputStream data, InputStream view, SelectionListener listener) {
        this(new InputSource(new BufferedInputStream(data)), new InputSource(new BufferedInputStream(view)), listener);
    }

    public StatGraphParser(InputStream data, InputStream view) {
        this(data, view, null);
    }

    public StatGraphParser(InputSource data, InputSource view, SelectionListener listener) {
        this.dataSource = data;
        this.viewSource = view;
        this.selectionListener = listener;
        this.xmlDocument = this.loadXML();
    }

    public StatGraphParser(InputSource data, InputSource view) {
        this(data, view, null);
    }

    public StatGraphPanel[] getGraphComponents() {
        return this.getGraphComponents(null);
    }

    public StatGraphPanel[] getGraphComponents(String[] componentNames) {
        return this.loadComponents(componentNames);
    }

    public StatGraphPanel getGraphComponent(String name) {
        return this.getGraphComponents(new String[]{name})[0];
    }

    public String getGraphName(int i) {
        if (i >= this.numComps) {
            return null;
        }
        return (String)this.labels.get(i);
    }

    public int getGraphCount() {
        return this.numComps;
    }

    private Document loadXML() {
        Node node;
        Document doc = this.parseXML();
        if (doc == null) {
            return null;
        }
        this.sessionLocale = StatGraph.getSessionLocale(doc);
        Element root = doc.getDocumentElement();
        String tag = root.getTagName();
        Element document = null;
        String elemTag = "";
        if (tag.equals("SASReport")) {
            document = root;
        } else {
            for (node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node instanceof Element && (elemTag = ((Element)node).getTagName()).equalsIgnoreCase("SASReport")) {
                    document = (Element)node;
                    break;
                }
                if (document != null) continue;
                System.out.print("No SASReport element found.");
                return null;
            }
        }
        for (node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("View")) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element) || !(elemTag = ((Element)node2).getTagName()).equals("StatGraph")) continue;
                    ++this.numComps;
                    String label = ((Element)node2).getAttribute("label");
                    this.labels.add(label);
                    String style = ((Element)node2).getAttribute("style:style");
                    this.styles.add(style);
                }
                continue;
            }
            if (!elemTag.equals("StatGraph")) continue;
            ++this.numComps;
            String label = ((Element)node).getAttribute("label");
            this.labels.add(label);
            String style = ((Element)node).getAttribute("style:style");
            this.styles.add(style);
        }
        return doc;
    }

    private Document parseXML() {
        DocumentBuilder parser = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            StatGraph.printDebug("pce=" + pce);
            return null;
        }
        Document document = null;
        try {
            document = parser.parse(this.viewSource);
        }
        catch (Exception e) {
            String msg = "Internal Exception:" + e;
            StatGraph.printDebug(msg);
            e.printStackTrace();
            return null;
        }
        return document;
    }

    private StatGraphPanel[] loadComponents(String[] names) {
        StatGraphPanel[] sgPanels2;
        int i;
        if (this.xmlDocument == null) {
            return null;
        }
        Locale.setDefault(this.sessionLocale);
        int[] id = null;
        int num = this.numComps;
        if (names != null) {
            boolean[] loading = new boolean[this.numComps];
            num = 0;
            for (i = 0; i < names.length; ++i) {
                int idx = this.labels.indexOf(names[i]);
                if (idx < 0 || loading[idx]) continue;
                loading[idx] = true;
                ++num;
            }
            id = new int[num];
            int idx = 0;
            for (int i2 = 0; i2 < this.numComps; ++i2) {
                if (!loading[i2]) continue;
                id[idx] = i2;
                ++idx;
            }
        }
        StatGraphPanel[] sgPanels = new StatGraphPanel[num];
        for (i = 0; i < num; ++i) {
            sgPanels[i] = new StatGraphPanel(true);
        }
        this.parseData(sgPanels, id);
        for (i = 0; i < num; ++i) {
            sgPanels[i].separateData = true;
            sgPanels[i].graph.selectionListener = this.selectionListener;
            StatGraph cfr_ignored_0 = sgPanels[i].graph;
            StatGraph.sessionLocale = this.sessionLocale;
            StatGraph cfr_ignored_1 = sgPanels[i].graph;
            StatGraph.systemLocale = this.systemLocale;
            NodeList nl = this.xmlDocument.getElementsByTagName("StatGraph");
            if (nl.getLength() == num) {
                Element elem = (Element)nl.item(i);
                int width = 0;
                int height = 0;
                String str = elem.getAttribute("width");
                if (StatGraph.isNumber(str)) {
                    width = Integer.parseInt(str);
                }
                if (StatGraph.isNumber(str = elem.getAttribute("height"))) {
                    height = Integer.parseInt(str);
                }
                if (width > 0 && height > 0) {
                    sgPanels[i].setSize(new Dimension(width, height));
                }
            }
            StatGraph.errorMessageList = sgPanels[i].getErrorMessages();
            StatGraph.warningMessageList = sgPanels[i].getWarningMessages();
            StatGraph.noteMessageList = sgPanels[i].getNoteMessages();
            sgPanels[i].load(this.xmlDocument, id == null ? i : id[i], id == null ? (String)this.styles.get(i) : (String)this.styles.get(id[i]));
        }
        if (names != null) {
            int i3;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (i3 = 0; i3 < names.length; ++i3) {
                map.put(names[i3], new Integer(i3));
            }
            sgPanels2 = new StatGraphPanel[names.length];
            for (i3 = 0; i3 < num; ++i3) {
                int idx = (Integer)map.get(this.labels.get(id[i3]));
                sgPanels2[idx] = sgPanels[i3];
            }
        } else {
            sgPanels2 = sgPanels;
        }
        Locale.setDefault(this.systemLocale);
        return sgPanels2;
    }

    public void parseData(StatGraphPanel[] panels, int[] graphIDs) {
        if (panels == null) {
            return;
        }
        StatGraph[] sg = new StatGraph[panels.length];
        for (int i = 0; i < sg.length; ++i) {
            sg[i] = panels[i].graph;
        }
        SAXParserFactory dpf = SAXParserFactory.newInstance();
        try {
            dpf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        dpf.setValidating(false);
        dpf.setNamespaceAware(false);
        DataParser handler = null;
        try {
            SAXParser parser = dpf.newSAXParser();
            ParserAdapter pa = new ParserAdapter(parser.getParser());
            handler = new DataParser(sg, graphIDs);
            pa.setContentHandler(handler);
            parser.parse(this.dataSource, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        handler = null;
    }
}

