/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.applets.statgraph.BaseStatGraphPanel;
import com.sas.graphics.applets.statgraph.FormatParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.CompositeComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.AbstractMapProvider;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class StatGraphPanel
extends BaseStatGraphPanel {
    public String errMsg = null;
    public boolean separateData = true;
    public static boolean dumpMessage = false;
    public static boolean dumpTiming = false;
    private ArrayList<String> errorMessageList = null;
    private ArrayList<String> warningMessageList = null;
    private ArrayList<String> noteMessageList = null;
    public String backupStyle = null;

    public StatGraphPanel() {
        this(false);
    }

    public StatGraphPanel(boolean logClientMessages) {
        this.graph = new StatGraph();
        if (logClientMessages) {
            this.errorMessageList = new ArrayList();
            this.warningMessageList = new ArrayList();
            this.noteMessageList = new ArrayList();
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.graph.rootPanel = this;
    }

    public void setServer(boolean server) {
        this.graph.server = server;
    }

    public void addData(DataModel data) {
        this.graph.addData(data);
    }

    public void addOLAPData(String name, OLAPDataSetInterface olap) {
        this.graph.addOLAPModel(name, olap);
    }

    public void addMapProvider(AbstractMapProvider provider) {
        this.graph.addMapProvider(provider);
    }

    public void addRangeAttrMap(String name, RangeAttributeMap ram) {
        this.graph.addRangeAttrMap(name, ram);
    }

    public void setProxy(Proxy proxy) {
        this.graph.setProxy(proxy);
    }

    public boolean load(Document doc) {
        return this.load(doc, 0);
    }

    public boolean load(Document doc, int graphIndex) {
        return this.load(doc, graphIndex, null);
    }

    public boolean load(Document doc, int graphIndex, String styleName) {
        Node node;
        if (dumpTiming) {
            StatGraphPanel.dumpTimeStamp("Begin client: load graph DOM");
        }
        this.graph.size = new Dimension(this.getWidth(), this.getHeight());
        Element root = doc.getDocumentElement();
        String tag = root.getTagName();
        Element document = null;
        String elemTag = "";
        if (tag.equals("SASReport")) {
            document = root;
        } else {
            for (node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equalsIgnoreCase("SASReport")) continue;
                document = (Element)node;
                break;
            }
            if (document == null) {
                this.errMsg = "No SASReport element found.";
                return false;
            }
        }
        FontManager.setRemapWindowsFonts((!StyleUtils.isWindowsOS() ? 1 : 0) != 0);
        Markers.initUserDefinedMarkers();
        Element sgElem = (Element)root.getElementsByTagName("StatGraph").item(0);
        block1: for (node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("style:Scheme")) {
                GraphStyle style = new GraphStyle();
                String[] dataColors = null;
                Element dc = StatGraph.getOptionAttrsElement(sgElem, "DataColors");
                if (dc != null) {
                    dataColors = StatGraph.parseStringValueList(dc, "Value");
                }
                String[] dataContrastColors = null;
                Element dcc = StatGraph.getOptionAttrsElement(sgElem, "DataContrastColors");
                if (dcc != null) {
                    dataContrastColors = StatGraph.parseStringValueList(dcc, "Value");
                }
                String[] dataSymbols = null;
                Element ds = StatGraph.getOptionAttrsElement(sgElem, "DataSymbols");
                if (ds != null) {
                    dataSymbols = StatGraph.parseStringValueList(ds, "Value");
                }
                String[] dataLinePatterns = null;
                Element dlp = StatGraph.getOptionAttrsElement(sgElem, "DataLinePatterns");
                if (dlp != null) {
                    dataLinePatterns = StatGraph.parseStringValueList(dlp, "Value");
                }
                String[] dataFillPatterns = null;
                Element dfp = StatGraph.getOptionAttrsElement(sgElem, "DataFillPatterns");
                if (dfp != null) {
                    dataFillPatterns = StatGraph.parseStringValueList(dfp, "Value");
                }
                String attrPriority = sgElem.getAttribute("attrPriority");
                String dataSkin = sgElem.getAttribute("dataSkin");
                GraphStyle.updateGraphDataStyles((Element)node, attrPriority, dataColors, dataContrastColors, dataSymbols, dataLinePatterns, dataFillPatterns, dataSkin);
                Style styleObject = null;
                styleObject = styleName == null ? Style.getStyle((Element)((Element)node), (boolean)false) : Style.getStyle((Element)((Element)node), (String)styleName, (boolean)false);
                if (styleObject.getDataStyleElement("GraphDataStyleDefault") == null) {
                    styleObject.addElement("GraphDataStyleDefault");
                }
                StatGraphPanel.parseUserDefinedMarkers(this, sgElem, styleObject);
                style.setGraphStyle(styleObject);
                this.graph.style = style;
                if (style.getAttrPriority() == 1 && (dataSymbols != null || dataLinePatterns != null)) {
                    StatGraph.printNote(RB.getStringResource("StatGraph.", "attrpriority.txt"));
                }
                if (dataSymbols == null) continue;
                for (int i = 0; i < dataSymbols.length; ++i) {
                    int symbol = Markers.getShape((String)dataSymbols[i]);
                    if (symbol < 0 || Markers.isGTLSupportedMarker((int)symbol)) continue;
                    Message msg = new Message(RB.getStringResource("StatGraph.", "datasymbols.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)dataSymbols[i]));
                    continue block1;
                }
                continue;
            }
            if (elemTag.equals("Formats")) {
                for (Node fnode = node.getFirstChild(); fnode != null; fnode = fnode.getNextSibling()) {
                    if (!(fnode instanceof Element)) continue;
                    FormatParser.load(this.graph, (Element)fnode);
                }
                continue;
            }
            if (elemTag.equals("StatGraph")) {
                this.graph.load((Element)node);
                continue;
            }
            if (!elemTag.equals("View")) continue;
            int currentGraph = 0;
            for (Node snode = node.getFirstChild(); snode != null; snode = snode.getNextSibling()) {
                String sTag;
                if (!(snode instanceof Element) || !(sTag = ((Element)snode).getTagName()).equals("StatGraph")) continue;
                if (currentGraph == graphIndex) {
                    if (this.graph.style == null && this.backupStyle != null) {
                        this.graph.style = new GraphStyle();
                        this.graph.style.setGraphStyle(PredefinedStyles.getPredefinedStyle((String)this.backupStyle));
                    }
                    this.graph.load((Element)snode);
                    continue block1;
                }
                ++currentGraph;
            }
        }
        if (dumpTiming) {
            StatGraphPanel.dumpTimeStamp("End client:load graph DOM");
        }
        return true;
    }

    static void addImageMap(ArrayList maps, JComponent comp) {
        Component[] children = comp.getComponents();
        for (int i = 0; i < children.length; ++i) {
            ImageMap im;
            if (children[i] instanceof OverlayContainer) {
                ImageMap im2;
                OverlayContainer oc = (OverlayContainer)children[i];
                Simple2DOverlayComposite soc = null;
                for (int j = 0; j < oc.getComponentCount(); ++j) {
                    JComponent c = (JComponent)oc.getComponent(j);
                    if (c instanceof CompositeComponent) {
                        soc = ((CompositeComponent)c).getComposite();
                        continue;
                    }
                    StatGraphPanel.addImageMap(maps, c);
                }
                if (soc == null || (im2 = soc.getImageMap()) == null) continue;
                maps.add(im2);
                continue;
            }
            if (children[i] instanceof RegionContainer) {
                ImageMap im3;
                Region region = null;
                for (int j = 0; j < ((JComponent)children[i]).getComponentCount(); ++j) {
                    JComponent c = (JComponent)((JComponent)children[i]).getComponent(j);
                    if (c instanceof Region) {
                        region = (Region)c;
                        continue;
                    }
                    StatGraphPanel.addImageMap(maps, c);
                }
                if (region == null || (im3 = region.getImageMap()) == null) continue;
                maps.add(im3);
                continue;
            }
            if (children[i] instanceof CompositeComponent) {
                im = ((CompositeComponent)children[i]).getComposite().getImageMap();
                if (im == null) continue;
                maps.add(im);
                continue;
            }
            if (children[i] instanceof Region) {
                im = ((Region)children[i]).getImageMap();
                if (im == null) continue;
                maps.add(im);
                continue;
            }
            StatGraphPanel.addImageMap(maps, (JComponent)children[i]);
        }
    }

    public ArrayList getImageMap() {
        ImageMap im;
        ImageMap.Region rr;
        int j;
        Shape[] shapes;
        AbstractAnno aa;
        int i;
        ArrayList<ImageMap> maps = new ArrayList<ImageMap>(12);
        for (i = this.graph.annotationInFrontList.size() - 1; i >= 0; --i) {
            aa = this.graph.annotationInFrontList.get(i);
            if (aa.getURL() == null && aa.getTooltip() == null || (shapes = aa.getImageMapRegions()) == null) continue;
            for (j = 0; j < shapes.length; ++j) {
                if (shapes[j] == null) continue;
                rr = new ImageMap.Region(shapes[j], aa.getURL(), aa.getTooltip());
                im = new ImageMap(new ImageMap.Region[]{rr});
                maps.add(im);
            }
        }
        StatGraphPanel.addImageMap(maps, this);
        for (i = this.graph.annotationInBackList.size() - 1; i >= 0; --i) {
            aa = this.graph.annotationInBackList.get(i);
            if (aa.getURL() == null && aa.getTooltip() == null || (shapes = aa.getImageMapRegions()) == null) continue;
            for (j = 0; j < shapes.length; ++j) {
                if (shapes[j] == null) continue;
                rr = new ImageMap.Region(shapes[j], aa.getURL(), aa.getTooltip());
                im = new ImageMap(new ImageMap.Region[]{rr});
                maps.add(im);
            }
        }
        return maps;
    }

    public static void dumpTimeStamp(String msg) {
        SimpleDateFormat sf = new SimpleDateFormat("ddMMMyy:kk:mm:ss.SSS");
        System.out.println("STG_TIMESTAMP: " + sf.format(new Date()).substring(0, 19).toUpperCase() + " " + msg);
    }

    public ArrayList getErrorMessages() {
        return this.errorMessageList;
    }

    public ArrayList getWarningMessages() {
        return this.warningMessageList;
    }

    public ArrayList getNoteMessages() {
        return this.noteMessageList;
    }
}

