/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.Constants;
import com.sas.graphics.applets.statgraph.AnnoDatasetParser;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.AxisLegendParser;
import com.sas.graphics.applets.statgraph.BaseStatGraphPanel;
import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.DecisionTreeParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.KPIParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutDataMatrixParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayExtrudedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapTempParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.LegendItemParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.MosaicParser;
import com.sas.graphics.applets.statgraph.PathDiagramParser;
import com.sas.graphics.applets.statgraph.PieParser2;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.ScatterMatrixParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.SizeLegendParser;
import com.sas.graphics.applets.statgraph.StripLabelParser;
import com.sas.graphics.applets.statgraph.TableParser;
import com.sas.graphics.applets.statgraph.TileParser;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GlobalLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.LegendTextItemList;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.applets.statgraph.sgchart.event.SelectionListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.OuterPadBorder;
import com.sas.graphics.applets.statgraph.sgchart.grid.StripLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.GridAxis;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.legend.AutoContinuousLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.VLegend;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.AbstractMapProvider;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BandOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.OContour;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SurfaceOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.CategorizationAttrMapper;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.attrmap.CategorizationAttributeMap;
import com.sas.graphics.util.attrmap.CategorizationAttributeMapParser;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.attrmap.DiscreteAttributeMapParser;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeAttributeMapParser;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.text.Message;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StatGraph {
    public static final String RB_KEY = "StatGraph.";
    public static final int SCATTER = 0;
    public static final int SERIES = 1;
    public static final int STEP = 2;
    public static final int NEEDLE = 3;
    public static final int VECTOR = 4;
    public static final int LINE = 5;
    public static final int BAND = 6;
    public static final int HISTOGRAM = 7;
    public static final int BVHISTOGRAM = 8;
    public static final int CONTOUR = 9;
    public static final int SURFACE = 10;
    public static final int BAR = 11;
    public static final int ELLIPSE = 12;
    public static final int FRINGE = 13;
    public static final int BOX = 14;
    public static final int PIE = 15;
    public static final int REFERENCELINE = 16;
    public static final int DROPLINE = 17;
    public static final int BLOCK = 18;
    public static final int LINECHART = 19;
    public static final int HEATMAPPARM = 20;
    public static final int WATERFALL = 21;
    public static final int DENDROGRAM = 22;
    public static final int BUBBLE = 23;
    public static final int HIGHLOW = 24;
    public static final int LINECHART2 = 25;
    public static final int RANGEATTRMAPVIEW = 26;
    public static final int TIMESERIES = 27;
    public static final int AXISTABLE = 28;
    public static final int POLYGON = 29;
    public static final int TEXTPLOT = 30;
    public static final int HEATBOXPARM = 31;
    public static final int WINDOWS = 0;
    public static final int ALX = 1;
    public static final int ALP = 2;
    public static final int OTHER_HOST = 3;
    public static final int TYPE_COL = 0;
    public static final int TYPE_CHAR = 1;
    public static final int TYPE_NUM = 2;
    public static final int TYPE_KEYWORD = 3;
    public JComponent rootPanel;
    public Dimension size;
    public ArrayList dataModelList = new ArrayList();
    public GraphStyle style;
    public boolean server = false;
    public boolean dataAntialiased = true;
    public boolean axisAntialiased = true;
    public boolean imagemapEnabled = true;
    public boolean subpixelRendering = false;
    public boolean isAutoSubpixel = false;
    public double axisLineOffsetCoverage = 1.0;
    public int labelingThreshold = 200;
    public int imagemapThreshold = 500;
    public int dataAntialisingThreshold = 4000;
    public int groupMax = 1000;
    public int discreteMax = 1000;
    public int panelCellMax = 1000;
    public int totalCellMax = 2000;
    public int nBinsMax = 10000;
    public int nXYBinsMax = 100000;
    public static int DATA_SKIN_MAX = 200;
    public int dataSkinMax = DATA_SKIN_MAX;
    public int nodeMax = Integer.MAX_VALUE;
    public int linePatternOBSMax = 10000;
    public int fillPatternOBSMax = 500;
    public boolean view2D = true;
    protected HashMap mapProviders = new HashMap();
    protected HashMap graphNamesTable = new HashMap();
    protected HashMap graphNamesRefs = new HashMap();
    protected HashMap legendItemsTable = new HashMap();
    protected HashMap legendTextItemsTable = new HashMap();
    protected HashMap axisNamesTable = new HashMap();
    protected HashMap axisNamesRefs = new HashMap();
    protected HashMap overviewAxisElements = new HashMap();
    protected double maxTotalLegendArea = 0.2;
    protected boolean scaleMarkers = true;
    public static double dataDPIScaleFactor = 1.0;
    public static double dataSizeScaleFactor = 1.0;
    public static double gapScaleFactor = 1.0;
    public static double linearScaleFactor = 1.0;
    public static int MPC = -1;
    public static boolean textWrapped = false;
    public static boolean includeMissingDiscrete = false;
    public static String missingOption = ".";
    public static String missingCharacter = "";
    public static boolean suppressWarningMsg = false;
    public static boolean noNotes = false;
    public static int extraPadding = 5;
    public static int SCMX_INSET_GUTTER = 4;
    public static int minimumFontSize = 6;
    public static boolean VGF = false;
    public static boolean SVG = false;
    public static boolean SVGSelectionMode = false;
    public static ArrayList<String> errorMessageList = null;
    public static ArrayList<String> warningMessageList = null;
    public static ArrayList<String> noteMessageList = null;
    public boolean xAxisViewportEnabled = true;
    public boolean yAxisViewportEnabled = true;
    public JPopupMenu chartPopupMenu = null;
    public SelectionListener selectionListener = null;
    public static final String valueSeparator = " ";
    public static final String modelSeparator = "#";
    public boolean whereVarsOnSeparateModel = false;
    public boolean whereIncludeMissingClass = true;
    public String whereDataModelName = null;
    public StringVariable[] whereVars = null;
    public String whereExpression = null;
    public String[] allWhereExpressions = null;
    public boolean xUnionAllPages = false;
    public boolean yUnionAllPages = false;
    public boolean x2UnionAllPages = false;
    public boolean y2UnionAllPages = false;
    private static Graphics dummyGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected ArrayList equatedPlots = null;
    public int pageNo = -1;
    protected double fontScaleFactor = 1.0;
    protected static double shrinkFontsFactor = 0.9;
    protected static double shrinkGapsFactor = 0.45;
    protected int shrinkFontsPower = 0;
    private JPanel titlePanel = null;
    private JPanel footnotePanel = null;
    private GlobalLegend globalLegend = null;
    private int numPages = -1;
    public static Locale systemLocale = null;
    public static Locale sessionLocale = null;
    public static String xmlEncoding = null;
    public static boolean useFontManager = false;
    public static Color clearColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    public ArrayList<AbstractAnno> annotationInBackList = new ArrayList();
    public ArrayList<AbstractAnno> annotationInFrontList = new ArrayList();
    public static String placeHolderToken = "AUTO";
    public static int collation = 1001;
    protected Hashtable<String, DiscreteAttributeMap> discreteAttrMapTable = new Hashtable();
    protected Hashtable<String, RangeAttributeMap> rangeAttrMapTable = new Hashtable();
    protected Hashtable<String, CategorizationAttributeMap> categorizationAttrMapTable = new Hashtable();
    protected ArrayList olapData = new ArrayList();
    protected static boolean olapGraph = false;
    protected static boolean birdRenderer = false;
    protected static boolean useResultSetID = false;
    protected boolean casData = false;
    private Proxy proxy = null;
    boolean hasForeignObject = false;
    private int supportedGraphCount = 0;
    private int validGraphCount = 0;
    protected String drillTarget = "_BLANK";
    protected boolean qcGlobalLegend = false;
    protected boolean transparentBackground = false;
    public boolean useFontLookupTable = true;
    protected int aaMax = -1;
    protected int tipMax = -1;
    protected ArrayList subpixelRenderers = new ArrayList();
    private int axisBreakSymbol = 0;
    private boolean discreteOffsetPadding = true;
    private HashMap discreteAttrVars = new HashMap();
    private HashMap rangeAttrVars = new HashMap();
    private HashMap categorizationAttrVars = new HashMap();
    public static final int NONNEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int POSITIVE_INTEGER = 2;
    private HashMap elementToObject;
    private HashMap<AbstractAnno, Element> drawObjectToElement = new HashMap();
    private HashMap sgElementToContainer = new HashMap();
    private int drawSpace = 3;
    public static final int ArrowAndTextComposite = 0;
    public static final int ArrowLineElement = 1;
    public static final int LineElement = 2;
    public static final int EllipseElement = 3;
    public static final int RectangleElement = 4;
    public static final int TextElement = 5;
    public static final int ImageElement = 6;
    public static final int MarkerElement = 7;
    public static final int ElementCount = 8;
    public static final String[] ElementNames = new String[]{"ArrowAndTextCompositeElement", "ArrowLineElement", "LineElement", "EllipseElement", "RectangleElement", "TextElement", "ImageElement", "MarkerElement"};
    private static ArrayList<Class> thirdPartyComponents = new ArrayList();
    boolean saLabeling = false;
    boolean labelDisplaceable = false;
    boolean labelVerbose = false;
    HashMap saWeightMap = null;
    int saMaxIterations = 100;
    int saSeed = 1234567;

    public StatGraph() {
        dataDPIScaleFactor = 1.0;
        dataSizeScaleFactor = 1.0;
        gapScaleFactor = 1.0;
        linearScaleFactor = 1.0;
        MPC = -1;
        textWrapped = false;
        missingOption = ".";
        VGF = false;
    }

    public static boolean isOLAP() {
        return olapGraph;
    }

    public static boolean isBirdRenderer() {
        return birdRenderer;
    }

    public static void setBirdRenderer(boolean b) {
        birdRenderer = b;
    }

    public static boolean isUseResultSetID() {
        return useResultSetID;
    }

    public static void setUseResultSetID(boolean b) {
        useResultSetID = b;
    }

    public boolean isCASData() {
        return this.casData;
    }

    public void setCASData(boolean b) {
        this.casData = b;
    }

    public boolean isCASData2() {
        return false;
    }

    public static int getMinimumFontSize() {
        return (int)Math.ceil((double)minimumFontSize * dataDPIScaleFactor);
    }

    public static int getExtraPadding() {
        return (int)Math.ceil((double)extraPadding * StatGraph.getGapScaleFactor());
    }

    public static Graphics getGraphics() {
        return dummyGraphics;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public void setNumPages(int pages) {
        this.numPages = pages;
    }

    public static FontMetrics getFontMetrics(Font font) {
        Graphics2D g2d = (Graphics2D)dummyGraphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (font == null) {
            return dummyGraphics.getFontMetrics();
        }
        return dummyGraphics.getFontMetrics(font);
    }

    public static FontMetrics getFontMetrics(String family, int style, int size) {
        Graphics2D g2d = (Graphics2D)dummyGraphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = null;
        font = useFontManager ? FontManager.getFont((String)family, (int)style, (int)size) : new Font(family, style, size);
        if (font == null) {
            return dummyGraphics.getFontMetrics();
        }
        return dummyGraphics.getFontMetrics(font);
    }

    public boolean isImagemapEnabled() {
        return this.imagemapEnabled;
    }

    public int getMaxOBS() {
        int mnobs = -2147483647;
        for (int i = 0; i < this.dataModelList.size(); ++i) {
            DataModel m = (DataModel)this.dataModelList.get(i);
            mnobs = Math.max(mnobs, m.getRowCount());
        }
        return mnobs;
    }

    public boolean isScaleMarkers() {
        return this.scaleMarkers;
    }

    public void setScaleMarkers(boolean scaleMarkers) {
        this.scaleMarkers = scaleMarkers;
    }

    void pushFontsShrinkage(Element elem) {
        if (elem.getAttribute("shrinkFonts").equalsIgnoreCase("true")) {
            ++this.shrinkFontsPower;
        }
    }

    void popFontsShrinkage(Element elem) {
        if (elem.getAttribute("shrinkFonts").equalsIgnoreCase("true")) {
            --this.shrinkFontsPower;
        }
    }

    public boolean isEmptyGraph(Element elem) {
        if (this.getMaxOBS() > 0) {
            return false;
        }
        NodeList ellipses = elem.getElementsByTagName("EllipseParm");
        int cnt = 0;
        for (int i = 0; i < ellipses.getLength(); ++i) {
            Element e = (Element)ellipses.item(i);
            if (!e.getAttribute("_stmt").equalsIgnoreCase("Ellipse")) continue;
            ++cnt;
        }
        if (cnt != 0) {
            return false;
        }
        NodeList kpis = elem.getElementsByTagName("KPIChart");
        if (kpis.getLength() > 0) {
            return false;
        }
        kpis = elem.getElementsByTagName("KPIParm");
        if (kpis.getLength() > 0) {
            return false;
        }
        return !StatGraph.hasDrawObjects(elem);
    }

    public static boolean hasDrawObjects(Element elem) {
        NodeList list = elem.getElementsByTagName("DrawImage");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawText");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawLine");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawArrow");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawRectangle");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawOval");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawPolyline");
        if (list.getLength() > 0) {
            return true;
        }
        list = elem.getElementsByTagName("DrawPolygon");
        return list.getLength() > 0;
    }

    public void addDiscreteAttrVar(String name, String attrMapName) {
        if (this.getDiscreteAttrMap(attrMapName) != null) {
            this.discreteAttrVars.put(name.toUpperCase(), attrMapName);
        }
    }

    public void removeDiscreteAttrVar(String name) {
        this.discreteAttrVars.remove(name);
    }

    public boolean hasDiscreteAttrVar(String name) {
        return this.discreteAttrVars.containsKey(name);
    }

    public DiscreteAttrMapper getDiscreteAttrVar(String name) {
        String attrMapName = (String)this.discreteAttrVars.get(name.toUpperCase());
        if (attrMapName == null) {
            return null;
        }
        DiscreteAttributeMap map = this.getDiscreteAttrMap(attrMapName);
        DiscreteAttrMapper mapper = new DiscreteAttrMapper(map);
        return mapper;
    }

    public void addRangeAttrVar(String name, String attrMapName) {
        if (this.getRangeAttrMap(attrMapName) == null) {
            return;
        }
        this.rangeAttrVars.put(name.toUpperCase(), attrMapName);
    }

    public void removeRangeAttrVar(String name) {
        this.rangeAttrVars.remove(name);
    }

    public boolean hasRangeAttrVar(String name) {
        return this.rangeAttrVars.containsKey(name);
    }

    public RangeAttrMapper getRangeAttrVar(String name) {
        String attrMapName = (String)this.rangeAttrVars.get(name.toUpperCase());
        if (attrMapName == null) {
            return null;
        }
        RangeAttributeMap map = this.getRangeAttrMap(attrMapName);
        RangeAttrMapper mapper = new RangeAttrMapper(map, this.style.getGraphStyle());
        return mapper;
    }

    public void addCategorizationAttrVar(String name, String attrMapName) {
        if (this.getCategorizationAttrMap(attrMapName) == null) {
            return;
        }
        this.categorizationAttrVars.put(name.toUpperCase(), attrMapName);
    }

    public void removeCategorizationAttrVar(String name) {
        this.categorizationAttrVars.remove(name);
    }

    public boolean hasCategorizationAttrVar(String name) {
        return this.categorizationAttrVars.containsKey(name);
    }

    public CategorizationAttrMapper getCategorizationAttrVar(String name) {
        String attrMapName = (String)this.categorizationAttrVars.get(name.toUpperCase());
        if (attrMapName == null) {
            return null;
        }
        CategorizationAttributeMap map = this.getCategorizationAttrMap(attrMapName);
        CategorizationAttrMapper mapper = new CategorizationAttrMapper(map, this.style.getGraphStyle());
        return mapper;
    }

    public static Insets getDefaultOuterPad(Component comp) {
        if (comp.getAlignmentY() == 0.0f) {
            return new Insets(0, 0, StatGraph.getExtraPadding(), 0);
        }
        if (comp.getAlignmentY() == 1.0f) {
            return new Insets(StatGraph.getExtraPadding(), 0, 0, 0);
        }
        if (comp.getAlignmentX() == 0.0f) {
            return new Insets(0, 0, 0, StatGraph.getExtraPadding());
        }
        if (comp.getAlignmentX() == 1.0f) {
            return new Insets(0, StatGraph.getExtraPadding(), 0, 0);
        }
        return new Insets(0, 0, 0, 0);
    }

    public static void addDefaultOuterPad(Element elem, JComponent comp) {
        StatGraph.addDefaultOuterPad(elem, comp, StatGraph.getDefaultOuterPad(comp));
    }

    public static void addDefaultOuterPad(Element elem, JComponent comp, Insets outerPad) {
        boolean top = outerPad.top > 0;
        boolean left = outerPad.left > 0;
        boolean bottom = outerPad.bottom > 0;
        boolean right = outerPad.right > 0;
        String str = elem.getAttribute("outerPad");
        if (str.length() > 0 && StatGraph.isLineThickness(str)) {
            return;
        }
        Element outerPadAttrs = StatGraph.getOptionAttrsElement(elem, "OuterPadAttrs");
        if (outerPadAttrs != null) {
            if (top && outerPadAttrs.hasAttribute("top")) {
                return;
            }
            if (left && outerPadAttrs.hasAttribute("left")) {
                return;
            }
            if (bottom && outerPadAttrs.hasAttribute("bottom")) {
                return;
            }
            if (right && outerPadAttrs.hasAttribute("right")) {
                return;
            }
        }
        OuterPadBorder outerPadBorder = new OuterPadBorder(outerPad.top, outerPad.left, outerPad.bottom, outerPad.right);
        Border border = comp.getBorder();
        if (border == null) {
            comp.setBorder((Border)outerPadBorder);
        } else if (border instanceof CompoundBorder) {
            Border outer = ((CompoundBorder)border).getOutsideBorder();
            Border inner = ((CompoundBorder)border).getInsideBorder();
            if (outer instanceof OuterPadBorder) {
                Insets pad = outer.getBorderInsets(comp);
                if (top) {
                    pad.top = outerPad.top;
                }
                if (left) {
                    pad.left = outerPad.left;
                }
                if (bottom) {
                    pad.bottom = outerPad.bottom;
                }
                if (right) {
                    pad.right = outerPad.right;
                }
                OuterPadBorder newOuterBorder = new OuterPadBorder(pad.top, pad.left, pad.bottom, pad.right);
                comp.setBorder(BorderFactory.createCompoundBorder((Border)newOuterBorder, inner));
            } else {
                comp.setBorder(BorderFactory.createCompoundBorder((Border)outerPadBorder, border));
            }
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder((Border)outerPadBorder, border));
        }
    }

    public boolean load(Element elem) {
        int index;
        AbstractAnno anno;
        int i;
        Element globalLegendElem;
        GlobalLegend gl;
        NodeList legendTextList;
        NodeList legendItemList;
        NodeList layoutGL;
        NodeList footnoteList;
        Node node;
        double mla;
        this.dumpSupportedFonts(elem);
        String str = elem.getAttribute("renderer");
        if (str.equalsIgnoreCase("crender") || elem.getAttribute("debugOption").toLowerCase().indexOf("crender") >= 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "invalidrenderer.txt"));
            return false;
        }
        this.setTransparentBackground(elem.getAttribute("opaque").equalsIgnoreCase("false"));
        if (!birdRenderer) {
            birdRenderer = elem.hasAttribute("birdRenderer") ? elem.getAttribute("birdRenderer").equalsIgnoreCase("true") : elem.getAttribute("debugOption").equalsIgnoreCase("_bird_");
        }
        this.casData = elem.hasAttribute("casData") ? elem.getAttribute("casData").equalsIgnoreCase("true") : elem.getAttribute("debugOption").toLowerCase().indexOf("casdata") >= 0;
        str = elem.getAttribute("labelPlacement");
        if (str.equalsIgnoreCase("SA")) {
            this.saLabeling = true;
        }
        this.parseLabelPlacementOpts(elem);
        str = elem.getAttribute("collation");
        collation = str.equalsIgnoreCase("BINARY") ? 1002 : 1001;
        str = elem.getAttribute("suppressClientMsg");
        suppressWarningMsg = str.equalsIgnoreCase("true");
        str = elem.getAttribute("notesOption");
        noNotes = str.equalsIgnoreCase("false");
        if (!StatGraph.isOLAP() && this.isEmptyGraph(elem)) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "empty.txt"));
            return false;
        }
        this.style.getGraphStyle().setPrintMessages(!noNotes && !suppressWarningMsg);
        str = elem.getAttribute("antiAlias");
        if (str.equalsIgnoreCase("test")) {
            if (!VGF) {
                this.axisAntialiased = false;
            }
            this.dataAntialiased = false;
        } else if (str.equalsIgnoreCase("false")) {
            this.dataAntialiased = false;
        }
        if (this.dataAntialiased && StatGraph.isNumber(str = elem.getAttribute("antiAliasLimit"))) {
            this.dataAntialisingThreshold = Integer.parseInt(str);
        }
        if (VGF) {
            this.subpixelRendering = true;
        } else if (!this.dataAntialiased) {
            this.subpixelRendering = false;
        } else {
            str = elem.getAttribute("subPixel");
            if (str.equalsIgnoreCase("on")) {
                this.subpixelRendering = true;
            } else if (str.equalsIgnoreCase("off")) {
                this.subpixelRendering = false;
            } else {
                this.subpixelRendering = this.isSubpixelRenderingRequired(elem);
                this.isAutoSubpixel = true;
            }
        }
        str = elem.getAttribute("axisLineExtent");
        if (StatGraph.isNumber(str)) {
            double d = Double.parseDouble(str);
            if (d >= 0.0 && d <= 1.0) {
                this.axisLineOffsetCoverage = d;
            }
        } else if (str.equalsIgnoreCase("full")) {
            this.axisLineOffsetCoverage = 1.0;
        } else if (str.equalsIgnoreCase("data")) {
            this.axisLineOffsetCoverage = 0.0;
        } else if (str.length() > 0) {
            StatGraph.printOptionError("AXISLINEEXTENT", str);
        }
        str = elem.getAttribute("drillTarget");
        if (str.length() > 0) {
            this.setDrillTarget(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("labelingLimit"))) {
            this.labelingThreshold = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("imagemapLimit"))) {
            this.imagemapThreshold = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("groupMax"))) {
            this.groupMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("discreteMax"))) {
            this.discreteMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("nBinsMax"))) {
            this.nBinsMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("nXYBinsMax"))) {
            this.nXYBinsMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("panelCellMax"))) {
            this.panelCellMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("dataSkinMax"))) {
            this.dataSkinMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("nodeMax"))) {
            this.nodeMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("linePatternOBSMax"))) {
            this.linePatternOBSMax = Integer.parseInt(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("totalCellMax"))) {
            this.totalCellMax = Integer.parseInt(str);
        }
        dataDPIScaleFactor = StatGraph.isNumber(str = elem.getAttribute("dataDPIScalingFactor")) ? Double.parseDouble(str) : 1.0;
        str = elem.getAttribute("dataSizeScalingFactor");
        dataSizeScaleFactor = StatGraph.isNumber(str) ? Double.parseDouble(str) : 1.0;
        str = elem.getAttribute("gapScalingFactor");
        gapScaleFactor = StatGraph.isNumber(str) ? Double.parseDouble(str) : dataDPIScaleFactor;
        double dh = 480.0;
        double ah = 480.0;
        str = elem.getAttribute("designHeight");
        if (StatGraph.isNumber(str)) {
            dh = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("height"))) {
            ah = Double.parseDouble(str);
        }
        linearScaleFactor = ah / dh;
        this.checkForAnnoAndMoveToDraw(elem);
        if (elem.hasAttribute("drawSpace")) {
            str = elem.getAttribute("drawSpace");
            for (int i2 = 0; i2 < Constants.SPACE_UNIT.length; ++i2) {
                if (!Constants.SPACE_UNIT[i2].equalsIgnoreCase(str)) continue;
                this.drawSpace = i2;
                break;
            }
        }
        if ((str = elem.getAttribute("axisBreakType")).length() == 0 || str.equalsIgnoreCase("FULL")) {
            this.axisBreakSymbol = 0;
        } else if (str.equalsIgnoreCase("AXIS")) {
            str = elem.getAttribute("axisBreakSymbol");
            if (str.length() == 0) {
                this.axisBreakSymbol = 4;
            } else if (str.equalsIgnoreCase("bracket")) {
                this.axisBreakSymbol = 1;
            } else if (str.equalsIgnoreCase("slantedRight")) {
                this.axisBreakSymbol = 2;
            } else if (str.equalsIgnoreCase("slantedLeft")) {
                this.axisBreakSymbol = 3;
            } else if (str.equalsIgnoreCase("squiggle")) {
                this.axisBreakSymbol = 4;
            } else if (str.equalsIgnoreCase("spark")) {
                this.axisBreakSymbol = 5;
            } else if (str.equalsIgnoreCase("notch")) {
                this.axisBreakSymbol = 6;
            } else if (str.equalsIgnoreCase("z")) {
                this.axisBreakSymbol = 7;
            } else {
                this.axisBreakSymbol = 4;
                StatGraph.printOptionError("BROKENAXISHASH", str);
            }
        } else {
            StatGraph.printOptionError("AXISBREAKTYPE", str);
        }
        BrokenPositionEncoder.BROKEN_GAP = this.axisBreakSymbol == 0 ? StatGraph.getExtraPadding() : 2 * StatGraph.getExtraPadding();
        str = elem.getAttribute("discreteAxisOffsetPad");
        if (str.equalsIgnoreCase("FALSE")) {
            this.setDiscreteOffsetPadding(false);
        }
        TrellisLayout.titleFootnoteSpacing = 0;
        TrellisLayout.interTitleFootnoteGap = 0;
        includeMissingDiscrete = elem.getAttribute("includeMissingDiscrete").equalsIgnoreCase("true");
        str = elem.getAttribute("missingOption");
        if (str.length() > 0) {
            missingOption = str.trim();
        }
        if ((str = elem.getAttribute("maxLegendArea")).length() > 0 && (mla = Double.parseDouble(str)) >= 0.0 && mla <= 100.0) {
            this.maxTotalLegendArea = mla / 100.0;
        }
        if ((str = elem.getAttribute("scaleMarkers")).equalsIgnoreCase("FALSE")) {
            this.setScaleMarkers(false);
        }
        DAMDatasetParser.load(this, elem);
        NodeList discreteAttrMapList = elem.getElementsByTagName("DiscreteAttrMap");
        int nl = discreteAttrMapList.getLength();
        if (discreteAttrMapList.getLength() > 0) {
            for (int i3 = 0; i3 < nl; ++i3) {
                Node nd = discreteAttrMapList.item(i3);
                Object obj = DiscreteAttributeMapParser.load((Element)((Element)nd), (Style)this.style.getGraphStyle(), (int)this.size.width, (int)this.size.height, (int)this.getDPI(), (double)dataDPIScaleFactor, (double)dataSizeScaleFactor, (double)this.fontScaleFactor, (double)this.getShrinkageScale(), (int)minimumFontSize, (boolean)useFontManager);
                if (obj instanceof DiscreteAttributeMap) {
                    DiscreteAttributeMap attrMap = (DiscreteAttributeMap)obj;
                    if (attrMap == null) continue;
                    this.addDiscreteAttrMap(attrMap.getName(), attrMap);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                StatGraph.printWarning((String)obj);
            }
        }
        NodeList rangeAttrMapList = elem.getElementsByTagName("RangeAttrMap");
        nl = rangeAttrMapList.getLength();
        if (rangeAttrMapList.getLength() > 0) {
            for (int i4 = 0; i4 < nl; ++i4) {
                Node nd = rangeAttrMapList.item(i4);
                Object obj = RangeAttributeMapParser.load((Element)((Element)nd), (Style)this.style.getGraphStyle());
                if (obj instanceof RangeAttributeMap) {
                    RangeAttributeMap attrMap = (RangeAttributeMap)obj;
                    if (attrMap == null) continue;
                    this.addRangeAttrMap(attrMap.getName(), attrMap);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                StatGraph.printWarning((String)obj);
            }
        }
        NodeList categorizationAttrMapList = elem.getElementsByTagName("CategorizationAttrMap");
        nl = categorizationAttrMapList.getLength();
        if (categorizationAttrMapList.getLength() > 0) {
            for (int i5 = 0; i5 < nl; ++i5) {
                Node nd = categorizationAttrMapList.item(i5);
                Object obj = CategorizationAttributeMapParser.load((Element)((Element)nd), (Style)this.style.getGraphStyle());
                if (obj instanceof CategorizationAttributeMap) {
                    CategorizationAttributeMap attrMap = (CategorizationAttributeMap)obj;
                    if (attrMap == null) continue;
                    this.addCategorizationAttrMap(attrMap.getName(), attrMap);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                StatGraph.printWarning((String)obj);
            }
        }
        NodeList discreteAttrVarList = elem.getElementsByTagName("DiscreteAttrVar");
        for (int i6 = 0; i6 < discreteAttrVarList.getLength(); ++i6) {
            Element e = (Element)discreteAttrVarList.item(i6);
            this.addDiscreteAttrVar(e.getAttribute("attrVar"), e.getAttribute("attrMap"));
        }
        DAMDatasetParser.createInternalDAttrVars(this, elem);
        NodeList rangeAttrVarList = elem.getElementsByTagName("RangeAttrVar");
        for (int i7 = 0; i7 < rangeAttrVarList.getLength(); ++i7) {
            Element e = (Element)rangeAttrVarList.item(i7);
            this.addRangeAttrVar(e.getAttribute("attrVar"), e.getAttribute("attrMap"));
        }
        NodeList categorizationAttrVarList = elem.getElementsByTagName("CategorizationAttrVar");
        for (int i8 = 0; i8 < categorizationAttrVarList.getLength(); ++i8) {
            Element e = (Element)categorizationAttrVarList.item(i8);
            this.addCategorizationAttrVar(e.getAttribute("attrVar"), e.getAttribute("attrMap"));
        }
        NodeList overviewAxisList = elem.getElementsByTagName("OverviewAxis");
        for (int i9 = 0; i9 < overviewAxisList.getLength(); ++i9) {
            Element e = (Element)overviewAxisList.item(i9);
            if (e.getAttribute("visible").equalsIgnoreCase("off")) continue;
            String s = e.getAttribute("axis");
            this.addOverviewAxisElement(s, e);
        }
        AnnoDatasetParser.load(this, elem);
        boolean layoutOverlay = false;
        OverlayContainer oc = null;
        String elemTag = "";
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            JComponent c;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("LayoutOverlay")) {
                c = LayoutOverlayParser.load(this, (Element)node, true);
                this.rootPanel.add(c);
                if (!(c instanceof OverlayContainer)) continue;
                layoutOverlay = true;
                oc = (OverlayContainer)c;
                continue;
            }
            if (elemTag.equals("LayoutOverlayExtruded")) {
                c = LayoutOverlayExtrudedParser.load(this, (Element)node, true);
                if (c == null) continue;
                this.rootPanel.add(c);
                if (!(c instanceof OverlayContainer)) continue;
                layoutOverlay = true;
                oc = (OverlayContainer)c;
                continue;
            }
            if (elemTag.equals("LayoutOverlayEquated")) {
                c = LayoutOverlayEquatedParser.load(this, (Element)node, true);
                if (c == null) continue;
                this.rootPanel.add(c);
                if (!(c instanceof OverlayContainer)) continue;
                layoutOverlay = true;
                oc = (OverlayContainer)c;
                continue;
            }
            if (elemTag.equals("LayoutOverlayMapTemp")) {
                c = LayoutOverlayMapTempParser.load(this, (Element)node, true);
                if (c == null) continue;
                this.rootPanel.add(c);
                if (!(c instanceof OverlayContainer)) continue;
                layoutOverlay = true;
                oc = (OverlayContainer)c;
                continue;
            }
            if (elemTag.equals("LayoutOverlayMap")) {
                c = LayoutOverlayMapParser.load(this, (Element)node, true);
                if (c == null) continue;
                this.rootPanel.add(c);
                if (!(c instanceof OverlayContainer)) continue;
                layoutOverlay = true;
                oc = (OverlayContainer)c;
                continue;
            }
            if (elemTag.equals("LayoutQCOverlay")) {
                c = StatGraph.parseThirdPartyComponent(this, (Element)node);
                if (c == null) continue;
                this.rootPanel.add(c);
                continue;
            }
            if (elemTag.equals("LayoutOverlay3D")) {
                this.rootPanel.add(LayoutOverlay3DParser.load(this, (Element)node));
                continue;
            }
            if (elemTag.equals("LayoutLattice")) {
                this.rootPanel.add((Component)LayoutLatticeParser.load(this, (Element)node));
                continue;
            }
            if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = (GridPanel)this.getObjectFromElement((Element)node);
                if (grid == null) {
                    grid = new GridPanel();
                }
                GridPanelParser.load(this, (Element)node, grid, this.rootPanel);
                this.rootPanel.add(grid);
                continue;
            }
            if (elemTag.equals("LayoutDataLattice")) {
                this.rootPanel.add((Component)LayoutDataLatticeParser.load(this, (Element)node));
                continue;
            }
            if (elemTag.equals("LayoutDataMatrix")) {
                this.rootPanel.add((Component)LayoutDataMatrixParser.load(this, (Element)node));
                continue;
            }
            if (elemTag.equals("LayoutDataPanel")) {
                this.rootPanel.add((Component)LayoutDataLatticeParser.load(this, (Element)node, true));
                continue;
            }
            if (!elemTag.equals("LayoutRegion") || (c = LayoutRegionParser.load(this, (Element)node)) == null) continue;
            this.rootPanel.add(c);
        }
        this.processAAMax();
        this.processTipMax();
        this.checkParsingStatus();
        FillAttrs fillStyle = new FillAttrs();
        GraphStyle.setDefaultFillStyle(this, null, fillStyle, "Backfill");
        Color bgColor = StatGraph.parseAttrColor("backgroundColor", this, elem);
        if (bgColor == null) {
            bgColor = fillStyle.getColor();
        }
        this.rootPanel.setBackground(bgColor);
        StatGraph.parseBorderOpts(this, this.rootPanel, elem, null);
        JComponent mainComp = this.rootPanel.getComponentCount() != 0 && this.rootPanel.getComponent(0) instanceof JComponent ? (JComponent)this.rootPanel.getComponent(0) : null;
        NodeList titleList = elem.getElementsByTagName("EntryTitle");
        nl = titleList.getLength();
        if (nl > 0) {
            Node nd;
            if (layoutOverlay) {
                for (int i10 = 0; i10 < nl; ++i10) {
                    nd = titleList.item(i10);
                    JComponent title = (JComponent)this.getObjectFromElement((Element)nd);
                    if (title == null) {
                        title = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd, title, oc, 1);
                    if (i10 == nl - 1) {
                        StatGraph.addDefaultOuterPad((Element)nd, title, new Insets(0, 0, StatGraph.getExtraPadding(), 0));
                    }
                    oc.addTitle(title);
                }
            } else if (mainComp instanceof TrellisPlot) {
                TrellisPlot trellis = (TrellisPlot)mainComp;
                if (!(trellis.getLayout() instanceof TrellisLayout)) {
                    trellis.setLayout((LayoutManager)new TrellisLayout());
                }
                for (int i11 = 0; i11 < nl; ++i11) {
                    Node nd2 = titleList.item(i11);
                    JComponent title = (JComponent)this.getObjectFromElement((Element)nd2);
                    if (title == null) {
                        title = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd2, title, (JComponent)trellis, 1);
                    if (i11 == nl - 1) {
                        StatGraph.addDefaultOuterPad((Element)nd2, title, new Insets(0, 0, StatGraph.getExtraPadding(), 0));
                    }
                    trellis.addTitle((Component)title);
                }
            } else {
                this.titlePanel = new GridPanel();
                if (mainComp != null) {
                    this.titlePanel.setBackground(mainComp.getBackground());
                }
                for (int i12 = 0; i12 < nl; ++i12) {
                    nd = titleList.item(i12);
                    JComponent title = (JComponent)this.getObjectFromElement((Element)nd);
                    if (title == null) {
                        title = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd, title, this.titlePanel, 1);
                    title.setAlignmentX(0.5f);
                    GridBagConstraints c = new GridBagConstraints();
                    c.weightx = 1.0;
                    c.fill = 2;
                    if (i12 == nl - 1) {
                        StatGraph.addDefaultOuterPad((Element)nd, title, new Insets(0, 0, StatGraph.getExtraPadding(), 0));
                    }
                    this.titlePanel.add((Component)title, c);
                }
                this.rootPanel.add((Component)this.titlePanel, "North");
            }
        }
        if ((nl = (footnoteList = elem.getElementsByTagName("EntryFootnote")).getLength()) > 0) {
            JComponent footnote;
            if (layoutOverlay) {
                for (int i13 = 0; i13 < nl; ++i13) {
                    Node nd = footnoteList.item(i13);
                    footnote = (JComponent)this.getObjectFromElement((Element)nd);
                    if (footnote == null) {
                        footnote = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd, footnote, oc, 2);
                    if (i13 == 0) {
                        StatGraph.addDefaultOuterPad((Element)nd, footnote, new Insets(StatGraph.getExtraPadding(), 0, 0, 0));
                    }
                    oc.addFootnote(footnote);
                }
            } else if (mainComp instanceof TrellisPlot) {
                TrellisPlot trellis = (TrellisPlot)mainComp;
                if (!(trellis.getLayout() instanceof TrellisLayout)) {
                    trellis.setLayout((LayoutManager)new TrellisLayout());
                }
                for (int i14 = 0; i14 < nl; ++i14) {
                    Node nd = footnoteList.item(i14);
                    JComponent footnote2 = (JComponent)this.getObjectFromElement((Element)nd);
                    if (footnote2 == null) {
                        footnote2 = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd, footnote2, (JComponent)trellis, 2);
                    if (i14 == 0) {
                        StatGraph.addDefaultOuterPad((Element)nd, footnote2, new Insets(StatGraph.getExtraPadding(), 0, 0, 0));
                    }
                    trellis.addFootnote((Component)footnote2);
                }
            } else {
                this.footnotePanel = new GridPanel();
                if (mainComp != null) {
                    this.footnotePanel.setBackground(mainComp.getBackground());
                }
                for (int i15 = 0; i15 < nl; ++i15) {
                    Node nd = footnoteList.item(i15);
                    footnote = (JComponent)this.getObjectFromElement((Element)nd);
                    if (footnote == null) {
                        footnote = new EntryComposite();
                    }
                    EntryConcatParser.load(this, (Element)nd, footnote, this.footnotePanel, 2);
                    footnote.setAlignmentX(0.5f);
                    GridBagConstraints c = new GridBagConstraints();
                    c.weightx = 1.0;
                    c.fill = 2;
                    if (i15 == 0) {
                        StatGraph.addDefaultOuterPad((Element)nd, footnote, new Insets(StatGraph.getExtraPadding(), 0, 0, 0));
                    }
                    this.footnotePanel.add((Component)footnote, c);
                }
                this.rootPanel.add((Component)this.footnotePanel, "South");
            }
        }
        if ((layoutGL = elem.getElementsByTagName("LayoutGlobalLegend")).getLength() == 0) {
            layoutGL = elem.getElementsByTagName("LayoutQCGlobalLegend");
            boolean bl = this.qcGlobalLegend = layoutGL.getLength() > 0;
        }
        if ((nl = (legendItemList = elem.getElementsByTagName("LegendItem")).getLength()) > 0) {
            for (int i16 = 0; i16 < nl; ++i16) {
                Node nd = legendItemList.item(i16);
                LegendItemParser.load(this, (Element)nd);
            }
        }
        if ((nl = (legendTextList = elem.getElementsByTagName("LegendTextItems")).getLength()) > 0) {
            for (int i17 = 0; i17 < nl; ++i17) {
                Node nd = legendTextList.item(i17);
                LegendItemParser.loadTextLegendItemList(this, (Element)nd);
            }
        }
        if (layoutGL.getLength() > 0 && (gl = GlobalLegend.load(this, globalLegendElem = (Element)layoutGL.item(0), this.rootPanel)) != null) {
            GridPanel grid;
            this.globalLegend = gl;
            JComponent glPanel = gl.getPanelComponent();
            if (gl.getPosition().equalsIgnoreCase("bottom")) {
                StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(StatGraph.getExtraPadding(), 0, 0, 0));
            } else if (gl.getPosition().equalsIgnoreCase("top")) {
                StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, 0, StatGraph.getExtraPadding(), 0));
            } else if (gl.getPosition().equalsIgnoreCase("left")) {
                StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, 0, 0, StatGraph.getExtraPadding()));
            } else if (gl.getPosition().equalsIgnoreCase("right")) {
                StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, StatGraph.getExtraPadding(), 0, 0));
            }
            boolean ok = gl.resolveGlobalLegends(this);
            Dimension ps = glPanel.getPreferredSize();
            if (!ok) {
                glPanel.removeAll();
                glPanel.setVisible(false);
            } else if ((double)(ps.width * ps.height) > this.maxTotalLegendArea * (double)this.size.width * (double)this.size.height) {
                if (this.maxTotalLegendArea > 0.0) {
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "legendsize.txt"), false);
                    glPanel.removeAll();
                    glPanel.setVisible(false);
                }
            } else if (layoutOverlay) {
                oc.addGlobalLegend(glPanel, gl.getPosition());
            } else if (mainComp instanceof TrellisPlot) {
                TrellisPlot trellis = (TrellisPlot)mainComp;
                trellis.setGlobalLegendSpacing(0);
                trellis.addGlobalLegend(glPanel, gl.getPosition());
            } else if (gl.getPosition().equals("bottom")) {
                if (this.footnotePanel != null) {
                    this.footnotePanel.add(glPanel, gl.getConstraints(), 0);
                } else {
                    grid = new GridPanel();
                    grid.add((Component)glPanel, gl.getConstraints());
                    this.rootPanel.add((Component)grid, "South");
                }
            } else if (gl.getPosition().equals("top")) {
                if (this.titlePanel != null) {
                    this.titlePanel.add((Component)glPanel, gl.getConstraints());
                } else {
                    grid = new GridPanel();
                    grid.add((Component)glPanel, gl.getConstraints());
                    this.rootPanel.add((Component)grid, "North");
                }
            } else if (gl.getPosition().equals("left")) {
                grid = new GridPanel();
                grid.add((Component)glPanel, gl.getConstraints());
                this.rootPanel.add((Component)grid, "West");
            } else {
                grid = new GridPanel();
                grid.add((Component)glPanel, gl.getConstraints());
                this.rootPanel.add((Component)grid, "East");
            }
        }
        this.resolveCrossRefs();
        SGAnnotationContainer ac = mainComp == null ? new SGAnnotationContainer(this.rootPanel, this.rootPanel) : new SGAnnotationContainer(mainComp, this.rootPanel);
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            AbstractAnno text;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).startsWith("Draw") || (text = AnnotateParser.load(this, (Element)node, (AnnotationContainer)ac)) == null) continue;
            if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                this.annotationInBackList.add(text);
                continue;
            }
            this.annotationInFrontList.add(text);
        }
        block18: for (i = 1; i < this.annotationInBackList.size(); ++i) {
            anno = this.annotationInBackList.get(i);
            index = anno.getIndex();
            if (index == -1) continue;
            for (int j = 0; j < i; ++j) {
                int jindex = this.annotationInBackList.get(j).getIndex();
                if (jindex != -1 && jindex <= index) continue;
                this.annotationInBackList.remove(i);
                this.annotationInBackList.add(j, anno);
                continue block18;
            }
        }
        for (i = 0; i < this.annotationInBackList.size(); ++i) {
            anno = this.annotationInBackList.get(i);
            anno.setIndex(i);
        }
        block21: for (i = 1; i < this.annotationInFrontList.size(); ++i) {
            anno = this.annotationInFrontList.get(i);
            index = anno.getIndex();
            if (index == -1) continue;
            for (int j = 0; j < i; ++j) {
                int jindex = this.annotationInFrontList.get(j).getIndex();
                if (jindex != -1 && jindex <= index) continue;
                this.annotationInFrontList.remove(i);
                this.annotationInFrontList.add(j, anno);
                continue block21;
            }
        }
        for (i = 0; i < this.annotationInFrontList.size(); ++i) {
            anno = this.annotationInFrontList.get(i);
            anno.setIndex(i);
        }
        StatGraph.parsingDone();
        return true;
    }

    public boolean reloadGlobalLegend(Element elem) {
        NodeList legendTextList;
        NodeList legendItemList;
        int nl;
        if (this.globalLegend == null) {
            return true;
        }
        JComponent oldGlPanel = this.globalLegend.getPanelComponent();
        if (!oldGlPanel.isVisible()) {
            return true;
        }
        Container c = oldGlPanel.getParent();
        boolean layoutOverlay = false;
        OverlayContainer oc = null;
        TrellisPlot trellis = null;
        if (c instanceof OverlayContainer) {
            layoutOverlay = true;
            oc = (OverlayContainer)c;
        } else if (c instanceof TrellisPlot) {
            trellis = (TrellisPlot)c;
        }
        NodeList layoutGL = elem.getElementsByTagName("LayoutGlobalLegend");
        if (layoutGL.getLength() == 0) {
            layoutGL = elem.getElementsByTagName("LayoutQCGlobalLegend");
            boolean bl = this.qcGlobalLegend = layoutGL.getLength() > 0;
        }
        if ((nl = (legendItemList = elem.getElementsByTagName("LegendItem")).getLength()) > 0) {
            for (int i = 0; i < nl; ++i) {
                Node nd = legendItemList.item(i);
                LegendItemParser.load(this, (Element)nd);
            }
        }
        if ((nl = (legendTextList = elem.getElementsByTagName("LegendTextItems")).getLength()) > 0) {
            for (int i = 0; i < nl; ++i) {
                Node nd = legendTextList.item(i);
                LegendItemParser.loadTextLegendItemList(this, (Element)nd);
            }
        }
        if (layoutGL.getLength() > 0) {
            Element globalLegendElem = (Element)layoutGL.item(0);
            GlobalLegend gl = GlobalLegend.load(this, globalLegendElem, this.rootPanel);
            if (gl != null) {
                JComponent glPanel = gl.getPanelComponent();
                if (gl.getPosition().equalsIgnoreCase("bottom")) {
                    StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(StatGraph.getExtraPadding(), 0, 0, 0));
                } else if (gl.getPosition().equalsIgnoreCase("top")) {
                    StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, 0, StatGraph.getExtraPadding(), 0));
                } else if (gl.getPosition().equalsIgnoreCase("left")) {
                    StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, 0, 0, StatGraph.getExtraPadding()));
                } else if (gl.getPosition().equalsIgnoreCase("right")) {
                    StatGraph.addDefaultOuterPad(globalLegendElem, glPanel, new Insets(0, StatGraph.getExtraPadding(), 0, 0));
                }
                boolean ok = gl.resolveGlobalLegends(this);
                Dimension ps = glPanel.getPreferredSize();
                if (!ok) {
                    glPanel.removeAll();
                    glPanel.setVisible(false);
                    return false;
                }
                if ((double)(ps.width * ps.height) > this.maxTotalLegendArea * (double)this.size.width * (double)this.size.height) {
                    if (this.maxTotalLegendArea > 0.0) {
                        StatGraph.printNote(RB.getStringResource(RB_KEY, "legendsize.txt"), false);
                        glPanel.removeAll();
                        glPanel.setVisible(false);
                        return false;
                    }
                } else if (layoutOverlay) {
                    oc.removeGlobalLegend(oldGlPanel);
                    oc.addGlobalLegend(glPanel, gl.getPosition());
                } else if (c instanceof TrellisPlot) {
                    trellis = (TrellisPlot)c;
                    trellis.removeGlobalLegend(oldGlPanel);
                    trellis.setGlobalLegendSpacing(0);
                    trellis.addGlobalLegend(glPanel, gl.getPosition());
                } else if (gl.getPosition().equals("bottom") && this.footnotePanel != null) {
                    this.footnotePanel.remove(oldGlPanel);
                    this.footnotePanel.add(glPanel, gl.getConstraints(), 0);
                } else if (gl.getPosition().equals("top") && this.titlePanel != null) {
                    this.titlePanel.remove(oldGlPanel);
                    this.titlePanel.add((Component)glPanel, gl.getConstraints());
                } else {
                    c.remove(oldGlPanel);
                    c.add((Component)glPanel, gl.getConstraints());
                }
            }
            this.globalLegend = gl;
        }
        this.resolveCrossRefs();
        return true;
    }

    public static JComponent parseComponent(StatGraph graph, Element elem, JComponent panel) {
        return StatGraph.parseComponent(graph, elem, panel, null, null);
    }

    public static JComponent parseComponent(StatGraph graph, Element elem, JComponent panel, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        String elemTag = elem.getTagName();
        Object comp = null;
        if (elemTag.equals("Entry")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new EntryComposite();
            }
            EntryConcatParser.load(graph, elem, (JComponent)comp, panel, 0);
        } else if (elemTag.equals("IntervalHeader")) {
            comp = new StripLabel("");
            StripLabelParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new Legend();
            }
            LegendParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("ContinuousLegend")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new LegendComponent();
            }
            LegendParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("SizeLegend")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new SizeLegendComponent();
            }
            SizeLegendParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("AxisLegend")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new AxisLegend();
            }
            AxisLegendParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("GTable")) {
            if (comp == null) {
                comp = new Table();
            }
            TableParser.load(graph, elem, (JComponent)comp, panel);
        } else if (elemTag.equals("LayoutOverlay") || elemTag.equals("LayoutPrototype") || elemTag.equals("LayoutPrototypeOverlay2D")) {
            comp = LayoutOverlayParser.load(graph, elem, rowColumnAxesType, rowColumn2AxesType);
        } else if (elemTag.equals("LayoutOverlayExtruded") || elemTag.equals("LayoutPrototypeExtruded")) {
            comp = LayoutOverlayExtrudedParser.load(graph, elem, rowColumnAxesType, rowColumn2AxesType);
        } else if (elemTag.equals("LayoutOverlayEquated")) {
            comp = LayoutOverlayEquatedParser.load(graph, elem);
        } else if (elemTag.equals("LayoutOverlayMapTemp")) {
            comp = LayoutOverlayMapTempParser.load(graph, elem);
        } else if (elemTag.equals("LayoutOverlayMap")) {
            comp = LayoutOverlayMapParser.load(graph, elem);
        } else if (elemTag.equals("LayoutQCOverlay")) {
            comp = StatGraph.parseThirdPartyComponent(graph, elem);
        } else if (elemTag.equals("LayoutOverlay3D") || elemTag.equals("LayoutPrototype3D")) {
            comp = LayoutOverlay3DParser.load(graph, elem);
        } else if (elemTag.equals("LayoutGridded")) {
            comp = (JComponent)graph.getObjectFromElement(elem);
            if (comp == null) {
                comp = new GridPanel();
            }
            GridPanelParser.load(graph, elem, (JComponent)comp, panel);
        } else {
            comp = elemTag.equals("LayoutLattice") ? LayoutLatticeParser.load(graph, elem) : (elemTag.equals("LayoutDataLattice") ? LayoutDataLatticeParser.load(graph, elem) : (elemTag.equals("LayoutDataMatrix") ? LayoutDataMatrixParser.load(graph, elem) : (elemTag.equals("LayoutDataPanel") ? LayoutDataLatticeParser.load(graph, elem, true) : (elemTag.equals("LayoutRegion") || elemTag.equals("LayoutPrototypeRegion") ? LayoutRegionParser.load(graph, elem) : (elemTag.equals("ScatterPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 0, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("TextPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 30, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("SeriesPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 1, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("StepPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 2, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("NeedlePlot") ? LayoutOverlayParser.loadPlot(graph, elem, 3, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("VectorPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 4, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("LineParm") ? LayoutOverlayParser.loadPlot(graph, elem, 5, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("ReferenceLine") ? LayoutOverlayParser.loadPlot(graph, elem, 16, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("DropLine") ? LayoutOverlayParser.loadPlot(graph, elem, 17, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("EllipseParm") ? LayoutOverlayParser.loadPlot(graph, elem, 12, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("BandPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 6, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("HistogramParm") ? LayoutOverlayParser.loadPlot(graph, elem, 7, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("ContourPlotParm") ? LayoutOverlayParser.loadPlot(graph, elem, 9, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("BarChartParm") || elemTag.equals("BarParm") ? LayoutOverlayParser.loadPlot(graph, elem, 11, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("ParetoLine") ? LayoutOverlayParser.loadPlot(graph, elem, 19, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("HeatmapParm") ? LayoutOverlayParser.loadPlot(graph, elem, 20, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("WaterfallChart") ? LayoutOverlayParser.loadPlot(graph, elem, 21, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("Dendrogram") ? LayoutOverlayParser.loadPlot(graph, elem, 22, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("BubblePlot") ? LayoutOverlayParser.loadPlot(graph, elem, 23, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("PieChartParm") || elemTag.equals("PieParm") || elemTag.equals("PieChart") ? PieParser2.load(graph, elem) : (elemTag.equals("PathDiagram") ? PathDiagramParser.load(graph, elem) : (elemTag.equals("DecisionTree") ? DecisionTreeParser.load(graph, elem) : (elemTag.equalsIgnoreCase("TreeMap") ? TileParser.load(graph, elem) : (elemTag.equalsIgnoreCase("MosaicPlotParm") ? MosaicParser.load(graph, elem) : (elemTag.equals("KPIParm") || elemTag.equals("KPIChart") ? KPIParser.load(graph, elem) : (elemTag.equals("FringePlot") ? LayoutOverlayParser.loadPlot(graph, elem, 13, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("BlockPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 18, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("AxisTable") ? LayoutOverlayParser.loadPlot(graph, elem, 28, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("SurfacePlotParm") ? LayoutOverlay3DParser.loadPlot(graph, elem, 10) : (elemTag.equals("BiHistogram3DParm") ? LayoutOverlay3DParser.loadPlot(graph, elem, 8) : (elemTag.equals("BoxPlotParm") ? LayoutOverlayParser.loadPlot(graph, elem, 14, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("HighLowPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 24, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("HeatBoxParm") ? LayoutOverlayParser.loadPlot(graph, elem, 31, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("LineChart") ? LayoutOverlayParser.loadPlot(graph, elem, 25, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("TimeSeriesPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 27, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("RangeAttrMapView") ? LayoutOverlayParser.loadPlot(graph, elem, 26, rowColumnAxesType, rowColumn2AxesType) : (elemTag.equals("ScatterPlotMatrix") ? ScatterMatrixParser.load(graph, elem) : (elemTag.equals("PolygonPlot") ? LayoutOverlayParser.loadPlot(graph, elem, 29, rowColumnAxesType, rowColumn2AxesType) : (JComponent)graph.getObjectFromElement(elem)))))))))))))))))))))))))))))))))))))))))));
        }
        return comp;
    }

    public static boolean isValidVar(String s) {
        return s.indexOf(modelSeparator) >= 0;
    }

    public static String getVarID(String s) {
        String name = s.substring(s.indexOf(modelSeparator) + 1);
        if (!StatGraph.isOLAP()) {
            name = name.toUpperCase();
        }
        return name;
    }

    public static String getDataName(String s) {
        int i = s.indexOf(modelSeparator);
        if (i > 0) {
            return s.substring(0, i);
        }
        return new String("");
    }

    public void addData(DataModel data) {
        olapGraph = false;
        this.dataModelList.add(data);
    }

    public DataModel getData(String name) {
        for (int i = 0; i < this.dataModelList.size(); ++i) {
            DataModel d = (DataModel)this.dataModelList.get(i);
            if (!d.name.equalsIgnoreCase(name)) continue;
            return d;
        }
        return null;
    }

    public void addMapProvider(AbstractMapProvider mp) {
        this.mapProviders.put(mp.getName(), mp);
    }

    public AbstractMapProvider getMapProvider(String name) {
        return (AbstractMapProvider)this.mapProviders.get(name);
    }

    public void addOLAPModel(String name, OLAPDataSetInterface olap) {
        olapGraph = true;
        DataModel dm = new DataModel(name);
        dm.setOLAPData(olap);
        this.olapData.add(dm);
    }

    public DataModel getOLAPModel(String name) {
        for (int i = 0; i < this.olapData.size(); ++i) {
            DataModel d = (DataModel)this.olapData.get(i);
            if (!d.name.equalsIgnoreCase(name)) continue;
            return d;
        }
        return null;
    }

    public boolean isValidDiscreteLegend(Legend legend) {
        String[] plots = legend.getGraphNames();
        if (plots != null) {
            for (int i = 0; i < plots.length; ++i) {
                Object graph;
                if (this.graphNamesTable.containsKey(plots[i])) {
                    graph = this.graphNamesTable.get(plots[i]);
                    if (plots.length == 1 && legend.isAutoLegend() && graph instanceof AutoLegendInterface && ((AutoLegendInterface)graph).isDegeneratedLegendContributor()) continue;
                    if (graph instanceof Overlay && ((Overlay)graph).isGroupAllMissings()) {
                        legend.printWarningForGroupAllMissings(plots[i]);
                        continue;
                    }
                    if (legend.getLegendItems(graph) != null) {
                        return true;
                    }
                }
                if (this.legendItemsTable.containsKey(plots[i]) && legend.getLegendItems(graph = this.legendItemsTable.get(plots[i])) != null) {
                    return true;
                }
                if (this.legendTextItemsTable.containsKey(plots[i]) && legend.getLegendItems(graph = this.legendTextItemsTable.get(plots[i])) != null) {
                    return true;
                }
                if (!this.discreteAttrMapTable.containsKey(plots[i]) || legend.getLegendItems(graph = this.discreteAttrMapTable.get(plots[i])) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void validateMergedLegend(Legend legend) {
        if (!legend.isMergedLegend()) {
            return;
        }
        String[] plots = legend.getGraphNames();
        if (plots != null) {
            if (plots.length >= 2) {
                if (!this.graphNamesTable.containsKey(plots[0]) || !this.graphNamesTable.containsKey(plots[1])) {
                    legend.setMergedLegend(false);
                }
            } else {
                legend.setMergedLegend(false);
            }
        }
    }

    private int getDiscreteLegendCount() {
        int cnt = 0;
        for (Object key : this.graphNamesRefs.keySet()) {
            Legend legend;
            if (!(key instanceof Legend) || !this.isValidDiscreteLegend(legend = (Legend)key)) continue;
            ++cnt;
        }
        return cnt;
    }

    private int getAxisLegendCount() {
        return this.axisNamesRefs.size();
    }

    protected void resolveCrossRefs() {
        Container container;
        Iterator e = this.graphNamesRefs.keySet().iterator();
        int legendCount = this.getDiscreteLegendCount();
        while (e.hasNext()) {
            Object key = e.next();
            if (key instanceof Overlay) {
                String gid = (String)this.graphNamesRefs.get(key);
                Object ref = this.graphNamesTable.get(gid);
                StatGraph.resolveModelRefs((Overlay)key, (Overlay)ref);
                continue;
            }
            if (key instanceof Legend) {
                Legend legend = (Legend)key;
                legend.setSubpixelRendering(this.subpixelRendering);
                if (legend.isGlobalLegend()) continue;
                if (this.globalLegend != null && this.globalLegend.getPanelComponent().isVisible()) {
                    StatGraph.printWarning(RB.getStringResource(RB_KEY, "globallegend.txt"));
                    legend.setVisible(false);
                    if (legend.getParent() == null) continue;
                    legend.getParent().remove(legend);
                    continue;
                }
                if (this.isValidDiscreteLegend(legend)) {
                    boolean merged = legend.isMergedLegend();
                    this.validateMergedLegend(legend);
                    if (this.equatedPlots != null && this.equatedPlots.size() > 0) {
                        String[] plotIDs = (String[])this.graphNamesRefs.get(legend);
                        for (int i = 0; i < plotIDs.length; ++i) {
                            Object plot = this.graphNamesTable.get(plotIDs[i]);
                            if (plot == null || !this.equatedPlots.contains(plot)) continue;
                            legend.repositionTitle = false;
                            break;
                        }
                    }
                    HashMap legendNamesTable = this.getLegendNamesTable(legend);
                    legend.resolveReferences(this.graphNamesRefs, legendNamesTable);
                    if (merged != legend.isMergedLegend()) {
                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "mergedlegend.txt"));
                        legend.setVisible(false);
                        if (legend.getParent() == null) continue;
                        legend.getParent().remove(legend);
                        continue;
                    }
                    if (legend.getComponentCount() == 0) {
                        legend.setVisible(false);
                        if (legend.getParent() == null) continue;
                        legend.getParent().remove(legend);
                        continue;
                    }
                    if (legend.getComponentCount() > 512) {
                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "legendnum.txt"));
                        legend.setVisible(false);
                        if (legend.getParent() == null) continue;
                        legend.getParent().remove(legend);
                        continue;
                    }
                    double threshold = this.maxTotalLegendArea * (double)this.size.width * (double)this.size.height / (double)legendCount;
                    Dimension ps = legend.getPreferredSize();
                    if ((double)(ps.width * ps.height) > threshold) {
                        if (legend.getParent() == null) continue;
                        if (this.maxTotalLegendArea > 0.0) {
                            StatGraph.printNote(RB.getStringResource(RB_KEY, "legendsize.txt"), false);
                            legend.setVisible(false);
                        }
                        legend.getParent().remove(legend);
                        continue;
                    }
                    Component[] legends = new Legend[]{legend};
                    Container container2 = legend.getParent();
                    if (!(container2 instanceof GridPanel)) continue;
                    GridPanelParser.resolveReferences(container2, legend, legends);
                    continue;
                }
                legend.setVisible(false);
                continue;
            }
            if (key instanceof LegendComponent) {
                LegendComponent lc = (LegendComponent)key;
                VLegend legend = lc.getLegend();
                String[] gids = (String[])this.graphNamesRefs.get(key);
                Object ref = this.graphNamesTable.get(gids[0]);
                container = lc.getParent();
                if (ref != null && StatGraph.resolveLegendRefs(legend, ref)) {
                    Component[] legends = new LegendComponent[]{lc};
                    if (container instanceof OverlayContainer) {
                        LayoutOverlayParser.resolveReferences(container, lc, legends);
                        continue;
                    }
                    if (container instanceof GridPanel) {
                        GridPanelParser.resolveReferences(container, lc, legends);
                        continue;
                    }
                    if (!(container instanceof TrellisPlot)) continue;
                    LayoutLatticeParser.resolveReferences(container, lc, legends);
                    continue;
                }
                Message msg = new Message(RB.getStringResource(RB_KEY, "legend.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)gids[0]));
                if (container == null) continue;
                container.remove(lc);
                continue;
            }
            if (!(key instanceof SizeLegendComponent)) continue;
            SizeLegendComponent sizeLegend = (SizeLegendComponent)key;
            String[] gids = (String[])this.graphNamesRefs.get(key);
            Object ref = this.graphNamesTable.get(gids[0]);
            Container container3 = sizeLegend.getParent();
            if (ref != null && StatGraph.resolveLegendRefs(sizeLegend, ref)) {
                Component[] legends = new SizeLegendComponent[]{sizeLegend};
                if (container3 instanceof RegionContainer) {
                    LayoutRegionParser.resolveReferences(container3, sizeLegend, legends);
                    continue;
                }
                if (container3 instanceof GridPanel) {
                    GridPanelParser.resolveReferences(container3, sizeLegend, legends);
                    continue;
                }
                if (!(container3 instanceof TrellisPlot)) continue;
                LayoutLatticeParser.resolveReferences(container3, sizeLegend, legends);
                continue;
            }
            Message msg = new Message(RB.getStringResource(RB_KEY, "sizeLegend.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)gids[0]));
            container3.remove(sizeLegend);
        }
        e = this.axisNamesRefs.keySet().iterator();
        boolean xAxisLegend = this.isAxisLegendNeeded(1);
        boolean yAxisLegend = this.isAxisLegendNeeded(2);
        while (e.hasNext()) {
            Object key = e.next();
            if (!(key instanceof AxisLegend)) continue;
            AxisLegend al = (AxisLegend)key;
            String aid = (String)this.axisNamesRefs.get(key);
            if (this.axisNamesTable.get(aid) instanceof VRectAxis) {
                VRectAxis axis = (VRectAxis)this.axisNamesTable.get(aid);
                if (this.extractAxisLegend(axis, xAxisLegend, yAxisLegend)) {
                    al.addAxis(axis);
                    al.build();
                    continue;
                }
                al.setVisible(false);
                Container container4 = al.getParent();
                if (container4 == null) continue;
                container4.remove(al);
                continue;
            }
            if (this.axisNamesTable.containsKey(aid)) {
                ArrayList axes = (ArrayList)this.axisNamesTable.get(aid);
                boolean axisLegend = this.extractAxisLegend(axes, xAxisLegend, yAxisLegend);
                for (int i = 0; i < axes.size(); ++i) {
                    VRectAxis axis = (VRectAxis)axes.get(i);
                    if (axis == null) continue;
                    if (axisLegend) {
                        al.addAxis(axis);
                        continue;
                    }
                    al.setVisible(false);
                    Container container5 = al.getParent();
                    if (container5 == null) break;
                    container5.remove(al);
                    break;
                }
                if (!axisLegend) continue;
                al.build();
                continue;
            }
            al.setVisible(false);
            container = al.getParent();
            if (container == null) continue;
            container.remove(al);
        }
    }

    public HashMap getLegendNamesTable(Legend legend) {
        HashMap table = new HashMap();
        String[] graphIDs = legend.getGraphNames();
        for (int i = 0; i < graphIDs.length; ++i) {
            Object graph = this.graphNamesTable.get(graphIDs[i]);
            if (graph == null && this.legendItemsTable != null) {
                graph = this.legendItemsTable.get(graphIDs[i]);
            }
            if (graph == null && this.legendTextItemsTable != null) {
                graph = this.legendTextItemsTable.get(graphIDs[i]);
            }
            if (graph == null && this.discreteAttrMapTable != null) {
                graph = this.discreteAttrMapTable.get(graphIDs[i]);
            }
            if (graph == null) continue;
            table.put(graphIDs[i], graph);
        }
        return table;
    }

    private boolean extractAxisLegend(VRectAxis axis, boolean xLegend, boolean yLegend) {
        if (axis == null || axis.getType() != 6 || axis.getAxisLegendFitPolicy() == 0) {
            return false;
        }
        if (axis.getAxisLegendFitPolicy() == 2) {
            return true;
        }
        return axis.getDimension() == 1 ? xLegend : yLegend;
    }

    private boolean extractAxisLegend(ArrayList axes, boolean xLegend, boolean yLegend) {
        for (int i = 0; i < axes.size(); ++i) {
            VRectAxis axis = (VRectAxis)axes.get(i);
            if (!this.extractAxisLegend(axis, xLegend, yLegend)) continue;
            return true;
        }
        return false;
    }

    private boolean isAxisLegendNeeded(int dim) {
        int len = this.getMinAxesLength(dim);
        int dimLen = dim == 1 ? this.size.width : this.size.height;
        double fudge = 0.875;
        return (double)len > fudge * (double)dimLen;
    }

    private int getMinAxisLength(VRectAxis axis) {
        FontMetrics fm = StatGraph.getFontMetrics(axis.getAxisStyle().getLabelStyle().getFont());
        DiscreteRange dr = (DiscreteRange)axis.getDataRange(axis.getDimension());
        String maxString = "";
        int len = 0;
        Vector values = dr.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String str;
            if (!(values.get(i) instanceof String) || (str = (String)values.get(i)).length() <= len) continue;
            len = str.length();
            maxString = str;
        }
        int tickSpace = axis.getDimension() == 1 ? fm.stringWidth(valueSeparator + maxString + valueSeparator) : fm.getHeight();
        int num = dr.getValuesSize();
        return tickSpace * num;
    }

    private int getMinAxesLength(int dim) {
        Object[] axes = this.axisNamesTable.values().toArray();
        int minLen = 0;
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] == null) continue;
            if (axes[i] instanceof VRectAxis) {
                VRectAxis axis = (VRectAxis)axes[i];
                if (axis.getType() != 6 || axis.getDimension() != dim) continue;
                minLen += this.getMinAxisLength(axis);
                continue;
            }
            ArrayList al = (ArrayList)axes[i];
            for (int j = 0; j < al.size(); ++j) {
                VRectAxis axis = (VRectAxis)al.get(j);
                if (axis.getType() != 6 || axis.getDimension() != dim) continue;
                minLen += this.getMinAxisLength(axis);
            }
        }
        return minLen;
    }

    private static void resolveModelRefs(Overlay o1, Overlay o2) {
        if (o1 instanceof BandOverlay) {
            BandOverlay band = (BandOverlay)o1;
            if (o2 instanceof ScatterOverlay) {
                ScatterOverlay plot = (ScatterOverlay)o2;
                if (plot.getPlotType() == 3) {
                    band.setStepJoinVisible(plot.isStepJoinVisible());
                    switch (plot.getStepPlacement()) {
                        default: {
                            band.setJoinType((byte)1);
                            break;
                        }
                        case 1: {
                            band.setJoinType((byte)2);
                            break;
                        }
                        case 2: {
                            band.setJoinType((byte)3);
                            break;
                        }
                    }
                } else {
                    band.setJoinType((byte)0);
                }
            }
        }
    }

    private static boolean resolveLegendRefs(VLegend legend, Overlay graph) {
        boolean ok = true;
        if (graph instanceof OContour) {
            OContour contour = (OContour)graph;
            if (contour.hasAreaFill || contour.hasSmoothFill) {
                Color[] ramp = contour.rampColors;
                ContinuousRange cr = (ContinuousRange)contour.getDataRange((byte)3);
                ColorEncoder ce = new ColorEncoder(new ContinuousRange(cr.getMin(), cr.getMax()), ramp[0], ramp[1], ramp[ramp.length - 1]);
                legend.colorRamp = contour.getColorRamp();
                legend.goodLevels = contour.numLevHint;
                legend.levels = contour.getLevels();
                legend.setSmooth(contour.hasSmoothFill);
                legend.setColorEncoder(ce);
            } else {
                ok = false;
            }
        } else if (graph instanceof SurfaceOverlay) {
            SurfaceOverlay surface = (SurfaceOverlay)graph;
            ColorEncoder ce = (ColorEncoder)surface.getEncoder((byte)4);
            if (ce != null) {
                legend.setSmooth(true);
                legend.setColorEncoder(ce);
            }
        } else if (graph instanceof ScatterOverlay) {
            ScatterOverlay plot = (ScatterOverlay)graph;
            ColorEncoder ce = (ColorEncoder)plot.getEncoder((byte)16);
            if (ce != null && ce.getInput() instanceof ContinuousRange) {
                legend.setSmooth(true);
                legend.setColorEncoder(ce);
            } else {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean resolveLegendRefs(VLegend legend, Object graph) {
        boolean ok = true;
        if (graph instanceof ContinuousLegendInterface) {
            Range[] ranges = ((ContinuousLegendInterface)graph).getColorModelRanges(0);
            if (ranges != null) {
                legend.setValueFormat(((ContinuousLegendInterface)graph).getContinuousLegendFormat());
                legend.setColorModelRanges(ranges);
                legend.setPlotHasMissingData(((ContinuousLegendInterface)graph).hasMissingValue());
                legend.setMissingColor(((ContinuousLegendInterface)graph).getMissingColor());
                legend.setMissingChickletLabel(missingOption);
                if (legend.isAutoTitle() && graph instanceof AutoContinuousLegendInterface) {
                    legend.setTitle(((AutoContinuousLegendInterface)graph).getDefaultContinuousLegendTitle());
                }
            } else {
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public static boolean resolveLegendRefs(SizeLegendComponent sizeLegend, Object graph) {
        boolean ok = true;
        if (graph instanceof SizeLegendInterface) {
            SizeLegendInterface sli = (SizeLegendInterface)graph;
            sizeLegend.setItemFillColor(sli.getItemFillColor());
            sizeLegend.setItemOutlineColor(sli.getItemOutlineColor());
            if (sizeLegend.isAutoTitle() && graph instanceof AutoContinuousLegendInterface) {
                sizeLegend.setTitle(((AutoContinuousLegendInterface)graph).getDefaultContinuousLegendTitle());
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public static boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isFontSize(String str) {
        if (str.endsWith("pt")) {
            return true;
        }
        return StatGraph.isNumber(str);
    }

    public static boolean isMarkerSize(String str) {
        if (str.endsWith("px")) {
            return true;
        }
        return StatGraph.isNumber(str);
    }

    public static boolean isLineThickness(String str) {
        if (str.endsWith("px")) {
            return true;
        }
        return StatGraph.isNumber(str);
    }

    public static void parseBorderOpts(StatGraph graph, JComponent comp, Element elem, Color back) {
        String str;
        boolean graphArea = elem.getNodeName().equals("StatGraph");
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (graphArea) {
            left = top = graph.unit2GapThickness("10px");
            bottom = top;
            right = top;
        }
        if (StatGraph.isLineThickness(str = elem.getAttribute("pad"))) {
            left = top = graph.unit2GapThickness(str);
            bottom = top;
            right = top;
        } else {
            Element padAttrs = StatGraph.getOptionAttrsElement(elem, "PadAttrs");
            if (padAttrs != null) {
                str = padAttrs.getAttribute("top");
                if (StatGraph.isLineThickness(str)) {
                    top = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("left"))) {
                    left = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("bottom"))) {
                    bottom = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("right"))) {
                    right = graph.unit2GapThickness(str);
                }
            }
        }
        Insets outerPad = new Insets(0, 0, 0, 0);
        str = elem.getAttribute("outerPad");
        if (str.length() > 0) {
            if (StatGraph.isLineThickness(str)) {
                outerPad.left = outerPad.top = graph.unit2GapThickness(str);
                outerPad.bottom = outerPad.top;
                outerPad.right = outerPad.top;
            } else if (!str.equalsIgnoreCase("auto")) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "outerpad.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            }
        } else {
            Element padAttrs = StatGraph.getOptionAttrsElement(elem, "OuterPadAttrs");
            if (padAttrs != null) {
                str = padAttrs.getAttribute("top");
                if (StatGraph.isLineThickness(str)) {
                    outerPad.top = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("left"))) {
                    outerPad.left = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("bottom"))) {
                    outerPad.bottom = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("right"))) {
                    outerPad.right = graph.unit2GapThickness(str);
                }
            }
        }
        boolean borderOn = graphArea || comp instanceof Legend || comp instanceof AxisLegend;
        str = elem.getAttribute("border");
        if (str.length() > 0) {
            borderOn = str.equalsIgnoreCase("true");
        } else if ((comp instanceof Legend || comp instanceof AxisLegend || comp instanceof LegendComponent || comp instanceof SizeLegendComponent || elem.getNodeName().equals("LayoutGlobalLegend")) && (str = graph.style.getStyleAttribute("LegendFill", "frameBorder")) != null && str.length() > 0) {
            borderOn = str.equalsIgnoreCase("true");
        }
        Border border = null;
        if (borderOn) {
            LineAttrs borderStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("borderAttrs"), borderStyle, "BorderLines");
            Element ba = StatGraph.getOptionAttrsElement(elem, "BorderAttrs");
            if (ba != null) {
                StatGraph.parseLineAttrs(graph, ba, borderStyle);
            }
            Color bc = borderStyle.getColor();
            int bp = borderStyle.getLinePattern();
            int bt = borderStyle.getWidth();
            border = back != null ? BorderFactory.createCompoundBorder(new StyledLineBorder(bc, bp, bt), BorderFactory.createMatteBorder(top, left, bottom, right, back)) : BorderFactory.createCompoundBorder(new StyledLineBorder(bc, bp, bt), BorderFactory.createEmptyBorder(top, left, bottom, right));
        } else {
            border = back != null ? BorderFactory.createMatteBorder(top, left, bottom, right, back) : BorderFactory.createEmptyBorder(top, left, bottom, right);
        }
        Border wholeBorder = border;
        if (outerPad.top != 0 || outerPad.left != 0 || outerPad.bottom != 0 || outerPad.right != 0) {
            OuterPadBorder outerPadBorder = new OuterPadBorder(outerPad.top, outerPad.left, outerPad.bottom, outerPad.right);
            wholeBorder = BorderFactory.createCompoundBorder((Border)outerPadBorder, border);
        }
        JComponent theBorderedComp = graphArea ? graph.rootPanel : comp;
        theBorderedComp.setBorder(wholeBorder);
    }

    public void addLegendItem(String name, LegendItem item) {
        if (this.legendItemsTable != null) {
            this.legendItemsTable.put(name, item);
        }
    }

    public LegendItem getLegendItem(String name) {
        if (name == null) {
            return null;
        }
        return (LegendItem)this.legendItemsTable.get(name);
    }

    public void addLegendTextItemList(String name, LegendTextItemList list) {
        if (this.legendTextItemsTable != null) {
            this.legendTextItemsTable.put(name, list);
        }
    }

    public LegendTextItemList getLegendTextItemList(String name) {
        if (name == null) {
            return null;
        }
        return (LegendTextItemList)this.legendTextItemsTable.get(name);
    }

    public void addNamedGraph(String name, Overlay chart) {
        if (this.graphNamesTable != null) {
            this.graphNamesTable.put(name, chart);
        }
    }

    public void addNamedRegion(String name, Region chart) {
        if (this.graphNamesTable != null) {
            this.graphNamesTable.put(name, chart);
        }
    }

    public void removeNamedGraph(Overlay chart) {
        if (this.graphNamesTable != null) {
            for (Object key : this.graphNamesTable.keySet()) {
                if (this.graphNamesTable.get(key) != chart) continue;
                this.graphNamesTable.remove(key);
                break;
            }
        }
    }

    public void addGraphReference(Object obj, Object reference) {
        if (this.graphNamesRefs != null) {
            this.graphNamesRefs.put(obj, reference);
        }
    }

    public boolean isNamedAxis(VRectAxis axis) {
        if (axis == null || this.axisNamesTable == null) {
            return false;
        }
        return this.axisNamesTable.containsValue(axis);
    }

    public String getAxisName(VRectAxis axis) {
        for (Object key : this.axisNamesTable.keySet()) {
            if (this.axisNamesTable.get(key) != axis) continue;
            return (String)key;
        }
        return null;
    }

    public void addNamedAxis(String name, VRectAxis axis) {
        if (this.axisNamesTable != null && this.axisNamesTable.get(name) == null) {
            this.axisNamesTable.put(name, axis);
        }
    }

    public void removeNamedAxis(VRectAxis axis) {
        if (this.axisNamesTable != null) {
            for (Object key : this.axisNamesTable.keySet()) {
                if (this.axisNamesTable.get(key) != axis) continue;
                this.axisNamesTable.remove(key);
                break;
            }
        }
    }

    public void replaceNamedAxis(String name, ArrayList axes) {
        if (this.axisNamesTable != null) {
            this.axisNamesTable.remove(name);
            this.axisNamesTable.put(name, axes);
        }
    }

    public void addAxisReference(Object obj, Object reference) {
        if (this.axisNamesRefs != null) {
            this.axisNamesRefs.put(obj, reference);
        }
    }

    public void addOverviewAxisElement(String name, Element elem) {
        if (this.overviewAxisElements != null) {
            this.overviewAxisElements.put(name.toUpperCase(), elem);
        }
    }

    public Element getOverviewAxisElement(String name) {
        if (this.overviewAxisElements != null) {
            return (Element)this.overviewAxisElements.get(name.toUpperCase());
        }
        return null;
    }

    public static int getHost() {
        String arch = System.getProperty("os.arch");
        String os = System.getProperty("os.name");
        if (arch == null || os == null) {
            return 3;
        }
        if (os.startsWith("Windows")) {
            return 0;
        }
        if (arch.equals("alpha") && os.equals("OSF1")) {
            return 1;
        }
        if (arch.equals("alpha") && os.equals("OpenVMS")) {
            return 2;
        }
        return 3;
    }

    public int getDPI() {
        return (int)Math.round(100.0 * dataDPIScaleFactor);
    }

    public int scaleMarkerSize(int ms) {
        return (int)Math.round((double)ms * dataDPIScaleFactor * dataSizeScaleFactor);
    }

    public int scaleLineThickness(int lt) {
        return (int)Math.round((double)lt * dataDPIScaleFactor * dataSizeScaleFactor);
    }

    public int scaleGapThickness(int gt) {
        return (int)Math.round((double)gt * gapScaleFactor);
    }

    private double getShrinkageScale() {
        return Math.pow(shrinkFontsFactor, this.shrinkFontsPower);
    }

    public double getGapShrinkageScale() {
        return Math.pow(shrinkGapsFactor, this.shrinkFontsPower);
    }

    public int scaleFontSize(int fs) {
        if (VGF) {
            return (int)Math.round((double)fs * dataDPIScaleFactor * dataSizeScaleFactor * this.fontScaleFactor * this.getShrinkageScale() * 96.0 / 72.0);
        }
        fs = (fs = (int)Math.round((double)fs * dataDPIScaleFactor * dataSizeScaleFactor)) <= 12 ? (int)Math.ceil((double)fs * this.fontScaleFactor * this.getShrinkageScale() * 1.3) : (int)Math.ceil((double)fs * this.fontScaleFactor * this.getShrinkageScale() * 100.0 / 72.0);
        return Math.max(fs, StatGraph.getMinimumFontSize());
    }

    public int unit2MarkerSize(String unit) {
        if (unit == null) {
            return -1;
        }
        try {
            return this.scaleMarkerSize(new Size(unit).toPixels(this.getDPI(), this.size.height));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int unit2LineThickness(String unit) {
        if (unit == null) {
            return -1;
        }
        try {
            return this.scaleLineThickness(new Size(unit).toPixels(this.getDPI(), this.size.height));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int unit2GapThickness(String unit) {
        if (unit == null) {
            return -1;
        }
        try {
            return this.scaleGapThickness(new Size(unit).toPixels(this.getDPI(), this.size.height));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int unit2FontSize(String unit) {
        if (unit == null) {
            return -1;
        }
        if (StatGraph.isNumber(unit)) {
            return this.scaleFontSize(Integer.parseInt(unit));
        }
        try {
            return this.scaleFontSize(new Size(unit).toPoints(this.getDPI(), this.size.height));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static double getStippleScaleFactor() {
        return Math.max(1.0, dataDPIScaleFactor);
    }

    public static int scaleStippleFactor(int stippleFactor) {
        if (dataDPIScaleFactor > 1.0) {
            return (int)Math.round((double)stippleFactor * dataDPIScaleFactor);
        }
        return stippleFactor;
    }

    public static boolean isScaledUp() {
        return dataDPIScaleFactor * dataSizeScaleFactor > 1.0;
    }

    public static int scaleLegendLineLength(int size) {
        if (StatGraph.isScaledUp()) {
            return (int)Math.round((double)size * dataDPIScaleFactor * dataSizeScaleFactor);
        }
        return (int)Math.round((double)size * dataDPIScaleFactor * dataSizeScaleFactor * dataSizeScaleFactor);
    }

    public static double getGapScaleFactor() {
        return gapScaleFactor;
    }

    public static String[] parseList2String(String list) {
        return StatGraph.parseList2String(list, valueSeparator);
    }

    public static String[] parseList2String(String list, String separator) {
        list = list.trim();
        ArrayList<String> values = new ArrayList<String>();
        int prev = 0;
        int next = 0;
        while (next >= 0) {
            next = list.indexOf(separator, prev);
            if (next > 0) {
                values.add(list.substring(prev, next).trim());
                prev = next + 1;
                continue;
            }
            values.add(list.substring(prev).trim());
        }
        String[] va = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            va[i] = (String)values.get(i);
        }
        return va;
    }

    public static Color[] parseList2Color(String list) {
        list = list.trim();
        ArrayList<String> values = new ArrayList<String>();
        int prev = 0;
        int next = 0;
        while (next >= 0) {
            next = list.indexOf(valueSeparator, prev);
            if (next > 0) {
                values.add(list.substring(prev, next).trim());
                prev = next + 1;
                continue;
            }
            values.add(list.substring(prev).trim());
        }
        Color[] ca = new Color[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            ca[i] = GraphStyle.SAS2JavaColor((String)values.get(i));
        }
        return ca;
    }

    static double[] parseList2Double(String list, boolean sort) {
        list = list.trim();
        ArrayList<Double> values = new ArrayList<Double>();
        int prev = 0;
        int next = 0;
        while (next >= 0) {
            next = list.indexOf(valueSeparator, prev);
            if (next > 0) {
                values.add(new Double(list.substring(prev, next).trim()));
                prev = next + 1;
                continue;
            }
            String s = list.substring(prev).trim();
            if (!StatGraph.isNumber(s)) continue;
            values.add(new Double(s));
        }
        if (sort) {
            Collections.sort(values);
        }
        double[] va = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            va[i] = (Double)values.get(i);
        }
        return va;
    }

    public static double[] parseList2Double(String list) {
        return StatGraph.parseList2Double(list, false);
    }

    public static double[] parseList2SortedDouble(String list) {
        return StatGraph.parseList2Double(list, true);
    }

    public static void double2String(DataModel m, int col) {
        m.setColumnClass(col, String.class);
        int cnt = m.getColumnValueCount(col);
        DataModel.StringArray sa = new DataModel.StringArray(cnt, cnt);
        for (int i = 0; i < cnt; ++i) {
            double d = m.getDoubleColumn(col)[i];
            sa.values[i] = d != d ? "." : DataModel.formatNumber(d);
        }
        m.setColumn(col, sa);
    }

    public static int[] parseList2Int(String list) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int prev = 0;
        int next = 0;
        while (next >= 0) {
            next = list.indexOf(valueSeparator, prev);
            if (next > 0) {
                values.add(new Integer(list.substring(prev, next).trim()));
                prev = next + 1;
                continue;
            }
            String s = list.substring(prev).trim();
            if (!StatGraph.isNumber(s)) continue;
            values.add(new Integer(s));
        }
        int[] va = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            va[i] = (Integer)values.get(i);
        }
        return va;
    }

    public static String[] parseStringValueList(Element elem, String tag) {
        return StatGraph.parseStringValueList(elem, tag, false);
    }

    public static String[] parseStringValueList(Element elem, String tag, boolean trimTrailing) {
        ArrayList<String> values = new ArrayList<String>();
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(tag)) continue;
            Node child = ((Element)node).getFirstChild();
            if (child != null) {
                values.add(child.getNodeValue());
                continue;
            }
            values.add("");
        }
        String[] vs = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            vs[i] = (String)values.get(i);
            if (!trimTrailing) continue;
            vs[i] = StringToNumericMap.trimTrailing((String)vs[i]);
        }
        return vs;
    }

    public static double[] parseDoubleValueList(Element elem, String tag, boolean sort) {
        ArrayList<Double> values = new ArrayList<Double>();
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(tag) || (child = ((Element)node).getFirstChild()) == null) continue;
            values.add(new Double(child.getNodeValue()));
        }
        if (sort) {
            Collections.sort(values);
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            vs[i] = (Double)values.get(i);
        }
        return vs;
    }

    public static Color[] parseColorValueList(StatGraph graph, Element elem, String tag) {
        ArrayList<String> values = new ArrayList<String>();
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(tag) || (child = ((Element)node).getFirstChild()) == null) continue;
            String str = child.getNodeValue();
            if (str.equalsIgnoreCase(placeHolderToken)) {
                values.add("");
                continue;
            }
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    values.add(graph.style.getStyleAttribute(en, an));
                    continue;
                }
                values.add("");
                continue;
            }
            values.add(child.getNodeValue());
        }
        Color[] cls = new Color[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            String c = (String)values.get(i);
            if (c.length() <= 0) continue;
            cls[i] = GraphStyle.SAS2JavaColor(c);
        }
        return cls;
    }

    public static short getMarkerSymbol(String str) {
        return (short)Markers.getShape((String)str);
    }

    public static void parseTextAttrs(StatGraph graph, Element elem, TextStyle textStyle) {
        if (elem == null) {
            return;
        }
        TextAttrs ta = new TextAttrs();
        ta.setColor(textStyle.getColor());
        ta.setFont(textStyle.getFont());
        StatGraph.parseTextAttrs(graph, elem, ta);
        textStyle.setColor(ta.getColor());
        textStyle.setFont(ta.getFont());
    }

    public static void parseTextAttrs(StatGraph graph, Element elem, TextAttrs textStyle) {
        if (elem == null) {
            return;
        }
        Color c = StatGraph.parseAttrColor("color", graph, elem);
        if (c != null) {
            textStyle.setColor(c);
        }
        String family = StatGraph.parseAttrString("family", graph, elem);
        String weight = StatGraph.parseAttrString("weight", graph, elem);
        String style = StatGraph.parseAttrString("style", graph, elem);
        int fontSize = StatGraph.parseAttrFontSize("size", graph, elem);
        if (family == null && weight == null && style == null && fontSize < 0) {
            return;
        }
        Font oldFont = textStyle.getFont();
        if (family == null) {
            family = oldFont.getFamily();
        }
        boolean italic = oldFont.isItalic();
        if (style != null) {
            if (style.equalsIgnoreCase("italic")) {
                italic = true;
            } else if (style.equalsIgnoreCase("normal")) {
                italic = false;
            } else {
                StatGraph.printOptionError("STYLE", style);
            }
        }
        boolean bold = oldFont.isBold();
        if (weight != null) {
            if (weight.equalsIgnoreCase("bold")) {
                bold = true;
            } else if (weight.equalsIgnoreCase("normal")) {
                bold = false;
            } else {
                StatGraph.printOptionError("WEIGHT", weight);
            }
        }
        int fontStyle = 0;
        if (bold) {
            fontStyle |= 1;
        }
        if (italic) {
            fontStyle |= 2;
        }
        if (fontSize < 0) {
            fontSize = oldFont.getSize();
        }
        if (useFontManager) {
            textStyle.setFont(FontManager.getFont((String)family, (int)fontStyle, (int)fontSize));
        } else {
            textStyle.setFont(new Font(family, fontStyle, fontSize));
        }
    }

    public static void parseLineAttrs(StatGraph graph, Element elem, LineAttrs lineStyle) {
        int thickness;
        String str;
        if (elem == null) {
            return;
        }
        Color c = StatGraph.parseAttrColor("color", graph, elem);
        if (c != null) {
            lineStyle.setColor(c);
        }
        if ((str = StatGraph.parseAttrString("pattern", graph, elem)) != null && str.length() > 0) {
            if (StatGraph.isInteger(str)) {
                int pt = Integer.parseInt(str);
                if (pt > 0 && pt < 47) {
                    lineStyle.setLinePattern(pt);
                } else {
                    StatGraph.printOptionError("PATTERN", str);
                }
            } else {
                StatGraph.printOptionError("PATTERN", str);
            }
        }
        if ((thickness = StatGraph.parseAttrLineThickness("thickness", graph, elem)) >= 0) {
            lineStyle.setWidth(thickness);
        }
    }

    public static boolean parseDisplayMarkers(Element elem) {
        String str = elem.getAttribute("display").toLowerCase().trim();
        if (str.length() > 0 && !str.equals("standard")) {
            if (str.equals("all") || str.equals("markers")) {
                return true;
            }
            StatGraph.printOptionError("DISPLAY", str);
        }
        return false;
    }

    public static boolean parseMarkerColorGroup(StatGraph graph, Element elem, RoleColumnMap map, DataModel model, Overlay plot) {
        return StatGraph.parseMarkerColorGroup(graph, elem, map, model, plot, "markerColorGroup");
    }

    public static boolean parseMarkerColorGroup(StatGraph graph, Element elem, RoleColumnMap map, DataModel model, Overlay plot, String roleName) {
        boolean groupMapped = false;
        String str = elem.getAttribute(roleName);
        String markerColorGroupVarID = StatGraph.getVarID(str);
        if (markerColorGroupVarID.length() > 0) {
            int col = model.getColumn(markerColorGroupVarID);
            map.map(45, col);
            plot.addRole(roleName.toUpperCase(), model.getColumnLabel(col));
            groupMapped = true;
            str = elem.getAttribute("filledOutlinedMarkers");
            if (str.equalsIgnoreCase("true")) {
                map.map(69, col);
            }
            if ((str = elem.getAttribute(roleName + "AttrVar")).length() > 0) {
                plot.addAttrVar("MARKERCOLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, plot, "MARKERCOLORGROUP", markerColorGroupVarID);
            }
            str = elem.getAttribute(roleName + "Index");
            if (str.length() > 0) {
                String indexVarID = StatGraph.getVarID(str);
                int ii = model.getColumn(indexVarID);
                if (StatGraph.checkVariable(roleName.toUpperCase() + "INDEX", model.getColumnLabel(ii), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(model, ii, roleName.toUpperCase() + "INDEX", indexVarID)) {
                    map.map(109, ii);
                    plot.addRole(roleName.toUpperCase() + "INDEX", model.getColumnLabel(ii));
                }
            }
        }
        return groupMapped;
    }

    public static boolean parseMarkerSymbolGroup(StatGraph graph, Element elem, RoleColumnMap map, DataModel model, Overlay plot) {
        return StatGraph.parseMarkerSymbolGroup(graph, elem, map, model, plot, "markerSymbolGroup");
    }

    public static boolean parseMarkerSymbolGroup(StatGraph graph, Element elem, RoleColumnMap map, DataModel model, Overlay plot, String roleName) {
        boolean groupMapped = false;
        String str = elem.getAttribute(roleName);
        String markerSymbolGroupVarID = StatGraph.getVarID(str);
        if (markerSymbolGroupVarID.length() > 0) {
            int col = model.getColumn(markerSymbolGroupVarID);
            map.map(8, col);
            plot.addRole(roleName.toUpperCase(), model.getColumnLabel(col));
            groupMapped = true;
            str = elem.getAttribute(roleName + "AttrVar");
            if (str.length() > 0) {
                DiscreteAttrMapper mapper = graph.getDiscreteAttrVar(str);
                plot.addAttrVar("MARKERSYMBOLGROUP", (AttrMapper)mapper);
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, plot, "MARKERSYMBOLGROUP", markerSymbolGroupVarID);
            }
            str = elem.getAttribute(roleName + "Index");
            if (str.length() > 0) {
                String indexVarID = StatGraph.getVarID(str);
                int ii = model.getColumn(indexVarID);
                if (StatGraph.checkVariable(roleName.toUpperCase() + "INDEX", model.getColumnLabel(ii), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(model, ii, roleName.toUpperCase() + "INDEX", indexVarID)) {
                    map.map(42, ii);
                    plot.addRole(roleName.toUpperCase() + "INDEX", model.getColumnLabel(ii));
                }
            }
        }
        return groupMapped;
    }

    public static boolean mapMarkerRoles(StatGraph graph, Element elem, RoleColumnMap map, Element markerElem, String mrkAttr, int gcol, boolean groupMapped, DataModel model, Overlay plot) {
        boolean colorMapped = StatGraph.parseMarkerColorGroup(graph, elem, map, model, plot, "markerColorGroup");
        if (!groupMapped) {
            groupMapped = colorMapped;
        }
        boolean symbolMapped = StatGraph.parseMarkerSymbolGroup(graph, elem, map, model, plot, "markerSymbolGroup");
        if (!groupMapped) {
            groupMapped = symbolMapped;
        }
        if (!(map.isRoleMapped(45) || !map.isRoleMapped(46) || markerElem != null && markerElem.hasAttribute("color") || mrkAttr.length() != 0)) {
            map.map(45, gcol);
            groupMapped = true;
        }
        if (!(map.isRoleMapped(8) || markerElem != null && markerElem.hasAttribute("symbol") || mrkAttr.length() != 0)) {
            map.map(8, gcol);
            groupMapped = true;
        }
        return groupMapped;
    }

    public static void parseMarkerAttrs(StatGraph graph, Element elem, MarkerAttrs markerStyle) {
        int size;
        String str;
        if (elem == null) {
            return;
        }
        Color c = StatGraph.parseAttrColor("color", graph, elem);
        if (c != null) {
            markerStyle.setColor(c);
        }
        if ((str = StatGraph.parseAttrString("symbol", graph, elem)) != null && str.length() > 0) {
            int symbol = Markers.getShape((String)str);
            if (symbol >= 0) {
                markerStyle.setShape(symbol);
                if (!Markers.isGTLSupportedMarker((int)symbol)) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "markersymbol.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                }
            } else {
                StatGraph.printOptionError("SYMBOL", str);
            }
        }
        if ((size = StatGraph.parseAttrMarkerSize("size", graph, elem)) >= 0) {
            int maxSize = 2 * Math.min(graph.size.width, graph.size.height);
            if (size > maxSize) {
                size = maxSize;
            }
            markerStyle.setSize(size);
        }
        if ((str = elem.getAttribute("weight")).length() > 0) {
            if (str.equalsIgnoreCase("normal")) {
                markerStyle.setWeight(0);
            } else if (str.equalsIgnoreCase("bold")) {
                markerStyle.setWeight(2);
            } else {
                StatGraph.printOptionError("WEIGHT", str);
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute("transparency"))) {
            markerStyle.setTransparency(Double.parseDouble(str));
        }
    }

    public static void parseFillAttrs(StatGraph graph, Element elem, FillAttrs fillStyle) {
        String str;
        if (elem == null) {
            return;
        }
        Color c = StatGraph.parseAttrColor("color", graph, elem);
        if (c != null) {
            fillStyle.setColor(c);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("transparency"))) {
            fillStyle.setTransparency(Double.parseDouble(str));
        }
    }

    public static void parseFillPatternAttrs(StatGraph graph, Element elem, FillPatternAttrs fillPatternStyle) {
        String str;
        if (elem == null) {
            return;
        }
        Color c = StatGraph.parseAttrColor("color", graph, elem);
        if (c != null) {
            fillPatternStyle.setColor(c);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("transparency"))) {
            fillPatternStyle.setTransparency(Double.parseDouble(str));
        }
        if ((str = StatGraph.parseAttrString("pattern", graph, elem)) != null && str.length() > 0) {
            int pattern = FillPatternAttrs.getPattern((String)str);
            if (pattern >= 0) {
                fillPatternStyle.setPattern(pattern);
            } else {
                StatGraph.printOptionError("PATTERN", str);
            }
        }
    }

    public static Color parseAttrColor(String attr, StatGraph graph, Element elem) {
        if (elem == null) {
            return null;
        }
        Color color = null;
        String str = elem.getAttribute(attr);
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    color = GraphStyle.SAS2JavaColor(graph.style.getStyleAttribute(en, an));
                }
            } else {
                color = GraphStyle.SAS2JavaColor(str.toUpperCase());
            }
        }
        return color;
    }

    public static String parseAttrString(String attr, StatGraph graph, Element elem) {
        String str = elem.getAttribute(attr);
        String name = null;
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    name = graph.style.getStyleAttribute(en, an);
                }
            } else {
                name = str;
            }
        }
        return name;
    }

    public static short parseAttrMarkerSymbol(String attr, StatGraph graph, Element elem) {
        short shape = -1;
        String str = elem.getAttribute(attr);
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    shape = StatGraph.getMarkerSymbol(graph.style.getStyleAttribute(en, an));
                }
            } else {
                shape = StatGraph.getMarkerSymbol(str);
            }
        }
        return shape;
    }

    public static int parseAttrMarkerSize(String attr, StatGraph graph, Element elem) {
        String str = elem.getAttribute(attr);
        int size = -1;
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    size = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                }
            } else {
                size = graph.unit2MarkerSize(str);
            }
        }
        return size;
    }

    public static int parseAttrLineThickness(String attr, StatGraph graph, Element elem) {
        String str = elem.getAttribute(attr);
        int size = -1;
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    size = graph.unit2LineThickness(graph.style.getStyleAttribute(en, an));
                }
            } else {
                size = graph.unit2LineThickness(str);
            }
        }
        return size;
    }

    public static int parseAttrFontSize(String attr, StatGraph graph, Element elem) {
        String str = elem.getAttribute(attr);
        int size = -1;
        if (str.length() > 0) {
            if (str.indexOf(":") >= 0) {
                String en = GraphStyle.parseStyleElementName(str);
                String an = GraphStyle.parseStyleAttributeName(str);
                en = graph.style.getGraphStyle().remapDataElement(en, an);
                if (en != null) {
                    size = graph.unit2FontSize(graph.style.getStyleAttribute(en, an));
                }
            } else {
                size = graph.unit2FontSize(str);
            }
        }
        return size;
    }

    public static void parseURLOpt(Element elem, DataModel dModel, RoleColumnMap rcMap, Overlay overlay) {
        String str = elem.getAttribute("url");
        if (str.length() > 0) {
            String urlVarID = StatGraph.getVarID(str);
            int ucol = dModel.getColumn(urlVarID);
            rcMap.map(52, ucol);
            overlay.addRole("URL", dModel.getColumnLabel(ucol));
        }
    }

    public static void parseURLOpt(Element elem, DataModel dModel, RoleColumnMap rcMap, Region region) {
        String str = elem.getAttribute("url");
        if (str.length() > 0) {
            String urlVarID = StatGraph.getVarID(str);
            int ucol = dModel.getColumn(urlVarID);
            rcMap.map(52, ucol);
            region.addRole("URL", dModel.getColumnLabel(ucol));
        }
    }

    public static ColorEncoder parseColorModelOpt(byte dimension, StatGraph graph, Element elem, Overlay overlay) {
        String defaultRamp = dimension == 4 ? "ThreeColorRamp" : "ThreeColorAltRamp";
        DataRange range = overlay.getDataRange(dimension);
        ColorEncoder encoder = null;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            String str = elem.getAttribute("colorModel");
            Color[] ramp = graph.style.getRampColors(str, defaultRamp);
            str = elem.getAttribute("reverseColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            Element cmElem = StatGraph.getOptionAttrsElement(elem, "ColorModel");
            boolean userColorModel = false;
            if (cmElem != null) {
                Color[] colors = StatGraph.parseColorValueList(graph, cmElem, "Value");
                if (colors != null && colors.length > 0) {
                    ramp = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
                }
                userColorModel = true;
            }
            if (userColorModel) {
                if (reverse) {
                    Color[] cl = new Color[ramp.length];
                    int idx = 0;
                    for (int i = ramp.length - 1; i >= 0; --i) {
                        cl[idx++] = ramp[i];
                    }
                    ramp = cl;
                }
                for (int i = 0; i < ramp.length; ++i) {
                    ramp[i] = overlay.applyDataTransparency(ramp[i]);
                }
                encoder = new ColorEncoder(cr, ramp);
            } else if (ramp.length == 2) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "colormodel.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            } else {
                encoder = reverse ? new ColorEncoder(cr, overlay.applyDataTransparency(ramp[2]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[0])) : new ColorEncoder(cr, overlay.applyDataTransparency(ramp[0]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[2]));
            }
        }
        return encoder;
    }

    public static ColorEncoder parseColorModelOpt(byte dimension, StatGraph graph, Element elem, Overlay overlay, double transparency) {
        String defaultRamp = dimension == 4 ? "ThreeColorRamp" : "ThreeColorAltRamp";
        DataRange range = overlay.getDataRange(dimension);
        ColorEncoder encoder = null;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            String str = elem.getAttribute("colorModel");
            Color[] ramp = graph.style.getRampColors(str, defaultRamp);
            str = elem.getAttribute("reverseColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            Element cmElem = StatGraph.getOptionAttrsElement(elem, "ColorModel");
            boolean userColorModel = false;
            if (cmElem != null) {
                Color[] colors = StatGraph.parseColorValueList(graph, cmElem, "Value");
                if (colors != null && colors.length > 0) {
                    ramp = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
                }
                userColorModel = true;
            }
            if (userColorModel) {
                if (reverse) {
                    Color[] cl = new Color[ramp.length];
                    int idx = 0;
                    for (int i = ramp.length - 1; i >= 0; --i) {
                        cl[idx++] = ramp[i];
                    }
                    ramp = cl;
                }
                for (int i = 0; i < ramp.length; ++i) {
                    ramp[i] = overlay.applyDataTransparency(ramp[i], transparency);
                }
                encoder = new ColorEncoder(cr, ramp);
            } else if (ramp.length == 2) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "colormodel.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            } else {
                encoder = reverse ? new ColorEncoder(cr, overlay.applyDataTransparency(ramp[2], transparency), overlay.applyDataTransparency(ramp[1], transparency), overlay.applyDataTransparency(ramp[0], transparency)) : new ColorEncoder(cr, overlay.applyDataTransparency(ramp[0], transparency), overlay.applyDataTransparency(ramp[1], transparency), overlay.applyDataTransparency(ramp[2], transparency));
            }
        }
        return encoder;
    }

    public static int dataSkinName2Int(String name) {
        String lcSkin = name.toLowerCase();
        int skinType = lcSkin.equals("pressed") ? 3 : (lcSkin.equals("sheen") ? 4 : (lcSkin.equals("crisp") ? 5 : (lcSkin.equals("gloss") ? 6 : (lcSkin.equals("matte") ? 7 : (lcSkin.equals("none") ? 0 : -1)))));
        return skinType;
    }

    public static void parseDataSkinOpt(StatGraph graph, Element elem, Overlay overlay) {
        int skinType = -1;
        String dsStr = elem.getAttribute("dataSkin");
        if (dsStr != null && dsStr.length() > 0 && (skinType = StatGraph.dataSkinName2Int(dsStr)) < 0) {
            StatGraph.printOptionError("DATASKIN", dsStr);
        }
        if (skinType < 0 && (dsStr = graph.style.getStyleAttribute("Skins", "dataSkin")) != null && dsStr.length() > 0) {
            skinType = StatGraph.dataSkinName2Int(dsStr);
        }
        if (skinType >= 0) {
            overlay.setSkinType(skinType);
        }
    }

    public static Element getOptionAttrsElement(Element elem, String optionAttrs) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(optionAttrs)) continue;
            return (Element)node;
        }
        return null;
    }

    private static Class type2Class(int type) {
        if (type == 2) {
            return String.class;
        }
        return Double.class;
    }

    public static boolean checkVariable(String role, Object cLabel, Class type, boolean required) {
        return StatGraph.checkVariable(role, cLabel, type, -1, false, required);
    }

    public static boolean checkVariable(String role, Object cLabel, Class type, int minNoneMissings, boolean required) {
        return StatGraph.checkVariable(role, cLabel, type, -1, false, minNoneMissings, required);
    }

    public static boolean checkVariable(String role, Object cLabel, Class type, int range, boolean nonMissing, boolean required) {
        return StatGraph.checkVariable(role, cLabel, type, range, nonMissing, 0, required);
    }

    public static boolean checkVariable(String role, Object cLabel, Class type, int range, boolean nonMissing, int minNonMissings, boolean required) {
        if (cLabel == null || !(cLabel instanceof ColumnMetadata)) {
            StatGraph.printDebug("Invalid column meta data!");
            return false;
        }
        ColumnMetadata cmd = (ColumnMetadata)cLabel;
        if (cmd.getNobs() <= 0) {
            StatGraph.printDebug("Invalid column meta data!");
            return false;
        }
        boolean ok = true;
        Message msg = null;
        if (type != null && type != StatGraph.type2Class(cmd.getType())) {
            msg = new Message(RB.getStringResource(RB_KEY, "dt.fmt.txt"));
        } else if (range == 0 && cmd.getMin() < 0.0) {
            msg = new Message(RB.getStringResource(RB_KEY, "nneg.fmt.txt"));
        } else if (range == 1 && cmd.getMin() <= 0.0) {
            msg = new Message(RB.getStringResource(RB_KEY, "pos.fmt.txt"));
        } else if (range == 2 && cmd.getMin() < 1.0) {
            msg = new Message(RB.getStringResource(RB_KEY, "posint.fmt.txt"));
        } else if (nonMissing && cmd.getMissings() > 0) {
            msg = new Message(RB.getStringResource(RB_KEY, "nmiss.fmt.txt"));
        } else if (minNonMissings > 0 && cmd.getNobs() - cmd.getMissings() < minNonMissings && !suppressWarningMsg) {
            msg = new Message(RB.getStringResource(RB_KEY, "minnmiss.fmt.txt"));
        }
        if (msg != null) {
            ok = false;
            StatGraph.printWarning(msg.toString((Object)role.toUpperCase(), (Object)cmd.getName()));
        }
        return ok;
    }

    public static void printDebug(String msg) {
        System.out.println("DEBUG: " + msg);
    }

    public static void printError(String msg) {
        StatGraph.printError(msg, suppressWarningMsg);
    }

    public static void printError(String msg, boolean suppress) {
        if (suppress) {
            return;
        }
        System.out.println("%1z" + msg);
        if (errorMessageList != null && !errorMessageList.contains(msg)) {
            errorMessageList.add(msg);
        }
    }

    public static void printWarning(String msg) {
        StatGraph.printWarning(msg, suppressWarningMsg);
    }

    public static void printWarning(String msg, boolean suppress) {
        if (suppress) {
            return;
        }
        System.out.println("%2z" + msg);
        if (warningMessageList != null && !warningMessageList.contains(msg)) {
            warningMessageList.add(msg);
        }
    }

    public static void printNote(String msg) {
        StatGraph.printNote(msg, suppressWarningMsg);
    }

    public static void printNote(String msg, boolean suppress) {
        if (suppress || noNotes) {
            return;
        }
        System.out.println("%3z" + msg);
        if (noteMessageList != null && !noteMessageList.contains(msg)) {
            noteMessageList.add(msg);
        }
    }

    public static void printOptionError(String option, String value) {
        Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
        StatGraph.printNote(msg.toString((Object)option, (Object)value));
    }

    public static int getMarkerEdgeWidth(double size, int weight) {
        double width;
        double ratio = (size /= dataDPIScaleFactor) / 7.0;
        if (weight == 2) {
            double power = 0.7;
            double minWidth = 2.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else if (weight == 1) {
            double power = 0.65;
            double minWidth = 1.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else {
            double power = 0.5;
            double minWidth = 1.0;
            width = ratio <= 3.0 ? minWidth : minWidth + Math.pow(ratio - 3.0, power);
        }
        width = Math.max(1.0, width * dataDPIScaleFactor);
        return (int)width;
    }

    public int getDrawSpace() {
        return this.drawSpace;
    }

    public void setDrawSpace(int drawSpace) {
        this.drawSpace = drawSpace;
    }

    public void clearElementToObjectTable() {
        if (this.elementToObject != null) {
            this.elementToObject.clear();
        }
    }

    public Object getObjectFromElement(Element elemID) {
        if (this.elementToObject != null) {
            return this.elementToObject.get(elemID);
        }
        return null;
    }

    public void removeObjectFromElement(Element elemID) {
        if (this.elementToObject != null) {
            this.elementToObject.remove(elemID);
        }
    }

    public void addElementObjectPair(Element elemID, Object overlay) {
        if (this.elementToObject == null) {
            this.elementToObject = new HashMap();
        }
        this.elementToObject.put(elemID, overlay);
    }

    public void clearDrawObjectToElementTable() {
        this.drawObjectToElement.clear();
    }

    public Element getElementForDrawObject(AbstractAnno anno) {
        return this.drawObjectToElement.get(anno);
    }

    public void removeElementForDrawObject(AbstractAnno anno) {
        this.drawObjectToElement.remove(anno);
    }

    public void addDrawObjectElementPair(AbstractAnno anno, Element elemID) {
        this.drawObjectToElement.put(anno, elemID);
    }

    public Iterator getAllSGElements() {
        if (this.elementToObject == null) {
            return null;
        }
        return this.elementToObject.values().iterator();
    }

    public Iterator getAllDomElements() {
        return this.elementToObject.keySet().iterator();
    }

    public Iterator getAllContainers() {
        return this.sgElementToContainer.values().iterator();
    }

    public void addSGElementContainerPair(Object element, JComponent container) {
        this.sgElementToContainer.put(element, container);
    }

    public void removeSGElementContainerPair(Object element) {
        this.sgElementToContainer.remove(element);
    }

    public JComponent getContainerFromSGElement(Object elemID) {
        return this.sgElementToContainer != null ? (JPanel)this.sgElementToContainer.get(elemID) : null;
    }

    public JPanel getTitlePanel() {
        return this.titlePanel;
    }

    public JPanel getFootnotePanel() {
        return this.footnotePanel;
    }

    public GlobalLegend getGlobalLegend() {
        return this.globalLegend;
    }

    public static int roundToNextHundreds(int aInt) {
        return (int)Math.ceil((double)aInt / 100.0) * 100;
    }

    public static Locale getSessionLocale(Document xml) {
        Locale userLocale = null;
        NodeList nl = xml.getElementsByTagName("StatGraph");
        Element elem = (Element)nl.item(0);
        String str = elem.getAttribute("sessionLocale");
        if (str.length() > 0) {
            int i = str.indexOf("_");
            if (i < 0) {
                userLocale = new Locale(str);
            } else {
                String language = str.substring(0, i);
                String country = str.substring(i + 1, str.length());
                userLocale = new Locale(language, country);
            }
        }
        return userLocale;
    }

    public static void setSystemLocale() {
        if (systemLocale != null) {
            Locale.setDefault(systemLocale);
        }
    }

    public static void setSessionLocale() {
        if (sessionLocale != null) {
            Locale.setDefault(sessionLocale);
        }
    }

    public static BasicStroke getStroke(int lineStyle, float lineWidth) {
        BasicStroke bs;
        int mask = SASLinePatterns.getStipplePattern((int)lineStyle);
        int factor = SASLinePatterns.getStippleFactor((int)lineStyle);
        factor = StatGraph.scaleStippleFactor(factor);
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] glPattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            glPattern[i] = dashes[index];
            ++i;
            --index;
        }
        float dashPhase = 0.0f;
        float[] dashArray = null;
        float lw = lineWidth;
        int stippleIndex = 0;
        if (lineWidth < 1.0f) {
            lw = 0.5f;
        }
        if (glPattern.length == 1) {
            bs = glPattern[0] < 0 ? null : new BasicStroke(lw, 0, 0);
        } else {
            if (glPattern[0] < 0 && glPattern[glPattern.length - 1] > 0) {
                ++stippleIndex;
                dashPhase = glPattern[1];
                dashArray = new float[glPattern.length];
                dashArray[glPattern.length - 1] = Math.abs(glPattern[0]);
            } else if (glPattern[0] < 0 && glPattern[glPattern.length - 1] < 0) {
                int n = glPattern.length - 1;
                glPattern[n] = glPattern[n] + glPattern[0];
                int[] newStipplePattern = new int[glPattern.length - 1];
                System.arraycopy(glPattern, 1, newStipplePattern, 0, glPattern.length - 1);
                glPattern = newStipplePattern;
                dashArray = new float[glPattern.length];
            } else {
                dashArray = new float[glPattern.length];
            }
            int dashIndex = 0;
            while (stippleIndex < glPattern.length) {
                dashArray[dashIndex] = Math.abs(glPattern[stippleIndex]);
                ++stippleIndex;
                ++dashIndex;
            }
            bs = new BasicStroke(lw, 0, 0, (int)Math.max(lineWidth, 1.0f), dashArray, dashPhase);
        }
        return bs;
    }

    public static Container getRootPanel(JPanel panel) {
        Container parent;
        for (parent = panel; parent != null && !(parent instanceof BaseStatGraphPanel); parent = parent.getParent()) {
        }
        return parent;
    }

    public void addDiscreteAttrMap(String name, DiscreteAttributeMap attrMap) {
        if (name != null && attrMap != null) {
            this.discreteAttrMapTable.put(name, attrMap);
        }
    }

    public DiscreteAttributeMap getDiscreteAttrMap(String name) {
        if (name == null) {
            return null;
        }
        return this.discreteAttrMapTable.get(name);
    }

    public void addRangeAttrMap(String name, RangeAttributeMap attrMap) {
        if (name != null && attrMap != null) {
            this.rangeAttrMapTable.put(name, attrMap);
        }
    }

    public RangeAttributeMap getRangeAttrMap(String name) {
        if (name == null) {
            return null;
        }
        return this.rangeAttrMapTable.get(name);
    }

    public void addCategorizationAttrMap(String name, CategorizationAttributeMap attrMap) {
        if (name != null && attrMap != null) {
            this.categorizationAttrMapTable.put(name, attrMap);
        }
    }

    public CategorizationAttributeMap getCategorizationAttrMap(String name) {
        if (name == null) {
            return null;
        }
        return this.categorizationAttrMapTable.get(name);
    }

    private void checkForAnnoAndMoveToDraw(Element graphNode) {
        Document dom = graphNode.getOwnerDocument();
        Node aElem = null;
        NodeList list = graphNode.getElementsByTagName("LayoutPrototype");
        if (list.getLength() == 0) {
            list = graphNode.getElementsByTagName("LayoutPrototypeOverlay2D");
        }
        boolean panel = list.getLength() > 0;
        list = graphNode.getElementsByTagName("ScatterPlotMatrix");
        panel |= list.getLength() > 0;
        for (Node node = dom.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("Annotation")) continue;
            aElem = (Element)node;
            break;
        }
        if (aElem == null) {
            return;
        }
        int position = -1;
        for (Node node = aElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String parentID;
            Element drawNode;
            Element elem;
            String elemTag;
            if (!(node instanceof Element) || (elemTag = (elem = (Element)node).getTagName()).indexOf("Attrs") != -1) continue;
            int index = -1;
            for (int i = 0; i < 8; ++i) {
                if (!ElementNames[i].equals(elemTag)) continue;
                index = i;
                break;
            }
            if (index == -1) continue;
            ++position;
            boolean attachedToData = false;
            Node parent = null;
            Element custom = null;
            boolean clip = false;
            boolean invalidDataSpace = panel;
            switch (index) {
                case 2: {
                    drawNode = dom.createElement("DrawLine");
                    break;
                }
                case 0: 
                case 1: {
                    drawNode = dom.createElement("DrawArrow");
                    drawNode.setAttribute("labelPosition", "begin");
                    drawNode.setAttribute("arrowHeadShape", "barbed");
                    drawNode.setAttribute("arrowHeadScale", Double.toString(0.5));
                    break;
                }
                case 4: {
                    drawNode = dom.createElement("DrawRectangle");
                    break;
                }
                case 3: {
                    drawNode = dom.createElement("DrawOval");
                    break;
                }
                case 7: {
                    drawNode = dom.createElement("DrawMarker");
                    drawNode.setAttribute("labelPosition", "below");
                    break;
                }
                default: {
                    drawNode = dom.createElement("DrawText");
                    break;
                }
                case 6: {
                    drawNode = dom.createElement("DrawImage");
                    String str = elem.getAttribute("File");
                    drawNode.setAttribute("image", str);
                    drawNode.setAttribute("labelPosition", "below");
                }
            }
            if (index <= 2) {
                double value;
                parentID = elem.getAttribute("Parent");
                parent = StatGraph.getElementFromID(graphNode, parentID);
                if (parent instanceof Element) {
                    parent = StatGraph.getDataContainer((Element)parent);
                }
                if (parentID != null && parentID.length() > 0) {
                    attachedToData = true;
                }
                if (elem.hasAttribute("AnchorAttachedToData")) {
                    attachedToData = "true".equalsIgnoreCase(elem.getAttribute("AnchorAttachedToData"));
                }
                if (attachedToData && (parent == null || !StatGraph.isValidDataSpace((Element)parent))) {
                    invalidDataSpace = true;
                }
                if (invalidDataSpace) {
                    String str = elem.getAttribute("SAnchorX");
                    if (StatGraph.isNumber(str)) {
                        value = Double.parseDouble(str) / (double)this.rootPanel.getWidth();
                        drawNode.setAttribute("x1", Double.toString(100.0 * value));
                        drawNode.setAttribute("x1Space", "graphpercent");
                    }
                    if (StatGraph.isNumber(str = elem.getAttribute("SAnchorY"))) {
                        value = Double.parseDouble(str) / (double)this.rootPanel.getHeight();
                        drawNode.setAttribute("y1", Double.toString(100.0 - 100.0 * value));
                        drawNode.setAttribute("y1Space", "graphpercent");
                    }
                } else if (attachedToData) {
                    drawNode.setAttribute("x1", elem.getAttribute("AnchorX"));
                    drawNode.setAttribute("y1", elem.getAttribute("AnchorY"));
                    drawNode.setAttribute("x1_type", "numeric");
                    drawNode.setAttribute("y1_type", "numeric");
                    drawNode.setAttribute("x1Space", "datavalue");
                    drawNode.setAttribute("y1Space", "datavalue");
                    if (!StatGraph.isPrimaryX((Element)parent)) {
                        drawNode.setAttribute("xAxis", "x2");
                    }
                    if (!StatGraph.isPrimaryY((Element)parent)) {
                        drawNode.setAttribute("yAxis", "y2");
                    }
                } else {
                    String str = elem.getAttribute("AnchorX");
                    if (StatGraph.isNumber(str)) {
                        value = Double.parseDouble(str);
                        drawNode.setAttribute("x1", Double.toString(100.0 * value));
                        drawNode.setAttribute("x1Space", "graphpercent");
                    }
                    if (StatGraph.isNumber(str = elem.getAttribute("AnchorY"))) {
                        value = Double.parseDouble(str);
                        drawNode.setAttribute("y1", Double.toString(100.0 - 100.0 * value));
                        drawNode.setAttribute("y1Space", "graphpercent");
                    }
                }
                boolean secondaryAttachedToData = false;
                if (elem.hasAttribute("SecondaryParent")) {
                    invalidDataSpace = false;
                    String secondaryParent = elem.getAttribute("SecondaryParent");
                    parent = StatGraph.getElementFromID(graphNode, secondaryParent);
                    if (parent instanceof Element) {
                        parent = StatGraph.getDataContainer((Element)parent);
                    }
                    if (secondaryParent != null && secondaryParent.length() > 0) {
                        secondaryAttachedToData = true;
                    }
                    if (elem.hasAttribute("SecondaryAttachedToData")) {
                        secondaryAttachedToData = "true".equalsIgnoreCase(elem.getAttribute("SecondaryAttachedToData"));
                    }
                    if (secondaryAttachedToData && (parent == null || !StatGraph.isValidDataSpace((Element)parent))) {
                        invalidDataSpace = true;
                    }
                }
                if (invalidDataSpace) {
                    String str = elem.getAttribute("SSecondaryX");
                    if (StatGraph.isNumber(str)) {
                        value = Double.parseDouble(str) / (double)this.rootPanel.getWidth();
                        drawNode.setAttribute("x2", Double.toString(100.0 * value));
                        drawNode.setAttribute("x2Space", "graphpercent");
                    }
                    if (StatGraph.isNumber(str = elem.getAttribute("SSecondaryY"))) {
                        value = Double.parseDouble(str) / (double)this.rootPanel.getHeight();
                        drawNode.setAttribute("y2", Double.toString(100.0 - 100.0 * value));
                        drawNode.setAttribute("y2Space", "graphpercent");
                    }
                } else if (secondaryAttachedToData) {
                    drawNode.setAttribute("x2", elem.getAttribute("SecondaryX"));
                    drawNode.setAttribute("y2", elem.getAttribute("SecondaryY"));
                    drawNode.setAttribute("x2_type", "numeric");
                    drawNode.setAttribute("y2_type", "numeric");
                    drawNode.setAttribute("x2Space", "datavalue");
                    drawNode.setAttribute("y2Space", "datavalue");
                    if (!StatGraph.isPrimaryX((Element)parent)) {
                        drawNode.setAttribute("xAxis", "x2");
                    }
                    if (!StatGraph.isPrimaryY((Element)parent)) {
                        drawNode.setAttribute("yAxis", "y2");
                    }
                } else {
                    String str = elem.getAttribute("SecondaryX");
                    if (StatGraph.isNumber(str)) {
                        value = Double.parseDouble(str);
                        drawNode.setAttribute("x2", Double.toString(100.0 * value));
                        drawNode.setAttribute("x2Space", "graphpercent");
                    }
                    if (StatGraph.isNumber(str = elem.getAttribute("SecondaryY"))) {
                        value = Double.parseDouble(str);
                        drawNode.setAttribute("y2", Double.toString(100.0 - 100.0 * value));
                        drawNode.setAttribute("y2Space", "graphpercent");
                    }
                }
                custom = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
                if (custom != null) {
                    String str;
                    if (custom.hasAttribute("width")) {
                        custom.setAttribute("thickness", custom.getAttribute("width"));
                        custom.removeAttribute("width");
                    }
                    if (custom.hasAttribute("pattern") && (!StatGraph.isNumber(str = custom.getAttribute("pattern")) || Double.parseDouble(str) < 0.0)) {
                        custom.removeAttribute("pattern");
                    }
                    drawNode.appendChild(custom);
                }
                clip = attachedToData && secondaryAttachedToData;
            } else {
                double temp;
                parentID = elem.getAttribute("Parent");
                parent = StatGraph.getElementFromID(graphNode, parentID);
                if (parent instanceof Element) {
                    parent = StatGraph.getDataContainer((Element)parent);
                }
                if (parentID != null && parentID.length() > 0) {
                    attachedToData = true;
                }
                if (elem.hasAttribute("AnchorAttachedToData")) {
                    attachedToData = "true".equalsIgnoreCase(elem.getAttribute("AnchorAttachedToData"));
                }
                if (attachedToData && (parent == null || !StatGraph.isValidDataSpace((Element)parent))) {
                    invalidDataSpace = true;
                }
                clip = parent != null;
                String str = invalidDataSpace ? elem.getAttribute("SAnchorX") : elem.getAttribute("AnchorX");
                double x1 = Double.parseDouble(str);
                if (invalidDataSpace) {
                    x1 /= (double)this.rootPanel.getWidth();
                }
                str = invalidDataSpace ? elem.getAttribute("SSecondaryX") : elem.getAttribute("SecondaryX");
                double x2 = Double.parseDouble(str);
                if (invalidDataSpace) {
                    x2 /= (double)this.rootPanel.getWidth();
                }
                if (x1 > x2) {
                    temp = x1;
                    x1 = x2;
                    x2 = temp;
                }
                str = invalidDataSpace ? elem.getAttribute("SAnchorY") : elem.getAttribute("AnchorY");
                double y1 = Double.parseDouble(str);
                if (invalidDataSpace) {
                    y1 /= (double)this.rootPanel.getHeight();
                }
                str = invalidDataSpace ? elem.getAttribute("SSecondaryY") : elem.getAttribute("SecondaryY");
                double y2 = Double.parseDouble(str);
                if (invalidDataSpace) {
                    y2 /= (double)this.rootPanel.getHeight();
                }
                if (y1 > y2) {
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                if (attachedToData && !invalidDataSpace) {
                    drawNode.setAttribute("x", Double.toString((x1 + x2) / 2.0));
                    drawNode.setAttribute("y", Double.toString((y1 + y2) / 2.0));
                    drawNode.setAttribute("x_type", "numeric");
                    drawNode.setAttribute("y_type", "numeric");
                    drawNode.setAttribute("drawSpace", "datavalue");
                    if (!StatGraph.isPrimaryX((Element)parent)) {
                        drawNode.setAttribute("xAxis", "x2");
                    }
                    if (!StatGraph.isPrimaryY((Element)parent)) {
                        drawNode.setAttribute("yAxis", "y2");
                    }
                } else {
                    drawNode.setAttribute("x", Double.toString((x1 + x2) * 50.0));
                    drawNode.setAttribute("y", Double.toString(100.0 - 50.0 * (y1 + y2)));
                    drawNode.setAttribute("drawSpace", "graphpercent");
                }
                if (index == 3 || index == 4) {
                    if (attachedToData && !invalidDataSpace) {
                        drawNode.setAttribute("width", Double.toString(x2 - x1));
                        drawNode.setAttribute("height", Double.toString(y2 - y1));
                        drawNode.setAttribute("widthUnit", "data");
                        drawNode.setAttribute("heightUnit", "data");
                    } else {
                        drawNode.setAttribute("width", Double.toString(100.0 * (x2 - x1)));
                        drawNode.setAttribute("height", Double.toString(100.0 * (y2 - y1)));
                    }
                    if (elem.hasAttribute("display")) {
                        drawNode.setAttribute("display", elem.getAttribute("display"));
                    } else {
                        boolean fill;
                        boolean line = elem.hasAttribute("line") ? "true".equalsIgnoreCase(elem.getAttribute("line")) : true;
                        boolean bl = fill = elem.hasAttribute("fill") ? "true".equalsIgnoreCase(elem.getAttribute("fill")) : true;
                        if (line && fill) {
                            drawNode.setAttribute("display", "all");
                        } else if (fill) {
                            drawNode.setAttribute("display", "fill");
                        } else {
                            drawNode.setAttribute("display", "outline");
                        }
                    }
                    custom = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
                    if (custom != null) {
                        Element anode = dom.createElement("OutlineAttrs");
                        if (custom.hasAttribute("pattern") && StatGraph.isNumber(str = custom.getAttribute("pattern")) && Double.parseDouble(str) >= 0.0) {
                            anode.setAttribute("pattern", str);
                        }
                        if (custom.hasAttribute("color")) {
                            anode.setAttribute("color", custom.getAttribute("color"));
                        }
                        if (custom.hasAttribute("width")) {
                            anode.setAttribute("thickness", custom.getAttribute("width"));
                        }
                        drawNode.appendChild(anode);
                    }
                    if ((custom = StatGraph.getOptionAttrsElement(elem, "FillAttrs")) != null) {
                        drawNode.appendChild(custom);
                        if (custom.hasAttribute("transparency")) {
                            str = custom.getAttribute("transparency");
                            if (StatGraph.isNumber(str)) {
                                double t = Double.parseDouble(str) / 100.0;
                                custom.setAttribute("transparency", Double.toString(t));
                            } else {
                                custom.removeAttribute("transparency");
                            }
                        }
                    }
                    if (elem.hasAttribute("transparency")) {
                        str = elem.getAttribute("transparency");
                        double t = 0.0;
                        if (StatGraph.isNumber(str)) {
                            t = Double.parseDouble(str) / 100.0;
                        }
                        if (custom == null) {
                            custom = drawNode.getOwnerDocument().createElement("FillAttrs");
                            drawNode.appendChild(custom);
                        }
                        custom.setAttribute("transparency", Double.toString(t));
                    }
                } else if (index == 6) {
                    boolean line;
                    if (attachedToData && !invalidDataSpace) {
                        drawNode.setAttribute("width", Double.toString(x2 - x1));
                        drawNode.setAttribute("height", Double.toString(y2 - y1));
                        drawNode.setAttribute("sizeUnit", "data");
                    } else {
                        drawNode.setAttribute("width", Double.toString(100.0 * (x2 - x1)));
                        drawNode.setAttribute("height", Double.toString(100.0 * (y2 - y1)));
                        drawNode.setAttribute("sizeUnit", "percent");
                    }
                    boolean bl = line = elem.hasAttribute("line") ? "true".equalsIgnoreCase(elem.getAttribute("line")) : true;
                    if (line) {
                        drawNode.setAttribute("border", "true");
                    }
                    if ((custom = StatGraph.getOptionAttrsElement(elem, "LineAttrs")) != null) {
                        Element anode = dom.createElement("BorderAttrs");
                        if (custom.hasAttribute("pattern") && StatGraph.isNumber(str = custom.getAttribute("pattern")) && Double.parseDouble(str) >= 0.0) {
                            anode.setAttribute("pattern", str);
                        }
                        if (custom.hasAttribute("color")) {
                            anode.setAttribute("color", custom.getAttribute("color"));
                        }
                        if (custom.hasAttribute("width")) {
                            anode.setAttribute("thickness", custom.getAttribute("width"));
                        }
                        drawNode.appendChild(anode);
                    }
                } else if (index == 5) {
                    if (attachedToData && !invalidDataSpace) {
                        drawNode.setAttribute("width", Double.toString(x2 - x1));
                        drawNode.setAttribute("widthUnit", "data");
                    } else {
                        drawNode.setAttribute("width", Double.toString(100.0 * (x2 - x1)));
                        drawNode.setAttribute("widthUnit", "percent");
                    }
                    custom = dom.createElement("EntryItem");
                    Text aa = dom.createTextNode(elem.getAttribute("text"));
                    custom.appendChild(aa);
                    drawNode.appendChild(custom);
                    elem.removeAttribute("text");
                    drawNode.setAttribute("labelPosition", "center");
                } else if (index == 7) {
                    int ix1 = (int)Double.parseDouble(elem.getAttribute("SAnchorX"));
                    int ix2 = (int)Double.parseDouble(elem.getAttribute("SSecondaryX"));
                    int iy1 = (int)Double.parseDouble(elem.getAttribute("SAnchorY"));
                    int iy2 = (int)Double.parseDouble(elem.getAttribute("SSecondaryY"));
                    int sz = Math.max(1, Math.min(Math.abs(iy2 - iy1), Math.abs(ix2 - ix1)) - 8);
                    drawNode.setAttribute("size", Integer.toString(sz));
                    custom = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
                    Element markerAttrs = null;
                    if (custom != null && custom.hasAttribute("color")) {
                        markerAttrs = dom.createElement("MarkerAttrs");
                        markerAttrs.setAttribute("color", custom.getAttribute("color"));
                    }
                    elem.setAttribute("markerAttrs", "AnnoShape");
                    if (elem.hasAttribute("symbol")) {
                        if (markerAttrs == null) {
                            markerAttrs = dom.createElement("MarkerAttrs");
                        }
                        if (StatGraph.isNumber(str = elem.getAttribute("symbol"))) {
                            int shape = (int)Double.parseDouble(str);
                            str = Markers.getShapeName((int)shape);
                        }
                        markerAttrs.setAttribute("symbol", str);
                    }
                    if (markerAttrs != null) {
                        drawNode.appendChild(markerAttrs);
                    }
                }
                if (elem.hasAttribute("Rotation")) {
                    str = elem.getAttribute("Rotation");
                    if (StatGraph.isNumber(str)) {
                        double val;
                        for (val = -1.0 * Double.parseDouble(str) * 180.0 / Math.PI; val < 0.0; val += 360.0) {
                        }
                        while (val > 360.0) {
                            val -= 360.0;
                        }
                        str = Double.toString(val);
                    }
                    drawNode.setAttribute("rotate", str);
                }
            }
            drawNode.setAttribute("name", elem.getAttribute("name"));
            drawNode.setAttribute("index", Integer.toString(position));
            if (elem.hasAttribute("group")) {
                drawNode.setAttribute("group", elem.getAttribute("group"));
            }
            if (elem.hasAttribute("text")) {
                drawNode.setAttribute("label", elem.getAttribute("text"));
            }
            if ((custom = StatGraph.getOptionAttrsElement(elem, "TextAttrs")) != null) {
                drawNode.appendChild(custom);
            }
            if (elem.hasAttribute("textPosition")) {
                String str = elem.getAttribute("textPosition");
                if (str.equalsIgnoreCase("start")) {
                    str = "begin";
                } else if (str.equalsIgnoreCase("through")) {
                    str = "center";
                }
                drawNode.setAttribute("labelPosition", str);
            }
            if (elem.hasAttribute("textAlignment")) {
                switch (Integer.parseInt(elem.getAttribute("textAlignment"))) {
                    case 2: {
                        drawNode.setAttribute("justify", "left");
                        break;
                    }
                    case 4: {
                        drawNode.setAttribute("justify", "right");
                        break;
                    }
                    default: {
                        drawNode.setAttribute("justify", "center");
                        break;
                    }
                }
            } else {
                drawNode.setAttribute("justify", "left");
            }
            if (panel || invalidDataSpace || parent == null) {
                graphNode.appendChild(drawNode);
                continue;
            }
            parent.appendChild(drawNode);
            if (elem.hasAttribute("clipOutside")) {
                drawNode.setAttribute("clip", elem.getAttribute("clipOutside"));
                continue;
            }
            if (!clip) continue;
            drawNode.setAttribute("clip", "true");
        }
        aElem.getParentNode().removeChild(aElem);
    }

    public static Element getElementFromID(Element graphNode, String id) {
        for (Node node = graphNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (id.equals(e.getAttribute("name"))) {
                return e;
            }
            if ((e = StatGraph.getElementFromID(e, id)) == null) continue;
            return e;
        }
        return null;
    }

    public static boolean isValidDataSpace(Element node) {
        String elemTag = node.getTagName();
        if (!elemTag.equals("LayoutOverlay") && !elemTag.equals("LayoutOverlayEquated")) {
            return false;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            elemTag = ((Element)child).getTagName();
            if (elemTag.equals("ScatterPlot")) {
                return true;
            }
            if (elemTag.equals("TextPlot")) {
                return true;
            }
            if (elemTag.equals("SeriesPlot")) {
                return true;
            }
            if (elemTag.equals("StepPlot")) {
                return true;
            }
            if (elemTag.equals("NeedlePlot")) {
                return true;
            }
            if (elemTag.equals("VectorPlot")) {
                return true;
            }
            if (elemTag.equals("BandPlot")) {
                return true;
            }
            if (elemTag.equals("BoxPlotParm")) continue;
            if (elemTag.equals("HistogramParm")) {
                return true;
            }
            if (elemTag.equals("LineParm")) {
                return true;
            }
            if (elemTag.equals("ReferenceLine") || elemTag.equals("DropLine")) continue;
            if (elemTag.equals("EllipseParm")) {
                return true;
            }
            if (elemTag.equals("ContourPlotParm")) {
                return true;
            }
            if (elemTag.equals("BarChartParm")) {
                return true;
            }
            if (elemTag.equals("ParetoLine")) {
                return true;
            }
            if (elemTag.equals("FringePlot") || elemTag.equals("BlockPlot")) continue;
            if (elemTag.equals("WaterfallChart")) {
                return true;
            }
            if (elemTag.equals("Dendrogram")) {
                return true;
            }
            if (elemTag.equals("BubblePlot")) {
                return true;
            }
            if (elemTag.equals("HeatmapParm")) {
                return true;
            }
            if (elemTag.equals("LineChart")) {
                return true;
            }
            if (elemTag.equals("TimeSeriesPlot")) {
                return true;
            }
            if (!elemTag.equals("RangeAttrMapView")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryX(Element node) {
        String elemTag = node.getTagName();
        if (!elemTag.equals("LayoutOverlay") && !elemTag.equals("LayoutOverlayEquated")) {
            return true;
        }
        boolean secondary = false;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element elem;
            if (!(child instanceof Element) || !(elemTag = (elem = (Element)child).getTagName()).equals("ScatterPlot") && !elemTag.equals("TextPlot") && !elemTag.equals("SeriesPlot") && !elemTag.equals("StepPlot") && !elemTag.equals("NeedlePlot") && !elemTag.equals("VectorPlot") && !elemTag.equals("BandPlot") && !elemTag.equals("BoxPlotParm") && !elemTag.equals("HistogramParm") && !elemTag.equals("LineParm") && !elemTag.equals("ReferenceLine") && !elemTag.equals("DropLine") && !elemTag.equals("EllipseParm") && !elemTag.equals("ContourPlotParm") && !elemTag.equals("BarChartParm") && !elemTag.equals("ParetoLine") && !elemTag.equals("FringePlot") && !elemTag.equals("BlockPlot") && !elemTag.equals("WaterfallChart") && !elemTag.equals("Dendrogram") && !elemTag.equals("BubblePlot") && !elemTag.equals("HeatmapParm") && !elemTag.equals("LineChart") && !elemTag.equals("TimeSeriesPlot") && !elemTag.equals("RangeAttrMapView")) continue;
            if (elem.hasAttribute("xAxis") && "x2".equalsIgnoreCase(elem.getAttribute("xAxis"))) {
                secondary = true;
                continue;
            }
            return true;
        }
        return !secondary;
    }

    public static boolean isPrimaryY(Element node) {
        String elemTag = node.getTagName();
        if (!elemTag.equals("LayoutOverlay") && !elemTag.equals("LayoutOverlayEquated")) {
            return true;
        }
        boolean secondary = false;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element elem;
            if (!(child instanceof Element) || !(elemTag = (elem = (Element)child).getTagName()).equals("ScatterPlot") && !elemTag.equals("TextPlot") && !elemTag.equals("SeriesPlot") && !elemTag.equals("StepPlot") && !elemTag.equals("NeedlePlot") && !elemTag.equals("VectorPlot") && !elemTag.equals("BandPlot") && !elemTag.equals("BoxPlotParm") && !elemTag.equals("HistogramParm") && !elemTag.equals("LineParm") && !elemTag.equals("ReferenceLine") && !elemTag.equals("DropLine") && !elemTag.equals("EllipseParm") && !elemTag.equals("ContourPlotParm") && !elemTag.equals("BarChartParm") && !elemTag.equals("ParetoLine") && !elemTag.equals("FringePlot") && !elemTag.equals("BlockPlot") && !elemTag.equals("WaterfallChart") && !elemTag.equals("Dendrogram") && !elemTag.equals("BubblePlot") && !elemTag.equals("HeatmapParm") && !elemTag.equals("LineChart") && !elemTag.equals("TimeSeriesPlot") && !elemTag.equals("RangeAttrMapView")) continue;
            if (elem.hasAttribute("yAxis") && "y2".equalsIgnoreCase(elem.getAttribute("yAxis"))) {
                secondary = true;
                continue;
            }
            return true;
        }
        return !secondary;
    }

    public static Node getDataContainer(Element node) {
        String elemTag = node.getTagName();
        if (elemTag.equals("LayoutOverlay") || elemTag.equals("LayoutOverlayEquated") || elemTag.equals("LayoutPrototype") || elemTag.equals("LayoutPrototypeOverlay2D")) {
            return node;
        }
        if (elemTag.equals("ScatterPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("TextPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("SeriesPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("StepPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("NeedlePlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("VectorPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("BandPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("BoxPlotParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("HistogramParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("LineParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("ReferenceLine")) {
            return node.getParentNode();
        }
        if (elemTag.equals("DropLine")) {
            return node.getParentNode();
        }
        if (elemTag.equals("EllipseParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("ContourPlotParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("BarChartParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("ParetoLine")) {
            return node.getParentNode();
        }
        if (elemTag.equals("FringePlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("BlockPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("WaterfallChart")) {
            return node.getParentNode();
        }
        if (elemTag.equals("Dendrogram")) {
            return node.getParentNode();
        }
        if (elemTag.equals("BubblePlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("HeatmapParm")) {
            return node.getParentNode();
        }
        if (elemTag.equals("LineChart")) {
            return node.getParentNode();
        }
        if (elemTag.equals("TimeSeriesPlot")) {
            return node.getParentNode();
        }
        if (elemTag.equals("RangeAttrMapView")) {
            return node.getParentNode();
        }
        return null;
    }

    public int unscaleFontSize(int fs) {
        double nfs = (double)fs / (this.fontScaleFactor * this.getShrinkageScale() * 100.0 / 72.0);
        if (nfs <= 12.0) {
            nfs = (double)fs / (this.fontScaleFactor * this.getShrinkageScale() * 1.3);
        }
        fs = (int)Math.round(nfs / (dataDPIScaleFactor * dataSizeScaleFactor));
        return fs;
    }

    public HashMap getGraphNamesRefs() {
        return this.graphNamesRefs;
    }

    public HashMap getGraphNamesTable() {
        return this.graphNamesTable;
    }

    public static JComponent parseThirdPartyComponent(StatGraph graph, Element elem) {
        JComponent comp = null;
        String elemName = elem.getNodeName();
        String clsName = RB.getStringResource(RB_KEY, elemName + ".parser.class.txt");
        try {
            Class<?> cls = Class.forName(clsName);
            Class[] parms = new Class[]{StatGraph.class, Element.class};
            Method meth = cls.getMethod("load", parms);
            Object[] args = new Object[]{graph, elem};
            comp = (JComponent)meth.invoke(null, args);
            if (!thirdPartyComponents.contains(cls)) {
                thirdPartyComponents.add(cls);
            }
        }
        catch (Exception ex) {
            StatGraph.printDebug(ex.getMessage());
        }
        return comp;
    }

    public static void parsingDone() {
        if (thirdPartyComponents.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < thirdPartyComponents.size(); ++i) {
                Class cls = thirdPartyComponents.get(i);
                Method meth = cls.getMethod("parsingDone", null);
                meth.invoke(null, null);
            }
        }
        catch (Exception ex) {
            StatGraph.printDebug(ex.getMessage());
        }
    }

    public static boolean isBundleAttributeFixed(Element elem, String bundleName, String attributeName) {
        return StatGraph.isBundleAttributeFixed(elem, bundleName, attributeName, false);
    }

    public static boolean isBundleAttributeFixed(Element elem, String bundleName, String attributeName, boolean elemOnly) {
        if (!elemOnly && elem.hasAttribute(bundleName)) {
            return true;
        }
        String str = bundleName.substring(0, 1).toUpperCase() + bundleName.substring(1, bundleName.length());
        Element e = StatGraph.getOptionAttrsElement(elem, str);
        if (e != null) {
            return e.hasAttribute(attributeName);
        }
        return false;
    }

    public static boolean isTransparencyFixed(Element elem, String bundleName) {
        return StatGraph.isTransparencyFixed(elem, StatGraph.getOptionAttrsElement(elem, bundleName));
    }

    public static boolean isTransparencyFixed(Element elem, Element bundleElem) {
        if (elem.hasAttribute("dataTransparency")) {
            return true;
        }
        if (bundleElem != null) {
            return bundleElem.hasAttribute("transparency");
        }
        return false;
    }

    public static int getAttributeType(Element elem, String attr) {
        String str = elem.getAttribute(attr + "_type");
        int type = -1;
        if (str.equalsIgnoreCase("Variable")) {
            type = 0;
        } else if (str.equalsIgnoreCase("String")) {
            type = 1;
        } else if (str.equalsIgnoreCase("Numeric")) {
            type = 2;
        } else if (str.equalsIgnoreCase("Keyword")) {
            type = 3;
        }
        return type;
    }

    public static NumericVariable getOLAPMeasureVar(DataModel model, String varName) {
        List l;
        OLAPVariableFactory fac = model.getOLAPVarFactory();
        if (StatGraph.isUseResultSetID()) {
            varName = fac.getUniqueLevelName(varName);
        }
        if (!(l = fac.getMeasureNames()).contains(varName)) {
            return null;
        }
        OLAPMeasureVariable om = new OLAPMeasureVariable();
        om.connectFrom(fac, varName);
        return om;
    }

    public static NumericVariable getOLAPMeasureVar(CRD crd, short role) {
        List l;
        OLAPVariableFactory fac = crd.getOLAPVarFactory();
        String varName = crd.getColumnName(role);
        if (StatGraph.isUseResultSetID()) {
            varName = fac.getUniqueLevelName(varName);
        }
        if (!(l = fac.getMeasureNames()).contains(varName)) {
            return null;
        }
        OLAPMeasureVariable om = new OLAPMeasureVariable();
        om.connectFrom(fac, varName);
        return om;
    }

    public static StringVariable getOLAPLevelVar(CRD crd, Short role) {
        OLAPVariableFactory fac = crd.getOLAPVarFactory();
        String varName = crd.getColumnName(role);
        if (StatGraph.isUseResultSetID()) {
            varName = fac.getHierarchyNameFromResultId(varName);
        }
        return StatGraph.getOLAPLevelVar(fac, varName);
    }

    public static StringVariable getOLAPLevelVar(OLAPVariableFactory fac, String varName) {
        List l = fac.getHeirarchyNames(1);
        if (!l.contains(varName) && !(l = fac.getHeirarchyNames(0)).contains(varName)) {
            return null;
        }
        OLAPLevelVariable ol = new OLAPLevelVariable();
        ol.connectFrom(fac, varName);
        return ol;
    }

    public static String getOLAPFormat(CRD crd, Short role) {
        OLAPVariableFactory fac = crd.getOLAPVarFactory();
        String varName = crd.getColumnName(role);
        if (StatGraph.isUseResultSetID()) {
            varName = fac.getUniqueLevelName(varName);
        }
        return fac.getFormat(varName);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    private void checkParsingStatus() {
        if (this.rootPanel.getComponentCount() == 0) {
            this.validGraphCount = 0;
            return;
        }
        this.checkChildren(this.rootPanel);
    }

    private void checkChildren(JComponent parent) {
        int count = parent.getComponentCount();
        if (count == 0) {
            return;
        }
        Component[] comp = parent.getComponents();
        for (int i = 0; i < count; ++i) {
            if (comp[i] instanceof BaseOverlayContainer) {
                Simple2DOverlayComposite sc = ((BaseOverlayContainer)comp[i]).getComposite();
                if (sc == null) continue;
                this.validGraphCount += sc.getNumOverlays();
                continue;
            }
            if (comp[i] instanceof Region) {
                ++this.validGraphCount;
                continue;
            }
            if (!(comp[i] instanceof JComponent)) continue;
            this.checkChildren((JComponent)comp[i]);
        }
    }

    void addSupportedGraph() {
        ++this.supportedGraphCount;
    }

    public boolean hasForeignObject() {
        return this.hasForeignObject;
    }

    public boolean hasValidGraph() {
        return this.validGraphCount > 0;
    }

    public boolean areAllGraphsRendered() {
        return this.supportedGraphCount > 0 && this.supportedGraphCount == this.validGraphCount;
    }

    public String getDrillTarget() {
        return this.drillTarget;
    }

    public void setDrillTarget(String drillTarget) {
        this.drillTarget = drillTarget;
    }

    public boolean isSALabeling() {
        return this.saLabeling;
    }

    public void setSALabeling(boolean value) {
        this.saLabeling = value;
    }

    public boolean isLabelDisplaceable() {
        return this.labelDisplaceable;
    }

    public boolean isLabelVerbose() {
        return this.labelVerbose;
    }

    public HashMap getSAWeightMap() {
        return this.saWeightMap;
    }

    public int getSAMaxIterations() {
        return this.saMaxIterations;
    }

    public int getSASeed() {
        return this.saSeed;
    }

    public void parseLabelPlacementOpts(Element elem) {
        this.labelVerbose = elem.getAttribute("debugOption").equalsIgnoreCase("sasstgr_lp");
        Element saOpts = StatGraph.getOptionAttrsElement(elem, "SAPlacementOpts");
        if (saOpts == null) {
            if (this.saLabeling) {
                this.saWeightMap = SALabeling.createDefaultWeightMap();
            }
            return;
        }
        String str = saOpts.getAttribute("maxIterations");
        if (str.length() > 0 && StatGraph.isNumber(str)) {
            this.saMaxIterations = (int)Double.parseDouble(str);
        }
        if ((str = saOpts.getAttribute("seed")).length() > 0 && StatGraph.isNumber(str)) {
            this.saSeed = (int)Double.parseDouble(str);
        }
        if (!this.saLabeling) {
            this.saWeightMap = null;
            return;
        }
        this.saWeightMap = SALabeling.createDefaultWeightMap();
        Element weightElem = StatGraph.getOptionAttrsElement(saOpts, "Weights");
        if (weightElem == null) {
            return;
        }
        String elemTag = "";
        for (Node node = weightElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String weight;
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Weight")) continue;
            String name = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null || !StatGraph.isNumber(weight = child.getNodeValue())) continue;
            this.saWeightMap.put(name.toUpperCase(), weight);
        }
    }

    private void addStyleFontName(ArrayList styleFonts, String elemName) {
        String names;
        StyleElement textElem = this.style.getGraphStyle().getStyleElement(elemName);
        if (textElem != null && (names = textElem.getAttribute("fontFamily")) != null && names.length() > 0) {
            String[] fonts = StatGraph.parseList2String(names, ",");
            for (int i = 0; i < fonts.length; ++i) {
                if (styleFonts.contains(fonts[i])) continue;
                styleFonts.add(fonts[i]);
            }
        }
    }

    public void dumpSupportedFonts(Element elem) {
        boolean dumpFonts = elem.getAttribute("debugOption").equalsIgnoreCase("sasstgr_javaFonts");
        if (!dumpFonts) {
            return;
        }
        ArrayList styleFonts = new ArrayList();
        this.addStyleFontName(styleFonts, "ValueText");
        this.addStyleFontName(styleFonts, "TitleText");
        this.addStyleFontName(styleFonts, "FootnoteText");
        this.addStyleFontName(styleFonts, "LabelText");
        this.addStyleFontName(styleFonts, "DataText");
        this.addStyleFontName(styleFonts, "UnicodeText");
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = e.getAvailableFontFamilyNames();
        StatGraph.printNote("Supported Font Families:");
        for (String font : fonts) {
            if (styleFonts.contains(font)) {
                styleFonts.remove(font);
            }
            System.out.println(font);
        }
        System.out.println("");
        if (styleFonts.size() > 0) {
            StatGraph.printNote("Unsupported font families defined in the graph style:");
            for (int i = 0; i < styleFonts.size(); ++i) {
                System.out.println((String)styleFonts.get(i));
            }
        }
        System.out.println("");
    }

    public boolean isQCGlobalLegend() {
        return this.qcGlobalLegend;
    }

    public void setQCGlobalLegend(boolean qcGlobalLegend) {
        this.qcGlobalLegend = qcGlobalLegend;
    }

    public HashMap getElementToObjectMap() {
        return this.elementToObject;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
        this.rootPanel.setOpaque(!transparentBackground);
    }

    public boolean isSubpixelRenderingRequired(Element elem) {
        if (elem.getElementsByTagName("ScatterPlot").getLength() > 0) {
            return false;
        }
        if (elem.getElementsByTagName("ScatterPlotMatrix").getLength() > 0) {
            return false;
        }
        if (elem.getElementsByTagName("SeriesPlot").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("BandPlot").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("BoxPlotParm").getLength() > 0 || elem.getElementsByTagName("BoxParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("HistogramParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("ContourPlotParm").getLength() > 0 || elem.getElementsByTagName("ContourParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("BarChartParm").getLength() > 0 || elem.getElementsByTagName("BarParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("ParetoLine").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("HeatmapParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("WaterfallChart").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("BubblePlot").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("HighLowPlot").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("HeatBoxParm").getLength() > 0) {
            return true;
        }
        if (elem.getElementsByTagName("LineChart").getLength() > 0) {
            return true;
        }
        return elem.getElementsByTagName("PolygonPlot").getLength() > 0;
    }

    public void addSubpixelRenderer(Object renderer) {
        this.subpixelRenderers.add(renderer);
    }

    public boolean updateAAMax(int max) {
        if (max > this.dataAntialisingThreshold) {
            this.aaMax = Math.max(this.aaMax, max);
            return false;
        }
        return true;
    }

    public void processAAMax() {
        if (!this.dataAntialiased || this.aaMax < 0 || VGF) {
            return;
        }
        this.dataAntialiased = false;
        this.subpixelRendering = false;
        for (int i = 0; i < this.subpixelRenderers.size(); ++i) {
            Object r = this.subpixelRenderers.get(i);
            if (r == null) continue;
            if (r instanceof Simple2DOverlayComposite) {
                Simple2DOverlayComposite soc = (Simple2DOverlayComposite)r;
                soc.subpixelRendering = false;
                if (soc.getOverlays() == null) continue;
                for (int j = 0; j < soc.getOverlays().size(); ++j) {
                    ((Overlay)soc.getOverlays().get(j)).setSubpixelRendering(false);
                }
                continue;
            }
            if (r instanceof GridAxis) {
                ((GridAxis)r).setSubpixelRendering(false);
                continue;
            }
            if (!(r instanceof AbstractAnno)) continue;
            ((AbstractAnno)r).setSubpixelRendering(false);
        }
        Message msg = new Message(RB.getStringResource(RB_KEY, "antialiasing2.fmt.txt"));
        StatGraph.printNote(msg.toString((Object)String.valueOf(String.valueOf(StatGraph.roundToNextHundreds(this.aaMax)))));
    }

    public boolean updateTipMax(int max) {
        if (max > this.imagemapThreshold) {
            this.tipMax = Math.max(this.tipMax, max);
            return false;
        }
        return true;
    }

    public void processTipMax() {
        if (!this.imagemapEnabled || this.tipMax < 0) {
            return;
        }
        Message msg = new Message(RB.getStringResource(RB_KEY, "tooltip2.fmt.txt"));
        StatGraph.printNote(msg.toString((Object)String.valueOf(String.valueOf(StatGraph.roundToNextHundreds(this.tipMax)))), false);
    }

    public int getAxisBreakSymbol() {
        return this.axisBreakSymbol;
    }

    public void setAxisBreakSymbol(int axisBreakSymbol) {
        this.axisBreakSymbol = axisBreakSymbol;
    }

    public boolean isDiscreteOffsetPadding() {
        return this.discreteOffsetPadding;
    }

    public void setDiscreteOffsetPadding(boolean discreteOffsetPadding) {
        this.discreteOffsetPadding = discreteOffsetPadding;
    }
}

