/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ScatterParser {
    public static final String RB_KEY = "ScatterParser.";

    public static ScatterOverlay load(StatGraph graph, Element elem) {
        ScatterOverlay plot = (ScatterOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new ScatterOverlay(0);
        }
        return ScatterParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, ScatterOverlay plot, Element elem) {
        Encoder encoder;
        HashMap<String, Serializable> table;
        String freqVarID;
        int ii;
        int position;
        ColumnMetadata cmd;
        String groupVarID;
        String msVarID;
        String mcgVarID;
        String str;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = ScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        if (!StatGraph.VGF && (str = elem.getAttribute("subPixel")).equalsIgnoreCase("off")) {
            plot.setSubpixelOff(true);
        }
        str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (plot.getYAxis().equalsIgnoreCase("y2")) {
            plot.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            plot.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        boolean errorbarUnmapped = false;
        if (plot.isDiscreteX()) {
            if (map.isRoleMapped(26)) {
                map.unmapRole(26);
                errorbarUnmapped = true;
            }
            if (map.isRoleMapped(27)) {
                map.unmapRole(27);
                errorbarUnmapped = true;
            }
        }
        if (plot.isDiscreteY()) {
            if (map.isRoleMapped(28)) {
                map.unmapRole(28);
                errorbarUnmapped = true;
            }
            if (map.isRoleMapped(29)) {
                map.unmapRole(29);
                errorbarUnmapped = true;
            }
        }
        if (errorbarUnmapped) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "errorbar.txt"));
        }
        Element labelElem = null;
        Element markerElem = null;
        Element markerCharacterElem = null;
        Element errorElem = null;
        Element markerFillElem = null;
        Element markerOutlineElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerCharacterAttrs")) {
                markerCharacterElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("ErrorBarAttrs")) {
                errorElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs")) {
                markerFillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs")) continue;
            markerOutlineElem = (Element)node;
        }
        String msgVarID = null;
        boolean labelsAsMarkers = false;
        boolean groupedMarkerSymbol = false;
        str = elem.getAttribute("markerCharacter");
        if (str.length() > 0) {
            msgVarID = StatGraph.getVarID(str);
        }
        if (msgVarID != null && msgVarID.length() > 0) {
            labelsAsMarkers = true;
            int msgcol = m.getColumn(msgVarID);
            map.map(5, msgcol);
            plot.addRole("MARKERCHARACTER", m.getColumnLabel(msgcol));
        } else {
            String symbolGroupRole = "symbolGroup";
            if (elem.hasAttribute(symbolGroupRole)) {
                symbolGroupRole = "markerSymbolGroup";
            }
            groupedMarkerSymbol = StatGraph.parseMarkerSymbolGroup(graph, elem, map, m, plot, symbolGroupRole);
        }
        boolean gradientMarkerColor = false;
        boolean groupedMarkerColor = false;
        String colorResponseRole = "colorResponse";
        str = elem.getAttribute("colorResponse");
        if (str.length() == 0) {
            str = elem.getAttribute("markerColorGradient");
            colorResponseRole = "markerColorGradient";
        }
        if ((mcgVarID = StatGraph.getVarID(str)).length() > 0) {
            int mcgcol = m.getColumn(mcgVarID);
            if (StatGraph.checkVariable(colorResponseRole.toUpperCase(), m.getColumnLabel(mcgcol), Double.class, 1, false)) {
                gradientMarkerColor = true;
                map.map(45, mcgcol);
                plot.addRole(colorResponseRole.toUpperCase(), m.getColumnLabel(mcgcol));
                str = elem.getAttribute(colorResponseRole + "AttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("MARKERCOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
                }
            }
        } else {
            groupedMarkerColor = StatGraph.parseMarkerColorGroup(graph, elem, map, m, plot, "colorGroup");
        }
        if (gradientMarkerColor) {
            Color missingGradientColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
            plot.setMissingGradientColor(missingGradientColor);
        }
        boolean markerSizeVar = false;
        String sizeResponseRole = "sizeResponse";
        str = elem.getAttribute("sizeResponse");
        if (str.length() == 0) {
            str = elem.getAttribute("markerSizeResponse");
            sizeResponseRole = "markerSizeResponse";
        }
        if ((msVarID = StatGraph.getVarID(str)).length() > 0) {
            if (StatGraph.isOLAP()) {
                markerSizeVar = true;
                map.map(7, msVarID);
            } else {
                int mscol = m.getColumn(msVarID);
                if (StatGraph.checkVariable(sizeResponseRole.toUpperCase(), m.getColumnLabel(mscol), Double.class, 1, false)) {
                    markerSizeVar = true;
                    map.map(7, mscol);
                    plot.addRole(sizeResponseRole.toUpperCase(), m.getColumnLabel(mscol));
                }
            }
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        MarkerAttrs ms = new MarkerAttrs();
        String mrkAttr = elem.getAttribute("markerAttrs");
        GraphStyle.setDefaultMarkerStyle(graph, mrkAttr, ms, contextName);
        int defaultMarkerSize = ms.getSize();
        if (markerElem != null) {
            StatGraph.parseMarkerAttrs(graph, markerElem, ms);
        }
        if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("size")) {
            plot.setUseMarkerSize(true);
        }
        if (markerElem != null && markerElem.hasAttribute("weight")) {
            plot.setUseMarkerWeight(true);
        }
        boolean markersVisible = ms.getSize() > 0;
        boolean filledOutlinedMarker = false;
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true") && !labelsAsMarkers) {
            plot.setFilledOutlinedMarker(true);
            filledOutlinedMarker = true;
            if (!groupedMarkerColor && (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                plot.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("color")) {
                plot.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("thickness")) {
                plot.setUseMarkerOutlineAttrsThickness(true);
            }
            GraphStyle.setDefaultFillStyle(graph, mrkFillAttr, plot.getMarkerFillStyle(), contextName);
            if (markerFillElem != null) {
                StatGraph.parseFillAttrs(graph, markerFillElem, plot.getMarkerFillStyle());
            }
            GraphStyle.setDefaultLineStyle(graph, mrkOutlineAttr, plot.getMarkerOutlineStyle(), "Outlines");
            if (markerOutlineElem != null) {
                StatGraph.parseLineAttrs(graph, markerOutlineElem, plot.getMarkerOutlineStyle());
            }
        }
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID = StatGraph.getVarID(str = elem.getAttribute("group")), plot.getStmt())) {
            groupVarID = "";
        }
        if (groupVarID.length() > 0 && !groupedMarkerColor && !groupedMarkerSymbol) {
            if (StatGraph.isOLAP()) {
                map.map(3, groupVarID);
                map.map(45, groupVarID);
                map.map(8, groupVarID);
            } else {
                String indexVarID;
                int ii2;
                int gcol = m.getColumn(groupVarID);
                if (!gradientMarkerColor) {
                    if (labelsAsMarkers) {
                        map.map(45, gcol);
                    } else if (filledOutlinedMarker) {
                        map.map(45, gcol);
                        if (!(mrkFillAttr.length() != 0 || markerFillElem != null && markerFillElem.hasAttribute("color"))) {
                            map.map(69, gcol);
                        }
                    } else if (!(mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                        map.map(45, gcol);
                    }
                }
                if (!(gradientMarkerColor || mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                    map.map(45, gcol);
                }
                if (!(!markersVisible || labelsAsMarkers || mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("symbol"))) {
                    map.map(8, gcol);
                }
                map.map(3, gcol);
                plot.addRole("GROUP", m.getColumnLabel(gcol));
                if (map.isRoleMapped(8) || map.isRoleMapped(45)) {
                    str = elem.getAttribute("groupAttrVar");
                    if (str.length() > 0) {
                        DiscreteAttrMapper mapper = graph.getDiscreteAttrVar(str);
                        if (mapper == null) {
                            mapper = graph.getRangeAttrVar(str);
                        }
                        plot.addAttrVar("GROUP", (AttrMapper)mapper);
                    } else {
                        DAMDatasetParser.addInternalAttrVar(graph, plot, "GROUP", groupVarID);
                    }
                }
                if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii2 = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii2, "INDEX", indexVarID)) {
                    if (map.isRoleMapped(45) && !gradientMarkerColor) {
                        map.map(41, ii2);
                    }
                    if (markersVisible && !labelsAsMarkers && map.isRoleMapped(8)) {
                        map.map(42, ii2);
                    }
                    plot.addRole("INDEX", m.getColumnLabel(ii2));
                }
            }
            str = elem.getAttribute("includeMissingGroup");
            if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else if (str.equalsIgnoreCase("ReverseData")) {
                    plot.setGroupOrder(3);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError("GROUPORDER", str);
                }
            } else if (graph.isCASData()) {
                plot.setGroupOrder(1);
            }
            str = elem.getAttribute("clusterWidth");
            if (StatGraph.isNumber(str)) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
            str = elem.getAttribute("clusterAxis");
            if (str.equalsIgnoreCase("X")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_X);
            } else if (str.equalsIgnoreCase("Y")) {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_Y);
            } else {
                plot.setClusterAxis(ScatterOverlay.CLUSTER_AUTO);
            }
        }
        if (graph.isCASData()) {
            plot.setDrawByGroupOrder(true);
        }
        StatGraph.parseURLOpt(elem, m, map, plot);
        boolean labelVisible = false;
        boolean labelingEnabled = true;
        if (labelsAsMarkers) {
            labelVisible = true;
            plot.setDataLabelSplit(false);
            plot.setFixedDataLabelPosition(ScatterParser.parseMarkerCharacterPosition(elem));
            str = elem.getAttribute("outlinedMarkerCharacters");
            if (str.equalsIgnoreCase("true")) {
                plot.setOutlinedMarkerCharacters(true);
                plot.setTextBacklight(1.0);
            }
        } else {
            str = elem.getAttribute("dataLabel");
            String labelVarID = StatGraph.getVarID(str);
            if (labelVarID.length() > 0) {
                int lcol = m.getColumn(labelVarID);
                map.map(5, lcol);
                labelVisible = true;
                cmd = (ColumnMetadata)m.getColumnLabel(lcol);
                int nms = cmd.getNobs() - cmd.getMissings();
                if (nms == 0) {
                    labelVisible = false;
                    labelingEnabled = false;
                } else {
                    Message msg;
                    labelVisible = true;
                    boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                    if (!labelingEnabled) {
                        msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(nms))), false);
                    } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                        labelingEnabled = false;
                        msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(cmd.getNobs()))), false);
                    }
                }
                plot.addRole("DATALABEL", m.getColumnLabel(lcol));
            }
        }
        if (labelVisible) {
            plot.setLabelVisible(true);
        }
        if (!labelsAsMarkers && (position = ScatterParser.parseDataLabelPosition(elem)) != -1) {
            labelingEnabled = false;
            plot.setFixedDataLabelPosition(position);
            ScatterParser.parseDataLabelSplitting(plot, elem);
        }
        if ((str = elem.getAttribute("freq")).length() > 0 && StatGraph.checkVariable("FREQ", m.getColumnLabel(ii = m.getColumn(freqVarID = StatGraph.getVarID(str))), Double.class, false)) {
            cmd = (ColumnMetadata)m.getColumnLabel(ii);
            if (cmd.getNobs() == cmd.getMissings() || cmd.getMax() < 1.0) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "freq.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)cmd.getName()));
                return false;
            }
            map.map(51, ii);
            plot.addRole("FREQ", m.getColumnLabel(ii));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        plot.setLabelsAsMarkers(labelsAsMarkers);
        if (labelsAsMarkers) {
            plot.setLabelCollisionAvoidance(false);
        } else {
            plot.setLabelCollisionAvoidance(labelingEnabled);
        }
        plot.setGradientMarkerColor(gradientMarkerColor);
        str = elem.getAttribute("dataSelectable");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !ScatterParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        StatGraph.parseDataSkinOpt(graph, elem, plot);
        if (plot.isTooltipEnabled()) {
            plot.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        plot.setModel(crd);
        if (!markersVisible || labelsAsMarkers) {
            plot.setDefaultMarkerShape((short)-1);
            plot.setDefaultMarkerColor(ms.getColor());
            if (labelsAsMarkers) {
                String mca = elem.getAttribute("markerCharacterAttrs");
                GraphStyle.setDefaultTextStyle(graph, mca, plot.getMarkerCharacterStyle(), "DataText");
                if (markerCharacterElem != null) {
                    StatGraph.parseTextAttrs(graph, markerCharacterElem, plot.getMarkerCharacterStyle());
                    if (markerCharacterElem.hasAttribute("color") && !gradientMarkerColor && !groupedMarkerColor && map.isRoleMapped(45)) {
                        map.unmapRole(45);
                    }
                } else if (mca.length() > 0 && map.isRoleMapped(45)) {
                    map.unmapRole(45);
                }
            }
        } else {
            plot.setDefaultMarkerColor(ms.getColor());
            plot.setMarkerTransparency(ms.getTransparency());
            plot.setDefaultMarkerShape((short)ms.getShape());
            plot.setDefaultMarkerWeight(ms.getWeight());
            if (!markerSizeVar) {
                plot.setMinMarkerSize(ms.getSize());
                plot.setMaxMarkerSize(ms.getSize());
                plot.setDefaultMarkerScale(0.0);
            } else {
                String an;
                int minMarker = defaultMarkerSize;
                int maxMarker = 3 * defaultMarkerSize;
                str = elem.getAttribute("sizeMin");
                if (str.length() == 0) {
                    str = elem.getAttribute("markerSizeMin");
                }
                if (StatGraph.isNumber(str)) {
                    minMarker = graph.unit2MarkerSize(str);
                } else if (str.indexOf(":") >= 0) {
                    String en = GraphStyle.parseStyleElementName(str);
                    an = GraphStyle.parseStyleAttributeName(str);
                    en = graph.style.getGraphStyle().remapDataElement(en, an);
                    if (en != null) {
                        minMarker = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                    }
                }
                str = elem.getAttribute("sizeMax");
                if (str.length() == 0) {
                    str = elem.getAttribute("markerSizeMax");
                }
                if (StatGraph.isNumber(str)) {
                    maxMarker = graph.unit2MarkerSize(str);
                } else if (str.indexOf(":") >= 0) {
                    String en = GraphStyle.parseStyleElementName(str);
                    an = GraphStyle.parseStyleAttributeName(str);
                    en = graph.style.getGraphStyle().remapDataElement(en, an);
                    if (en != null) {
                        maxMarker = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                    }
                }
                if (minMarker < maxMarker) {
                    plot.setMinMarkerSize(minMarker);
                    plot.setMaxMarkerSize(maxMarker);
                } else {
                    plot.setMinMarkerSize(defaultMarkerSize);
                    plot.setMaxMarkerSize(3 * defaultMarkerSize);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "mmmarker.txt"));
                }
            }
        }
        if (labelVisible && !labelsAsMarkers) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), plot.getLabelStyle(), "DataText");
            if (groupVarID.length() <= 0 && !gradientMarkerColor || StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(ms.getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs(graph, labelElem, plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if ((str = elem.getAttribute("useDiscreteSize")).length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setUseDiscreteSizs(true);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("discreteMarkerSize"))) {
            double size = Double.parseDouble(str);
            plot.setDiscreteMarkerSize(size);
        }
        if ((str = elem.getAttribute("errorBarCapShape")).equalsIgnoreCase("none")) {
            plot.setErrorCapVisible(false);
        } else if (str.equalsIgnoreCase("serif")) {
            plot.setErrorCapVisible(true);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("errorBarCapeShape", str);
        } else {
            str = graph.style.getStyleAttribute("Error", "capStyle");
            if (str != null && str.length() > 0) {
                if (str.equalsIgnoreCase("none")) {
                    plot.setErrorCapVisible(false);
                } else if (str.equalsIgnoreCase("serif")) {
                    plot.setErrorCapVisible(true);
                }
            }
        }
        str = elem.getAttribute("errorBarCapScale");
        if (StatGraph.isNumber(str)) {
            plot.setCapScale(Double.parseDouble(str));
        }
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("errorBarAttrs"), plot.getErrorBarStyle(), "Error");
        if (StatGraph.isBundleAttributeFixed(elem, "errorBarAttrs", "color")) {
            plot.setUseErrorBarStyle(1);
        } else if (groupVarID.length() == 0 && !gradientMarkerColor) {
            plot.setUseErrorBarStyle(1);
            if (graph.style.isCycleAttrs()) {
                plot.getErrorBarStyle().setColor(ms.getColor());
            }
        }
        if (errorElem != null) {
            StatGraph.parseLineAttrs(graph, errorElem, plot.getErrorBarStyle());
        }
        if ((str = elem.getAttribute("labelStrip")).equalsIgnoreCase("true")) {
            plot.setStripMarkerCharacter(true);
        }
        str = elem.getAttribute("jitter");
        plot.setJitter(false);
        if (str.length() > 0 && !str.equalsIgnoreCase("NONE")) {
            if (str.equalsIgnoreCase("AUTO")) {
                plot.setJitter(true);
            } else {
                StatGraph.printOptionError("JITTER", str);
            }
        }
        if (plot.isJitter()) {
            Element jElem = StatGraph.getOptionAttrsElement(elem, "JitterOpts");
            if (jElem != null) {
                str = jElem.getAttribute("axis");
                if (str.length() > 0) {
                    if (str.equalsIgnoreCase("X")) {
                        plot.setJitterAxis(1);
                    } else if (str.equalsIgnoreCase("Y")) {
                        plot.setJitterAxis(2);
                    } else if (str.equalsIgnoreCase("BOTH") && !plot.isDiscreteX() && !plot.isDiscreteY()) {
                        plot.setJitterAxis(3);
                    } else if (!str.equalsIgnoreCase("AUTO")) {
                        StatGraph.printOptionError("AXIS", str);
                    }
                }
                if (StatGraph.isNumber(str = jElem.getAttribute("width"))) {
                    double jw = Double.parseDouble(str);
                    if (jw < 0.0) {
                        StatGraph.printOptionError("WIDTH", str);
                    } else {
                        plot.setJitterWidth(jw);
                    }
                }
                if ((str = jElem.getAttribute("uniform")).equalsIgnoreCase("true")) {
                    plot.setUniformJitter(true);
                }
            }
            if (plot.resolveJitterType() != 3 && !plot.isJitterable()) {
                plot.setJitter(false);
            }
        }
        ScatterParser.parseSelectionColor(plot, graph);
        ScatterParser.parseLabelVisibles(plot, elem);
        plot.setUseMarkerTransparency(StatGraph.isTransparencyFixed(elem, markerElem));
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(45)) {
            if (gradientMarkerColor) {
                ColorEncoder encoder2 = StatGraph.parseColorModelOpt((byte)16, graph, elem, plot, plot.getMarkerTransparency());
                if (encoder2 != null) {
                    plot.setEncoder((byte)16, encoder2);
                }
            } else {
                RangeColorMapper rcm = plot.getGroupRangeMapper();
                if (rcm != null) {
                    Object[] rLabels = plot.getRangeLabels(rcm, (short)45);
                    table = new HashMap<String, Serializable>();
                    for (int i = 0; i < rLabels.length; ++i) {
                        table.put(rLabels[i], rcm.getMappedMarkerAttrs((String)rLabels[i]).getColor());
                    }
                    DiscreteRange dr = new DiscreteRange(rLabels);
                    encoder = new ColorEncoder(dr, table);
                    plot.setEncoder((byte)16, encoder);
                } else {
                    graph.style.setContextCount(contextCount);
                    LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)16, plot.getMarkerTransparency(), !groupedMarkerColor);
                }
            }
        }
        if (crd.isAvailable(69)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)24, plot.getMarkerTransparency(), !groupedMarkerColor);
        }
        if (crd.isAvailable(8)) {
            RangeColorMapper rcm = plot.getGroupRangeMapper();
            if (rcm != null) {
                Object[] rLabels = plot.getRangeLabels(rcm, (short)8);
                table = new HashMap();
                for (int i = 0; i < rLabels.length; ++i) {
                    table.put(rLabels[i], new Integer(rcm.getMappedMarkerAttrs((String)rLabels[i]).getShape()));
                }
                DiscreteRange dr = new DiscreteRange(rLabels);
                encoder = new ShapeEncoder(dr, table);
                plot.setEncoder((byte)6, encoder);
            } else {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)6, !groupedMarkerSymbol);
            }
        }
        if (crd.isAvailable(26)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)7);
        }
        if (crd.isAvailable(27)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)8);
        }
        if (crd.isAvailable(28)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)9);
        }
        if (crd.isAvailable(29)) {
            LayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)10);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    public static boolean isDiscreteOffsetSupported(ScatterOverlay plot) {
        return plot.isDiscreteX() || plot.isDiscreteY();
    }

    public static void parseSelectionColor(ScatterOverlay plot, StatGraph graph) {
        MarkerAttrs ms = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle(graph, "", ms, "Selection");
    }

    public static void parseLabelVisibles(ScatterOverlay plot, Element elem) {
        String str = elem.getAttribute("invisiblePointLabels");
        if (str.length() > 0) {
            int[] obs = StatGraph.parseList2Int(str);
            plot.setInitialHideLabelObs(obs);
        }
    }

    public static DataModel parseXYVariables(ScatterOverlay plot, StatGraph graph, Element elem, RoleColumnMap map) {
        String xelVarID;
        int xelcol;
        String xeuVarID;
        int xeucol;
        int ycol;
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        Element rElem = StatGraph.getOptionAttrsElement(elem, "YVars");
        DataModel model = graph.getData(dataName);
        if (model == null) {
            model = graph.getOLAPModel(dataName);
            map.map(10, xVarID);
            map.map(11, yVarID);
            return model;
        }
        int xcol = model.getColumn(xVarID);
        int n = ycol = rElem == null ? model.getColumn(yVarID) : -1;
        if (rElem != null && StatGraph.parseStringValueList(rElem, "Value").length == 1) {
            yVarID = StatGraph.getVarID(StatGraph.parseStringValueList(rElem, "Value")[0]);
            ycol = model.getColumn(yVarID);
        }
        switch (plot.getPlotType()) {
            case 0: {
                if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true)) {
                    return null;
                }
                if (StatGraph.checkVariable("Y", model.getColumnLabel(ycol), null, 1, true)) break;
                return null;
            }
            case 1: {
                str = elem.getAttribute("orient");
                if (str.equalsIgnoreCase("horizontal")) {
                    int t = xcol;
                    xcol = ycol;
                    ycol = t;
                    plot.setVerticalFill(false);
                }
                if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true)) {
                    return null;
                }
                if (rElem == null || StatGraph.parseStringValueList(rElem, "Value").length == 1) {
                    if (StatGraph.checkVariable("Y", model.getColumnLabel(ycol), null, 1, true)) break;
                    return null;
                }
                String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
                int cnt = 0;
                for (int i = 0; i < multiResponseVars.length; ++i) {
                    str = multiResponseVars[i];
                    yVarID = StatGraph.getVarID(str);
                    if (yVarID.length() <= 0 || !StatGraph.checkVariable("Y", model.getColumnLabel(ycol = model.getColumn(yVarID)), Double.class, 1, true)) continue;
                    map.map(610 + cnt, ycol);
                    plot.addRole("MULTI_RESPONSE" + cnt, model.getColumnLabel(ycol));
                    ++cnt;
                }
                if (cnt <= 0) {
                    return null;
                }
                plot.setResponseCount(cnt);
                map.map(10, xcol);
                plot.addRole("X", model.getColumnLabel(xcol));
                return model;
            }
            case 5: {
                str = elem.getAttribute("orient");
                String cat = "X";
                String res = "Y";
                int catcol = xcol;
                int rescol = ycol;
                if (str.equalsIgnoreCase("horizontal")) {
                    int t = xcol;
                    xcol = ycol;
                    ycol = t;
                    plot.setVerticalFill(false);
                    cat = "Y";
                    res = "X";
                    catcol = ycol;
                    rescol = xcol;
                }
                if (!StatGraph.checkVariable(cat, model.getColumnLabel(catcol), null, 1, true)) {
                    return null;
                }
                if (StatGraph.checkVariable(res, model.getColumnLabel(rescol), Double.class, 1, true)) break;
                return null;
            }
            case 2: 
            case 3: {
                if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true)) {
                    return null;
                }
                if (StatGraph.checkVariable("Y", model.getColumnLabel(ycol), Double.class, 1, true)) break;
                return null;
            }
            case 4: {
                if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), Double.class, 1, true)) {
                    return null;
                }
                if (StatGraph.checkVariable("Y", model.getColumnLabel(ycol), Double.class, 1, true)) break;
                return null;
            }
        }
        map.map(10, xcol);
        map.map(11, ycol);
        plot.addRole("X", model.getColumnLabel(xcol));
        plot.addRole("Y", model.getColumnLabel(ycol));
        str = elem.getAttribute("xErrorUpper");
        if (str.length() > 0 && StatGraph.checkVariable("XERRORUPPER", model.getColumnLabel(xeucol = model.getColumn(xeuVarID = StatGraph.getVarID(str))), Double.class, false)) {
            map.map(26, xeucol);
            plot.addRole("XERRORUPPER", model.getColumnLabel(xeucol));
        }
        if ((str = elem.getAttribute("xErrorLower")).length() > 0 && StatGraph.checkVariable("XERRORLOWER", model.getColumnLabel(xelcol = model.getColumn(xelVarID = StatGraph.getVarID(str))), Double.class, false)) {
            map.map(27, xelcol);
            plot.addRole("XERRORLOWER", model.getColumnLabel(xelcol));
        }
        if ((str = elem.getAttribute("yErrorUpper")).length() > 0) {
            String yeuVarID = StatGraph.getVarID(str);
            int yeucol = model.getColumn(yeuVarID);
            if (StatGraph.checkVariable("YERRORUPPER", model.getColumnLabel(yeucol), Double.class, false)) {
                map.map(28, yeucol);
                plot.addRole("YERRORUPPER", model.getColumnLabel(yeucol));
            }
        } else {
            String euVarID;
            int eucol;
            str = elem.getAttribute("errorUpper");
            if (str.length() > 0 && StatGraph.checkVariable("ERRORUPPER", model.getColumnLabel(eucol = model.getColumn(euVarID = StatGraph.getVarID(str))), Double.class, false)) {
                map.map(28, eucol);
                plot.addRole("ERRORUPPER", model.getColumnLabel(eucol));
            }
        }
        str = elem.getAttribute("yErrorLower");
        if (str.length() > 0) {
            String yelVarID = StatGraph.getVarID(str);
            int yelcol = model.getColumn(yelVarID);
            if (StatGraph.checkVariable("YERRORLOWER", model.getColumnLabel(yelcol), Double.class, false)) {
                map.map(29, yelcol);
                plot.addRole("YERRORLOWER", model.getColumnLabel(yelcol));
            }
        } else {
            String elVarID;
            int elcol;
            str = elem.getAttribute("errorLower");
            if (str.length() > 0 && StatGraph.checkVariable("ERRORLOWER", model.getColumnLabel(elcol = model.getColumn(elVarID = StatGraph.getVarID(str))), Double.class, false)) {
                map.map(29, elcol);
                plot.addRole("ERRORLOWER", model.getColumnLabel(elcol));
            }
        }
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        if (model == null) {
            types[0] = 0;
            types[1] = 0;
            types[2] = 0;
            return types;
        }
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        Element rElem = StatGraph.getOptionAttrsElement(elem, "YVars");
        int xcol = model.getColumn(xVarID);
        int ycol = rElem == null ? model.getColumn(yVarID) : -1;
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        if (rElem == null) {
            cmd = (ColumnMetadata)model.getColumnLabel(ycol);
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                    return null;
                }
                types[1] = 2;
            } else {
                types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            }
        } else {
            types[1] = 0;
        }
        types[2] = 0;
        if (elem.getTagName().equals("SeriesPlot") && (str = elem.getAttribute("orient")).length() > 0 && str.equalsIgnoreCase("Horizontal")) {
            int temp = types[0];
            types[0] = types[1];
            types[1] = temp;
        }
        return types;
    }

    protected static int parseMarkerCharacterPosition(Element elem) {
        String str = elem.getAttribute("markerCharacterPosition");
        if (str.equalsIgnoreCase("TOP")) {
            return 0;
        }
        if (str.equalsIgnoreCase("BOTTOM")) {
            return 1;
        }
        if (str.equalsIgnoreCase("LEFT")) {
            return 2;
        }
        if (str.equalsIgnoreCase("RIGHT")) {
            return 3;
        }
        if (str.equalsIgnoreCase("CENTER")) {
            return 4;
        }
        if (str.equalsIgnoreCase("TOPLEFT")) {
            return 5;
        }
        if (str.equalsIgnoreCase("TOPRIGHT")) {
            return 6;
        }
        if (str.equalsIgnoreCase("BOTTOMLEFT")) {
            return 7;
        }
        if (str.equalsIgnoreCase("BOTTOMRIGHT")) {
            return 8;
        }
        if (str.length() > 0) {
            StatGraph.printOptionError("MARKERCHARACTERPOSITION", str);
        }
        return 4;
    }

    protected static int parseDataLabelPosition(Element elem) {
        String str = elem.getAttribute("dataLabelPosition");
        if (str.equalsIgnoreCase("AUTO")) {
            return -1;
        }
        if (str.equalsIgnoreCase("TOP")) {
            return 0;
        }
        if (str.equalsIgnoreCase("BOTTOM")) {
            return 1;
        }
        if (str.equalsIgnoreCase("LEFT")) {
            return 2;
        }
        if (str.equalsIgnoreCase("RIGHT")) {
            return 3;
        }
        if (str.equalsIgnoreCase("CENTER")) {
            return 4;
        }
        if (str.equalsIgnoreCase("TOPLEFT")) {
            return 5;
        }
        if (str.equalsIgnoreCase("TOPRIGHT")) {
            return 6;
        }
        if (str.equalsIgnoreCase("BOTTOMLEFT")) {
            return 7;
        }
        if (str.equalsIgnoreCase("BOTTOMRIGHT")) {
            return 8;
        }
        if (str.length() > 0) {
            StatGraph.printOptionError("DATALABELPOSITION", str);
        }
        return -1;
    }

    public static boolean checkIndexColumn(DataModel m, int col, String option, String colName) {
        boolean ok = true;
        double[] data = m.getDoubleColumn(col);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == (double)((int)data[i])) continue;
            Message msg = new Message(RB.getStringResource(RB_KEY, "index.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)option, (Object)colName));
            return false;
        }
        return ok;
    }

    public static void parseDataLabelSplitting(Overlay plot, Element elem) {
        boolean isTextPlot = elem.getAttribute("_stmt").equalsIgnoreCase("textplot");
        String str = elem.getAttribute("dataLabelSplit");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataLabelSplit(true);
        }
        if ((str = elem.getAttribute(isTextPlot ? "splitChar" : "dataLabelSplitChar")).length() > 0) {
            char[] schars = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                schars[i] = str.charAt(i);
            }
            plot.setDataLabelSplitChar(schars);
        }
        if ((str = elem.getAttribute(isTextPlot ? "splitCharDrop" : "dataLabelSplitCharDrop")).length() > 0 && str.equalsIgnoreCase("false")) {
            plot.setDataLabelSplitCharDrop(false);
        }
        if ((str = elem.getAttribute(isTextPlot ? "splitJustify" : "dataLabelSplitJustify")).length() > 0) {
            if (str.equalsIgnoreCase("left")) {
                plot.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_LEFT);
            } else if (str.equalsIgnoreCase("right")) {
                plot.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_RIGHT);
            } else if (str.equalsIgnoreCase("center")) {
                plot.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_CENTER);
            } else if (str.equalsIgnoreCase("auto")) {
                plot.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_AUTO);
            } else {
                StatGraph.printOptionError("DATALABELSPLITJUSTIFY", str);
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute(isTextPlot ? "splitWidth" : "dataLabelSplitWidth"))) {
            plot.setDataLabelNumSplitChars((int)Double.parseDouble(str));
        }
    }

    public static void parseCurveLabelSplitting(StatGraph graph, Overlay plot, Element elem) {
        String str;
        if (graph.isSALabeling() || !graph.isLabelDisplaceable()) {
            plot.setPadSplittedCurveLabel(false);
        }
        if ((str = elem.getAttribute("curveLabelSplit")).length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setCurveLabelSplit(true);
        }
        if ((str = elem.getAttribute("curveLabelSplitChar")).length() > 0) {
            char[] schars = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                schars[i] = str.charAt(i);
            }
            plot.setCurveLabelSplitChar(schars);
        }
        if ((str = elem.getAttribute("curveLabelSplitCharDrop")).length() > 0 && str.equalsIgnoreCase("false")) {
            plot.setCurveLabelSplitCharDrop(false);
        }
        if ((str = elem.getAttribute("curveLabelSplitJustify")).length() > 0) {
            if (str.equalsIgnoreCase("left")) {
                plot.setCurveLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_LEFT);
            } else if (str.equalsIgnoreCase("right")) {
                plot.setCurveLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_RIGHT);
            } else if (str.equalsIgnoreCase("center")) {
                plot.setCurveLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_CENTER);
            } else if (str.equalsIgnoreCase("auto")) {
                plot.setCurveLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_AUTO);
            } else {
                StatGraph.printOptionError("CURVELABELSPLITJUSTIFY", str);
            }
        }
    }
}

