/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.DefaultAnnotationContainer;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.SizeAndSpace;
import com.sas.graphics.applets.statgraph.BaseStatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SGAnnotationContainer
extends DefaultAnnotationContainer {
    private BaseOverlayContainer boc = null;
    private TrellisPlot trellisPlot = null;

    public SGAnnotationContainer(Container container, Container rootContainer) {
        super(container, rootContainer);
        if (container instanceof BaseOverlayContainer) {
            if (container.getParent() == rootContainer) {
                this.boc = (BaseOverlayContainer)container;
            }
        } else if (container instanceof TrellisPlot) {
            this.trellisPlot = (TrellisPlot)container;
        }
    }

    public Container getPrimaryContainer() {
        return this.container;
    }

    public Point2D.Double getScreenPoint(PointAndSpace p, double dataDPIScaleFactor) {
        Point origin;
        Point2D.Double pt = super.getScreenPoint(p, dataDPIScaleFactor);
        if (p.ySpace != 3 && p.ySpace != 2 || !(p.y instanceof Number) || this.boc == null && this.trellisPlot == null) {
            return pt;
        }
        double yd = ((Number)p.y).doubleValue();
        double yo = 0.0;
        double height = 0.0;
        Point point = origin = this.container != null ? SwingUtilities.convertPoint(this.container, 0, 0, this.graphContainer) : new Point(0, 0);
        if (this.boc != null) {
            double y1 = 0.0;
            for (int i = 0; i < this.boc.getTitleCount(); ++i) {
                y1 += (double)this.boc.getTitle(i).getHeight();
            }
            double y2 = 0.0;
            for (int i = 0; i < this.boc.getFootnoteCount(); ++i) {
                y2 += (double)this.boc.getFootnote(i).getHeight();
            }
            height = (double)this.boc.getHeight() - y1 - y2;
            yo = (double)origin.y + y1;
        } else if (this.trellisPlot != null) {
            double y1 = 0.0;
            ArrayList titles = this.trellisPlot.getTitles();
            for (int i = 0; i < titles.size(); ++i) {
                y1 += (double)((Component)titles.get(i)).getHeight();
            }
            double y2 = 0.0;
            ArrayList footnotes = this.trellisPlot.getFootnotes();
            for (int i = 0; i < footnotes.size(); ++i) {
                y2 += (double)((Component)footnotes.get(i)).getHeight();
            }
            height = (double)this.trellisPlot.getHeight() - y1 - y2;
            yo = (double)origin.y + y1;
        } else if (this.graphContainer instanceof BaseStatGraphPanel) {
            double y2;
            double y1;
            BaseStatGraphPanel gr = (BaseStatGraphPanel)this.graphContainer;
            JPanel pp = gr.graph.getTitlePanel();
            double d = y1 = pp == null ? 0.0 : (double)pp.getHeight();
            y1 = y1 > (double)TrellisLayout.titleFootnoteSpacing ? (y1 += (double)(2 * TrellisLayout.titleFootnoteSpacing)) : 0.0;
            pp = gr.graph.getFootnotePanel();
            double d2 = y2 = pp == null ? 0.0 : (double)pp.getHeight();
            y2 = y2 > (double)TrellisLayout.titleFootnoteSpacing ? (y2 += (double)(2 * TrellisLayout.titleFootnoteSpacing)) : 0.0;
            height = (double)gr.getHeight() - y1 - y2;
            yo = (double)origin.y + y1;
        } else {
            return pt;
        }
        if (p.ySpace == 3) {
            pt.setLocation(pt.getX(), yo + (100.0 - yd) * height / 100.0);
        } else {
            pt.setLocation(pt.getX(), yo + (height - dataDPIScaleFactor * yd));
        }
        return pt;
    }

    public Point2D.Double getScreenSize(SizeAndSpace sz, double dataDPIScaleFactor) {
        Point2D.Double size = super.getScreenSize(sz, dataDPIScaleFactor);
        if (sz.heightSpace != 3 || Double.isNaN(sz.height) || this.boc == null && this.trellisPlot == null) {
            return size;
        }
        double ht = 0.0;
        if (this.boc != null) {
            double y1 = 0.0;
            for (int i = 0; i < this.boc.getTitleCount(); ++i) {
                y1 += (double)this.boc.getTitle(i).getHeight();
            }
            double y2 = 0.0;
            for (int i = 0; i < this.boc.getFootnoteCount(); ++i) {
                y2 += (double)this.boc.getFootnote(i).getHeight();
            }
            ht = (double)this.boc.getHeight() - y1 - y2;
        } else if (this.trellisPlot != null) {
            double y1 = 0.0;
            ArrayList titles = this.trellisPlot.getTitles();
            for (int i = 0; i < titles.size(); ++i) {
                y1 += (double)((Component)titles.get(i)).getHeight();
            }
            double y2 = 0.0;
            ArrayList footnotes = this.trellisPlot.getFootnotes();
            for (int i = 0; i < footnotes.size(); ++i) {
                y2 += (double)((Component)footnotes.get(i)).getHeight();
            }
            ht = (double)this.trellisPlot.getHeight() - y1 - y2;
        } else if (this.graphContainer instanceof BaseStatGraphPanel) {
            double y2;
            double y1;
            BaseStatGraphPanel gr = (BaseStatGraphPanel)this.graphContainer;
            JPanel pp = gr.graph.getTitlePanel();
            double d = y1 = pp == null ? 0.0 : (double)pp.getHeight();
            y1 = y1 > (double)TrellisLayout.titleFootnoteSpacing ? (y1 += (double)(2 * TrellisLayout.titleFootnoteSpacing)) : 0.0;
            pp = gr.graph.getFootnotePanel();
            double d2 = y2 = pp == null ? 0.0 : (double)pp.getHeight();
            y2 = y2 > (double)TrellisLayout.titleFootnoteSpacing ? (y2 += (double)(2 * TrellisLayout.titleFootnoteSpacing)) : 0.0;
            ht = (double)gr.getHeight() - y1 - y2;
        } else {
            return size;
        }
        size.setLocation(size.getX(), sz.height * ht / 100.0);
        return size;
    }

    public void update(PointAndSpace p, double dataDPIScaleFactor, Point2D.Double loc) {
        super.update(p, dataDPIScaleFactor, loc);
        if (p.ySpace != 3 && p.ySpace != 2 || !(p.y instanceof Number) || this.boc == null && this.trellisPlot == null) {
            return;
        }
        double yd = ((Number)p.y).doubleValue();
        int yo = 0;
        int height = 0;
        if (this.boc != null) {
            int y1 = 0;
            for (int i = 0; i < this.boc.getTitleCount(); ++i) {
                y1 += this.boc.getTitle(i).getHeight();
            }
            int y2 = 0;
            for (int i = 0; i < this.boc.getFootnoteCount(); ++i) {
                y2 += this.boc.getFootnote(i).getHeight();
            }
            height = this.boc.getHeight() - y1 - y2;
            yo = this.boc.getY() + y1;
        } else if (this.trellisPlot != null) {
            int y1 = 0;
            ArrayList titles = this.trellisPlot.getTitles();
            for (int i = 0; i < titles.size(); ++i) {
                y1 += ((Component)titles.get(i)).getHeight();
            }
            int y2 = 0;
            ArrayList footnotes = this.trellisPlot.getFootnotes();
            for (int i = 0; i < footnotes.size(); ++i) {
                y2 += ((Component)footnotes.get(i)).getHeight();
            }
            height = this.trellisPlot.getHeight() - y1 - y2;
            yo = this.trellisPlot.getY() + y1;
        } else if (this.graphContainer instanceof BaseStatGraphPanel) {
            int y2;
            int y1;
            BaseStatGraphPanel gr = (BaseStatGraphPanel)this.graphContainer;
            JPanel pp = gr.graph.getTitlePanel();
            int n = y1 = pp == null ? 0 : pp.getHeight();
            y1 = y1 > TrellisLayout.titleFootnoteSpacing ? (y1 += 2 * TrellisLayout.titleFootnoteSpacing) : 0;
            pp = gr.graph.getFootnotePanel();
            int n2 = y2 = pp == null ? 0 : pp.getHeight();
            y2 = y2 > TrellisLayout.titleFootnoteSpacing ? (y2 += 2 * TrellisLayout.titleFootnoteSpacing) : 0;
            height = gr.getHeight() - y1 - y2;
            yo = gr.getY() + y1;
        } else {
            return;
        }
        p.y = p.ySpace == 3 ? new Double(100.0 - (loc.getY() - (double)yo) * 100.0 / (double)height) : new Double(((double)height - (loc.getY() - (double)yo)) / dataDPIScaleFactor);
    }

    public void update(SizeAndSpace size, double dataDPIScaleFactor, Point2D.Double newSize) {
        super.update(size, dataDPIScaleFactor, newSize);
        if (size.heightSpace != 3 || this.boc == null && this.trellisPlot == null) {
            return;
        }
        int ht = 0;
        if (this.boc != null) {
            int y1 = 0;
            for (int i = 0; i < this.boc.getTitleCount(); ++i) {
                y1 += this.boc.getTitle(i).getHeight();
            }
            int y2 = 0;
            for (int i = 0; i < this.boc.getFootnoteCount(); ++i) {
                y2 += this.boc.getFootnote(i).getHeight();
            }
            ht = this.boc.getHeight() - y1 - y2;
        } else if (this.trellisPlot != null) {
            int y1 = 0;
            ArrayList titles = this.trellisPlot.getTitles();
            for (int i = 0; i < titles.size(); ++i) {
                y1 += ((Component)titles.get(i)).getHeight();
            }
            int y2 = 0;
            ArrayList footnotes = this.trellisPlot.getFootnotes();
            for (int i = 0; i < footnotes.size(); ++i) {
                y2 += ((Component)footnotes.get(i)).getHeight();
            }
            ht = this.trellisPlot.getHeight() - y1 - y2;
        } else if (this.graphContainer instanceof BaseStatGraphPanel) {
            int y2;
            int y1;
            BaseStatGraphPanel gr = (BaseStatGraphPanel)this.graphContainer;
            JPanel pp = gr.graph.getTitlePanel();
            int n = y1 = pp == null ? 0 : pp.getHeight();
            y1 = y1 > TrellisLayout.titleFootnoteSpacing ? (y1 += 2 * TrellisLayout.titleFootnoteSpacing) : 0;
            pp = gr.graph.getFootnotePanel();
            int n2 = y2 = pp == null ? 0 : pp.getHeight();
            y2 = y2 > TrellisLayout.titleFootnoteSpacing ? (y2 += 2 * TrellisLayout.titleFootnoteSpacing) : 0;
            ht = gr.getHeight() - y1 - y2;
        } else {
            return;
        }
        size.height = new Double(newSize.getY() * 100.0 / (double)ht);
    }
}

