/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.NoWrapEditorKit;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.WrapEditorKit;
import com.sas.graphics.applets.statgraph.sgchart.grid.OuterPadBorder;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.vgf.VGFGraphics2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public final class RotatedJTextPane
extends JTextPane {
    public static AttributedCharacterIterator.Attribute[] attributes = new AttributedCharacterIterator.Attribute[]{TextAttribute.FOREGROUND, TextAttribute.FONT, TextAttribute.FAMILY, TextAttribute.SIZE, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SUPERSCRIPT};
    private double theta = 0.0;
    private boolean antialiased = true;
    private RotatedJTextPane shortPane;
    private double hAlign = 0.5;
    public static final int WRAP = 0;
    public static final int SHORT = 1;
    public static final int TRUNCATE = 2;
    public static final int CLIP = 3;
    public static final int NONE = 4;
    private int shortenPolicy = 0;
    private boolean underOutmostLayout = false;
    private boolean paintEnabled = true;
    public AttributedString at = null;
    private TextStyle truncationTextStyle = new TextStyle();

    public RotatedJTextPane() {
        this.setEditable(false);
        this.setDoubleBuffered(false);
        for (int i = 0; i < this.getMouseListeners().length; ++i) {
            this.removeMouseListener(this.getMouseListeners()[i]);
        }
    }

    public TextStyle getTruncationTextStyle() {
        return this.truncationTextStyle;
    }

    public void setTruncationTextStyle(TextStyle style) {
        this.truncationTextStyle = style;
    }

    public double getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(double align) {
        this.hAlign = align;
    }

    public void setShortText(DefaultStyledDocument doc) {
        if (doc == null || doc.getLength() == 0) {
            return;
        }
        this.shortPane = new RotatedJTextPane();
        this.shortPane.setShortenPolicy(3);
        this.shortPane.setBorder(this.getBorder());
        this.shortPane.setOpaque(this.isOpaque());
        this.shortPane.setBackground(this.getBackground());
        this.shortPane.setTheta(this.getTheta());
        this.shortPane.setAntialiased(this.isAntialiased());
        this.shortPane.setAlignmentX(this.getAlignmentX());
        this.shortPane.setHAlign(this.getHAlign());
        this.shortPane.setDocument(doc);
    }

    public void setShortenPolicy(int policy) {
        this.shortenPolicy = policy;
        if (policy == 3) {
            this.setEditorKit(new NoWrapEditorKit());
        } else if (policy == 2) {
            this.setEditorKit(new WrapEditorKit());
        }
    }

    public int getShortenPolicy() {
        return this.shortenPolicy;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension oldPS = this.getPreferredSize();
        super.setBounds(x, y, width, height);
        if (this.shortenPolicy == 4) {
            return;
        }
        if (this.shortenPolicy == 0 && !this.underOutmostLayout) {
            this.shortenPolicy = 3;
        }
        if (this.shortenPolicy == 3) {
            this.setPreferredSize(oldPS);
            return;
        }
        Dimension newPS = this.getPreferredSize();
        Insets is = this.getInsets();
        if ((double)(newPS.height - is.top - is.bottom) > 1.5 * (double)(oldPS.height - is.top - is.bottom)) {
            switch (this.shortenPolicy) {
                default: {
                    StatGraph.textWrapped = true;
                    SimpleAttributeSet set = new SimpleAttributeSet();
                    if (this.hAlign == 0.0) {
                        StyleConstants.setAlignment(set, 0);
                    } else if (this.hAlign == 1.0) {
                        StyleConstants.setAlignment(set, 2);
                    } else {
                        StyleConstants.setAlignment(set, 1);
                    }
                    this.setParagraphAttributes(set, false);
                    break;
                }
                case 1: {
                    Container parent;
                    if (this.shortPane == null || (parent = this.getParent()) == null) break;
                    parent.remove(this);
                    this.setVisible(false);
                    parent.add(this.shortPane);
                    StatGraph.textWrapped = true;
                    this.at = null;
                    break;
                }
                case 2: {
                    Document doc = this.getDocument();
                    this.truncate(doc, width);
                    this.setPreferredSize(oldPS);
                }
            }
        }
    }

    private void truncate(Document doc, double len) {
        if (doc.getLength() < 3) {
            return;
        }
        SimpleAttributeSet set = EntryConcatParser.createAttributeSet(this.truncationTextStyle, null, false, false, false, false);
        try {
            doc.insertString(doc.getLength(), "...", set);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        while (true) {
            try {
                double l;
                do {
                    doc.remove(doc.getLength() - 4, 1);
                } while (!((l = this.getPreferredSize().getWidth()) < len) && doc.getLength() != 3);
            }
            catch (BadLocationException badLocationException) {
                continue;
            }
            break;
        }
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
        if (theta == 90.0 || theta == 270.0) {
            Border bd = this.getBorder();
            if (bd instanceof OuterPadBorder) {
                Insets in = this.getInsets();
                if (theta == 90.0) {
                    this.setBorder((Border)new OuterPadBorder(in.left, in.bottom, in.right, in.top));
                } else {
                    this.setBorder((Border)new OuterPadBorder(in.right, in.top, in.left, in.bottom));
                }
            } else if (bd instanceof EmptyBorder) {
                Insets in = this.getInsets();
                if (theta == 90.0) {
                    this.setBorder(new EmptyBorder(in.left, in.bottom, in.right, in.top));
                } else {
                    this.setBorder(new EmptyBorder(in.right, in.top, in.left, in.bottom));
                }
            } else if (bd instanceof CompoundBorder) {
                CompoundBorder cb = (CompoundBorder)bd;
                Border outsideBorder = cb.getOutsideBorder();
                Border insideBorder = cb.getInsideBorder();
                CompoundBorder ncb = null;
                if (outsideBorder instanceof OuterPadBorder) {
                    Insets in = ((OuterPadBorder)outsideBorder).getBorderInsets();
                    outsideBorder = theta == 90.0 ? new OuterPadBorder(in.left, in.bottom, in.right, in.top) : new OuterPadBorder(in.right, in.top, in.left, in.bottom);
                    if (insideBorder instanceof CompoundBorder) {
                        in = ((EmptyBorder)((CompoundBorder)insideBorder).getInsideBorder()).getBorderInsets();
                        insideBorder = theta == 90.0 ? new CompoundBorder(((CompoundBorder)insideBorder).getOutsideBorder(), new EmptyBorder(in.left, in.bottom, in.right, in.top)) : new CompoundBorder(((CompoundBorder)insideBorder).getOutsideBorder(), new EmptyBorder(in.right, in.top, in.left, in.bottom));
                    } else if (insideBorder instanceof EmptyBorder) {
                        in = ((EmptyBorder)insideBorder).getBorderInsets();
                        insideBorder = theta == 90.0 ? new EmptyBorder(in.left, in.bottom, in.right, in.top) : new EmptyBorder(in.right, in.top, in.left, in.bottom);
                    }
                } else {
                    Insets in = ((EmptyBorder)insideBorder).getBorderInsets();
                    insideBorder = theta == 90.0 ? new EmptyBorder(in.left, in.bottom, in.right, in.top) : new EmptyBorder(in.right, in.top, in.left, in.bottom);
                }
                ncb = new CompoundBorder(outsideBorder, insideBorder);
                this.setBorder(ncb);
            }
            Dimension d = this.getPreferredSize();
            this.setPreferredSize(new Dimension(d.height, d.width));
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean b) {
        this.antialiased = b;
        try {
            Class<?> cls = Class.forName("com.sun.java.swing.SwingUtilities2");
            Field fld = cls.getDeclaredField("AA_TEXT_PROPERTY_KEY");
            this.putClientProperty(fld.get(null), new Boolean(b));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.paintEnabled) {
            Container c = this;
            while (!((Component)c).isOpaque()) {
                c = c.getParent();
            }
            g.setColor(c.getBackground());
            g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            return;
        }
        super.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        AffineTransform at = g2d.getTransform();
        double sx = at.getScaleX();
        double sy = at.getScaleY();
        if (sx < 1.0 || sy < 1.0) {
            Dimension d = this.getPreferredSize();
            Dimension sz = this.getSize();
            if (d.width == sz.width && d.height == sz.height) {
                Font savedFont = this.getFont();
                String text = this.getText();
                int width = g2d.getFontMetrics(savedFont).stringWidth(text);
                Shape clip = g2d.getClip();
                Rectangle bounds = clip.getBounds();
                if (this.theta == 0.0 || this.theta == 180.0) {
                    if ((double)width > Math.ceil((double)sz.width * sx)) {
                        g2d.scale(0.9, 1.0);
                        width = g2d.getFontMetrics(savedFont).stringWidth(text);
                        bounds.width = (int)Math.ceil((double)width / sx);
                        g2d.setClip(bounds);
                    }
                } else if ((double)width > Math.ceil((double)sz.height * sy)) {
                    g2d.scale(0.9, 1.0);
                    width = g2d.getFontMetrics(savedFont).stringWidth(text);
                    bounds.height = (int)Math.ceil((double)width / sx);
                    g2d.setClip(bounds);
                }
            }
        }
        if (this.antialiased) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        Insets in = this.getInsets();
        Rectangle bounds = this.getBounds();
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            Border border = this.getBorder();
            while (border instanceof CompoundBorder) {
                Border outer = ((CompoundBorder)border).getOutsideBorder();
                if (outer == null) continue;
                border = outer;
            }
            if (border instanceof OuterPadBorder) {
                Insets pad = border.getBorderInsets(this);
                g2d.fillRect(pad.left, pad.top, bounds.width - pad.left - pad.right, bounds.height - pad.top - pad.bottom);
            } else {
                g2d.fillRect(0, 0, bounds.width, bounds.height);
            }
        }
        if (this.getText().length() == 0) {
            return;
        }
        AttributedString as = this.getAttributedString();
        if (as != null) {
            float yo;
            float xo;
            TextLayout tl;
            int actualWW;
            LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g2d.getFontRenderContext());
            lbm.setPosition(0);
            int wrappingWidth = bounds.height;
            float hAlign = (float)this.hAlign;
            float valign = this.getAlignmentY();
            if (this.getParent().getComponentCount() == 1) {
                hAlign = this.getParent().getAlignmentX();
                valign = this.getParent().getAlignmentY();
            }
            if (this.theta == 0.0) {
                actualWW = bounds.width - in.left - in.right;
                wrappingWidth = this.shortenPolicy == 0 ? actualWW : Short.MAX_VALUE;
                tl = lbm.nextLayout(wrappingWidth);
                xo = (double)hAlign == 0.0 ? (float)in.left : ((double)hAlign == 1.0 ? (float)in.left + Math.max(0.0f, (float)actualWW - tl.getVisibleAdvance()) : (float)in.left + Math.max(0.0f, ((float)actualWW - tl.getVisibleAdvance()) / 2.0f));
                yo = (float)in.top + tl.getAscent();
                if (StatGraph.VGF && valign != 0.0f) {
                    Dimension ps = this.getPreferredSize();
                    int delta = bounds.height - ps.height;
                    yo = (double)valign == 1.0 ? (yo += (float)delta) : (float)((double)yo + (double)delta / 2.0);
                } else if (valign != 0.0f) {
                    float height = tl.getAscent() + tl.getDescent();
                    while ((tl = lbm.nextLayout(wrappingWidth)) != null) {
                        height += tl.getLeading() + tl.getAscent() + tl.getDescent();
                    }
                    yo = (double)valign == 1.0 ? (yo += Math.max(0.0f, (float)(bounds.height - in.top - in.bottom) - height)) : (yo += Math.max(0.0f, ((float)(bounds.height - in.top - in.bottom) - height) / 2.0f));
                    lbm.setPosition(0);
                    tl = lbm.nextLayout(wrappingWidth);
                }
            } else if (this.theta == 180.0) {
                actualWW = bounds.width - in.left - in.right;
                wrappingWidth = this.shortenPolicy == 0 ? actualWW : Short.MAX_VALUE;
                tl = lbm.nextLayout(wrappingWidth);
                yo = (float)in.bottom + tl.getAscent();
                xo = (double)hAlign == 1.0 ? (float)in.right : ((double)hAlign == 0.0 ? (float)in.right + Math.max(0.0f, (float)actualWW - tl.getVisibleAdvance()) : (float)in.right + Math.max(0.0f, ((float)actualWW - tl.getVisibleAdvance()) / 2.0f));
                if ((double)valign != 1.0) {
                    float height = tl.getAscent() + tl.getDescent();
                    while ((tl = lbm.nextLayout(wrappingWidth)) != null) {
                        height += tl.getLeading() + tl.getAscent() + tl.getDescent();
                    }
                    yo = (double)valign == 0.0 ? (yo += Math.max(0.0f, (float)(bounds.height - in.top - in.bottom) - height)) : (yo += Math.max(0.0f, ((float)(bounds.height - in.top - in.bottom) - height) / 2.0f));
                    lbm.setPosition(0);
                    tl = lbm.nextLayout(wrappingWidth);
                }
                g2d.rotate(Math.PI, bounds.width / 2, bounds.height / 2);
            } else if (this.theta == 90.0) {
                tl = lbm.nextLayout(32767.0f);
                xo = (float)((bounds.width + in.top - in.bottom) / 2) + tl.getAscent() / 2.0f - tl.getDescent() / 2.0f;
                yo = bounds.height - in.left;
                g2d.rotate(-1.5707963267948966, xo, yo);
            } else {
                tl = lbm.nextLayout(32767.0f);
                xo = (float)((bounds.width + in.bottom - in.top) / 2) - tl.getAscent() / 2.0f + tl.getDescent() / 2.0f;
                yo = in.left;
                g2d.rotate(1.5707963267948966, xo, yo);
            }
            int curPos = 0;
            int nextPos = lbm.getPosition();
            while (tl != null) {
                block43: {
                    if (StatGraph.VGF) {
                        AttributedCharacterIterator iter = as.getIterator(attributes, curPos, nextPos);
                        float xx = xo;
                        int start = curPos;
                        int end = iter.getRunLimit();
                        while (true) {
                            block42: {
                                int style;
                                Number num;
                                String family;
                                Font ff;
                                if ((ff = (Font)iter.getAttribute(TextAttribute.FONT)) == null) {
                                    ff = g2d.getFont();
                                }
                                if ((family = (String)iter.getAttribute(TextAttribute.FAMILY)) == null) {
                                    family = ff.getFamily();
                                }
                                float size = (num = (Number)iter.getAttribute(TextAttribute.SIZE)) == null ? (float)ff.getSize() : num.floatValue();
                                boolean italic = (Number)iter.getAttribute(TextAttribute.POSTURE) == TextAttribute.POSTURE_OBLIQUE;
                                boolean bold = (Number)iter.getAttribute(TextAttribute.WEIGHT) == TextAttribute.WEIGHT_BOLD;
                                int n = style = bold ? 1 : 0;
                                if (italic) {
                                    style |= 2;
                                }
                                Number sup = (Number)iter.getAttribute(TextAttribute.SUPERSCRIPT);
                                float offset = 0.0f;
                                int sign = 1;
                                if (sup != null && sup.doubleValue() != 0.0) {
                                    double value = sup.doubleValue();
                                    if (value < 0.0) {
                                        sign *= -1;
                                    }
                                    size = (float)((double)size * (0.6666666666666666 * ((double)sign * value)));
                                    offset = value < 0.0 ? (float)((double)size * 0.5 * Math.pow(0.6666666666666666, (double)sign * value - 1.0)) : (float)((double)(-size) * 0.5 * Math.pow(0.6666666666666666, (double)sign * value - 1.0));
                                }
                                Font font = new Font(family, style, Math.round(size));
                                g2d.setFont(font);
                                g2d.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                                try {
                                    if (StatGraph.VGF && StatGraph.SVG && this.isUnderOutmostLayout()) {
                                        ((VGFGraphics2D)g2d).textClip(false);
                                    }
                                    g2d.drawString(this.getText(start, end - start), xx, yo + offset);
                                    if (!StatGraph.VGF || !StatGraph.SVG || !this.isUnderOutmostLayout()) break block42;
                                    ((VGFGraphics2D)g2d).textClip(true);
                                }
                                catch (BadLocationException ee) {
                                    break block43;
                                }
                            }
                            if (end != nextPos) {
                                xx = (float)((double)xx + g2d.getFontMetrics().getStringBounds(iter, start, end, (Graphics)g2d).getWidth());
                                start = end;
                                iter.setIndex(start);
                                end = iter.getRunLimit();
                                continue;
                            }
                            break block43;
                            break;
                        }
                    }
                    tl.draw(g2d, xo, yo);
                }
                yo += tl.getDescent() + tl.getLeading();
                tl = lbm.nextLayout(wrappingWidth);
                if (tl == null) continue;
                curPos = nextPos;
                nextPos = lbm.getPosition();
                yo += tl.getAscent();
                if ((double)hAlign == 0.0) {
                    xo = in.left;
                    continue;
                }
                if ((double)hAlign == 1.0) {
                    xo = Math.max((float)in.left, (float)(bounds.width - in.right) - tl.getVisibleAdvance());
                    continue;
                }
                xo = Math.max((float)in.left, ((float)(wrappingWidth + in.left) - tl.getVisibleAdvance() - (float)in.right) / 2.0f);
            }
        } else {
            this.setSize(new Dimension(this.getHeight(), this.getHeight()));
            super.paintComponent(g2d);
        }
        g2d.dispose();
    }

    private AttributedString getAttributedString() {
        AttributedString at;
        StyledDocument doc = this.getStyledDocument();
        int length = doc.getLength();
        try {
            at = new AttributedString(doc.getText(0, length));
        }
        catch (BadLocationException e) {
            return null;
        }
        Element elmt = doc.getCharacterElement(0);
        while (elmt != null && elmt.getEndOffset() <= doc.getLength()) {
            this.extractAttributes(at, elmt);
            elmt = doc.getCharacterElement(elmt.getEndOffset());
        }
        return at;
    }

    private void extractAttributes(AttributedString at, Element elmt) {
        if (elmt.getElementCount() == 0) {
            int start = elmt.getStartOffset();
            int end = elmt.getEndOffset();
            AttributeSet as = elmt.getAttributes();
            if (as.isDefined(StyleConstants.Foreground)) {
                at.addAttribute(TextAttribute.FOREGROUND, StyleConstants.getForeground(as), start, end);
            }
            if (as.isDefined(StyleConstants.FontFamily)) {
                at.addAttribute(TextAttribute.FAMILY, StyleConstants.getFontFamily(as), start, end);
            }
            if (as.isDefined(StyleConstants.Size)) {
                at.addAttribute(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(as)), start, end);
            }
            if (as.isDefined(StyleConstants.Bold)) {
                if (StyleConstants.isBold(as)) {
                    at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, start, end);
                } else {
                    at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, start, end);
                }
            }
            if (as.isDefined(StyleConstants.Italic)) {
                if (StyleConstants.isItalic(as)) {
                    at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, start, end);
                } else {
                    at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR, start, end);
                }
            }
            if (as.isDefined(StyleConstants.Subscript) && StyleConstants.isSubscript(as)) {
                at.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, start, end);
            }
            if (as.isDefined(StyleConstants.Superscript) && StyleConstants.isSuperscript(as)) {
                at.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, start, end);
            }
            if (as.isDefined(StyleConstants.Background)) {
                at.addAttribute(TextAttribute.BACKGROUND, StyleConstants.getBackground(as), start, end);
            }
            if (as.isDefined(StyleConstants.Underline)) {
                at.addAttribute(TextAttribute.UNDERLINE, new Boolean(StyleConstants.isUnderline(as)), start, end);
            }
            if (as.isDefined(StyleConstants.StrikeThrough)) {
                at.addAttribute(TextAttribute.STRIKETHROUGH, new Boolean(StyleConstants.isStrikeThrough(as)), start, end);
            }
        } else {
            for (int i = 0; i < elmt.getElementCount(); ++i) {
                this.extractAttributes(at, elmt.getElement(i));
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isVisible()) {
            if (this.at == null && this.getText().length() > 0) {
                this.at = this.getAttributedString();
            }
            Dimension d = super.getPreferredSize();
            if (this.at != null && this.shortenPolicy == 0) {
                Rectangle r = this.getBounds();
                Insets in = this.getInsets();
                int w = r.width;
                Graphics2D g2d = (Graphics2D)this.getGraphics();
                if (g2d == null) {
                    g2d = (Graphics2D)StatGraph.getGraphics();
                }
                if (g2d == null) {
                    return d;
                }
                if (this.antialiased) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                if (w > 0) {
                    int wrappingWidth = w - in.left - in.right;
                    LineBreakMeasurer lbm = new LineBreakMeasurer(this.at.getIterator(), g2d.getFontRenderContext());
                    lbm.setPosition(0);
                    TextLayout tl = lbm.nextLayout(wrappingWidth);
                    float ht = tl.getAscent() + tl.getDescent();
                    float wd = tl.getVisibleAdvance();
                    while ((tl = lbm.nextLayout(wrappingWidth)) != null) {
                        ht += tl.getAscent() + tl.getDescent() + tl.getLeading();
                        wd += Math.max(wd, tl.getVisibleAdvance());
                    }
                    d.height = (double)(ht + (float)in.top + (float)in.bottom) * 1.5 < (double)d.height ? (int)Math.ceil(ht) + in.top + in.bottom : (int)Math.max(ht + (float)in.top + (float)in.bottom, (float)d.height);
                    d.width = (int)Math.max(wd + (float)in.left + (float)in.right, (float)d.width);
                } else {
                    LineBreakMeasurer lbm = new LineBreakMeasurer(this.at.getIterator(), g2d.getFontRenderContext());
                    lbm.setPosition(0);
                    TextLayout tl = lbm.nextLayout(2.1474836E9f);
                    float ht = tl.getAscent() + tl.getDescent();
                    float wd = tl.getVisibleAdvance();
                    d.height = (int)Math.max(ht + (float)in.top + (float)in.bottom, (float)d.height);
                    d.width = (int)Math.max(wd + (float)in.left + (float)in.right, (float)d.width);
                }
            }
            return d;
        }
        return new Dimension(0, 0);
    }

    boolean isUnderOutmostLayout() {
        return this.underOutmostLayout;
    }

    void setUnderOutmostLayout(boolean underOutmostLayout) {
        this.underOutmostLayout = underOutmostLayout;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public void setPaintEnabled(boolean enable) {
        this.paintEnabled = enable;
    }
}

