/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ReferenceLineParser {
    public static final String RB_KEY = "ReferenceLineParser.";

    public static ReferenceLineOverlay load(StatGraph graph, Element elem, int autoCurveLabelPosition) {
        ReferenceLineOverlay line = (ReferenceLineOverlay)graph.getObjectFromElement(elem);
        if (line == null) {
            line = new ReferenceLineOverlay();
        }
        return ReferenceLineParser.load(graph, line, elem, autoCurveLabelPosition) ? line : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean load(StatGraph graph, ReferenceLineOverlay line, Element elem, int autoCurveLabelPosition) {
        boolean curveLabeled;
        String str;
        block82: {
            String yVarID;
            String xVarID;
            String dataName;
            block87: {
                block81: {
                    int type;
                    block86: {
                        block80: {
                            block85: {
                                graph.addSupportedGraph();
                                LayoutOverlayParser.parseGraphOpts(graph, elem, line);
                                if (line.getXAxis().equalsIgnoreCase("x2")) {
                                    line.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
                                } else {
                                    line.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
                                }
                                if (line.getYAxis().equalsIgnoreCase("y2")) {
                                    line.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
                                } else {
                                    line.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
                                }
                                dataName = null;
                                xVarID = null;
                                yVarID = null;
                                str = elem.getAttribute("y");
                                if (str.length() <= 0) break block80;
                                type = StatGraph.getAttributeType(elem, "y");
                                if (type >= 0) break block85;
                                if (StatGraph.getDataName(str).length() > 0) {
                                    if (dataName == null) {
                                        dataName = StatGraph.getDataName(str);
                                    }
                                    yVarID = StatGraph.getVarID(str);
                                    break block80;
                                } else if (line.isDiscreteY()) {
                                    line.setYValue(ReferenceLineParser.trimMissing(str));
                                    break block80;
                                } else {
                                    if (!StatGraph.isNumber(str)) {
                                        Message msg = new Message(RB.getStringResource(RB_KEY, "y.fmt.txt"));
                                        StatGraph.printWarning(msg.toString((Object)str));
                                        graph.removeNamedGraph(line);
                                        return false;
                                    }
                                    line.setYValue(new Double(str));
                                }
                                break block80;
                            }
                            if (type == 0) {
                                if (dataName == null) {
                                    dataName = StatGraph.getDataName(str);
                                }
                                yVarID = StatGraph.getVarID(str);
                            } else if (type == 1) {
                                if (!line.isDiscreteY()) {
                                    Message msg = new Message(RB.getStringResource(RB_KEY, "y.fmt.txt"));
                                    StatGraph.printWarning(msg.toString((Object)("'" + str + "'")));
                                    graph.removeNamedGraph(line);
                                    return false;
                                }
                                line.setYValue(ReferenceLineParser.trimMissing(str));
                            } else if (line.isDiscreteY()) {
                                line.setYValue(ReferenceLineParser.trimMissing(str));
                            } else {
                                if (!StatGraph.isNumber(str)) return false;
                                line.setYValue(new Double(str));
                            }
                        }
                        if ((str = elem.getAttribute("x")).length() <= 0) break block81;
                        type = StatGraph.getAttributeType(elem, "x");
                        if (type >= 0) break block86;
                        if (StatGraph.getDataName(str).length() > 0) {
                            if (dataName == null) {
                                dataName = StatGraph.getDataName(str);
                            }
                            xVarID = StatGraph.getVarID(str);
                            break block81;
                        } else if (line.isDiscreteX()) {
                            line.setXValue(ReferenceLineParser.trimMissing(str));
                            break block81;
                        } else {
                            if (!StatGraph.isNumber(str)) {
                                Message msg = new Message(RB.getStringResource(RB_KEY, "x.fmt.txt"));
                                StatGraph.printWarning(msg.toString((Object)str));
                                graph.removeNamedGraph(line);
                                return false;
                            }
                            line.setXValue(new Double(str));
                        }
                        break block81;
                    }
                    if (type == 0) {
                        if (dataName == null) {
                            dataName = StatGraph.getDataName(str);
                        }
                        xVarID = StatGraph.getVarID(str);
                    } else if (type == 1) {
                        if (!line.isDiscreteX()) {
                            Message msg = new Message(RB.getStringResource(RB_KEY, "x.fmt.txt"));
                            StatGraph.printWarning(msg.toString((Object)("'" + str + "'")));
                            graph.removeNamedGraph(line);
                            return false;
                        }
                        line.setXValue(ReferenceLineParser.trimMissing(str));
                    } else if (line.isDiscreteX()) {
                        line.setXValue(ReferenceLineParser.trimMissing(str));
                    } else {
                        if (!StatGraph.isNumber(str)) return false;
                        line.setXValue(new Double(str));
                    }
                }
                curveLabeled = false;
                if (dataName != null && dataName.length() > 0) break block87;
                str = elem.getAttribute("curveLabel");
                if (str.length() > 0) {
                    int type = StatGraph.getAttributeType(elem, "curveLabel");
                    if (type < 0) {
                        line.setCurveLabelString(str);
                        curveLabeled = true;
                        break block82;
                    } else if (type != 0) {
                        line.setCurveLabelString(str);
                        curveLabeled = true;
                        break block82;
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "label2.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    }
                }
                break block82;
            }
            DataModel m = graph.getData(dataName);
            RoleColumnMap map = new RoleColumnMap();
            if (yVarID != null) {
                int ycol = m.getColumn(yVarID);
                if (!line.isDiscreteY() && !StatGraph.checkVariable("y", m.getColumnLabel(ycol), Double.class, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(11, ycol);
                line.addRole("Y", m.getColumnLabel(ycol));
            }
            if (xVarID != null) {
                int xcol = m.getColumn(xVarID);
                if (!line.isDiscreteX() && !StatGraph.checkVariable("x", m.getColumnLabel(xcol), Double.class, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(10, xcol);
                line.addRole("X", m.getColumnLabel(xcol));
            }
            if ((str = elem.getAttribute("curveLabel")).length() > 0) {
                String curveLabelVarID;
                int type = StatGraph.getAttributeType(elem, "curveLabel");
                if (type < 0) {
                    curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)str));
                    }
                } else if (type == 0) {
                    curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    }
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                    String val = type == 2 ? str : "'" + str + "'";
                    StatGraph.printNote(msg.toString((Object)val));
                }
            }
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(map);
            LayoutOverlayParser.parseWhere(graph, crd, line);
            if (line.isTooltipEnabled()) {
                line.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
            }
            line.setModel(crd);
        }
        StatGraph.parseDataSkinOpt(graph, elem, line);
        LineAttrs ls = line.getLineStyle();
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), ls, "Reference");
        TextStyle labelStyle = null;
        if (curveLabeled) {
            str = elem.getAttribute("curveLabelLocation");
            if (str.equalsIgnoreCase("INSIDE")) {
                line.setCurveLabelLocation(0);
            } else if (str.equalsIgnoreCase("OUTSIDE")) {
                if (BandParser.isUnderLatticeLayout(elem)) {
                    line.setCurveLabelLocation(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "outsidelabel.txt"));
                } else {
                    line.setCurveLabelLocation(1);
                }
            } else {
                if (BandParser.isUnderLatticeLayout(elem)) {
                    line.setCurveLabelLocation(0);
                } else {
                    line.setCurveLabelLocation(1);
                }
                if (str.length() > 0) {
                    StatGraph.printOptionError("CURVELABELLOCATION", str);
                }
            }
            str = elem.getAttribute("curveLabelPosition");
            if (str.equalsIgnoreCase("MIN")) {
                line.setCurveLabelPosition(0);
            } else if (str.equalsIgnoreCase("MAX")) {
                line.setCurveLabelPosition(1);
            } else if (str.equalsIgnoreCase("AUTO")) {
                line.setCurveLabelPosition(autoCurveLabelPosition);
            } else {
                line.setCurveLabelPosition(autoCurveLabelPosition);
                if (str.length() > 0) {
                    StatGraph.printOptionError("CURVELABELPOSITION", str);
                }
            }
            labelStyle = new TextStyle();
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("curveLabelAttrs"), labelStyle, "ValueText");
            line.setLabelStyle(labelStyle);
            str = elem.getAttribute("curveLabelFormat");
            if (str.length() > 0) {
                SASFormat lf = SASFormat.getInstance((String)str);
                line.setLabelFormat(lf);
            }
            ScatterParser.parseCurveLabelSplitting(graph, line, elem);
        }
        if ((str = elem.getAttribute("clip")).length() > 0 && str.equalsIgnoreCase("true")) {
            line.setClipping(true);
        }
        if (graph.isSALabeling()) {
            line.setProtectedLine(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        } else {
            line.setProtectedLine(false);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("CurveLabelAttrs") && labelStyle != null) {
                StatGraph.parseTextAttrs(graph, (Element)node, labelStyle);
                continue;
            }
            if (!elemTag.equals("LineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, ls);
        }
        str = elem.getAttribute("useDiscreteThickness");
        if (str.equalsIgnoreCase("true")) {
            line.setUseDiscreteThickness(true);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("discreteLineThickness"))) {
            double thickness = Double.parseDouble(str);
            if (thickness >= 0.0 && thickness <= 1.0) {
                line.setDiscreteLineThickness(thickness);
            } else {
                StatGraph.printOptionError("DISCRETELINETHICKNESS", str);
            }
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !ReferenceLineParser.isDiscreteOffsetSupported(line)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
            return true;
        }
        if (!StatGraph.isNumber(str)) {
            if (str.length() <= 0) return true;
            StatGraph.printOptionError("DISCRETEOFFSET", str);
            return true;
        }
        double offset = Double.parseDouble(str);
        if (offset >= -0.5 && offset <= 0.5) {
            line.setDiscreteOffset(offset);
            return true;
        }
        StatGraph.printOptionError("DISCRETEOFFSET", str);
        return true;
    }

    static boolean isDiscreteOffsetSupported(ReferenceLineOverlay line) {
        return line.isDiscreteX() || line.isDiscreteY();
    }

    public static String trimMissing(String str) {
        if (str.trim().length() == 0) {
            str = str.trim();
        }
        return str;
    }
}

