/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.regions.PathDiagramRegion;
import com.sas.graphics.components.pfd.PFDCurvedLink;
import com.sas.graphics.components.pfd.PFDLinkLabel;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPathDiagramCurvedLink;
import com.sas.graphics.components.pfd.PFDPathDiagramLink;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPathDiagramSelfLink;
import com.sas.graphics.components.pfd.PFDPathDiagramView;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSelfLink;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.util.layout.PathDiagramGRIPLayout;
import com.sas.graphics.components.util.layout.PathDiagramGroupLayeredLayout;
import com.sas.graphics.components.util.layout.PathDiagramLayeredLayout;
import com.sas.graphics.components.util.layout.PathDiagramNeuralNetworkLayout;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class PathDiagramParser {
    public static final String RB_KEY = "PathDiagramParser.";
    public static final String FROM_ID = "fromID";
    public static final String TO_ID = "toID";
    public static final String NODE_X = "nodeX";
    public static final String NODE_Y = "nodeY";
    public static final String NODE_PRIORITY = "nodePriority";
    public static final String NODE_RELATIVE_SIZE = "relativeNodeSize";
    public static final String LINK_ID = "linkID";
    public static final String LINK_LABEL = "linkLabel";
    public static final String LINK_CONTROL_X = "linkControlX";
    public static final String LINK_CONTROL_Y = "linkControlY";
    public static final String LINK_DIRECTION = "linkDirection";
    public static final String LINK_DIRECTION_TO = "TO";
    public static final String LINK_DIRECTION_FROM = "FROM";
    public static final String LINK_DIRECTION_BOTH = "BOTH";
    public static final String LINK_DIRECTION_NONE = "NONE";
    public static final String LINK_PRIORITY = "linkPriority";
    public static final String BREAK_POINTS = "breakPoints";
    public static final String RELATIVE_LOCATION = "relativeLocation";
    public static final String LINK_LINE_ATTRS = "linkLineAttrs";
    public static final String LINK_LABEL_ATTRS = "linkLabelAttrs";
    public static final String LINK_LABEL_FILL_ATTRS = "linkLabelFillAttrs";
    public static final String LINK_LABEL_OUTLINE_ATTRS = "linkLabelOutlineAttrs";
    public static final String LINK_COLOR_RESPONSE = "linkColorResponse";
    public static final String LINK_WIDTH_RESPONSE = "linkWidthResponse";
    public static final String NAME = "name";
    public static final String NODE_ID = "nodeID";
    public static final String NODE_WIDTH = "nodeWidth";
    public static final String NODE_HEIGHT = "nodeHeight";
    public static final String NODE_SHAPE = "nodeShape";
    public static final String NODE_COLOR_GROUP = "nodeColorGroup";
    public static final String NODE_TITLE = "nodeTitle";
    public static final String NODE_TITLE_ATTRS = "nodeTitleAttrs";
    public static final String NODE_DETAILS = "nodeDetails";
    public static final String NODE_DETAILS_ATTRS = "nodeDetailsAttrs";
    public static final String NODE_FILL_ATTRS = "nodeFillAttrs";
    public static final String NODE_OUTLINE_ATTRS = "nodeOutlineAttrs";
    public static final String NODE_LABEL = "nodeLabel";
    public static final String NODE_LABEL_ATTRS = "nodeLabelAttrs";
    public static double defaultSideWidth = 100.0;
    public static double defaultSideHeight = 50.0;

    public static PathDiagramRegion load(StatGraph graph, Element elem) {
        PathDiagramRegion path = (PathDiagramRegion)graph.getObjectFromElement(elem);
        if (path == null) {
            path = new PathDiagramRegion();
        }
        return PathDiagramParser.load(graph, path, elem) ? path : null;
    }

    public static boolean load(StatGraph graph, PathDiagramRegion path, Element elem) {
        double scaledNodeHeight;
        int columnNumber;
        String str;
        String str2;
        String str3;
        boolean isFixedLayout;
        graph.addSupportedGraph();
        if (path == null) {
            return false;
        }
        PFDPathDiagramView pd = path.getPFDView();
        LayoutRegionParser.parseGraphOpts(graph, elem, path);
        double sizeScaleFactor = StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
        pd.setOpaque(false);
        pd.userSetAlwaysCropAndScaleToFit = true;
        pd.setMaxZoomScale(Double.MAX_VALUE);
        pd.setSize(graph.size);
        PFDModel pdDataModel = pd.getModel();
        if (pdDataModel == null) {
            pdDataModel = new PFDModel();
        }
        pdDataModel.setMinSize(new Dimension(1, 1));
        FillAttrs fillAttrs = PathDiagramParser.parseFillAttrs(graph, elem, NODE_FILL_ATTRS, "NodeFillAttrs", "GraphDataNodeDefault", null);
        TextAttrs nodeTitleAttrs = PathDiagramParser.parseTextAttrs(graph, elem, NODE_TITLE_ATTRS, "NodeTitleAttrs", "NodeTitle", null);
        TextAttrs nodeDetailsAttrs = PathDiagramParser.parseTextAttrs(graph, elem, NODE_DETAILS_ATTRS, "NodeDetailsAttrs", "NodeDetails", null);
        LineAttrs nodeOutlineAttrs = PathDiagramParser.parseLineAttrs(graph, elem, NODE_OUTLINE_ATTRS, "NodeOutlineAttrs", "GraphDataNodeDefault", null);
        LineAttrs linkLineAttrs = PathDiagramParser.parseLineAttrs(graph, elem, LINK_LINE_ATTRS, "LinkLineAttrs", "NodeLink", null);
        TextAttrs linkLabelAttrs = PathDiagramParser.parseTextAttrs(graph, elem, LINK_LABEL_ATTRS, "LinkLabelAttrs", "NodeLinkLabel", null);
        FillAttrs linkLabelFillAttrs = PathDiagramParser.parseFillAttrs(graph, elem, LINK_LABEL_FILL_ATTRS, "LinkLabelFillAttrs", "Backfill", null);
        LineAttrs linkLabelOutlineAttrs = PathDiagramParser.parseLineAttrs(graph, elem, LINK_LABEL_OUTLINE_ATTRS, "LinkLabelOutlineAttrs", "Outlines", null);
        TextAttrs nodeLabelAttrs = PathDiagramParser.parseTextAttrs(graph, elem, NODE_LABEL_ATTRS, "NodeLabelAttrs", "NodeLabel", null);
        Hashtable<String, PFDPathDiagramNode> context = new Hashtable<String, PFDPathDiagramNode>();
        boolean FIXED = true;
        int FLOW = 2;
        int GROUPED_FLOW = 3;
        int GRIP = 4;
        int NEURAL_NETWORK = 5;
        int arrangement = 2;
        if (elem.hasAttribute("arrangement")) {
            String str4 = elem.getAttribute("arrangement").toLowerCase();
            arrangement = str4.equalsIgnoreCase("fixed") ? 1 : (str4.equalsIgnoreCase("groupedFlow") ? 3 : (str4.equalsIgnoreCase("grip") ? 4 : (str4.equalsIgnoreCase("neuralNet") ? 5 : 2)));
        }
        boolean bl = isFixedLayout = arrangement == 1;
        if (elem.hasAttribute("textSizeMin") && StatGraph.isNumber(str3 = elem.getAttribute("textSizeMin"))) {
            path.setTextSizeMin((int)Double.parseDouble(str3));
        }
        double graphScale = 1.0;
        if (arrangement == 4 && elem.hasAttribute("diagramScale") && StatGraph.isNumber(str2 = elem.getAttribute("diagramScale"))) {
            graphScale = Double.parseDouble(str2);
        }
        if (graphScale != 1.0) {
            PathDiagramParser.scaleFontSize(nodeTitleAttrs, nodeLabelAttrs, linkLabelAttrs, graphScale);
        }
        RoleColumnMap map = new RoleColumnMap();
        DataModel nodeDataModel = null;
        DataModel linkDataModel = null;
        String[] linkID = null;
        String[] linkFromNodeID = null;
        String[] linkToNodeID = null;
        String[] linkDirection = null;
        String[] linkLabel = null;
        String[] breakPoints = null;
        double[] linkControlX = null;
        double[] linkControlXRaw = null;
        double[] linkControlY = null;
        double[] linkControlYRaw = null;
        double[] linkColor = null;
        double[] linkWidth = null;
        boolean[] reversed = null;
        double[] linkPriority = null;
        double[] relativeLocationValues = null;
        if (elem.hasAttribute(FROM_ID)) {
            str = elem.getAttribute(FROM_ID);
            linkDataModel = graph.getData(StatGraph.getDataName(str));
            columnNumber = linkDataModel.getColumn(StatGraph.getVarID(str));
            if (columnNumber >= 0) {
                linkFromNodeID = linkDataModel.getColumnAsClassColumn(columnNumber);
            }
            if (!StatGraph.checkVariable(FROM_ID, linkDataModel.getColumnLabel(columnNumber), null, 1, true)) {
                return false;
            }
        }
        if (elem.hasAttribute(TO_ID)) {
            columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(TO_ID)));
            if (columnNumber >= 0) {
                linkToNodeID = linkDataModel.getColumnAsClassColumn(columnNumber);
            }
            if (!StatGraph.checkVariable(TO_ID, linkDataModel.getColumnLabel(columnNumber), null, 1, true)) {
                return false;
            }
        }
        if (elem.hasAttribute(BREAK_POINTS) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(BREAK_POINTS)))) >= 0) {
            breakPoints = linkDataModel.getColumnAsClassColumn(columnNumber);
        }
        double[] nodeXRaw = null;
        double[] nodeYRaw = null;
        double[] nodeXCentroid = null;
        double[] nodeYCentroid = null;
        double[] nodeW = null;
        double[] nodeH = null;
        double nodeWidth = -1.0;
        double nodeHeight = -1.0;
        String[] nodeID = null;
        String[] nodeTitle = null;
        String[] nodeShape = null;
        String[] nodeDetails = null;
        String[] nodeLabel = null;
        String[] nodeColor = null;
        double[] nodePriority = null;
        double[] nodeRelativeSize = null;
        if (elem.hasAttribute(NODE_X) && (columnNumber = (nodeDataModel = graph.getData(StatGraph.getDataName(str = elem.getAttribute(NODE_X)))).getColumn(StatGraph.getVarID(str))) >= 0 && StatGraph.checkVariable(NODE_X, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            nodeXRaw = nodeDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_Y)) {
            if (nodeDataModel == null) {
                nodeDataModel = graph.getData(StatGraph.getDataName(elem.getAttribute(NODE_Y)));
            }
            if ((columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_Y)))) >= 0 && StatGraph.checkVariable(NODE_Y, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
                nodeYRaw = nodeDataModel.getDoubleColumn(columnNumber);
            }
        }
        if (nodeDataModel == null) {
            if (arrangement == 1) {
                nodeDataModel = linkDataModel;
            } else if (elem.hasAttribute(NODE_ID)) {
                str = elem.getAttribute(NODE_ID);
                nodeDataModel = graph.getData(StatGraph.getDataName(str));
            } else {
                nodeDataModel = linkDataModel;
            }
        }
        if (elem.hasAttribute(NODE_DETAILS) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_DETAILS)))) >= 0) {
            nodeDetails = nodeDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_ID) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_ID)))) >= 0) {
            nodeID = nodeDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_TITLE) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_TITLE)))) >= 0) {
            nodeTitle = nodeDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (StatGraph.isNumber(str = elem.getAttribute(NODE_WIDTH))) {
            nodeWidth = Double.parseDouble(str);
        } else if (str.length() > 0 && StatGraph.isValidVar(str) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(str))) >= 0 && StatGraph.checkVariable(NODE_WIDTH, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false, 1, false)) {
            nodeW = nodeDataModel.getDoubleColumn(columnNumber);
        }
        str = elem.getAttribute(NODE_HEIGHT);
        if (StatGraph.isNumber(str)) {
            nodeHeight = Double.parseDouble(str);
        } else if (str.length() > 0 && StatGraph.isValidVar(str) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(str))) >= 0 && StatGraph.checkVariable(NODE_HEIGHT, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false, 1, false)) {
            nodeH = nodeDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_SHAPE) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_SHAPE)))) >= 0) {
            nodeShape = nodeDataModel.getStringColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_COLOR_GROUP) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_COLOR_GROUP)))) >= 0) {
            nodeColor = nodeDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (elem.hasAttribute(NODE_PRIORITY)) {
            columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_PRIORITY)));
            if (columnNumber >= 0 && StatGraph.checkVariable(NODE_PRIORITY, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
                nodePriority = nodeDataModel.getDoubleColumn(columnNumber);
            }
        } else if (!isFixedLayout) {
            nodePriority = new double[nodeDataModel.getRowCount()];
            for (int i = 0; i < nodePriority.length; ++i) {
                nodePriority[i] = 1.0;
            }
        }
        if (elem.hasAttribute(NODE_RELATIVE_SIZE)) {
            columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_RELATIVE_SIZE)));
            if (columnNumber >= 0 && StatGraph.checkVariable(NODE_RELATIVE_SIZE, nodeDataModel.getColumnLabel(columnNumber), Double.class, 1, false, 1, false)) {
                nodeRelativeSize = nodeDataModel.getDoubleColumn(columnNumber);
            }
            if (nodeRelativeSize != null) {
                nodeRelativeSize = PathDiagramParser.normalize(nodeRelativeSize);
            }
        }
        if (elem.hasAttribute(NODE_LABEL) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(NODE_LABEL)))) >= 0) {
            nodeLabel = nodeDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (isFixedLayout) {
            if (nodeXRaw == null) {
                nodeXRaw = new double[nodeDataModel.getRowCount()];
            }
            if (nodeYRaw == null) {
                nodeYRaw = new double[nodeDataModel.getRowCount()];
            }
            nodeXCentroid = new double[nodeXRaw.length];
            nodeYCentroid = new double[nodeYRaw.length];
        } else {
            nodeXCentroid = new double[nodeDataModel.getRowCount()];
            nodeYCentroid = new double[nodeDataModel.getRowCount()];
        }
        if (elem.hasAttribute(LINK_ID) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_ID)))) >= 0) {
            linkID = linkDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_LABEL) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_LABEL)))) >= 0) {
            linkLabel = linkDataModel.getColumnAsClassColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_CONTROL_X) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_CONTROL_X)))) >= 0 && StatGraph.checkVariable(LINK_CONTROL_X, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            linkControlXRaw = linkDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_CONTROL_Y) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_CONTROL_Y)))) >= 0 && StatGraph.checkVariable(LINK_CONTROL_Y, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            linkControlYRaw = linkDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_DIRECTION) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_DIRECTION)))) >= 0) {
            linkDirection = linkDataModel.getStringColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_PRIORITY) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_PRIORITY)))) >= 0 && StatGraph.checkVariable(LINK_PRIORITY, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            linkPriority = linkDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(RELATIVE_LOCATION) && (columnNumber = linkDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(RELATIVE_LOCATION)))) >= 0 && StatGraph.checkVariable(RELATIVE_LOCATION, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            relativeLocationValues = linkDataModel.getDoubleColumn(columnNumber);
        }
        if (elem.hasAttribute(LINK_COLOR_RESPONSE) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_COLOR_RESPONSE)))) >= 0 && StatGraph.checkVariable(LINK_COLOR_RESPONSE, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            linkColor = nodeDataModel.getDoubleColumn(columnNumber);
            path.setLinkColorCMD((ColumnMetadata)nodeDataModel.getColumnLabel(columnNumber));
        }
        if (elem.hasAttribute(LINK_WIDTH_RESPONSE) && (columnNumber = nodeDataModel.getColumn(StatGraph.getVarID(elem.getAttribute(LINK_WIDTH_RESPONSE)))) >= 0 && StatGraph.checkVariable(LINK_WIDTH_RESPONSE, linkDataModel.getColumnLabel(columnNumber), Double.class, 1, false)) {
            linkWidth = nodeDataModel.getDoubleColumn(columnNumber);
        }
        if (linkFromNodeID == null || linkToNodeID == null) {
            return false;
        }
        LinkedHashMap<String, Color> nodeColorMap = null;
        if (nodeColor != null) {
            nodeColorMap = new LinkedHashMap<String, Color>();
            DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
            if (missingElem == null) {
                missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataNodeDefault");
            }
            Color missingColor = missingElem.getFillColor();
            Color[] fillColors = graph.style.getGraphStyle().getDataNodeFillColors();
            int nColors = 0;
            for (int i = 0; i < nodeColor.length; ++i) {
                String s = nodeColor[i];
                if (s == null || nodeColorMap.get(s) != null) continue;
                Color c = LayoutOverlayParser.isMissing(s, false) ? missingColor : fillColors[nColors % fillColors.length];
                ++nColors;
                nodeColorMap.put(s, c);
            }
            path.setNodeColorMap(nodeColorMap);
        }
        ContinuousRangeToColorMapper linkColorMap = null;
        if (linkColor != null) {
            Color[] colors;
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (int i = 0; i < linkColor.length; ++i) {
                if (Double.isNaN(linkColor[i])) continue;
                min = Math.min(min, linkColor[i]);
                max = Math.max(max, linkColor[i]);
            }
            double[] values = new double[]{min, max};
            DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
            if (missingElem == null) {
                missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataNodeDefault");
            }
            Color missingColor = missingElem.getLineColor();
            str = elem.getAttribute("linkColorModel");
            RampStyleElement rampElem = graph.style.getGraphStyle().getRampStyleElement("GraphDataNodeDefault");
            rampElem = rampElem.mergeWith((StyleElement)graph.style.getGraphStyle().getRampStyleElement("TwoColorAltRamp")).getAsRampStyle();
            if (str != null && str.length() > 0) {
                rampElem = rampElem.mergeWith((StyleElement)graph.style.getGraphStyle().getRampStyleElement(str)).getAsRampStyle();
            }
            Color[] cl = rampElem.getThreeColors();
            Element cmElem = StatGraph.getOptionAttrsElement(elem, "LinkColorModel");
            if (cmElem != null && (colors = StatGraph.parseColorValueList(graph, cmElem, "Value")) != null && colors.length > 0) {
                cl = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
            }
            str = elem.getAttribute("reverseLinkColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            Color[] rampColors = new Color[cl.length];
            for (int i = 0; i < cl.length; ++i) {
                int idx = reverse ? cl.length - 1 - i : i;
                rampColors[i] = cl[idx];
            }
            linkColorMap = new ContinuousRangeToColorMapper();
            linkColorMap.setColorSpectrumColors(rampColors);
            linkColorMap.setColorSpectrumValues(values);
            linkColorMap.setReplaceMissingValues(true);
            linkColorMap.setMissingReplacement(missingColor);
            path.setLinkColorMapper(linkColorMap);
        }
        double linkWidthDataMax = Double.NaN;
        double linkWidthMin = linkLineAttrs.getWidth();
        double linkWidthMax = 10.0 * linkWidthMin;
        if (linkWidth != null) {
            double d;
            str = elem.getAttribute("linkWidthMaxResponse");
            if (StatGraph.isNumber(str) && (d = Double.parseDouble(str)) > 0.0) {
                linkWidthDataMax = d;
            }
            if (StatGraph.isNumber(str = elem.getAttribute("linkWidthMax")) && (d = Double.parseDouble(str)) >= 0.0) {
                linkWidthMax = d;
            }
            if (StatGraph.isNumber(str = elem.getAttribute("linkWidthMin")) && (d = Double.parseDouble(str)) >= 0.0) {
                linkWidthMin = d;
            }
            if (linkWidthMin > linkWidthMax) {
                linkWidthMin = linkLineAttrs.getWidth();
                linkWidthMax = 10.0 * linkWidthMin;
            }
            if (Double.isNaN(linkWidthDataMax)) {
                double max = -1.7976931348623157E308;
                for (int i = 0; i < linkWidth.length; ++i) {
                    if (Double.isNaN(linkWidth[i])) continue;
                    max = Math.max(max, linkWidth[i]);
                }
                linkWidthDataMax = max;
            }
        }
        int numberOfObservations = nodeDataModel.getRowCount();
        double heightOfComponent = pd.getHeight();
        double scaledNodeWidth = nodeWidth > 0.0 ? (double)((int)(nodeWidth * sizeScaleFactor)) : (double)((int)(defaultSideWidth * sizeScaleFactor));
        double d = scaledNodeHeight = nodeHeight > 0.0 ? (double)((int)(nodeHeight * sizeScaleFactor)) : (double)((int)(defaultSideHeight * sizeScaleFactor));
        if (isFixedLayout) {
            int i;
            for (i = numberOfObservations - 1; i >= 0; --i) {
                double scale;
                double d2 = scale = nodeRelativeSize == null ? 1.0 : nodeRelativeSize[i];
                double d3 = Double.isNaN(nodeXRaw[i]) ? nodeXRaw[i] : (nodeXCentroid[i] = nodeXRaw[i] * sizeScaleFactor - (nodeW == null ? scale * scaledNodeWidth / 2.0 : sizeScaleFactor * scale * nodeW[i] / 2.0));
                nodeYCentroid[i] = Double.isNaN(nodeYRaw[i]) ? nodeYRaw[i] : heightOfComponent - nodeYRaw[i] * sizeScaleFactor - (nodeH == null ? scale * scaledNodeHeight / 2.0 : sizeScaleFactor * scale * nodeH[i] / 2.0);
            }
            numberOfObservations = linkDataModel.getRowCount();
            if (linkControlXRaw != null && linkControlYRaw != null) {
                linkControlX = new double[linkControlXRaw.length];
                linkControlY = new double[linkControlYRaw.length];
                for (i = numberOfObservations - 1; i >= 0; --i) {
                    if (Math.abs(linkControlXRaw[i]) <= 1.0 && Math.abs(linkControlYRaw[i]) <= 1.0) {
                        linkControlX[i] = linkControlXRaw[i];
                        linkControlY[i] = linkControlYRaw[i];
                        continue;
                    }
                    linkControlX[i] = Double.isNaN(linkControlXRaw[i]) ? Double.NaN : linkControlXRaw[i] * sizeScaleFactor;
                    linkControlY[i] = Double.isNaN(linkControlXRaw[i]) ? Double.NaN : heightOfComponent - linkControlYRaw[i] * sizeScaleFactor;
                }
            }
        }
        numberOfObservations = nodeDataModel.getRowCount();
        double unscaledNodeWidth = nodeWidth > 0.0 ? nodeWidth : defaultSideWidth;
        double unscaledNodeHeight = nodeHeight > 0.0 ? nodeHeight : defaultSideHeight;
        for (int i = 0; i < numberOfObservations; ++i) {
            String thisNodeTitle;
            if (Double.isNaN(nodeXCentroid[i]) || Double.isNaN(nodeYCentroid[i]) || nodePriority != null && Double.isNaN(nodePriority[i])) continue;
            Dimension thisNodeDimension = isFixedLayout ? new Dimension(nodeW != null ? (int)nodeW[i] : (int)unscaledNodeWidth, nodeH != null ? (int)nodeH[i] : (int)unscaledNodeHeight) : new Dimension(nodeW != null ? (int)nodeW[i] : (int)defaultSideWidth, nodeH != null ? (int)nodeH[i] : (int)defaultSideHeight);
            if (nodeRelativeSize != null) {
                thisNodeDimension.width = (int)((double)thisNodeDimension.width * nodeRelativeSize[i]);
                thisNodeDimension.height = (int)((double)thisNodeDimension.height * nodeRelativeSize[i]);
            }
            thisNodeDimension.width = (int)((double)thisNodeDimension.width * sizeScaleFactor);
            thisNodeDimension.height = (int)((double)thisNodeDimension.height * sizeScaleFactor);
            if (Double.isNaN(thisNodeDimension.width) || thisNodeDimension.width <= 0 || Double.isNaN(thisNodeDimension.height) || thisNodeDimension.height <= 0) continue;
            String string = thisNodeTitle = nodeTitle != null && nodeTitle[i] != null ? nodeTitle[i].trim() : null;
            int thisNodeShape = nodeShape == null || nodeShape[i] == null ? 2 : (nodeShape[i].equalsIgnoreCase("OVAL") ? 5 : (nodeShape[i].equalsIgnoreCase(LINK_DIRECTION_NONE) ? (arrangement == 4 && nodePriority != null && nodePriority[i] == (double)PFDPathDiagramNode.NODE_PRIORITY_3 ? 0 : 5) : (nodeShape[i].equalsIgnoreCase("TRIANGLE") ? 4 : 2)));
            String thisNodeDetails = nodeDetails != null ? nodeDetails[i] : null;
            String label = nodeLabel != null ? nodeLabel[i] : null;
            PFDPathDiagramNode node = new PFDPathDiagramNode(new Point((int)nodeXCentroid[i], (int)nodeYCentroid[i]), thisNodeDimension, thisNodeShape, thisNodeTitle, i);
            if (label != null) {
                node.setGapScaleFactor(StatGraph.getGapScaleFactor());
                node.setOutsideLabel(label.trim());
                node.getOutsideLabel().setFont(nodeLabelAttrs.getFont());
                node.getOutsideLabel().setForeground(nodeLabelAttrs.getColor());
            }
            if (nodePriority != null) {
                node.setNodePriority((int)nodePriority[i]);
            } else {
                node.setNodePriority(PFDPathDiagramNode.NODE_PRIORITY_1);
            }
            if (nodeRelativeSize != null) {
                node.setRelativeNodeSize(nodeRelativeSize[i]);
            } else {
                node.setRelativeNodeSize(1.0);
            }
            if (nodeShape != null && nodeShape[i] != null && nodeShape[i].equalsIgnoreCase(LINK_DIRECTION_NONE)) {
                node.getDrawable().getBrush().setColor(new Color(0, 0, 0, 0));
                node.getDrawable().getPen().setColor(new Color(0, 0, 0, 0));
            } else {
                if (nodeColorMap != null) {
                    Color c = (Color)nodeColorMap.get(nodeColor[i]);
                    if (c == null) {
                        c = fillAttrs.getColor();
                    }
                    node.getDrawable().getBrush().setColor(c);
                } else {
                    node.getDrawable().getBrush().setColor(fillAttrs.getColor());
                }
                PFDPen pen = node.getDrawable().getPen();
                pen.setColor(nodeOutlineAttrs.getColor());
                pen.setLineWidth((float)nodeOutlineAttrs.getWidth());
                String patternName = linkLineAttrs.getPatternName();
                if (patternName.substring(0, 4).equalsIgnoreCase("Dash")) {
                    pen.setStyle(2);
                } else if (patternName.substring(0, 3).equalsIgnoreCase("Dot")) {
                    pen.setStyle(3);
                }
            }
            node.getLabel().setFont(nodeTitleAttrs.getFont());
            node.getLabel().setForeground(nodeTitleAttrs.getColor());
            if (nodeID != null) {
                if (nodeID[i] == null || context.get(nodeID[i]) != null) continue;
                context.put(nodeID[i], node);
                pdDataModel.addPrimitive((PFDPrimitive)node);
                continue;
            }
            context.put("node_" + node.hashCode(), node);
            pdDataModel.addPrimitive((PFDPrimitive)node);
        }
        HashMap linkMap = PathDiagramParser.getLinkMap(numberOfObservations, linkFromNodeID, linkToNodeID, linkPriority);
        numberOfObservations = linkDataModel.getRowCount();
        Object link = null;
        reversed = new boolean[numberOfObservations];
        for (int i = 0; i < numberOfObservations; ++i) {
            if (linkFromNodeID[i] == null || linkToNodeID[i] == null) continue;
            PFDPathDiagramNode fromNode = (PFDPathDiagramNode)context.get(linkFromNodeID[i]);
            PFDPathDiagramNode toNode = (PFDPathDiagramNode)context.get(linkToNodeID[i]);
            if (fromNode == null || toNode == null || linkPriority != null && linkPriority[i] != 1.0 && linkPriority[i] != 2.0) continue;
            reversed[i] = false;
            if (!linkFromNodeID[i].equalsIgnoreCase(linkToNodeID[i]) && (linkControlX == null || Double.isNaN(linkControlX[i]) || linkControlY == null || Double.isNaN(linkControlY[i]))) {
                if (isFixedLayout) {
                    link = new PFDPathDiagramLink(fromNode.getOutputPort(), toNode.getInputPort());
                } else if (arrangement == 4) {
                    if (linkPriority != null && linkPriority[i] != 1.0) {
                        link = new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0));
                        ((PFDPathDiagramCurvedLink)link).setLinkPriority((int)linkPriority[i]);
                    } else if (PathDiagramParser.isReciprocalPair(linkMap, linkFromNodeID[i], linkToNodeID[i])) {
                        link = new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0));
                        ((PFDPathDiagramCurvedLink)link).setReciprocalLink(true);
                    } else {
                        link = linkDirection != null && linkDirection[i] != null && linkDirection[i].equalsIgnoreCase(LINK_DIRECTION_BOTH) ? new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0)) : new PFDPathDiagramLink(fromNode.getOutputPort(), toNode.getInputPort());
                    }
                } else if (linkPriority != null && linkPriority[i] != 1.0) {
                    link = new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0));
                    ((PFDPathDiagramCurvedLink)link).setLinkPriority((int)linkPriority[i]);
                } else {
                    link = linkDirection != null && linkDirection[i] != null && linkDirection[i].equalsIgnoreCase(LINK_DIRECTION_BOTH) ? new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0)) : new PFDPathDiagramLink(fromNode.getOutputPort(), toNode.getInputPort());
                }
                link.update("fromPort", (PFDView)pd);
            } else if (linkFromNodeID[i].equalsIgnoreCase(linkToNodeID[i])) {
                if (isFixedLayout) {
                    int relativeLocation = 3;
                    if (relativeLocationValues != null) {
                        relativeLocation = (int)relativeLocationValues[i];
                    } else {
                        int relativeX = 1;
                        if (linkControlX != null && !Double.isNaN(linkControlX[i])) {
                            relativeX = (int)linkControlX[i];
                        }
                        int relativeY = -1;
                        if (linkControlY != null && !Double.isNaN(linkControlY[i])) {
                            relativeY = (int)linkControlY[i];
                        }
                        block1 : switch (relativeX) {
                            case -1: {
                                switch (relativeY) {
                                    case -1: {
                                        relativeLocation = 1;
                                        break block1;
                                    }
                                    case 0: {
                                        relativeLocation = 8;
                                        break block1;
                                    }
                                    case 1: {
                                        relativeLocation = 7;
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case 0: {
                                switch (relativeY) {
                                    case -1: {
                                        relativeLocation = 2;
                                        break block1;
                                    }
                                    case 1: {
                                        relativeLocation = 6;
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case 1: {
                                switch (relativeY) {
                                    case -1: {
                                        relativeLocation = 3;
                                        break block1;
                                    }
                                    case 0: {
                                        relativeLocation = 4;
                                        break block1;
                                    }
                                    case 1: {
                                        relativeLocation = 5;
                                        break block1;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    link = new PFDSelfLink(fromNode.getOutputPort(), relativeLocation);
                    link.setSelectable(true);
                } else {
                    link = new PFDPathDiagramSelfLink(fromNode.getOutputPort(), 2);
                    link.setSelectable(true);
                }
            } else {
                link = isFixedLayout ? new PFDCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point((int)linkControlX[i], (int)linkControlY[i])) : new PFDPathDiagramCurvedLink(fromNode.getOutputPort(), toNode.getInputPort(), new Point(0, 0));
            }
            if (link == null) continue;
            if (linkLabel != null && linkLabel[i] != null) {
                link.setMiddleLabel(linkLabel[i].trim());
                link.setMiddleLabelVisible(true);
            }
            link.setFromArrowVisible(false);
            link.setToArrowVisible(false);
            if (linkDirection != null) {
                String direction = linkDirection[i];
                int dir = 3;
                if (direction == null || direction.equalsIgnoreCase(LINK_DIRECTION_TO)) {
                    link.setFromArrowVisible(reversed[i]);
                    link.setToArrowVisible(!reversed[i]);
                    dir = reversed[i] ? 2 : 1;
                } else if (direction.equalsIgnoreCase(LINK_DIRECTION_FROM)) {
                    link.setFromArrowVisible(!reversed[i]);
                    link.setToArrowVisible(reversed[i]);
                    dir = reversed[i] ? 1 : 2;
                } else if (direction.equalsIgnoreCase(LINK_DIRECTION_BOTH)) {
                    link.setFromArrowVisible(true);
                    link.setToArrowVisible(true);
                    dir = 3;
                }
                if (!isFixedLayout) {
                    ((PathDiagramLinkLayoutInterface)link).setLinkDirection(dir);
                }
            } else if (!isFixedLayout) {
                ((PathDiagramLinkLayoutInterface)link).setLinkDirection(1);
            }
            PFDPen linkPen = link.getPen();
            if (linkColorMap != null) {
                Color c = linkColorMap.getValue(linkColor[i]);
                if (c == null) {
                    c = linkLineAttrs.getColor();
                }
                linkPen.setColor(c);
            } else {
                linkPen.setColor(linkLineAttrs.getColor());
            }
            if (linkWidth != null) {
                int w;
                if (Double.isNaN(linkWidth[i])) {
                    w = linkLineAttrs.getWidth();
                } else {
                    double dw = linkWidthMax * linkWidth[i] / linkWidthDataMax;
                    dw = Math.max(linkWidthMin, dw);
                    dw = Math.min(linkWidthMax, dw);
                    w = (int)(dw + 0.5);
                }
                w = (int)((double)w * graphScale + 0.5);
                linkPen.setLineWidth((float)w);
                link.setFromElbowLineWidth((float)w);
                link.setToElbowLineWidth((float)w);
            } else {
                linkPen.setLineWidth((float)((int)((double)linkLineAttrs.getWidth() * graphScale + 0.5)));
                link.setFromElbowLineWidth((float)((int)((double)linkLineAttrs.getWidth() * graphScale + 0.5)));
                link.setToElbowLineWidth((float)((int)((double)linkLineAttrs.getWidth() * graphScale + 0.5)));
            }
            PFDLinkLabel middleLabel = null;
            middleLabel = link.getMiddleLabelObject();
            if (middleLabel != null) {
                link.setMiddleLabelPosition(1);
                middleLabel.setTransparent(true);
                middleLabel.setFont(linkLabelAttrs.getFont());
                middleLabel.setForeground(linkLabelAttrs.getColor());
            }
            link.setArrowBase(link.getArrowBase() * (float)(sizeScaleFactor * graphScale));
            link.setArrowLength(link.getArrowLength() * (float)(sizeScaleFactor * graphScale));
            String patternName = linkLineAttrs.getPatternName();
            if (patternName.substring(0, 4).equalsIgnoreCase("Dash")) {
                linkPen.setStyle(2);
            } else if (patternName.substring(0, 3).equalsIgnoreCase("Dot")) {
                linkPen.setStyle(3);
            }
            if (breakPoints != null && breakPoints[i] != null) {
                link.setCustomBreakPointsUsed(true);
                StringTokenizer tokenizer = new StringTokenizer(breakPoints[i], ",");
                while (tokenizer.hasMoreTokens()) {
                    String xval = tokenizer.nextToken();
                    if (!tokenizer.hasMoreTokens()) break;
                    String yval = tokenizer.nextToken();
                    try {
                        int bx = (int)(Double.parseDouble(xval) * sizeScaleFactor);
                        int by = (int)(heightOfComponent - Double.parseDouble(yval) * sizeScaleFactor);
                        Point pt = new Point(bx, by);
                        link.addBreakPoint(pt);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            pdDataModel.addPrimitive((PFDPrimitive)link);
        }
        pd.setModel(pdDataModel);
        if (!isFixedLayout) {
            switch (arrangement) {
                default: {
                    PathDiagramLayeredLayout layout = new PathDiagramLayeredLayout();
                    layout.setGridScaleFactor(sizeScaleFactor);
                    pd.setPFDLayout((LayoutStrategyInterface)layout);
                    break;
                }
                case 3: {
                    PathDiagramGroupLayeredLayout gLayout = new PathDiagramGroupLayeredLayout();
                    gLayout.setGridScaleFactor(sizeScaleFactor);
                    pd.setPFDLayout((LayoutStrategyInterface)gLayout);
                    break;
                }
                case 4: {
                    PathDiagramGRIPLayout GRIPlayout = new PathDiagramGRIPLayout(graph.size.width, graph.size.height);
                    GRIPlayout.setGridScaleFactor(sizeScaleFactor);
                    GRIPlayout.setGraphScale(graphScale);
                    pd.setPFDLayout((LayoutStrategyInterface)GRIPlayout);
                    break;
                }
                case 5: {
                    PathDiagramNeuralNetworkLayout nnlayout = new PathDiagramNeuralNetworkLayout();
                    nnlayout.setGridScaleFactor(sizeScaleFactor);
                    pd.setPFDLayout((LayoutStrategyInterface)nnlayout);
                }
            }
        }
        pd.setScaleToFit(true);
        path.setLinkLabelAttrs(linkLabelAttrs);
        path.setNodeLabelAttrs(nodeLabelAttrs);
        path.setNodeTitleAttrs(nodeTitleAttrs);
        path.setNodeOutlineAttrs(nodeOutlineAttrs);
        return true;
    }

    private static FillAttrs parseFillAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, FillAttrs fa) {
        if (fa == null) {
            fa = new FillAttrs();
        }
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute(attrName), fa, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseFillAttrs(graph, le, fa);
        }
        return fa;
    }

    private static TextAttrs parseTextAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, TextAttrs ta) {
        if (ta == null) {
            ta = new TextAttrs();
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute(attrName), ta, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseTextAttrs(graph, le, ta);
        }
        return ta;
    }

    private static LineAttrs parseLineAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        if (la == null) {
            la = new LineAttrs();
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        return la;
    }

    private static double[] normalize(double[] nodeRelativeSize) {
        double[] normalizedSize = new double[nodeRelativeSize.length];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < nodeRelativeSize.length; ++i) {
            if (Double.isNaN(nodeRelativeSize[i])) continue;
            min = Math.min(min, nodeRelativeSize[i]);
            max = Math.max(max, nodeRelativeSize[i]);
        }
        double delta = max - min;
        for (int i = 0; i < nodeRelativeSize.length; ++i) {
            normalizedSize[i] = delta == 0.0 || Double.isNaN(nodeRelativeSize[i]) ? 1.0 : nodeRelativeSize[i] / max;
        }
        return normalizedSize;
    }

    private static HashMap getLinkMap(int obs, String[] fromNode, String[] toNode, double[] linkPriority) {
        HashMap<String, ArrayList<String>> linkMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < obs; ++i) {
            if (fromNode[i] == null || toNode[i] == null || linkPriority != null && linkPriority[i] != 1.0 && linkPriority[i] != 2.0) continue;
            ArrayList<String> toList = (ArrayList<String>)linkMap.get(fromNode[i]);
            if (toList == null) {
                toList = new ArrayList<String>();
                linkMap.put(fromNode[i], toList);
            }
            toList.add(toNode[i]);
        }
        return linkMap;
    }

    private static boolean isReciprocalPair(HashMap linkMap, String from, String to) {
        ArrayList toList = (ArrayList)linkMap.get(to);
        if (toList == null) {
            return false;
        }
        for (int i = 0; i < toList.size(); ++i) {
            if (!((String)toList.get(i)).equals(from)) continue;
            return true;
        }
        return false;
    }

    private static void scaleFontSize(TextAttrs nodeTitleAttrs, TextAttrs nodeLabelAttrs, TextAttrs linkLabelAttrs, double scale) {
        scale = Math.pow(scale, 0.25);
        Font f = nodeTitleAttrs.getFont();
        Font scaledF = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * scale));
        nodeTitleAttrs.setFont(scaledF);
        f = nodeLabelAttrs.getFont();
        scaledF = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * scale));
        nodeLabelAttrs.setFont(scaledF);
        f = linkLabelAttrs.getFont();
        scaledF = new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * scale));
        linkLabelAttrs.setFont(scaledF);
    }
}

