/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.regions.MosaicRegion;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import java.awt.Color;
import org.w3c.dom.Element;

public final class MosaicParser {
    public static final String RB_KEY = "MosaicParser.";

    public static MosaicRegion load(StatGraph graph, Element elem) {
        MosaicRegion mosaic = (MosaicRegion)graph.getObjectFromElement(elem);
        if (mosaic == null) {
            mosaic = new MosaicRegion();
        }
        return MosaicParser.load(graph, mosaic, elem) ? mosaic : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean load(StatGraph graph, MosaicRegion mosaic, Element elem) {
        Color clr;
        int i;
        String urlVarID;
        int ucol;
        int crcol;
        String str;
        graph.style.resetCounters();
        graph.addSupportedGraph();
        String dataName = null;
        DataModel m = null;
        RoleColumnMap map = new RoleColumnMap();
        Element byElem = StatGraph.getOptionAttrsElement(elem, "CategoryVars");
        if (byElem == null) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "category.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)0));
            return false;
        }
        String[] byVars = StatGraph.parseStringValueList(byElem, "Value");
        if (byVars == null || byVars.length == 0 || byVars.length > 3) {
            int cnum = byVars == null ? 0 : byVars.length;
            Message msg = new Message(RB.getStringResource(RB_KEY, "category.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)cnum));
            return false;
        }
        dataName = StatGraph.getDataName(byVars[0]);
        m = graph.getData(dataName);
        String[] tv = new String[byVars.length];
        for (int i2 = 0; i2 < tv.length; ++i2) {
            tv[i2] = StatGraph.getVarID(byVars[i2]);
        }
        mosaic.setCategoryVarNames(tv);
        if (graph.isCASData()) {
            mosaic.setCategoryOrder(1);
        }
        if ((str = elem.getAttribute("count")).length() == 0) {
            str = elem.getAttribute("response");
        }
        if (str.length() <= 0) return false;
        String cntVarID = StatGraph.getVarID(str);
        int ccol = m.getColumn(cntVarID);
        if (!StatGraph.checkVariable("COUNT", m.getColumnLabel(ccol), Double.class, 0, false, 1, true)) return false;
        ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(ccol);
        if (cmd.getMax() == 0.0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "count.txt"));
            return false;
        }
        mosaic.setCountVarName(cntVarID);
        mosaic.addRole("COUNT", m.getColumnLabel(ccol));
        str = elem.getAttribute("colorResponse");
        boolean gradientColor = false;
        String crVarID = StatGraph.getVarID(str);
        if (crVarID.length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
            mosaic.setColorResponseVarName(crVarID);
            mosaic.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
            gradientColor = true;
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                mosaic.setColorRAM(graph.getRangeAttrVar(str));
            }
        }
        str = elem.getAttribute("colorGroup");
        if (!gradientColor && str.length() > 0) {
            String cgVarID = StatGraph.getVarID(str);
            for (int i3 = 0; i3 < tv.length; ++i3) {
                if (!cgVarID.equalsIgnoreCase(tv[i3])) continue;
                mosaic.setColorGroupIndex(i3);
                int cgcol = m.getColumn(cgVarID);
                mosaic.addRole("COLORGROUP", m.getColumnLabel(cgcol));
                str = elem.getAttribute("colorGroupAttrVar");
                if (str.length() > 0) {
                    mosaic.setColorDAM(graph.getDiscreteAttrVar(str));
                    break;
                }
                if (!DAMDatasetParser.hasInternalDAttrVar(graph, cgVarID)) break;
                mosaic.setColorDAM(DAMDatasetParser.getInternalDAttrMapper(graph, cgVarID));
                break;
            }
        }
        if ((str = elem.getAttribute("url")).length() > 0 && StatGraph.checkVariable("URL", m.getColumnLabel(ucol = m.getColumn(urlVarID = StatGraph.getVarID(str))), String.class, 1, false)) {
            mosaic.setURLVarName(urlVarID);
            mosaic.addRole("URL", m.getColumnLabel(ucol));
        }
        LayoutRegionParser.parseRoleTipStuff(elem, m, mosaic, true);
        str = elem.getAttribute("gutter");
        if (StatGraph.isLineThickness(str)) {
            int gt = (int)Double.parseDouble(str);
            if (gt >= 0) {
                mosaic.setMinimumGutter(gt);
            } else {
                StatGraph.printOptionError("GUTTER", "(" + str + ")");
            }
        } else if (str.length() > 0) {
            int[] gutters = null;
            try {
                gutters = StatGraph.parseList2Int(str);
            }
            catch (NumberFormatException nfe) {
                gutters = null;
            }
            if (gutters == null || gutters.length != mosaic.getDimension()) {
                StatGraph.printOptionError("GUTTER", "(" + str + ")");
            } else {
                boolean valid = true;
                for (i = 0; i < gutters.length; ++i) {
                    if (gutters[i] >= 0) continue;
                    StatGraph.printOptionError("GUTTER", "(" + str + ")");
                    valid = false;
                    break;
                }
                if (valid) {
                    mosaic.setGutters(gutters);
                }
            }
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        mosaic.setCRD(crd);
        LayoutRegionParser.parseGraphOpts(graph, elem, mosaic);
        str = elem.getAttribute("valueLocation");
        if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
            if (str.equalsIgnoreCase("inside")) {
                mosaic.setValueLocation(2);
            } else if (str.equalsIgnoreCase("outside")) {
                mosaic.setValueLocation(1);
            } else {
                StatGraph.printOptionError("VALUELOCATION", str);
            }
        }
        if ((str = elem.getAttribute("insideValueFitPolicy")).length() != 0 && !str.equalsIgnoreCase("none")) {
            if (str.equalsIgnoreCase("split")) {
                mosaic.setInsideValueFitting(1);
            } else if (str.equalsIgnoreCase("splitalways")) {
                mosaic.setInsideValueFitting(2);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("INSIDEVALUEFITPOLICY", str);
            }
        }
        if ((str = elem.getAttribute("xValueFitPolicy")).length() != 0 && !str.equalsIgnoreCase("rotate")) {
            if (str.equalsIgnoreCase("none")) {
                mosaic.setHorizontalOutsideValuesFitting(false);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("XVALUEFITPOLICY", str);
            }
        }
        if ((str = elem.getAttribute("yValueFitPolicy")).length() == 0 || str.equalsIgnoreCase("none")) {
            mosaic.setVerticalOutsideValues(false);
        } else if (str.equalsIgnoreCase("rotatealways")) {
            mosaic.setVerticalOutsideValues(true);
        } else if (str.length() > 0) {
            mosaic.setVerticalOutsideValues(false);
            StatGraph.printOptionError("YVALUEFITPOLICY", str);
        }
        str = elem.getAttribute("display");
        mosaic.setPercentAxesOn(false);
        mosaic.setFillOn(true);
        mosaic.setOutlineOn(true);
        mosaic.setValuesOn(true);
        mosaic.setLabelsOn(true);
        mosaic.setTicksOn(false);
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                mosaic.setTicksOn(true);
            } else {
                mosaic.setFillOn(false);
                mosaic.setOutlineOn(false);
                mosaic.setValuesOn(false);
                mosaic.setLabelsOn(false);
                mosaic.setTicksOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        mosaic.setOutlineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        mosaic.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("values")) {
                        mosaic.setValuesOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("labels")) {
                        mosaic.setLabelsOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("ticks")) {
                        mosaic.setTicksOn(true);
                        continue;
                    }
                    mosaic.setFillOn(true);
                    mosaic.setOutlineOn(true);
                    mosaic.setValuesOn(true);
                    mosaic.setLabelsOn(true);
                    StatGraph.printOptionError("DISPLAY", str);
                    break;
                }
                if (!mosaic.isFillOn() && !mosaic.isOutlineOn()) {
                    mosaic.setFillOn(true);
                    mosaic.setOutlineOn(true);
                }
            }
        }
        Color missingEdgeColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getLineColor();
        mosaic.setMissingEdgeColor(missingEdgeColor);
        Color missingFillColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor();
        mosaic.setMissingFillColor(missingFillColor);
        str = elem.getAttribute("squared");
        mosaic.setSquared(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("dataSkin");
        int skinType = 0;
        if (str.length() > 0 && (skinType = StatGraph.dataSkinName2Int(str)) < 0) {
            StatGraph.printOptionError("DATASKIN", str);
        }
        if (skinType < 0 && (str = graph.style.getStyleAttribute("Skins", "dataSkin")) != null && str.length() > 0) {
            skinType = StatGraph.dataSkinName2Int(str);
        }
        if (skinType >= 0) {
            mosaic.setSkinType(skinType);
        }
        FillAttrs fa = mosaic.getFillStyle();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("fillAttrs"), fa, "GraphDataStyleDefault");
        Element fillElem = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        boolean colorDefined = false;
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, fa);
            colorDefined = fillElem.hasAttribute("color");
        }
        mosaic.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("valueAttrs"), mosaic.getDataLabelStyle(), "ValueText");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "ValueAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, mosaic.getDataLabelStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("insideValueAttrs"), mosaic.getInsideDataLabelStyle(), "ValueText");
        Element inLabelElem = StatGraph.getOptionAttrsElement(elem, "InsideValueAttrs");
        if (inLabelElem != null) {
            StatGraph.parseTextAttrs(graph, inLabelElem, mosaic.getInsideDataLabelStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), mosaic.getLabelStyle(), "LabelText");
        labelElem = StatGraph.getOptionAttrsElement(elem, "LabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, mosaic.getLabelStyle());
        }
        LineAttrs la = mosaic.getOutlineStyle();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), la, "Outlines");
        Element outlineElem = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
        if (outlineElem != null) {
            StatGraph.parseLineAttrs(graph, outlineElem, la);
        }
        if ((clr = StatGraph.parseAttrColor("wallColor", graph, elem)) != null) {
            mosaic.setWallColor(clr);
        }
        if (gradientColor) {
            mosaic.setColorGroupIndex(-1);
            Color missingColor = mosaic.isFillOn() ? missingFillColor : missingEdgeColor;
            mosaic.setColorMapper((ColorMapper)MosaicParser.createGTKColorMapper(elem, graph, mosaic, str, fa, missingColor));
        } else if (mosaic.getColorGroupIndex() >= 0 && !colorDefined) {
            StringVectorVariable cgVar;
            String cgVarID = mosaic.getCategoryVarNames()[mosaic.getColorGroupIndex()];
            int ccol2 = m.getColumn(cgVarID);
            ColumnMetadata cmd2 = (ColumnMetadata)m.getColumnLabel(ccol2);
            boolean numeric = cmd2.getType() == 1;
            StringToColorMapper stcm = new StringToColorMapper();
            StringVectorVariable newCGVar = cgVar = mosaic.getCategoryVars()[mosaic.getColorGroupIndex()];
            if (graph.isCASData()) {
                newCGVar = new StringVariable();
                newCGVar.connectFrom((StringVariable)cgVar);
                newCGVar.setUniqueValueSort(1);
            }
            for (int i4 = 0; i4 < newCGVar.getUniqueValueCount(); ++i4) {
                try {
                    String cat = newCGVar.uniqueValue.getValue(i4);
                    Color c = LayoutOverlayParser.isMissing(cat, numeric) ? (mosaic.isFillOn() ? missingFillColor : missingEdgeColor) : graph.style.getNextFillColor();
                    stcm.add(cat, mosaic.applyDataTransparency(c, mosaic.getFillStyle()));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            mosaic.setColorMapper((ColorMapper)stcm);
        } else {
            mosaic.setColorGroupIndex(-1);
        }
        if (graph.dataAntialiased) {
            mosaic.setAntialiased(graph.updateAAMax(m.getRowCount()));
        } else {
            mosaic.setAntialiased(false);
        }
        if (graph.imagemapEnabled && mosaic.isTooltipEnabled()) {
            mosaic.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
            return true;
        } else {
            mosaic.setTooltipEnabled(false);
        }
        return true;
    }

    private static final ContinuousRangeToColorMapper createGTKColorMapper(Element elem, StatGraph graph, MosaicRegion mosaic, String str, FillAttrs fa, Color missingColor) {
        Color[] colors;
        str = elem.getAttribute("colorModel");
        Color[] cl = graph.style.getRampColors(str, "ThreeColorRamp");
        Element cmElem = StatGraph.getOptionAttrsElement(elem, "ColorModel");
        if (cmElem != null && (colors = StatGraph.parseColorValueList(graph, cmElem, "Value")) != null && colors.length > 0) {
            cl = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
        }
        str = elem.getAttribute("reverseColorModel");
        boolean reverse = str.equalsIgnoreCase("true");
        Color[] rampColors = new Color[cl.length];
        for (int i = 0; i < cl.length; ++i) {
            int idx = reverse ? cl.length - 1 - i : i;
            rampColors[i] = mosaic.applyDataTransparency(cl[idx], fa);
        }
        ContinuousRangeToColorMapper colorMapper = new ContinuousRangeToColorMapper();
        double[] values = new double[]{0.0, 0.5, 1.0};
        colorMapper.setColorSpectrumColors(rampColors);
        colorMapper.setColorSpectrumValues(values);
        colorMapper.setReplaceMissingValues(true);
        colorMapper.setMissingReplacement(missingColor);
        return colorMapper;
    }
}

