/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LineParmParser {
    public static final String RB_KEY = "LineParmParser.";

    public static LineParmOverlay load(StatGraph graph, Element elem) {
        LineParmOverlay line = (LineParmOverlay)graph.getObjectFromElement(elem);
        if (line == null) {
            line = new LineParmOverlay();
        }
        return LineParmParser.load(graph, line, elem) ? line : null;
    }

    public static boolean load(StatGraph graph, LineParmOverlay line, Element elem) {
        Message msg;
        Element elem2;
        graph.addSupportedGraph();
        boolean grouped = false;
        String dataName = null;
        String slopeVarID = null;
        String xVarID = null;
        String yVarID = null;
        String groupVarID = null;
        double slope = Double.NaN;
        double x = Double.NaN;
        double y = Double.NaN;
        boolean hasSlope = false;
        boolean hasX = false;
        boolean hasY = false;
        LayoutOverlayParser.parseGraphOpts(graph, elem, line);
        String str = elem.getAttribute("slope");
        if (StatGraph.isNumber(str)) {
            slope = Double.parseDouble(str);
            line.setConstantSlope(slope);
            hasSlope = true;
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            dataName = StatGraph.getDataName(str);
            slopeVarID = StatGraph.getVarID(str);
            hasSlope = true;
        } else if (str.equalsIgnoreCase(".")) {
            hasSlope = true;
        }
        str = elem.getAttribute("y");
        if (StatGraph.isNumber(str)) {
            y = Double.parseDouble(str);
            line.setConstantY(y);
            hasY = true;
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            yVarID = StatGraph.getVarID(str);
            hasY = true;
        }
        str = elem.getAttribute("x");
        if (StatGraph.isNumber(str)) {
            x = Double.parseDouble(str);
            line.setConstantX(x);
            hasX = true;
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            xVarID = StatGraph.getVarID(str);
            hasX = true;
        }
        if (!(hasSlope && hasX && hasY)) {
            graph.removeNamedGraph(line);
            return false;
        }
        str = elem.getAttribute("group");
        if (str.length() > 0) {
            groupVarID = StatGraph.getVarID(str);
            grouped = groupVarID.length() > 0;
        }
        line.setColorPriority(graph.style.getAttrPriority() == 1);
        line.setStyleColorCount(graph.style.getColorCount());
        String contextName = graph.style.getContextName();
        line.setContextName(contextName);
        int contextCount = graph.style.getContextCount();
        boolean curveLabeled = false;
        if (dataName == null || dataName.length() <= 0) {
            Color[] clist = new Color[1];
            LineAttrs[] llist = new LineAttrs[]{new LineAttrs()};
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), llist[0], contextName);
            elem2 = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
            if (elem2 != null) {
                StatGraph.parseLineAttrs(graph, elem2, llist[0]);
            }
            clist[0] = llist[0].getColor();
            line.setLineColors(0, clist);
            line.setLineStyles(0, llist);
            line.setModel(null);
            line.setLineWidths(llist[0].getWidth());
            line.setXValue(x);
            line.setYValue(y);
            if (Double.isNaN(slope)) {
                slope = Double.MAX_VALUE;
                y = Double.NaN;
            }
            line.setDefaultSlope(slope);
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                double yIntercept = y - slope * x;
                line.setDefaultIntercept(yIntercept);
            } else if (!Double.isNaN(y)) {
                line.setDefaultIntercept(y);
            } else if (!Double.isNaN(x)) {
                line.setXInterceptBased(true);
                line.setDefaultIntercept(x);
            }
            str = elem.getAttribute("curveLabel");
            if (str.length() > 0) {
                int type = StatGraph.getAttributeType(elem, "curveLabel");
                if (type < 0) {
                    line.setCurveLabelString(str);
                    curveLabeled = true;
                } else if (type != 0) {
                    line.setCurveLabelString(str);
                    curveLabeled = true;
                } else {
                    msg = new Message(RB.getStringResource(RB_KEY, "label2.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                }
            }
        } else {
            String indexVarID;
            int ii;
            LineAttrs[] lsl;
            Color[] clist;
            DataModel m = graph.getData(dataName);
            RoleColumnMap map = new RoleColumnMap();
            if (slopeVarID != null) {
                int scol = m.getColumn(slopeVarID);
                if (!StatGraph.checkVariable("SLOPE", m.getColumnLabel(scol), Double.class, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(30, scol);
            }
            if (yVarID != null) {
                int ycol = m.getColumn(yVarID);
                if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(11, ycol);
            }
            if (xVarID != null) {
                int xcol = m.getColumn(xVarID);
                if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(10, xcol);
            }
            if (groupVarID != null) {
                if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, line.getStmt())) {
                    grouped = false;
                } else {
                    int gcol = m.getColumn(groupVarID);
                    map.map(3, gcol);
                    str = elem.getAttribute("includeMissingGroup");
                    if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                        line.setMissingGroupOn(false);
                    }
                    if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                        line.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    } else {
                        DAMDatasetParser.addInternalAttrVar(graph, line, "GROUP", groupVarID);
                    }
                    if (graph.isCASData()) {
                        line.setGroupOrder(1);
                        line.setDrawByGroupOrder(true);
                    }
                }
            }
            if ((str = elem.getAttribute("curveLabel")).length() > 0) {
                String curveLabelVarID;
                int type = StatGraph.getAttributeType(elem, "curveLabel");
                if (type < 0) {
                    curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    } else {
                        Message msg2 = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                        StatGraph.printNote(msg2.toString((Object)str));
                    }
                } else if (type == 0) {
                    curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    }
                } else {
                    msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                    String val = type == 2 ? str : "'" + str + "'";
                    StatGraph.printNote(msg.toString((Object)val));
                }
            }
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(map);
            LayoutOverlayParser.parseWhere(graph, crd, line);
            DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
            if (missingElem == null) {
                missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
            }
            Color missingContrastColor = missingElem.getContrastColor();
            LineAttrs missingLineAttrs = line.getMissingLineAttrs();
            missingLineAttrs.setColor(missingContrastColor);
            missingLineAttrs.setLinePattern(missingElem.getLineStyle());
            line.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "lineAttrs", "thickness"));
            boolean cCount = false;
            boolean lCount = false;
            LineAttrs ls = new LineAttrs();
            String lineAttr = elem.getAttribute("lineAttrs");
            GraphStyle.setDefaultDataLineStyle(graph, lineAttr, ls, contextName);
            elem2 = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
            if (elem2 != null) {
                StatGraph.parseLineAttrs(graph, elem2, ls);
                line.setLineWidths(ls.getWidth());
                if (!grouped || lineAttr.length() > 0 || elem2.hasAttribute("color")) {
                    clist = new Color[]{ls.getColor()};
                    line.setLineColors(0, clist);
                    line.setFixedLineColor(elem2.hasAttribute("color"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        line.setLineColors(contextCount, graph.style.contrastColorList);
                    } else {
                        line.setLineColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    }
                    cCount = true;
                }
                if (!grouped || lineAttr.length() > 0 || elem2.hasAttribute("pattern")) {
                    LineAttrs[] lsl2 = new LineAttrs[]{ls};
                    line.setLineStyles(0, lsl2);
                    line.setFixedLinePattern(elem2.hasAttribute("pattern"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        line.setLineStyles(contextCount, graph.style.lineStyleList);
                    } else {
                        line.setLineStyles(graph.style.lineStyleCnt, graph.style.lineStyleList);
                    }
                    lCount = true;
                }
            } else if (grouped) {
                if (lineAttr.length() > 0) {
                    clist = new Color[]{ls.getColor()};
                    line.setLineColors(0, clist);
                    lsl = new LineAttrs[]{ls};
                    line.setLineStyles(0, lsl);
                    line.setFixedLineColor(true);
                    line.setFixedLinePattern(true);
                } else if (graph.style.isCycleAttrs()) {
                    line.setLineColors(contextCount, graph.style.contrastColorList);
                    line.setLineStyles(contextCount, graph.style.lineStyleList);
                } else {
                    line.setLineColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    line.setLineStyles(graph.style.lineStyleCnt, graph.style.lineStyleList);
                }
                cCount = true;
                lCount = true;
            } else {
                clist = new Color[]{ls.getColor()};
                line.setLineColors(0, clist);
                lsl = new LineAttrs[]{ls};
                line.setLineStyles(0, lsl);
            }
            str = elem.getAttribute("index");
            if (str.length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                line.colorIndex = m.getDoubleColumn(ii);
                line.styleIndex = line.colorIndex;
                if (cCount) {
                    line.setLineColors(0, graph.style.contrastColorList);
                }
                if (lCount) {
                    line.setLineStyles(0, graph.style.lineStyleList);
                }
            }
            line.setModel(crd);
            if (line.isUseLineThickness() || !line.hasAttrVar("GROUP")) {
                line.setLineWidths(ls.getWidth());
            }
            if (line.colorIndex == null) {
                graph.style.setContextCount(contextCount + line.getNumberOfGroups());
            } else {
                graph.style.setContextCount(contextCount);
            }
        }
        TextStyle labelStyle = null;
        if (curveLabeled) {
            str = elem.getAttribute("curveLabelLocation");
            if (str.equalsIgnoreCase("OUTSIDE")) {
                if (BandParser.isUnderLatticeLayout(elem)) {
                    line.setCurveLabelLocation(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "outsidelabel.txt"));
                } else {
                    line.setCurveLabelLocation(1);
                }
            } else if (str.equalsIgnoreCase("INSIDE")) {
                line.setCurveLabelLocation(0);
            } else {
                line.setCurveLabelLocation(0);
                if (str.length() > 0) {
                    StatGraph.printOptionError("CURVELABELLOCATION", str);
                }
            }
            str = elem.getAttribute("curveLabelPosition");
            if (StatGraph.isNumber(str)) {
                line.setLabelPosition(Double.parseDouble(str));
            } else if (str.equalsIgnoreCase("MIN")) {
                line.setLabelPosition(0.0);
            } else if (str.equalsIgnoreCase("MAX")) {
                line.setLabelPosition(1.0);
            } else if (str.equalsIgnoreCase("AUTO")) {
                line.setLabelPosition(1.0);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("CURVELABELPOSITION", str);
            }
            labelStyle = new TextStyle();
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("curveLabelAttrs"), labelStyle, "ValueText");
            if (!grouped) {
                if (graph.style.isCycleAttrs()) {
                    labelStyle.setColor(line.getLineColors()[0]);
                }
                line.setUseLabelColor(true);
            } else if (elem.getAttribute("curveLabelAttrs").length() > 0) {
                line.setUseLabelColor(true);
            }
            str = elem.getAttribute("curveLabelHAlign");
            if (str.length() > 0) {
                line.setLabelInsideHAutomatic(false);
                if (str.equalsIgnoreCase("LEFT")) {
                    labelStyle.setHorizontalJustification(0);
                } else if (str.equalsIgnoreCase("RIGHT")) {
                    labelStyle.setHorizontalJustification(2);
                } else {
                    labelStyle.setHorizontalJustification(1);
                }
            } else {
                labelStyle.setHorizontalJustification(0);
            }
            str = elem.getAttribute("curveLabelVAlign");
            if (str.length() > 0) {
                line.setLabelInsideVAutomatic(false);
                if (str.equalsIgnoreCase("TOP")) {
                    labelStyle.setVerticalJustification(0);
                } else if (str.equalsIgnoreCase("BOTTOM")) {
                    labelStyle.setVerticalJustification(3);
                } else {
                    labelStyle.setVerticalJustification(1);
                }
            } else {
                labelStyle.setVerticalJustification(0);
            }
            line.setLabelStyle(labelStyle);
            str = elem.getAttribute("curveLabelFormat");
            if (str.length() > 0) {
                SASFormat lf = SASFormat.getInstance((String)str);
                line.setLabelFormat(lf);
            }
            ScatterParser.parseCurveLabelSplitting(graph, line, elem);
        }
        if ((str = elem.getAttribute("extend")).length() > 0 && str.equalsIgnoreCase("true")) {
            line.setExtreme(true);
        }
        if ((str = elem.getAttribute("clip")).length() > 0 && str.equalsIgnoreCase("true")) {
            line.setClipping(true);
        }
        if ((str = elem.getAttribute("dataLabelProtected")).equalsIgnoreCase("true")) {
            line.setProtectedLine(true);
        } else {
            line.setProtectedLine(false);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("CurveLabelAttrs") || labelStyle == null) continue;
            if (((Element)node).hasAttribute("color")) {
                line.setUseLabelColor(true);
            }
            StatGraph.parseTextAttrs(graph, (Element)node, labelStyle);
        }
        return true;
    }
}

