/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LineChartParser {
    public static final String RB_KEY = "LineChartParser.";

    public static LineChartOverlay load(StatGraph graph, Element elem) {
        LineChartOverlay lineChart = (LineChartOverlay)graph.getObjectFromElement(elem);
        if (lineChart == null) {
            lineChart = new LineChartOverlay();
        }
        return LineChartParser.load(graph, lineChart, elem) ? lineChart : null;
    }

    public static boolean load(StatGraph graph, LineChartOverlay lineChart, Element elem) {
        Node node;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, lineChart);
        String str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                lineChart.setLineOn(true);
                lineChart.setFillOn(true);
                lineChart.setMarkerOn(true);
            } else {
                lineChart.setLineOn(false);
                lineChart.setFillOn(false);
                lineChart.setMarkerOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("line")) {
                        lineChart.setLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        lineChart.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("markers")) {
                        lineChart.setMarkerOn(true);
                        continue;
                    }
                    lineChart.setLineOn(true);
                    lineChart.setFillOn(false);
                    lineChart.setMarkerOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            lineChart.setLineOn(true);
            lineChart.setFillOn(false);
            lineChart.setMarkerOn(false);
        }
        String elemTag = "";
        boolean gotGroup = false;
        boolean gotColor = false;
        boolean gotLine = false;
        boolean gotLineColor = false;
        boolean gotShape = false;
        boolean gotShapeColor = false;
        boolean gotShapeWeight = false;
        boolean gotShapeFillColor = false;
        boolean gotShapeOutlineColor = false;
        boolean gotShapeOutlineThickness = false;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (lineChart.isFillOn() && elemTag.equals("FillAttrs") && ((Element)node).hasAttribute("color")) {
                gotColor = true;
                continue;
            }
            if (lineChart.isLineOn() && elemTag.equals("LineAttrs")) {
                if (((Element)node).hasAttribute("pattern")) {
                    gotLine = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotLineColor = true;
                continue;
            }
            if (!lineChart.isMarkerOn()) continue;
            if (elemTag.equals("MarkerAttrs")) {
                if (((Element)node).hasAttribute("symbol")) {
                    gotShape = true;
                }
                if (((Element)node).hasAttribute("color")) {
                    gotShapeColor = true;
                }
                if (!((Element)node).hasAttribute("weight")) continue;
                gotShapeWeight = true;
                continue;
            }
            if (elemTag.equals("MarkerOutlineAttrs")) {
                if (((Element)node).hasAttribute("thickness")) {
                    gotShapeOutlineThickness = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotShapeOutlineColor = true;
                continue;
            }
            if (!elemTag.equals("MarkerFillAttrs") || !((Element)node).hasAttribute("color")) continue;
            gotShapeFillColor = true;
        }
        String fillAttr = elem.getAttribute("fillAttrs");
        String lineAttr = elem.getAttribute("lineAttrs");
        String mrkAttr = elem.getAttribute("markerAttrs");
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        if (mrkAttr.length() > 0 || gotShapeColor) {
            lineChart.setUseMarkerAttrsColor(true);
        }
        if ((str = elem.getAttribute("filledOutlinedMarkers")).equalsIgnoreCase("true")) {
            lineChart.setFilledOutlinedMarker(true);
            if (mrkFillAttr.length() > 0 || gotShapeFillColor) {
                lineChart.setUseMarkerFillAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || gotShapeOutlineColor) {
                lineChart.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || gotShapeOutlineThickness) {
                lineChart.setUseMarkerOutlineAttrsThickness(true);
            }
        }
        lineChart.setUseMarkerSize(StatGraph.isBundleAttributeFixed(elem, "markerAttrs", "size"));
        lineChart.setUseMarkerWeight(gotShapeWeight);
        lineChart.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "lineAttrs", "thickness"));
        lineChart.setUseMarkerTransparency(StatGraph.isTransparencyFixed(elem, "MarkerAttrs"));
        lineChart.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        str = elem.getAttribute("primary");
        lineChart.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("category");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        DataModel m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        }
        RoleColumnMap map = new RoleColumnMap();
        if (StatGraph.isOLAP()) {
            map.map(1, xVarID);
        } else {
            int xcol = m.getColumn(xVarID);
            if (!StatGraph.checkVariable("CATEGORY", m.getColumnLabel(xcol), null, 1, true)) {
                graph.removeNamedGraph(lineChart);
                return false;
            }
            map.map(1, xcol);
            lineChart.addRole("CATEGORY", m.getColumnLabel(xcol));
        }
        boolean gradientColor = false;
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null || StatGraph.parseStringValueList(rElem, "Value").length == 1) {
            String indexVarID;
            int ii;
            int crcol;
            String crVarID;
            str = rElem == null ? elem.getAttribute("response") : StatGraph.parseStringValueList(rElem, "Value")[0];
            String yVarID = StatGraph.getVarID(str);
            if (yVarID.length() > 0) {
                if (StatGraph.isOLAP()) {
                    map.map(2, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 1, true)) {
                        graph.removeNamedGraph(lineChart);
                        return false;
                    }
                    map.map(2, ycol);
                    lineChart.addRole("RESPONSE", m.getColumnLabel(ycol));
                }
            }
            if ((crVarID = StatGraph.getVarID(str = elem.getAttribute("colorResponse"))).length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
                gradientColor = true;
                if (lineChart.isFillOn()) {
                    map.map(6, crcol);
                } else {
                    map.map(46, crcol);
                }
                lineChart.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
                str = elem.getAttribute("colorResponseAttrVar");
                if (str.length() > 0) {
                    lineChart.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
                }
            }
            lineChart.setGradientColor(gradientColor);
            str = elem.getAttribute("group");
            if (str.length() > 0) {
                String gVarID = StatGraph.getVarID(str);
                if (StatGraph.isOLAP()) {
                    gotGroup = true;
                    map.map(3, gVarID);
                    map.map(6, gVarID);
                    map.map(36, gVarID);
                    map.map(46, gVarID);
                    map.map(111, gVarID);
                    map.map(112, gVarID);
                } else if (!LayoutOverlayParser.hasTooManyGroups(graph, m, StatGraph.getVarID(str), lineChart.getStmt())) {
                    gotGroup = true;
                    int gcol = m.getColumn(gVarID);
                    map.map(3, gcol);
                    if (!gradientColor && !gotColor && fillAttr.length() == 0) {
                        map.map(6, gcol);
                    }
                    if (!gotLine && lineAttr.length() == 0) {
                        map.map(36, gcol);
                    }
                    if (!gradientColor && !gotLineColor && lineAttr.length() == 0) {
                        map.map(46, gcol);
                    }
                    if (!gotShape && mrkAttr.length() == 0) {
                        map.map(8, gcol);
                    }
                    if (!gradientColor && !gotShapeColor && mrkAttr.length() == 0) {
                        map.map(45, gcol);
                    }
                    if (!gradientColor && lineChart.isFilledOutlinedMarker()) {
                        if (!map.isRoleMapped(45)) {
                            map.map(45, gcol);
                        }
                        if (!gotShapeFillColor && mrkFillAttr.length() == 0) {
                            map.map(69, gcol);
                        }
                    }
                    lineChart.addRole("GROUP", m.getColumnLabel(gcol));
                    str = elem.getAttribute("includeMissingGroup");
                    if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                        lineChart.setMissingGroupOn(false);
                    }
                    if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                        lineChart.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    } else {
                        String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : gVarID;
                        DAMDatasetParser.addInternalAttrVar(graph, lineChart, "GROUP", originalGroup);
                    }
                }
            }
            if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                map.map(44, ii);
                lineChart.addRole("INDEX", m.getColumnLabel(ii));
            }
        } else {
            String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
            int cnt = 0;
            for (int i = 0; i < multiResponseVars.length; ++i) {
                str = multiResponseVars[i];
                String yVarID = StatGraph.getVarID(str);
                if (yVarID.length() <= 0) continue;
                if (StatGraph.isOLAP()) {
                    map.map(610 + cnt, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 1, true)) continue;
                    map.map(610 + cnt, ycol);
                    lineChart.addRole("MULTI_RESPONSE" + cnt, m.getColumnLabel(ycol));
                }
                ++cnt;
            }
            if (cnt == 0) {
                graph.removeNamedGraph(lineChart);
                return false;
            }
            lineChart.setResponseCount(cnt);
        }
        str = elem.getAttribute("groupDisplay");
        if (str.equalsIgnoreCase("Cluster")) {
            lineChart.setGroupDisplay(0);
        } else if (str.equalsIgnoreCase("Stack")) {
            lineChart.setGroupDisplay(2);
        } else {
            lineChart.setGroupDisplay(1);
        }
        str = elem.getAttribute("stat");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("SUM")) {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    lineChart.setStatistic(6);
                } else {
                    StatGraph.printOptionError("stat", str);
                    lineChart.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("MEAN")) {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    lineChart.setStatistic(1);
                } else {
                    StatGraph.printOptionError("stat", str);
                    lineChart.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("FREQ")) {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    lineChart.setStatistic(6);
                } else {
                    lineChart.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("PCT")) {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    lineChart.setStatistic(6);
                } else {
                    lineChart.setStatistic(13);
                }
            } else if (str.equalsIgnoreCase("PROPORTION")) {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    lineChart.setStatistic(6);
                } else {
                    lineChart.setStatistic(3);
                }
            } else {
                if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                    lineChart.setStatistic(6);
                } else {
                    lineChart.setStatistic(2);
                }
                StatGraph.printOptionError("STAT", str);
            }
        } else if (elem.getAttribute("_stmt").equalsIgnoreCase("LineChart")) {
            if (map.isRoleMapped(2) || lineChart.isMultiResponse()) {
                lineChart.setStatistic(6);
            } else {
                lineChart.setStatistic(2);
            }
        }
        StatGraph.parseURLOpt(elem, m, map, lineChart);
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, lineChart);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, lineChart);
        str = elem.getAttribute("clusterWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            lineChart.setClusterWidth(width);
        }
        if (!gotGroup && !lineChart.isMultiResponse() || lineChart.getGroupDisplay() != 0) {
            lineChart.setClusterWidth(1.0);
        }
        if ((str = elem.getAttribute("orient")).length() > 0) {
            if (str.equalsIgnoreCase("Horizontal")) {
                lineChart.setVertical(false);
            } else if (str.equalsIgnoreCase("Vertical")) {
                lineChart.setVertical(true);
            } else {
                lineChart.setVertical(true);
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        StatGraph.parseDataSkinOpt(graph, elem, lineChart);
        str = elem.getAttribute("groupOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Ascending")) {
                lineChart.setGroupOrder(1);
            } else if (str.equalsIgnoreCase("Descending")) {
                lineChart.setGroupOrder(2);
            } else if (str.equalsIgnoreCase("Data")) {
                lineChart.setGroupOrder(0);
            } else if (str.equalsIgnoreCase("ReverseData")) {
                lineChart.setGroupOrder(3);
            } else {
                lineChart.setGroupOrder(0);
                StatGraph.printOptionError("GROUPORDER", str);
            }
        } else if (graph.isCASData()) {
            lineChart.setGroupOrder(1);
        }
        if (graph.isCASData()) {
            lineChart.setDrawByGroupOrder(true);
        }
        if ((str = elem.getAttribute("smoothConnect")).length() > 0 && str.equalsIgnoreCase("true")) {
            lineChart.setSmooth(true);
        }
        if ((str = elem.getAttribute("vertexLabel")).length() > 0 && str.equalsIgnoreCase("true")) {
            lineChart.setVertexLabelOn(true);
            str = elem.getAttribute("vertexLabelFormat");
            if (str.length() > 0) {
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"VERTEXLABELFORMAT", (Object)str));
                } else if (fmt.isCharacterFormat()) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "formattype.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"VERTEXLABELFORMAT", (Object)str));
                } else {
                    lineChart.setLabelFormat(fmt);
                }
            }
        }
        if ((str = elem.getAttribute("baselineIntercept")).length() > 0) {
            if (str.equalsIgnoreCase("AUTO")) {
                lineChart.setBaselineInterceptType(0);
            } else if (str.equalsIgnoreCase("AXISMIN")) {
                lineChart.setBaselineInterceptType(2);
            } else if (str.equalsIgnoreCase("AXISMINEXTEND")) {
                lineChart.setBaselineInterceptType(3);
            } else if (str.equalsIgnoreCase("AXISMAX")) {
                lineChart.setBaselineInterceptType(4);
            } else if (str.equalsIgnoreCase("AXISMAXEXTEND")) {
                lineChart.setBaselineInterceptType(5);
            } else if (StatGraph.isNumber(str)) {
                lineChart.setBaselineInterceptType(1);
                lineChart.setBaseline(Double.parseDouble(str));
            } else {
                StatGraph.printOptionError("BASELINEINTERCEPT", str);
            }
        }
        lineChart.setModel(crd);
        if (!lineChart.isDataValid()) {
            graph.removeNamedGraph(lineChart);
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "baddata.txt"));
            return false;
        }
        str = elem.getAttribute("break");
        if (str.equalsIgnoreCase("true")) {
            lineChart.setBreakMissing(true);
        }
        String contextName = graph.style.isCycleAttrs() ? graph.style.getContextName() : "GraphDataStyleDefault";
        lineChart.setContextName(contextName);
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), lineChart.getLineStyle(), contextName);
        if (lineChart.isFillOn()) {
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), lineChart.getFillStyle(), contextName);
        }
        if (lineChart.isMarkerOn()) {
            GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), lineChart.getMarkerStyle(), contextName);
        }
        if (lineChart.isVertexLabelOn()) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("vertexLabelAttrs"), lineChart.getLabelStyle(), "DataText");
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("baselineAttrs"), lineChart.getBaselineStyle(), "AxisLines");
        if (lineChart.isFilledOutlinedMarker()) {
            GraphStyle.setDefaultFillStyle(graph, mrkFillAttr, lineChart.getMarkerFillStyle(), contextName);
            GraphStyle.setDefaultLineStyle(graph, mrkOutlineAttr, lineChart.getMarkerOutlineStyle(), "Outlines");
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs") && lineChart.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, lineChart.getFillStyle());
                continue;
            }
            if (elemTag.equals("LineAttrs") && lineChart.isLineOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, lineChart.getLineStyle());
                continue;
            }
            if (elemTag.equals("MarkerAttrs") && lineChart.isMarkerOn()) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, lineChart.getMarkerStyle());
                continue;
            }
            if (elemTag.equals("VertexLabelAttrs") && lineChart.isVertexLabelOn()) {
                StatGraph.parseTextAttrs(graph, (Element)node, lineChart.getLabelStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                lineChart.setUseLabelColor(true);
                continue;
            }
            if (elemTag.equals("BaselineAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, lineChart.getBaselineStyle());
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs") && lineChart.isFilledOutlinedMarker()) {
                StatGraph.parseFillAttrs(graph, (Element)node, lineChart.getMarkerFillStyle());
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs") || !lineChart.isFilledOutlinedMarker()) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, lineChart.getMarkerOutlineStyle());
        }
        str = elem.getAttribute("discreteOffset");
        if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                lineChart.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        int startFillColorIndex = -1;
        if (gradientColor) {
            ColorEncoder encoder = lineChart.getFillStyle() != null && lineChart.getFillStyle().getTransparency() >= 0.0 ? StatGraph.parseColorModelOpt((byte)4, graph, elem, lineChart, lineChart.getFillStyle().getTransparency()) : StatGraph.parseColorModelOpt((byte)4, graph, elem, lineChart);
            if (encoder != null) {
                lineChart.setEncoder((byte)4, encoder);
            }
            if ((encoder = StatGraph.parseColorModelOpt((byte)17, graph, elem, lineChart)) != null) {
                lineChart.setEncoder((byte)17, encoder);
            }
        } else {
            if (!gotColor && (crd.isAvailable(6) || lineChart.isMultiResponse())) {
                graph.style.setContextCount(contextCount);
                startFillColorIndex = graph.style.fillColorCnt;
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)lineChart, (byte)4, lineChart.getFillStyle().getTransparency());
            }
            if (!gotLineColor && (crd.isAvailable(46) || lineChart.isMultiResponse())) {
                graph.style.setContextCount(contextCount);
                startContrastColorIndex = graph.style.contrastColorCnt;
                LayoutOverlayParser.setDiscreteEncoder(graph, lineChart, (byte)17);
            }
        }
        if (!gotLine && (crd.isAvailable(36) || lineChart.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, lineChart, (byte)15);
        }
        if ((!gradientColor && !gotShapeColor || lineChart.isFilledOutlinedMarker()) && (crd.isAvailable(45) || lineChart.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.contrastColorCnt = startContrastColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)lineChart, (byte)16, lineChart.getMarkerStyle().getTransparency());
        }
        if (!gradientColor && !gotShapeFillColor && (crd.isAvailable(69) || lineChart.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            if (startFillColorIndex >= 0) {
                graph.style.fillColorCnt = startFillColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)lineChart, (byte)24, lineChart.getMarkerStyle().getTransparency());
        }
        if (!gotShape && (crd.isAvailable(8) || lineChart.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, lineChart, (byte)6);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        int[] types = new int[3];
        String str = elem.getAttribute("response");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        String yVarID = StatGraph.getVarID(str);
        if (model == null) {
            str = elem.getAttribute("orient");
            if (str.equalsIgnoreCase("Horizontal")) {
                types[0] = 0;
                types[1] = 2;
            } else {
                types[0] = 2;
                types[1] = 0;
            }
            types[2] = 0;
            return types;
        }
        if (yVarID.length() > 0) {
            int ycol = model.getColumn(yVarID);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol);
            if (cmd.getType() == 2) {
                return null;
            }
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        } else {
            type = 0;
        }
        str = elem.getAttribute("category");
        String xVarID = StatGraph.getVarID(str);
        if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
            return null;
        }
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            types[0] = type;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }

    private static boolean transposeData(StatGraph graph, Element elem) {
        int i;
        Object[] newx;
        Object[] oldx;
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null) {
            return true;
        }
        elem.removeAttribute("index");
        String str = elem.getAttribute("category");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
        DataModel old_dm = graph.getData(dataName);
        dataName = dataName + "_MULTI_RESPONSES";
        DataModel dm = new DataModel();
        dm.name = dataName;
        graph.addData(dm);
        int oldOBS = old_dm.getRowCount();
        int newOBS = oldOBS * multiResponseVars.length;
        int oldXCol = old_dm.getColumn(xVarID);
        ColumnMetadata cmd = (ColumnMetadata)old_dm.getColumnLabel(oldXCol);
        String fmtName = cmd.getFormat() == null ? null : cmd.getFormat().getName();
        byte type = cmd.getType();
        if (type == 1) {
            oldx = old_dm.getDoubleColumn(oldXCol);
            newx = new double[newOBS];
            for (i = 0; i < newOBS; ++i) {
                newx[i] = oldx[i % oldOBS];
            }
            dm.addDoubleColumn("CATEGORY", cmd.getLabel(), fmtName, cmd.getMin(), cmd.getMax(), cmd.getMissings() * multiResponseVars.length, (double[])newx);
        } else {
            oldx = old_dm.getStringColumn(oldXCol);
            newx = new String[newOBS];
            for (i = 0; i < newOBS; ++i) {
                newx[i] = oldx[i % oldOBS];
            }
            dm.addStringColumn("CATEGORY", cmd.getLabel(), fmtName, cmd.getLength(), cmd.getMissings() * multiResponseVars.length, (String[])newx);
        }
        double[] newy = new double[newOBS];
        String[] groups = new String[newOBS];
        double min = Double.MAX_VALUE;
        double max = -min;
        int nmiss = 0;
        String label = null;
        int glen = 0;
        int rcnt = 0;
        for (int i2 = 0; i2 < multiResponseVars.length; ++i2) {
            String rVarID = StatGraph.getVarID(multiResponseVars[i2]);
            int rcol = old_dm.getColumn(rVarID);
            cmd = (ColumnMetadata)old_dm.getColumnLabel(rcol);
            if (cmd.getType() == 2) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "dt.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"RESPONSE", (Object)cmd.getName()));
                continue;
            }
            ++rcnt;
            double[] oldx2 = old_dm.getDoubleColumn(rcol);
            if (i2 == 0) {
                fmtName = cmd.getFormat() == null ? null : cmd.getFormat().getName();
                label = cmd.getLabel();
            } else {
                label = label + ", " + cmd.getLabel();
            }
            min = Math.min(min, cmd.getMin());
            max = Math.max(max, cmd.getMax());
            nmiss += cmd.getMissings();
            glen = Math.max(glen, cmd.getLabel().length());
            for (int j = 0; j < oldOBS; ++j) {
                newy[i2 * oldOBS + j] = oldx2[j];
                groups[i2 * oldOBS + j] = cmd.getLabel();
            }
        }
        if (rcnt == 0) {
            return false;
        }
        dm.addDoubleColumn("RESPONSE", label, fmtName, min, max, nmiss, newy);
        dm.addStringColumn("GROUP", "GROUP", null, glen, 0, groups);
        String newXName = dataName + "#CATEGORY";
        String newYName = dataName + "#RESPONSE";
        String newGName = dataName + "#GROUP";
        elem.setAttribute("category", newXName);
        elem.setAttribute("response", newYName);
        elem.setAttribute("group", newGName);
        elem.removeChild(rElem);
        return true;
    }
}

