/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Font;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class LegendParser
extends GraphComponentParser {
    public static final String RB_KEY = "LegendParser.";

    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container) {
        boolean ok = GraphComponentParser.load(graph, element, component, container);
        if (element.getTagName().equalsIgnoreCase("DiscreteLegend") || element.getTagName().equalsIgnoreCase("MergedLegend") || element.getTagName().equalsIgnoreCase("AutoLegend")) {
            MarkerAttrs attrs;
            Element elElem;
            Element gnElem;
            boolean merged = element.getTagName().equalsIgnoreCase("MergedLegend");
            boolean auto = element.getTagName().equalsIgnoreCase("AutoLegend");
            Legend legend = (Legend)component;
            legend.setQCGlobalLegend(graph.isQCGlobalLegend());
            int type = 0;
            String s = element.getAttribute("type");
            if (s.length() > 0) {
                if (s.equalsIgnoreCase("MarkerSymbol")) {
                    type = 1;
                } else if (s.equalsIgnoreCase("MarkerColor")) {
                    type = 3;
                } else if (s.equalsIgnoreCase("LineColor")) {
                    type = 4;
                } else if (s.equalsIgnoreCase("LinePattern")) {
                    type = 5;
                } else if (s.equalsIgnoreCase("FillColor")) {
                    type = 7;
                } else if (s.equalsIgnoreCase("FillPattern")) {
                    type = 8;
                } else if (s.equalsIgnoreCase("MARKER")) {
                    type = 9;
                } else if (s.equalsIgnoreCase("LINE")) {
                    type = 10;
                } else if (s.equalsIgnoreCase("FILL")) {
                    type = 11;
                } else if (s.equalsIgnoreCase("TEXT")) {
                    type = 16;
                } else if (s.equalsIgnoreCase("ALL")) {
                    type = 0;
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "type.fmt.txt"));
                    StatGraph.printWarning(msg.toString((Object)s));
                    return false;
                }
                legend.setType(type);
            }
            if (type == 16) {
                legend.setSortBySymbolText(element.getAttribute("sortBy").equalsIgnoreCase("TEXT"));
            }
            if (!(element.hasAttribute("backgroundColor") || element.getAttribute("location").equalsIgnoreCase("INSIDE") && legend.getParent() instanceof BaseOverlayContainer)) {
                FillAttrs fillStyle = new FillAttrs();
                GraphStyle.setDefaultFillStyle(graph, "", fillStyle, "LegendFill");
                legend.setBackground(fillStyle.getColor());
            }
            if ((gnElem = StatGraph.getOptionAttrsElement(element, "GraphNames")) != null) {
                String[] aNames;
                Element anElem;
                String[] gNames;
                String[] names = gNames = StatGraph.parseStringValueList(gnElem, "Value");
                if (merged && (anElem = StatGraph.getOptionAttrsElement(element, "AdditionalNames")) != null && (aNames = StatGraph.parseStringValueList(anElem, "Value")) != null && aNames.length > 0) {
                    names = new String[gNames.length + aNames.length];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = i < gNames.length ? gNames[i] : aNames[i - gNames.length];
                    }
                }
                legend.setGraphNames(names);
                graph.addGraphReference(legend, names);
            }
            if ((elElem = StatGraph.getOptionAttrsElement(element, "ExcludeList")) != null) {
                String[] values = StatGraph.parseStringValueList(elElem, "Value", true);
                legend.setExcludedValues(values);
            }
            if ((s = element.getAttribute("sortOrder")).length() > 0) {
                if (s.equalsIgnoreCase("AUTO")) {
                    legend.setSortOrder(0);
                } else if (s.equalsIgnoreCase("REVERSEAUTO")) {
                    legend.setSortOrder(3);
                } else if (s.equalsIgnoreCase("ASCENDINGFORMATTED")) {
                    legend.setSortOrder(1);
                } else if (s.equalsIgnoreCase("DESCENDINGFORMATTED")) {
                    legend.setSortOrder(2);
                }
            }
            if ((s = element.getAttribute("title")).length() > 0) {
                legend.setTitle(s);
            }
            s = element.getAttribute("titleBorder");
            legend.setTitleBorder(s.equalsIgnoreCase("true"));
            s = element.getAttribute("titleHAlign");
            if (s.length() > 0) {
                if (s.equalsIgnoreCase("left")) {
                    legend.setTitleAligment(0.0f);
                } else if (s.equalsIgnoreCase("right")) {
                    legend.setTitleAligment(1.0f);
                }
            }
            s = element.getAttribute("displayClipped");
            legend.setClippingAllowed(s.equalsIgnoreCase("true"));
            legend.setOutlineFilledChicklet(!element.getAttribute("fillItemOutline").equalsIgnoreCase("AUTO"));
            legend.setScaleSymbolWithFont(element.getAttribute("autoItemSize").equalsIgnoreCase("TRUE"));
            Element sizeElem = StatGraph.getOptionAttrsElement(element, "ItemSize");
            if (sizeElem != null) {
                s = sizeElem.getAttribute("lineLength");
                if (s.length() > 0 && StatGraph.isNumber(s)) {
                    legend.setItemLineLength((int)Double.parseDouble(s));
                }
                if (!legend.isScaleSymbolWithFont()) {
                    s = sizeElem.getAttribute("fillHeight");
                    if (s.length() > 0) {
                        double size = Double.NaN;
                        if (s.indexOf(":") >= 0) {
                            String en = GraphStyle.parseStyleElementName(s);
                            String an = GraphStyle.parseStyleAttributeName(s);
                            en = graph.style.getGraphStyle().remapDataElement(en, an);
                            if (en != null && an != null) {
                                size = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                            }
                        } else if (!s.equalsIgnoreCase("AUTO")) {
                            if (s.equalsIgnoreCase("BIG")) {
                                String fs = null;
                                Element valueAttrsElem = StatGraph.getOptionAttrsElement(element, "ValueAttrs");
                                if (valueAttrsElem != null && valueAttrsElem.hasAttribute("size")) {
                                    fs = valueAttrsElem.getAttribute("size");
                                }
                                if (fs == null && element.hasAttribute("valueAttrs")) {
                                    fs = graph.style.getStyleAttribute("ValueText", "fontSize");
                                }
                                if (fs == null) {
                                    fs = graph.style.getStyleAttribute("ValueText", "fontSize");
                                }
                                if (fs != null && !fs.endsWith("pt")) {
                                    fs = fs + "pt";
                                }
                                if (fs != null) {
                                    size = Legend.DEFAULT_CHICKLET_FONT_MULTIPLIER * (double)graph.unit2MarkerSize(fs);
                                }
                            } else {
                                size = graph.unit2MarkerSize(s);
                            }
                        }
                        if (size > 0.0) {
                            legend.setCustomChickletHeight(size);
                        } else if (size == size) {
                            StatGraph.printOptionError("FILLHEIGHT", s);
                        }
                    }
                    if ((s = sizeElem.getAttribute("heightScale")).length() > 0 && StatGraph.isNumber(s)) {
                        legend.setCustomHeightScale(Double.parseDouble(s));
                    }
                    if ((s = sizeElem.getAttribute("fillAspectRatio")).length() > 0) {
                        if (StatGraph.isNumber(s)) {
                            legend.setCustomChickletAspect(Double.parseDouble(s));
                        } else if (s.equalsIgnoreCase("GOLDEN")) {
                            legend.setCustomChickletAspect(Legend.GOLDEN_RATIO);
                        } else if (!s.equalsIgnoreCase("AUTO")) {
                            StatGraph.printOptionError("FILLASPECTRATIO", s);
                        }
                    }
                }
            }
            LegendParser.addLegendSpacer(element);
            StatGraph.parseBorderOpts(graph, component, element, null);
            legend.setTextAntiAliased(graph.axisAntialiased);
            legend.setDataAntiAliased(graph.dataAntialiased);
            TextStyle valueAttrs = new TextStyle();
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("valueAttrs"), valueAttrs, "ValueText");
            TextStyle titleAttrs = new TextStyle();
            if (StatGraph.isOLAP()) {
                GraphStyle.setDefaultTextStyle(graph, element.getAttribute("titleAttrs"), titleAttrs, "Label2Text");
            } else {
                GraphStyle.setDefaultTextStyle(graph, element.getAttribute("titleAttrs"), titleAttrs, "LabelText");
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                SGAnnotationContainer ac;
                AbstractAnno text;
                if (!(children.item(i) instanceof Element)) continue;
                Element child = (Element)children.item(i);
                if (child.getTagName().equalsIgnoreCase("ValueAttrs")) {
                    StatGraph.parseTextAttrs(graph, child, valueAttrs);
                    continue;
                }
                if (child.getTagName().equalsIgnoreCase("TitleAttrs")) {
                    StatGraph.parseTextAttrs(graph, child, titleAttrs);
                    continue;
                }
                if (!child.getTagName().startsWith("Draw") || (text = AnnotateParser.load(graph, child, (AnnotationContainer)(ac = new SGAnnotationContainer(legend, graph.rootPanel)))) == null) continue;
                if ("back".equalsIgnoreCase(child.getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
            }
            if (StatGraph.dataSizeScaleFactor < 1.0) {
                double scale = Math.pow(StatGraph.dataSizeScaleFactor, 4.0);
                scale = Math.pow(scale, 0.08333333333333333);
                Font fn = titleAttrs.getFont();
                fn = StatGraph.useFontManager ? FontManager.getFont((String)fn.getFamily(), (int)fn.getStyle(), (int)((int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()))) : new Font(fn.getFamily(), fn.getStyle(), (int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()));
                legend.setTitleFont(fn);
                fn = valueAttrs.getFont();
                fn = StatGraph.useFontManager ? FontManager.getFont((String)fn.getFamily(), (int)fn.getStyle(), (int)((int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()))) : new Font(fn.getFamily(), fn.getStyle(), (int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()));
                legend.setFont(fn);
            } else {
                legend.setTitleFont(titleAttrs.getFont());
                legend.setFont(valueAttrs.getFont());
            }
            legend.setTitleColor(titleAttrs.getColor());
            legend.setValueColor(valueAttrs.getColor());
            if (legend.getLineBorderColor() != null) {
                legend.setForeground(legend.getLineBorderColor());
            }
            if ((s = element.getAttribute("order")).equalsIgnoreCase("columnMajor")) {
                legend.setOrder(1);
            } else if (s.equalsIgnoreCase("rowMajor")) {
                legend.setOrder(0);
            } else {
                legend.setOrder(0);
                if (s.length() > 0) {
                    StatGraph.printOptionError("ORDER", s);
                }
            }
            s = element.getAttribute("across");
            if (!s.equals("")) {
                legend.setAcross(Integer.parseInt(s));
            }
            if (!(s = element.getAttribute("down")).equals("")) {
                legend.setDown(Integer.parseInt(s));
            }
            if ((s = element.getAttribute("merge")).equalsIgnoreCase("true")) {
                legend.setOverlay(true);
            }
            if (merged) {
                legend.setMergedLegend(true);
            } else if (auto) {
                legend.setAutoLegend(true);
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 9: {
                    attrs = new MarkerAttrs();
                    GraphStyle.setDefaultMarkerStyle(graph, null, attrs, "GraphDataStyleDefault");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    attrs = new LineAttrs();
                    GraphStyle.setDefaultLineStyle(graph, null, (LineAttrs)attrs, "GraphDataStyleDefault");
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    attrs = new FillAttrs();
                    GraphStyle.setDefaultFillStyle(graph, null, (FillAttrs)attrs, "GraphDataStyleDefault");
                    break;
                }
                default: {
                    attrs = null;
                }
            }
            legend.setDefaultAttrs((ColorAttr)attrs);
            LineAttrs lineattr = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, null, lineattr, "Outlines");
            legend.setDefaultOutlineAttrs(lineattr);
        } else {
            String s;
            LegendComponent legend = (LegendComponent)component;
            legend.setAntiAliased(graph.axisAntialiased);
            Element gnElem = StatGraph.getOptionAttrsElement(element, "GraphNames");
            if (gnElem != null) {
                String[] names = StatGraph.parseStringValueList(gnElem, "Value");
                graph.addGraphReference(legend, names);
            }
            if ((s = element.getAttribute("title")).length() > 0) {
                String type = element.getAttribute("title_type");
                if (type.length() > 0) {
                    if (type.equalsIgnoreCase("KEYWORD")) {
                        if (s.equalsIgnoreCase("AUTO")) {
                            legend.getLegend().setAutoTitle(true);
                        }
                    } else {
                        legend.setTitle(s);
                    }
                } else {
                    legend.setTitle(s);
                }
            }
            StatGraph.parseBorderOpts(graph, component, element, null);
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("valueAttrs"), legend.getValueStyle(), "ValueText");
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("titleAttrs"), legend.getTitleStyle(), "LabelText");
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, null, ls, "AxisLines");
            TickMarkStyle tms = legend.getTickStyle();
            tms.setColor(ls.getColor());
            tms.setLineWidth(ls.getWidth());
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof Element)) continue;
                Element child = (Element)children.item(i);
                if (child.getTagName().equalsIgnoreCase("ValueAttrs")) {
                    StatGraph.parseTextAttrs(graph, child, legend.getValueStyle());
                    continue;
                }
                if (!child.getTagName().equalsIgnoreCase("TitleAttrs")) continue;
                StatGraph.parseTextAttrs(graph, child, legend.getTitleStyle());
            }
            s = element.getAttribute("valueCount");
            if (!s.equals("")) {
                legend.setLabelCount(Integer.parseInt(s));
            }
            if (!(s = element.getAttribute("valueCountHint")).equals("")) {
                legend.setLabelCountHint(Integer.parseInt(s));
            }
            if ((s = element.getAttribute("valueFormat")).length() > 0) {
                legend.setValueFormat(SASFormat.getInstance((String)s));
            }
            if ((s = element.getAttribute("displayMissing")).length() > 0) {
                if ("ON".equalsIgnoreCase(s)) {
                    legend.setDisplayMissing(1);
                } else if ("AUTO".equalsIgnoreCase(s)) {
                    legend.setDisplayMissing(2);
                } else {
                    legend.setDisplayMissing(0);
                }
            }
            if ((s = element.getAttribute("extractScale")).length() > 0 && s.equalsIgnoreCase("true")) {
                legend.setExactScale(true);
            }
            if ((s = element.getAttribute("extractScaleType")).equalsIgnoreCase("scientific")) {
                legend.setScientificScale(true);
            }
            s = element.getAttribute("integer");
            legend.setInteger(s.equalsIgnoreCase("true"));
            LineAttrs la = new LineAttrs();
            GraphStyle cfr_ignored_0 = graph.style;
            GraphStyle.setDefaultLineStyle(graph, "", la, "AxisLines");
            legend.getLegend().setBorderLineColor(la.getColor());
        }
        return ok;
    }

    public static void addLegendSpacer(Element legendElem) {
        String spacerSide;
        String str = legendElem.getAttribute("outerPad");
        if (str.equalsIgnoreCase("AUTO")) {
            legendElem.removeAttribute("outerPad");
            str = "";
        }
        if (str.length() > 0) {
            return;
        }
        Element parent = (Element)legendElem.getParentNode();
        String parentName = parent.getNodeName();
        if (parentName.startsWith("LayoutOverlay") || parentName.equals("LayoutQCOverlay") || parentName.equals("LayoutRegion")) {
            str = legendElem.getAttribute("location");
            if (str.equalsIgnoreCase("INSIDE")) {
                return;
            }
            String va = legendElem.getAttribute("vAlign");
            String ha = legendElem.getAttribute("hAlign");
            spacerSide = va.equalsIgnoreCase("bottom") ? "top" : (va.equalsIgnoreCase("top") ? "bottom" : (ha.equalsIgnoreCase("right") ? "left" : (ha.equalsIgnoreCase("left") ? "right" : "top")));
        } else if (parentName.equals("SideBar")) {
            str = parent.getAttribute("align");
            spacerSide = str.equalsIgnoreCase("top") ? "bottom" : (str.equalsIgnoreCase("right") ? "left" : (str.equalsIgnoreCase("left") ? "right" : "top"));
        } else {
            return;
        }
        Element outerPadElem = StatGraph.getOptionAttrsElement(legendElem, "OuterPadAttrs");
        if (outerPadElem == null) {
            Document doc = legendElem.getOwnerDocument();
            outerPadElem = doc.createElement("OuterPadAttrs");
            legendElem.appendChild(outerPadElem);
        }
        if (!outerPadElem.hasAttribute(spacerSide)) {
            outerPadElem.setAttribute(spacerSide, "10");
        }
    }
}

