/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.AxisLegendParser;
import com.sas.graphics.applets.statgraph.AxisTableParser;
import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.BarParser;
import com.sas.graphics.applets.statgraph.BlockParser;
import com.sas.graphics.applets.statgraph.BoxParser;
import com.sas.graphics.applets.statgraph.BubbleParser;
import com.sas.graphics.applets.statgraph.ContourParser;
import com.sas.graphics.applets.statgraph.DendrogramParser;
import com.sas.graphics.applets.statgraph.DropLineParser;
import com.sas.graphics.applets.statgraph.EllipseParmParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.FringeParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.HeatBoxParser;
import com.sas.graphics.applets.statgraph.HeatMapParmParser;
import com.sas.graphics.applets.statgraph.HighLowParser;
import com.sas.graphics.applets.statgraph.HistoParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapTempParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.LineChartParser;
import com.sas.graphics.applets.statgraph.LineParmParser;
import com.sas.graphics.applets.statgraph.NeedleParser;
import com.sas.graphics.applets.statgraph.ParetoLineParser;
import com.sas.graphics.applets.statgraph.PieParser;
import com.sas.graphics.applets.statgraph.PolygonParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.RangeAttrMapViewParser;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.RotatedJTextPane;
import com.sas.graphics.applets.statgraph.ScatterMatrixParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.SeriesParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StepParser;
import com.sas.graphics.applets.statgraph.SurfaceParser;
import com.sas.graphics.applets.statgraph.TableParser;
import com.sas.graphics.applets.statgraph.TextPlotParser;
import com.sas.graphics.applets.statgraph.TimeSeriesParser;
import com.sas.graphics.applets.statgraph.VectorParser;
import com.sas.graphics.applets.statgraph.WaterFallChartParser;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.TickInterval;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayInnerMargin;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverviewAxisComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HeatBoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PieOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.TimeSeriesOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayoutOverlayParser {
    public static final String RB_KEY = "LayoutOverlayParser.";
    static final int LINEAR_AXIS = 0;
    static final int TIME_AXIS = 1;
    static final int DISCRETE_AXIS = 2;
    static final int LOG_AXIS = 3;
    static int xAxisType = 0;
    static int x2AxisType = 0;
    static int yAxisType = 0;
    static int y2AxisType = 0;
    static int zAxisType = 0;
    static double logBaseX = 10.0;
    static double logBaseX2 = 10.0;
    static double logBaseY = 10.0;
    static double logBaseY2 = 10.0;

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        return LayoutOverlayParser.load(graph, elem, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        return LayoutOverlayParser.load(graph, elem, false, rowColumnAxesType, rowColumn2AxesType);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost) {
        return LayoutOverlayParser.load(graph, elem, outmost, null, null);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        Element elem2;
        if (!LayoutOverlayParser.hasGraphElement(elem)) {
            return LayoutOverlayParser.loadNonGraphs(graph, elem);
        }
        graph.style.resetCounters();
        String str = elem.getAttribute("cycleAttrs");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlayParser.initComposite(graph, elem);
        }
        LayoutOverlayParser.parseUserViewportParams(graph, elem, oc);
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        if (!elem.getAttribute("opaque").equalsIgnoreCase("true")) {
            oc.getBaseComponent().setTransparentBackground(graph.isTransparentBackground());
        }
        Simple2DOverlayComposite soc = oc.getComposite();
        if (!elem.getNodeName().equals("LayoutPrototype") && !elem.getNodeName().equals("LayoutPrototypeOverlay2D")) {
            str = elem.getAttribute("aspectRatio");
            if (StatGraph.isNumber(str)) {
                soc.setAspectRatio(Double.parseDouble(str));
            } else {
                soc.setAspectRatio(-1.0);
            }
        }
        double leftAxisPercent = 0.25;
        str = elem.getAttribute("leftAxisWidthMax");
        if (StatGraph.isNumber(str)) {
            leftAxisPercent = Double.parseDouble(str);
        }
        double rightAxisPercent = 0.25;
        str = elem.getAttribute("rightAxisWidthMax");
        if (StatGraph.isNumber(str)) {
            rightAxisPercent = Double.parseDouble(str);
        }
        if (leftAxisPercent < 0.0) {
            leftAxisPercent = 0.25;
        }
        if (rightAxisPercent < 0.0) {
            rightAxisPercent = 0.25;
        }
        if (leftAxisPercent + rightAxisPercent > 1.0) {
            leftAxisPercent = 0.25;
            rightAxisPercent = 0.25;
        } else {
            soc.setYAxisMaxWidthPercentage(leftAxisPercent);
            soc.setY2AxisMaxWidthPercentage(rightAxisPercent);
        }
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        LayoutOverlayParser.initAxis(graph, xAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, x2Axis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, yAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, y2Axis, graph.axisLineOffsetCoverage);
        xAxisType = 0;
        x2AxisType = 0;
        yAxisType = 0;
        y2AxisType = 0;
        zAxisType = 0;
        LayoutOverlayParser.decideAxesType(graph, elem, rowColumnAxesType, rowColumn2AxesType);
        ArrayList plots = new ArrayList();
        BoxOverlay boxOverlay = null;
        HeatBoxOverlay heatboxOverlay = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            if (elemTag.equals("ScatterPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, ScatterParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("TextPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, TextPlotParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("SeriesPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = LayoutOverlayParser.addPlotToList(plots, SeriesParser.load(graph, (Element)node, curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("StepPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = LayoutOverlayParser.addPlotToList(plots, StepParser.load(graph, (Element)node, curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("NeedlePlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, NeedleParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("VectorPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, VectorParser.load(graph, (Element)node));
            } else if (elemTag.equals("BandPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = LayoutOverlayParser.addPlotToList(plots, BandParser.load(graph, (Element)node, curveLabelPosition));
            } else if (elemTag.equals("BoxPlotParm") || elemTag.equals("BoxParm")) {
                Overlay[] blocks;
                boxOverlay = BoxParser.load(graph, (Element)node);
                ok = LayoutOverlayParser.addPlotToList(plots, boxOverlay, graph, !outmost);
                if (ok && (blocks = boxOverlay.getBlockOverlays()) != null) {
                    OverlayInnerMargin oim;
                    for (int i = 0; i < blocks.length; ++i) {
                        LayoutOverlayParser.addPlotToList(plots, blocks[i]);
                    }
                    if (boxOverlay.getOrientation() == 1) {
                        oim = new OverlayInnerMargin(3);
                        TextAttrs textStyle = new TextAttrs();
                        GraphStyle.setDefaultTextStyle(graph, "", textStyle, "DataText");
                        FontMetrics fm = StatGraph.getFontMetrics(textStyle.getFont());
                        int gap = (int)((double)fm.getHeight() * 0.25);
                        oim.setGutter(gap);
                        oim.setPad(-1, -1, -1, gap);
                    } else {
                        oim = new OverlayInnerMargin(2);
                    }
                    for (int i = 0; i < blocks.length; ++i) {
                        oim.addOverlay(blocks[i]);
                    }
                    soc.addOverlayInnerMargin(oim);
                }
            } else if (elemTag.equals("HistogramParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, HistoParser.load(graph, (Element)node));
            } else if (elemTag.equals("LineParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, LineParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("ReferenceLine")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = LayoutOverlayParser.addPlotToList(plots, ReferenceLineParser.load(graph, (Element)node, curveLabelPosition));
            } else if (elemTag.equals("DropLine")) {
                ok = LayoutOverlayParser.addPlotToList(plots, DropLineParser.load(graph, (Element)node));
            } else if (elemTag.equals("EllipseParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, EllipseParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("ContourPlotParm") || elemTag.equals("ContourParm")) {
                boolean[] log = new boolean[]{xAxisType == 3, x2AxisType == 3, yAxisType == 3, y2AxisType == 3};
                double[] base = new double[]{logBaseX, logBaseX2, logBaseY, logBaseY2};
                ok = LayoutOverlayParser.addPlotToList(plots, ContourParser.load(graph, (Element)node, log, base));
            } else if (elemTag.equals("BarChartParm") || elemTag.equals("BarParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, BarParser.load(graph, (Element)node));
            } else if (elemTag.equals("ParetoLine")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = LayoutOverlayParser.addPlotToList(plots, ParetoLineParser.load(graph, (Element)node, curveLabelPosition));
            } else if (elemTag.equals("PieChartParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, PieParser.load(graph, (Element)node));
            } else if (elemTag.equals("FringePlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, FringeParser.load(graph, (Element)node));
            } else if (elemTag.equals("BlockPlot")) {
                BlockOverlay block = BlockParser.load(graph, (Element)node);
                if (block != null) {
                    String s = ((Element)node).getAttribute("display");
                    if (s.length() == 0 || s.equalsIgnoreCase("STANDARD")) {
                        block.setValueOn(false);
                        block.setLabelOn(false);
                    }
                    ok = LayoutOverlayParser.addPlotToList(plots, block);
                } else {
                    ok = false;
                }
            } else if (elemTag.equals("AxisTable")) {
                AxisTable axisTable = AxisTableParser.load(graph, (Element)node);
                ok = LayoutOverlayParser.addPlotToList(plots, axisTable);
            } else if (elemTag.equals("WaterfallChart")) {
                ok = LayoutOverlayParser.addPlotToList(plots, WaterFallChartParser.load(graph, (Element)node));
            } else if (elemTag.equals("Dendrogram")) {
                ok = LayoutOverlayParser.addPlotToList(plots, DendrogramParser.load(graph, (Element)node));
            } else if (elemTag.equals("BubblePlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, BubbleParser.load(graph, (Element)node));
            } else if (elemTag.equals("HeatmapParm")) {
                ok = LayoutOverlayParser.addPlotToList(plots, HeatMapParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("HighLowPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, HighLowParser.load(graph, (Element)node));
            } else if (elemTag.equals("HeatBoxParm")) {
                Overlay[] imOverlays;
                heatboxOverlay = HeatBoxParser.load(graph, (Element)node);
                ok = LayoutOverlayParser.addPlotToList(plots, heatboxOverlay, graph, !outmost);
                if (ok && (imOverlays = heatboxOverlay.getInnerMarginOverlays()) != null) {
                    for (int i = 0; i < imOverlays.length; ++i) {
                        LayoutOverlayParser.addPlotToList(plots, imOverlays[i]);
                    }
                    OverlayInnerMargin oim = new OverlayInnerMargin(2);
                    for (int i = 0; i < imOverlays.length; ++i) {
                        oim.addOverlay(imOverlays[i]);
                    }
                    soc.addOverlayInnerMargin(oim);
                }
            } else if (elemTag.equals("LineChart")) {
                ok = LayoutOverlayParser.addPlotToList(plots, LineChartParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("TimeSeriesPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, TimeSeriesParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("RangeAttrMapView")) {
                ok = LayoutOverlayParser.addPlotToList(plots, RangeAttrMapViewParser.load(graph, (Element)node), graph, !outmost);
            }
            if (elemTag.equals("PolygonPlot")) {
                ok = LayoutOverlayParser.addPlotToList(plots, PolygonParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("InnerMargin")) {
                String loc = ((Element)node).getAttribute("align");
                int just = 2;
                if (loc.length() > 0 && loc.equalsIgnoreCase("top")) {
                    just = 1;
                } else if (loc.length() > 0 && loc.equalsIgnoreCase("left")) {
                    just = 3;
                } else if (loc.length() > 0 && loc.equalsIgnoreCase("right")) {
                    just = 4;
                }
                OverlayInnerMargin oim = new OverlayInnerMargin(just);
                String str2 = ((Element)node).getAttribute("opaque");
                if (str2.length() > 0 && str2.equalsIgnoreCase("true")) {
                    Color c;
                    oim.setOpaque(true);
                    if (((Element)node).hasAttribute("backgroundColor") && (c = StatGraph.parseAttrColor("backgroundColor", graph, (Element)node)) != null) {
                        oim.setBackground(c);
                    }
                }
                if ((str2 = ((Element)node).getAttribute("separator")).length() > 0 && str2.equalsIgnoreCase("true")) {
                    oim.setSeparatorOn(true);
                    GraphStyle.setDefaultLineStyle(graph, ((Element)node).getAttribute("separatorAttrs"), oim.getSeparatorAttrs(), "AxisLines");
                }
                if ((str2 = ((Element)node).getAttribute("gutter")).length() > 0 && StatGraph.isLineThickness(str2)) {
                    oim.setGutter(graph.unit2GapThickness(str2));
                }
                if ((str2 = ((Element)node).getAttribute("pad")).length() > 0 && StatGraph.isLineThickness(str2)) {
                    int pad = graph.unit2GapThickness(str2);
                    oim.setPad(pad, pad, pad, pad);
                } else {
                    Element padAttrs = StatGraph.getOptionAttrsElement((Element)node, "PadAttrs");
                    if (padAttrs != null) {
                        int top = -1;
                        int left = -1;
                        int bottom = -1;
                        int right = -1;
                        str = padAttrs.getAttribute("top");
                        if (StatGraph.isLineThickness(str)) {
                            top = graph.unit2GapThickness(str);
                        }
                        if (StatGraph.isLineThickness(str = padAttrs.getAttribute("left"))) {
                            left = graph.unit2GapThickness(str);
                        }
                        if (StatGraph.isLineThickness(str = padAttrs.getAttribute("bottom"))) {
                            bottom = graph.unit2GapThickness(str);
                        }
                        if (StatGraph.isLineThickness(str = padAttrs.getAttribute("right"))) {
                            right = graph.unit2GapThickness(str);
                        }
                        oim.setPad(top, left, bottom, right);
                    }
                }
                Element elem22 = (Element)node;
                for (Node node2 = elem22.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element)) continue;
                    elemTag = ((Element)node2).getTagName();
                    if (elemTag.equals("BlockPlot") && (just == 1 || just == 2)) {
                        BlockOverlay block = BlockParser.load(graph, (Element)node2);
                        ok = LayoutOverlayParser.addPlotToList(plots, block);
                        if (!ok) continue;
                        block.setOverlayJustification(just);
                        block.setValueVAlign(1);
                        oim.addOverlay(block);
                        continue;
                    }
                    if (elemTag.equals("AxisTable")) {
                        AxisTable axisTable = AxisTableParser.load(graph, (Element)node2, just);
                        ok = LayoutOverlayParser.addPlotToList(plots, axisTable);
                        if (!ok) continue;
                        axisTable.setOverlayJustification(just);
                        oim.addOverlay(axisTable);
                        continue;
                    }
                    if (elemTag.equals("SeparatorAttrs")) {
                        if (!oim.isSeparatorOn()) continue;
                        StatGraph.parseLineAttrs(graph, (Element)node2, oim.getSeparatorAttrs());
                        continue;
                    }
                    if (elemTag.equals("PadAttrs")) continue;
                    StatGraph.printDebug("Unsupported plot for inner margin.");
                }
                if (oim.getOverlays().size() > 0) {
                    soc.addOverlayInnerMargin(oim);
                }
            } else if (elemTag.equals("Entry")) {
                JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                if (entry == null) {
                    entry = new EntryComposite();
                }
                EntryConcatParser.load(graph, (Element)node, entry, oc, 0);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                        entry.setAlignmentY(0.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, entry);
                    oc.addSidebar(entry);
                } else {
                    oc.add((Component)entry, 0);
                }
            } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                Legend legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("AxisLegend")) {
                AxisLegend legend = (AxisLegend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new AxisLegend();
                }
                AxisLegendParser.load(graph, (Element)node, legend, oc);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("ContinuousLegend")) {
                LegendComponent legend = (LegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new LegendComponent();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentX(1.0f);
                    }
                    if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                        legend.setHorizontal(true);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("GTable")) {
                Table table = (Table)graph.getObjectFromElement((Element)node);
                if (table == null) {
                    table = new Table();
                }
                TableParser.load(graph, (Element)node, table, oc);
                oc.add((Component)table, 0);
            } else if (elemTag.startsWith("Draw")) {
                AbstractAnno text = AnnotateParser.load(graph, (Element)node, oc);
                if ((elem.getTagName().equals("LayoutPrototype") || elem.getTagName().equals("LayoutPrototypeOverlay2D")) && text.isInDataSpace()) {
                    text.setClip(true);
                }
                if (text != null) {
                    if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                        graph.annotationInBackList.add(text);
                    } else {
                        graph.annotationInFrontList.add(text);
                    }
                }
            } else if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = (GridPanel)graph.getObjectFromElement((Element)node);
                if (grid == null) {
                    grid = new GridPanel();
                }
                GridPanelParser.load(graph, (Element)node, grid, oc);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (grid.getAlignmentX() == 0.5f && grid.getAlignmentY() == 0.5f) {
                        grid.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, grid);
                    oc.addSidebar(grid);
                } else {
                    oc.add((Component)grid, 0);
                }
            } else if (elemTag.equals("LayoutOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayEquated")) {
                boolean server = graph.server;
                graph.server = true;
                BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMapTemp")) {
                boolean server = graph.server;
                graph.server = true;
                BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayMapTempParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMap")) {
                boolean server = graph.server;
                graph.server = true;
                BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutQCOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                JComponent overlayContainer = StatGraph.parseThirdPartyComponent(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlay3D")) {
                boolean server = graph.server;
                graph.server = true;
                BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutLattice")) {
                oc.add((Component)LayoutLatticeParser.load(graph, (Element)node), 0);
            } else if (elemTag.equals("LayoutDataLattice")) {
                oc.add((Component)LayoutDataLatticeParser.load(graph, (Element)node), 0);
            } else if (elemTag.equals("LayoutDataPanel")) {
                oc.add((Component)LayoutDataLatticeParser.load(graph, (Element)node, true), 0);
            } else if (elemTag.equals("LayoutRegion")) {
                oc.add((Component)LayoutRegionParser.load(graph, (Element)node), 0);
            } else {
                graph.hasForeignObject = true;
            }
            if (ok || (str = ((Element)node).getAttribute("required")).length() <= 0 || !str.equalsIgnoreCase("true")) continue;
            oc.removeAll();
            Component msg = LayoutOverlayParser.createMessage();
            oc.add(msg);
            return oc;
        }
        if (plots.size() > 0) {
            LayoutOverlayParser.setAutomaticAxisTypes(plots, true, xAxis, x2Axis, yAxis, y2Axis, null);
        }
        LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, x2Axis, yAxis, y2Axis, null);
        LayoutOverlayParser.setAxisBreakType(graph, xAxis, soc);
        LayoutOverlayParser.setAxisBreakType(graph, x2Axis, soc);
        LayoutOverlayParser.setAxisBreakType(graph, yAxis, soc);
        LayoutOverlayParser.setAxisBreakType(graph, y2Axis, soc);
        LayoutOverlayParser.parsePointLabelOpts(graph, soc, elem);
        LayoutOverlayParser.setCategorySortByColumn(plots, xAxis, x2Axis, yAxis, y2Axis);
        for (int i = 0; i < plots.size(); ++i) {
            Overlay plot = (Overlay)plots.get(i);
            if (plot instanceof PieOverlay) {
                if (i == 0) {
                    PieOverlay pie = (PieOverlay)plot;
                    soc.getWall().setFillOn(false);
                    soc.getWall().setEdgeOn(false);
                    soc.setAxesVisible(false);
                    soc.addOverlay(pie);
                    break;
                }
                Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)plot.getStmt()));
                continue;
            }
            if (LayoutOverlayParser.isCompatibleOverlay(graph, plot)) {
                LayoutOverlayParser.addOverlay(plot, soc, xAxis, x2Axis, yAxis, y2Axis, null);
                if (graph.dataAntialiased && !plot.isDisableAA()) {
                    plot.setDisableAA(!graph.updateAAMax(plot.getRendererComplexity()));
                }
                if (!graph.imagemapEnabled || !plot.isTooltipEnabled()) continue;
                plot.setTooltipEnabled(graph.updateTipMax(plot.getNumOfTooltips()));
                continue;
            }
            graph.removeNamedGraph(plot);
        }
        if (xAxisType == 3) {
            LayoutOverlayParser.updateAxisOpts(graph, soc, elem, xAxis);
        }
        if (x2AxisType == 3) {
            LayoutOverlayParser.updateAxisOpts(graph, soc, elem, x2Axis);
        }
        if (yAxisType == 3) {
            LayoutOverlayParser.updateAxisOpts(graph, soc, elem, yAxis);
        }
        if (y2AxisType == 3) {
            LayoutOverlayParser.updateAxisOpts(graph, soc, elem, y2Axis);
        }
        if ((str = graph.style.getStyleAttribute("GridLines", "displayOpts")) != null && str.equalsIgnoreCase("on")) {
            if (!LayoutOverlayParser.hasAxisOpts(elem, "XAxisOpts", false, true)) {
                LayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
            }
            if (!LayoutOverlayParser.hasAxisOpts(elem, "X2AxisOpts", false, false)) {
                LayoutOverlayParser.addAutoGridLine(graph, x2Axis, soc);
            }
            if (!LayoutOverlayParser.hasAxisOpts(elem, "YAxisOpts", true, true)) {
                LayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
            }
            if (!LayoutOverlayParser.hasAxisOpts(elem, "Y2AxisOpts", true, false)) {
                LayoutOverlayParser.addAutoGridLine(graph, y2Axis, soc);
            }
        }
        if (boxOverlay != null && oc.getComposite().contains(boxOverlay) && !boxOverlay.getModel().isAvailable(10)) {
            if (boxOverlay.getOrientation() == 0) {
                if (boxOverlay.getXAxis().equalsIgnoreCase("X")) {
                    xAxis.setVisible(false);
                } else {
                    x2Axis.setVisible(false);
                }
            } else if (boxOverlay.getYAxis().equalsIgnoreCase("Y")) {
                yAxis.setVisible(false);
            } else {
                y2Axis.setVisible(false);
            }
        }
        VRectAxis[] axes = new VRectAxis[]{xAxis, x2Axis, yAxis, y2Axis};
        VRectAxis[] mirrorAxes = new VRectAxis[]{x2Axis, xAxis, y2Axis, yAxis};
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i].getInputDataRange() == null || mirrorAxes[i].getInputDataRange() != null) continue;
            String display2 = null;
            if (mirrorAxes[i] == x2Axis && LayoutOverlayParser.isAxisOptsApplicable(elem, "XAxisOpts", false, true)) {
                display2 = StatGraph.getOptionAttrsElement(elem, "XAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i] == xAxis && LayoutOverlayParser.isAxisOptsApplicable(elem, "X2AxisOpts", false, false)) {
                display2 = StatGraph.getOptionAttrsElement(elem, "X2AxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i] == y2Axis && LayoutOverlayParser.isAxisOptsApplicable(elem, "YAxisOpts", true, true)) {
                display2 = StatGraph.getOptionAttrsElement(elem, "YAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i] == yAxis && LayoutOverlayParser.isAxisOptsApplicable(elem, "Y2AxisOpts", true, false)) {
                display2 = StatGraph.getOptionAttrsElement(elem, "Y2AxisOpts").getAttribute("displaySecondary");
            }
            if (display2 == null || display2.length() == 0 || display2.equalsIgnoreCase("NONE") || !LayoutOverlayParser.honorAxisOpts(elem, axes[i], "displaySecondary")) {
                mirrorAxes[i].setVisible(false);
                continue;
            }
            mirrorAxes[i].setVisible(true);
            LayoutOverlayParser.copyAxisOptions(axes[i], mirrorAxes[i]);
            LayoutOverlayEquatedParser.parseAxisDisplay2Opts(display2, mirrorAxes[i]);
            LayoutOverlayParser.setAxisBreakType(graph, mirrorAxes[i], soc);
            VRectGridLines grid = soc.getGridLines(mirrorAxes[i]);
            if (grid != null) {
                soc.removeGridLines(grid);
            }
            mirrorAxes[i].setSecondary(true);
            mirrorAxes[i].setMirrorAxis(axes[i]);
        }
        ArrayList overlays = soc.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay o = (Overlay)overlays.get(i);
            if (o instanceof LineParmOverlay || o instanceof EllipseParmOverlay && o.getStmt().equalsIgnoreCase("EllipseParm")) {
                boolean axesMappedOk = true;
                if (o.getXAxis().equalsIgnoreCase("x") && !xAxis.isVisible()) {
                    axesMappedOk = false;
                } else if (o.getXAxis().equalsIgnoreCase("x2") && !x2Axis.isVisible()) {
                    axesMappedOk = false;
                }
                if (o.getYAxis().equalsIgnoreCase("y") && !yAxis.isVisible()) {
                    axesMappedOk = false;
                } else if (o.getYAxis().equalsIgnoreCase("y2") && !y2Axis.isVisible()) {
                    axesMappedOk = false;
                }
                if (!axesMappedOk) {
                    soc.removeOverlay(o);
                    if (!(o instanceof EllipseParmOverlay) && !(o instanceof LineParmOverlay)) continue;
                    Message msg = new Message(RB.getStringResource(RB_KEY, "parmaxis.fmt.txt"));
                    StatGraph.printWarning(msg.toString((Object)o.getStmt()));
                    continue;
                }
            }
            if (xAxis.isVisible() && xAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)xAxis, (byte)1);
            }
            if (x2Axis.isVisible() && x2Axis.isSecondary()) {
                soc.connect(o, (AbstractAxis)x2Axis, (byte)1);
            }
            if (yAxis.isVisible() && yAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)yAxis, (byte)2);
            }
            if (!y2Axis.isVisible() || !y2Axis.isSecondary()) continue;
            soc.connect(o, (AbstractAxis)y2Axis, (byte)2);
        }
        if (!(xAxis.isVisible() || x2Axis.isVisible() || yAxis.isVisible() || y2Axis.isVisible())) {
            soc.setAxesVisible(false);
        }
        if (xAxis.getName() != null && xAxis.isOverviewAxisOn() && (elem2 = graph.getOverviewAxisElement(xAxis.getName())) != null) {
            LayoutOverlayParser.parseOverviewAxis(graph, elem2, soc, xAxis, elem);
        }
        if (((Element)elem.getParentNode()).getTagName().equalsIgnoreCase("LayoutLattice")) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, xAxis, x2Axis, yAxis, y2Axis);
        } else if (xAxis.isVisible() && xAxis.getAxisStyle().isTitleOn() && xAxis.getTitleFitPolicy() == 1) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, null, null, yAxis, y2Axis);
        } else if (x2Axis.isVisible() && x2Axis.getAxisStyle().isTitleOn() && x2Axis.getTitleFitPolicy() == 1) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, null, null, yAxis, y2Axis);
        }
        LayoutOverlayParser.validateBrokenAxes(soc, xAxis, x2Axis, yAxis, y2Axis);
        return oc;
    }

    private static void updateAxisOpts(StatGraph graph, Simple2DOverlayComposite soc, Element elem, VRectAxis axis) {
        Node nd;
        NodeList linearOpts;
        VRectAxis masterAxis = null;
        NodeList axisOpts = null;
        Object[] axes = soc.getAxes();
        boolean logToLinear = false;
        for (int k = 0; k < axes.length; ++k) {
            VRectAxis a;
            if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != axis.getDimension() || a.getPrimary() != axis.getPrimary()) continue;
            if (a.getType() != 0) break;
            logToLinear = true;
            if (axis.getDimension() == 1) {
                masterAxis = new VRectAxis(1);
                if (axis.getPrimary()) {
                    axisOpts = elem.getElementsByTagName("XAxisOpts");
                    break;
                }
                axisOpts = elem.getElementsByTagName("X2AxisOpts");
                break;
            }
            if (axis.getDimension() != 2) break;
            masterAxis = new VRectAxis(2);
            if (axis.getPrimary()) {
                axisOpts = elem.getElementsByTagName("YAxisOpts");
                break;
            }
            axisOpts = elem.getElementsByTagName("Y2AxisOpts");
            break;
        }
        if (!logToLinear) {
            return;
        }
        if (masterAxis != null) {
            LayoutOverlayParser.resetAxisOpts(axis, masterAxis);
        }
        if (axisOpts != null && axisOpts.getLength() > 0 && (linearOpts = ((Element)(nd = axisOpts.item(0))).getElementsByTagName("LinearOpts")).getLength() > 0) {
            LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)linearOpts.item(0), axis, soc);
        }
        axis.updateOutputRange();
    }

    public static AbstractSGComponent loadNonGraphs(StatGraph graph, Element elem) {
        BaseOverlayContainer oc = (BaseOverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new BaseOverlayContainer(true, false, false, true);
        }
        LayoutOverlayParser.loadNonGraphs(graph, elem, oc);
        return oc;
    }

    public static AbstractSGComponent loadNonGraphs(StatGraph graph, Element elem, BaseOverlayContainer oc) {
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            AbstractAnno text;
            JComponent overlayContainer;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            JComponent comp = (JComponent)graph.getObjectFromElement((Element)node);
            if (elemTag.equals("Entry")) {
                EntryComposite ec;
                JComponent entry = comp != null ? comp : new EntryComposite();
                EntryConcatParser.load(graph, (Element)node, entry, oc, 0);
                if (((Element)node).getAttribute("_id").startsWith("dropsite") && entry instanceof EntryComposite && (ec = (EntryComposite)entry).getCenterComponent() != null) {
                    RotatedJTextPane rjt = (RotatedJTextPane)ec.getCenterComponent();
                    rjt.setText("");
                }
                oc.add((Component)entry, 0);
            } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                Legend legend = comp != null ? (Legend)comp : new Legend();
                LegendParser.load(graph, (Element)node, legend, oc);
                oc.add((Component)legend, 0);
            } else if (elemTag.equals("ContinuousLegend")) {
                LegendComponent legend = comp != null ? (LegendComponent)comp : new LegendComponent();
                LegendParser.load(graph, (Element)node, legend, oc);
                oc.add((Component)legend, 0);
            } else if (elemTag.equals("GTable")) {
                Table table = comp != null ? (Table)comp : new Table();
                TableParser.load(graph, (Element)node, table, oc);
                oc.add((Component)table, 0);
            } else if (elemTag.equals("LayoutRegion")) {
                AbstractSGComponent region = LayoutRegionParser.load(graph, (Element)node);
                oc.add((Component)region, 0);
            } else if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = comp != null ? (GridPanel)comp : new GridPanel();
                GridPanelParser.load(graph, (Element)node, grid, oc);
                oc.add((Component)grid, 0);
            } else if (elemTag.equals("LayoutOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayEquated")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMapTemp")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapTempParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMap")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutQCOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = StatGraph.parseThirdPartyComponent(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlay3D")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutLattice")) {
                oc.add((Component)LayoutLatticeParser.load(graph, (Element)node), 0);
            } else if (elemTag.equals("ScatterPlotMatrix")) {
                oc.add((Component)ScatterMatrixParser.load(graph, (Element)node), 0);
            } else if (elemTag.startsWith("Draw") && (text = AnnotateParser.load(graph, (Element)node, oc)) != null) {
                if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                } else {
                    graph.annotationInFrontList.add(text);
                }
            }
            if (ok) continue;
            return null;
        }
        return oc;
    }

    public static AbstractSGComponent loadPlot(StatGraph graph, Element elem, int type) {
        return LayoutOverlayParser.loadPlot(graph, elem, type, null, null);
    }

    public static AbstractSGComponent loadPlot(StatGraph graph, Element elem, int type, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        graph.style.resetCounters();
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlayParser.initComposite(graph, elem);
        } else {
            graph.removeObjectFromElement(elem);
        }
        Simple2DOverlayComposite soc = oc.getComposite();
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        oc.getBaseComponent().setTransparentBackground(graph.isTransparentBackground());
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        LayoutOverlayParser.initAxis(graph, xAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, x2Axis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, yAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, y2Axis, graph.axisLineOffsetCoverage);
        xAxisType = 0;
        x2AxisType = 0;
        yAxisType = 0;
        y2AxisType = 0;
        zAxisType = 0;
        boolean xSecondary = false;
        boolean ySecondary = false;
        if (oc.isHorizontal()) {
            xSecondary = elem.getAttribute("yAxis").equalsIgnoreCase("y2");
            ySecondary = elem.getAttribute("xAxis").equalsIgnoreCase("x2");
        } else {
            xSecondary = elem.getAttribute("xAxis").equalsIgnoreCase("x2");
            ySecondary = elem.getAttribute("yAxis").equalsIgnoreCase("y2");
        }
        LayoutOverlayParser.requiredAxesTypeByPlot(graph, elem, !xSecondary, xSecondary, !ySecondary, ySecondary, false, new boolean[5]);
        if (rowColumnAxesType != null) {
            if (rowColumnAxesType[0] != -1) {
                yAxisType = rowColumnAxesType[0];
            }
            if (rowColumnAxesType[1] != -1) {
                xAxisType = rowColumnAxesType[1];
            }
        }
        if (rowColumn2AxesType != null) {
            if (rowColumn2AxesType[0] != -1) {
                y2AxisType = rowColumn2AxesType[0];
            }
            if (rowColumn2AxesType[1] != -1) {
                x2AxisType = rowColumn2AxesType[1];
            }
        }
        VRectAxis x1a = xAxis;
        VRectAxis x2a = x2Axis;
        VRectAxis y1a = yAxis;
        VRectAxis y2a = y2Axis;
        if (xSecondary) {
            x1a = x2Axis;
            x2a = xAxis;
        }
        if (ySecondary) {
            y1a = y2Axis;
            y2a = yAxis;
        }
        Overlay overlay = null;
        switch (type) {
            case 0: {
                overlay = ScatterParser.load(graph, elem);
                break;
            }
            case 30: {
                overlay = TextPlotParser.load(graph, elem);
                break;
            }
            case 1: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = SeriesParser.load(graph, elem, curveLabelPosition);
                break;
            }
            case 2: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = StepParser.load(graph, elem, curveLabelPosition);
                break;
            }
            case 3: {
                overlay = NeedleParser.load(graph, elem);
                break;
            }
            case 4: {
                overlay = VectorParser.load(graph, elem);
                break;
            }
            case 5: {
                Message msg = new Message(RB.getStringResource(RB_KEY, "parmplot.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"LINEPARM", (Object)LayoutOverlayParser.getLayoutName(elem.getParentNode())));
                overlay = null;
                break;
            }
            case 16: {
                Message msg = new Message(RB.getStringResource(RB_KEY, "parmplot.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"REFERENCELINE", (Object)LayoutOverlayParser.getLayoutName(elem.getParentNode())));
                overlay = null;
                break;
            }
            case 17: {
                Message msg = new Message(RB.getStringResource(RB_KEY, "parmplot.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"DROPLINE", (Object)LayoutOverlayParser.getLayoutName(elem.getParentNode())));
                overlay = null;
                break;
            }
            case 6: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = BandParser.load(graph, elem, curveLabelPosition);
                break;
            }
            case 7: {
                overlay = HistoParser.load(graph, elem);
                break;
            }
            case 9: {
                boolean[] log = new boolean[]{xAxisType == 3, x2AxisType == 3, yAxisType == 3, y2AxisType == 3};
                double[] base = new double[]{logBaseX, logBaseX2, logBaseY, logBaseY2};
                overlay = ContourParser.load(graph, elem);
                break;
            }
            case 11: {
                overlay = BarParser.load(graph, elem);
                break;
            }
            case 19: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = ParetoLineParser.load(graph, elem, curveLabelPosition);
                break;
            }
            case 20: {
                overlay = HeatMapParmParser.load(graph, elem);
                break;
            }
            case 21: {
                overlay = WaterFallChartParser.load(graph, elem);
                break;
            }
            case 22: {
                overlay = DendrogramParser.load(graph, elem);
                break;
            }
            case 23: {
                overlay = BubbleParser.load(graph, elem);
                break;
            }
            case 15: {
                overlay = PieParser.load(graph, elem);
                soc.getWall().setFillOn(false);
                soc.getWall().setEdgeOn(false);
                soc.setAxesVisible(false);
                break;
            }
            case 12: {
                Message msg;
                if (elem.getAttribute("_stmt").equalsIgnoreCase("EllipseParm")) {
                    msg = new Message(RB.getStringResource(RB_KEY, "parmplot.fmt.txt"));
                    StatGraph.printWarning(msg.toString((Object)"ELLIPSEPARM", (Object)LayoutOverlayParser.getLayoutName(elem.getParentNode())));
                    overlay = null;
                    break;
                }
                overlay = EllipseParmParser.load(graph, elem);
                break;
            }
            case 13: {
                overlay = FringeParser.load(graph, elem);
                break;
            }
            case 18: {
                overlay = BlockParser.load(graph, elem);
                if (!LayoutOverlayParser.isAxisOptsApplicable(elem, "XAxisOpts", false, true)) {
                    soc.setAxesVisible(false);
                }
                soc.getWall().setEdgeOn(false);
                break;
            }
            case 28: {
                overlay = AxisTableParser.load(graph, elem);
                if (!LayoutOverlayParser.isAxisOptsApplicable(elem, "XAxisOpts", false, true) && !LayoutOverlayParser.isAxisOptsApplicable(elem, "YAxisOpts", true, true)) {
                    soc.setAxesVisible(false);
                }
                soc.getWall().setEdgeOn(false);
                break;
            }
            case 14: {
                overlay = BoxParser.load(graph, elem);
                break;
            }
            case 24: {
                overlay = HighLowParser.load(graph, elem);
                break;
            }
            case 31: {
                overlay = HeatBoxParser.load(graph, elem);
                break;
            }
            case 25: {
                overlay = LineChartParser.load(graph, elem);
                break;
            }
            case 26: {
                overlay = RangeAttrMapViewParser.load(graph, elem);
                break;
            }
            case 27: {
                overlay = TimeSeriesParser.load(graph, elem);
                break;
            }
            case 29: {
                overlay = PolygonParser.load(graph, elem);
            }
        }
        if (overlay == null) {
            return null;
        }
        if (graph.dataAntialiased && !overlay.isDisableAA()) {
            overlay.setDisableAA(!graph.updateAAMax(overlay.getRendererComplexity()));
        }
        if (graph.imagemapEnabled && overlay.isTooltipEnabled()) {
            overlay.setTooltipEnabled(graph.updateTipMax(overlay.getNumOfTooltips()));
        }
        overlay.setComponentSize(graph.size.width, graph.size.height);
        LayoutOverlayParser.setAutomaticAxisTypes(overlay, true, xAxis, x2Axis, yAxis, y2Axis, null);
        if (oc.isHorizontal()) {
            LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, y1a, y2a, x1a, x2a, null);
        } else {
            LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, x1a, x2a, y1a, y2a, null);
        }
        if (overlay instanceof BarOverlay && ((BarOverlay)overlay).isCategorySortVarDefined()) {
            ArrayList<Overlay> a = new ArrayList<Overlay>();
            a.add(overlay);
            LayoutOverlayParser.setCategorySortByColumn(a, xAxis, x2Axis, yAxis, y2Axis);
        }
        if (!LayoutOverlayParser.isCompatibleOverlay(graph, overlay)) {
            return null;
        }
        LayoutOverlayParser.addOverlay(overlay, soc, xAxis, x2Axis, yAxis, y2Axis, null, oc.isHorizontal());
        if (overlay instanceof BoxOverlay) {
            Overlay[] blocks = ((BoxOverlay)overlay).getBlockOverlays();
            if (blocks != null) {
                OverlayInnerMargin oim;
                for (int i = 0; i < blocks.length; ++i) {
                    LayoutOverlayParser.addOverlay(blocks[i], soc, xAxis, x2Axis, yAxis, y2Axis, null, oc.isHorizontal());
                }
                if (((BoxOverlay)overlay).getOrientation() == 1) {
                    oim = new OverlayInnerMargin(3);
                    TextAttrs textStyle = new TextAttrs();
                    GraphStyle.setDefaultTextStyle(graph, "", textStyle, "DataText");
                    FontMetrics fm = StatGraph.getFontMetrics(textStyle.getFont());
                    int gap = (int)((double)fm.getHeight() * 0.25);
                    oim.setGutter(gap);
                    oim.setPad(-1, -1, -1, gap);
                } else {
                    oim = new OverlayInnerMargin(2);
                }
                for (int i = 0; i < blocks.length; ++i) {
                    oim.addOverlay(blocks[i]);
                }
                soc.addOverlayInnerMargin(oim);
            }
            if (!overlay.getModel().isAvailable(10)) {
                if (((BoxOverlay)overlay).getOrientation() == 0) {
                    if (overlay.getXAxis().equalsIgnoreCase("X")) {
                        xAxis.setVisible(false);
                    } else {
                        x2Axis.setVisible(false);
                    }
                } else if (overlay.getYAxis().equalsIgnoreCase("Y")) {
                    yAxis.setVisible(false);
                } else {
                    y2Axis.setVisible(false);
                }
            }
        }
        if (((Element)elem.getParentNode()).getTagName().equalsIgnoreCase("LayoutLattice")) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, x2Axis, x2Axis, yAxis, y2Axis);
        } else if (xAxis.isVisible() && xAxis.getAxisStyle().isTitleOn() && xAxis.getTitleFitPolicy() == 1) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, null, null, yAxis, y2Axis);
        } else if (x2Axis.isVisible() && x2Axis.getAxisStyle().isTitleOn() && x2Axis.getTitleFitPolicy() == 1) {
            LayoutOverlayParser.modifyAxisTitleFitPolicy(soc, null, null, yAxis, y2Axis);
        }
        LayoutOverlayParser.validateBrokenAxes(soc, xAxis, x2Axis, yAxis, y2Axis);
        return oc;
    }

    public static void addOverlay(Overlay overlay, Simple2DOverlayComposite soc, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        LayoutOverlayParser.addOverlay(overlay, soc, xa, x2a, ya, y2a, za, false);
    }

    private static boolean isAxisAffected(Overlay plot, byte dim) {
        boolean affected = true;
        if (plot instanceof ReferenceLineOverlay) {
            ReferenceLineOverlay ref = (ReferenceLineOverlay)plot;
            switch (dim) {
                case 1: {
                    if (!ref.isHorizontal()) break;
                    affected = false;
                    break;
                }
                case 2: {
                    if (ref.isHorizontal()) break;
                    affected = false;
                }
            }
        }
        return affected;
    }

    public static void addOverlay(Overlay overlay, Simple2DOverlayComposite soc, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za, boolean horizontal) {
        soc.addOverlay(overlay);
        boolean xok = true;
        boolean yok = true;
        boolean zok = true;
        if (horizontal) {
            if (overlay.getYAxis().equals("y")) {
                if (!xa.isVisible()) {
                    xa.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)xa, (byte)1);
            } else {
                if (!x2a.isVisible()) {
                    x2a.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)x2a, (byte)1);
            }
            if (overlay.getXAxis().equals("x")) {
                if (!ya.isVisible()) {
                    ya.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)ya, (byte)2);
            } else {
                if (!y2a.isVisible()) {
                    y2a.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)y2a, (byte)2);
            }
        } else {
            if (overlay.getXAxis().equals("x")) {
                if (!xa.isVisible()) {
                    xa.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)xa, (byte)1);
            } else {
                if (!x2a.isVisible()) {
                    x2a.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)x2a, (byte)1);
            }
            if (overlay.getYAxis().equals("y")) {
                if (!ya.isVisible()) {
                    ya.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)ya, (byte)2);
            } else {
                if (!y2a.isVisible()) {
                    y2a.setVisible(LayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)y2a, (byte)2);
            }
        }
        if (za != null) {
            za.setVisible(true);
            zok = soc.connect(overlay, (AbstractAxis)za, (byte)3);
        }
        if (!(xok && yok && zok)) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            soc.removeOverlay(overlay);
        }
    }

    public static OverlayContainer initComposite(StatGraph graph, Element elem) {
        boolean interactive = !graph.server;
        boolean softwareBuffered = false;
        if (elem.getTagName().equalsIgnoreCase("ContourPlotParm") || elem.getTagName().equals("ContourParm")) {
            softwareBuffered = ContourParser.needsSmoothFill(graph, elem);
        } else {
            Element cE = StatGraph.getOptionAttrsElement(elem, "ContourPlotParm");
            if (cE == null) {
                cE = StatGraph.getOptionAttrsElement(elem, "ContourParm");
            }
            if (cE != null) {
                softwareBuffered = ContourParser.needsSmoothFill(graph, cE);
            }
        }
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new OverlayContainer(true, softwareBuffered, interactive);
        }
        Simple2DOverlayComposite soc = new Simple2DOverlayComposite();
        soc.setLabelVerbose(graph.isLabelVerbose());
        soc.setLabelDisplaceable(graph.isLabelDisplaceable());
        soc.setSALabeling(graph.isSALabeling());
        soc.setSAWeightMap(graph.getSAWeightMap());
        soc.setSAMaxIterations(graph.getSAMaxIterations());
        soc.setSASeed(graph.getSASeed());
        oc.setComposite(soc);
        Wall w = new Wall(true);
        GraphStyle.setDefaultLineStyle(graph, null, w.getEdgeStyle(), "WallFill");
        GraphStyle.setDefaultLineStyle(graph, null, w.getAxisLineStyle(), "AxisLines");
        String str = elem.getAttribute("wallDisplay");
        if (str.length() == 0) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                w.setEdgeOn(true);
            } else {
                w.setEdgeOn(false);
            }
            w.setFillOn(true);
        } else if (str.equalsIgnoreCase("STANDARD")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            w.setFillOn(false);
            w.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else {
            w.setFillOn(false);
            w.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    w.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    w.setFillOn(true);
                    continue;
                }
                w.setFillOn(true);
                w.setEdgeOn(true);
                StatGraph.printOptionError("WALLDISPLAY", opts[i]);
                break;
            }
        }
        LayoutOverlayParser.parseWallColor(graph, elem, w.getFillStyle());
        soc.setWall(w);
        soc.dataDisplayAntialiased = graph.dataAntialiased;
        soc.axisDisplayAntialiased = graph.axisAntialiased;
        soc.subpixelRendering = graph.subpixelRendering;
        graph.addSubpixelRenderer(soc);
        oc.setViewportEnabled(0, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(1, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(2, !graph.server && graph.yAxisViewportEnabled);
        oc.setViewportEnabled(3, !graph.server && graph.yAxisViewportEnabled);
        if (!graph.server) {
            if (graph.chartPopupMenu == null) {
                graph.chartPopupMenu = OverlayContainer.createChartPopupMenu();
            }
            oc.setChartPopupMenu(graph.chartPopupMenu);
        }
        if (graph.selectionListener != null) {
            oc.addSelectionListener(graph.selectionListener);
        }
        return oc;
    }

    public static void initAxis(StatGraph graph, VRectAxis axis, double lineExtent) {
        LayoutOverlayParser.initAxis(graph, axis);
        axis.setAxisLineOffsetCoverage(lineExtent);
    }

    public static void initAxis(StatGraph graph, VRectAxis axis) {
        if (axis == null) {
            return;
        }
        axis.setGapShrinkScale(graph.getGapShrinkageScale());
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, null, ls, "AxisLines");
        Color alc = ls.getColor();
        AxisStyle as = axis.getAxisStyle();
        as.setAxisLineColor(alc);
        as.getMajorTickStyle().setColor(alc);
        as.getMinorTickStyle().setColor(alc);
        as.setLineWidth(ls.getWidth());
        as.getMajorTickStyle().setLineWidth(ls.getWidth());
        as.getMinorTickStyle().setLineWidth(ls.getWidth());
        as.setLineStipple(ls.getStipplePattern(), ls.getStippleFactor());
        GraphStyle.setDefaultTextStyle(graph, null, as.getTitleStyle(), "LabelText");
        GraphStyle.setDefaultTextStyle(graph, null, as.getLabelStyle(), "ValueText");
        String str = graph.style.getStyleAttribute("AxisLines", "tickDisplay");
        if (str != null) {
            if (str.equalsIgnoreCase("INSIDE")) {
                axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(0);
            } else if (str.equalsIgnoreCase("ACROSS")) {
                axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(2);
            }
        }
        if (graph.isCASData()) {
            axis.setTickValueOrder(4);
        }
    }

    public static void copyAxisOptions(VRectAxis fromAxis, VRectAxis toAxis) {
        toAxis.setAxisStyle(new AxisStyle(fromAxis.getAxisStyle()));
        toAxis.setRectAxisParams(fromAxis.getRectAxisParams());
        toAxis.setValueFormat(fromAxis.getValueFormat());
        toAxis.setUseDataFormat(fromAxis.isUseDataFormat());
        toAxis.setIntegerTicks(fromAxis.isIntegerTicks());
        toAxis.setStartCoverage(fromAxis.getStartCoverage());
        toAxis.setEndCoverage(fromAxis.getEndCoverage());
        toAxis.setMinOffsetBy(fromAxis.getMinOffsetBy());
        toAxis.setMaxOffsetBy(fromAxis.getMaxOffsetBy());
        toAxis.setUserStartOffset(fromAxis.getUserStartOffset());
        toAxis.setUserEndOffset(fromAxis.getUserEndOffset());
        toAxis.setUseTitle(fromAxis.getUseTitle());
        toAxis.setShortTitle(fromAxis.getShortTitle());
        toAxis.setTitlePositionedAtMax(fromAxis.isTitlePositionedAtMax());
        toAxis.setAxisLineOffsetCoverage(fromAxis.getAxisLineOffsetCoverage());
        String fit = fromAxis.getFitPolicy();
        boolean diagonal2 = fromAxis.getTickValueRotation() == 2;
        String[] compoundFit = fromAxis.getCompoundFitPolicy();
        if (!toAxis.getPrimary() && toAxis.getDimension() == 1) {
            if (fit != null && fit.indexOf("angle315") >= 0 && !diagonal2) {
                fit = fit.replaceAll("angle315", "angle45");
            } else if (fit != null && fit.indexOf("angle45") >= 0 && diagonal2) {
                fit = fit.replaceAll("angle45", "angle315");
            }
            if (compoundFit != null) {
                String[] newCompoundFit = new String[compoundFit.length];
                for (int i = 0; i < compoundFit.length; ++i) {
                    if (compoundFit[i] != null && compoundFit[i].indexOf("angle315") >= 0 && !diagonal2) {
                        newCompoundFit[i] = compoundFit[i].replaceAll("angle315", "angle45");
                    }
                    newCompoundFit[i] = compoundFit[i] != null && compoundFit[i].indexOf("angle45") >= 0 && diagonal2 ? compoundFit[i].replaceAll("angle45", "angle315") : compoundFit[i];
                }
                compoundFit = newCompoundFit;
            }
        } else if (toAxis.getPrimary() && toAxis.getDimension() == 1) {
            if (fit != null && fit.indexOf("angle45") >= 0 && !diagonal2) {
                fit = fit.replaceAll("angle45", "angle315");
            } else if (fit != null && fit.indexOf("angle315") >= 0 && diagonal2) {
                fit = fit.replaceAll("angle315", "angle45");
            }
            if (compoundFit != null) {
                String[] newCompoundFit = new String[compoundFit.length];
                for (int i = 0; i < compoundFit.length; ++i) {
                    newCompoundFit[i] = compoundFit[i] != null && compoundFit[i].indexOf("angle45") >= 0 && !diagonal2 ? compoundFit[i].replaceAll("angle45", "angle315") : (compoundFit[i] != null && compoundFit[i].indexOf("angle315") >= 0 && diagonal2 ? compoundFit[i].replaceAll("angle315", "angle45") : compoundFit[i]);
                }
                compoundFit = newCompoundFit;
            }
        }
        if (fit == null) {
            toAxis.setFitPolicy(null);
        } else {
            toAxis.setHonorFitStartegy(fromAxis.isHonorFitStartegy());
            toAxis.setFitPolicy(fit);
            toAxis.setRotateAlways(fromAxis.isRotateAlways());
            toAxis.setSplitAlways(fromAxis.isSplitAlways());
            toAxis.setCompoundFitPolicy(compoundFit);
        }
        toAxis.setHotelText(fromAxis.isHotelText());
        toAxis.setTicks(fromAxis.getTicks());
        toAxis.setDiscreteTicks(fromAxis.getDiscreteTicks());
        toAxis.setTickValueListPolicy(fromAxis.getTickValueListPolicy());
        toAxis.setTickValuePriority(fromAxis.getTickValuePriority());
        toAxis.setViewportMin(fromAxis.getViewportMin());
        toAxis.setViewportMax(fromAxis.getViewportMax());
        toAxis.setType(fromAxis.getType());
        toAxis.setReverse(fromAxis.isReverse());
        toAxis.setTickLabels(fromAxis.getTickLabels());
        toAxis.setTickValueOrder(fromAxis.getTickValueOrder());
        toAxis.setExtractScale(fromAxis.isExtractScale());
        toAxis.setScientificScale(fromAxis.isScientificScale());
        toAxis.setLogarithmBase(fromAxis.getLogarithmBase());
        toAxis.setLogTickIntervalStyle(fromAxis.getLogTickIntervalStyle());
        toAxis.setTicklabelMaxDecimals(fromAxis.getTickLabelMaxDecimals());
        toAxis.setTicklabelMaxWidth(fromAxis.getTickLabelMaxWidth());
        toAxis.setTicklabelPreferredDecimals(fromAxis.getTickLabelPreferredDecimals());
        toAxis.setMinorNum(fromAxis.getMinorNum());
        toAxis.setUserReqMinorNum(fromAxis.getUserReqMinorNum());
        toAxis.setGridVisible(fromAxis.isGridVisible());
        toAxis.setGridStyle(fromAxis.getGridStyle());
        toAxis.setMinorGridStyle(fromAxis.getMinorGridStyle());
        toAxis.setMinorGridOn(fromAxis.isMinorGridOn());
        toAxis.setAxisLegendFitPolicy(fromAxis.getAxisLegendFitPolicy());
        toAxis.setTicksShownAtMidpoint(fromAxis.isTicksShownAtMidpoint());
        toAxis.setGreenBarOn(fromAxis.isGreenBarOn());
        toAxis.setGreenBarColor(fromAxis.getGreenBarColor());
        toAxis.setLabelPosition(fromAxis.getLabelPosition());
        toAxis.setTickValueRotation(fromAxis.getTickValueRotation());
        toAxis.setMinorTicksOn(fromAxis.isMinorTicksOn());
        toAxis.setMajorTicksOn(fromAxis.isMajorTicksOn());
        toAxis.setTickBoxOn(fromAxis.isTickBoxOn());
        toAxis.getAxisStyle().setTickBoxOn(fromAxis.getAxisStyle().isTickBoxOn());
        toAxis.getAxisStyle().setTickBoxStyle(fromAxis.getAxisStyle().getTickBoxStyle());
        toAxis.getAxisStyle().setTickBoxBackground(fromAxis.getAxisStyle().getTickBoxBackground());
        toAxis.setSortTickValueByOverlay(fromAxis.isSortTickValueByOverlay());
        toAxis.setCompressExtender(fromAxis.isCompressExtender());
        toAxis.setDisplayStackedLabels(fromAxis.isDisplayStackedLabels());
        toAxis.setSplitChar(fromAxis.getSplitChar());
        toAxis.setMultilineJustification(fromAxis.getMultilineJustification());
        toAxis.setTickValueAlignment(fromAxis.getTickValueAlignment());
        toAxis.setSplitCharDrop(fromAxis.isSplitCharDrop());
        toAxis.setTitleFitPolicy(fromAxis.getTitleFitPolicy());
        toAxis.setTitleSplitChar(fromAxis.getTitleSplitChar());
        toAxis.setMultilineTitleJustification(fromAxis.getMultilineTitleJustification());
        toAxis.setTitleSplitCharDrop(fromAxis.isTitleSplitCharDrop());
        toAxis.setBrokenAxis(fromAxis.isBrokenAxis());
        toAxis.setInputDataRanges(fromAxis.getInputDataRanges());
    }

    public static void resetAxisOpts(VRectAxis axis, VRectAxis masterAxis) {
        axis.setRectAxisParams(masterAxis.getRectAxisParams());
        axis.setMinorNum(masterAxis.getMinorNum());
        axis.setStartCoverage(masterAxis.getStartCoverage());
        axis.setEndCoverage(masterAxis.getEndCoverage());
        axis.setTickValueRotation(masterAxis.getTickValueRotation());
        axis.setFitPolicy(masterAxis.getFitPolicy());
        axis.setCompoundFitPolicy(masterAxis.getCompoundFitPolicy());
        axis.setHonorFitStartegy(masterAxis.isHonorFitStartegy());
        axis.setRotateAlways(masterAxis.isRotateAlways());
        axis.setSplitAlways(masterAxis.isSplitAlways());
        axis.setHotelText(masterAxis.isHotelText());
        axis.setValueFormat(masterAxis.getValueFormat());
        axis.setUseDataFormat(masterAxis.isUseDataFormat());
        axis.setTicks(masterAxis.getTicks());
        axis.setTickValuePriority(masterAxis.getTickValuePriority());
        axis.setTickLabels(masterAxis.getTickLabels());
        axis.setViewportMin(masterAxis.getViewportMin());
        axis.setViewportMax(masterAxis.getViewportMax());
        axis.setGreenBarOn(masterAxis.isGreenBarOn());
    }

    public static void turnOffHistogramBinAxis(Simple2DOverlayComposite soc, VRectAxis axis) {
        if (axis.getType() != 1) {
            return;
        }
        ArrayList overlays = soc.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            HistogramOverlay hist;
            if (!(overlays.get(i) instanceof HistogramOverlay) || !(hist = (HistogramOverlay)overlays.get(i)).isBinAxis()) continue;
            if (hist.getOrientation() == 0 && axis.getDimension() == 1) {
                if ((!hist.getXAxis().equalsIgnoreCase("X") || !axis.getPrimary()) && (!hist.getXAxis().equalsIgnoreCase("X2") || axis.getPrimary())) continue;
                hist.setBinAxis(false);
                continue;
            }
            if (hist.getOrientation() != 1 || axis.getDimension() != 2 || (!hist.getYAxis().equalsIgnoreCase("Y") || !axis.getPrimary()) && (!hist.getYAxis().equalsIgnoreCase("Y2") || axis.getPrimary())) continue;
            hist.setBinAxis(false);
        }
    }

    public static void parseGraphOpts(StatGraph graph, Element elem, Overlay overlay) {
        String str = elem.getAttribute("name");
        if (str.length() > 0) {
            graph.addNamedGraph(str, overlay);
            overlay.setName(str);
        }
        if ((str = elem.getAttribute("legendLabel")).length() > 0) {
            overlay.setLegendLabel(str);
        }
        if ((str = elem.getAttribute("xAxis")).length() > 0) {
            if (str.equalsIgnoreCase("x") || str.equalsIgnoreCase("x2")) {
                overlay.setXAxis(str.toLowerCase());
            } else {
                StatGraph.printOptionError("XAXIS", str);
            }
        }
        if ((str = elem.getAttribute("yAxis")).length() > 0) {
            if (str.equalsIgnoreCase("y") || str.equalsIgnoreCase("y2")) {
                overlay.setYAxis(str.toLowerCase());
            } else {
                StatGraph.printOptionError("YAXIS", str);
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute("dataTransparency"))) {
            overlay.setDataTransparency(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("antiAlias")).equalsIgnoreCase("OFF")) {
            overlay.setDisableAA(true);
        }
        if ((str = elem.getAttribute("contributeOffsets")).equalsIgnoreCase("NONE")) {
            overlay.setContribOffsets(false, false, false, false);
        } else if (str.equalsIgnoreCase("ALL")) {
            overlay.setContribOffsets(true, true, true, true);
        } else if (str.length() > 0) {
            boolean xmin = false;
            boolean xmax = false;
            boolean ymin = false;
            boolean ymax = false;
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("xmin")) {
                    xmin = true;
                    continue;
                }
                if (opts[i].equalsIgnoreCase("xmax")) {
                    xmax = true;
                    continue;
                }
                if (opts[i].equalsIgnoreCase("ymin")) {
                    ymin = true;
                    continue;
                }
                if (opts[i].equalsIgnoreCase("ymax")) {
                    ymax = true;
                    continue;
                }
                xmin = true;
                xmax = true;
                ymin = true;
                ymax = true;
                StatGraph.printOptionError("CONTRIBUTEOFFSETS", opts[i]);
                break;
            }
            overlay.setContribOffsets(xmin, xmax, ymin, ymax);
        }
        str = elem.getAttribute("_stmt");
        if (str.length() == 0) {
            str = elem.getTagName();
        }
        overlay.setStmt(str.toUpperCase());
        overlay.setDataSkinMax(graph.dataSkinMax);
        overlay.setDiscreteOffsetPadding(graph.isDiscreteOffsetPadding());
        if (graph.server && !graph.imagemapEnabled) {
            overlay.setTooltipEnabled(false);
        }
    }

    static boolean isNumericAxis(int type) {
        return type == 0 || type == 3 || type == 1;
    }

    public static boolean isOverlayCompatibleWithComposite(Overlay overlay, Simple2DOverlayComposite soc) {
        ArrayList ovs = soc.getOverlays();
        if (ovs.size() == 0) {
            return true;
        }
        boolean ok = true;
        if (overlay instanceof BoxOverlay && !overlay.getModel().isAvailable(10)) {
            boolean hasX = false;
            boolean hasX2 = false;
            boolean hasY = false;
            boolean hasY2 = false;
            for (int i = 0; i < ovs.size(); ++i) {
                Overlay o = (Overlay)ovs.get(i);
                if (o == overlay || o instanceof BoxOverlay && !o.getModel().isAvailable(10)) continue;
                if (o.getXAxis().equalsIgnoreCase("X")) {
                    hasX = true;
                } else {
                    hasX2 = true;
                }
                if (o.getYAxis().equalsIgnoreCase("Y")) {
                    hasY = true;
                    continue;
                }
                hasY2 = true;
            }
            if (((BoxOverlay)overlay).getOrientation() == 0) {
                if (overlay.getXAxis().equalsIgnoreCase("X") && hasX || overlay.getXAxis().equalsIgnoreCase("X2") && hasX2) {
                    ok = false;
                }
            } else if (overlay.getYAxis().equalsIgnoreCase("Y") && hasY || overlay.getYAxis().equalsIgnoreCase("Y2") && hasY2) {
                ok = false;
            }
        } else {
            boolean allowX = true;
            boolean allowX2 = true;
            boolean allowY = true;
            boolean allowY2 = true;
            for (int i = 0; i < ovs.size(); ++i) {
                Overlay o = (Overlay)ovs.get(i);
                if (o == overlay || !(o instanceof BoxOverlay)) continue;
                BoxOverlay box = (BoxOverlay)o;
                if (overlay instanceof BlockOverlay && box.getBlockOverlays() != null) {
                    Overlay[] blocks = box.getBlockOverlays();
                    for (int b = 0; b < blocks.length; ++b) {
                        if (blocks[b] != overlay) continue;
                        return ok;
                    }
                }
                if (o.getModel().isAvailable(10)) continue;
                if (box.getOrientation() == 0) {
                    if (o.getXAxis().equalsIgnoreCase("X")) {
                        allowX = false;
                        continue;
                    }
                    allowX2 = false;
                    continue;
                }
                if (o.getYAxis().equalsIgnoreCase("Y")) {
                    allowY = false;
                    continue;
                }
                allowY2 = false;
            }
            if (overlay.getXAxis().equalsIgnoreCase("X") && !allowX || overlay.getXAxis().equalsIgnoreCase("X2") && !allowX2) {
                ok = false;
            }
            if (overlay.getYAxis().equalsIgnoreCase("Y") && !allowY || overlay.getYAxis().equalsIgnoreCase("Y2") && allowY2) {
                ok = false;
            }
        }
        if (!ok) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "nonxbox.txt"));
        }
        return ok;
    }

    public static boolean isCompatibleOverlay(StatGraph graph, Overlay overlay) {
        int type;
        DataRange dr;
        if (overlay instanceof ReferenceLineOverlay || overlay instanceof DropLineOverlay) {
            return true;
        }
        if (overlay instanceof RangeAttrMapViewOverlay) {
            int typeY;
            RangeAttrMapViewOverlay view = (RangeAttrMapViewOverlay)overlay;
            int typeX = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType;
            int n = typeY = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType;
            if (!(view.getXRangeAttributeMap() != null && (view.getXRangeAttributeMap() == null || typeX != 0 && typeX != 1) || view.getYRangeAttributeMap() != null && (view.getYRangeAttributeMap() == null || typeY != 0 && typeY != 1))) {
                return true;
            }
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            return false;
        }
        if (overlay instanceof LineParmOverlay || overlay instanceof EllipseParmOverlay) {
            int typeY;
            int typeX = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType;
            int n = typeY = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType;
            if (!(typeX != 0 && typeX != 1 || typeY != 0 && typeY != 1)) {
                return true;
            }
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            return false;
        }
        if (overlay instanceof TimeSeriesOverlay) {
            int typeY;
            int typeX = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType;
            int n = typeY = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType;
            if (((TimeSeriesOverlay)overlay).isVertical() && typeX != 1 || !((TimeSeriesOverlay)overlay).isVertical() && typeY != 1) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
                return false;
            }
        }
        if ((dr = overlay.getDataRange((byte)1)) instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "discrete.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt(), (Object)StatGraph.roundToNextHundreds(((DiscreteRange)dr).getValuesSize())), false);
            return false;
        }
        int xa = LayoutOverlayParser.getAxisType(dr);
        if (!(xa < 0 || xa == (type = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType) || LayoutOverlayParser.isNumericAxis(xa) && LayoutOverlayParser.isNumericAxis(type))) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            return false;
        }
        dr = overlay.getDataRange((byte)2);
        if (dr instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "discrete.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt(), (Object)StatGraph.roundToNextHundreds(((DiscreteRange)dr).getValuesSize())), false);
            return false;
        }
        int ya = LayoutOverlayParser.getAxisType(dr);
        if (!(ya < 0 || ya == (type = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType) || LayoutOverlayParser.isNumericAxis(ya) && LayoutOverlayParser.isNumericAxis(type))) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            return false;
        }
        dr = overlay.getDataRange((byte)3);
        if (dr instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "discrete.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt(), (Object)StatGraph.roundToNextHundreds(((DiscreteRange)dr).getValuesSize())), false);
            return false;
        }
        int za = LayoutOverlayParser.getAxisType(dr);
        if (!(za < 0 || za == zAxisType || LayoutOverlayParser.isNumericAxis(za) && LayoutOverlayParser.isNumericAxis(zAxisType))) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
            return false;
        }
        return true;
    }

    static int getAxisType(DataRange dr) {
        if (dr == null) {
            return -1;
        }
        if (dr instanceof DiscreteRange) {
            return 2;
        }
        if (dr.getFormat() instanceof SASDateTimeFormat) {
            return 1;
        }
        return 0;
    }

    static void setAutomaticAxisTypes(Overlay firstPlot, boolean view2D, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        int type = LayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)1));
        if (firstPlot.getXAxis().equalsIgnoreCase("x2")) {
            x2AxisType = type;
        } else {
            xAxisType = type;
        }
        type = LayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)2));
        if (firstPlot.getYAxis().equalsIgnoreCase("y2")) {
            y2AxisType = type;
        } else {
            yAxisType = type;
        }
        if (!view2D) {
            zAxisType = LayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)3));
        }
        LayoutOverlayParser.setTypeToVRectAxis(xa, xAxisType);
        LayoutOverlayParser.setTypeToVRectAxis(x2a, x2AxisType);
        LayoutOverlayParser.setTypeToVRectAxis(ya, yAxisType);
        LayoutOverlayParser.setTypeToVRectAxis(y2a, y2AxisType);
        LayoutOverlayParser.setTypeToVRectAxis(za, zAxisType);
    }

    public static void setAutomaticAxisTypes(ArrayList overlays, boolean view2D, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        LayoutOverlayParser.setTypeToVRectAxis(xa, xAxisType);
        LayoutOverlayParser.setTypeToVRectAxis(x2a, x2AxisType);
        LayoutOverlayParser.setTypeToVRectAxis(ya, yAxisType);
        LayoutOverlayParser.setTypeToVRectAxis(y2a, y2AxisType);
        LayoutOverlayParser.setTypeToVRectAxis(za, zAxisType);
    }

    public static void setCategorySortByColumn(ArrayList plots, VRectAxis rx, VRectAxis rx2, VRectAxis ry, VRectAxis ry2) {
        VRectAxis axis;
        BoxOverlay box;
        VRectAxis axis2;
        Overlay o;
        int i;
        int n = plots.size();
        BarOverlay bar = null;
        boolean xPrimary = false;
        boolean x2Primary = false;
        boolean yPrimary = false;
        boolean y2Primary = false;
        for (i = n - 1; i >= 0; --i) {
            o = (Overlay)plots.get(i);
            if (o.isDependent() || !o.isPrimary()) continue;
            if (o instanceof BarOverlay) {
                bar = (BarOverlay)o;
                if (bar.isCategorySortVarDefined()) {
                    axis2 = null;
                    if (bar.getOrientation() == 0) {
                        if (bar.getXAxis().equalsIgnoreCase("X") && !xPrimary) {
                            axis2 = rx;
                        } else if (bar.getXAxis().equalsIgnoreCase("X2") && !x2Primary) {
                            axis2 = rx2;
                        }
                    } else if (bar.getYAxis().equalsIgnoreCase("Y") && !yPrimary) {
                        axis2 = ry;
                    } else if (bar.getXAxis().equalsIgnoreCase("Y2") && !y2Primary) {
                        axis2 = ry2;
                    }
                    if (axis2 != null) {
                        switch (axis2.getTickValueOrder()) {
                            case 5: {
                                bar.setOrder(7);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                            case -1: 
                            case 3: {
                                bar.setOrder(6);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                            case 0: {
                                bar.setOrder(0);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                        }
                    }
                }
            } else if (o instanceof BoxOverlay && (box = (BoxOverlay)o).getCategoryOrderRole() != BoxOverlay.ORDER_AUTO) {
                axis = null;
                if (box.getOrientation() == 0) {
                    if (box.getXAxis().equalsIgnoreCase("X") && !xPrimary) {
                        axis = rx;
                    } else if (box.getXAxis().equalsIgnoreCase("X2") && !x2Primary) {
                        axis = rx2;
                    }
                } else if (box.getYAxis().equalsIgnoreCase("Y") && !yPrimary) {
                    axis = ry;
                } else if (box.getXAxis().equalsIgnoreCase("Y2") && !y2Primary) {
                    axis = ry2;
                }
                if (axis != null) {
                    switch (axis.getTickValueOrder()) {
                        case 5: {
                            box.setCategoryOrderType(2);
                            axis.setSortTickValueByOverlay(true);
                            break;
                        }
                        case 3: {
                            box.setCategoryOrderType(1);
                            axis.setSortTickValueByOverlay(true);
                            break;
                        }
                        default: {
                            box.setCategoryOrderType(0);
                            box.setCategoryOrderRole(BoxOverlay.ORDER_AUTO);
                            axis.setSortTickValueByOverlay(false);
                        }
                    }
                }
            }
            if (o.getXAxis().equalsIgnoreCase("X")) {
                xPrimary = true;
            } else {
                x2Primary = true;
            }
            if (o.getYAxis().equalsIgnoreCase("Y")) {
                yPrimary = true;
                continue;
            }
            y2Primary = true;
        }
        if (xPrimary && yPrimary && x2Primary && y2Primary) {
            return;
        }
        for (i = 0; i < n; ++i) {
            o = (Overlay)plots.get(i);
            if (o.isDependent()) continue;
            if (o instanceof BarOverlay) {
                bar = (BarOverlay)o;
                if (bar.isCategorySortVarDefined()) {
                    axis2 = null;
                    if (bar.getOrientation() == 0) {
                        if (bar.getXAxis().equalsIgnoreCase("X") && !xPrimary) {
                            axis2 = rx;
                        } else if (bar.getXAxis().equalsIgnoreCase("X2") && !x2Primary) {
                            axis2 = rx2;
                        }
                    } else if (bar.getYAxis().equalsIgnoreCase("Y") && !yPrimary) {
                        axis2 = ry;
                    } else if (bar.getXAxis().equalsIgnoreCase("Y2") && !y2Primary) {
                        axis2 = ry2;
                    }
                    if (axis2 != null) {
                        switch (axis2.getTickValueOrder()) {
                            case 5: {
                                bar.setOrder(7);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                            case -1: 
                            case 3: {
                                bar.setOrder(6);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                            case 0: {
                                bar.setOrder(0);
                                axis2.setSortTickValueByOverlay(true);
                                break;
                            }
                        }
                    }
                }
            } else if (o instanceof BoxOverlay && (box = (BoxOverlay)o).getCategoryOrderRole() != BoxOverlay.ORDER_AUTO) {
                axis = null;
                if (box.getOrientation() == 0) {
                    if (box.getXAxis().equalsIgnoreCase("X") && !xPrimary) {
                        axis = rx;
                    } else if (box.getXAxis().equalsIgnoreCase("X2") && !x2Primary) {
                        axis = rx2;
                    }
                } else if (box.getYAxis().equalsIgnoreCase("Y") && !yPrimary) {
                    axis = ry;
                } else if (box.getXAxis().equalsIgnoreCase("Y2") && !y2Primary) {
                    axis = ry2;
                }
                if (axis != null) {
                    switch (axis.getTickValueOrder()) {
                        case 5: {
                            box.setCategoryOrderType(2);
                            axis.setSortTickValueByOverlay(true);
                            break;
                        }
                        case 3: {
                            box.setCategoryOrderType(1);
                            axis.setSortTickValueByOverlay(true);
                            break;
                        }
                        default: {
                            box.setCategoryOrderType(0);
                            box.setCategoryOrderRole(BoxOverlay.ORDER_AUTO);
                            axis.setSortTickValueByOverlay(false);
                        }
                    }
                }
            }
            if (o.getXAxis().equalsIgnoreCase("X")) {
                xPrimary = true;
            } else {
                x2Primary = true;
            }
            if (o.getYAxis().equalsIgnoreCase("Y")) {
                yPrimary = true;
                continue;
            }
            y2Primary = true;
        }
    }

    public static boolean addPlotToList(ArrayList overlays, Overlay plot, StatGraph graph, boolean scaleMarker) {
        if (plot == null) {
            return false;
        }
        plot.setComponentSize(graph.size.width, graph.size.height);
        plot.setScaleMarkers(scaleMarker && graph.isScaleMarkers());
        return LayoutOverlayParser.addPlotToList(overlays, plot);
    }

    public static boolean addPlotToList(ArrayList overlays, Overlay plot) {
        if (plot != null) {
            overlays.add(plot);
            return true;
        }
        return false;
    }

    static void setTypeToVRectAxis(VRectAxis axis, int type) {
        if (axis == null) {
            return;
        }
        switch (type) {
            case 0: {
                axis.setType(0);
                break;
            }
            case 3: {
                axis.setType(1);
                break;
            }
            case 1: {
                axis.setType(5);
                break;
            }
            case 2: {
                axis.setType(6);
            }
        }
    }

    static Overlay getFirst2DPlot(ArrayList overlays, String str) {
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay overlay = (Overlay)overlays.get(i);
            if (!str.equals("x") && !str.equals("x2") ? overlay.getDataRange((byte)2) == null : overlay.getDataRange((byte)1) == null) continue;
            if (!overlay.getXAxis().equalsIgnoreCase(str) && !overlay.getYAxis().equalsIgnoreCase(str)) continue;
            return overlay;
        }
        return null;
    }

    public static void parseAxisOptsList(StatGraph graph, Simple2DOverlayComposite soc, Element elem, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("XAxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "XAxisOpts", false, true)) {
                xa.setVisible(true);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, xa);
                continue;
            }
            if (elemTag.equals("X2AxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "X2AxisOpts", false, false)) {
                x2a.setVisible(true);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, x2a);
                continue;
            }
            if (elemTag.equals("YAxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "YAxisOpts", true, true)) {
                if (za == null) {
                    ya.setVisible(true);
                    LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, ya);
                    continue;
                }
                za.setVisible(true);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, za);
                continue;
            }
            if (elemTag.equals("Y2AxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "Y2AxisOpts", true, false)) {
                y2a.setVisible(true);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, y2a);
                continue;
            }
            if (!elemTag.equals("ZAxisOpts")) continue;
            ya.setVisible(true);
            LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, ya);
        }
    }

    private static void validateBrokenAxes(Simple2DOverlayComposite soc, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a) {
        if (soc != null && ya != null && y2a != null && soc.hasOverlayOnAxis(ya) && soc.hasOverlayOnAxis(y2a)) {
            ya.setBrokenAxis(false);
            ya.setInputDataRanges(null);
            y2a.setBrokenAxis(false);
            y2a.setInputDataRanges(null);
        }
        if (soc != null && xa != null && x2a != null && soc.hasOverlayOnAxis(xa) && soc.hasOverlayOnAxis(x2a)) {
            xa.setBrokenAxis(false);
            xa.setInputDataRanges(null);
            x2a.setBrokenAxis(false);
            x2a.setInputDataRanges(null);
        }
        if (ya != null && ya.isBrokenAxis() && soc.hasOverlayOnAxis(ya) || y2a != null && y2a.isBrokenAxis() && soc.hasOverlayOnAxis(y2a)) {
            if (xa != null) {
                xa.setBrokenAxis(false);
                xa.setInputDataRanges(null);
            }
            if (x2a != null) {
                x2a.setBrokenAxis(false);
                x2a.setInputDataRanges(null);
            }
        }
    }

    private static void modifyAxisTitleFitPolicy(Simple2DOverlayComposite soc, VRectAxis x1, VRectAxis x2, VRectAxis y1, VRectAxis y2) {
        Message msg = new Message(RB.getStringResource(RB_KEY, "axislabelfit.fmt.txt"));
        if (x1 != null && x1.getTitleFitPolicy() == 1 && (soc == null || soc.hasOverlayOnAxis(x1))) {
            x1.setTitleFitPolicy(0);
            StatGraph.printNote(msg.toString((Object)"X"));
        }
        if (x2 != null && x2.getTitleFitPolicy() == 1 && (soc == null || soc.hasOverlayOnAxis(x2))) {
            x2.setTitleFitPolicy(0);
            StatGraph.printNote(msg.toString((Object)"X2"));
        }
        if (y1 != null && y1.getTitleFitPolicy() == 1 && (soc == null || soc.hasOverlayOnAxis(y1))) {
            y1.setTitleFitPolicy(0);
            StatGraph.printNote(msg.toString((Object)"Y"));
        }
        if (y2 != null && y2.getTitleFitPolicy() == 1 && (soc == null || soc.hasOverlayOnAxis(y2))) {
            y2.setTitleFitPolicy(0);
            StatGraph.printNote(msg.toString((Object)"Y2"));
        }
    }

    public static void parseAxisOpts(StatGraph graph, Simple2DOverlayComposite soc, Element axisOps, VRectAxis axis) {
        LayoutOverlayParser.parseAxisOpts(graph, soc, axisOps, axis, false);
    }

    public static void parseAxisCompOpts(StatGraph graph, Simple2DOverlayComposite soc, Element axisOps, VRectAxis axis) {
        LayoutOverlayParser.parseAxisOpts(graph, soc, axisOps, axis, true);
    }

    static void parseAxisOpts(StatGraph graph, Simple2DOverlayComposite soc, Element axisOps, VRectAxis axis, boolean isComp) {
        int type;
        String str = axisOps.getAttribute("name");
        if (str.length() > 0) {
            axis.setName(str);
        }
        if ((str = axisOps.getAttribute("opaque")).length() > 0 && str.equalsIgnoreCase("true")) {
            Color bgColor = StatGraph.parseAttrColor("backgroundColor", graph, axisOps);
            if (bgColor != null) {
                axis.setBackground(bgColor);
            } else {
                FillAttrs wallFill = new FillAttrs();
                GraphStyle.setDefaultFillStyle(graph, "", wallFill, "WallFill");
                axis.setBackground(wallFill.getColor());
            }
        }
        if ((str = axisOps.getAttribute("type")).equalsIgnoreCase("LINEAR")) {
            type = 0;
        } else if (str.equalsIgnoreCase("TIME")) {
            type = 1;
        } else if (str.equalsIgnoreCase("DISCRETE")) {
            type = 2;
        } else if (str.equalsIgnoreCase("LOG")) {
            type = 3;
        } else {
            type = axis.getDimension() == 1 ? (axis.getPrimary() ? xAxisType : x2AxisType) : (axis.getDimension() == 2 ? (axis.getPrimary() ? yAxisType : y2AxisType) : zAxisType);
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("TYPE", str);
            }
        }
        LayoutOverlayParser.setTypeToVRectAxis(axis, type);
        if (axis.getDimension() == 1) {
            if (axis.getPrimary()) {
                xAxisType = type;
            } else {
                x2AxisType = type;
            }
        } else if (axis.getDimension() == 2) {
            if (axis.getPrimary()) {
                yAxisType = type;
            } else {
                y2AxisType = type;
            }
        } else {
            zAxisType = type;
        }
        str = axisOps.getAttribute("display");
        AxisStyle as = axis.getAxisStyle();
        if (str.length() != 0 && !str.equalsIgnoreCase("STANDARD") && !str.equalsIgnoreCase("ALL")) {
            as.setAxisLineOn(false);
            as.setMajorTickMarksOn(false);
            as.setTitleOn(false);
            as.setLabelsOn(false);
            if (!str.equalsIgnoreCase("NONE")) {
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("LINE")) {
                        as.setAxisLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKS")) {
                        as.setMajorTickMarksOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("LABEL")) {
                        as.setTitleOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKVALUES")) {
                        as.setLabelsOn(true);
                        continue;
                    }
                    as.setAxisLineOn(true);
                    as.setMajorTickMarksOn(true);
                    as.setTitleOn(true);
                    as.setLabelsOn(true);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        axis.setMajorTicksOn(as.isMajorTickMarksOn());
        String hint = graph.style.getStyleAttribute("GridLines", "displayOpts");
        if (hint == null) {
            hint = "";
        }
        boolean gridVisible = false;
        str = axisOps.getAttribute("gridDisplay");
        if (str.equalsIgnoreCase("on")) {
            gridVisible = true;
        } else if (str.equalsIgnoreCase("off")) {
            gridVisible = false;
        } else if (str.equalsIgnoreCase("auto_on")) {
            gridVisible = !hint.equalsIgnoreCase("off");
        } else {
            gridVisible = hint.equalsIgnoreCase("on");
            if (str.length() > 0 && !str.equalsIgnoreCase("auto_off")) {
                StatGraph.printOptionError("GRIDDISPLAY", str);
            }
        }
        axis.setGridVisible(gridVisible);
        VRectGridLines grid = null;
        if (gridVisible) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("gridAttrs"), gridStyle, "GridLines");
            axis.setGridStyle(gridStyle);
            if (soc != null) {
                grid = new VRectGridLines();
                grid.setLineStyle(gridStyle);
                soc.connect(grid, axis);
            }
        }
        if (gridVisible && (str = graph.style.getStyleAttribute("MinorGridLines", "displayOpts")) != null && str.equalsIgnoreCase("on")) {
            axis.setMinorGridOn(true);
            if (type == 0) {
                axis.getRectAxisParams().setMinorNum(1);
            } else if (type == 1) {
                axis.getRectAxisParams().setMinorNum(12);
            } else if (type == 3) {
                axis.getRectAxisParams().setMinorNum(10);
            }
            LineAttrs minorGridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, "", minorGridStyle, "MinorGridLines");
            axis.setMinorGridStyle(minorGridStyle);
        }
        if ((str = axisOps.getAttribute("label")).length() > 0) {
            axis.setUseTitle(str);
        }
        if ((str = axisOps.getAttribute("labelFormat")).length() > 0) {
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt == null) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "badfmt.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"LABELFORMAT", (Object)str));
            } else {
                axis.setLabelFormat(fmt);
            }
        }
        if ((str = axisOps.getAttribute("reverse")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setReverse(true);
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("lineExtent"))) {
            double d = Double.parseDouble(str);
            if (d >= 0.0 && d <= 1.0) {
                axis.setAxisLineOffsetCoverage(d);
            }
        } else if (str.equalsIgnoreCase("full")) {
            axis.setAxisLineOffsetCoverage(1.0);
        } else if (str.equalsIgnoreCase("data")) {
            axis.setAxisLineOffsetCoverage(0.0);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("LINEEXTENT", str);
        } else {
            axis.setAxisLineOffsetCoverage(graph.axisLineOffsetCoverage);
        }
        double omax = 0.0;
        str = axisOps.getAttribute("offsetMax");
        if (StatGraph.isNumber(str)) {
            omax = Double.parseDouble(str);
        }
        double omin = 0.0;
        str = axisOps.getAttribute("offsetMin");
        if (StatGraph.isNumber(str)) {
            omin = Double.parseDouble(str);
        }
        if (omin + omax > 1.0) {
            axisOps.removeAttribute("offsetMin");
            axisOps.removeAttribute("offsetMax");
            StatGraph.printNote(RB.getStringResource(RB_KEY, "offsets.txt"));
        }
        String string = str = axis.isReverse() ? axisOps.getAttribute("offsetMax") : axisOps.getAttribute("offsetMin");
        if (StatGraph.isNumber(str)) {
            axis.setUserStartOffset(Double.parseDouble(str));
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
        } else if (str.equalsIgnoreCase("autoCompress")) {
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        } else if (str.equalsIgnoreCase("auto")) {
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_AUTO);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("OFFSETMIN", str);
        }
        String string2 = str = axis.isReverse() ? axisOps.getAttribute("offsetMin") : axisOps.getAttribute("offsetMax");
        if (StatGraph.isNumber(str)) {
            axis.setUserEndOffset(Double.parseDouble(str));
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
        } else if (str.equalsIgnoreCase("autoCompress")) {
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        } else if (str.equalsIgnoreCase("auto")) {
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_AUTO);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("OFFSETMAX", str);
        }
        str = axisOps.getAttribute("shortLabel");
        if (str.length() > 0) {
            axis.setShortTitle(str);
        }
        if ((str = axisOps.getAttribute("tickStyle")).equalsIgnoreCase("INSIDE")) {
            axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(0);
        } else if (str.equalsIgnoreCase("ACROSS")) {
            axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(2);
        } else if (str.length() > 0 && !str.equalsIgnoreCase("OUTSIDE")) {
            StatGraph.printOptionError("TICKSTYLE", str);
        }
        str = axisOps.getAttribute("labelPosition");
        if (str.length() > 0) {
            if (axis.getDimension() == 1) {
                if (str.equalsIgnoreCase("LEFT")) {
                    axis.setLabelPosition(0);
                } else if (str.equalsIgnoreCase("RIGHT")) {
                    axis.setLabelPosition(2);
                } else if (str.equalsIgnoreCase("CENTER")) {
                    axis.setLabelPosition(1);
                } else if (str.equalsIgnoreCase("DATACENTER")) {
                    axis.setLabelPosition(3);
                } else {
                    StatGraph.printOptionError("LABELPOSITION", str);
                }
            } else if (axis.getDimension() == 2) {
                if (str.equalsIgnoreCase("BOTTOM")) {
                    axis.setLabelPosition(0);
                } else if (str.equalsIgnoreCase("TOP")) {
                    axis.setLabelPosition(2);
                } else if (str.equalsIgnoreCase("CENTER")) {
                    axis.setLabelPosition(1);
                } else if (str.equalsIgnoreCase("DATACENTER")) {
                    axis.setLabelPosition(3);
                } else {
                    StatGraph.printOptionError("LABELPOSITION", str);
                }
            }
        }
        boolean splittable = axis.getLabelPosition() == 1 || axis.getLabelPosition() == 3;
        str = axisOps.getAttribute("labelFitPolicy");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("AUTO")) {
                axis.setTitleFitPolicy(0);
            } else if (str.equalsIgnoreCase("SPLIT") && splittable) {
                axis.setTitleFitPolicy(1);
            } else if (str.equalsIgnoreCase("SPLITALWAYS") && splittable) {
                axis.setTitleFitPolicy(2);
            } else if (str.equalsIgnoreCase("STACKED") && splittable) {
                axis.setTitleFitPolicy(2);
                axis.setHotelText(true);
            } else {
                StatGraph.printOptionError("LABELFITPOLICY", str);
            }
        }
        if (axis.getTitleFitPolicy() == 1 || axis.getTitleFitPolicy() == 2) {
            str = axisOps.getAttribute("labelSplitChar");
            if (str.length() > 0) {
                char[] schars = new char[str.length()];
                for (int i = 0; i < str.length(); ++i) {
                    schars[i] = str.charAt(i);
                }
                axis.setTitleSplitChar(schars);
            }
            if ((str = axisOps.getAttribute("labelSplitJustify")).length() > 0) {
                if (axis.getDimension() == 1) {
                    if (str.equalsIgnoreCase("left")) {
                        axis.setMultilineTitleJustification(0);
                    } else if (str.equalsIgnoreCase("right")) {
                        axis.setMultilineTitleJustification(2);
                    } else if (str.equalsIgnoreCase("center")) {
                        axis.setMultilineTitleJustification(1);
                    } else {
                        StatGraph.printOptionError("LABELSPLITJUSTIFY", str);
                    }
                } else if (axis.getDimension() == 2) {
                    if (str.equalsIgnoreCase("bottom")) {
                        axis.setMultilineTitleJustification(3);
                    } else if (str.equalsIgnoreCase("top")) {
                        axis.setMultilineTitleJustification(0);
                    } else if (str.equalsIgnoreCase("center")) {
                        axis.setMultilineTitleJustification(1);
                    } else {
                        StatGraph.printOptionError("LABELSPLITJUSTIFY", str);
                    }
                }
            } else {
                axis.setMultilineTitleJustification(1);
            }
            str = axisOps.getAttribute("labelSplitCharDrop");
            if (str.equalsIgnoreCase("false")) {
                axis.setTitleSplitCharDrop(false);
            }
        }
        if (axis.getDimension() == 1) {
            str = axisOps.getAttribute("tickValueVAlign");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("TOP")) {
                    axis.setTickValueAlignment(0);
                } else if (str.equalsIgnoreCase("BOTTOM")) {
                    axis.setTickValueAlignment(3);
                } else if (str.equalsIgnoreCase("CENTER")) {
                    axis.setTickValueAlignment(1);
                } else {
                    StatGraph.printOptionError("VALIGN", str);
                }
            }
        } else if (axis.getDimension() == 2 && (str = axisOps.getAttribute("tickValueHAlign")).length() > 0) {
            if (str.equalsIgnoreCase("LEFT")) {
                axis.setTickValueAlignment(0);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axis.setTickValueAlignment(2);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axis.setTickValueAlignment(1);
            } else {
                StatGraph.printOptionError("HALIGN", str);
            }
        }
        if ((axis.getUseTitle() == null || axis.getUseTitle().equals("")) && axis.getLabelPosition() == 2 && axis.getDimension() == 2 && (str = axisOps.getAttribute("stackedLabels")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setDisplayStackedLabels(true);
            axis.setShortTitle("");
        }
        TextAttrs ta = new TextAttrs();
        GraphStyle.setDefaultTextStyle(graph, axisOps.getAttribute("labelAttrs"), axis.getAxisStyle().getTitleStyle(), "LabelText");
        GraphStyle.setDefaultTextStyle(graph, axisOps.getAttribute("tickValueAttrs"), axis.getAxisStyle().getLabelStyle(), "ValueText");
        LineAttrs tls = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("axisLineAttrs"), tls, "AxisLines");
        axis.getAxisStyle().setAxisLineColor(tls.getColor());
        axis.getAxisStyle().getMajorTickStyle().setColor(tls.getColor());
        axis.getAxisStyle().getMinorTickStyle().setColor(tls.getColor());
        axis.getAxisStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().getMajorTickStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().getMinorTickStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().setLineStipple(tls.getStipplePattern(), tls.getStippleFactor());
        String elemTag = "";
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("AxisLineAttrs")) {
                LineAttrs ls = new LineAttrs();
                StatGraph.parseLineAttrs(graph, (Element)node, ls);
                axis.getAxisStyle().setAxisLineColor(ls.getColor());
                axis.getAxisStyle().getMajorTickStyle().setColor(ls.getColor());
                axis.getAxisStyle().getMinorTickStyle().setColor(ls.getColor());
                axis.getAxisStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().getMajorTickStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().getMinorTickStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().setLineStipple(ls.getStipplePattern(), ls.getStippleFactor());
                continue;
            }
            if (elemTag.equals("GridAttrs")) {
                if (grid != null) {
                    StatGraph.parseLineAttrs(graph, (Element)node, grid.getLineStyle());
                }
                if (!gridVisible) continue;
                StatGraph.parseLineAttrs(graph, (Element)node, axis.getGridStyle());
                continue;
            }
            if (elemTag.equals("LabelAttrs")) {
                StatGraph.parseTextAttrs(graph, (Element)node, axis.getAxisStyle().getTitleStyle());
                continue;
            }
            if (elemTag.equals("TickValueAttrs")) {
                StatGraph.parseTextAttrs(graph, (Element)node, axis.getAxisStyle().getLabelStyle());
                continue;
            }
            if (elemTag.equals("LinearOpts")) {
                if (!isComp && type != 0) continue;
                LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node, axis, soc);
                continue;
            }
            if (elemTag.equals("DiscreteOpts")) {
                if (!isComp && type != 2) continue;
                LayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node, axis);
                if (grid != null && gridVisible && soc != null) {
                    grid.setShownAtMidpoint(axis.isTicksShownAtMidpoint());
                }
                if (!axis.isGreenBarOn() || soc == null) continue;
                VRectGridLines gBar = new VRectGridLines();
                soc.connectGreenBar(gBar, axis);
                continue;
            }
            if (elemTag.equals("TimeOpts")) {
                if (!isComp && type != 1) continue;
                LayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node, axis, soc);
                continue;
            }
            if (elemTag.equals("LogOpts")) {
                if (!isComp && type != 3) continue;
                LayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node, axis);
                continue;
            }
            if (!elemTag.equals("PercentileOpts") && !elemTag.equals("ProbabilityOpts")) continue;
        }
        if (!axis.isMinorTicksOn() && !axis.isMinorGridOn()) {
            axis.getRectAxisParams().setMinorNum(0);
        }
    }

    private static void parseOverviewAxis(StatGraph graph, Element elem, Simple2DOverlayComposite soc, VRectAxis axis, Element layoutOverlayElem) {
        String str;
        Element overviewElem;
        Simple2DOverlayComposite plot_soc = null;
        if (LayoutOverlayParser.hasGraphElement(elem)) {
            overviewElem = elem;
        } else {
            overviewElem = (Element)layoutOverlayElem.cloneNode(true);
            NodeList nl = overviewElem.getElementsByTagName("XAxisOpts");
            if (nl.getLength() > 0) {
                overviewElem.removeChild(nl.item(0));
            }
            if ((nl = overviewElem.getElementsByTagName("X2AxisOpts")).getLength() > 0) {
                overviewElem.removeChild(nl.item(0));
            }
            if ((nl = overviewElem.getElementsByTagName("YAxisOpts")).getLength() > 0) {
                overviewElem.removeChild(nl.item(0));
            }
            if ((nl = overviewElem.getElementsByTagName("Y2AxisOpts")).getLength() > 0) {
                overviewElem.removeChild(nl.item(0));
            }
        }
        int[] axesType = new int[]{yAxisType, xAxisType};
        int[] axes2Type = new int[]{y2AxisType, x2AxisType};
        AbstractSGComponent comp = LayoutOverlayParser.load(graph, overviewElem, axesType, axes2Type);
        if (comp instanceof OverlayContainer) {
            plot_soc = ((OverlayContainer)comp).getComposite();
        }
        if (plot_soc == null) {
            return;
        }
        OverviewAxisComposite composite = new OverviewAxisComposite(axis);
        composite.setChannel(soc.getChannel());
        Wall w = new Wall(true);
        w.setFillStyle(soc.getWall().getFillStyle());
        w.setFillOn(soc.getWall().isFillOn());
        w.setEdgeOn(false);
        composite.setWall(w);
        VRectAxis xAxis = new VRectAxis(1, false);
        xAxis.setType(xAxisType);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        x2Axis.setType(x2AxisType);
        VRectAxis yAxis = new VRectAxis(2, false);
        yAxis.setType(yAxisType);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        y2Axis.setType(y2AxisType);
        x2Axis.setVisible(false);
        yAxis.setVisible(false);
        y2Axis.setVisible(false);
        xAxis.setVisible(axis.isVisible());
        LayoutOverlayParser.copyAxisOptions(axis, xAxis);
        ArrayList plots = plot_soc.getOverlays();
        for (int i = 0; i < plots.size(); ++i) {
            Overlay o = (Overlay)plots.get(i);
            if (!o.getXAxis().equalsIgnoreCase("X")) continue;
            composite.connect(o, (AbstractAxis)xAxis, (byte)1);
            if (o.getYAxis().equalsIgnoreCase("Y")) {
                composite.connect(o, (AbstractAxis)yAxis, (byte)2);
                continue;
            }
            composite.connect(o, (AbstractAxis)y2Axis, (byte)2);
        }
        DataRange dr = axis.getInputDataRange();
        if (dr instanceof ContinuousRange) {
            xAxis.setViewportMin(((ContinuousRange)dr).getMin());
            xAxis.setViewportMax(((ContinuousRange)dr).getMax());
            xAxis.setTickValuePriority(false);
        } else if (dr instanceof OrdinalRange) {
            xAxis.setInputDataRange((DataRange)new OrdinalRange((OrdinalRange)dr));
        } else {
            xAxis.setInputDataRange((DataRange)new DiscreteRange((DataRange)((DiscreteRange)dr)));
        }
        axis.setComposite(composite);
        axis.getAxisStyle().setTitleOn(false);
        boolean update = false;
        if (!Double.isNaN(axis.getDisplayMin())) {
            axis.setStartCoverage(0.0);
            if (axis.isReverse()) {
                axis.setUserEndOffset(0.0);
            } else {
                axis.setUserStartOffset(0.0);
            }
            axis.setViewportMin(axis.getDisplayMin());
            update = true;
        }
        if (!Double.isNaN(axis.getDisplayMax())) {
            axis.setEndCoverage(0.0);
            if (axis.isReverse()) {
                axis.setUserStartOffset(0.0);
            } else {
                axis.setUserEndOffset(0.0);
            }
            axis.setViewportMax(axis.getDisplayMax());
            update = true;
        }
        axis.setTickValuePriority(false);
        if (update) {
            axis.updateOutputRange();
        }
        if ((str = elem.getAttribute("maxSize")).length() > 0 && StatGraph.isNumber(str)) {
            composite.setMaxSize(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("minSize")).length() > 0 && StatGraph.isNumber(str)) {
            composite.setMinSize(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("reverseOrthogonalAxis")).length() > 0 && str.equalsIgnoreCase("true")) {
            yAxis.setReverse(true);
        }
        if ((str = elem.getAttribute("reverseOrthogonalAxis")).length() > 0 && str.equalsIgnoreCase("true")) {
            y2Axis.setReverse(true);
        }
        str = elem.getAttribute("overviewAxisDisplay");
        AxisStyle as = xAxis.getAxisStyle();
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD") || str.equalsIgnoreCase("ALL")) {
            as.setAxisLineOn(true);
            as.setMajorTickMarksOn(true);
            as.setLabelsOn(true);
        } else {
            as.setAxisLineOn(false);
            as.setMajorTickMarksOn(false);
            as.setLabelsOn(false);
            if (!str.equalsIgnoreCase("NONE")) {
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("LINE")) {
                        as.setAxisLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKS")) {
                        as.setMajorTickMarksOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKVALUES")) {
                        as.setLabelsOn(true);
                        continue;
                    }
                    as.setAxisLineOn(true);
                    as.setMajorTickMarksOn(true);
                    as.setLabelsOn(true);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        xAxis.setMajorTicksOn(as.isMajorTickMarksOn());
    }

    public static boolean honorAxisOpts(Element axisOps, VRectAxis axis, String attrName) {
        Element parent = (Element)axisOps.getParentNode();
        while (!parent.getNodeName().equalsIgnoreCase("StatGraph")) {
            parent = (Element)parent.getParentNode();
        }
        NodeList nl = parent.getElementsByTagName("LayoutLattice");
        if (nl == null || nl.getLength() <= 0) {
            return true;
        }
        Element lattice = (Element)nl.item(0);
        if (axis.getDimension() == 1) {
            String str;
            Element colaxis = null;
            if (axis.getPrimary()) {
                str = lattice.getAttribute("columnDataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("ColumnAxes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                colaxis = (Element)nl.item(0);
            } else {
                str = lattice.getAttribute("column2DataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("Column2Axes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                colaxis = (Element)nl.item(0);
            }
            if (colaxis != null && (nl = colaxis.getElementsByTagName("ColumnAxis")) != null && nl.getLength() > 0) {
                if (attrName.equalsIgnoreCase("viewport")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps.getParentNode() != nl.item(i)) continue;
                        return true;
                    }
                } else if (attrName.equalsIgnoreCase("displaySecondary")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps != nl.item(i)) continue;
                        return true;
                    }
                }
                return false;
            }
        } else {
            String str;
            Element rowaxis = null;
            if (axis.getPrimary()) {
                str = lattice.getAttribute("rowDataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("RowAxes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                rowaxis = (Element)nl.item(0);
            } else {
                str = lattice.getAttribute("row2DataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("Row2Axes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                rowaxis = (Element)nl.item(0);
            }
            if (rowaxis != null && (nl = rowaxis.getElementsByTagName("RowAxis")) != null && nl.getLength() > 0) {
                if (attrName.equalsIgnoreCase("viewport")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps.getParentNode() != nl.item(i)) continue;
                        return true;
                    }
                } else if (attrName.equalsIgnoreCase("displaySecondary")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps != nl.item(i)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static void parseLinearAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis, Simple2DOverlayComposite soc) {
        String[] labels;
        boolean tvloS = false;
        String str = axisOps.getAttribute("integer");
        if (str.equalsIgnoreCase("true")) {
            axis.setIntegerTicks(true);
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("nTicks"))) {
            axis.setNTicks(Integer.parseInt(str));
        }
        if ((str = axisOps.getAttribute("minorTicks")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setMinorTicksOn(true);
            axis.getRectAxisParams().setMinorNum(1);
        }
        if (axis.isGridVisible()) {
            str = axisOps.getAttribute("minorGrid");
            if (str.equalsIgnoreCase("true")) {
                axis.setMinorGridOn(true);
                axis.getRectAxisParams().setMinorNum(1);
            } else if (str.equalsIgnoreCase("false")) {
                axis.setMinorGridOn(false);
            }
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("minorTickCount"))) {
            int n = (int)Double.parseDouble(str);
            axis.setUserReqMinorNum(n);
        }
        if (axis.isMinorGridOn()) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("minorGridAttrs"), gridStyle, "MinorGridLines");
            axis.setMinorGridStyle(gridStyle);
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("thresholdMin"))) {
            axis.setStartCoverage(Double.parseDouble(str));
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("thresholdMax"))) {
            axis.setEndCoverage(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("tickValueRotation")).length() > 0) {
            if (str.equalsIgnoreCase("diagonal")) {
                axis.setTickValueRotation(0);
            } else if (str.equalsIgnoreCase("diagonal2")) {
                axis.setTickValueRotation(2);
            } else if (str.equalsIgnoreCase("vertical")) {
                axis.setTickValueRotation(1);
            } else {
                Message msg = new Message(RB.getStringResource(RB_KEY, "angle.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"TICKVALUEROTATION", (Object)str));
            }
        }
        if ((str = axisOps.getAttribute("tickValueFitPolicy")).length() > 0) {
            axis.setTickLabeling(str);
        }
        if ((str = axisOps.getAttribute("viewportMin")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMin(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("viewportMax")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMax(Double.parseDouble(str));
        }
        double viewportmin = axis.getDisplayMin();
        double viewportmax = axis.getDisplayMax();
        if (!Double.isNaN(viewportmin) && !Double.isNaN(viewportmax) && viewportmin >= viewportmax) {
            axis.setDisplayMin(Double.NaN);
            axis.setDisplayMax(Double.NaN);
        }
        if ((str = axisOps.getAttribute("tickValueFormat")).length() > 0) {
            if (!str.equalsIgnoreCase("DATA")) {
                Message msg;
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    msg = new Message(RB.getStringResource(RB_KEY, "badfmt.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else if (fmt.isCharacterFormat()) {
                    msg = new Message(RB.getStringResource(RB_KEY, "formattype.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else {
                    axis.setValueFormat(fmt);
                }
            } else {
                axis.setUseDataFormat(true);
            }
        }
        if ((str = axisOps.getAttribute("origin")).length() > 0) {
            axis.setOrigin(Double.parseDouble(str));
        }
        Element tickValueElem = null;
        Element tickDisplayElem = null;
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("MinorGridAttrs") && axis.isMinorGridOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, axis.getMinorGridStyle());
                continue;
            }
            if (elemTag.equals("TickValueFormatOpts")) {
                Element ggood = (Element)node;
                str = ggood.getAttribute("maxWidth");
                if (StatGraph.isNumber(str)) {
                    axis.setTicklabelMaxWidth(Integer.parseInt(str));
                }
                if (StatGraph.isNumber(str = ggood.getAttribute("maxDecimals"))) {
                    axis.setTicklabelMaxDecimals(Integer.parseInt(str));
                }
                if (StatGraph.isNumber(str = ggood.getAttribute("preferredDecimals"))) {
                    axis.setTicklabelPreferredDecimals(Integer.parseInt(str));
                }
                if ((str = ggood.getAttribute("extractScale")).equalsIgnoreCase("true")) {
                    axis.setExtractScale(true);
                }
                if (!(str = ggood.getAttribute("extractScaleType")).equalsIgnoreCase("scientific")) continue;
                axis.setScientificScale(true);
                continue;
            }
            if (elemTag.equals("IncludeRanges")) {
                ContinuousRange[] ranges = LayoutOverlayParser.parseIncludeRanges(graph, (Element)node);
                if (ranges == null) continue;
                axis.setInputDataRanges(ranges);
                axis.setBrokenAxis(true);
                continue;
            }
            if (elemTag.equals("TickValues")) {
                tickValueElem = (Element)node;
                tvloS = true;
                continue;
            }
            if (elemTag.equals("TickDisplays")) {
                tickDisplayElem = (Element)node;
                tvloS = true;
                continue;
            }
            if (!elemTag.equals("TickValueSequence")) continue;
            Element tvs = (Element)node;
            double start = 0.0;
            double end = 0.0;
            double increment = 0.0;
            boolean hasStart = false;
            boolean hasEnd = false;
            boolean hasIncrement = false;
            str = tvs.getAttribute("start");
            if (StatGraph.isNumber(str)) {
                start = Double.parseDouble(str);
                hasStart = true;
            }
            if (StatGraph.isNumber(str = tvs.getAttribute("end"))) {
                end = Double.parseDouble(str);
                hasEnd = true;
            }
            if (StatGraph.isNumber(str = tvs.getAttribute("increment"))) {
                increment = Double.parseDouble(str);
                hasIncrement = true;
            }
            if (!hasStart && !hasEnd && hasIncrement) {
                if (increment <= 0.0) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "tickinc.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                    continue;
                }
                axis.getRectAxisParams().setAutoMajorInterval(false);
                axis.getRectAxisParams().setMajorInterval(new TickInterval(increment));
                tvloS = true;
                continue;
            }
            if (start < end) {
                if (start + increment < start || start + increment > end) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "tickinc.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                    continue;
                }
            } else if (start > end) {
                if (start + increment > start || start + increment < end) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "tickinc.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                    continue;
                }
            } else if (increment != 0.0) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "tickinc.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
                continue;
            }
            if (increment != 0.0) {
                int i;
                int intervals = (int)Math.ceil((end - start) / increment);
                if (intervals > 10000) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "tickintervals.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)intervals));
                    continue;
                }
                double[] tList = new double[intervals + 1];
                if (increment > 0.0) {
                    for (i = 0; i < intervals + 1; ++i) {
                        tList[i] = i < intervals ? start + (double)i * increment : end;
                    }
                } else {
                    for (i = 0; i < intervals + 1; ++i) {
                        tList[i] = i == 0 ? end : start + (double)(intervals - i) * increment;
                    }
                }
                axis.setTicks(tList);
                tvloS = true;
                continue;
            }
            double[] tList = new double[]{start};
            axis.setTicks(tList);
            tvloS = true;
        }
        str = axisOps.getAttribute("tickValuePriority");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            if (tvloS) {
                axis.setTickValuePriority(true);
            } else {
                axis.setTickValuePriority(false);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "tickprior.txt"));
            }
        }
        if (!axis.getTickValuePriority() && LayoutOverlayParser.honorAxisOpts(axisOps, axis, "viewport")) {
            str = axisOps.getAttribute("viewMin");
            if (str.length() > 0 && StatGraph.isNumber(str)) {
                axis.setViewportMin(Double.parseDouble(str));
            }
            if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber(str)) {
                axis.setViewportMax(Double.parseDouble(str));
            }
            double vmin = axis.getViewportMin();
            double vmax = axis.getViewportMax();
            if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin >= vmax) {
                axis.setViewportMin(Double.NaN);
                axis.setViewportMax(Double.NaN);
                Message msg = new Message(RB.getStringResource(RB_KEY, "viewmm.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
            }
        }
        if (tickValueElem != null && tickDisplayElem != null) {
            TreeMap map = LayoutOverlayParser.parseTickValueAndDisplayLists(tickValueElem, tickDisplayElem);
            int size = map.size();
            double[] ticks = new double[size];
            String[] labels2 = new String[size];
            Iterator iter = map.keySet().iterator();
            for (int n = 0; n < size; ++n) {
                Object key = iter.next();
                ticks[n] = (Double)key;
                labels2[n] = (String)map.get(key);
            }
            if (ticks != null && ticks.length > 0) {
                axis.setTicks(ticks);
            }
            if (labels2 != null && labels2.length > 0) {
                axis.setTickLabels(labels2);
            }
        } else if (tickValueElem != null) {
            double[] ticks = StatGraph.parseDoubleValueList(tickValueElem, "Value", true);
            if (ticks != null && ticks.length > 0) {
                axis.setTicks(ticks);
            }
        } else if (tickDisplayElem != null && (labels = StatGraph.parseStringValueList(tickDisplayElem, "Value")) != null && labels.length > 0) {
            axis.setTickLabels(labels);
        }
    }

    private static TreeMap parseTickValueAndDisplayLists(Element tickValueElem, Element tickDisplayElem) {
        TreeMap<Double, String> pair = new TreeMap<Double, String>();
        String elemTag = "";
        Node nodeD = tickDisplayElem.getFirstChild();
        for (Node nodeV = tickValueElem.getFirstChild(); nodeV != null; nodeV = nodeV.getNextSibling()) {
            Node child;
            Node child2;
            Double value = null;
            if (nodeV instanceof Element && (elemTag = ((Element)nodeV).getTagName()).equals("Value") && (child2 = ((Element)nodeV).getFirstChild()) != null) {
                value = new Double(child2.getNodeValue());
            }
            String display = "";
            if (nodeD != null && nodeD instanceof Element && (elemTag = ((Element)nodeD).getTagName()).equals("Value") && (child = ((Element)nodeD).getFirstChild()) != null) {
                display = child.getNodeValue();
            }
            if (value != null) {
                pair.put(value, display);
            }
            nodeD = nodeD == null ? null : nodeD.getNextSibling();
        }
        return pair;
    }

    public static void parseDiscreteAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis) {
        String pName;
        String str = axisOps.getAttribute("tickValueFormat");
        if (str.length() > 0) {
            Message msg;
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt != null) {
                if (fmt.isCharacterFormat()) {
                    axis.setValueFormat(fmt);
                } else {
                    msg = new Message(RB.getStringResource(RB_KEY, "formattype.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
                }
            } else {
                msg = new Message(RB.getStringResource(RB_KEY, "badfmt.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
            }
        }
        if ((str = axisOps.getAttribute("tickType")).equalsIgnoreCase("MIDPOINT")) {
            axis.setTicksShownAtMidpoint(true);
        } else if (str.equalsIgnoreCase("INBETWEEN")) {
            axis.setTicksShownAtMidpoint(false);
        } else if (str.equalsIgnoreCase("BOX")) {
            axis.setTickBoxOn(true);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("TICKTYPE", str);
        }
        str = axisOps.getAttribute("tickValueRotation");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("diagonal")) {
                axis.setTickValueRotation(0);
            } else if (str.equalsIgnoreCase("diagonal2")) {
                axis.setTickValueRotation(2);
            } else if (str.equalsIgnoreCase("vertical")) {
                axis.setTickValueRotation(1);
            } else if (str.equalsIgnoreCase("auto")) {
                if (axis.isTickBoxOn() && axis.getAxisStyle().isMajorTickMarksOn()) {
                    axis.setTickValueRotation(1);
                } else {
                    axis.setTickValueRotation(0);
                }
            } else {
                Message msg = new Message(RB.getStringResource(RB_KEY, "angle.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"TICKVALUEROTATION", (Object)str));
            }
        } else if (axis.isTickBoxOn() && axis.getAxisStyle().isMajorTickMarksOn()) {
            axis.setTickValueRotation(1);
        } else {
            axis.setTickValueRotation(0);
        }
        str = axisOps.getAttribute("tickValueFitPolicy");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("EXTRACT") || str.equalsIgnoreCase("EXTRACTALWAYS")) {
                boolean auto = str.equalsIgnoreCase("EXTRACT");
                Element parentAxisOpts = (Element)axisOps.getParentNode();
                str = parentAxisOpts.getAttribute("name");
                if (str.length() > 0) {
                    graph.addNamedAxis(str, axis);
                    if (auto) {
                        axis.setAxisLegendFitPolicy(1);
                    } else {
                        axis.setAxisLegendFitPolicy(2);
                    }
                }
            } else {
                axis.setTickLabeling(str);
            }
        }
        if ((str = axisOps.getAttribute("tickValueSplitChar")).length() > 0) {
            char[] schars = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                schars[i] = str.charAt(i);
            }
            axis.setSplitChar(schars);
        }
        if ((str = axisOps.getAttribute("tickValueSplitJustify")).length() > 0) {
            if (str.equalsIgnoreCase("left")) {
                axis.setMultilineJustification(0);
            } else if (str.equalsIgnoreCase("right")) {
                axis.setMultilineJustification(2);
            } else if (str.equalsIgnoreCase("center")) {
                axis.setMultilineJustification(1);
            } else {
                StatGraph.printOptionError("TICKVALUESPLITJUSTIFY", str);
            }
        }
        if ((str = axisOps.getAttribute("tickValueSplitCharDrop")).equalsIgnoreCase("false")) {
            axis.setSplitCharDrop(false);
        }
        if ((str = axisOps.getAttribute("viewportMin")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMin(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("viewportMax")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMax(Double.parseDouble(str));
        }
        double viewportmin = axis.getDisplayMin();
        double viewportmax = axis.getDisplayMax();
        if (!Double.isNaN(viewportmin) && !Double.isNaN(viewportmax) && viewportmin >= viewportmax) {
            axis.setDisplayMin(Double.NaN);
            axis.setDisplayMax(Double.NaN);
        }
        if ((str = axisOps.getAttribute("tickValueOrder")).length() > 0) {
            if (str.equalsIgnoreCase("ASCENDING")) {
                axis.setTickValueOrder(1);
            } else if (str.equalsIgnoreCase("DESCENDING")) {
                axis.setTickValueOrder(2);
            }
        }
        boolean commonAxis = (pName = axisOps.getParentNode().getNodeName()).startsWith("Column") || pName.startsWith("Row");
        str = axisOps.getAttribute("sortOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("AUTO")) {
                axis.setTickValueOrder(-1);
            } else if (str.equalsIgnoreCase("DATA")) {
                axis.setTickValueOrder(0);
            } else if (str.equalsIgnoreCase("ASCENDINGUNFORMATTED") && !commonAxis) {
                axis.setTickValueOrder(3);
            } else if (str.equalsIgnoreCase("ASCENDINGFORMATTED")) {
                axis.setTickValueOrder(4);
            } else if (str.equalsIgnoreCase("DESCENDINGUNFORMATTED") && !commonAxis) {
                axis.setTickValueOrder(5);
            } else if (str.equalsIgnoreCase("DESCENDINGFORMATTED")) {
                axis.setTickValueOrder(6);
            } else if (str.equalsIgnoreCase("_ASCENDINGUNFORMATTED_")) {
                axis.setTickValueOrder(4);
            } else {
                StatGraph.printOptionError("SORTORDER", str);
            }
        } else if (graph.isCASData()) {
            axis.setTickValueOrder(4);
        } else {
            axis.setTickValueOrder(-1);
        }
        str = axisOps.getAttribute("colorBands");
        if (str.equalsIgnoreCase("EVEN") || str.equalsIgnoreCase("ODD")) {
            FillAttrs fillStyle = new FillAttrs();
            fillStyle.setTransparency(0.0);
            GraphStyle.setDefaultDataFillStyle(graph, axisOps.getAttribute("colorBandsAttrs"), fillStyle, "Block");
            Element fillAttrs = StatGraph.getOptionAttrsElement(axisOps, "ColorBandsAttrs");
            if (fillAttrs != null) {
                StatGraph.parseFillAttrs(graph, fillAttrs, fillStyle);
            }
            Color[] colors = new Color[2];
            if (str.equalsIgnoreCase("EVEN")) {
                colors[0] = null;
                colors[1] = Overlay.applyTransparency(fillStyle.getColor(), fillStyle.getTransparency());
            } else {
                colors[0] = Overlay.applyTransparency(fillStyle.getColor(), fillStyle.getTransparency());
                colors[1] = null;
            }
            axis.setGreenBarOn(true);
            axis.setGreenBarColor(colors);
        } else {
            axis.setGreenBarOn(false);
            axis.setGreenBarColor(null);
        }
        if (axis.isTickBoxOn()) {
            AxisStyle as = axis.getAxisStyle();
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("tickBoxOutlineAttrs"), ls, "AxisLines");
            as.getTickBoxStyle().setColor(ls.getColor());
            FillAttrs fs = new FillAttrs();
            fs.setTransparency(0.0);
            GraphStyle.setDefaultDataFillStyle(graph, axisOps.getAttribute("tickBoxFillAttrs"), fs, "Block");
            Color bkColor = Overlay.applyTransparency(fs.getColor(), fs.getTransparency());
            str = axisOps.getAttribute("tickBoxDisplay");
            if (str.length() > 0) {
                as.setTickBoxOn(false);
                as.setTickBoxBackground(null);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("OUTLINE")) {
                        as.setTickBoxOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("FILL")) {
                        as.setTickBoxBackground(bkColor);
                        continue;
                    }
                    as.setTickBoxOn(true);
                    as.setTickBoxBackground(null);
                    StatGraph.printOptionError("TICKBOXDISPLAY", opts[i]);
                    break;
                }
            } else {
                as.setTickBoxOn(true);
                as.setTickBoxBackground(null);
            }
        }
        if ((str = axisOps.getAttribute("tickValueListPolicy")).length() > 0) {
            if (str.equalsIgnoreCase("LIST")) {
                axis.setTickValueListPolicy(0);
            } else if (str.equalsIgnoreCase("UNION")) {
                axis.setTickValueListPolicy(1);
            } else if (str.equalsIgnoreCase("INTERSECTION")) {
                axis.setTickValueListPolicy(2);
            } else if (str.equalsIgnoreCase("DATA")) {
                axis.setTickValueListPolicy(3);
            }
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            String[] ticks;
            Element tickElem;
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("TickDisplays")) {
                tickElem = (Element)node;
                String[] labels = StatGraph.parseStringValueList(tickElem, "Value");
                if (labels == null || labels.length <= 0) continue;
                if (StatGraph.MPC > 0 && graph.pageNo >= 0) {
                    int s = StatGraph.MPC * graph.pageNo;
                    int e = s + StatGraph.MPC;
                    String[] useLabels = new String[StatGraph.MPC];
                    for (int i = s; i < e; ++i) {
                        useLabels[i - s] = i < labels.length ? labels[i] : "";
                    }
                    axis.setTickLabels(useLabels);
                    continue;
                }
                axis.setTickLabels(labels);
                continue;
            }
            if (!elemTag.equals("TickValues") || (ticks = StatGraph.parseStringValueList(tickElem = (Element)node, "Value", true)) == null || ticks.length <= 0) continue;
            axis.setDiscreteTicks(ticks);
        }
    }

    public static void parseTimeAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis, Simple2DOverlayComposite soc) {
        Message msg;
        boolean tvloS = false;
        String str = axisOps.getAttribute("minorTicks");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setMinorTicksOn(true);
            axis.getRectAxisParams().setMinorNum(12);
        } else {
            axis.getRectAxisParams().setMinorNum(0);
        }
        if (axis.isGridVisible()) {
            str = axisOps.getAttribute("minorGrid");
            if (str.equalsIgnoreCase("true")) {
                axis.setMinorGridOn(true);
                axis.getRectAxisParams().setMinorNum(12);
            } else if (str.equalsIgnoreCase("false")) {
                axis.setMinorGridOn(false);
            }
        }
        if (axis.isMinorGridOn()) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("minorGridAttrs"), gridStyle, "MinorGridLines");
            axis.setMinorGridStyle(gridStyle);
        }
        if ((str = axisOps.getAttribute("splitTickValue")).length() > 0 && str.equalsIgnoreCase("false")) {
            axis.getRectAxisParams().setSplitTickValue(false);
        }
        if ((str = axisOps.getAttribute("interval")).length() > 0) {
            if (str.equalsIgnoreCase("second")) {
                axis.getRectAxisParams().setTimeInterval(10);
            } else if (str.equalsIgnoreCase("minute")) {
                axis.getRectAxisParams().setTimeInterval(15);
            } else if (str.equalsIgnoreCase("hour")) {
                axis.getRectAxisParams().setTimeInterval(20);
            } else if (str.equalsIgnoreCase("day")) {
                axis.getRectAxisParams().setTimeInterval(25);
            } else if (str.equalsIgnoreCase("tenday")) {
                axis.getRectAxisParams().setTimeInterval(35);
            } else if (str.equalsIgnoreCase("week")) {
                axis.getRectAxisParams().setTimeInterval(30);
            } else if (str.equalsIgnoreCase("semimonth")) {
                axis.getRectAxisParams().setTimeInterval(40);
            } else if (str.equalsIgnoreCase("month")) {
                axis.getRectAxisParams().setTimeInterval(45);
            } else if (str.equalsIgnoreCase("quarter")) {
                axis.getRectAxisParams().setTimeInterval(50);
            } else if (str.equalsIgnoreCase("semiyear")) {
                axis.getRectAxisParams().setTimeInterval(55);
            } else if (str.equalsIgnoreCase("year")) {
                axis.getRectAxisParams().setTimeInterval(60);
            } else {
                axis.getRectAxisParams().setTimeInterval(0);
                if (!str.equalsIgnoreCase("auto")) {
                    StatGraph.printOptionError("INTERVAL", str);
                }
            }
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("intervalMultiplier"))) {
            axis.getRectAxisParams().setTimeIntervalMultiplier((int)Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("minorTickInterval")).length() > 0) {
            if (str.equalsIgnoreCase("second")) {
                axis.getRectAxisParams().setMinorTimeInterval(10);
            } else if (str.equalsIgnoreCase("minute")) {
                axis.getRectAxisParams().setMinorTimeInterval(15);
            } else if (str.equalsIgnoreCase("hour")) {
                axis.getRectAxisParams().setMinorTimeInterval(20);
            } else if (str.equalsIgnoreCase("day")) {
                axis.getRectAxisParams().setMinorTimeInterval(25);
            } else if (str.equalsIgnoreCase("tenday")) {
                axis.getRectAxisParams().setMinorTimeInterval(35);
            } else if (str.equalsIgnoreCase("week")) {
                axis.getRectAxisParams().setMinorTimeInterval(30);
            } else if (str.equalsIgnoreCase("semimonth")) {
                axis.getRectAxisParams().setMinorTimeInterval(40);
            } else if (str.equalsIgnoreCase("month")) {
                axis.getRectAxisParams().setMinorTimeInterval(45);
            } else if (str.equalsIgnoreCase("quarter")) {
                axis.getRectAxisParams().setMinorTimeInterval(50);
            } else if (str.equalsIgnoreCase("semiyear")) {
                axis.getRectAxisParams().setMinorTimeInterval(55);
            } else if (str.equalsIgnoreCase("year")) {
                axis.getRectAxisParams().setMinorTimeInterval(60);
            } else {
                axis.getRectAxisParams().setMinorTimeInterval(0);
                if (!str.equalsIgnoreCase("auto")) {
                    StatGraph.printOptionError("INTERVAL", str);
                }
            }
        }
        if ((str = axisOps.getAttribute("tickValueRotation")).length() > 0) {
            if (str.equalsIgnoreCase("diagonal")) {
                axis.setTickValueRotation(0);
            } else if (str.equalsIgnoreCase("diagonal2")) {
                axis.setTickValueRotation(2);
            } else if (str.equalsIgnoreCase("vertical")) {
                axis.setTickValueRotation(1);
            } else {
                msg = new Message(RB.getStringResource(RB_KEY, "angle.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"TICKVALUEROTATION", (Object)str));
            }
        }
        if ((str = axisOps.getAttribute("tickValueFitPolicy")).length() > 0) {
            if (!axis.getRectAxisParams().isSplitTickValue()) {
                axis.setTickLabeling(str);
            } else {
                msg = new Message(RB.getStringResource(RB_KEY, "timetickvaluefit.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            }
        }
        if ((str = axisOps.getAttribute("tickValueFormat")).length() > 0) {
            if (!str.equalsIgnoreCase("DATA")) {
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    Message msg2 = new Message(RB.getStringResource(RB_KEY, "badfmt.fmt.txt"));
                    StatGraph.printNote(msg2.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else {
                    axis.setValueFormat(fmt);
                }
            } else {
                axis.setUseDataFormat(true);
            }
        }
        if ((str = axisOps.getAttribute("viewMin")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setViewportMin(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setViewportMax(Double.parseDouble(str));
        }
        double vmin = axis.getViewportMin();
        double vmax = axis.getViewportMax();
        if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin >= vmax) {
            axis.setViewportMin(Double.NaN);
            axis.setViewportMax(Double.NaN);
            Message msg3 = new Message(RB.getStringResource(RB_KEY, "viewmm.fmt.txt"));
            StatGraph.printNote(msg3.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
        }
        if ((str = axisOps.getAttribute("viewportMin")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMin(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("viewportMax")).length() > 0 && StatGraph.isNumber(str)) {
            axis.setDisplayMax(Double.parseDouble(str));
        }
        double viewportmin = axis.getDisplayMin();
        double viewportmax = axis.getDisplayMax();
        if (!Double.isNaN(viewportmin) && !Double.isNaN(viewportmax) && viewportmin >= viewportmax) {
            axis.setDisplayMin(Double.NaN);
            axis.setDisplayMax(Double.NaN);
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            ContinuousRange[] ranges;
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("MinorGridAttrs") && axis.isMinorGridOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, axis.getMinorGridStyle());
                continue;
            }
            if (elemTag.equals("TickValues")) {
                axis.setTicks(StatGraph.parseDoubleValueList((Element)node, "Value", true));
                axis.getRectAxisParams().setMinorNum(0);
                tvloS = true;
                continue;
            }
            if (!elemTag.equals("IncludeRanges") || (ranges = LayoutOverlayParser.parseIncludeRanges(graph, (Element)node)) == null) continue;
            axis.setInputDataRanges(ranges);
            axis.setBrokenAxis(true);
        }
        str = axisOps.getAttribute("tickValuePriority");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            if (tvloS) {
                axis.setTickValuePriority(true);
            } else {
                axis.setTickValuePriority(false);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "tickprior.txt"));
            }
        }
    }

    public static void parseLogarithmicAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis) {
        Message msg;
        boolean tvloS = false;
        String str = axisOps.getAttribute("base");
        if (StatGraph.isNumber(str)) {
            double base = Double.parseDouble(str);
            if (base == 2.0 || base == 10.0) {
                axis.setLogarithmBase(base);
            } else {
                StatGraph.printOptionError("BASE", str);
            }
        } else if (str.length() > 0 && str.equalsIgnoreCase("E")) {
            axis.setLogarithmBase(Math.E);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("BASE", str);
        }
        str = axisOps.getAttribute("tickIntervalStyle");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("LOGEXPONENT")) {
                axis.setLogTickIntervalStyle(1);
            } else if (str.equalsIgnoreCase("LOGEXPAND")) {
                axis.setLogTickIntervalStyle(0);
            } else if (str.equalsIgnoreCase("LINEAR")) {
                axis.setLogTickIntervalStyle(2);
                axis.setTickLabeling("THINLOGARITHMIC");
            } else if (!str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("TICKINTERVALSTYLE", str);
            }
        }
        str = axisOps.getAttribute("valuesType");
        boolean exponent = false;
        if (str.equalsIgnoreCase("exponent")) {
            exponent = true;
        }
        if (axis.getLogarithmBase() == 10.0 && axis.getLogTickIntervalStyle() != 2) {
            str = axisOps.getAttribute("minorTicks");
            if (str.length() > 0 && str.equalsIgnoreCase("true")) {
                axis.setMinorTicksOn(true);
                axis.getRectAxisParams().setMinorNum(10);
            }
            if (axis.isGridVisible()) {
                str = axisOps.getAttribute("minorGrid");
                if (str.equalsIgnoreCase("true")) {
                    axis.setMinorGridOn(true);
                    axis.getRectAxisParams().setMinorNum(10);
                } else if (str.equalsIgnoreCase("false")) {
                    axis.setMinorGridOn(false);
                }
            }
            if (StatGraph.isNumber(str = axisOps.getAttribute("minorTickCount"))) {
                int n = (int)Double.parseDouble(str);
                axis.setUserReqMinorNum(n);
            }
            if (axis.isMinorGridOn()) {
                LineAttrs gridStyle = new LineAttrs();
                GraphStyle.setDefaultLineStyle(graph, axisOps.getAttribute("minorGridAttrs"), gridStyle, "MinorGridLines");
                axis.setMinorGridStyle(gridStyle);
            }
        }
        if ((str = axisOps.getAttribute("tickValueFormat")).length() > 0) {
            if (!str.equalsIgnoreCase("DATA")) {
                Message msg2;
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    msg2 = new Message(RB.getStringResource(RB_KEY, "badfmt.fmt.txt"));
                    StatGraph.printNote(msg2.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else if (fmt.isCharacterFormat()) {
                    msg2 = new Message(RB.getStringResource(RB_KEY, "formattype.fmt.txt"));
                    StatGraph.printNote(msg2.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else {
                    axis.setValueFormat(fmt);
                }
            } else {
                axis.setUseDataFormat(true);
            }
        }
        if ((str = axisOps.getAttribute("viewMin")).length() > 0 && StatGraph.isNumber(str)) {
            double d = Double.parseDouble(str);
            if (exponent) {
                d = Math.pow(axis.getLogarithmBase(), d);
            }
            if (d <= 0.0 || Double.isInfinite(d)) {
                msg = new Message(RB.getStringResource(RB_KEY, "logvmin.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)Double.toString(d)));
            } else {
                axis.setViewportMin(d);
            }
        }
        if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber(str)) {
            double d = Double.parseDouble(str);
            if (exponent) {
                d = Math.pow(axis.getLogarithmBase(), d);
            }
            if (d <= 0.0 || Double.isInfinite(d)) {
                msg = new Message(RB.getStringResource(RB_KEY, "logvmax.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)Double.toString(d)));
            } else {
                axis.setViewportMax(d);
            }
        }
        double vmin = axis.getViewportMin();
        double vmax = axis.getViewportMax();
        if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin >= vmax) {
            axis.setViewportMin(Double.NaN);
            axis.setViewportMax(Double.NaN);
            Message msg3 = new Message(RB.getStringResource(RB_KEY, "viewmm.fmt.txt"));
            StatGraph.printNote(msg3.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("thresholdMin"))) {
            axis.setStartCoverage(Double.parseDouble(str));
        }
        if (StatGraph.isNumber(str = axisOps.getAttribute("thresholdMax"))) {
            axis.setEndCoverage(Double.parseDouble(str));
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("MinorGridAttrs") && axis.isMinorGridOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, axis.getMinorGridStyle());
                continue;
            }
            if (!elemTag.equals("TickValues")) continue;
            Element tickElem = (Element)node;
            double[] ticks = StatGraph.parseDoubleValueList(tickElem, "Value", true);
            if (exponent) {
                int numTicks = ticks.length;
                int idx = 0;
                for (int i = 0; i < ticks.length; ++i) {
                    double expValue = Math.pow(axis.getLogarithmBase(), ticks[i]);
                    if (Double.isInfinite(expValue) || Double.isNaN(expValue)) continue;
                    ticks[idx++] = expValue;
                }
                if (idx < numTicks) {
                    double[] ticks2 = new double[idx];
                    for (int i = 0; i < idx; ++i) {
                        ticks2[i] = ticks[i];
                    }
                    ticks = ticks2;
                }
            }
            boolean okTicks = true;
            for (int i = 0; i < ticks.length; ++i) {
                if (!(ticks[i] <= 0.0)) continue;
                Message msg4 = new Message(RB.getStringResource(RB_KEY, "logtick.fmt.txt"));
                StatGraph.printNote(msg4.toString((Object)Double.toString(ticks[i])));
                okTicks = false;
                break;
            }
            if (!okTicks) continue;
            axis.setTicks(ticks);
            tvloS = true;
        }
        str = axisOps.getAttribute("tickValuePriority");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            if (tvloS) {
                axis.setTickValuePriority(true);
            } else {
                axis.setTickValuePriority(false);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "tickprior.txt"));
            }
        }
    }

    public static void parsePointLabelOpts(StatGraph graph, Simple2DOverlayComposite soc, Element elem) {
        String str = elem.getAttribute("maxHLabelOffset");
        if (str.length() > 0) {
            soc.setMaxHLabelShift(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("maxVLabelOffset")).length() > 0) {
            soc.setMaxVLabelShift(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("hLabelOffsetStep")).length() > 0) {
            soc.setHLabelShiftDelta(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("vLabelOffsetStep")).length() > 0) {
            soc.setVLabelShiftDelta(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("showPointLabels")).equalsIgnoreCase("NONE")) {
            soc.setShowPointLabels(2);
        } else if (str.equalsIgnoreCase("ALL")) {
            soc.setShowPointLabels(1);
        } else if (str.equalsIgnoreCase("CUSTOM")) {
            soc.setShowPointLabels(3);
        }
    }

    public static void addAutoGridLine(StatGraph graph, VRectAxis axis, Simple2DOverlayComposite soc) {
        if (axis.isVisible() && soc.getGridLines(axis) == null) {
            VRectGridLines grid = new VRectGridLines();
            GraphStyle.setDefaultLineStyle(graph, null, grid.getLineStyle(), "GridLines");
            soc.connect(grid, axis);
        }
    }

    static short dim2role(byte dim) {
        short role = -1;
        switch (dim) {
            case 4: {
                role = 6;
                break;
            }
            case 16: {
                role = 45;
                break;
            }
            case 23: {
                role = 68;
                break;
            }
            case 17: {
                role = 46;
                break;
            }
            case 15: {
                role = 36;
                break;
            }
            case 6: {
                role = 8;
                break;
            }
            case 21: {
                role = 111;
                break;
            }
            case 22: {
                role = 112;
                break;
            }
            case 24: {
                role = 69;
            }
        }
        return role;
    }

    public static void parseWhere(StatGraph graph, CRD crd, Overlay plot) {
        if (graph.whereExpression == null) {
            return;
        }
        if (crd.getSrcModel().name == null || graph.whereDataModelName != null && !crd.getSrcModel().name.equalsIgnoreCase(graph.whereDataModelName)) {
            return;
        }
        if (!LayoutDataLatticeParser.isSupportedInsideDataLattice(plot)) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "dpdl.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)plot.getStmt()));
            return;
        }
        crd.whereVars = graph.whereVars;
        crd.whereVarsOnSeparateModel = graph.whereVarsOnSeparateModel;
        crd.whereIncludeMissingClass = graph.whereIncludeMissingClass;
        crd.whereExpression = graph.whereExpression;
        crd.allWhereExpressions = graph.allWhereExpressions;
        plot.xUnionAllPages = plot.getXAxis().equalsIgnoreCase("x") ? graph.xUnionAllPages : graph.x2UnionAllPages;
        plot.yUnionAllPages = plot.getYAxis().equalsIgnoreCase("y") ? graph.yUnionAllPages : graph.y2UnionAllPages;
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, -1.0, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, boolean grouped) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, -1.0, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, -1.0, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, boolean grouped) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, -1.0, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, double transparency) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, transparency, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, double transparency, boolean grouped) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, transparency, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, double transparency) {
        LayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, transparency, true);
    }

    public static boolean isMissing(Object o, boolean numeric) {
        if (numeric && o.equals(".")) {
            return true;
        }
        return ((String)o).trim().equals("");
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, double transparency, boolean grouped) {
        Object[] vals;
        short newRole = role >= 0 ? role : LayoutOverlayParser.dim2role(dim);
        Object[] objectArray = vals = graph.isCASData() ? overlay.getSortedUniqueValues(newRole, 1) : overlay.getRawUniqueValues(newRole);
        if (vals == null || vals.length == 0) {
            return;
        }
        boolean numeric = StatGraph.isOLAP() ? false : overlay.getModel().getColumnClass(newRole) == Double.class;
        DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
        if (missingElem == null) {
            missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
        }
        Color missingColor = missingElem.getDefaultColor();
        Color missingContrastColor = missingElem.getContrastColor();
        int missingSymbol = missingElem.getMarkerSymbol();
        LineAttrs missingLineAttrs = new LineAttrs();
        missingLineAttrs.setColor(missingContrastColor);
        missingLineAttrs.setLinePattern(missingElem.getLineStyle());
        int missingFillPattern = FillPatternAttrs.getPattern((String)missingElem.getFillPattern());
        if (missingFillPattern < 0) {
            missingFillPattern = FillPatternAttrs.getPattern((String)"E");
        }
        Encoder encoder = null;
        DiscreteRange dr = new DiscreteRange(vals);
        HashMap table = new HashMap();
        Enumeration e = dr.getEnumeration();
        HashMap<String, Serializable> topLevels = StatGraph.isOLAP() ? new HashMap<String, Serializable>() : null;
        switch (dim) {
            case 4: 
            case 24: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            c = LayoutOverlayParser.isMissing(str, false) ? missingColor : (grouped ? graph.style.getGroupNextFillColor() : graph.style.getNextFillColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (LayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextFillColor() : graph.style.getNextFillColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency(c, transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupFillColorList() : graph.style.fillColorList;
                break;
            }
            case 16: 
            case 17: 
            case 23: 
            case 25: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            c = LayoutOverlayParser.isMissing(str, false) ? missingContrastColor : (grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (LayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingContrastColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency(c, transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupContrastColorList() : graph.style.contrastColorList;
                break;
            }
            case 15: {
                while (e.hasMoreElements()) {
                    LineAttrs la;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            la = LayoutOverlayParser.isMissing(str, false) ? missingLineAttrs : (grouped ? graph.style.getGroupNextLineStyle() : graph.style.getNextLineStyle());
                            topLevels.put(str, (Serializable)la);
                        } else {
                            la = (LineAttrs)topLevels.get(str);
                        }
                    } else {
                        la = LayoutOverlayParser.isMissing(o, numeric) ? missingLineAttrs : (grouped ? graph.style.getGroupNextLineStyle() : graph.style.getNextLineStyle());
                    }
                    table.put(o, (Serializable)la);
                }
                encoder = new LineEncoder(dr, table);
                ((LineEncoder)encoder).styleArray = grouped ? graph.style.getGroupLineStyleList() : graph.style.lineStyleList;
                break;
            }
            case 6: {
                while (e.hasMoreElements()) {
                    Integer ms;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            ms = LayoutOverlayParser.isMissing(str, false) ? new Integer(missingSymbol) : new Integer(grouped ? graph.style.getGroupNextMarkerSymbol() : graph.style.getNextMarkerSymbol());
                            topLevels.put(str, ms);
                        } else {
                            ms = (Integer)topLevels.get(str);
                        }
                    } else {
                        ms = LayoutOverlayParser.isMissing(o, numeric) ? new Integer(missingSymbol) : new Integer(grouped ? graph.style.getGroupNextMarkerSymbol() : graph.style.getNextMarkerSymbol());
                    }
                    table.put(o, ms);
                }
                encoder = new ShapeEncoder(dr, table);
                ((ShapeEncoder)encoder).shapeArray = grouped ? graph.style.getGroupMarkerSymbolList() : graph.style.markerSymbolList;
                break;
            }
            case 21: {
                while (e.hasMoreElements()) {
                    Integer fp;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            fp = LayoutOverlayParser.isMissing(str, false) ? new Integer(missingFillPattern) : new Integer(grouped ? graph.style.getGroupNextFillPattern() : graph.style.getNextFillPattern());
                            topLevels.put(str, fp);
                        } else {
                            fp = (Integer)topLevels.get(str);
                        }
                    } else {
                        fp = LayoutOverlayParser.isMissing(o, numeric) ? new Integer(missingFillPattern) : new Integer(grouped ? graph.style.getGroupNextFillPattern() : graph.style.getNextFillPattern());
                    }
                    table.put(o, fp);
                }
                encoder = new FillPatternEncoder(dr, table);
                ((FillPatternEncoder)encoder).patternArray = grouped ? graph.style.getGroupFillPatternList() : graph.style.fillPatternList;
                break;
            }
            case 22: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)o);
                        if (!topLevels.containsKey(str)) {
                            c = LayoutOverlayParser.isMissing(str, false) ? missingContrastColor : (grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (LayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingContrastColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency(c, transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupContrastColorList() : graph.style.contrastColorList;
            }
        }
        overlay.setEncoder(dim, encoder);
    }

    public static void setContinuousEncoder(StatGraph graph, Overlay overlay, byte dim) {
        DataRange range = overlay.getDataRange(dim);
        if (range instanceof ContinuousRange) {
            PositionEncoder encoder = new PositionEncoder((DataRange)((ContinuousRange)range));
            overlay.setEncoder(dim, encoder);
        }
    }

    public static boolean isIndexVarAssigned(CRD crd) {
        return crd.isAvailable(42) || crd.isAvailable(41) || crd.isAvailable(43) || crd.isAvailable(44);
    }

    public static void resolveReferences(Container container, Component oldComponent, Component[] newComponents) {
        OverlayContainer oc = null;
        String name = null;
        if (container instanceof OverlayContainer) {
            oc = (OverlayContainer)container;
        }
        Component[] components = container.getComponents();
        int index = -1;
        for (int i = 0; index < 0 && i < components.length; ++i) {
            if (!components[i].equals(oldComponent)) continue;
            index = i;
            if (oc == null) continue;
            name = oc.getLayoutComponentName(oldComponent);
        }
        container.remove(oldComponent);
        if (name != null) {
            oc.add(newComponents[newComponents.length - 1], index, name);
        } else {
            container.add(newComponents[newComponents.length - 1], index);
        }
    }

    public static boolean hasGraphElement(Element elem) {
        return LayoutOverlayParser.getFirstPlot(elem) != null;
    }

    public static String getFirstPlot(Element elem) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("ScatterPlot")) {
                return elemTag;
            }
            if (elemTag.equals("TextPlot")) {
                return elemTag;
            }
            if (elemTag.equals("SeriesPlot")) {
                return elemTag;
            }
            if (elemTag.equals("StepPlot")) {
                return elemTag;
            }
            if (elemTag.equals("NeedlePlot")) {
                return elemTag;
            }
            if (elemTag.equals("VectorPlot")) {
                return elemTag;
            }
            if (elemTag.equals("BandPlot")) {
                return elemTag;
            }
            if (elemTag.equals("BoxPlotParm") || elemTag.equals("BoxParm")) {
                return elemTag;
            }
            if (elemTag.equals("HistogramParm")) {
                return elemTag;
            }
            if (elemTag.equals("LineParm")) {
                return elemTag;
            }
            if (elemTag.equals("ReferenceLine")) {
                return elemTag;
            }
            if (elemTag.equals("DropLine")) {
                return elemTag;
            }
            if (elemTag.equals("EllipseParm")) {
                return elemTag;
            }
            if (elemTag.equals("ContourPlotParm") || elemTag.equals("ContourParm")) {
                return elemTag;
            }
            if (elemTag.equals("BarChartParm") || elemTag.equals("BarParm")) {
                return elemTag;
            }
            if (elemTag.equals("ParetoLine")) {
                return elemTag;
            }
            if (elemTag.equals("HeatmapParm")) {
                return elemTag;
            }
            if (elemTag.equals("WaterfallChart")) {
                return elemTag;
            }
            if (elemTag.equals("Dendrogram")) {
                return elemTag;
            }
            if (elemTag.equals("BubblePlot")) {
                return elemTag;
            }
            if (elemTag.equals("PieChartParm")) {
                return elemTag;
            }
            if (elemTag.equals("FringePlot")) {
                return elemTag;
            }
            if (elemTag.equals("BlockPlot")) {
                return elemTag;
            }
            if (elemTag.equals("AxisTable")) {
                return elemTag;
            }
            if (elemTag.equals("HighLowPlot")) {
                return elemTag;
            }
            if (elemTag.equals("HeatBoxParm")) {
                return elemTag;
            }
            if (elemTag.equals("LineChart")) {
                return elemTag;
            }
            if (elemTag.equals("RangeAttrMapView")) {
                return elemTag;
            }
            if (elemTag.equals("TimeSeriesPlot")) {
                return elemTag;
            }
            if (elemTag.equals("PolygonPlot")) {
                return elemTag;
            }
            if (!elemTag.equals("InnerMargin")) continue;
            return LayoutOverlayParser.getFirstPlot((Element)node);
        }
        return null;
    }

    public static void parseRoleTipStuff(Element elem, DataModel model, RoleColumnMap map, Overlay overlay) {
        String str;
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement(elem, "Roles");
        if (roleElem != null) {
            LayoutOverlayParser.parseRoleNames(roleElem, model, overlay);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement(elem, "TipFormats")) != null) {
            LayoutOverlayParser.parseTipFormats(formatElem, overlay);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement(elem, "TipLabels")) != null) {
            LayoutOverlayParser.parseTipLabels(labelElem, overlay);
        }
        if ((str = elem.getAttribute("tip")).length() > 0) {
            if (str.equalsIgnoreCase("NONE")) {
                overlay.setTooltipEnabled(false);
            }
            String[] tipRoles = StatGraph.parseList2String(str);
            int cnt = 0;
            HashMap<Integer, String> roleMap = new HashMap<Integer, String>();
            for (int i = 0; i < tipRoles.length; ++i) {
                ColumnMetadata cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(300 + cnt), tipRoles[i]);
                String tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(300 + cnt++, tipcol);
            }
            overlay.setTipRoleMap(roleMap);
        }
    }

    public static void parseRoleNames(Element elem, DataModel model, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String name = child.getNodeValue();
            String varID = StatGraph.getVarID(name);
            int col = model.getColumn(varID);
            if (!model.hasColumn(varID)) continue;
            overlay.addRole(role.toUpperCase(), model.getColumnLabel(col));
        }
    }

    public static void parseTipFormats(Element elem, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String format = child.getNodeValue();
            ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setFormat(format);
        }
    }

    public static void parseTipLabels(Element elem, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String label = child.getNodeValue();
            ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setLabel(label);
        }
    }

    public static Component createMessage() {
        RotatedJTextPane textPane = new RotatedJTextPane();
        textPane.setOpaque(false);
        textPane.setText("Required plot is invalid, all plots are removed.");
        return textPane;
    }

    public static void decideAxesType(StatGraph graph, Element elem, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        Node node;
        boolean overlay3D = elem.getTagName().equals("LayoutOverlay3D");
        boolean userSetXType = false;
        boolean userSetX2Type = overlay3D;
        boolean userSetYType = false;
        boolean userSetY2Type = overlay3D;
        boolean userSetZType = !overlay3D;
        String elemTag = "";
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("XAxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "XAxisOpts", false, true)) {
                userSetXType = LayoutOverlayParser.isUserSetAxisType((Element)node, "X");
                continue;
            }
            if (elemTag.equals("X2AxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "X2AxisOpts", false, false)) {
                userSetX2Type = LayoutOverlayParser.isUserSetAxisType((Element)node, "X2");
                continue;
            }
            if (elemTag.equals("YAxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "YAxisOpts", true, true)) {
                userSetYType = LayoutOverlayParser.isUserSetAxisType((Element)node, "Y");
                continue;
            }
            if (elemTag.equals("Y2AxisOpts") && LayoutOverlayParser.isAxisOptsApplicable(elem, "Y2AxisOpts", true, false)) {
                userSetY2Type = LayoutOverlayParser.isUserSetAxisType((Element)node, "Y2");
                continue;
            }
            if (!elemTag.equals("ZAxisOpts")) continue;
            userSetZType = LayoutOverlayParser.isUserSetAxisType((Element)node, "Z");
        }
        if (rowColumnAxesType != null) {
            if (rowColumnAxesType[0] != -1) {
                userSetYType = true;
                yAxisType = rowColumnAxesType[0];
            }
            if (rowColumnAxesType[1] != -1) {
                userSetXType = true;
                xAxisType = rowColumnAxesType[1];
            }
        }
        if (rowColumn2AxesType != null) {
            if (rowColumn2AxesType[0] != -1) {
                userSetY2Type = true;
                y2AxisType = rowColumn2AxesType[0];
            }
            if (rowColumn2AxesType[1] != -1) {
                userSetX2Type = true;
                x2AxisType = rowColumn2AxesType[1];
            }
        }
        if (userSetXType && userSetX2Type && userSetYType && userSetY2Type && userSetZType) {
            return;
        }
        boolean[] defined = new boolean[]{userSetXType, userSetX2Type, userSetYType, userSetY2Type, userSetZType};
        for (node = elem.getLastChild(); node != null; node = node.getPreviousSibling()) {
            String str;
            if (!(node instanceof Element) || !LayoutOverlayParser.isPrimaryPlot((Element)node) || !(str = ((Element)node).getAttribute("primary")).equalsIgnoreCase("true")) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            boolean z = false;
            str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            if (overlay3D && !userSetZType) {
                z = true;
            }
            LayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, z, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            userSetZType = defined[4];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
            return;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !LayoutOverlayParser.isPrimaryPlot((Element)node)) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            boolean z = false;
            String str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            if (overlay3D && !userSetZType) {
                z = true;
            }
            LayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, z, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            userSetZType = defined[4];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
            return;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !LayoutOverlayParser.isOneDimensionalPlot((Element)node)) continue;
            LayoutOverlayParser.requiredAxesTypesBy1DPlots(graph, (Element)node, userSetXType, userSetX2Type, userSetYType, userSetY2Type, userSetZType, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            userSetZType = defined[4];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
            return;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("InnerMargin")) continue;
            for (Node node2 = ((Element)node).getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element) || !LayoutOverlayParser.isOneDimensionalPlot((Element)node2)) continue;
                LayoutOverlayParser.requiredAxesTypesBy1DPlots(graph, (Element)node2, userSetXType, userSetX2Type, userSetYType, userSetY2Type, userSetZType, defined);
                userSetXType = defined[0];
                userSetX2Type = defined[1];
                userSetYType = defined[2];
                userSetY2Type = defined[3];
                userSetZType = defined[4];
                if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
                return;
            }
        }
    }

    private static void requiredAxesTypesBy1DPlots(StatGraph graph, Element elem, boolean xTypeSet, boolean x2TypeSet, boolean yTypeSet, boolean y2TypeSet, boolean zTypeSet, boolean[] defined) {
        boolean horizontalSide = true;
        String elemTag = elem.getTagName();
        if (elemTag.equals("AxisTable") && !elem.hasAttribute("x")) {
            horizontalSide = false;
        }
        boolean x = false;
        boolean x2 = false;
        boolean y = false;
        boolean y2 = false;
        boolean z = false;
        if (horizontalSide) {
            String str = elem.getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!x2TypeSet) {
                    x2 = true;
                }
            } else if (!xTypeSet) {
                x = true;
            }
        } else {
            String str = elem.getAttribute("yAxis");
            if (str.equalsIgnoreCase("Y2")) {
                if (!y2TypeSet) {
                    y2 = true;
                }
            } else if (!yTypeSet) {
                y = true;
            }
        }
        LayoutOverlayParser.requiredAxesTypeByPlot(graph, elem, x, x2, y, y2, z, defined);
    }

    public static void requiredAxesTypeByPlot(StatGraph graph, Element elem, boolean x, boolean x2, boolean y, boolean y2, boolean z, boolean[] defined) {
        int[] types;
        if (!(x || x2 || y || y2 || z)) {
            return;
        }
        String elemTag = elem.getTagName();
        if (elemTag.equals("ScatterPlot") || elemTag.equals("TextPlot") || elemTag.equals("SeriesPlot")) {
            int[] types2 = ScatterParser.getVariableTypes(graph, elem);
            if (types2 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types2, defined);
            }
        } else if (elemTag.equals("StepPlot") || elemTag.equals("NeedlePlot")) {
            int[] types3 = ScatterParser.getVariableTypes(graph, elem);
            if (types3 != null && types3[1] != 2) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types3, defined);
            }
        } else if (elemTag.equals("VectorPlot") || elemTag.equals("HistogramParm") || elemTag.equals("ContourPlotParm") || elemTag.equals("ContourParm")) {
            int[] types4 = ScatterParser.getVariableTypes(graph, elem);
            if (types4 != null && types4[0] != 2 && types4[1] != 2) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types4, defined);
            }
        } else if (elemTag.equals("BandPlot")) {
            int[] types5 = BandParser.getVariableTypes(graph, elem);
            if (types5 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types5, defined);
            }
        } else if (elemTag.equals("BarChartParm") || elemTag.equals("BarParm")) {
            int[] types6 = BarParser.getVariableTypes(graph, elem);
            if (types6 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types6, defined);
            }
        } else if (elemTag.equals("ParetoLine")) {
            int[] types7 = BarParser.getVariableTypes(graph, elem);
            if (types7 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types7, defined);
            }
        } else if (elemTag.equals("HeatmapParm")) {
            int[] types8 = HeatMapParmParser.getVariableTypes(graph, elem);
            if (types8 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types8, defined);
            }
        } else if (elemTag.equals("WaterfallChart")) {
            int[] types9 = WaterFallChartParser.getVariableTypes(graph, elem);
            if (types9 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types9, defined);
            }
        } else if (elemTag.equals("Dendrogram")) {
            int[] types10 = DendrogramParser.getVariableTypes(graph, elem);
            if (types10 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types10, defined);
            }
        } else if (elemTag.equals("BubblePlot")) {
            int[] types11 = BubbleParser.getVariableTypes(graph, elem);
            if (types11 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types11, defined);
            }
        } else if (elemTag.equals("BoxPlotParm") || elemTag.equals("BoxParm")) {
            int[] types12 = BoxParser.getVariableTypes(graph, elem);
            if (types12 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types12, defined);
            }
        } else if (elemTag.equals("SurfacePlotParm") || elemTag.equals("SurfaceParm")) {
            int[] types13 = SurfaceParser.getVariableTypes(graph, elem);
            if (types13 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types13, defined);
            }
        } else if (elemTag.equals("BiHistogram3DParm")) {
            int[] types14 = SurfaceParser.getVariableTypes(graph, elem);
            if (types14 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types14, defined);
            }
        } else if (elemTag.equals("HighLowPlot")) {
            int[] types15 = HighLowParser.getVariableTypes(graph, elem);
            if (types15 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types15, defined);
            }
        } else if (elemTag.equals("HeatBoxParm")) {
            int[] types16 = HeatBoxParser.getVariableTypes(graph, elem);
            if (types16 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types16, defined);
            }
        } else if (elemTag.equals("LineChart")) {
            int[] types17 = LineChartParser.getVariableTypes(graph, elem);
            if (types17 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types17, defined);
            }
        } else if (elemTag.equals("TimeSeriesPlot")) {
            int[] types18 = TimeSeriesParser.getVariableTypes(graph, elem);
            if (types18 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types18, defined);
            }
        } else if (elemTag.equals("AxisTable")) {
            int[] types19 = AxisTableParser.getVariableTypes(graph, elem);
            if (types19 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types19, defined);
            }
        } else if (elemTag.equals("BlockPlot") || elemTag.equals("FringePlot")) {
            int[] types20 = BlockParser.getVariableTypes(graph, elem);
            if (types20 != null) {
                LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types20, defined);
            }
        } else if (elemTag.equals("PolygonPlot") && (types = PolygonParser.getVariableTypes(graph, elem)) != null) {
            LayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types, defined);
        }
    }

    private static void setAxisTypes(boolean x, boolean x2, boolean y, boolean y2, boolean z, int[] types, boolean[] defined) {
        if (x) {
            xAxisType = types[0];
            defined[0] = true;
        }
        if (x2) {
            x2AxisType = types[0];
            defined[1] = true;
        }
        if (y) {
            yAxisType = types[1];
            defined[2] = true;
        }
        if (y2) {
            y2AxisType = types[1];
            defined[3] = true;
        }
        if (z) {
            zAxisType = types[2];
            defined[4] = true;
        }
    }

    public static boolean isPrimaryPlot(Element elem) {
        String elemTag = elem.getTagName();
        return elemTag.equals("ScatterPlot") || elemTag.equals("TextPlot") || elemTag.equals("SeriesPlot") || elemTag.equals("StepPlot") || elemTag.equals("NeedlePlot") || elemTag.equals("VectorPlot") || elemTag.equals("BandPlot") || elemTag.equals("HistogramParm") || elemTag.equals("BarChartParm") || elemTag.equals("BarParm") || elemTag.equals("WaterfallChart") || elemTag.equals("Dendrogram") || elemTag.equals("BubblePlot") || elemTag.equals("ParetoLine") || elemTag.equals("HeatmapParm") || elemTag.equals("BoxPlotParm") || elemTag.equals("BoxParm") || elemTag.equals("HighLowPlot") || elemTag.equals("HeatBoxParm") || elemTag.equals("LineChart") || elemTag.equals("TimeSeriesPlot") || elemTag.equals("ContourPlotParm") || elemTag.equals("ContourParm") || elemTag.equals("SurfacePlotParm") || elemTag.equals("SurfaceParm") || elemTag.equals("BiHistogram3DParm") || elemTag.equals("PolygonPlot");
    }

    public static boolean isOneDimensionalPlot(Element elem) {
        String elemTag = elem.getTagName();
        return elemTag.equals("BlockPlot") || elemTag.equals("FringePlot") || elemTag.equals("AxisTable");
    }

    public static boolean isUserSetAxisType(Element elem, String which) {
        boolean userSet = false;
        int type = 0;
        String str = elem.getAttribute("type");
        if (str.equalsIgnoreCase("LINEAR")) {
            type = 0;
            userSet = true;
        } else if (str.equalsIgnoreCase("TIME")) {
            type = 1;
            userSet = true;
        } else if (str.equalsIgnoreCase("DISCRETE")) {
            type = 2;
            userSet = true;
        } else if (str.equalsIgnoreCase("LOG")) {
            type = 3;
            userSet = true;
            String elemTag = "";
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("LogOpts")) continue;
                double base = -1.0;
                str = ((Element)node).getAttribute("base");
                if (StatGraph.isNumber(str)) {
                    base = Double.parseDouble(str);
                } else if (str.length() > 0 && str.equalsIgnoreCase("E")) {
                    base = Math.E;
                }
                if (base != 10.0 && base != 2.0 && base != Math.E) continue;
                if (which.equals("X")) {
                    logBaseX = base;
                    continue;
                }
                if (which.equals("X2")) {
                    logBaseX2 = base;
                    continue;
                }
                if (which.equals("Y")) {
                    logBaseY = base;
                    continue;
                }
                if (!which.equals("Y2")) continue;
                logBaseY2 = base;
            }
        }
        if (which.equals("X")) {
            xAxisType = type;
        } else if (which.equals("X2")) {
            x2AxisType = type;
        } else if (which.equals("Y")) {
            yAxisType = type;
        } else if (which.equals("Y2")) {
            y2AxisType = type;
        } else if (which.equals("Z")) {
            zAxisType = type;
        }
        return userSet;
    }

    public static void checkLocation(String loc) {
        if (loc.length() > 0 && !loc.equalsIgnoreCase("outside") && !loc.equalsIgnoreCase("inside")) {
            StatGraph.printOptionError("LOCATION", loc);
        }
    }

    public static void parseWallColor(StatGraph graph, Element elem, FillAttrs fillStyle) {
        GraphStyle.setDefaultFillStyle(graph, "", fillStyle, "WallFill");
        if (elem.hasAttribute("wallColor")) {
            Color wc = StatGraph.parseAttrColor("wallColor", graph, elem);
            if (wc != null) {
                fillStyle.setColor(wc);
            }
        }
    }

    static ContinuousRange[] parseIncludeRanges(StatGraph graph, Element elem) {
        ArrayList<ContinuousRange> rlist = new ArrayList<ContinuousRange>();
        double minRange = Double.MAX_VALUE;
        double maxRange = -1.7976931348623157E308;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element elem2 = (Element)node;
            double min = Double.NaN;
            double max = Double.NaN;
            boolean minExclude = false;
            boolean maxExclude = false;
            String str = elem2.getAttribute("minValue");
            if (StatGraph.isNumber(str)) {
                min = Double.parseDouble(str);
            } else if (str.equalsIgnoreCase("MIN")) {
                min = BrokenPositionEncoder.DATA_MIN;
            }
            str = elem2.getAttribute("maxValue");
            if (StatGraph.isNumber(str)) {
                max = Double.parseDouble(str);
            } else if (str.equalsIgnoreCase("MAX")) {
                max = BrokenPositionEncoder.DATA_MAX;
            }
            str = elem2.getAttribute("minExclude");
            if (str.equalsIgnoreCase("true")) {
                minExclude = true;
            }
            if ((str = elem2.getAttribute("maxExclude")).equalsIgnoreCase("true")) {
                maxExclude = true;
            }
            if (Double.isNaN(min) || Double.isNaN(max) || !(min < max)) continue;
            ContinuousRange cr = new ContinuousRange(min, max);
            cr.setMinExclude(minExclude);
            cr.setMaxExclude(maxExclude);
            if (min != BrokenPositionEncoder.DATA_MIN && max != BrokenPositionEncoder.DATA_MAX) {
                minRange = Math.min(minRange, max - min);
                maxRange = Math.max(maxRange, max - min);
            }
            for (int i = 0; i < rlist.size(); ++i) {
                ContinuousRange ran = (ContinuousRange)rlist.get(i);
                double mi = ran.getMin();
                double ma = ran.getMax();
                if (min > mi && min < ma || max > mi && max < ma) {
                    return null;
                }
                if ((min != ma || !minExclude || !ran.isMaxExclude()) && (max != mi || !maxExclude || !ran.isMinExclude())) continue;
                return null;
            }
            rlist.add(cr);
        }
        if (maxRange / minRange > 10000.0) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "includeranges.txt"));
            return null;
        }
        if (rlist.size() > 0) {
            ArrayList sortList = new ArrayList();
            sortList.add(rlist.get(0));
            for (int i = 1; i < rlist.size(); ++i) {
                double min = ((ContinuousRange)rlist.get(i)).getMin();
                int idx = sortList.size();
                for (int j = 0; j < idx; ++j) {
                    double mi = ((ContinuousRange)sortList.get(j)).getMin();
                    if (!(min < mi)) continue;
                    idx = j;
                    break;
                }
                sortList.add(idx, rlist.get(i));
            }
            if (sortList.size() > 1) {
                ContinuousRange cr1 = (ContinuousRange)sortList.get(0);
                int i = 1;
                while (i < sortList.size()) {
                    ContinuousRange cr2 = (ContinuousRange)sortList.get(i);
                    if (cr2.getMin() == cr1.getMax()) {
                        cr1.setMax(cr2.getMax());
                        sortList.remove(i);
                        continue;
                    }
                    cr1 = cr2;
                    ++i;
                }
            }
            ContinuousRange[] ranges = new ContinuousRange[sortList.size()];
            for (int i = 0; i < sortList.size(); ++i) {
                ranges[i] = (ContinuousRange)sortList.get(i);
            }
            return ranges;
        }
        return null;
    }

    public static String getLayoutName(Node node) {
        if (node.getNodeName().startsWith("Layout")) {
            return node.getNodeName().substring(6).toUpperCase();
        }
        return node.getNodeName();
    }

    public static boolean hasTooManyGroups(StatGraph graph, DataModel model, String groupVar, String stmt) {
        return LayoutOverlayParser.hasTooManyUniqueValues(graph, model, groupVar, "GROUP", stmt);
    }

    public static boolean hasTooManyCategories(StatGraph graph, DataModel model, String categoryVar) {
        return LayoutOverlayParser.hasTooManyUniqueValues(graph, model, categoryVar, "DISCRETE", null);
    }

    public static boolean hasTooManyUniqueValues(StatGraph graph, DataModel model, String varID, String type, String stmt) {
        int maximum;
        if (varID.length() <= 0) {
            return false;
        }
        int col = model.getColumn(varID);
        String[] values = model.getColumnAsClassColumn(col, true);
        StringVectorVariable var = new StringVectorVariable();
        var.connectFrom(values);
        int n = var.getUniqueValueCount();
        int n2 = maximum = type.equalsIgnoreCase("DISCRETE") ? graph.discreteMax : graph.groupMax;
        if (n > maximum) {
            if (!type.equalsIgnoreCase("DISCRETE")) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "group.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)type.toUpperCase(), (Object)varID, (Object)stmt, (Object)StatGraph.roundToNextHundreds(n)));
            }
            return true;
        }
        return false;
    }

    private static boolean isVRef(ReferenceLineOverlay ref) {
        if (ref.getXValue() != null) {
            return true;
        }
        if (ref.getYValue() != null) {
            return false;
        }
        return ref.getModel().isAvailable(10);
    }

    private static boolean isAxisOptsApplicable(Element layoutElem, String axisOpts, boolean vertical, boolean primary) {
        String range;
        if (StatGraph.getOptionAttrsElement(layoutElem, axisOpts) == null) {
            return false;
        }
        if (!layoutElem.getNodeName().equalsIgnoreCase("LayoutOverlay")) {
            return true;
        }
        Element parentElem = (Element)layoutElem.getParentNode();
        if (!parentElem.getNodeName().equals("LayoutLattice")) {
            return true;
        }
        return !(vertical ? (primary ? ((range = parentElem.getAttribute("rowDataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "RowAxes") != null : ((range = parentElem.getAttribute("row2DataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "Row2Axes") != null) : (primary ? ((range = parentElem.getAttribute("columnDataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "ColumnAxes") != null : ((range = parentElem.getAttribute("column2DataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "Column2Axes") != null));
    }

    private static boolean hasAxisOpts(Element layoutElem, String axisOpts, boolean vertical, boolean primary) {
        String range;
        if (!layoutElem.getNodeName().equalsIgnoreCase("LayoutOverlay")) {
            return StatGraph.getOptionAttrsElement(layoutElem, axisOpts) != null;
        }
        Element parentElem = (Element)layoutElem.getParentNode();
        if (!parentElem.getNodeName().equals("LayoutLattice")) {
            return StatGraph.getOptionAttrsElement(layoutElem, axisOpts) != null;
        }
        return vertical ? (primary ? ((range = parentElem.getAttribute("rowDataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "RowAxes") != null : ((range = parentElem.getAttribute("row2DataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "Row2Axes") != null) : (primary ? ((range = parentElem.getAttribute("columnDataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "ColumnAxes") != null : ((range = parentElem.getAttribute("column2DataRange")).equalsIgnoreCase("UNION") || range.equalsIgnoreCase("UNIONALL")) && StatGraph.getOptionAttrsElement(parentElem, "Column2Axes") != null);
    }

    private static void setAxisBreakType(StatGraph graph, VRectAxis axis, Simple2DOverlayComposite soc) {
        if (axis != null && axis.isBrokenAxis() && (soc.getWall().isEdgeOn() || axis.getAxisStyle().isAxisLineOn())) {
            axis.setBrokenAxisHash(graph.getAxisBreakSymbol());
        }
    }

    public static void parseUserViewportParams(StatGraph graph, Element elem, OverlayContainer oc) {
        OverlayContainer.UserViewportParams params = new OverlayContainer.UserViewportParams(oc);
        String str = elem.getAttribute("XAxisViewportMin");
        if (StatGraph.isNumber(str)) {
            params.viewportMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("XAxisViewportMax"))) {
            params.viewportMax = Double.parseDouble(str);
        }
        str = elem.getAttribute("XAxisViewportTicks");
        params.viewportTicks = LayoutOverlayParser.stringToDoubleArray(str);
        str = elem.getAttribute("XAxisStartOffset");
        if (StatGraph.isNumber(str)) {
            params.startOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("XAxisStrideOffset"))) {
            params.strideOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("XAxisOffsetMin"))) {
            params.offsetMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("XAxisOffsetMax"))) {
            params.offsetMax = Double.parseDouble(str);
        }
        if (params.hasUserSetViewport()) {
            oc.setUserViewportParams(params, 0);
        }
        params = new OverlayContainer.UserViewportParams(oc);
        str = elem.getAttribute("X2AxisViewportMin");
        if (StatGraph.isNumber(str)) {
            params.viewportMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("X2AxisViewportMax"))) {
            params.viewportMax = Double.parseDouble(str);
        }
        str = elem.getAttribute("X2AxisViewportTicks");
        params.viewportTicks = LayoutOverlayParser.stringToDoubleArray(str);
        str = elem.getAttribute("X2AxisStartOffset");
        if (StatGraph.isNumber(str)) {
            params.startOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("X2AxisStrideOffset"))) {
            params.strideOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("X2AxisOffsetMin"))) {
            params.offsetMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("X2AxisOffsetMax"))) {
            params.offsetMax = Double.parseDouble(str);
        }
        if (params.hasUserSetViewport()) {
            oc.setUserViewportParams(params, 1);
        }
        params = new OverlayContainer.UserViewportParams(oc);
        str = elem.getAttribute("YAxisViewportMin");
        if (StatGraph.isNumber(str)) {
            params.viewportMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("YAxisViewportMax"))) {
            params.viewportMax = Double.parseDouble(str);
        }
        str = elem.getAttribute("YAxisViewportTicks");
        params.viewportTicks = LayoutOverlayParser.stringToDoubleArray(str);
        str = elem.getAttribute("YAxisStartOffset");
        if (StatGraph.isNumber(str)) {
            params.startOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("YAxisStrideOffset"))) {
            params.strideOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("YAxisOffsetMin"))) {
            params.offsetMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("YAxisOffsetMax"))) {
            params.offsetMax = Double.parseDouble(str);
        }
        if (params.hasUserSetViewport()) {
            oc.setUserViewportParams(params, 2);
        }
        params = new OverlayContainer.UserViewportParams(oc);
        str = elem.getAttribute("Y2AxisViewportMin");
        if (StatGraph.isNumber(str)) {
            params.viewportMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("Y2AxisViewportMax"))) {
            params.viewportMax = Double.parseDouble(str);
        }
        str = elem.getAttribute("Y2AxisViewportTicks");
        params.viewportTicks = LayoutOverlayParser.stringToDoubleArray(str);
        str = elem.getAttribute("Y2AxisStartOffset");
        if (StatGraph.isNumber(str)) {
            params.startOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("Y2AxisStrideOffset"))) {
            params.strideOffset = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("Y2AxisOffsetMin"))) {
            params.offsetMin = Double.parseDouble(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("Y2AxisOffsetMax"))) {
            params.offsetMax = Double.parseDouble(str);
        }
        if (params.hasUserSetViewport()) {
            oc.setUserViewportParams(params, 3);
        }
    }

    private static double[] stringToDoubleArray(String str) {
        String[] s = str.split(" ");
        double[] v = new double[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                v[i] = Double.parseDouble(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return v;
    }

    public static void scriptUserViewportParams(Element elem, OverlayContainer oc) {
        OverlayContainer.UserViewportParams params = oc.getUserViewportParams(0);
        if (params != null) {
            if (!Double.isNaN(params.viewportMin)) {
                elem.setAttribute("XAxisViewportMin", Double.toString(params.viewportMin));
            }
            if (!Double.isNaN(params.viewportMax)) {
                elem.setAttribute("XAxisViewportMax", Double.toString(params.viewportMax));
            }
            if (params.viewportTicks != null) {
                elem.setAttribute("XAxisViewportTicks", LayoutOverlayParser.doubleArrayToString(params.viewportTicks));
            }
            if (!Double.isNaN(params.startOffset)) {
                elem.setAttribute("XAxisStartOffset", Double.toString(params.startOffset));
            }
            if (!Double.isNaN(params.strideOffset)) {
                elem.setAttribute("XAxisStrideOffset", Double.toString(params.strideOffset));
            }
            if (!Double.isNaN(params.offsetMin)) {
                elem.setAttribute("XAxisOffsetMin", Double.toString(params.offsetMin));
            }
            if (!Double.isNaN(params.offsetMax)) {
                elem.setAttribute("XAxisOffsetMax", Double.toString(params.offsetMax));
            }
        }
        if ((params = oc.getUserViewportParams(1)) != null) {
            if (!Double.isNaN(params.viewportMin)) {
                elem.setAttribute("X2AxisViewportMin", Double.toString(params.viewportMin));
            }
            if (!Double.isNaN(params.viewportMax)) {
                elem.setAttribute("X2AxisViewportMax", Double.toString(params.viewportMax));
            }
            if (params.viewportTicks != null) {
                elem.setAttribute("X2AxisViewportTicks", LayoutOverlayParser.doubleArrayToString(params.viewportTicks));
            }
            if (!Double.isNaN(params.startOffset)) {
                elem.setAttribute("X2AxisStartOffset", Double.toString(params.startOffset));
            }
            if (!Double.isNaN(params.strideOffset)) {
                elem.setAttribute("X2AxisStrideOffset", Double.toString(params.strideOffset));
            }
            if (!Double.isNaN(params.offsetMin)) {
                elem.setAttribute("X2AxisOffsetMin", Double.toString(params.offsetMin));
            }
            if (!Double.isNaN(params.offsetMax)) {
                elem.setAttribute("X2AxisOffsetMax", Double.toString(params.offsetMax));
            }
        }
        if ((params = oc.getUserViewportParams(2)) != null) {
            if (!Double.isNaN(params.viewportMin)) {
                elem.setAttribute("YAxisViewportMin", Double.toString(params.viewportMin));
            }
            if (!Double.isNaN(params.viewportMax)) {
                elem.setAttribute("YAxisViewportMax", Double.toString(params.viewportMax));
            }
            if (params.viewportTicks != null) {
                elem.setAttribute("YAxisViewportTicks", LayoutOverlayParser.doubleArrayToString(params.viewportTicks));
            }
            if (!Double.isNaN(params.startOffset)) {
                elem.setAttribute("YAxisStartOffset", Double.toString(params.startOffset));
            }
            if (!Double.isNaN(params.strideOffset)) {
                elem.setAttribute("YAxisStrideOffset", Double.toString(params.strideOffset));
            }
            if (!Double.isNaN(params.offsetMin)) {
                elem.setAttribute("YAxisOffsetMin", Double.toString(params.offsetMin));
            }
            if (!Double.isNaN(params.offsetMax)) {
                elem.setAttribute("YAxisOffsetMax", Double.toString(params.offsetMax));
            }
        }
        if ((params = oc.getUserViewportParams(3)) != null && params.hasUserSetViewport(3)) {
            if (!Double.isNaN(params.viewportMin)) {
                elem.setAttribute("Y2AxisViewportMin", Double.toString(params.viewportMin));
            }
            if (!Double.isNaN(params.viewportMax)) {
                elem.setAttribute("Y2AxisViewportMax", Double.toString(params.viewportMax));
            }
            if (params.viewportTicks != null) {
                elem.setAttribute("Y2AxisViewportTicks", LayoutOverlayParser.doubleArrayToString(params.viewportTicks));
            }
            if (!Double.isNaN(params.startOffset)) {
                elem.setAttribute("Y2AxisStartOffset", Double.toString(params.startOffset));
            }
            if (!Double.isNaN(params.strideOffset)) {
                elem.setAttribute("Y2AxisStrideOffset", Double.toString(params.strideOffset));
            }
            if (!Double.isNaN(params.offsetMin)) {
                elem.setAttribute("Y2AxisOffsetMin", Double.toString(params.offsetMin));
            }
            if (!Double.isNaN(params.offsetMax)) {
                elem.setAttribute("Y2AxisOffsetMax", Double.toString(params.offsetMax));
            }
        }
    }

    public static void clearViewportParams(Element elem) {
        if (elem.hasAttribute("XAxisViewportMin")) {
            elem.removeAttribute("XAxisViewportMin");
        }
        if (elem.hasAttribute("XAxisViewportMax")) {
            elem.removeAttribute("XAxisViewportMax");
        }
        if (elem.hasAttribute("XAxisViewportTicks")) {
            elem.removeAttribute("XAxisViewportTicks");
        }
        if (elem.hasAttribute("XAxisStartOffset")) {
            elem.removeAttribute("XAxisStartOffset");
        }
        if (elem.hasAttribute("XAxisStrideOffset")) {
            elem.removeAttribute("XAxisStrideOffset");
        }
        if (elem.hasAttribute("XAxisOffsetMin")) {
            elem.removeAttribute("XAxisOffsetMin");
        }
        if (elem.hasAttribute("XAxisOffsetMax")) {
            elem.removeAttribute("XAxisOffsetMax");
        }
        if (elem.hasAttribute("X2AxisViewportMin")) {
            elem.removeAttribute("X2AxisViewportMin");
        }
        if (elem.hasAttribute("X2AxisViewportMax")) {
            elem.removeAttribute("X2AxisViewportMax");
        }
        if (elem.hasAttribute("X2AxisViewportTicks")) {
            elem.removeAttribute("X2AxisViewportTicks");
        }
        if (elem.hasAttribute("X2AxisStartOffset")) {
            elem.removeAttribute("X2AxisStartOffset");
        }
        if (elem.hasAttribute("X2AxisStrideOffset")) {
            elem.removeAttribute("X2AxisStrideOffset");
        }
        if (elem.hasAttribute("X2AxisOffsetMin")) {
            elem.removeAttribute("X2AxisOffsetMin");
        }
        if (elem.hasAttribute("X2AxisOffsetMax")) {
            elem.removeAttribute("X2AxisOffsetMax");
        }
        if (elem.hasAttribute("YAxisViewportMin")) {
            elem.removeAttribute("YAxisViewportMin");
        }
        if (elem.hasAttribute("YAxisViewportMax")) {
            elem.removeAttribute("YAxisViewportMax");
        }
        if (elem.hasAttribute("YAxisViewportTicks")) {
            elem.removeAttribute("YAxisViewportTicks");
        }
        if (elem.hasAttribute("YAxisStartOffset")) {
            elem.removeAttribute("YAxisStartOffset");
        }
        if (elem.hasAttribute("YAxisStrideOffset")) {
            elem.removeAttribute("YAxisStrideOffset");
        }
        if (elem.hasAttribute("YAxisOffsetMin")) {
            elem.removeAttribute("YAxisOffsetMin");
        }
        if (elem.hasAttribute("YAxisOffsetMax")) {
            elem.removeAttribute("YAxisOffsetMax");
        }
        if (elem.hasAttribute("Y2AxisViewportMin")) {
            elem.removeAttribute("Y2AxisViewportMin");
        }
        if (elem.hasAttribute("Y2AxisViewportMax")) {
            elem.removeAttribute("Y2AxisViewportMax");
        }
        if (elem.hasAttribute("Y2AxisViewportTicks")) {
            elem.removeAttribute("Y2AxisViewportTicks");
        }
        if (elem.hasAttribute("Y2AxisStartOffset")) {
            elem.removeAttribute("Y2AxisStartOffset");
        }
        if (elem.hasAttribute("Y2AxisStrideOffset")) {
            elem.removeAttribute("Y2AxisStrideOffset");
        }
        if (elem.hasAttribute("Y2AxisOffsetMin")) {
            elem.removeAttribute("Y2AxisOffsetMin");
        }
        if (elem.hasAttribute("Y2AxisOffsetMax")) {
            elem.removeAttribute("Y2AxisOffsetMax");
        }
    }

    private static String doubleArrayToString(double[] v) {
        String str = "";
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                str = str + " ";
            }
            str = str + Double.toString(v[i]);
        }
        return str;
    }
}

