/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import org.w3c.dom.Element;

public final class LayoutOverlayMapParser {
    public static final String RB_KEY = "LayoutOverlayMapParser.";

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        return LayoutOverlayMapParser.load(graph, elem, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost) {
        StatGraph.printWarning(RB.getStringResource(RB_KEY, "release.txt"));
        OverlayContainer oc = (OverlayContainer)LayoutOverlayEquatedParser.load(graph, elem, outmost, true);
        oc.setAxesVisible(false);
        oc.getComposite().getWall().setFillOn(false);
        oc.getComposite().getWall().setEdgeOn(false);
        oc.getComposite().setSquareFormat(Simple2DOverlayComposite.EQUATED_CENTER);
        String str = elem.getAttribute("clip");
        if (str.length() > 0 && !str.equalsIgnoreCase("none") && !str.equalsIgnoreCase("all")) {
            String[] stringArray = StatGraph.parseList2String(str);
        }
        return oc;
    }

    public static void parseViewportOpts(StatGraph graph, Element elem, MapOverlay mapOverlay, VRectAxis xAxis, VRectAxis yAxis) {
        double xmin = mapOverlay.getMapXMin();
        double xmax = mapOverlay.getMapXMax();
        double ymin = mapOverlay.getMapYMin();
        double ymax = mapOverlay.getMapYMax();
        Element vpOpts = StatGraph.getOptionAttrsElement(elem, "ViewportOpts");
        if (vpOpts != null) {
            Element plotsElem = StatGraph.getOptionAttrsElement(vpOpts, "ViewportPlotList");
            if (plotsElem != null) {
                String[] plots = StatGraph.parseStringValueList(plotsElem, "Value");
                xmin = Double.MAX_VALUE;
                xmax = -1.7976931348623157E308;
                ymin = Double.MAX_VALUE;
                ymax = -1.7976931348623157E308;
                boolean found = false;
                for (int i = 0; i < plots.length; ++i) {
                    DataRange yRange;
                    Object plot = graph.graphNamesTable.get(plots[i]);
                    if (plot == null) continue;
                    Overlay o = (Overlay)plot;
                    DataRange xRange = o.getDataRange((byte)1);
                    if (xRange != null && xRange instanceof ContinuousRange) {
                        xmin = Math.min(xmin, ((ContinuousRange)xRange).getMin());
                        xmax = Math.max(xmax, ((ContinuousRange)xRange).getMax());
                    }
                    if ((yRange = o.getDataRange((byte)2)) != null && yRange instanceof ContinuousRange) {
                        ymin = Math.min(ymin, ((ContinuousRange)yRange).getMin());
                        ymax = Math.max(ymax, ((ContinuousRange)yRange).getMax());
                    }
                    found = true;
                }
                if (!found) {
                    xmin = mapOverlay.getMapXMin();
                    xmax = mapOverlay.getMapXMax();
                    ymin = mapOverlay.getMapYMin();
                    ymax = mapOverlay.getMapYMax();
                }
            } else {
                String str = vpOpts.getAttribute("xMin");
                if (StatGraph.isNumber(str)) {
                    xmin = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("xMax"))) {
                    xmax = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("yMin"))) {
                    ymin = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("yMax"))) {
                    ymax = Double.parseDouble(str);
                }
            }
        }
        xAxis.setViewportMin(xmin);
        xAxis.setViewportMax(xmax);
        yAxis.setViewportMin(ymin);
        yAxis.setViewportMax(ymax);
        xAxis.setStartCoverage(0.0);
        xAxis.setEndCoverage(0.0);
        xAxis.setUserStartOffset(0.0);
        xAxis.setUserEndOffset(0.0);
        yAxis.setStartCoverage(0.0);
        yAxis.setEndCoverage(0.0);
        yAxis.setUserStartOffset(0.0);
        yAxis.setUserEndOffset(0.0);
    }
}

