/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.BarParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.SeriesParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.SimpleExtrudedOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.text.Message;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LayoutOverlayExtrudedParser {
    public static final String RB_KEY = "LayoutOverlayParser.";

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        return LayoutOverlayExtrudedParser.load(graph, elem, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        return LayoutOverlayExtrudedParser.load(graph, elem, false, rowColumnAxesType, rowColumn2AxesType);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost) {
        return LayoutOverlayExtrudedParser.load(graph, elem, outmost, null, null);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        int i;
        Node node2;
        Element elem2;
        String align;
        Node node;
        if (!LayoutOverlayParser.hasGraphElement(elem)) {
            return LayoutOverlayParser.loadNonGraphs(graph, elem);
        }
        graph.style.resetCounters();
        String str = elem.getAttribute("cycleAttrs");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        BaseOverlayContainer oc = (BaseOverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlayExtrudedParser.initComposite(graph, elem);
        }
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        Simple2DOverlayComposite soc = oc.getComposite();
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        VRectAxis zAxis = null;
        LayoutOverlayParser.initAxis(graph, xAxis);
        LayoutOverlayParser.initAxis(graph, x2Axis);
        LayoutOverlayParser.initAxis(graph, yAxis);
        LayoutOverlayParser.initAxis(graph, y2Axis);
        LayoutOverlayParser.decideAxesType(graph, elem, rowColumnAxesType, rowColumn2AxesType);
        ArrayList plots = new ArrayList();
        String elemTag = "";
        boolean x = false;
        boolean x2 = false;
        boolean y = false;
        boolean y2 = false;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("BarChartParm") || elemTag.equals("BarParm")) {
                BarOverlay bar = BarParser.load(graph, (Element)node);
                if (bar == null) continue;
                bar.setExtrudedOverlay(true);
                bar.setOverlayPosition(2);
                LayoutOverlayParser.addPlotToList(plots, bar);
                if (bar.getXAxis().equalsIgnoreCase("x")) {
                    x = true;
                } else {
                    x2 = true;
                }
                if (bar.getYAxis().equalsIgnoreCase("y")) {
                    y = true;
                    continue;
                }
                y2 = true;
                continue;
            }
            if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                Legend legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                String loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentY(1.0f);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                oc.addLegend(legend);
                continue;
            }
            graph.hasForeignObject = true;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("Face")) continue;
            align = ((Element)node).getAttribute("align");
            int face = align.length() > 0 && align.equalsIgnoreCase("BACK") ? 1 : 0;
            elem2 = (Element)node;
            if (!(x && x2 && y && y2)) {
                int xType = LayoutOverlayParser.xAxisType;
                int x2Type = LayoutOverlayParser.x2AxisType;
                int yType = LayoutOverlayParser.yAxisType;
                int y2Type = LayoutOverlayParser.y2AxisType;
                LayoutOverlayParser.decideAxesType(graph, elem2, rowColumnAxesType, rowColumn2AxesType);
                if (x) {
                    LayoutOverlayParser.xAxisType = xType;
                }
                if (x2) {
                    LayoutOverlayParser.x2AxisType = x2Type;
                }
                if (y) {
                    LayoutOverlayParser.yAxisType = yType;
                }
                if (y2) {
                    LayoutOverlayParser.y2AxisType = y2Type;
                }
            }
            for (node2 = elem2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element)) continue;
                elemTag = ((Element)node2).getTagName();
                ScatterOverlay overlay = null;
                if (!elemTag.equals("SeriesPlot")) continue;
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = SeriesParser.load(graph, (Element)node2, curveLabelPosition);
                LayoutOverlayParser.addPlotToList(plots, overlay, graph, !outmost);
                if (overlay == null) continue;
                overlay.setOverlayPosition(face);
                if (overlay.getXAxis().equalsIgnoreCase("x")) {
                    x = true;
                } else {
                    x2 = true;
                }
                if (overlay.getYAxis().equalsIgnoreCase("y")) {
                    y = true;
                    continue;
                }
                y2 = true;
            }
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("Face")) continue;
            align = ((Element)node).getAttribute("align");
            int face = align.length() > 0 && align.equalsIgnoreCase("BACK") ? 1 : 0;
            elem2 = (Element)node;
            for (node2 = elem2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element)) continue;
                elemTag = ((Element)node2).getTagName();
                ReferenceLineOverlay overlay = null;
                if (elemTag.equals("ReferenceLine")) {
                    int curveLabelPosition = 1;
                    if (y2Axis.isVisible() && !yAxis.isVisible()) {
                        curveLabelPosition = 0;
                    }
                    overlay = ReferenceLineParser.load(graph, (Element)node2, curveLabelPosition);
                    LayoutOverlayParser.addPlotToList(plots, overlay);
                    if (overlay == null) continue;
                    overlay.setOverlayPosition(face);
                    overlay.setExtrudedOverlay(true);
                    continue;
                }
                if (!elemTag.equals("Entry")) continue;
                if (face == 0) {
                    JComponent entry = (JComponent)graph.getObjectFromElement((Element)node2);
                    if (entry == null) {
                        entry = new EntryComposite();
                    }
                    EntryConcatParser.load(graph, (Element)node2, entry, oc, 0);
                    String loc = ((Element)node2).getAttribute("location");
                    LayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("outside")) {
                        if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                            entry.setAlignmentY(0.0f);
                        }
                        StatGraph.addDefaultOuterPad((Element)node, entry);
                        oc.addSidebar(entry);
                        continue;
                    }
                    oc.add((Component)entry, 0);
                    continue;
                }
                StatGraph.printNote(RB.getStringResource(RB_KEY, "entryextruded.txt"));
            }
        }
        if (plots.size() > 0) {
            LayoutOverlayParser.setAutomaticAxisTypes(plots, true, xAxis, x2Axis, yAxis, y2Axis, zAxis);
        }
        LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, x2Axis, yAxis, y2Axis, zAxis);
        for (int i2 = 0; i2 < plots.size(); ++i2) {
            Overlay plot = (Overlay)plots.get(i2);
            if (LayoutOverlayParser.isCompatibleOverlay(graph, plot)) {
                LayoutOverlayParser.addOverlay(plot, soc, xAxis, x2Axis, yAxis, y2Axis, zAxis);
                continue;
            }
            graph.removeNamedGraph(plot);
        }
        str = graph.style.getStyleAttribute("GridLines", "displayOpts");
        if (str != null && str.equalsIgnoreCase("on")) {
            if (StatGraph.getOptionAttrsElement(elem, "XAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "X2AxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, x2Axis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "YAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "Y2AxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, y2Axis, soc);
            }
        }
        VRectAxis[] axes = new VRectAxis[]{xAxis, x2Axis, yAxis, y2Axis};
        VRectAxis[] mirrorAxes = new VRectAxis[]{x2Axis, xAxis, y2Axis, yAxis};
        for (int i3 = 0; i3 < axes.length; ++i3) {
            if (axes[i3].getInputDataRange() == null || mirrorAxes[i3].getInputDataRange() != null) continue;
            String display2 = null;
            if (mirrorAxes[i3] == x2Axis && StatGraph.getOptionAttrsElement(elem, "XAxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement(elem, "XAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == xAxis && StatGraph.getOptionAttrsElement(elem, "X2AxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement(elem, "X2AxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == y2Axis && StatGraph.getOptionAttrsElement(elem, "YAxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement(elem, "YAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == yAxis && StatGraph.getOptionAttrsElement(elem, "Y2AxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement(elem, "Y2AxisOpts").getAttribute("displaySecondary");
            }
            if (display2 == null || display2.length() == 0 || display2.equalsIgnoreCase("NONE") || !LayoutOverlayParser.honorAxisOpts(elem, axes[i3], "displaySecondary")) {
                mirrorAxes[i3].setVisible(false);
                continue;
            }
            mirrorAxes[i3].setVisible(true);
            LayoutOverlayParser.copyAxisOptions(axes[i3], mirrorAxes[i3]);
            LayoutOverlayEquatedParser.parseAxisDisplay2Opts(display2, mirrorAxes[i3]);
            VRectGridLines grid = soc.getGridLines(mirrorAxes[i3]);
            if (grid != null) {
                soc.removeGridLines(grid);
            }
            mirrorAxes[i3].setSecondary(true);
            mirrorAxes[i3].setMirrorAxis(axes[i3]);
        }
        ArrayList overlays = soc.getOverlays();
        int parmPlotCnt = 0;
        for (i = 0; i < overlays.size(); ++i) {
            Overlay o = (Overlay)overlays.get(i);
            if (o instanceof ReferenceLineOverlay || o instanceof DropLineOverlay) {
                ++parmPlotCnt;
            }
            if (xAxis.isVisible() && xAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)xAxis, (byte)1);
            }
            if (x2Axis.isVisible() && x2Axis.isSecondary()) {
                soc.connect(o, (AbstractAxis)x2Axis, (byte)1);
            }
            if (yAxis.isVisible() && yAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)yAxis, (byte)2);
            }
            if (!y2Axis.isVisible() || !y2Axis.isSecondary()) continue;
            soc.connect(o, (AbstractAxis)y2Axis, (byte)2);
        }
        if (parmPlotCnt > 0 && parmPlotCnt == overlays.size()) {
            for (i = 0; i < parmPlotCnt; ++i) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "parm.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)((Overlay)overlays.get(i)).getStmt(), (Object)LayoutOverlayParser.getLayoutName(elem)));
            }
            oc.removeAll();
        }
        if (!(xAxis.isVisible() || x2Axis.isVisible() || yAxis.isVisible() || y2Axis.isVisible())) {
            soc.setAxesVisible(false);
        }
        return oc;
    }

    public static OverlayContainer initComposite(StatGraph graph, Element elem) {
        Element wallAttrs;
        boolean interactive = !graph.server;
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new OverlayContainer(false, false, interactive);
        }
        if (oc.getBaseComponent() != null) {
            oc.getBaseComponent().setObliqueProjection(true);
        }
        SimpleExtrudedOverlayComposite soc = new SimpleExtrudedOverlayComposite();
        oc.setComposite(soc);
        Wall w = new Wall(false);
        GraphStyle.setDefaultLineStyle(graph, null, w.getEdgeStyle(), "WallFill");
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("wallAttrs"), w.getFillStyle(), "WallFill");
        w.getFillStyle().setTransparency(0.0);
        String str = elem.getAttribute("wallDisplay");
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD")) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                w.setEdgeOn(true);
            } else {
                w.setEdgeOn(false);
            }
            w.setFillOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            w.setFillOn(false);
            w.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else {
            w.setFillOn(false);
            w.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    w.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    w.setFillOn(true);
                    continue;
                }
                w.setFillOn(true);
                w.setEdgeOn(true);
                StatGraph.printOptionError("WALLDISPLAY", opts[i]);
                break;
            }
        }
        Wall sideWall = new Wall();
        str = elem.getAttribute("sideWallDisplay");
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD")) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                sideWall.setEdgeOn(true);
            } else {
                sideWall.setEdgeOn(false);
            }
            sideWall.setFillOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            sideWall.setFillOn(false);
            sideWall.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            sideWall.setFillOn(true);
            sideWall.setEdgeOn(true);
        } else {
            sideWall.setFillOn(false);
            sideWall.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    sideWall.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    sideWall.setFillOn(true);
                    continue;
                }
                sideWall.setFillOn(true);
                sideWall.setEdgeOn(true);
                StatGraph.printOptionError("SIDEWALLDISPLAY", opts[i]);
                break;
            }
        }
        Wall floor = new Wall();
        str = elem.getAttribute("floorDisplay");
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD")) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                floor.setEdgeOn(true);
            } else {
                floor.setEdgeOn(false);
            }
            floor.setFillOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            floor.setFillOn(false);
            floor.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            floor.setFillOn(true);
            floor.setEdgeOn(true);
        } else {
            floor.setFillOn(false);
            floor.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    floor.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    floor.setFillOn(true);
                    continue;
                }
                floor.setFillOn(true);
                floor.setEdgeOn(true);
                StatGraph.printOptionError("FLOORDISPLAY", opts[i]);
                break;
            }
        }
        if ((w.isFillOn() || sideWall.isFillOn() || floor.isFillOn()) && (wallAttrs = StatGraph.getOptionAttrsElement(elem, "WallAttrs")) != null) {
            StatGraph.parseFillAttrs(graph, wallAttrs, w.getFillStyle());
        }
        soc.setWall(w);
        soc.setSideWall(sideWall);
        soc.setFloor(floor);
        sideWall.setEdgeStyle(w.getEdgeStyle());
        sideWall.setFillStyle(w.getFillStyle());
        floor.setEdgeStyle(w.getEdgeStyle());
        floor.setFillStyle(w.getFillStyle());
        str = elem.getAttribute("cube");
        if (str.equalsIgnoreCase("false")) {
            w.setCube(false);
        }
        soc.dataDisplayAntialiased = graph.dataAntialiased;
        soc.axisDisplayAntialiased = graph.axisAntialiased;
        return oc;
    }
}

