/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.BiHistoParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.SurfaceParser;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple3DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LayoutOverlay3DParser {
    public static final String RB_KEY = "LayoutOverlayParser.";

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        if (graph.getMaxOBS() <= 0) {
            return LayoutOverlayParser.loadNonGraphs(graph, elem);
        }
        graph.style.resetCounters();
        String str = elem.getAttribute("cycleAttrs");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        BaseOverlayContainer oc = (BaseOverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlay3DParser.initComposite(graph, elem);
        }
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        if (!elem.getAttribute("opaque").equalsIgnoreCase("true")) {
            oc.getBaseComponent().setTransparentBackground(graph.isTransparentBackground());
        }
        Simple2DOverlayComposite soc = oc.getComposite();
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis zAxis = new VRectAxis(3, false);
        LayoutOverlayParser.initAxis(graph, xAxis);
        LayoutOverlayParser.initAxis(graph, yAxis);
        LayoutOverlayParser.initAxis(graph, zAxis);
        LayoutOverlayParser.decideAxesType(graph, elem, null, null);
        ArrayList plots = new ArrayList();
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            AbstractSGComponent legend;
            String loc;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("SurfacePlotParm")) {
                LayoutOverlayParser.addPlotToList(plots, SurfaceParser.load(graph, (Element)node));
                continue;
            }
            if (elemTag.equals("BiHistogram3DParm")) {
                LayoutOverlayParser.addPlotToList(plots, BiHistoParser.load(graph, (Element)node));
                continue;
            }
            if (elemTag.equals("Entry")) {
                JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                if (entry == null) {
                    entry = new EntryComposite();
                }
                EntryConcatParser.load(graph, (Element)node, entry, oc, 0);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                        entry.setAlignmentY(0.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, entry);
                    oc.addSidebar(entry);
                    continue;
                }
                oc.add((Component)entry, 0);
                continue;
            }
            if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentY(1.0f);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                oc.addLegend(legend);
                continue;
            }
            if (elemTag.equals("ContinuousLegend")) {
                legend = (LegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new LegendComponent();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentX(1.0f);
                }
                if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                    ((LegendComponent)legend).setHorizontal(true);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                oc.addLegend(legend);
                continue;
            }
            if (elemTag.startsWith("Draw")) {
                AbstractAnno text = AnnotateParser.load(graph, (Element)node, oc);
                if (text == null) continue;
                if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
                continue;
            }
            graph.hasForeignObject = true;
        }
        if (plots.size() > 0) {
            LayoutOverlayParser.setAutomaticAxisTypes(plots, false, xAxis, null, yAxis, null, zAxis);
        }
        LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, null, yAxis, null, zAxis);
        for (int i = 0; i < plots.size(); ++i) {
            Overlay plot = (Overlay)plots.get(i);
            if (LayoutOverlayParser.isCompatibleOverlay(graph, plot)) {
                LayoutOverlayParser.addOverlay(plot, soc, xAxis, null, yAxis, null, zAxis);
                continue;
            }
            graph.removeNamedGraph(plot);
        }
        str = graph.style.getStyleAttribute("GridLines", "displayOpts");
        if (str != null && str.equalsIgnoreCase("on")) {
            if (StatGraph.getOptionAttrsElement(elem, "XAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "YAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "ZAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, zAxis, soc);
            }
        }
        return oc;
    }

    public static AbstractSGComponent loadPlot(StatGraph graph, Element elem, int type) {
        if (graph.getMaxOBS() <= 0) {
            return null;
        }
        graph.style.resetCounters();
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlay3DParser.initComposite(graph, elem);
        }
        Simple2DOverlayComposite soc = oc.getComposite();
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        oc.getBaseComponent().setTransparentBackground(graph.isTransparentBackground());
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis zAxis = new VRectAxis(3, false);
        LayoutOverlayParser.initAxis(graph, xAxis);
        LayoutOverlayParser.initAxis(graph, yAxis);
        LayoutOverlayParser.initAxis(graph, zAxis);
        Overlay overlay = null;
        switch (type) {
            case 8: {
                overlay = BiHistoParser.load(graph, elem);
                break;
            }
            case 10: {
                overlay = SurfaceParser.load(graph, elem);
            }
        }
        if (overlay == null) {
            return null;
        }
        LayoutOverlayParser.setAutomaticAxisTypes(overlay, false, xAxis, null, yAxis, null, zAxis);
        LayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, null, yAxis, null, zAxis);
        if (!LayoutOverlayParser.isCompatibleOverlay(graph, overlay)) {
            return null;
        }
        LayoutOverlayParser.addOverlay(overlay, soc, xAxis, null, yAxis, null, zAxis, oc.isHorizontal());
        return oc;
    }

    public static OverlayContainer initComposite(StatGraph graph, Element elem) {
        boolean interactive = !graph.server;
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new OverlayContainer(false, false, interactive);
        }
        Simple3DOverlayComposite soc = new Simple3DOverlayComposite();
        oc.setComposite(soc);
        Wall w = new Wall(false);
        GraphStyle.setDefaultLineStyle(graph, null, w.getEdgeStyle(), "WallFill");
        String str = elem.getAttribute("wallDisplay");
        if (str.length() == 0) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                w.setEdgeOn(true);
            } else {
                w.setEdgeOn(false);
            }
            w.setFillOn(false);
        } else if (str.equalsIgnoreCase("STANDARD")) {
            w.setFillOn(false);
            w.setEdgeOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            w.setFillOn(false);
            w.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else {
            w.setFillOn(false);
            w.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    w.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    w.setFillOn(true);
                    continue;
                }
                w.setFillOn(true);
                w.setEdgeOn(true);
                StatGraph.printOptionError("WALLDISPLAY", opts[i]);
                break;
            }
        }
        if (w.isFillOn()) {
            LayoutOverlayParser.parseWallColor(graph, elem, w.getFillStyle());
        }
        soc.setWall(w);
        str = elem.getAttribute("cube");
        if (str.equalsIgnoreCase("false")) {
            w.setCube(false);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("rotate"))) {
            oc.getBaseComponent().setAzimuth(Float.parseFloat(str));
        } else {
            oc.getBaseComponent().setAzimuth(54.0f);
        }
        str = elem.getAttribute("tilt");
        if (StatGraph.isNumber(str)) {
            oc.getBaseComponent().setInclination(-Float.parseFloat(str));
        } else {
            oc.getBaseComponent().setInclination(-20.0f);
        }
        str = elem.getAttribute("zoom");
        if (StatGraph.isNumber(str)) {
            oc.getBaseComponent().setZoom(Float.parseFloat(str));
        } else {
            oc.getBaseComponent().setZoom(1.0f);
        }
        soc.dataDisplayAntialiased = graph.dataAntialiased;
        soc.axisDisplayAntialiased = graph.axisAntialiased;
        return oc;
    }
}

