/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.EntryStub;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.GridAxis;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayoutLatticeParser {
    public static final String RB_KEY = "LayoutLatticeParser.";
    private static final int DATA = 0;
    private static final int UNION = 1;
    private static final int UNIONALL = 2;

    public static TrellisPlot load(StatGraph graph, Element elem) {
        graph.pushFontsShrinkage(elem);
        TrellisPlot plot = (TrellisPlot)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new TrellisPlot();
        }
        LayoutLatticeParser.load(graph, elem, plot);
        graph.popFontsShrinkage(elem);
        return plot;
    }

    public static void load(StatGraph graph, Element elem, TrellisPlot plot) {
        boolean addY2Axis;
        Node node;
        double percent;
        plot.disableLayout();
        GraphComponentParser.load(graph, elem, (JComponent)plot, null);
        StatGraph.parseBorderOpts(graph, (JComponent)plot, elem, null);
        boolean rowMajor = true;
        boolean packed = false;
        String str = elem.getAttribute("order");
        if (str.equalsIgnoreCase("COLUMNMAJOR")) {
            rowMajor = false;
        } else if (str.equalsIgnoreCase("ROWMAJOR")) {
            rowMajor = true;
        } else if (str.equalsIgnoreCase("PACKED")) {
            packed = true;
        } else if (str.length() > 0) {
            StatGraph.printOptionError("ORDER", str);
        }
        boolean rowsSet = false;
        str = elem.getAttribute("rows");
        int numRows = 1;
        if (StatGraph.isNumber(str)) {
            numRows = Integer.parseInt(str);
            rowsSet = true;
        }
        boolean columnsSet = false;
        str = elem.getAttribute("columns");
        int numCols = 1;
        if (StatGraph.isNumber(str)) {
            numCols = Integer.parseInt(str);
            columnsSet = true;
        }
        str = elem.getAttribute("rowGutter");
        int rowGap = 0;
        if (StatGraph.isLineThickness(str)) {
            rowGap = graph.unit2GapThickness(str);
        }
        str = elem.getAttribute("columnGutter");
        int colGap = 0;
        if (StatGraph.isLineThickness(str)) {
            colGap = graph.unit2GapThickness(str);
        }
        TrellisLayout tl = new TrellisLayout(numRows, numCols, colGap, rowGap);
        plot.setLayout((LayoutManager)tl);
        tl.setCellHeadersAligned(true);
        str = elem.getAttribute("leftAxisWidthMax");
        if (StatGraph.isNumber(str) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRowAxisWidthPercentage(percent);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("rightAxisWidthMax")) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRow2AxisWidthPercentage(percent);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("cellAspectRatio"))) {
            tl.setCellAspectRatio(Double.parseDouble(str));
        } else {
            tl.setCellAspectRatio(-1.0);
        }
        boolean alignColumnAxesLabel = true;
        str = elem.getAttribute("columnAxesLabelAlign");
        if (str.length() > 0 && StatGraph.isNumber(str)) {
            alignColumnAxesLabel = Integer.parseInt(str) > 0;
        }
        boolean alignRowAxesLabel = true;
        str = elem.getAttribute("rowAxesLabelAlign");
        if (str.length() > 0 && StatGraph.isNumber(str)) {
            boolean bl = alignRowAxesLabel = Integer.parseInt(str) > 0;
        }
        if ((str = elem.getAttribute("skipEmptyCells")).length() > 0 && str.equalsIgnoreCase("true")) {
            tl.setEmptyCellsSkipped(true);
        }
        NodeList list = elem.getElementsByTagName("LayoutOverlay3D");
        boolean is3D = false;
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getParentNode() != elem) continue;
            is3D = true;
            break;
        }
        int cnt = 0;
        LinkedHashMap cellItem = new LinkedHashMap();
        LinkedHashMap rowAxesType = new LinkedHashMap();
        LinkedHashMap row2AxesType = new LinkedHashMap();
        LinkedHashMap colAxesType = new LinkedHashMap();
        LinkedHashMap col2AxesType = new LinkedHashMap();
        String elemTag = "";
        Element rowAxes = null;
        Element row2Axes = null;
        Element columnAxes = null;
        Element column2Axes = null;
        int[] rowColumnDataRange = new int[2];
        int[] rowColumn2DataRange = new int[2];
        LayoutLatticeParser.getRowColumnDataRange(elem, rowColumnDataRange, rowColumn2DataRange);
        rowAxes = StatGraph.getOptionAttrsElement(elem, "RowAxes");
        row2Axes = StatGraph.getOptionAttrsElement(elem, "Row2Axes");
        columnAxes = StatGraph.getOptionAttrsElement(elem, "ColumnAxes");
        column2Axes = StatGraph.getOptionAttrsElement(elem, "Column2Axes");
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            int col;
            int row;
            if (!(node instanceof Element) || (elemTag = ((Element)node).getTagName()).equals("RowHeaders") || elemTag.equals("Row2Headers") || elemTag.equals("ColumnHeaders") || elemTag.equals("Column2Headers") || elemTag.equals("SideBar") || elemTag.equals("RowAxes") || elemTag.equals("Row2Axes") || elemTag.equals("ColumnAxes") || elemTag.equals("Column2Axes") || elemTag.equals("BackgroundAttrs") || elemTag.equals("BorderAttrs") || elemTag.equals("PadAttrs") || elemTag.equals("OuterPadAttrs") || elemTag.equals("EntryTitle") || elemTag.equals("EntryFootnote") || elemTag.equals("LegendItem")) continue;
            if (elemTag.startsWith("Draw")) {
                SGAnnotationContainer ac = new SGAnnotationContainer((Container)plot, graph.rootPanel);
                AbstractAnno text = AnnotateParser.load(graph, (Element)node, (AnnotationContainer)ac);
                if (text == null) continue;
                if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
                continue;
            }
            if (rowsSet && columnsSet && cnt >= numRows * numCols) continue;
            if (rowMajor) {
                row = cnt / numCols;
                col = cnt - row * numCols;
            } else {
                col = cnt / numRows;
                row = cnt - col * numRows;
            }
            LayoutLatticeParser.loadCell(graph, (Element)node, row, col, plot, cellItem, rowAxes, row2Axes, columnAxes, column2Axes, is3D, rowAxesType, row2AxesType, colAxesType, col2AxesType, rowColumnDataRange, rowColumn2DataRange);
            ++cnt;
        }
        str = elem.getAttribute("rowWeights");
        boolean hasPreferredRowWeight = false;
        if (str.length() > 0 && !str.equalsIgnoreCase("UNIFORM")) {
            int i;
            String[] weights = StatGraph.parseList2String(str);
            boolean validWeights = true;
            double totalWeight = 0.0;
            int numericWeightCnt = 0;
            for (i = 0; i < weights.length; ++i) {
                if (StatGraph.isNumber(weights[i])) {
                    double wt = Double.parseDouble(weights[i]);
                    if (wt < 0.0) {
                        StatGraph.printOptionError("ROWWEIGHTS", "(" + str + ")");
                        validWeights = false;
                        break;
                    }
                    ++numericWeightCnt;
                    totalWeight += wt;
                    continue;
                }
                if (!weights[i].equalsIgnoreCase("PREFERRED")) {
                    StatGraph.printOptionError("ROWWEIGHTS", "(" + str + ")");
                    validWeights = false;
                    break;
                }
                hasPreferredRowWeight = true;
            }
            if (validWeights && numericWeightCnt > 0 && totalWeight == 0.0) {
                StatGraph.printOptionError("ROWWEIGHTS", "(" + str + ")");
                validWeights = false;
            }
            if (validWeights) {
                if (weights.length == 1 && weights[0].equalsIgnoreCase("PREFERRED")) {
                    weights = new String[tl.getGridRows()];
                    for (i = 0; i < weights.length; ++i) {
                        weights[i] = "PREFERRED";
                    }
                    tl.setRowWeights2(weights);
                } else if (weights.length == tl.getGridRows()) {
                    tl.setRowWeights2(weights);
                } else {
                    StatGraph.printOptionError("ROWWEIGHTS", "(" + str + ")");
                    hasPreferredRowWeight = false;
                }
                if (hasPreferredRowWeight) {
                    StatGraph.textWrapped = true;
                }
            }
        }
        str = elem.getAttribute("columnWeights");
        boolean hasPreferredColumnWeight = false;
        if (str.length() > 0) {
            int i;
            String[] weights = StatGraph.parseList2String(str);
            boolean validWeights = true;
            double totalWeight = 0.0;
            int numericWeightCnt = 0;
            for (i = 0; i < weights.length; ++i) {
                if (StatGraph.isNumber(weights[i])) {
                    double wt = Double.parseDouble(weights[i]);
                    if (wt < 0.0) {
                        StatGraph.printOptionError("COLUMNWEIGHTS", "(" + str + ")");
                        validWeights = false;
                        break;
                    }
                    ++numericWeightCnt;
                    totalWeight += wt;
                    continue;
                }
                if (!weights[i].equalsIgnoreCase("PREFERRED")) {
                    StatGraph.printOptionError("COLUMNWEIGHTS", "(" + str + ")");
                    validWeights = false;
                    break;
                }
                hasPreferredColumnWeight = true;
            }
            if (validWeights && numericWeightCnt > 0 && totalWeight == 0.0) {
                StatGraph.printOptionError("COLUMNWEIGHTS", "(" + str + ")");
                validWeights = false;
            }
            if (validWeights) {
                if (weights.length == 1 && weights[0].equalsIgnoreCase("PREFERRED")) {
                    weights = new String[tl.getGridColumns()];
                    for (i = 0; i < weights.length; ++i) {
                        weights[i] = "PREFERRED";
                    }
                    tl.setColumnWeights2(weights);
                } else if (weights.length == tl.getGridColumns()) {
                    tl.setColumnWeights2(weights);
                } else {
                    StatGraph.printOptionError("COLUMNWEIGHTS", "(" + str + ")");
                    hasPreferredColumnWeight = false;
                }
                if (hasPreferredColumnWeight) {
                    StatGraph.textWrapped = true;
                }
            }
        }
        if (cellItem.size() < numCols * numRows && packed) {
            if (!rowsSet || !columnsSet) {
                if (rowMajor) {
                    numRows = (int)Math.ceil((double)cnt / (double)numCols);
                } else {
                    numCols = (int)Math.ceil((double)cnt / (double)numRows);
                }
            }
            LayoutLatticeParser.packCellItems(numRows, numCols, plot, cellItem);
        } else {
            LayoutLatticeParser.populateCellItems(rowMajor, numRows, numCols, plot, cellItem);
        }
        rowAxes = null;
        row2Axes = null;
        columnAxes = null;
        column2Axes = null;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("RowHeaders")) {
                LayoutLatticeParser.loadRowColHeaders(graph, (Element)node, plot, "R");
                continue;
            }
            if (elemTag.equals("Row2Headers")) {
                LayoutLatticeParser.loadRowColHeaders(graph, (Element)node, plot, "R2");
                continue;
            }
            if (elemTag.equals("ColumnHeaders")) {
                LayoutLatticeParser.loadRowColHeaders(graph, (Element)node, plot, "C");
                continue;
            }
            if (elemTag.equals("Column2Headers")) {
                LayoutLatticeParser.loadRowColHeaders(graph, (Element)node, plot, "C2");
                continue;
            }
            if (elemTag.equals("SideBar")) {
                LayoutLatticeParser.loadSideBar(graph, (Element)node, plot);
                continue;
            }
            if (elemTag.equals("RowAxes")) {
                if (is3D) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "value.fmt.txt"));
                    String err = msg.toString((Object)"ROWAXES");
                    StatGraph.printWarning(err);
                    continue;
                }
                rowAxes = (Element)node;
                LayoutLatticeParser.loadRowColAxes(graph, (Element)node, plot, "R", rowAxesType);
                continue;
            }
            if (elemTag.equals("Row2Axes")) {
                if (is3D) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "value.fmt.txt"));
                    String err = msg.toString((Object)"ROW2AXES");
                    StatGraph.printWarning(err);
                    continue;
                }
                row2Axes = (Element)node;
                LayoutLatticeParser.loadRowColAxes(graph, (Element)node, plot, "R2", row2AxesType);
                continue;
            }
            if (elemTag.equals("ColumnAxes")) {
                if (is3D) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "value.fmt.txt"));
                    String err = msg.toString((Object)"COLUMNAXES");
                    StatGraph.printWarning(err);
                    continue;
                }
                columnAxes = (Element)node;
                LayoutLatticeParser.loadRowColAxes(graph, (Element)node, plot, "C", colAxesType);
                continue;
            }
            if (!elemTag.equals("Column2Axes")) continue;
            if (is3D) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "value.fmt.txt"));
                String err = msg.toString((Object)"COLUMN2AXES");
                StatGraph.printWarning(err);
                continue;
            }
            column2Axes = (Element)node;
            LayoutLatticeParser.loadRowColAxes(graph, (Element)node, plot, "C2", col2AxesType);
        }
        if (rowAxes != null) {
            LayoutLatticeParser.parseDisplaySecondary(graph, rowAxes, plot, "R");
        }
        if (row2Axes != null) {
            LayoutLatticeParser.parseDisplaySecondary(graph, row2Axes, plot, "R2");
        }
        if (columnAxes != null) {
            LayoutLatticeParser.parseDisplaySecondary(graph, columnAxes, plot, "C");
        }
        if (column2Axes != null) {
            LayoutLatticeParser.parseDisplaySecondary(graph, column2Axes, plot, "C2");
        }
        for (int i = 0; i < plot.getComponentCount(); ++i) {
            if (!(plot.getComponent(i) instanceof GridAxisInterface)) continue;
            plot.setComponentZOrder(plot.getComponent(i), 0);
        }
        boolean hSync = false;
        str = elem.getAttribute("columnDataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (is3D) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                String err = msg.toString((Object)"COLUMNDATARANGE", (Object)str);
                StatGraph.printWarning(err);
            } else if (str.equalsIgnoreCase("union")) {
                hSync = true;
            } else if (str.equalsIgnoreCase("unionall")) {
                plot.setUniformXRange(true);
                hSync = true;
            } else {
                StatGraph.printOptionError("COLUMNDATARANGE", str);
            }
        }
        boolean h2Sync = false;
        str = elem.getAttribute("column2DataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (is3D) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                String err = msg.toString((Object)"COLUMN2DATARANGE", (Object)str);
                StatGraph.printWarning(err);
            } else if (str.equalsIgnoreCase("union")) {
                h2Sync = true;
            } else if (str.equalsIgnoreCase("unionall")) {
                plot.setUniformX2Range(true);
                h2Sync = true;
            } else {
                StatGraph.printOptionError("COLUMN2DATARANGE", str);
            }
        }
        boolean vSync = false;
        str = elem.getAttribute("rowDataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (is3D) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                String err = msg.toString((Object)"ROWDATARANGE", (Object)str);
                StatGraph.printWarning(err);
            } else if (str.equalsIgnoreCase("union")) {
                vSync = true;
            } else if (str.equalsIgnoreCase("unionall")) {
                plot.setUniformYRange(true);
                vSync = true;
            } else {
                StatGraph.printOptionError("ROWDATARANGE", str);
            }
        }
        boolean v2Sync = false;
        str = elem.getAttribute("row2DataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (is3D) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                String err = msg.toString((Object)"ROW2DATARANGE", (Object)str);
                StatGraph.printWarning(err);
            } else if (str.equalsIgnoreCase("union")) {
                v2Sync = true;
            } else if (str.equalsIgnoreCase("unionall")) {
                plot.setUniformY2Range(true);
                v2Sync = true;
            } else {
                StatGraph.printOptionError("ROW2DATARANGE", str);
            }
        }
        LayoutLatticeParser.unifyGridAxisViewport(plot);
        LayoutLatticeParser.decideRowColumnAxisTypes(plot);
        LayoutLatticeParser.unifyRowColumnAxisType(plot);
        LayoutLatticeParser.setupInternalAxes(plot, hSync, vSync, h2Sync, v2Sync);
        if (alignColumnAxesLabel || alignRowAxesLabel) {
            LayoutLatticeParser.setupAxesLabelAlignment(plot, alignColumnAxesLabel, alignRowAxesLabel);
        }
        if (hSync || vSync || h2Sync || v2Sync) {
            LayoutLatticeParser.turnOffEquateOption(plot);
        }
        if (hSync || vSync || h2Sync || v2Sync) {
            LayoutLatticeParser.ignoreAspectOption(plot);
        }
        if (hSync && !plot.isUniformXRange() && h2Sync && !plot.isUniformX2Range()) {
            LayoutLatticeParser.unifyColumnViewport(plot, true, true);
        } else if (hSync && !plot.isUniformXRange()) {
            LayoutLatticeParser.unifyColumnViewport(plot, true, false);
        } else if (h2Sync && !plot.isUniformX2Range()) {
            LayoutLatticeParser.unifyColumnViewport(plot, false, true);
        }
        if (vSync && !plot.isUniformYRange() && v2Sync && !plot.isUniformY2Range()) {
            LayoutLatticeParser.unifyRowViewport(plot, true, true);
        } else if (vSync && !plot.isUniformYRange()) {
            LayoutLatticeParser.unifyRowViewport(plot, true, false);
        } else if (v2Sync && !plot.isUniformY2Range()) {
            LayoutLatticeParser.unifyRowViewport(plot, false, true);
        }
        if (plot.isUniformXRange() || plot.isUniformYRange() || plot.isUniformX2Range() || plot.isUniformY2Range()) {
            LayoutLatticeParser.unifyViewport(plot);
        }
        boolean addXAxis = hSync && columnAxes == null;
        boolean addX2Axis = h2Sync && column2Axes == null;
        boolean addYAxis = vSync && rowAxes == null;
        boolean bl = addY2Axis = v2Sync && row2Axes == null;
        if (addXAxis || addX2Axis || addYAxis || addY2Axis) {
            LayoutLatticeParser.addAxesRangeToRangeMerger(plot, addXAxis, addX2Axis, addYAxis, addY2Axis);
        }
        if (hSync || h2Sync) {
            plot.installColumnRangeListeners(true, hSync, h2Sync);
        }
        if (vSync || v2Sync) {
            plot.installRowRangeListeners(true, vSync, v2Sync);
        }
        plot.installMarginListeners();
        plot.enableLayout();
        if (!graph.server) {
            LayoutLatticeParser.registerViewportListener(plot, hSync, vSync);
        }
    }

    private static void packCellItems(int nRows, int nCols, TrellisPlot plot, LinkedHashMap cellItem) {
        int nPlots = cellItem.size();
        int[] cellsPerRow = new int[nRows];
        for (int i = 0; i < nRows; ++i) {
            cellsPerRow[i] = nCols;
        }
        int neededRows = (int)Math.ceil((double)nPlots / (double)nCols);
        int emptyCells = nCols - nPlots % nCols;
        if (emptyCells >= nCols) {
            emptyCells = 0;
        }
        int r = 0;
        for (int i = 0; i < emptyCells; ++i) {
            int n = r++;
            cellsPerRow[n] = cellsPerRow[n] - 1;
            if (r < neededRows) continue;
            r = 0;
        }
        Component[] comps = new Component[cellItem.size()];
        Iterator I = cellItem.keySet().iterator();
        int n = 0;
        while (I.hasNext()) {
            comps[n++] = (Component)I.next();
        }
        n = 0;
        for (int i = 0; i < neededRows; ++i) {
            for (int j = 0; j < cellsPerRow[i]; ++j) {
                plot.addCellItem(i, j, comps[n]);
                ArrayList header = (ArrayList)cellItem.get(comps[n]);
                if (header != null) {
                    for (int h = 0; h < header.size(); ++h) {
                        plot.addCellHeader(i, j, h, (JComponent)header.get(h));
                    }
                }
                ++n;
            }
        }
    }

    private static void populateCellItems(boolean rowMajor, int numRows, int numCols, TrellisPlot plot, LinkedHashMap cellItem) {
        Iterator I = cellItem.keySet().iterator();
        int cnt = 0;
        while (I.hasNext()) {
            int col;
            int row;
            if (rowMajor) {
                row = cnt / numCols;
                col = cnt - row * numCols;
            } else {
                col = cnt / numRows;
                row = cnt - col * numRows;
            }
            Component comp = (Component)I.next();
            plot.addCellItem(row, col, comp);
            ArrayList header = (ArrayList)cellItem.get(comp);
            if (header != null) {
                for (int h = 0; h < header.size(); ++h) {
                    plot.addCellHeader(row, col, h, (JComponent)header.get(h));
                }
            }
            ++cnt;
        }
    }

    static void loadCell(StatGraph graph, Element elem, int row, int col, TrellisPlot plot, LinkedHashMap cellItem, Element rowAxes, Element row2Axes, Element columnAxes, Element column2Axes, boolean is3D, LinkedHashMap rowAxesType, LinkedHashMap row2AxesType, LinkedHashMap colAxesType, LinkedHashMap col2AxesType, int[] rowColumnDataRange, int[] rowColumn2DataRange) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (row >= tl.getGridRows()) {
            plot.addRow();
        }
        if (col >= tl.getGridColumns()) {
            plot.addColumn();
        }
        String elemTag = elem.getTagName();
        JComponent comp = null;
        if (elemTag.equals("Cell")) {
            String tag = "";
            ArrayList header = null;
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                tag = ((Element)node).getTagName();
                if (tag.equals("CellHeader")) {
                    header = LayoutLatticeParser.loadCellHeaders(graph, (Element)node, row, col, plot);
                    continue;
                }
                int[] rowColumnAxesType = new int[2];
                int[] rowColumn2AxesType = new int[2];
                LayoutLatticeParser.parseRowColumnAxesType(graph, rowAxes, row2Axes, columnAxes, column2Axes, plot, row, col, rowAxesType, row2AxesType, colAxesType, col2AxesType, rowColumnDataRange, rowColumn2DataRange, rowColumnAxesType, rowColumn2AxesType);
                comp = StatGraph.parseComponent(graph, (Element)node, (JComponent)plot, rowColumnAxesType, rowColumn2AxesType);
                LayoutLatticeParser.setCurrentRowColumnAxesType(comp, row, col, rowAxesType, row2AxesType, colAxesType, col2AxesType);
            }
            cellItem.put(comp, header);
        } else {
            int[] rowColumnAxesType = new int[2];
            int[] rowColumn2AxesType = new int[2];
            if (is3D) {
                comp = StatGraph.parseComponent(graph, elem, (JComponent)plot);
            } else {
                LayoutLatticeParser.parseRowColumnAxesType(graph, rowAxes, row2Axes, columnAxes, column2Axes, plot, row, col, rowAxesType, row2AxesType, colAxesType, col2AxesType, rowColumnDataRange, rowColumn2DataRange, rowColumnAxesType, rowColumn2AxesType);
                comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, rowColumnAxesType, rowColumn2AxesType);
                LayoutLatticeParser.setCurrentRowColumnAxesType(comp, row, col, rowAxesType, row2AxesType, colAxesType, col2AxesType);
            }
            cellItem.put(comp, null);
        }
    }

    static ArrayList loadCellHeaders(StatGraph graph, Element elem, int row, int col, TrellisPlot plot) {
        int cnt = 0;
        ArrayList<JComponent> header = new ArrayList<JComponent>();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            JComponent comp;
            if (!(node instanceof Element) || (comp = StatGraph.parseComponent(graph, (Element)node, (JComponent)plot)) == null) continue;
            header.add(comp);
            ++cnt;
        }
        return header;
    }

    static void loadRowColHeaders(StatGraph graph, Element elem, TrellisPlot plot, String position) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int cnt = 0;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            JComponent comp;
            if (!(node instanceof Element) || (comp = StatGraph.parseComponent(graph, (Element)node, (JComponent)plot)) == null) continue;
            if (position.equals("R") || position.equals("R2")) {
                if (cnt >= tl.getGridRows()) break;
                if (position.equals("R")) {
                    plot.addRowHeader(cnt, (Component)comp);
                } else {
                    plot.addRowHeader2(cnt, (Component)comp);
                }
            } else {
                if (cnt >= tl.getGridColumns()) break;
                if (position.equals("C")) {
                    plot.addColumnHeader2(cnt, (Component)comp);
                } else {
                    plot.addColumnHeader(cnt, (Component)comp);
                }
            }
            ++cnt;
        }
    }

    static void loadRowColAxes(StatGraph graph, Element elem, TrellisPlot plot, String position, LinkedHashMap axesType) {
        int maxGridAxes;
        String axisTag;
        boolean primary;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int cnt = 0;
        byte dimension = position.startsWith("R") ? (byte)2 : 1;
        boolean bl = primary = position.length() == 1;
        if (dimension == 2) {
            axisTag = "RowAxis";
            maxGridAxes = tl.getGridRows();
        } else {
            axisTag = "ColumnAxis";
            maxGridAxes = tl.getGridColumns();
        }
        for (Node node = elem.getFirstChild(); node != null && cnt < maxGridAxes; node = node.getNextSibling()) {
            Element nodeElem;
            String tag;
            if (!(node instanceof Element) || !(tag = (nodeElem = (Element)node).getTagName()).equals(axisTag)) continue;
            if (!LayoutLatticeParser.hasOverlayOnAxis(plot, dimension, primary, cnt)) {
                ++cnt;
                continue;
            }
            GridAxis ga = (GridAxis)graph.getObjectFromElement(nodeElem);
            if (ga == null) {
                ga = new GridAxis(dimension);
            }
            if (dimension == 2) {
                plot.addRowAxis(cnt, (Component)ga, primary);
            } else {
                plot.addColumnAxis(cnt, (Component)ga, primary);
            }
            VRectAxis axis = ga.getAxis();
            axis.setPrimary(primary);
            LayoutOverlayParser.initAxis(graph, axis);
            LayoutOverlayParser.parseAxisCompOpts(graph, null, nodeElem, axis);
            if (!nodeElem.hasAttribute("type")) {
                axis.setType(-1);
            }
            if (axesType.get(cnt) != null) {
                LayoutOverlayParser.setTypeToVRectAxis(axis, (Integer)axesType.get(cnt));
            }
            ga.setAntiAliased(graph.axisAntialiased);
            ga.setSubpixelRendering(graph.subpixelRendering);
            graph.addSubpixelRenderer(ga);
            boolean enabled = dimension == 1 ? graph.xAxisViewportEnabled : graph.yAxisViewportEnabled;
            ga.setViewportEnabled(!graph.server && enabled);
            ++cnt;
        }
        if (cnt < maxGridAxes) {
            for (int i = cnt; i < maxGridAxes; ++i) {
                GridAxis ga = new GridAxis(dimension);
                if (dimension == 2) {
                    plot.addRowAxis(i, (Component)ga, primary);
                } else {
                    plot.addColumnAxis(i, (Component)ga, primary);
                }
                VRectAxis axis = ga.getAxis();
                axis.setPrimary(primary);
                LayoutOverlayParser.initAxis(graph, axis);
                ga.setVisible(false);
            }
        }
    }

    static void parseDisplaySecondary(StatGraph graph, Element elem, TrellisPlot plot, String position) {
        int maxGridAxes;
        String axisTag;
        boolean primary;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int cnt = 0;
        byte dimension = position.startsWith("R") ? (byte)2 : 1;
        boolean bl = primary = position.length() == 1;
        if (dimension == 2) {
            axisTag = "RowAxis";
            maxGridAxes = tl.getGridRows();
        } else {
            axisTag = "ColumnAxis";
            maxGridAxes = tl.getGridColumns();
        }
        for (Node node = elem.getFirstChild(); node != null && cnt < maxGridAxes; node = node.getNextSibling()) {
            GridAxis ga;
            Element nodeElem;
            String tag;
            if (!(node instanceof Element) || !(tag = (nodeElem = (Element)node).getTagName()).equals(axisTag)) continue;
            GridAxis gridAxis = ga = dimension == 2 ? (GridAxis)plot.getRowAxis(cnt, primary) : (GridAxis)plot.getColumnAxis(cnt, primary);
            if (ga == null) {
                ++cnt;
                continue;
            }
            VRectAxis axis = ga.getAxis();
            String display2 = nodeElem.getAttribute("displaySecondary");
            if (display2.length() > 0 && !display2.equalsIgnoreCase("NONE")) {
                GridAxis ga2;
                GridAxis gridAxis2 = dimension == 2 ? (GridAxis)plot.getRowAxis(cnt, !primary) : (ga2 = (GridAxis)plot.getColumnAxis(cnt, !primary));
                if (ga2 != null || LayoutLatticeParser.hasOverlayOnAxis(plot, dimension, !primary, cnt)) {
                    ++cnt;
                    continue;
                }
                ga2 = new GridAxis(dimension);
                ga2.setMirror(true);
                VRectAxis axis2 = ga2.getAxis();
                axis2.setPrimary(!primary);
                if (dimension == 2) {
                    plot.addRowAxis(cnt, (Component)ga2, !primary);
                } else {
                    plot.addColumnAxis(cnt, (Component)ga2, !primary);
                }
                boolean enabled = dimension == 1 ? graph.xAxisViewportEnabled : graph.yAxisViewportEnabled;
                LayoutOverlayParser.copyAxisOptions(axis, axis2);
                ga2.setAntiAliased(graph.axisAntialiased);
                ga2.setSubpixelRendering(graph.subpixelRendering);
                ga2.setViewportEnabled(!graph.server && enabled);
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(display2, axis2);
                graph.addSubpixelRenderer(ga2);
            }
            ++cnt;
        }
    }

    static boolean hasOverlayOnAxis(TrellisPlot plot, int dimension, boolean primary, int idx) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (dimension == 2) {
            for (int i = 0; i < tl.getGridColumns(); ++i) {
                OverlayContainer oc;
                if (!(plot.getCellItem(idx, i) instanceof OverlayContainer) || (oc = (OverlayContainer)plot.getCellItem(idx, i)).getComposite() == null) continue;
                ArrayList ov = oc.getComposite().getOverlays();
                for (int o = 0; o < ov.size(); ++o) {
                    String yaxis = ((Overlay)ov.get(o)).getYAxis();
                    if (primary && yaxis.equalsIgnoreCase("y")) {
                        return true;
                    }
                    if (primary || !yaxis.equalsIgnoreCase("y2")) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < tl.getGridRows(); ++i) {
                OverlayContainer oc;
                if (!(plot.getCellItem(i, idx) instanceof OverlayContainer) || (oc = (OverlayContainer)plot.getCellItem(i, idx)).getComposite() == null) continue;
                ArrayList ov = oc.getComposite().getOverlays();
                for (int o = 0; o < ov.size(); ++o) {
                    String xaxis = ((Overlay)ov.get(o)).getXAxis();
                    if (primary && xaxis.equalsIgnoreCase("x")) {
                        return true;
                    }
                    if (primary || !xaxis.equalsIgnoreCase("x2")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static void loadSideBar(StatGraph graph, Element elem, TrellisPlot plot) {
        String str = elem.getAttribute("align");
        boolean fill = !elem.getAttribute("spaceFill").equalsIgnoreCase("false");
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            JComponent comp;
            if (!(node instanceof Element) || (comp = StatGraph.parseComponent(graph, (Element)node, (JComponent)plot)) == null) continue;
            if (str.equalsIgnoreCase("top")) {
                plot.addGridBorderAnnotation((Component)comp, 1);
                plot.setGridAnnotationFilled(fill, 1);
                continue;
            }
            if (str.equalsIgnoreCase("bottom")) {
                plot.addGridBorderAnnotation((Component)comp, 3);
                plot.setGridAnnotationFilled(fill, 3);
                continue;
            }
            if (str.equalsIgnoreCase("left")) {
                plot.addGridBorderAnnotation((Component)comp, 2);
                plot.setGridAnnotationFilled(fill, 2);
                continue;
            }
            if (str.equalsIgnoreCase("right")) {
                plot.addGridBorderAnnotation((Component)comp, 4);
                plot.setGridAnnotationFilled(fill, 4);
                continue;
            }
            plot.addGridBorderAnnotation((Component)comp, 3);
            plot.setGridAnnotationFilled(fill, 3);
        }
    }

    public static void resolveReferences(Container container, Component oldComponent, Component[] newComponents) {
        if (oldComponent instanceof EntryStub) {
            EntryStub es = (EntryStub)oldComponent;
            es.setLayout(new BorderLayout());
            es.setBorder(null);
            es.add(newComponents[newComponents.length - 1]);
        }
    }

    public static void registerViewportListener(TrellisPlot plot, boolean hSync, boolean vSync) {
        block100: {
            int j;
            Component comp;
            GridAxisInterface axis2;
            GridAxisInterface axis;
            boolean disable_x;
            int c;
            int rows;
            int cols;
            block99: {
                GridAxis ga2;
                GridAxis ga;
                int r;
                int r2;
                cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
                rows = ((TrellisLayout)plot.getLayout()).getGridRows();
                boolean unionAllX = plot.isUniformXRange();
                boolean unionAllY = plot.isUniformYRange();
                boolean unionAllX2 = plot.isUniformX2Range();
                boolean unionAllY2 = plot.isUniformY2Range();
                boolean disable_y = false;
                boolean hasY = false;
                boolean hasY2 = false;
                for (r2 = 0; r2 < rows; ++r2) {
                    GridAxis ga3 = (GridAxis)plot.getRowAxis(r2, true);
                    GridAxis ga22 = (GridAxis)plot.getRowAxis(r2, false);
                    if (ga3 != null) {
                        hasY = true;
                    }
                    if (ga22 == null) continue;
                    hasY2 = true;
                }
                if (hasY && hasY2) {
                    boolean mirror_all = true;
                    boolean mirrorY = false;
                    boolean mirrorY2 = false;
                    for (r = 0; r < rows; ++r) {
                        ga = (GridAxis)plot.getRowAxis(r, true);
                        ga2 = (GridAxis)plot.getRowAxis(r, false);
                        if (ga == null && ga2 == null || ga != null && !ga.isVisible() && ga2 != null && !ga2.isVisible()) continue;
                        if (ga == null || ga2 == null) {
                            mirror_all = false;
                            break;
                        }
                        if (!ga.isMirror() && !ga2.isMirror()) {
                            mirror_all = false;
                            break;
                        }
                        if (ga.isMirror()) {
                            mirrorY = true;
                        }
                        if (!ga2.isMirror()) continue;
                        mirrorY2 = true;
                    }
                    if (!(!mirror_all || mirrorY && mirrorY2)) {
                        if (mirrorY) {
                            unionAllY = unionAllY2;
                        }
                    } else {
                        disable_y = true;
                    }
                } else if (hasY) {
                    for (r2 = 0; r2 < rows; ++r2) {
                        if (!LayoutLatticeParser.hasOverlayOnAxis(plot, 2, false, r2)) continue;
                        disable_y = true;
                        break;
                    }
                } else if (hasY2) {
                    for (r2 = 0; r2 < rows; ++r2) {
                        if (!LayoutLatticeParser.hasOverlayOnAxis(plot, 2, true, r2)) continue;
                        disable_y = true;
                        break;
                    }
                    unionAllY = unionAllY2;
                }
                if (disable_y) {
                    for (r2 = 0; r2 < rows; ++r2) {
                        GridAxis ga4 = (GridAxis)plot.getRowAxis(r2, true);
                        GridAxis ga23 = (GridAxis)plot.getRowAxis(r2, false);
                        if (ga4 != null) {
                            ga4.setViewportEnabled(false);
                        }
                        if (ga23 != null) {
                            ga23.setViewportEnabled(false);
                        }
                        for (c = 0; c < cols; ++c) {
                            if (!(plot.getCellItem(r2, c) instanceof OverlayContainer)) continue;
                            OverlayContainer oc = (OverlayContainer)plot.getCellItem(r2, c);
                            oc.setViewportEnabled(2, false);
                            oc.setViewportEnabled(3, false);
                        }
                    }
                }
                disable_x = false;
                boolean hasX = false;
                boolean hasX2 = false;
                for (c = 0; c < cols; ++c) {
                    ga = (GridAxis)plot.getColumnAxis(c, true);
                    ga2 = (GridAxis)plot.getColumnAxis(c, false);
                    if (ga != null) {
                        hasX = true;
                    }
                    if (ga2 == null) continue;
                    hasX2 = true;
                }
                if (hasX && hasX2) {
                    boolean mirror_all = true;
                    boolean mirrorX = false;
                    boolean mirrorX2 = false;
                    for (int c2 = 0; c2 < cols; ++c2) {
                        GridAxis ga5 = (GridAxis)plot.getColumnAxis(c2, true);
                        GridAxis ga24 = (GridAxis)plot.getColumnAxis(c2, false);
                        if (ga5 == null && ga24 == null || ga5 != null && !ga5.isVisible() && ga24 != null && !ga24.isVisible()) continue;
                        if (ga5 == null || ga24 == null) {
                            mirror_all = false;
                            break;
                        }
                        if (!ga5.isMirror() && !ga24.isMirror()) {
                            mirror_all = false;
                            break;
                        }
                        if (ga5.isMirror()) {
                            mirrorX = true;
                        }
                        if (!ga24.isMirror()) continue;
                        mirrorX2 = true;
                    }
                    if (!(!mirror_all || mirrorX && mirrorX2)) {
                        if (mirrorX) {
                            unionAllX = unionAllX2;
                        }
                    } else {
                        disable_x = true;
                    }
                } else if (hasX) {
                    for (c = 0; c < cols; ++c) {
                        if (!LayoutLatticeParser.hasOverlayOnAxis(plot, 1, false, c)) continue;
                        disable_x = true;
                        break;
                    }
                } else if (hasX2) {
                    for (c = 0; c < cols; ++c) {
                        if (!LayoutLatticeParser.hasOverlayOnAxis(plot, 1, true, c)) continue;
                        disable_x = true;
                        break;
                    }
                    unionAllX = unionAllX2;
                }
                if (disable_x) {
                    for (c = 0; c < cols; ++c) {
                        GridAxis ga6 = (GridAxis)plot.getColumnAxis(c, true);
                        GridAxis ga25 = (GridAxis)plot.getColumnAxis(c, false);
                        if (ga6 != null) {
                            ga6.setViewportEnabled(false);
                        }
                        if (ga25 != null) {
                            ga25.setViewportEnabled(false);
                        }
                        for (int r3 = 0; r3 < rows; ++r3) {
                            if (!(plot.getCellItem(r3, c) instanceof OverlayContainer)) continue;
                            OverlayContainer oc = (OverlayContainer)plot.getCellItem(r3, c);
                            oc.setViewportEnabled(0, false);
                            oc.setViewportEnabled(1, false);
                        }
                    }
                }
                if (unionAllY && !disable_y) {
                    for (r = 0; r < rows; ++r) {
                        axis = (GridAxisInterface)plot.getRowAxis(r, true);
                        axis2 = (GridAxisInterface)plot.getRowAxis(r, false);
                        for (int j2 = 0; j2 < rows; ++j2) {
                            for (int i = 0; i < cols; ++i) {
                                comp = plot.getCellItem(j2, i);
                                if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                                    ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                                }
                                if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                                    ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                                }
                                if (comp instanceof OverlayContainer) {
                                    if (axis != null && axis instanceof ViewportListener) {
                                        ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis);
                                        ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis);
                                    }
                                    if (axis2 != null && axis2 instanceof ViewportListener) {
                                        ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis2);
                                        ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis2);
                                    }
                                }
                                if (!(comp instanceof OverlayContainer)) continue;
                                OverlayContainer oc = (OverlayContainer)comp;
                                for (int jj = 0; jj < rows; ++jj) {
                                    for (int ii = 0; ii < cols; ++ii) {
                                        if (jj == j2 && ii == i || !(plot.getCellItem(jj, ii) instanceof ViewportListener)) continue;
                                        oc.addViewportListener(2, (ViewportListener)((Object)plot.getCellItem(jj, ii)));
                                        oc.addViewportListener(3, (ViewportListener)((Object)plot.getCellItem(jj, ii)));
                                    }
                                }
                            }
                        }
                        if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                            ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                        }
                        if (axis != null && axis instanceof GridAxis && axis2 instanceof ViewportListener) {
                            ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
                        }
                        for (int jj = 0; jj < rows; ++jj) {
                            GridAxisInterface raxis = (GridAxisInterface)plot.getRowAxis(jj, true);
                            GridAxisInterface raxis2 = (GridAxisInterface)plot.getRowAxis(jj, false);
                            if (jj == r) continue;
                            if (raxis != null && raxis instanceof GridAxis) {
                                if (axis instanceof ViewportListener) {
                                    ((GridAxis)raxis).addViewportListener((ViewportListener)axis);
                                }
                                if (axis2 instanceof ViewportListener) {
                                    ((GridAxis)raxis).addViewportListener((ViewportListener)axis2);
                                }
                            }
                            if (raxis2 == null || !(raxis2 instanceof GridAxis)) continue;
                            if (axis instanceof ViewportListener) {
                                ((GridAxis)raxis2).addViewportListener((ViewportListener)axis);
                            }
                            if (!(axis2 instanceof ViewportListener)) continue;
                            ((GridAxis)raxis2).addViewportListener((ViewportListener)axis2);
                        }
                    }
                } else if (!disable_y) {
                    for (r = 0; r < rows; ++r) {
                        axis = (GridAxisInterface)plot.getRowAxis(r, true);
                        axis2 = (GridAxisInterface)plot.getRowAxis(r, false);
                        for (int i = 0; i < cols; ++i) {
                            comp = plot.getCellItem(r, i);
                            if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                                ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                            }
                            if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                                ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                            }
                            if (comp instanceof OverlayContainer) {
                                if (axis != null && axis instanceof ViewportListener) {
                                    ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis);
                                    ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis);
                                }
                                if (axis2 != null && axis2 instanceof ViewportListener) {
                                    ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis2);
                                    ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis2);
                                }
                            }
                            if (!(comp instanceof OverlayContainer) || !vSync) continue;
                            OverlayContainer oc = (OverlayContainer)comp;
                            for (j = 0; j < cols; ++j) {
                                if (j == i || !(plot.getCellItem(r, j) instanceof ViewportListener)) continue;
                                oc.addViewportListener(2, (ViewportListener)((Object)plot.getCellItem(r, j)));
                                oc.addViewportListener(3, (ViewportListener)((Object)plot.getCellItem(r, j)));
                            }
                        }
                        if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                            ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                        }
                        if (axis == null || !(axis instanceof GridAxis) || !(axis2 instanceof ViewportListener)) continue;
                        ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
                    }
                }
                if (!unionAllX || disable_x) break block99;
                for (c = 0; c < cols; ++c) {
                    axis = (GridAxisInterface)plot.getColumnAxis(c, true);
                    axis2 = (GridAxisInterface)plot.getColumnAxis(c, false);
                    for (int i = 0; i < rows; ++i) {
                        for (int j3 = 0; j3 < cols; ++j3) {
                            comp = plot.getCellItem(i, j3);
                            if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                                ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                            }
                            if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                                ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                            }
                            if (comp instanceof OverlayContainer) {
                                if (axis != null && axis instanceof ViewportListener) {
                                    ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis);
                                    ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis);
                                }
                                if (axis2 != null && axis2 instanceof ViewportListener) {
                                    ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis2);
                                    ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis2);
                                }
                            }
                            if (!(comp instanceof OverlayContainer)) continue;
                            OverlayContainer oc = (OverlayContainer)comp;
                            for (int ii = 0; ii < rows; ++ii) {
                                for (int jj = 0; jj < cols; ++jj) {
                                    if (ii == i && jj == j3 || !(plot.getCellItem(ii, jj) instanceof ViewportListener)) continue;
                                    oc.addViewportListener(0, (ViewportListener)((Object)plot.getCellItem(ii, jj)));
                                    oc.addViewportListener(1, (ViewportListener)((Object)plot.getCellItem(ii, jj)));
                                }
                            }
                        }
                    }
                    if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                        ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                    }
                    if (axis != null && axis instanceof GridAxis && axis2 instanceof ViewportListener) {
                        ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
                    }
                    for (int jj = 0; jj < cols; ++jj) {
                        GridAxisInterface caxis = (GridAxisInterface)plot.getColumnAxis(jj, true);
                        GridAxisInterface caxis2 = (GridAxisInterface)plot.getColumnAxis(jj, false);
                        if (jj == c) continue;
                        if (caxis != null && caxis instanceof GridAxis) {
                            if (axis instanceof ViewportListener) {
                                ((GridAxis)caxis).addViewportListener((ViewportListener)axis);
                            }
                            if (axis2 instanceof ViewportListener) {
                                ((GridAxis)caxis).addViewportListener((ViewportListener)axis2);
                            }
                        }
                        if (caxis2 == null || !(caxis2 instanceof GridAxis)) continue;
                        if (axis instanceof ViewportListener) {
                            ((GridAxis)caxis2).addViewportListener((ViewportListener)axis);
                        }
                        if (!(axis2 instanceof ViewportListener)) continue;
                        ((GridAxis)caxis2).addViewportListener((ViewportListener)axis2);
                    }
                }
                break block100;
            }
            if (disable_x) break block100;
            for (c = 0; c < cols; ++c) {
                axis = (GridAxisInterface)plot.getColumnAxis(c, true);
                axis2 = (GridAxisInterface)plot.getColumnAxis(c, false);
                for (int i = 0; i < rows; ++i) {
                    comp = plot.getCellItem(i, c);
                    if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (comp instanceof OverlayContainer) {
                        if (axis != null && axis instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis);
                            ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis);
                        }
                        if (axis2 != null && axis2 instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis2);
                            ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis2);
                        }
                    }
                    if (!(comp instanceof OverlayContainer) || !hSync) continue;
                    OverlayContainer oc = (OverlayContainer)comp;
                    for (j = 0; j < rows; ++j) {
                        if (j == i || !(plot.getCellItem(j, c) instanceof ViewportListener)) continue;
                        oc.addViewportListener(0, (ViewportListener)((Object)plot.getCellItem(j, c)));
                        oc.addViewportListener(1, (ViewportListener)((Object)plot.getCellItem(j, c)));
                    }
                }
                if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                    ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                }
                if (axis == null || !(axis instanceof GridAxis) || !(axis2 instanceof ViewportListener)) continue;
                ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
            }
        }
    }

    public static void ignoreAspectOption(TrellisPlot plot) {
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean msgOut = false;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                OverlayContainer oc;
                Component comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer) || !((oc = (OverlayContainer)comp).getComposite().getAspectRatio() > 0.0)) continue;
                oc.getComposite().setAspectRatio(-1.0);
                msgOut = true;
            }
        }
        if (msgOut) {
            StatGraph.printDebug("\"Aspect\" option is ignored.");
        }
    }

    public static void turnOffEquateOption(TrellisPlot plot) {
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean msgOut = false;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                OverlayContainer oc;
                Component comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer) || (oc = (OverlayContainer)comp).getComposite().getSquareFormat() == Simple2DOverlayComposite.EQUATED_NONE) continue;
                oc.getComposite().setSquareFormat(Simple2DOverlayComposite.EQUATED_NONE);
                msgOut = true;
            }
        }
        if (msgOut) {
            StatGraph.printDebug("\"Equate\" option is turned off.");
        }
    }

    public static void unifyGridAxisViewport(TrellisPlot plot) {
        boolean unifyX2;
        boolean unifyY2;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean unionAllX = plot.isUniformXRange();
        boolean unionAllY = plot.isUniformYRange();
        boolean unionAllX2 = plot.isUniformX2Range();
        boolean unionAllY2 = plot.isUniformY2Range();
        double yvmin = Double.NaN;
        double yvmax = Double.NaN;
        double y2vmin = Double.NaN;
        double y2vmax = Double.NaN;
        for (int i = 0; i < rows; ++i) {
            VRectAxis ax;
            if (plot.getRowAxis(i, true) != null) {
                ax = ((GridAxis)plot.getRowAxis(i, true)).getAxis();
                if (!Double.isNaN(ax.getViewportMin())) {
                    yvmin = Double.isNaN(yvmin) ? ax.getViewportMin() : Math.min(yvmin, ax.getViewportMin());
                }
                if (!Double.isNaN(ax.getViewportMax())) {
                    yvmax = Double.isNaN(yvmax) ? ax.getViewportMax() : Math.max(yvmax, ax.getViewportMax());
                }
            }
            if (plot.getRowAxis(i, false) == null) continue;
            ax = ((GridAxis)plot.getRowAxis(i, false)).getAxis();
            if (!Double.isNaN(ax.getViewportMin())) {
                y2vmin = Double.isNaN(y2vmin) ? ax.getViewportMin() : Math.min(y2vmin, ax.getViewportMin());
            }
            if (Double.isNaN(ax.getViewportMax())) continue;
            y2vmax = Double.isNaN(y2vmax) ? ax.getViewportMax() : Math.max(y2vmax, ax.getViewportMax());
        }
        boolean unifyY = unionAllY && (!Double.isNaN(yvmin) || !Double.isNaN(yvmax));
        boolean bl = unifyY2 = unionAllY2 && (!Double.isNaN(y2vmin) || !Double.isNaN(y2vmax));
        if (unifyY || unifyY2) {
            for (int i = 0; i < rows; ++i) {
                VRectAxis ax;
                if (unifyY && plot.getRowAxis(i, true) != null) {
                    ax = ((GridAxis)plot.getRowAxis(i, true)).getAxis();
                    ax.setViewportMin(yvmin);
                    ax.setViewportMax(yvmax);
                    ax.setViewport(yvmin, yvmax);
                }
                if (!unifyY2 || plot.getRowAxis(i, false) == null) continue;
                ax = ((GridAxis)plot.getRowAxis(i, false)).getAxis();
                ax.setViewportMin(y2vmin);
                ax.setViewportMax(y2vmax);
                ax.setViewport(y2vmin, y2vmax);
            }
        }
        double xvmin = Double.NaN;
        double xvmax = Double.NaN;
        double x2vmin = Double.NaN;
        double x2vmax = Double.NaN;
        for (int i = 0; i < cols; ++i) {
            VRectAxis ax;
            if (plot.getColumnAxis(i, true) != null) {
                ax = ((GridAxis)plot.getColumnAxis(i, true)).getAxis();
                if (!Double.isNaN(ax.getViewportMin())) {
                    xvmin = Double.isNaN(xvmin) ? ax.getViewportMin() : Math.min(xvmin, ax.getViewportMin());
                }
                if (!Double.isNaN(ax.getViewportMax())) {
                    xvmax = Double.isNaN(xvmax) ? ax.getViewportMax() : Math.max(xvmax, ax.getViewportMax());
                }
            }
            if (plot.getColumnAxis(i, false) == null) continue;
            ax = ((GridAxis)plot.getColumnAxis(i, false)).getAxis();
            if (!Double.isNaN(ax.getViewportMin())) {
                x2vmin = Double.isNaN(x2vmin) ? ax.getViewportMin() : Math.min(x2vmin, ax.getViewportMin());
            }
            if (Double.isNaN(ax.getViewportMax())) continue;
            x2vmax = Double.isNaN(x2vmax) ? ax.getViewportMax() : Math.max(x2vmax, ax.getViewportMax());
        }
        boolean unifyX = unionAllX && (!Double.isNaN(xvmin) || !Double.isNaN(xvmax));
        boolean bl2 = unifyX2 = unionAllX2 && (!Double.isNaN(x2vmin) || !Double.isNaN(x2vmax));
        if (unifyX || unifyX2) {
            for (int i = 0; i < cols; ++i) {
                VRectAxis ax;
                if (unifyX && plot.getColumnAxis(i, true) != null) {
                    ax = ((GridAxis)plot.getColumnAxis(i, true)).getAxis();
                    ax.setViewportMin(xvmin);
                    ax.setViewportMax(xvmax);
                    ax.setViewport(xvmin, xvmax);
                }
                if (!unifyX2 || plot.getColumnAxis(i, false) == null) continue;
                ax = ((GridAxis)plot.getColumnAxis(i, false)).getAxis();
                ax.setViewportMin(x2vmin);
                ax.setViewportMax(x2vmax);
                ax.setViewport(x2vmin, x2vmax);
            }
        }
    }

    public static void unifyViewport(TrellisPlot plot) {
        boolean unifyY2;
        Component comp;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean unionAllX = plot.isUniformXRange();
        boolean unionAllY = plot.isUniformYRange();
        boolean unionAllX2 = plot.isUniformX2Range();
        boolean unionAllY2 = plot.isUniformY2Range();
        double xvmin = Double.NaN;
        double xvmax = Double.NaN;
        double yvmin = Double.NaN;
        double yvmax = Double.NaN;
        double x2vmin = Double.NaN;
        double x2vmax = Double.NaN;
        double y2vmin = Double.NaN;
        double y2vmax = Double.NaN;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer)) continue;
                Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    VRectAxis ax = (VRectAxis)axes[i];
                    if (ax.getDimension() == 1) {
                        if (!Double.isNaN(ax.getViewportMin())) {
                            if (Double.isNaN(xvmin)) {
                                if (ax.getPrimary()) {
                                    xvmin = ax.getViewportMin();
                                } else {
                                    x2vmin = ax.getViewportMin();
                                }
                            } else if (ax.getPrimary()) {
                                xvmin = Math.min(xvmin, ax.getViewportMin());
                            } else {
                                x2vmin = Math.min(x2vmin, ax.getViewportMin());
                            }
                        }
                        if (Double.isNaN(ax.getViewportMax())) continue;
                        if (Double.isNaN(xvmax)) {
                            if (ax.getPrimary()) {
                                xvmax = ax.getViewportMax();
                                continue;
                            }
                            x2vmax = ax.getViewportMax();
                            continue;
                        }
                        if (ax.getPrimary()) {
                            xvmax = Math.max(xvmax, ax.getViewportMax());
                            continue;
                        }
                        x2vmax = Math.max(x2vmax, ax.getViewportMax());
                        continue;
                    }
                    if (ax.getDimension() != 2) continue;
                    if (!Double.isNaN(ax.getViewportMin())) {
                        if (Double.isNaN(yvmin)) {
                            if (ax.getPrimary()) {
                                yvmin = ax.getViewportMin();
                            } else {
                                y2vmin = ax.getViewportMin();
                            }
                        } else if (ax.getPrimary()) {
                            yvmin = Math.min(yvmin, ax.getViewportMin());
                        } else {
                            y2vmin = Math.min(y2vmin, ax.getViewportMin());
                        }
                    }
                    if (Double.isNaN(ax.getViewportMax())) continue;
                    if (Double.isNaN(yvmax)) {
                        if (ax.getPrimary()) {
                            yvmax = ax.getViewportMax();
                            continue;
                        }
                        y2vmax = ax.getViewportMax();
                        continue;
                    }
                    if (ax.getPrimary()) {
                        yvmax = Math.max(yvmax, ax.getViewportMax());
                        continue;
                    }
                    y2vmax = Math.max(y2vmax, ax.getViewportMax());
                }
            }
        }
        boolean unifyX = unionAllX && (!Double.isNaN(xvmin) || !Double.isNaN(xvmax));
        boolean unifyY = unionAllY && (!Double.isNaN(yvmin) || !Double.isNaN(yvmax));
        boolean unifyX2 = unionAllX2 && (!Double.isNaN(x2vmin) || !Double.isNaN(x2vmax));
        boolean bl = unifyY2 = unionAllY2 && (!Double.isNaN(y2vmin) || !Double.isNaN(y2vmax));
        if (unifyX || unifyY || unifyX2 || unifyY2) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    comp = plot.getCellItem(r, c);
                    if (!(comp instanceof OverlayContainer)) continue;
                    Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                    for (int i = 0; i < axes.length; ++i) {
                        VRectAxis ax = (VRectAxis)axes[i];
                        if (unifyX && ax.getDimension() == 1 && ax.getPrimary()) {
                            ax.setViewport(xvmin, xvmax);
                            continue;
                        }
                        if (unifyX2 && ax.getDimension() == 1 && !ax.getPrimary()) {
                            ax.setViewport(x2vmin, x2vmax);
                            continue;
                        }
                        if (unifyY && ax.getDimension() == 2 && ax.getPrimary()) {
                            ax.setViewport(yvmin, yvmax);
                            continue;
                        }
                        if (!unifyY2 || ax.getDimension() != 2 || ax.getPrimary()) continue;
                        ax.setViewport(y2vmin, y2vmax);
                    }
                }
            }
        }
    }

    public static void addAxesRangeToRangeMerger(TrellisPlot plot, boolean addXAxis, boolean addX2Axis, boolean addYAxis, boolean addY2Axis) {
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Simple2DOverlayComposite soc;
                Component comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer) || (soc = ((OverlayContainer)comp).getComposite()) == null) continue;
                soc.addAxesToRangeMerger(addXAxis, addX2Axis, addYAxis, addY2Axis);
            }
        }
    }

    public static void unifyColumnViewport(TrellisPlot plot) {
        LayoutLatticeParser.unifyColumnViewport(plot, true, true);
    }

    public static void unifyColumnViewport(TrellisPlot plot, boolean hSync, boolean h2Sync) {
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int c = 0; c < cols; ++c) {
            boolean unifyX2;
            Component comp;
            double xvmin = Double.NaN;
            double xvmax = Double.NaN;
            double x2vmin = Double.NaN;
            double x2vmax = Double.NaN;
            for (int r = 0; r < rows; ++r) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer)) continue;
                Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    VRectAxis ax = (VRectAxis)axes[i];
                    if (ax.getDimension() != 1) continue;
                    if (!Double.isNaN(ax.getViewportMin())) {
                        if (Double.isNaN(xvmin)) {
                            if (ax.getPrimary()) {
                                xvmin = ax.getViewportMin();
                            } else {
                                x2vmin = ax.getViewportMin();
                            }
                        } else if (ax.getPrimary()) {
                            xvmin = Math.min(xvmin, ax.getViewportMin());
                        } else {
                            x2vmin = Math.min(x2vmin, ax.getViewportMin());
                        }
                    }
                    if (Double.isNaN(ax.getViewportMax())) continue;
                    if (Double.isNaN(xvmax)) {
                        if (ax.getPrimary()) {
                            xvmax = ax.getViewportMax();
                            continue;
                        }
                        x2vmax = ax.getViewportMax();
                        continue;
                    }
                    if (ax.getPrimary()) {
                        xvmax = Math.max(xvmax, ax.getViewportMax());
                        continue;
                    }
                    x2vmax = Math.max(x2vmax, ax.getViewportMax());
                }
            }
            boolean unifyX = hSync && (!Double.isNaN(xvmin) || !Double.isNaN(xvmax));
            boolean bl = unifyX2 = h2Sync && (!Double.isNaN(x2vmin) || !Double.isNaN(x2vmax));
            if (!unifyX && !unifyX2) continue;
            for (int r = 0; r < rows; ++r) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer)) continue;
                Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    VRectAxis ax = (VRectAxis)axes[i];
                    if (unifyX && ax.getDimension() == 1 && ax.getPrimary()) {
                        ax.setViewport(xvmin, xvmax);
                        continue;
                    }
                    if (!unifyX2 || ax.getDimension() != 1 || ax.getPrimary()) continue;
                    ax.setViewport(x2vmin, x2vmax);
                }
            }
        }
    }

    public static void unifyRowViewport(TrellisPlot plot) {
        LayoutLatticeParser.unifyRowViewport(plot, true, true);
    }

    public static void unifyRowViewport(TrellisPlot plot, boolean vSync, boolean v2Sync) {
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int r = 0; r < rows; ++r) {
            boolean unifyY2;
            Component comp;
            double yvmin = Double.NaN;
            double yvmax = Double.NaN;
            double y2vmin = Double.NaN;
            double y2vmax = Double.NaN;
            for (int c = 0; c < cols; ++c) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer)) continue;
                Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    VRectAxis ax = (VRectAxis)axes[i];
                    if (ax.getDimension() != 2) continue;
                    if (!Double.isNaN(ax.getViewportMin())) {
                        if (Double.isNaN(yvmin)) {
                            if (ax.getPrimary()) {
                                yvmin = ax.getViewportMin();
                            } else {
                                y2vmin = ax.getViewportMin();
                            }
                        } else if (ax.getPrimary()) {
                            yvmin = Math.min(yvmin, ax.getViewportMin());
                        } else {
                            y2vmin = Math.min(y2vmin, ax.getViewportMin());
                        }
                    }
                    if (Double.isNaN(ax.getViewportMax())) continue;
                    if (Double.isNaN(yvmax)) {
                        if (ax.getPrimary()) {
                            yvmax = ax.getViewportMax();
                            continue;
                        }
                        y2vmax = ax.getViewportMax();
                        continue;
                    }
                    if (ax.getPrimary()) {
                        yvmax = Math.max(yvmax, ax.getViewportMax());
                        continue;
                    }
                    y2vmax = Math.max(y2vmax, ax.getViewportMax());
                }
            }
            boolean unifyY = vSync && (!Double.isNaN(yvmin) || !Double.isNaN(yvmax));
            boolean bl = unifyY2 = v2Sync && (!Double.isNaN(y2vmin) || !Double.isNaN(y2vmax));
            if (!unifyY && !unifyY2) continue;
            for (int c = 0; c < cols; ++c) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof OverlayContainer)) continue;
                Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    VRectAxis ax = (VRectAxis)axes[i];
                    if (unifyY && ax.getDimension() == 2 && ax.getPrimary()) {
                        ax.setViewport(yvmin, yvmax);
                        continue;
                    }
                    if (!unifyY2 || ax.getDimension() != 2 || ax.getPrimary()) continue;
                    ax.setViewport(y2vmin, y2vmax);
                }
            }
        }
    }

    public static void setupInternalAxes(TrellisPlot plot, boolean xUnion, boolean yUnion) {
        LayoutLatticeParser.setupInternalAxes(plot, xUnion, yUnion, xUnion, yUnion, true, false);
    }

    public static void setupInternalAxes(TrellisPlot plot, boolean xUnion, boolean yUnion, boolean x2Union, boolean y2Union) {
        LayoutLatticeParser.setupInternalAxes(plot, xUnion, yUnion, x2Union, y2Union, true, false);
    }

    public static void setupInternalAxes(TrellisPlot plot, boolean xUnion, boolean yUnion, boolean x2Union, boolean y2Union, boolean propagateAxisLines) {
        LayoutLatticeParser.setupInternalAxes(plot, xUnion, yUnion, x2Union, y2Union, propagateAxisLines, false);
    }

    public static void setupInternalAxes(TrellisPlot plot, boolean xUnion, boolean yUnion, boolean x2Union, boolean y2Union, boolean propagateAxisLines, boolean internalized) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        boolean yUnion_sav = yUnion;
        boolean y2Union_sav = y2Union;
        for (int i = 0; i < tl.getGridRows(); ++i) {
            GridAxis ga2;
            GridAxis ga;
            yUnion = yUnion_sav;
            y2Union = y2Union_sav;
            if (plot.getRowAxis(i, true) == null && plot.getRowAxis(i, false) == null) continue;
            if (yUnion || y2Union) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                int j;
                ga = (GridAxis)plot.getRowAxis(i, true);
                ga2 = (GridAxis)plot.getRowAxis(i, false);
                if (ga == null) {
                    yUnion = false;
                } else if (ga.isMirror()) {
                    yUnion = y2Union;
                }
                if (ga2 == null) {
                    y2Union = false;
                } else if (ga2.isMirror()) {
                    y2Union = yUnion;
                }
                boolean hasMarginOverlay = false;
                boolean[] hasY = new boolean[tl.getGridColumns()];
                boolean[] hasY2 = new boolean[tl.getGridColumns()];
                VRectAxis yaxis = null;
                VRectAxis y2axis = null;
                for (j = 0; j < tl.getGridColumns(); ++j) {
                    if (!(tl.getCell(i, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Wall wall = soc.getWall();
                    hasMarginOverlay |= soc.hasMarginOverlay((byte)2);
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectGridLines gBar;
                        VRectGridLines grid;
                        VRectAxis a;
                        if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != 2) continue;
                        if (a.getPrimary()) {
                            if (!yUnion) continue;
                            LayoutOverlayParser.copyAxisOptions(ga.getAxis(), a);
                            hasY[j] = true;
                            if (yaxis == null) {
                                yaxis = a;
                            }
                            LayoutOverlayParser.turnOffHistogramBinAxis(soc, a);
                        } else {
                            if (!y2Union) continue;
                            LayoutOverlayParser.copyAxisOptions(ga2.getAxis(), a);
                            hasY2[j] = true;
                            if (y2axis == null) {
                                y2axis = a;
                            }
                            LayoutOverlayParser.turnOffHistogramBinAxis(soc, a);
                        }
                        a.setVisible(false);
                        if (propagateAxisLines) {
                            if (ga != null && ga.getAxis().isVisible() && ga.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setYAxisLineOn(true);
                            }
                            if (ga2 != null && ga2.getAxis().isVisible() && ga2.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setY2AxisLineOn(true);
                            }
                        } else {
                            if (j == 0 && ga != null && ga.getAxis().isVisible() && ga.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setYAxisLineOn(true);
                            }
                            if (j == tl.getGridColumns() - 1 && ga2 != null && ga2.getAxis().isVisible() && ga2.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setY2AxisLineOn(true);
                            }
                        }
                        if (ga != null && ga.getAxis().isGridVisible() && a.getPrimary() || ga2 != null && ga2.getAxis().isGridVisible() && !a.getPrimary()) {
                            grid = new VRectGridLines();
                            if (a.getPrimary()) {
                                grid.setLineStyle(ga.getAxis().getGridStyle());
                            } else {
                                grid.setLineStyle(ga2.getAxis().getGridStyle());
                            }
                            soc.connect(grid, a);
                        } else {
                            grid = soc.getGridLines(a);
                            if (grid != null) {
                                soc.removeGridLines(grid);
                            }
                        }
                        if (ga != null && ga.getAxis().isGreenBarOn() && a.getPrimary() || ga2 != null && ga2.getAxis().isGreenBarOn() && !a.getPrimary()) {
                            gBar = new VRectGridLines();
                            soc.connectGreenBar(gBar, a);
                        } else {
                            gBar = soc.getGreenBar(a);
                            if (gBar != null) {
                                soc.removeGreenBar(gBar);
                            }
                        }
                        if (a.getPrimary() && !plot.isUniformYRange()) {
                            a.setViewport(ga.getAxis().getViewportMin(), ga.getAxis().getViewportMax());
                        }
                        if (a.getPrimary() || plot.isUniformY2Range()) continue;
                        a.setViewport(ga2.getAxis().getViewportMin(), ga2.getAxis().getViewportMax());
                    }
                }
                for (j = 0; j < tl.getGridColumns(); ++j) {
                    VRectGridLines gBar;
                    VRectGridLines grid;
                    ArrayList addOn;
                    if (!(tl.getCell(i, j).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null || (addOn = oc.getAllAddOns()) != null && addOn.size() == 1 && addOn.get(0) instanceof EntryComposite && ((EntryComposite)addOn.get(0)).isDropsite()) continue;
                    if (yUnion && ga != null && ga.getAxis().isGridVisible() && !hasY[j] && yaxis != null) {
                        grid = new VRectGridLines();
                        grid.setLineStyle(ga.getAxis().getGridStyle());
                        soc.connect(grid, yaxis);
                    }
                    if (y2Union && ga2 != null && ga2.getAxis().isGridVisible() && !hasY2[j] && y2axis != null) {
                        grid = new VRectGridLines();
                        grid.setLineStyle(ga2.getAxis().getGridStyle());
                        soc.connect(grid, y2axis);
                    }
                    if (yUnion && ga != null && ga.getAxis().isGreenBarOn() && !hasY[j] && yaxis != null) {
                        gBar = new VRectGridLines();
                        soc.connectGreenBar(gBar, yaxis);
                    }
                    if (!y2Union || ga2 == null || !ga2.getAxis().isGreenBarOn() || hasY2[j] || y2axis == null) continue;
                    gBar = new VRectGridLines();
                    soc.connectGreenBar(gBar, y2axis);
                }
                if (yUnion && ga != null) {
                    ga.getAxis().getAxisStyle().setAxisLineOn(false);
                    ga.setIgnoreOffset(hasMarginOverlay);
                }
                if (y2Union && ga2 != null) {
                    ga2.getAxis().getAxisStyle().setAxisLineOn(false);
                    ga2.setIgnoreOffset(hasMarginOverlay);
                }
                if (!yUnion && ga != null) {
                    ga.setVisible(false);
                }
                if (y2Union || ga2 == null) continue;
                ga2.setVisible(false);
                continue;
            }
            ga = (GridAxis)plot.getRowAxis(i, true);
            ga2 = (GridAxis)plot.getRowAxis(i, false);
            if (internalized) {
                for (int j = 0; j < tl.getGridColumns(); ++j) {
                    OverlayContainer oc;
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectAxis a;
                        if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != 2) continue;
                        if (a.getPrimary()) {
                            LayoutOverlayParser.copyAxisOptions(ga.getAxis(), a);
                            LayoutOverlayParser.setCategorySortByColumn(soc.getOverlays(), null, null, a, null);
                            continue;
                        }
                        LayoutOverlayParser.copyAxisOptions(ga2.getAxis(), a);
                        LayoutOverlayParser.setCategorySortByColumn(soc.getOverlays(), null, null, null, a);
                    }
                }
            }
            if (ga != null) {
                ga.setVisible(false);
            }
            if (ga2 == null) continue;
            ga2.setVisible(false);
        }
        boolean xUnion_sav = xUnion;
        boolean x2Union_sav = x2Union;
        for (int j = 0; j < tl.getGridColumns(); ++j) {
            GridAxis ga2;
            GridAxis ga;
            xUnion = xUnion_sav;
            x2Union = x2Union_sav;
            if (plot.getColumnAxis(j, true) == null && plot.getColumnAxis(j, false) == null) continue;
            if (xUnion || x2Union) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                int i;
                ga = (GridAxis)plot.getColumnAxis(j, true);
                ga2 = (GridAxis)plot.getColumnAxis(j, false);
                if (ga == null) {
                    xUnion = false;
                } else if (ga.isMirror()) {
                    xUnion = x2Union;
                }
                if (ga2 == null) {
                    x2Union = false;
                } else if (ga2.isMirror()) {
                    x2Union = xUnion;
                }
                boolean hasMarginOverlay = false;
                boolean[] hasX = new boolean[tl.getGridRows()];
                boolean[] hasX2 = new boolean[tl.getGridRows()];
                VRectAxis xaxis = null;
                VRectAxis x2axis = null;
                for (i = 0; i < tl.getGridRows(); ++i) {
                    if (!(tl.getCell(i, j).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Wall wall = soc.getWall();
                    hasMarginOverlay |= soc.hasMarginOverlay((byte)1);
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectGridLines gBar;
                        VRectGridLines grid;
                        VRectAxis a;
                        if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != 1) continue;
                        if (a.getPrimary()) {
                            if (!xUnion) continue;
                            LayoutOverlayParser.copyAxisOptions(ga.getAxis(), a);
                            hasX[i] = true;
                            if (xaxis == null) {
                                xaxis = a;
                            }
                            LayoutOverlayParser.turnOffHistogramBinAxis(soc, a);
                        } else {
                            if (!x2Union) continue;
                            LayoutOverlayParser.copyAxisOptions(ga2.getAxis(), a);
                            hasX2[i] = true;
                            if (x2axis == null) {
                                x2axis = a;
                            }
                            LayoutOverlayParser.turnOffHistogramBinAxis(soc, a);
                        }
                        a.setVisible(false);
                        if (propagateAxisLines) {
                            if (ga != null && ga.getAxis().isVisible() && ga.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setXAxisLineOn(true);
                            }
                            if (ga2 != null && ga2.getAxis().isVisible() && ga2.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setX2AxisLineOn(true);
                            }
                        } else {
                            if (i == tl.getGridRows() - 1 && ga != null && ga.getAxis().isVisible() && ga.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setXAxisLineOn(true);
                            }
                            if (i == 0 && ga2 != null && ga2.getAxis().isVisible() && ga2.getAxis().getAxisStyle().isAxisLineOn()) {
                                wall.setX2AxisLineOn(true);
                            }
                        }
                        if (ga != null && ga.getAxis().isGridVisible() && a.getPrimary() || ga2 != null && ga2.getAxis().isGridVisible() && !a.getPrimary()) {
                            grid = new VRectGridLines();
                            if (a.getPrimary()) {
                                grid.setLineStyle(ga.getAxis().getGridStyle());
                            } else {
                                grid.setLineStyle(ga2.getAxis().getGridStyle());
                            }
                            soc.connect(grid, a);
                        } else {
                            grid = soc.getGridLines(a);
                            if (grid != null) {
                                soc.removeGridLines(grid);
                            }
                        }
                        if (ga != null && ga.getAxis().isGreenBarOn() && a.getPrimary() || ga2 != null && ga2.getAxis().isGreenBarOn() && !a.getPrimary()) {
                            gBar = new VRectGridLines();
                            soc.connectGreenBar(gBar, a);
                        } else {
                            gBar = soc.getGreenBar(a);
                            if (gBar != null) {
                                soc.removeGreenBar(gBar);
                            }
                        }
                        if (a.getPrimary() && !plot.isUniformXRange()) {
                            a.setViewport(ga.getAxis().getViewportMin(), ga.getAxis().getViewportMax());
                        }
                        if (a.getPrimary() || plot.isUniformX2Range()) continue;
                        a.setViewport(ga2.getAxis().getViewportMin(), ga2.getAxis().getViewportMax());
                    }
                }
                for (i = 0; i < tl.getGridRows(); ++i) {
                    VRectGridLines gBar;
                    VRectGridLines grid;
                    ArrayList addOn;
                    if (!(tl.getCell(i, j).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null || (addOn = oc.getAllAddOns()) != null && addOn.size() == 1 && addOn.get(0) instanceof EntryComposite && ((EntryComposite)addOn.get(0)).isDropsite()) continue;
                    if (xUnion && ga != null && ga.getAxis().isGridVisible() && !hasX[i] && xaxis != null) {
                        grid = new VRectGridLines();
                        grid.setLineStyle(ga.getAxis().getGridStyle());
                        soc.connect(grid, xaxis);
                    }
                    if (x2Union && ga2 != null && ga2.getAxis().isGridVisible() && !hasX2[i] && x2axis != null) {
                        grid = new VRectGridLines();
                        grid.setLineStyle(ga2.getAxis().getGridStyle());
                        soc.connect(grid, x2axis);
                    }
                    if (xUnion && ga != null && ga.getAxis().isGreenBarOn() && !hasX[i] && xaxis != null) {
                        gBar = new VRectGridLines();
                        soc.connectGreenBar(gBar, xaxis);
                    }
                    if (!x2Union || ga2 == null || !ga2.getAxis().isGreenBarOn() || hasX2[i] || x2axis == null) continue;
                    gBar = new VRectGridLines();
                    soc.connectGreenBar(gBar, x2axis);
                }
                if (xUnion && ga != null) {
                    ga.getAxis().getAxisStyle().setAxisLineOn(false);
                    ga.setIgnoreOffset(hasMarginOverlay);
                }
                if (x2Union && ga2 != null) {
                    ga2.getAxis().getAxisStyle().setAxisLineOn(false);
                    ga2.setIgnoreOffset(hasMarginOverlay);
                }
                if (!xUnion && ga != null) {
                    ga.setVisible(false);
                }
                if (x2Union || ga2 == null) continue;
                ga2.setVisible(false);
                continue;
            }
            ga = (GridAxis)plot.getColumnAxis(j, true);
            ga2 = (GridAxis)plot.getColumnAxis(j, false);
            if (internalized) {
                for (int i = 0; i < tl.getGridRows(); ++i) {
                    BaseOverlayContainer oc;
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i, j).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectAxis a;
                        if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != 1) continue;
                        if (a.getPrimary()) {
                            LayoutOverlayParser.copyAxisOptions(ga.getAxis(), a);
                            LayoutOverlayParser.setCategorySortByColumn(soc.getOverlays(), a, null, null, null);
                            continue;
                        }
                        LayoutOverlayParser.copyAxisOptions(ga2.getAxis(), a);
                        LayoutOverlayParser.setCategorySortByColumn(soc.getOverlays(), null, a, null, null);
                    }
                }
            }
            if (ga != null) {
                ga.setVisible(false);
            }
            if (ga2 == null) continue;
            ga2.setVisible(false);
        }
    }

    public static void decideRowColumnAxisTypes(TrellisPlot plot) {
        VRectAxis vra;
        int i;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        for (i = 0; i < tl.getGridRows(); ++i) {
            if (plot.getRowAxis(i, true) != null && (vra = ((GridAxis)plot.getRowAxis(i, true)).getAxis()).getType() < 0) {
                if (((GridAxis)plot.getRowAxis(i, true)).isMirror()) {
                    vra.setType(LayoutLatticeParser.getAxisType(plot, i, 2, false));
                } else {
                    vra.setType(LayoutLatticeParser.getAxisType(plot, i, 2, true));
                }
            }
            if (plot.getRowAxis(i, false) == null || (vra = ((GridAxis)plot.getRowAxis(i, false)).getAxis()).getType() >= 0) continue;
            if (((GridAxis)plot.getRowAxis(i, false)).isMirror()) {
                vra.setType(LayoutLatticeParser.getAxisType(plot, i, 2, true));
                continue;
            }
            vra.setType(LayoutLatticeParser.getAxisType(plot, i, 2, false));
        }
        for (i = 0; i < tl.getGridColumns(); ++i) {
            if (plot.getColumnAxis(i, true) != null && (vra = ((GridAxis)plot.getColumnAxis(i, true)).getAxis()).getType() < 0) {
                if (((GridAxis)plot.getColumnAxis(i, true)).isMirror()) {
                    vra.setType(LayoutLatticeParser.getAxisType(plot, i, 1, false));
                } else {
                    vra.setType(LayoutLatticeParser.getAxisType(plot, i, 1, true));
                }
            }
            if (plot.getColumnAxis(i, false) == null || (vra = ((GridAxis)plot.getColumnAxis(i, false)).getAxis()).getType() >= 0) continue;
            if (((GridAxis)plot.getColumnAxis(i, false)).isMirror()) {
                vra.setType(LayoutLatticeParser.getAxisType(plot, i, 1, true));
                continue;
            }
            vra.setType(LayoutLatticeParser.getAxisType(plot, i, 1, false));
        }
    }

    public static int getAxisType(TrellisPlot plot, int rowCol, int dimension, boolean primary) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (dimension == 1) {
            for (int i = 0; i < tl.getGridRows(); ++i) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                if (!(tl.getCell(i, rowCol).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, rowCol).getItem()).getComposite()) == null) continue;
                Object[] axes = soc.getAxes();
                for (int k = 0; k < axes.length; ++k) {
                    VRectAxis a;
                    if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != dimension || a.getPrimary() != primary) continue;
                    return a.getType();
                }
            }
        } else {
            for (int i = 0; i < tl.getGridColumns(); ++i) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                if (!(tl.getCell(rowCol, i).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(rowCol, i).getItem()).getComposite()) == null) continue;
                Object[] axes = soc.getAxes();
                for (int k = 0; k < axes.length; ++k) {
                    VRectAxis a;
                    if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != dimension || a.getPrimary() != primary) continue;
                    return a.getType();
                }
            }
        }
        return 0;
    }

    public static void unifyRowColumnAxisType(TrellisPlot plot) {
        boolean hasLog2;
        boolean hasLinear2;
        VRectAxis vra;
        int i;
        boolean hasLog;
        boolean hasLinear;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (plot.isUniformYRange()) {
            hasLinear = false;
            hasLog = false;
            for (i = 0; i < tl.getGridRows(); ++i) {
                if (plot.getRowAxis(i, true) == null) continue;
                vra = ((GridAxis)plot.getRowAxis(i, true)).getAxis();
                if (vra.getType() == 0) {
                    hasLinear = true;
                    continue;
                }
                if (vra.getType() != 1) continue;
                hasLog = true;
            }
            if (hasLog && hasLinear) {
                for (i = 0; i < tl.getGridRows(); ++i) {
                    if (plot.getRowAxis(i, true) == null || (vra = ((GridAxis)plot.getRowAxis(i, true)).getAxis()).getType() != 1) continue;
                    vra.setType(0);
                }
            }
        }
        if (plot.isUniformY2Range()) {
            hasLinear2 = false;
            hasLog2 = false;
            for (i = 0; i < tl.getGridRows(); ++i) {
                if (plot.getRowAxis(i, false) == null) continue;
                vra = ((GridAxis)plot.getRowAxis(i, false)).getAxis();
                if (vra.getType() == 0) {
                    hasLinear2 = true;
                    continue;
                }
                if (vra.getType() != 1) continue;
                hasLog2 = true;
            }
            if (hasLog2 && hasLinear2) {
                for (i = 0; i < tl.getGridRows(); ++i) {
                    if (plot.getRowAxis(i, false) == null || (vra = ((GridAxis)plot.getRowAxis(i, false)).getAxis()).getType() != 1) continue;
                    vra.setType(0);
                }
            }
        }
        if (plot.isUniformXRange()) {
            hasLinear = false;
            hasLog = false;
            for (i = 0; i < tl.getGridColumns(); ++i) {
                if (plot.getColumnAxis(i, true) == null) continue;
                vra = ((GridAxis)plot.getColumnAxis(i, true)).getAxis();
                if (vra.getType() == 0) {
                    hasLinear = true;
                    continue;
                }
                if (vra.getType() != 1) continue;
                hasLog = true;
            }
            if (hasLog && hasLinear) {
                for (i = 0; i < tl.getGridColumns(); ++i) {
                    if (plot.getColumnAxis(i, true) == null || (vra = ((GridAxis)plot.getColumnAxis(i, true)).getAxis()).getType() != 1) continue;
                    vra.setType(0);
                }
            }
        }
        if (plot.isUniformX2Range()) {
            hasLinear2 = false;
            hasLog2 = false;
            for (i = 0; i < tl.getGridColumns(); ++i) {
                if (plot.getColumnAxis(i, false) == null) continue;
                vra = ((GridAxis)plot.getColumnAxis(i, false)).getAxis();
                if (vra.getType() == 0) {
                    hasLinear2 = true;
                    continue;
                }
                if (vra.getType() != 1) continue;
                hasLog2 = true;
            }
            if (hasLog2 && hasLinear2) {
                for (i = 0; i < tl.getGridColumns(); ++i) {
                    if (plot.getColumnAxis(i, false) == null || (vra = ((GridAxis)plot.getColumnAxis(i, false)).getAxis()).getType() != 1) continue;
                    vra.setType(0);
                }
            }
        }
    }

    public static boolean isLogToLinearAxis(TrellisPlot plot, int rowCol, int dimension, boolean primary) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (dimension == 1) {
            for (int i = 0; i < tl.getGridRows(); ++i) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                if (!(tl.getCell(i, rowCol).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(i, rowCol).getItem()).getComposite()) == null) continue;
                Object[] axes = soc.getAxes();
                for (int k = 0; k < axes.length; ++k) {
                    VRectAxis a;
                    if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != dimension || a.getPrimary() != primary || a.getType() != 0) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < tl.getGridColumns(); ++i) {
                BaseOverlayContainer oc;
                Simple2DOverlayComposite soc;
                if (!(tl.getCell(rowCol, i).getItem() instanceof BaseOverlayContainer) || (soc = (oc = (BaseOverlayContainer)tl.getCell(rowCol, i).getItem()).getComposite()) == null) continue;
                Object[] axes = soc.getAxes();
                for (int k = 0; k < axes.length; ++k) {
                    VRectAxis a;
                    if (!(axes[k] instanceof AbstractAxis) || (a = (VRectAxis)axes[k]).getDimension() != dimension || a.getPrimary() != primary || a.getType() != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void setupAxesLabelAlignment(TrellisPlot plot, boolean alignColumnAxesLabel, boolean alignRowAxesLabel) {
        int a;
        Object[] axes;
        Simple2DOverlayComposite soc;
        Insets si;
        Component comp;
        GridAxisInterface axis2;
        GridAxisInterface axis;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int r = 0; r < rows; ++r) {
            axis = (GridAxisInterface)plot.getRowAxis(r, true);
            axis2 = (GridAxisInterface)plot.getRowAxis(r, false);
            if (axis != null && axis instanceof GridAxis) {
                ((GridAxis)axis).getAxis().setTitlePositionedAtMax(alignRowAxesLabel);
            }
            if (axis2 == null || !(axis2 instanceof GridAxis)) continue;
            ((GridAxis)axis2).getAxis().setTitlePositionedAtMax(alignRowAxesLabel);
        }
        for (int c = 0; c < cols; ++c) {
            axis = (GridAxisInterface)plot.getColumnAxis(c, true);
            axis2 = (GridAxisInterface)plot.getColumnAxis(c, false);
            if (axis != null && axis instanceof GridAxis) {
                ((GridAxis)axis).getAxis().setTitlePositionedAtMax(alignColumnAxesLabel);
            }
            if (axis2 == null || !(axis2 instanceof GridAxis)) continue;
            ((GridAxis)axis2).getAxis().setTitlePositionedAtMax(alignColumnAxesLabel);
        }
        if (alignColumnAxesLabel) {
            for (int j = 0; j < rows; ++j) {
                int i;
                boolean xAlign = alignColumnAxesLabel;
                boolean x2Align = alignColumnAxesLabel;
                for (i = 0; i < cols; ++i) {
                    comp = plot.getCellItem(j, i);
                    if (!(comp instanceof OverlayContainer)) continue;
                    if (!((OverlayContainer)comp).getMarginsAligned()) {
                        xAlign = false;
                        x2Align = false;
                        break;
                    }
                    si = ((OverlayContainer)comp).getSurroundingInsets();
                    if (si.top > 0) {
                        x2Align = false;
                    }
                    if (si.bottom <= 0) continue;
                    xAlign = false;
                }
                for (i = 0; i < cols; ++i) {
                    comp = plot.getCellItem(j, i);
                    if (!(comp instanceof OverlayContainer) || (soc = ((OverlayContainer)comp).getComposite()) == null) continue;
                    axes = soc.getAxes();
                    for (a = 0; a < axes.length; ++a) {
                        if (axes[a] == null || !(axes[a] instanceof VRectAxis) || ((VRectAxis)axes[a]).getDimension() != 1) continue;
                        if (((VRectAxis)axes[a]).getPrimary()) {
                            ((VRectAxis)axes[a]).setTitlePositionedAtMax(xAlign);
                            continue;
                        }
                        ((VRectAxis)axes[a]).setTitlePositionedAtMax(x2Align);
                    }
                }
            }
        }
        if (alignRowAxesLabel) {
            for (int i = 0; i < cols; ++i) {
                int j;
                boolean yAlign = alignRowAxesLabel;
                boolean y2Align = alignRowAxesLabel;
                for (j = 0; j < rows; ++j) {
                    comp = plot.getCellItem(j, i);
                    if (!(comp instanceof OverlayContainer)) continue;
                    if (!((OverlayContainer)comp).getMarginsAligned()) {
                        yAlign = false;
                        y2Align = false;
                        break;
                    }
                    si = ((OverlayContainer)comp).getSurroundingInsets();
                    if (si.left > 0) {
                        yAlign = false;
                    }
                    if (si.right <= 0) continue;
                    y2Align = false;
                }
                for (j = 0; j < rows; ++j) {
                    comp = plot.getCellItem(j, i);
                    if (!(comp instanceof OverlayContainer) || (soc = ((OverlayContainer)comp).getComposite()) == null) continue;
                    axes = soc.getAxes();
                    for (a = 0; a < axes.length; ++a) {
                        if (axes[a] == null || !(axes[a] instanceof VRectAxis) || ((VRectAxis)axes[a]).getDimension() != 2) continue;
                        if (((VRectAxis)axes[a]).getPrimary()) {
                            ((VRectAxis)axes[a]).setTitlePositionedAtMax(yAlign);
                            continue;
                        }
                        ((VRectAxis)axes[a]).setTitlePositionedAtMax(y2Align);
                    }
                }
            }
        }
    }

    public static void parseRowColumnAxesType(StatGraph graph, Element rowAxes, Element row2Axes, Element columnAxes, Element column2Axes, TrellisPlot plot, int row, int col, LinkedHashMap rowAxesType, LinkedHashMap row2AxesType, LinkedHashMap colAxesType, LinkedHashMap col2AxesType, int[] rowColumnDataRange, int[] rowColumn2DataRange, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        String elemTag;
        Node node;
        int i;
        Iterator I;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        rowColumnAxesType[0] = -1;
        if (rowColumnDataRange[0] != 0) {
            if (rowColumnDataRange[0] == 1 && rowAxesType.get(row) != null) {
                rowColumnAxesType[0] = (Integer)rowAxesType.get(row);
            } else if (rowColumnDataRange[0] == 2 && rowAxesType.size() > 0) {
                I = rowAxesType.values().iterator();
                rowColumnAxesType[0] = (Integer)I.next();
            } else if (rowAxes != null) {
                i = 0;
                for (node = rowAxes.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("RowAxis")) continue;
                    if (i == row) {
                        rowColumnAxesType[0] = LayoutLatticeParser.parseAxisType((Element)node);
                        break;
                    }
                    ++i;
                }
            }
        }
        rowColumn2AxesType[0] = -1;
        if (rowColumn2DataRange[0] != 0) {
            if (rowColumn2DataRange[0] == 1 && row2AxesType.get(row) != null) {
                rowColumn2AxesType[0] = (Integer)row2AxesType.get(row);
            } else if (rowColumn2DataRange[0] == 2 && row2AxesType.size() > 0) {
                I = row2AxesType.values().iterator();
                rowColumn2AxesType[0] = (Integer)I.next();
            } else if (row2Axes != null) {
                i = 0;
                for (node = row2Axes.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("RowAxis")) continue;
                    if (i == row) {
                        rowColumn2AxesType[0] = LayoutLatticeParser.parseAxisType((Element)node);
                        break;
                    }
                    ++i;
                }
            }
        }
        rowColumnAxesType[1] = -1;
        if (rowColumnDataRange[1] != 0) {
            if (rowColumnDataRange[1] == 1 && colAxesType.get(col) != null) {
                rowColumnAxesType[1] = (Integer)colAxesType.get(col);
            } else if (rowColumnDataRange[1] == 2 && colAxesType.size() > 0) {
                I = colAxesType.values().iterator();
                rowColumnAxesType[1] = (Integer)I.next();
            } else if (columnAxes != null) {
                i = 0;
                for (node = columnAxes.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("ColumnAxis")) continue;
                    if (i == col) {
                        rowColumnAxesType[1] = LayoutLatticeParser.parseAxisType((Element)node);
                        break;
                    }
                    ++i;
                }
            }
        }
        rowColumn2AxesType[1] = -1;
        if (rowColumn2DataRange[1] != 0) {
            if (rowColumn2DataRange[1] == 1 && col2AxesType.get(col) != null) {
                rowColumn2AxesType[1] = (Integer)col2AxesType.get(col);
            } else if (rowColumn2DataRange[1] == 2 && col2AxesType.size() > 0) {
                I = col2AxesType.values().iterator();
                rowColumn2AxesType[1] = (Integer)I.next();
            } else if (column2Axes != null) {
                i = 0;
                for (node = column2Axes.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("ColumnAxis")) continue;
                    if (i == col) {
                        rowColumn2AxesType[1] = LayoutLatticeParser.parseAxisType((Element)node);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private static int parseAxisType(Element axisElem) {
        String str = axisElem.getAttribute("type");
        int type = str.equalsIgnoreCase("LINEAR") ? 0 : (str.equalsIgnoreCase("TIME") ? 1 : (str.equalsIgnoreCase("DISCRETE") ? 2 : (str.equalsIgnoreCase("LOG") ? 3 : -1)));
        return type;
    }

    private static void setCurrentRowColumnAxesType(JComponent comp, int row, int col, LinkedHashMap rowAxesType, LinkedHashMap row2AxesType, LinkedHashMap colAxesType, LinkedHashMap col2AxesType) {
        OverlayContainer oc;
        Simple2DOverlayComposite soc;
        if (comp instanceof OverlayContainer && (soc = (oc = (OverlayContainer)comp).getComposite()) != null) {
            Object[] axes = soc.getAxes();
            for (int k = 0; k < axes.length; ++k) {
                VRectAxis a;
                if (!(axes[k] instanceof AbstractAxis) || !soc.hasOverlayOnAxis(a = (VRectAxis)axes[k])) continue;
                if (a.getDimension() == 2 && a.getPrimary()) {
                    if (rowAxesType.get(row) != null) continue;
                    rowAxesType.put(row, LayoutLatticeParser.convertAxisType(a.getType(), a.getDataRange(a.getDimension())));
                    continue;
                }
                if (a.getDimension() == 2 && !a.getPrimary()) {
                    if (row2AxesType.get(row) != null) continue;
                    row2AxesType.put(row, LayoutLatticeParser.convertAxisType(a.getType(), a.getDataRange(a.getDimension())));
                    continue;
                }
                if (a.getDimension() == 1 && a.getPrimary()) {
                    if (colAxesType.get(col) != null) continue;
                    colAxesType.put(col, LayoutLatticeParser.convertAxisType(a.getType(), a.getDataRange(a.getDimension())));
                    continue;
                }
                if (a.getDimension() != 1 || a.getPrimary() || col2AxesType.get(col) != null) continue;
                col2AxesType.put(col, LayoutLatticeParser.convertAxisType(a.getType(), a.getDataRange(a.getDimension())));
            }
        }
    }

    private static int convertAxisType(int axisType, DataRange dr) {
        switch (axisType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 6: {
                if (dr instanceof BinnedRange) {
                    return 0;
                }
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    private static void getRowColumnDataRange(Element elem, int[] rowColumnDataRange, int[] rowColumn2DataRange) {
        String str = elem.getAttribute("rowDataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (str.equalsIgnoreCase("union")) {
                rowColumnDataRange[0] = 1;
            } else if (str.equalsIgnoreCase("unionall")) {
                rowColumnDataRange[0] = 2;
            }
        } else {
            rowColumnDataRange[0] = 0;
        }
        str = elem.getAttribute("columnDataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (str.equalsIgnoreCase("union")) {
                rowColumnDataRange[1] = 1;
            } else if (str.equalsIgnoreCase("unionall")) {
                rowColumnDataRange[1] = 2;
            }
        } else {
            rowColumnDataRange[1] = 0;
        }
        str = elem.getAttribute("row2DataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (str.equalsIgnoreCase("union")) {
                rowColumn2DataRange[0] = 1;
            } else if (str.equalsIgnoreCase("unionall")) {
                rowColumn2DataRange[0] = 2;
            }
        } else {
            rowColumn2DataRange[0] = 0;
        }
        str = elem.getAttribute("column2DataRange");
        if (str.length() > 0 && !str.equalsIgnoreCase("data")) {
            if (str.equalsIgnoreCase("union")) {
                rowColumn2DataRange[1] = 1;
            } else if (str.equalsIgnoreCase("unionall")) {
                rowColumn2DataRange[1] = 2;
            }
        } else {
            rowColumn2DataRange[1] = 0;
        }
    }
}

