/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.overlays.WaterfallChartOverlay;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LayoutDataMatrixParser {
    public static final String RB_KEY = "LayoutDataLatticeParser.";

    public static TrellisPlot load(StatGraph graph, Element elem) {
        graph.pushFontsShrinkage(elem);
        TrellisPlot plot = (TrellisPlot)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new TrellisPlot();
        }
        LayoutDataMatrixParser.load(graph, elem, plot);
        graph.popFontsShrinkage(elem);
        return plot;
    }

    public static void load(StatGraph graph, Element elem, TrellisPlot plot) {
        ArrayList axes;
        int totalCells;
        double percent;
        Message msg;
        int maxPages;
        Object cls;
        int sortOrder;
        String[] classValues;
        ColumnMetadata cmd;
        plot.disableLayout();
        GraphComponentParser.load(graph, elem, (JComponent)plot, null);
        StatGraph.parseBorderOpts(graph, (JComponent)plot, elem, null);
        LayoutDataLatticeParser.DataLatticeProperties pp = new LayoutDataLatticeParser.DataLatticeProperties();
        pp.isDataPanel = false;
        String str = elem.getAttribute("includeMissingClass");
        if (str.equalsIgnoreCase("false")) {
            pp.includeMissing = false;
        }
        pp.inLookup = new HashMap();
        Object clsvv = null;
        StringVariable[] rvv = null;
        StringVariable[] cvv = null;
        DataModel model = null;
        int page = 0;
        String dataName = null;
        int numRows = 1;
        int numCols = 1;
        pp.maxNumCols = 1;
        pp.maxNumRows = 1;
        pp.startCol = 0;
        pp.startRow = 0;
        String[] rowVars = null;
        Element rElem = StatGraph.getOptionAttrsElement(elem, "RowVars");
        if (rElem != null) {
            rowVars = StatGraph.parseStringValueList(rElem, "Value");
        }
        if (rowVars != null) {
            dataName = StatGraph.getDataName(rowVars[0]);
        }
        String[] colVars = null;
        Element cElem = StatGraph.getOptionAttrsElement(elem, "ColumnVars");
        if (cElem != null) {
            colVars = StatGraph.parseStringValueList(cElem, "Value");
        }
        String dn = null;
        if (colVars != null) {
            dn = StatGraph.getDataName(colVars[0]);
        }
        if (dataName == null || dataName.length() == 0) {
            dataName = dn;
        } else if (dn != null && dn.length() > 0 && !dn.equals(dataName)) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "data2.txt"));
            return;
        }
        int cnt = 0;
        if (rowVars != null) {
            cnt += rowVars.length;
        }
        if (colVars != null) {
            cnt += colVars.length;
        }
        String[] vars = new String[cnt];
        if (rowVars != null) {
            for (int i = 0; i < rowVars.length; ++i) {
                vars[i] = rowVars[i];
            }
        }
        if (colVars != null) {
            int offset = rowVars == null ? 0 : rowVars.length;
            for (int i = 0; i < colVars.length; ++i) {
                vars[i + offset] = colVars[i];
            }
        }
        HashMap sortOrderMap = LayoutDataLatticeParser.parseSortOrder(graph, elem, vars, null);
        model = graph.getData(dataName);
        OLAPVariableFactory fac = null;
        ArrayList<String> rowDimNames = null;
        ArrayList<String> colDimNames = null;
        if (model == null) {
            model = graph.getOLAPModel(dataName);
            if (model == null) {
                pp.degenerated = true;
            } else {
                fac = model.getOLAPVarFactory();
            }
        }
        pp.dataModel = model;
        if (rowVars != null) {
            rvv = new StringVariable[rowVars.length];
            int numLevels = 1;
            if (StatGraph.isOLAP()) {
                rowDimNames = new ArrayList<String>();
            }
            for (int i = 0; i < rowVars.length; ++i) {
                String rowVarID = StatGraph.getVarID(rowVars[i]);
                StringVariable rowClassVar = null;
                if (StatGraph.isOLAP()) {
                    rowDimNames.add(rowVarID);
                    rowClassVar = StatGraph.getOLAPLevelVar(fac, rowVarID);
                    rowClassVar.getUniqueValueCount();
                    rvv[rvv.length - 1 - i] = rowClassVar;
                    continue;
                }
                int rowcol = model.getColumn(rowVarID);
                cmd = (ColumnMetadata)model.getColumnLabel(rowcol);
                rowClassVar = new StringVectorVariable();
                rowClassVar.setLabel(cmd.getLabel());
                if (pp.includeMissing) {
                    classValues = model.getColumnAsClassColumn(rowcol, true);
                    ((StringVectorVariable)rowClassVar).setBlankMissing(false);
                } else {
                    if (!StatGraph.checkVariable("ROWVAR", cmd, null, 1, true)) {
                        return;
                    }
                    classValues = model.getColumnAsClassColumn(rowcol, false);
                }
                ((StringVectorVariable)rowClassVar).connectFrom(classValues);
                sortOrder = -1;
                if (sortOrderMap != null && sortOrderMap.get(rowVars[i]) != null) {
                    sortOrder = (Integer)sortOrderMap.get(rowVars[i]);
                }
                cls = sortOrder == -1 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, rowcol, pp) : null) : LayoutDataLatticeParser.getSortedClasses(model, rowcol, pp, cmd.getType(), sortOrder);
                if (cls != null) {
                    pp.inLookup.put(rowClassVar, cls);
                }
                numLevels *= LayoutDataLatticeParser.getNumLevels(rowClassVar, pp);
                rvv[rvv.length - 1 - i] = rowClassVar;
            }
            if (StatGraph.isOLAP()) {
                numLevels = LayoutDataLatticeParser.getNumLevels(fac, rowDimNames);
            }
            pp.maxNumRows = numRows = numLevels;
        }
        if (colVars != null) {
            cvv = new StringVariable[colVars.length];
            StringVariable columnClassVar = null;
            int numLevels = 1;
            if (StatGraph.isOLAP()) {
                colDimNames = new ArrayList<String>();
            }
            for (int i = 0; i < colVars.length; ++i) {
                String columnVarID = StatGraph.getVarID(colVars[i]);
                if (StatGraph.isOLAP()) {
                    colDimNames.add(columnVarID);
                    columnClassVar = StatGraph.getOLAPLevelVar(fac, columnVarID);
                    columnClassVar.getUniqueValueCount();
                    cvv[cvv.length - 1 - i] = columnClassVar;
                    continue;
                }
                int columncol = model.getColumn(columnVarID);
                cmd = (ColumnMetadata)model.getColumnLabel(columncol);
                columnClassVar = new StringVectorVariable();
                columnClassVar.setLabel(cmd.getLabel());
                if (pp.includeMissing) {
                    classValues = model.getColumnAsClassColumn(columncol, true);
                    ((StringVectorVariable)columnClassVar).setBlankMissing(false);
                } else {
                    if (!StatGraph.checkVariable("COLUMNVAR", cmd, null, 1, true)) {
                        return;
                    }
                    classValues = model.getColumnAsClassColumn(columncol, false);
                }
                ((StringVectorVariable)columnClassVar).connectFrom(classValues);
                sortOrder = -1;
                if (sortOrderMap != null && sortOrderMap.get(colVars[i]) != null) {
                    sortOrder = (Integer)sortOrderMap.get(colVars[i]);
                }
                cls = sortOrder == -1 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, columncol, pp) : null) : LayoutDataLatticeParser.getSortedClasses(model, columncol, pp, cmd.getType(), sortOrder);
                if (cls != null) {
                    pp.inLookup.put(columnClassVar, cls);
                }
                numLevels *= LayoutDataLatticeParser.getNumLevels(columnClassVar, pp);
                cvv[cvv.length - 1 - i] = columnClassVar;
            }
            if (StatGraph.isOLAP()) {
                numLevels = LayoutDataLatticeParser.getNumLevels(fac, colDimNames);
            }
            pp.maxNumCols = numCols = numLevels;
        }
        int rows = -1;
        int cols = -1;
        str = elem.getAttribute("rows");
        if (str.length() > 0) {
            if (LayoutDataMatrixParser.isMDDataLattice(rvv, cvv)) {
                Message msg2 = new Message(RB.getStringResource(RB_KEY, "mdoption.fmt.txt"));
                StatGraph.printNote(msg2.toString((Object)"ROWS", (Object)str));
            } else {
                numRows = rows = Integer.parseInt(str);
            }
        }
        if ((str = elem.getAttribute("columns")).length() > 0) {
            if (LayoutDataMatrixParser.isMDDataLattice(rvv, cvv)) {
                Message msg3 = new Message(RB.getStringResource(RB_KEY, "mdoption.fmt.txt"));
                StatGraph.printNote(msg3.toString((Object)"COLUMNS", (Object)str));
            } else {
                numCols = cols = Integer.parseInt(str);
            }
        }
        if ((rows > 0 || cols > 0) && (str = elem.getAttribute("panelNumber")).length() > 0) {
            page = Integer.parseInt(str) - 1;
        }
        pp.maxNumPages = maxPages = (int)(Math.ceil((double)pp.maxNumRows / (double)numRows) * Math.ceil((double)pp.maxNumCols / (double)numCols));
        if (!elem.hasAttribute("panelNumber")) {
            graph.setNumPages(maxPages);
        }
        if (page < 0) {
            msg = new Message(RB.getStringResource(RB_KEY, "page.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1)));
            return;
        }
        if (page >= maxPages) {
            msg = new Message(RB.getStringResource(RB_KEY, "page2.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
            page = maxPages - 1;
        }
        int askedTotalCols = (pp.maxNumCols + numCols - 1) / numCols * numCols;
        pp.startRow = numCols * page / askedTotalCols * numRows;
        pp.startCol = numCols * page % askedTotalCols;
        str = elem.getAttribute("cellWidthMin");
        int minCellWidth = 100;
        if (StatGraph.isLineThickness(str)) {
            minCellWidth = graph.unit2LineThickness(str);
        }
        str = elem.getAttribute("cellHeightMin");
        int minCellHeight = 100;
        if (StatGraph.isLineThickness(str)) {
            minCellHeight = graph.unit2LineThickness(str);
        }
        if (numRows == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "row.txt"));
            return;
        }
        if (numCols == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "column.txt"));
            return;
        }
        pp.insideHeader = false;
        pp.rowHeaders = 1;
        pp.columnHeaders = 4;
        pp.includeNameInHeader = false;
        pp.extractHeaderName = true;
        pp.headerBorder = false;
        pp.sharedAxes = StatGraph.getOptionAttrsElement(elem, "LayoutPrototype3D") == null && StatGraph.getOptionAttrsElement(elem, "LayoutPrototypeRegion") == null;
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("headerBorderAttrs"), pp.headerBorderStyle, "AxisLines");
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("headerLabelAttrs"), pp.headerLabelStyle, "ValueText");
        Element la = StatGraph.getOptionAttrsElement(elem, "HeaderLabelAttrs");
        if (la != null) {
            StatGraph.parseTextAttrs(graph, la, pp.headerLabelStyle);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("extractedHeaderNameAttrs"), pp.headerExtractedLabelStyle, "LabelText");
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("extractedHeaderLevelNameAttrs"), pp.headerExtractedLevelLabelStyle, "Label2Text");
        EntryConcatParser.defaultTextStyle = pp.headerLabelStyle;
        GraphStyle.setDefaultFillStyle(graph, "", pp.wallFillStyle, "WallFill");
        GraphStyle.setDefaultFillStyle(graph, "", pp.headerFillStyle, "HeaderFill");
        Color bgColor = StatGraph.parseAttrColor("headerBackgroundColor", graph, elem);
        if (bgColor != null) {
            pp.headerFillStyle.setColor(bgColor);
        }
        if ((str = elem.getAttribute("headerOpaque")).equalsIgnoreCase("false")) {
            pp.headerFillStyle.setTransparency(1.0);
        }
        TrellisLayout tl = new TrellisLayout(numRows, numCols, 0, 0);
        tl.setMinCellSize(new Dimension(minCellWidth, minCellHeight));
        plot.setLayout((LayoutManager)tl);
        str = elem.getAttribute("leftAxisWidthMax");
        if (StatGraph.isNumber(str) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRowAxisWidthPercentage(percent);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("rightAxisWidthMax")) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRow2AxisWidthPercentage(percent);
        }
        tl.setGridAttrs(pp.headerBorderStyle);
        plot.setRowHeaderLabelPosition(1);
        plot.setColumnHeaderLabelPosition(2);
        boolean[] sortBy = LayoutDataLatticeParser.isSortByPlot(elem);
        boolean colSort = sortBy[0];
        boolean rowSort = sortBy[1];
        str = elem.getAttribute("skipEmptyCells");
        if (str.equalsIgnoreCase("true")) {
            pp.showEmptyCells = false;
        }
        if (!pp.showEmptyCells) {
            tl.setEmptyCellsSkipped(true);
        }
        if (LayoutDataLatticeParser.getPanelCellCount(pp, numRows, numCols, page, totalCells = pp.maxNumRows * pp.maxNumCols) > graph.panelCellMax) {
            graph.setNumPages(0);
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "cellmax.txt"));
            return;
        }
        VRectAxis rowAxis = new VRectAxis(2);
        LayoutOverlayParser.initAxis(graph, rowAxis);
        rowAxis.setType(-1);
        rowAxis.setCompressExtender(true);
        rowAxis.setTitlePositionedAtMax(true);
        plot.setRowAxisLabelPosition(1);
        rowAxis.setLabelPosition(2);
        VRectAxis columnAxis = new VRectAxis(1);
        LayoutOverlayParser.initAxis(graph, columnAxis);
        columnAxis.setType(-1);
        columnAxis.setCompressExtender(true);
        columnAxis.setTitlePositionedAtMax(true);
        if (colVars != null) {
            plot.setColumnAxisLabelPosition(2);
            columnAxis.setLabelPosition(0);
        }
        VRectAxis row2Axis = new VRectAxis(2);
        LayoutOverlayParser.initAxis(graph, row2Axis);
        row2Axis.setType(-1);
        row2Axis.setCompressExtender(true);
        row2Axis.setTitlePositionedAtMax(true);
        plot.setRow2AxisLabelPosition(1);
        row2Axis.setLabelPosition(2);
        VRectAxis column2Axis = new VRectAxis(1);
        LayoutOverlayParser.initAxis(graph, column2Axis);
        column2Axis.setType(-1);
        column2Axis.setCompressExtender(true);
        column2Axis.setTitlePositionedAtMax(true);
        if (!pp.degenerated || StatGraph.isOLAP()) {
            pp.rowAxisAltDisplay = "TICKS TICKVALUES LABEL";
            pp.rowAxisDisplay2 = "NONE";
            pp.rowAxisAltDisplay2 = "NONE";
            pp.colAxisAltDisplay = "TICKS TICKVALUES LABEL";
            pp.colAxisDisplay2 = "NONE";
            pp.colAxisAltDisplay2 = "NONE";
            pp.row2AxisAltDisplay = "TICKS TICKVALUES LABEL";
            pp.row2AxisDisplay2 = "NONE";
            pp.row2AxisAltDisplay2 = "NONE";
            pp.col2AxisAltDisplay = "TICKS TICKVALUES LABEL";
            pp.col2AxisDisplay2 = "NONE";
            pp.col2AxisAltDisplay2 = "NONE";
            rowAxis.getAxisStyle().setAxisLineOn(false);
            row2Axis.getAxisStyle().setAxisLineOn(false);
            columnAxis.getAxisStyle().setAxisLineOn(false);
            column2Axis.getAxisStyle().setAxisLineOn(false);
        }
        boolean xWeight = true;
        boolean yWeight = true;
        Element ovlyElem = StatGraph.getOptionAttrsElement(elem, "LayoutPrototypeOverlay2D");
        if (ovlyElem != null) {
            Element axisOpts;
            if (rowSort) {
                graph.yUnionAllPages = false;
                plot.setUniformYRange(false);
                graph.y2UnionAllPages = false;
                plot.setUniformY2Range(false);
            }
            if (colSort) {
                graph.xUnionAllPages = false;
                plot.setUniformXRange(false);
                graph.x2UnionAllPages = false;
                plot.setUniformX2Range(false);
            }
            if ((axisOpts = StatGraph.getOptionAttrsElement(ovlyElem, "XAxisOpts")) != null) {
                LayoutOverlayParser.parseAxisCompOpts(graph, null, axisOpts, columnAxis);
                if (!axisOpts.hasAttribute("type")) {
                    columnAxis.setType(-1);
                }
                if (axisOpts.hasAttribute("display")) {
                    pp.colAxisAltDisplay = axisOpts.getAttribute("display");
                }
            }
            if ((axisOpts = StatGraph.getOptionAttrsElement(ovlyElem, "YAxisOpts")) != null) {
                LayoutOverlayParser.parseAxisCompOpts(graph, null, axisOpts, rowAxis);
                if (!axisOpts.hasAttribute("type")) {
                    rowAxis.setType(-1);
                }
                if (axisOpts.hasAttribute("display")) {
                    pp.rowAxisAltDisplay = axisOpts.getAttribute("display");
                }
            }
            if ((axisOpts = StatGraph.getOptionAttrsElement(ovlyElem, "Y2AxisOpts")) != null) {
                LayoutOverlayParser.parseAxisCompOpts(graph, null, axisOpts, row2Axis);
                if (!axisOpts.hasAttribute("type")) {
                    row2Axis.setType(-1);
                }
                if (axisOpts.hasAttribute("display")) {
                    pp.row2AxisAltDisplay = axisOpts.getAttribute("display");
                }
            }
            int[] rowColumnAxesType = new int[]{LayoutDataMatrixParser.convertAxisType(columnAxis.getType()), LayoutDataMatrixParser.convertAxisType(rowAxis.getType())};
            int[] rowColumn2AxesType = new int[]{LayoutDataMatrixParser.convertAxisType(column2Axis.getType()), LayoutDataMatrixParser.convertAxisType(row2Axis.getType())};
            LayoutOverlayParser.decideAxesType(graph, ovlyElem, rowColumnAxesType, rowColumn2AxesType);
            if (LayoutOverlayParser.xAxisType == 2) {
                if (columnAxis.getFitPolicy() == null) {
                    columnAxis.setTickLabeling("STAGGERTRUNCATEDROP");
                }
                if (StatGraph.isOLAP()) {
                    columnAxis.getAxisStyle().setTitleStyle(pp.headerExtractedLevelLabelStyle);
                }
            }
            if (LayoutOverlayParser.yAxisType == 2 && StatGraph.isOLAP()) {
                rowAxis.getAxisStyle().setTitleStyle(pp.headerExtractedLevelLabelStyle);
            }
            if (LayoutOverlayParser.y2AxisType == 2 && StatGraph.isOLAP()) {
                row2Axis.getAxisStyle().setTitleStyle(pp.headerExtractedLevelLabelStyle);
            }
            if ((str = ovlyElem.getAttribute("xDataRange")).equalsIgnoreCase("UNION")) {
                graph.xUnionAllPages = false;
            } else if (str.equalsIgnoreCase("UNIONALL")) {
                plot.setUniformXRange(true);
                graph.xUnionAllPages = true;
            } else {
                if (LayoutOverlayParser.xAxisType == 2) {
                    graph.xUnionAllPages = false;
                } else {
                    plot.setUniformXRange(true);
                    graph.xUnionAllPages = true;
                }
                if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                    StatGraph.printOptionError("XDATARANGE", str);
                }
            }
            if (!Double.isNaN(columnAxis.getViewportMin()) && !Double.isNaN(columnAxis.getViewportMax())) {
                graph.xUnionAllPages = false;
            }
            if ((str = ovlyElem.getAttribute("yDataRange")).equalsIgnoreCase("UNION")) {
                graph.yUnionAllPages = false;
            } else if (str.equalsIgnoreCase("UNIONALL")) {
                plot.setUniformYRange(true);
                graph.yUnionAllPages = true;
            } else {
                if (LayoutOverlayParser.yAxisType == 2) {
                    graph.yUnionAllPages = false;
                } else {
                    plot.setUniformYRange(true);
                    graph.yUnionAllPages = true;
                }
                if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                    StatGraph.printOptionError("YDATARANGE", str);
                }
            }
            if (!Double.isNaN(rowAxis.getViewportMin()) && !Double.isNaN(rowAxis.getViewportMax())) {
                graph.yUnionAllPages = false;
            }
            if ((str = ovlyElem.getAttribute("y2DataRange")).equalsIgnoreCase("UNION")) {
                graph.y2UnionAllPages = false;
            } else if (str.equalsIgnoreCase("UNIONALL")) {
                plot.setUniformY2Range(true);
                graph.y2UnionAllPages = true;
            } else {
                if (LayoutOverlayParser.y2AxisType == 2) {
                    graph.y2UnionAllPages = false;
                } else {
                    plot.setUniformY2Range(true);
                    graph.y2UnionAllPages = true;
                }
                if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                    StatGraph.printOptionError("Y2DATARANGE", str);
                }
            }
            if (!Double.isNaN(row2Axis.getViewportMin()) && !Double.isNaN(row2Axis.getViewportMax())) {
                graph.y2UnionAllPages = false;
            }
            if ((str = elem.getAttribute("yWeights")).length() == 0 || str.equalsIgnoreCase("AUTO")) {
                if (LayoutOverlayParser.yAxisType == 2) {
                    yWeight = false;
                }
            } else if (!str.equalsIgnoreCase("EQUAL")) {
                if (str.equalsIgnoreCase("PROPORTIONAL")) {
                    yWeight = false;
                } else {
                    StatGraph.printOptionError("YWEIGHTS", str);
                }
            }
            if ((str = elem.getAttribute("xWeights")).length() == 0 || str.equalsIgnoreCase("AUTO")) {
                if (LayoutOverlayParser.xAxisType == 2) {
                    xWeight = false;
                }
            } else if (!str.equalsIgnoreCase("EQUAL")) {
                if (str.equalsIgnoreCase("PROPORTIONAL")) {
                    xWeight = false;
                } else {
                    StatGraph.printOptionError("XWEIGHTS", str);
                }
            }
        }
        graph.whereDataModelName = dataName;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element nodeElem = (Element)node;
            String elemTag = nodeElem.getTagName();
            if (elemTag.startsWith("Draw")) {
                SGAnnotationContainer ac = new SGAnnotationContainer((Container)plot, graph.rootPanel);
                AbstractAnno text = AnnotateParser.load(graph, nodeElem, (AnnotationContainer)ac);
                if (text == null) continue;
                if ("back".equalsIgnoreCase(nodeElem.getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
                continue;
            }
            if (!LayoutDataMatrixParser.isValidStamp(elemTag)) continue;
            if (pp.degenerated) {
                if (ovlyElem != null) {
                    BaseOverlayContainer oc = (BaseOverlayContainer)LayoutOverlayParser.load(graph, nodeElem);
                    plot.addCellItem(0, 0, (Component)oc);
                    if (StatGraph.isOLAP()) {
                        DataTreeGroupNode tree;
                        Entry e;
                        String lab;
                        oc.getComposite().getWall().setEdgeOn(false);
                        DataModel m = (DataModel)graph.olapData.get(0);
                        fac = m.getOLAPVarFactory();
                        plot.createRowOLAPHeader();
                        plot.createColumnOLAPHeader();
                        ArrayList<String> list = new ArrayList<String>();
                        if (m.yCategoryVar != null) {
                            list.add(m.yCategoryVar);
                            rowAxis.getAxisStyle().setMajorTickMarksOn(false);
                            rowAxis.getAxisStyle().setLabelsOn(false);
                            rowAxis.getAxisStyle().setTitleOn(false);
                            pp.rowAxisAltDisplay = "none";
                            lab = fac.getHierachyLabel(m.yCategoryVar);
                            e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + lab.trim() + " ", 90.0);
                            plot.addRowOLAPHeaderTitle((Component)e, true);
                            tree = fac.createSubTree(list);
                            double theta = pp.verticalRowHeaders ? 90.0 : 0.0;
                            LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, theta, plot.getRowOLAPHeaderLevels(true), rowAxis);
                            plot.setRowOLAPHeaderTree(tree, true);
                            plot.setRowOLAPHeaderBackground(pp.headerFillStyle.getColor());
                        } else if (m.xCategoryVar != null) {
                            list.add(m.xCategoryVar);
                            columnAxis.getAxisStyle().setMajorTickMarksOn(false);
                            columnAxis.getAxisStyle().setLabelsOn(false);
                            columnAxis.getAxisStyle().setTitleOn(false);
                            pp.colAxisAltDisplay = "none";
                            lab = fac.getHierachyLabel(m.xCategoryVar);
                            e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + lab.trim() + " ", 0.0);
                            plot.addColumnOLAPHeaderTitle((Component)e, true);
                            tree = fac.createSubTree(list);
                            WaterfallChartOverlay.addFinalCategoryToTree(tree, null, oc);
                            LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, 0.0, plot.getColumnOLAPHeaderLevels(true), columnAxis);
                            plot.setColumnOLAPHeaderTree(tree, true);
                            plot.setColumnOLAPHeaderBackground(pp.headerFillStyle.getColor());
                        }
                        LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, 1, 1);
                        String[] xAxisLabel = LayoutDataLatticeParser.getAxisLabel(oc, (byte)1, true);
                        String[] yAxisLabel = LayoutDataLatticeParser.getAxisLabel(oc, (byte)2, true, rowAxis.isDisplayStackedLabels());
                        String[] xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(oc, (byte)1, false);
                        String[] yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(oc, (byte)2, false, row2Axis.isDisplayStackedLabels());
                        LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, columnAxis, row2Axis, column2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
                        continue;
                    }
                    oc.getComposite().getWall().setEdgeOn(true);
                    oc.getComposite().getWall().setEdgeStyle(pp.headerBorderStyle);
                    Object[] axes2 = oc.getComposite().getAxes();
                    for (int i = 0; i < axes2.length; ++i) {
                        VRectAxis vr = (VRectAxis)axes2[i];
                        if (vr.getDimension() == 2) {
                            VRectAxis rAxis;
                            VRectAxis vRectAxis = rAxis = vr.getPrimary() ? rowAxis : row2Axis;
                            if (rAxis != null) {
                                vr.setDisplayStackedLabels(rAxis.isDisplayStackedLabels());
                            }
                            vr.setLabelPosition(2);
                            continue;
                        }
                        if (vr.getDimension() != 1 || LayoutOverlayParser.xAxisType != 2 || vr.getFitPolicy() != null) continue;
                        vr.setTickLabeling("STAGGERTRUNCATEDROP");
                    }
                    continue;
                }
                JComponent comp = StatGraph.parseComponent(graph, nodeElem, (JComponent)plot, null, null);
                plot.addCellItem(0, 0, (Component)comp);
                continue;
            }
            str = nodeElem.getAttribute("aspectRatio");
            if (StatGraph.isNumber(str)) {
                tl.setCellAspectRatio(Double.parseDouble(str));
            } else {
                tl.setCellAspectRatio(-1.0);
            }
            int[] types = LayoutDataLatticeParser.getUserDefinedAxisTypes(elem, true);
            int[] types2 = LayoutDataLatticeParser.getUserDefinedAxisTypes(elem, false);
            if (StatGraph.isOLAP()) {
                LayoutDataLatticeParser.repeatOLAPRowColumnStamps(graph, nodeElem, pp, rvv, cvv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
                continue;
            }
            if (rvv != null) {
                plot.createRowCompoundHeader();
            }
            if (cvv != null) {
                plot.createColumnCompoundHeader();
            }
            if (plot.isCompoundHeaders()) {
                LayoutDataLatticeParser.repeatRowColumnStamps(graph, nodeElem, pp, rvv, cvv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
                continue;
            }
            StringVariable rv = rvv == null ? null : rvv[0];
            StringVariable cv = cvv == null ? null : cvv[0];
            LayoutDataLatticeParser.repeatRowColumnStamps(graph, nodeElem, pp, rv, cv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
        }
        if (graph.isNamedAxis(columnAxis)) {
            if (graph.xUnionAllPages) {
                axes = LayoutDataLatticeParser.getColumnAxes(plot, true);
                graph.replaceNamedAxis(graph.getAxisName(columnAxis), axes);
            } else {
                graph.removeNamedAxis(columnAxis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "colaxislegend.txt"));
            }
        }
        if (graph.isNamedAxis(rowAxis)) {
            if (graph.yUnionAllPages) {
                axes = LayoutDataLatticeParser.getRowAxes(plot, true);
                graph.replaceNamedAxis(graph.getAxisName(rowAxis), axes);
            } else {
                graph.removeNamedAxis(rowAxis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "rowaxislegend.txt"));
            }
        }
        if (graph.isNamedAxis(row2Axis)) {
            if (graph.y2UnionAllPages) {
                axes = LayoutDataLatticeParser.getRowAxes(plot, false);
                graph.replaceNamedAxis(graph.getAxisName(row2Axis), axes);
            } else {
                graph.removeNamedAxis(row2Axis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "row2axislegend.txt"));
            }
        }
        boolean columnUnion = !graph.xUnionAllPages;
        boolean column2Union = !graph.x2UnionAllPages;
        boolean rowUnion = !graph.yUnionAllPages;
        boolean row2Union = !graph.y2UnionAllPages;
        graph.whereDataModelName = null;
        graph.xUnionAllPages = false;
        graph.x2UnionAllPages = false;
        graph.yUnionAllPages = false;
        graph.y2UnionAllPages = false;
        LayoutDataLatticeParser.applyAxisOptions(plot, rowAxis, columnAxis, row2Axis, column2Axis, pp);
        LayoutLatticeParser.decideRowColumnAxisTypes(plot);
        if (!rowSort && !colSort) {
            LayoutLatticeParser.setupInternalAxes(plot, true, true, true, true, false);
            LayoutLatticeParser.turnOffEquateOption(plot);
            if (plot.isUniformXRange() || plot.isUniformYRange() || plot.isUniformX2Range() || plot.isUniformY2Range()) {
                LayoutLatticeParser.unifyViewport(plot);
            }
            plot.installColumnRangeListeners(true, true, true);
            plot.installRowRangeListeners(true, true, true);
            if (!xWeight && (columnUnion || column2Union)) {
                LayoutDataLatticeParser.weightingByCategories(plot, true, false);
            }
            if (!yWeight && (rowUnion || row2Union)) {
                LayoutDataLatticeParser.weightingByCategories(plot, false, false);
            }
        } else {
            LayoutLatticeParser.setupInternalAxes(plot, !colSort, !rowSort, !colSort, !rowSort, false, true);
            if (colSort) {
                tl.setRowHeadersAligned(false);
                if (!xWeight) {
                    LayoutDataLatticeParser.weightingByCategories(plot, true, true);
                }
            } else {
                tl.setColumnHeadersAligned(false);
                if (!yWeight) {
                    LayoutDataLatticeParser.weightingByCategories(plot, false, true);
                }
            }
            if (plot.isUniformXRange() || plot.isUniformYRange() || plot.isUniformX2Range() || plot.isUniformY2Range()) {
                LayoutLatticeParser.unifyViewport(plot);
            }
            if (colSort) {
                plot.installRowRangeListeners(true, true, true);
            } else {
                plot.installColumnRangeListeners(true, true, true);
            }
        }
        plot.installMarginListeners();
        plot.enableLayout();
        if (!graph.server) {
            LayoutLatticeParser.registerViewportListener(plot, true, true);
        }
    }

    private static boolean isMDDataLattice(StringVariable[] rvv, StringVariable[] cvv) {
        if (rvv != null && rvv.length > 1) {
            return true;
        }
        return cvv != null && cvv.length > 1;
    }

    static boolean isValidStamp(String str) {
        if (str.equals("LayoutPrototypeOverlay2D")) {
            return true;
        }
        return str.equals("LayoutPrototypeRegion");
    }

    static int convertAxisType(int axisType) {
        int type = -1;
        switch (axisType) {
            default: {
                break;
            }
            case 0: {
                type = 0;
                break;
            }
            case 6: {
                type = 2;
                break;
            }
            case 5: {
                type = 1;
                break;
            }
            case 1: {
                type = 3;
            }
        }
        return type;
    }
}

