/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.regions.KPIRegion;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.gtk.render.RendererUtil;
import java.awt.Color;
import org.w3c.dom.Element;

public final class KPIParser {
    public static final String RB_KEY = "KPIParser.";

    public static KPIRegion load(StatGraph graph, Element elem) {
        KPIRegion kpi = (KPIRegion)graph.getObjectFromElement(elem);
        if (kpi == null) {
            kpi = new KPIRegion();
        }
        return KPIParser.load(graph, kpi, elem) ? kpi : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean load(StatGraph graph, KPIRegion kpi, Element elem) {
        String str;
        block51: {
            block54: {
                block56: {
                    Element spOpts;
                    block55: {
                        block53: {
                            block52: {
                                graph.addSupportedGraph();
                                String dataName = null;
                                DataModel m = null;
                                str = elem.getAttribute("value");
                                if (StatGraph.isNumber(str)) {
                                    kpi.setActualValue(Double.parseDouble(str));
                                } else {
                                    int acol;
                                    dataName = StatGraph.getDataName(str);
                                    String actualVarID = StatGraph.getVarID(str);
                                    m = graph.getData(dataName);
                                    if (!StatGraph.checkVariable("VALUE", m.getColumnLabel(acol = m.getColumn(actualVarID)), Double.class, 1, true)) {
                                        return false;
                                    }
                                    kpi.setActualVariable(actualVarID);
                                }
                                Color underflowColor = StatGraph.parseAttrColor("underflowColor", graph, elem);
                                Color overflowColor = StatGraph.parseAttrColor("overflowColor", graph, elem);
                                str = elem.getAttribute("bounds");
                                if (str.length() > 0) {
                                    RangeAttrBundle rbundle;
                                    RangeAttributeMap raMap = graph.getRangeAttrMap(str);
                                    if (raMap == null) {
                                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "bounds.txt"));
                                        return false;
                                    }
                                    raMap.applyStyle(graph.style.getGraphStyle());
                                    boolean reverse = Boolean.parseBoolean(elem.getAttribute("reverseBounds"));
                                    str = elem.getAttribute("underflowColor");
                                    if ("".equals(str) || "AUTO".equalsIgnoreCase(str)) {
                                        rbundle = raMap.getUnderflowAttrs();
                                        Color color = underflowColor = rbundle.getKPIActiveColor() == null ? rbundle.getKPIColor() : rbundle.getKPIActiveColor();
                                    }
                                    if ("".equals(str = elem.getAttribute("overflowColor")) || "AUTO".equalsIgnoreCase(str)) {
                                        rbundle = raMap.getOverflowAttrs();
                                        Color color = overflowColor = rbundle.getKPIActiveColor() == null ? rbundle.getKPIColor() : rbundle.getKPIActiveColor();
                                    }
                                    if (!kpi.createRangeColorModel(raMap, underflowColor, overflowColor, reverse)) {
                                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "bounds.txt"));
                                        return false;
                                    }
                                } else {
                                    Color[] actColors;
                                    Element bElem = StatGraph.getOptionAttrsElement(elem, "Bounds");
                                    double[] range = StatGraph.parseDoubleValueList(bElem, "Value", true);
                                    if (range == null || range.length == 1) {
                                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "bounds.txt"));
                                        return false;
                                    }
                                    Color[] colors = KPIParser.getColors(elem, graph, "Colors");
                                    if (colors == null) {
                                        colors = graph.style.getGraphStyle().getKPIRangeNormalColors();
                                    }
                                    if ((actColors = KPIParser.getColors(elem, graph, "ActiveColors")) == null) {
                                        actColors = graph.style.getGraphStyle().getKPIRangeActiveColors();
                                    }
                                    kpi.createRangeColorModel(range, true, colors, actColors, underflowColor, overflowColor);
                                }
                                str = elem.getAttribute("target");
                                if (StatGraph.isNumber(str)) {
                                    kpi.setTargetValue(Double.parseDouble(str));
                                } else if (str.length() > 0) {
                                    String targetVarID;
                                    int tcol;
                                    if (dataName == null) {
                                        dataName = StatGraph.getDataName(str);
                                        m = graph.getData(dataName);
                                    }
                                    if (!StatGraph.checkVariable("TARGET", m.getColumnLabel(tcol = m.getColumn(targetVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
                                        return false;
                                    }
                                    kpi.setTargetVariable(targetVarID);
                                }
                                str = elem.getAttribute("stat").toUpperCase();
                                if (str.equals("MEAN")) {
                                    kpi.setStatistic(1);
                                } else if (str.equals("SUM") || str.length() > 0) {
                                    // empty if block
                                }
                                str = elem.getAttribute("rangeLabelFormat");
                                if (str.length() > 0) {
                                    kpi.setLabelFormat(str);
                                }
                                if ((str = elem.getAttribute("valueLabelFormat")).length() > 0) {
                                    kpi.setValueFormat(str);
                                }
                                kpi.setDataModel(m);
                                str = elem.getAttribute("type").toUpperCase();
                                if (!str.equals("BULLET")) break block52;
                                kpi.setType(RendererUtil.KPIChartType.BULLET);
                                Element buOpts = StatGraph.getOptionAttrsElement(elem, "BulletOpts");
                                if (buOpts != null && (str = buOpts.getAttribute("orient")).equalsIgnoreCase("vertical")) {
                                    kpi.setOrientation(1);
                                }
                                break block51;
                            }
                            if (!str.equals("SLIDER")) break block53;
                            kpi.setType(RendererUtil.KPIChartType.SLIDER);
                            Element slOpts = StatGraph.getOptionAttrsElement(elem, "SliderOpts");
                            if (slOpts != null && (str = slOpts.getAttribute("orient")).equalsIgnoreCase("vertical")) {
                                kpi.setOrientation(1);
                            }
                            break block51;
                        }
                        if (!str.equals("SPEEDOMETER")) break block54;
                        spOpts = StatGraph.getOptionAttrsElement(elem, "SpeedometerOpts");
                        if (spOpts != null) break block55;
                        kpi.setType(RendererUtil.KPIChartType.SPEEDOMETER_FULL);
                        break block51;
                    }
                    str = spOpts.getAttribute("type").toUpperCase();
                    if (!str.equals("HALF")) break block56;
                    kpi.setType(RendererUtil.KPIChartType.SPEEDOMETER_HALF);
                    break block51;
                }
                if (str.equals("QUARTER")) {
                    kpi.setType(RendererUtil.KPIChartType.SPEEDOMETER_QUARTER);
                    break block51;
                } else if (str.equals("FULL")) {
                    kpi.setType(RendererUtil.KPIChartType.SPEEDOMETER_FULL_NOLABEL);
                    break block51;
                } else {
                    kpi.setType(RendererUtil.KPIChartType.SPEEDOMETER_FULL);
                }
                break block51;
            }
            if (str.equals("THERMOMETER")) {
                Element smOpts = StatGraph.getOptionAttrsElement(elem, "ThermometerOpts");
                if (smOpts == null) {
                    // empty if block
                }
            } else if (str.equals("TRAFFICLIGHT")) {
                kpi.setType(RendererUtil.KPIChartType.TRAFFIC_LIGHT);
                Element tOpts = StatGraph.getOptionAttrsElement(elem, "TrafficLightOpts");
                if (tOpts != null && (str = tOpts.getAttribute("orient")).equalsIgnoreCase("vertical")) {
                    kpi.setOrientation(1);
                }
            } else if (str.equals("DIAL")) {
                kpi.setType(RendererUtil.KPIChartType.DIAL);
                Element dOpts = StatGraph.getOptionAttrsElement(elem, "DialOpts");
                if (dOpts != null) {
                    // empty if block
                }
            }
        }
        String graphSkin = graph.style.getStyleAttribute("Skins", "kpiSkin");
        str = elem.getAttribute("kpiSkin").toUpperCase();
        str = str.length() > 0 ? str : (graphSkin != null ? graphSkin : str);
        str = str.toUpperCase();
        if (str.length() > 0) {
            if (str.equals("BASIC") || str.equals("NONE")) {
                kpi.setSkin(RendererUtil.Skin.NONE);
            } else if (str.equals("SATIN")) {
                kpi.setSkin(RendererUtil.Skin.SATIN);
            } else if (str.equals("MODERN")) {
                kpi.setSkin(RendererUtil.Skin.MODERN);
            } else if (str.equals("ONYX")) {
                // empty if block
            }
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("valueLabelAttrs"), kpi.getValueTextStyle(), "KPIValueText");
        Element valueElem = StatGraph.getOptionAttrsElement(elem, "ValueLabelAttrs");
        if (valueElem != null) {
            StatGraph.parseTextAttrs(graph, valueElem, kpi.getValueTextStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("rangeLabelAttrs"), kpi.getRangeValueTextStyle(), "KPIRangeText");
        Element rangeElem = StatGraph.getOptionAttrsElement(elem, "RangeLabelAttrs");
        if (rangeElem != null) {
            StatGraph.parseTextAttrs(graph, rangeElem, kpi.getRangeValueTextStyle());
        }
        if ((str = elem.getAttribute("display").toUpperCase()).equals("STANDARD")) return true;
        if (str.equals("ALL")) {
            return true;
        }
        if (str.length() <= 0) return true;
        String[] d = StatGraph.parseList2String(str);
        kpi.setValueVisible(false);
        kpi.setRangeValueVisible(false);
        int i = 0;
        while (i < d.length) {
            if (d[i].equals("VALUELABEL")) {
                kpi.setValueVisible(true);
            } else if (d[i].equals("RANGELABELS")) {
                kpi.setRangeValueVisible(true);
            }
            ++i;
        }
        return true;
    }

    private static Color[] getColors(Element elem, StatGraph graph, String attrName) {
        Element cElem = StatGraph.getOptionAttrsElement(elem, attrName);
        if (cElem == null) {
            return null;
        }
        Color[] colors = StatGraph.parseColorValueList(graph, cElem, "Value");
        return colors == null || colors.length < 1 ? null : colors;
    }
}

