/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HeatBoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.NumericFormat;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HeatBoxParser {
    public static final String RB_KEY = "HeatBoxParser.";

    public static HeatBoxOverlay load(StatGraph graph, Element elem) {
        HeatBoxOverlay heatbox = (HeatBoxOverlay)graph.getObjectFromElement(elem);
        if (heatbox == null) {
            heatbox = new HeatBoxOverlay();
        }
        return HeatBoxParser.load(graph, heatbox, elem) ? heatbox : null;
    }

    public static boolean load(StatGraph graph, HeatBoxOverlay heatbox, Element elem) {
        int ycol;
        String yVarID;
        int i;
        int cnt;
        Element rElem;
        int varcol;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, heatbox);
        String str = elem.getAttribute("primary");
        heatbox.setPrimary(str.equalsIgnoreCase("true"));
        if (heatbox.getXAxis().equalsIgnoreCase("x2")) {
            heatbox.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            heatbox.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (heatbox.getYAxis().equalsIgnoreCase("y2")) {
            heatbox.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            heatbox.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        str = elem.getAttribute("Q1");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            graph.removeNamedGraph(heatbox);
            return false;
        }
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        String varID = StatGraph.getVarID(str);
        int q1Col = varcol = m.getColumn(varID);
        if (!StatGraph.checkVariable("Q1", m.getColumnLabel(varcol), Double.class, 1, true)) {
            graph.removeNamedGraph(heatbox);
            return false;
        }
        map.map(71, varcol);
        heatbox.addRole("Q1", m.getColumnLabel(varcol));
        str = elem.getAttribute("Q3");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            varcol = m.getColumn(varID);
            if (!StatGraph.checkVariable("Q3", m.getColumnLabel(varcol), Double.class, 1, true)) {
                graph.removeNamedGraph(heatbox);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            graph.removeNamedGraph(heatbox);
            return false;
        }
        map.map(72, varcol);
        heatbox.addRole("Q3", m.getColumnLabel(varcol));
        str = elem.getAttribute("dataMin");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            varcol = m.getColumn(varID);
            if (!StatGraph.checkVariable("DATAMIN", m.getColumnLabel(varcol), Double.class, 1, true)) {
                graph.removeNamedGraph(heatbox);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            graph.removeNamedGraph(heatbox);
            return false;
        }
        map.map(77, varcol);
        heatbox.addRole("DATAMIN", m.getColumnLabel(varcol));
        str = elem.getAttribute("dataMax");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            varcol = m.getColumn(varID);
            if (!StatGraph.checkVariable("DATAMAX", m.getColumnLabel(varcol), Double.class, 1, true)) {
                graph.removeNamedGraph(heatbox);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            graph.removeNamedGraph(heatbox);
            return false;
        }
        map.map(78, varcol);
        heatbox.addRole("DATAMAX", m.getColumnLabel(varcol));
        str = elem.getAttribute("analysisLabel");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            varcol = m.getColumn(varID);
            if (!StatGraph.checkVariable("ANALYSISLABEL", m.getColumnLabel(varcol), String.class, 1, true)) {
                graph.removeNamedGraph(heatbox);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            graph.removeNamedGraph(heatbox);
            return false;
        }
        map.map(89, varcol);
        heatbox.addRole("ANALYSISLABEL", m.getColumnLabel(varcol));
        str = elem.getAttribute("mean");
        if (StatGraph.getDataName(str).length() > 0 && StatGraph.checkVariable("MEAN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(73, varcol);
            heatbox.addRole("MEAN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("median")).length() > 0 && StatGraph.checkVariable("MEDIAN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(74, varcol);
            heatbox.addRole("MEDIAN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("min")).length() > 0 && StatGraph.checkVariable("MIN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(75, varcol);
            heatbox.addRole("MIN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("max")).length() > 0 && StatGraph.checkVariable("MAX", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(76, varcol);
            heatbox.addRole("MAX", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("STD")).length() > 0 && StatGraph.checkVariable("STD", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false, 0, false)) {
            map.map(79, varcol);
            heatbox.addRole("STD", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("N")).length() > 0 && StatGraph.checkVariable("N", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false, 0, false)) {
            map.map(80, varcol);
            heatbox.addRole("N", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binMin")).length() > 0 && StatGraph.checkVariable("BINMIN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(81, varcol);
            heatbox.addRole("BINMIN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binMax")).length() > 0 && StatGraph.checkVariable("BINMAX", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(82, varcol);
            heatbox.addRole("BINMAX", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binStartMin")).length() > 0 && StatGraph.checkVariable("BINSTARTMIN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(83, varcol);
            heatbox.addRole("BINSTARTMIN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binStartMax")).length() > 0 && StatGraph.checkVariable("BINSTARTMAX", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false)) {
            map.map(84, varcol);
            heatbox.addRole("BINSTARTMAX", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binSizeMin")).length() > 0 && StatGraph.checkVariable("BINWIDTHMIN", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false, 0, false)) {
            map.map(85, varcol);
            heatbox.addRole("BINWIDTHMIN", m.getColumnLabel(varcol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("binSizeMax")).length() > 0 && StatGraph.checkVariable("BINWIDTHMAX", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false, 0, false)) {
            map.map(86, varcol);
            heatbox.addRole("BINWIDTHMAX", m.getColumnLabel(varcol));
        }
        if ((rElem = StatGraph.getOptionAttrsElement(elem, "OutlierMinVars")) != null) {
            String[] outlierMinVars = StatGraph.parseStringValueList(rElem, "Value");
            cnt = 0;
            for (i = 0; i < outlierMinVars.length; ++i) {
                str = outlierMinVars[i];
                yVarID = StatGraph.getVarID(str);
                if (yVarID.length() <= 0 || !StatGraph.checkVariable("HEATBOX_OUTLERMIN", m.getColumnLabel(ycol = m.getColumn(yVarID)), Double.class, 0, false)) continue;
                map.map(650 + cnt, ycol);
                heatbox.addRole("HEATBOX_OUTLERMIN" + cnt, m.getColumnLabel(ycol));
                ++cnt;
            }
            heatbox.setOutlierMinVarCount(cnt);
        }
        if ((rElem = StatGraph.getOptionAttrsElement(elem, "OutlierMaxVars")) != null) {
            String[] outlierMaxVars = StatGraph.parseStringValueList(rElem, "Value");
            cnt = 0;
            for (i = 0; i < outlierMaxVars.length; ++i) {
                str = outlierMaxVars[i];
                yVarID = StatGraph.getVarID(str);
                if (yVarID.length() <= 0 || !StatGraph.checkVariable("HEATBOX_OUTLERMAX", m.getColumnLabel(ycol = m.getColumn(yVarID)), Double.class, 0, false)) continue;
                map.map(800 + cnt, ycol);
                heatbox.addRole("HEATBOX_OUTLERMAX" + cnt, m.getColumnLabel(ycol));
                ++cnt;
            }
            heatbox.setOutlierMaxVarCount(cnt);
        }
        if (StatGraph.getDataName(str = elem.getAttribute("x")).length() > 0 && StatGraph.checkVariable("X", m.getColumnLabel(varcol = m.getColumn(varID = StatGraph.getVarID(str))), null, 1, true)) {
            map.map(87, varcol);
            heatbox.addRole("X", m.getColumnLabel(varcol));
        }
        boolean hasGroup = false;
        str = elem.getAttribute("group");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            varcol = m.getColumn(varID);
            if (StatGraph.checkVariable("GROUP", m.getColumnLabel(varcol), null, 1, true)) {
                map.map(88, varcol);
                heatbox.addRole("GROUP", m.getColumnLabel(varcol));
            }
            if (map.isRoleMapped(88)) {
                hasGroup = true;
                int gcol = m.getColumn(varID);
                map.map(6, gcol);
                map.map(36, gcol);
                map.map(46, gcol);
                map.map(45, gcol);
                map.map(68, gcol);
                map.map(8, gcol);
                heatbox.addRole("GROUP", m.getColumnLabel(gcol));
                str = elem.getAttribute("includeMissingGroup");
                if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                    heatbox.setMissingGroupOn(false);
                }
                if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                    heatbox.addAttrVar("TUKEYGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    heatbox.addAttrVar("OUTLIERGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                }
                if ((str = elem.getAttribute("groupOrder")).length() > 0) {
                    if (str.equalsIgnoreCase("Ascending")) {
                        heatbox.setGroupOrder(1);
                    } else if (str.equalsIgnoreCase("Descending")) {
                        heatbox.setGroupOrder(2);
                    } else if (str.equalsIgnoreCase("Data")) {
                        heatbox.setGroupOrder(0);
                    } else if (str.equalsIgnoreCase("ReverseData")) {
                        heatbox.setGroupOrder(3);
                    } else {
                        heatbox.setGroupOrder(0);
                        StatGraph.printOptionError("GROUPORDER", str);
                    }
                } else if (graph.isCASData()) {
                    heatbox.setGroupOrder(1);
                }
                if (graph.isCASData()) {
                    heatbox.setDrawByGroupOrder(true);
                }
                if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
                    heatbox.setClusterWidth(Double.parseDouble(str));
                }
            }
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0) {
            String dStat = elem.getAttribute("displayStats");
            if (dStat.length() > 0 && !dStat.equalsIgnoreCase("none")) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            } else if (StatGraph.isNumber(str)) {
                double offset = Double.parseDouble(str);
                if (offset >= -0.5 && offset <= 0.5) {
                    heatbox.setDiscreteOffset(offset);
                } else {
                    StatGraph.printOptionError("DISCRETEOFFSET", str);
                }
            } else if (str.length() > 0) {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        }
        if ((str = elem.getAttribute("display")).length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                HeatBoxParser.setDisplayAll(heatbox, true);
            } else if (str.equalsIgnoreCase("none")) {
                HeatBoxParser.setDisplayAll(heatbox, false);
            } else {
                String[] opts = StatGraph.parseList2String(str);
                HeatBoxParser.setDisplayAll(heatbox, false);
                for (int i2 = 0; i2 < opts.length; ++i2) {
                    if (opts[i2].equalsIgnoreCase("connect")) {
                        heatbox.setConnectOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("caps")) {
                        heatbox.setCapOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("fill")) {
                        heatbox.setFillOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("median")) {
                        heatbox.setMedianOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("mean")) {
                        heatbox.setMeanOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("outliers")) {
                        heatbox.setOutlierOn(true);
                        continue;
                    }
                    if (opts[i2].equalsIgnoreCase("notches")) {
                        heatbox.setNotchOn(true);
                        continue;
                    }
                    HeatBoxParser.setDisplayAll(heatbox, true);
                    StatGraph.printOptionError("DISPLAY", opts[i2]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Box", "displayOpts");
            if (str != null) {
                String[] opts = StatGraph.parseList2String(str);
                HeatBoxParser.setDisplayAll(heatbox, false);
                for (int i3 = 0; i3 < opts.length; ++i3) {
                    if (opts[i3].equalsIgnoreCase("connect")) {
                        heatbox.setConnectOn(true);
                        continue;
                    }
                    if (opts[i3].equalsIgnoreCase("caps")) {
                        heatbox.setCapOn(true);
                        continue;
                    }
                    if (opts[i3].equalsIgnoreCase("fill")) {
                        heatbox.setFillOn(true);
                        continue;
                    }
                    if (opts[i3].equalsIgnoreCase("median")) {
                        heatbox.setMedianOn(true);
                        continue;
                    }
                    if (opts[i3].equalsIgnoreCase("mean")) {
                        heatbox.setMeanOn(true);
                        continue;
                    }
                    if (opts[i3].equalsIgnoreCase("outliers")) {
                        heatbox.setOutlierOn(true);
                        continue;
                    }
                    if (!opts[i3].equalsIgnoreCase("notches")) continue;
                    heatbox.setNotchOn(true);
                }
                if (!HeatBoxParser.isBoxOn(heatbox)) {
                    heatbox.setCapOn(true);
                    heatbox.setFillOn(true);
                    heatbox.setMeanOn(true);
                    heatbox.setMedianOn(true);
                    heatbox.setOutlierOn(true);
                }
            }
        }
        if (heatbox.isCapOn()) {
            int capShape = 1;
            str = elem.getAttribute("capShape");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("line")) {
                    capShape = 2;
                } else if (str.equalsIgnoreCase("bracket")) {
                    capShape = 3;
                } else if (str.equalsIgnoreCase("serif")) {
                    capShape = 1;
                } else if (str.equalsIgnoreCase("none")) {
                    capShape = 0;
                } else {
                    StatGraph.printOptionError("CAPSHAPE", str);
                }
            } else {
                str = graph.style.getStyleAttribute("Box", "capStyle");
                if (str != null) {
                    if (str.equalsIgnoreCase("line")) {
                        capShape = 2;
                    } else if (str.equalsIgnoreCase("bracket")) {
                        capShape = 3;
                    }
                }
            }
            heatbox.setCapShape(capShape);
            str = elem.getAttribute("capScale");
            if (StatGraph.isNumber(str)) {
                heatbox.setCapScale(Double.parseDouble(str));
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute("boxWidth"))) {
            double width = Double.parseDouble(str);
            heatbox.setBoxWidth(width);
            heatbox.setUserSetBoxWidth(true);
        } else if (hasGroup) {
            heatbox.setBoxWidth(0.6);
        } else {
            heatbox.setBoxWidth(0.4);
        }
        str = elem.getAttribute("intervalBoxWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            if (width >= 0.0) {
                heatbox.setIntervalBoxWidth(width);
            }
        } else if (str.equalsIgnoreCase("auto")) {
            heatbox.setIntervalBoxWidth(-1.0);
        }
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            heatbox.setOrientation(1);
        } else if (str.equalsIgnoreCase("Vertical")) {
            heatbox.setOrientation(0);
        } else {
            heatbox.setOrientation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        boolean extreme = false;
        str = elem.getAttribute("extreme");
        if (str.equalsIgnoreCase("true")) {
            extreme = true;
            heatbox.setExtreme(extreme);
        }
        if ((str = elem.getAttribute("binDisplay")).length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                heatbox.setHeatMapOutlineOn(true);
            } else {
                heatbox.setHeatMapOutlineOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i4 = 0; i4 < opts.length; ++i4) {
                    if (!opts[i4].equalsIgnoreCase("outline")) {
                        heatbox.setHeatMapOutlineOn(false);
                        StatGraph.printOptionError("DISPLAY", opts[i4]);
                        break;
                    }
                    heatbox.setHeatMapOutlineOn(true);
                }
            }
        } else {
            heatbox.setHeatMapOutlineOn(false);
        }
        str = elem.getAttribute("binWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            heatbox.setHeatMapWidth(width);
        } else if (hasGroup) {
            heatbox.setHeatMapWidth(0.4);
        } else {
            heatbox.setHeatMapWidth(0.2);
        }
        str = elem.getAttribute("includeZeroBins");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            heatbox.setIncludeZeroBins(true);
        }
        StatGraph.parseDataSkinOpt(graph, elem, heatbox);
        HeatBoxParser.parseRoleTipStuff(elem, m, map, heatbox);
        StatGraph.parseURLOpt(elem, m, map, heatbox);
        LayoutOverlayParser.parseWhere(graph, crd, heatbox);
        heatbox.setModel(crd);
        String contextName = graph.style.getContextName();
        heatbox.setContextName(contextName);
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), heatbox.getOutlineStyle(), contextName);
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), ls, "Outlines");
            if (heatbox.isFillOn()) {
                heatbox.getOutlineStyle().setLinePattern(ls.getLinePattern());
            }
            heatbox.getOutlineStyle().setWidth(ls.getWidth());
        } else {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), heatbox.getOutlineStyle(), "Outlines");
        }
        if (heatbox.isFillOn()) {
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), heatbox.getFillStyle(), contextName);
        }
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), heatbox.getWhiskerStyle(), contextName);
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), ls, "BoxWhisker");
            if (heatbox.isFillOn()) {
                heatbox.getWhiskerStyle().setLinePattern(ls.getLinePattern());
            }
            heatbox.getWhiskerStyle().setWidth(ls.getWidth());
        } else {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), heatbox.getWhiskerStyle(), "BoxWhisker");
        }
        if (heatbox.isMedianOn()) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), heatbox.getMedianStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), ls, "BoxMedian");
                if (heatbox.isFillOn()) {
                    heatbox.getMedianStyle().setLinePattern(ls.getLinePattern());
                }
                heatbox.getMedianStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), heatbox.getMedianStyle(), "BoxMedian");
            }
        }
        if (heatbox.isMeanOn()) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), heatbox.getMeanStyle(), contextName);
                MarkerAttrs ms = new MarkerAttrs();
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), ms, "BoxMean");
                heatbox.getMeanStyle().setSize(ms.getSize());
                heatbox.getMeanStyle().setWeight(ms.getWeight());
            } else {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), heatbox.getMeanStyle(), "BoxMean");
            }
        }
        if (heatbox.isOutlierOn() && !extreme) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("outlierAttrs"), heatbox.getOutlierStyle(), contextName);
            } else {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("outlierAttrs"), heatbox.getOutlierStyle(), "Outlier");
            }
        }
        if (heatbox.isConnectOn()) {
            int connect = 6;
            str = elem.getAttribute("connect");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("min")) {
                    connect = 1;
                } else if (str.equalsIgnoreCase("q1")) {
                    connect = 2;
                } else if (str.equalsIgnoreCase("median")) {
                    connect = 3;
                } else if (str.equalsIgnoreCase("q3")) {
                    connect = 4;
                } else if (str.equalsIgnoreCase("max")) {
                    connect = 5;
                } else if (str.equalsIgnoreCase("mean")) {
                    connect = 6;
                } else {
                    StatGraph.printOptionError("CONNECT", str);
                }
                heatbox.setConnectBy(connect);
            } else {
                str = graph.style.getStyleAttribute("Box", "connect");
                if (str != null) {
                    connect = str.equalsIgnoreCase("min") ? 1 : (str.equalsIgnoreCase("q1") ? 2 : (str.equalsIgnoreCase("median") ? 3 : (str.equalsIgnoreCase("q3") ? 4 : (str.equalsIgnoreCase("max") ? 5 : (str.equalsIgnoreCase("mean") ? 6 : 6)))));
                    heatbox.setConnectBy(connect);
                }
            }
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), heatbox.getConnectStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), ls, "ConnectLine");
                if (heatbox.isFillOn()) {
                    heatbox.getConnectStyle().setLinePattern(ls.getLinePattern());
                }
                heatbox.getConnectStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), heatbox.getConnectStyle(), "ConnectLine");
            }
            str = elem.getAttribute("connectBreak");
            if (str.equalsIgnoreCase("true")) {
                heatbox.setConnectSkipMiss(true);
            }
        }
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("binOutlineAttrs"), heatbox.getOutlineStyle(), contextName);
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("binOutlineAttrs"), ls, "Outlines");
            heatbox.getOutlineStyle().setLinePattern(ls.getLinePattern());
            heatbox.getOutlineStyle().setWidth(ls.getWidth());
        } else {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("binOutlineAttrs"), heatbox.getOutlineStyle(), "Outlines");
        }
        heatbox.setUseOutlineColor(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color"));
        heatbox.setUseOutlinePattern(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "pattern") || heatbox.isFillOn());
        heatbox.setUseOutlineSize(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        heatbox.setUseConnectLineColor(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "color"));
        heatbox.setUseConnectLinePattern(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "pattern") || heatbox.isFillOn());
        heatbox.setUseConnectLineSize(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "thickness"));
        heatbox.setUseWhiskerColor(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "color"));
        heatbox.setUseWhiskerPattern(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "pattern") || heatbox.isFillOn());
        heatbox.setUseWhiskerSize(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "thickness"));
        heatbox.setUseMedianColor(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "color"));
        heatbox.setUseMedianPattern(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "pattern") || heatbox.isFillOn());
        heatbox.setUseMedianSize(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "thickness"));
        heatbox.setUseMeanSymbol(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "symbol"));
        heatbox.setUseMeanColor(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "color"));
        heatbox.setUseMeanSize(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "size"));
        heatbox.setUseMeanWeight(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "weight", true));
        heatbox.setUseMeanTransparency(StatGraph.isTransparencyFixed(elem, "MeanAttrs"));
        heatbox.setUseOutlierSymbol(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "symbol"));
        heatbox.setUseOutlierColor(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "color"));
        heatbox.setUseOutlierSize(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "size"));
        heatbox.setUseOutlierWeight(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "weight", true));
        heatbox.setUseOutlierTransparency(StatGraph.isTransparencyFixed(elem, "OutlierAttrs"));
        heatbox.setUseFillColor(StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color"));
        heatbox.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("OutlineAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, heatbox.getOutlineStyle());
                continue;
            }
            if (elemTag.equals("ConnectAttrs") && heatbox.isConnectOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, heatbox.getConnectStyle());
                continue;
            }
            if (elemTag.equals("WhiskerAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, heatbox.getWhiskerStyle());
                continue;
            }
            if (elemTag.equals("MedianAttrs") && heatbox.isMedianOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, heatbox.getMedianStyle());
                continue;
            }
            if (elemTag.equals("MeanAttrs") && heatbox.isMeanOn()) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, heatbox.getMeanStyle());
                continue;
            }
            if (elemTag.equals("OutlierAttrs") && heatbox.isOutlierOn() && !extreme) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, heatbox.getOutlierStyle());
                continue;
            }
            if (elemTag.equals("FillAttrs") && heatbox.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, heatbox.getFillStyle());
                continue;
            }
            if (!elemTag.equals("BinOutlineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, heatbox.getHeatMapOutlineStyle());
        }
        if (heatbox.isCapOn()) {
            heatbox.getCapStyle().setColor(heatbox.getWhiskerStyle().getColor());
            heatbox.getCapStyle().setWidth(heatbox.getWhiskerStyle().getWidth());
        }
        if ((str = elem.getAttribute("displayStats")).length() > 0 && !str.equalsIgnoreCase("none")) {
            boolean haveStats = true;
            if (heatbox.getOrientation() == 1) {
                StatGraph.printNote(RB.getStringResource("BoxParser.", "stat.txt"));
                haveStats = false;
            }
            if (hasGroup) {
                StatGraph.printNote(RB.getStringResource("BoxParser.", "statgroup.txt"));
                haveStats = false;
            }
            if (haveStats) {
                Object[] xValues;
                String[] opts = str.equalsIgnoreCase("all") ? new String[]{"N", "DataMin", "Min", "Q1", "Median", "Q3", "Max", "DataMax", "Mean", "STD", "Range", "IQR"} : (str.equalsIgnoreCase("standard") ? new String[]{"N", "mean", "STD"} : StatGraph.parseList2String(str));
                DataModel model = new DataModel();
                if (heatbox.isIntervalBox()) {
                    xValues = heatbox.getDoubleCategoryValues();
                    ContinuousRange cr = heatbox.getDoubleCategoryRange();
                    model.addDoubleColumn("X", "X", null, cr.getMin(), cr.getMax(), 0, (double[])xValues);
                } else {
                    xValues = heatbox.getCategoryValues();
                    model.addStringColumn("X", "X", null, xValues.length, 0, (String[])xValues);
                }
                ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(q1Col);
                String fmt = NumericFormat.isNamedFormat((SASFormat)cmd.getFormat()) ? cmd.getFormat().getName() : DataModel.defaultFormat.getName();
                int num = 0;
                boolean[] displayStats = new boolean[opts.length];
                for (int i5 = 0; i5 < opts.length; ++i5) {
                    double[] sValues;
                    if (!HeatBoxParser.isValidStatistic(opts[i5]) || (sValues = heatbox.getStatistics(opts[i5])) == null) continue;
                    if (opts[i5].equalsIgnoreCase("N")) {
                        model.addDoubleColumn(opts[i5], HeatBoxParser.getNLSName(opts[i5]), null, -1.0, -1.0, 0, sValues);
                    } else {
                        model.addDoubleColumn(opts[i5], HeatBoxParser.getNLSName(opts[i5]), fmt, -1.0, -1.0, 0, sValues);
                    }
                    displayStats[i5] = true;
                    ++num;
                }
                if (num >= 1) {
                    Overlay[] imOverlays = new AxisTable[num];
                    num = 0;
                    for (int i6 = opts.length - 1; i6 >= 0; --i6) {
                        if (!displayStats[i6]) continue;
                        imOverlays[num] = new AxisTable();
                        RoleColumnMap map2 = new RoleColumnMap();
                        int xcol = model.getColumn("X");
                        map2.map(114, xcol);
                        imOverlays[num].addRole("X", model.getColumnLabel(xcol));
                        int lcol = model.getColumn(opts[i6]);
                        map2.map(115, lcol);
                        imOverlays[num].addRole("COLUMN", model.getColumnLabel(lcol));
                        CRD crd2 = new CRD();
                        crd2.setSrcModel(model);
                        crd2.setSrcMap(map2);
                        ((AxisTable)imOverlays[num]).setModel(crd2);
                        GraphStyle.setDefaultTextStyle(graph, "", ((AxisTable)imOverlays[num]).getValueAttrs(), "DataText");
                        GraphStyle.setDefaultTextStyle(graph, "", ((AxisTable)imOverlays[num]).getLabelAttrs(), "ValueText");
                        imOverlays[num].setOverlayJustification(2);
                        imOverlays[num].setXAxis(heatbox.getXAxis());
                        if (heatbox.getYAxis().equalsIgnoreCase("Y2")) {
                            ((AxisTable)imOverlays[num]).setLabelPosition(2);
                        }
                        ++num;
                    }
                    heatbox.setInnerMarginOverlays(imOverlays);
                }
            }
        }
        Color missingColor = null;
        ColorEncoder encoder = HeatBoxParser.parseColorModelOpt((byte)4, graph, elem, heatbox);
        if (encoder != null) {
            heatbox.setEncoder((byte)4, encoder);
            missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor();
            heatbox.setMissingHeatMapColor(heatbox.applyDataTransparency(missingColor));
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)heatbox, (byte)4, heatbox.getFillStyle().getTransparency());
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, heatbox, (byte)15);
        }
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, heatbox, (byte)17);
            ColorEncoder lcEncoder = (ColorEncoder)heatbox.getEncoder((byte)17);
            DiscreteRange dr = (DiscreteRange)lcEncoder.getInput();
            HashMap lcTable = lcEncoder.colorList;
            HashMap scTable = new HashMap();
            HashMap sc2Table = new HashMap();
            for (Object key : lcTable.keySet()) {
                Color c = (Color)lcTable.get(key);
                scTable.put(key, heatbox.applyDataTransparency(c, heatbox.getMeanStyle().getTransparency()));
                sc2Table.put(key, heatbox.applyDataTransparency(c, heatbox.getOutlierStyle().getTransparency()));
            }
            ColorEncoder scEncoder = new ColorEncoder(dr, scTable);
            scEncoder.colorArray = lcEncoder.colorArray;
            heatbox.setEncoder((byte)16, scEncoder);
            ColorEncoder s2cEncoder = new ColorEncoder(dr, sc2Table);
            s2cEncoder.colorArray = lcEncoder.colorArray;
            heatbox.setEncoder((byte)23, s2cEncoder);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, heatbox, (byte)6);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    public static boolean isUnderLatticeLayout(Element elem) {
        Node parentNode = elem.getParentNode();
        String name = parentNode.getNodeName();
        if (name.equalsIgnoreCase("LayoutPrototype") || name.equalsIgnoreCase("LayoutPrototypeOverlay2D")) {
            return true;
        }
        if (name.equalsIgnoreCase("LayoutLattice")) {
            return true;
        }
        return name.equalsIgnoreCase("LayoutOverlay") && (name = (parentNode = parentNode.getParentNode()).getNodeName()).equalsIgnoreCase("LayoutLattice");
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("Q1");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            return null;
        }
        DataModel model = graph.getData(dataName);
        String varID = StatGraph.getVarID(str);
        int col = model.getColumn(varID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(col);
        int analysisType = 0;
        if (cmd.getType() == 2) {
            return null;
        }
        analysisType = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        int categoryType = 2;
        str = elem.getAttribute("category");
        if (StatGraph.getDataName(str).length() > 0) {
            varID = StatGraph.getVarID(str);
            col = model.getColumn(varID);
            cmd = (ColumnMetadata)model.getColumnLabel(col);
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, varID)) {
                return null;
            }
        }
        if ((str = elem.getAttribute("orient")).equalsIgnoreCase("Horizontal")) {
            types[0] = analysisType;
            types[1] = categoryType;
        } else {
            types[0] = categoryType;
            types[1] = analysisType;
        }
        types[2] = 0;
        return types;
    }

    private static void setDisplayAll(HeatBoxOverlay heatBox, boolean on) {
        heatBox.setCapOn(on);
        heatBox.setConnectOn(on);
        heatBox.setMedianOn(on);
        heatBox.setMeanOn(on);
        heatBox.setOutlierOn(on);
        heatBox.setFillOn(on);
        heatBox.setNotchOn(on);
    }

    private static boolean isBoxOn(HeatBoxOverlay heatbox) {
        return heatbox.isCapOn() || heatbox.isConnectOn() || heatbox.isMedianOn() || heatbox.isMeanOn() || heatbox.isOutlierOn() || heatbox.isFillOn() || heatbox.isNotchOn();
    }

    private static void parseRoleTipStuff(Element elem, DataModel model, RoleColumnMap map, HeatBoxOverlay overlay) {
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement(elem, "Roles");
        if (roleElem != null) {
            LayoutOverlayParser.parseRoleNames(roleElem, model, overlay);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement(elem, "TipFormats")) != null) {
            String elemTag = "";
            HashMap<String, String> formatMap = null;
            for (Node node = formatElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String format = child.getNodeValue();
                if (HeatBoxParser.isStat(role.toUpperCase())) {
                    if (formatMap == null) {
                        formatMap = new HashMap<String, String>();
                    }
                    formatMap.put(role.toUpperCase(), format);
                    continue;
                }
                ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd == null) continue;
                cmd.setFormat(format);
            }
            overlay.setCustomTipFormat(formatMap);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement(elem, "TipLabels")) != null) {
            String elemTag = "";
            HashMap<String, String> labelMap = null;
            for (Node node = labelElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String label = child.getNodeValue();
                if (HeatBoxParser.isStat(role.toUpperCase())) {
                    if (labelMap == null) {
                        labelMap = new HashMap<String, String>();
                    }
                    labelMap.put(role.toUpperCase(), label);
                    continue;
                }
                ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd == null) continue;
                cmd.setLabel(label);
            }
            overlay.setCustomTipLabel(labelMap);
        }
        overlay.clearStatTips();
        String str = elem.getAttribute("tip");
        if (str.length() > 0) {
            String[] tipRoles = StatGraph.parseList2String(str);
            overlay.setCustomTips(true);
            int cnt = 0;
            HashMap<Integer, String> roleMap = new HashMap<Integer, String>();
            for (int i = 0; i < tipRoles.length; ++i) {
                if (HeatBoxParser.isStat(tipRoles[i].toUpperCase())) {
                    overlay.addStatTip(tipRoles[i].toUpperCase());
                    continue;
                }
                ColumnMetadata cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(300 + cnt), tipRoles[i].toUpperCase());
                String tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(300 + cnt++, tipcol);
            }
            overlay.setCustomTipList(tipRoles);
            overlay.setTipRoleMap(roleMap);
        }
    }

    private static boolean isStat(String name) {
        return name.equalsIgnoreCase("MIN") || name.equalsIgnoreCase("Q1") || name.equalsIgnoreCase("MEDIAN") || name.equalsIgnoreCase("MEAN") || name.equalsIgnoreCase("Q3") || name.equalsIgnoreCase("MAX") || name.equalsIgnoreCase("STD") || name.equalsIgnoreCase("N") || name.equalsIgnoreCase("DATAMIN") || name.equalsIgnoreCase("DATAMAX");
    }

    private static boolean isValidStatistic(String statname) {
        return statname.equalsIgnoreCase("MIN") || statname.equalsIgnoreCase("Q1") || statname.equalsIgnoreCase("MEDIAN") || statname.equalsIgnoreCase("Q3") || statname.equalsIgnoreCase("MAX") || statname.equalsIgnoreCase("MEAN") || statname.equalsIgnoreCase("N") || statname.equalsIgnoreCase("STD") || statname.equalsIgnoreCase("RANGE") || statname.equalsIgnoreCase("IQR") || statname.equalsIgnoreCase("DATAMIN") || statname.equalsIgnoreCase("DATAMAX");
    }

    private static String getNLSName(String name) {
        String NLS = name;
        if (name.equalsIgnoreCase("MIN")) {
            NLS = RB.getStringResource("BoxParser.", "MIN.txt");
        } else if (name.equalsIgnoreCase("Q1")) {
            NLS = RB.getStringResource("BoxParser.", "Q1.txt");
        } else if (name.equalsIgnoreCase("MEDIAN")) {
            NLS = RB.getStringResource("BoxParser.", "MEDIAN.txt");
        } else if (name.equalsIgnoreCase("Q3")) {
            NLS = RB.getStringResource("BoxParser.", "Q3.txt");
        } else if (name.equalsIgnoreCase("MAX")) {
            NLS = RB.getStringResource("BoxParser.", "MAX.txt");
        } else if (name.equalsIgnoreCase("MEAN")) {
            NLS = RB.getStringResource("BoxParser.", "MEAN.txt");
        } else if (name.equalsIgnoreCase("N")) {
            NLS = RB.getStringResource("BoxParser.", "N.txt");
        } else if (name.equalsIgnoreCase("STD")) {
            NLS = RB.getStringResource("BoxParser.", "STD.txt");
        } else if (name.equalsIgnoreCase("RANGE")) {
            NLS = RB.getStringResource("BoxParser.", "RANGE.txt");
        } else if (name.equalsIgnoreCase("IQR")) {
            NLS = RB.getStringResource("BoxParser.", "IQR.txt");
        } else if (name.equalsIgnoreCase("DATAMIN")) {
            NLS = RB.getStringResource("BoxParser.", "DATAMIN.txt");
        } else if (name.equalsIgnoreCase("DATAMAX")) {
            NLS = RB.getStringResource("BoxParser.", "DATAMAX.txt");
        }
        return NLS;
    }

    public static ColorEncoder parseColorModelOpt(byte dimension, StatGraph graph, Element elem, Overlay overlay) {
        String defaultRamp = "Outlier";
        DataRange range = overlay.getDataRange(dimension);
        ColorEncoder encoder = null;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            String str = elem.getAttribute("binColorModel");
            Color[] ramp = graph.style.getRampColors(str, defaultRamp);
            str = elem.getAttribute("reverseBinColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            Element cmElem = StatGraph.getOptionAttrsElement(elem, "BinColorModel");
            boolean userColorModel = false;
            if (cmElem != null) {
                Color[] colors = StatGraph.parseColorValueList(graph, cmElem, "Value");
                if (colors != null && colors.length > 0) {
                    ramp = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
                }
                userColorModel = true;
            }
            if (userColorModel) {
                if (reverse) {
                    Color[] cl = new Color[ramp.length];
                    int idx = 0;
                    for (int i = ramp.length - 1; i >= 0; --i) {
                        cl[idx++] = ramp[i];
                    }
                    ramp = cl;
                }
                for (int i = 0; i < ramp.length; ++i) {
                    ramp[i] = overlay.applyDataTransparency(ramp[i]);
                }
                encoder = new ColorEncoder(cr, ramp);
            } else if (ramp.length == 2) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "colormodel.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            } else {
                encoder = reverse ? new ColorEncoder(cr, overlay.applyDataTransparency(ramp[2]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[0])) : new ColorEncoder(cr, overlay.applyDataTransparency(ramp[0]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[2]));
            }
        }
        return encoder;
    }
}

