/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.SASColors;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GraphStyle {
    private Style graphStyle = null;
    int fillColorCnt = 0;
    int contrastColorCnt = 0;
    int markerSymbolCnt = 0;
    int lineStyleCnt = 0;
    int fillPatternCnt = 0;
    int currentFillColorCnt = 0;
    int currentContrastColorCnt = 0;
    int currentMarkerSymbolCnt = 0;
    int currentLineStyleCnt = 0;
    int currentFillPatternCnt = 0;
    private static final SASColors sasColor = SASColors.getInstance();
    public static final String styleRefSeparator = ":";
    public Color[] fillColorList = null;
    public Color[] contrastColorList = null;
    public int[] markerSymbolList = null;
    public LineAttrs[] lineStyleList = null;
    public int[] fillPatternList = null;
    boolean cycleAttrs = false;
    int contextCnt = 0;
    static final String[] contextNames = new String[]{"GraphDataStyle1", "GraphDataStyle2", "GraphDataStyle3", "GraphDataStyle4", "GraphDataStyle5", "GraphDataStyle6", "GraphDataStyle7", "GraphDataStyle8", "GraphDataStyle9", "GraphDataStyle10", "GraphDataStyle11", "GraphDataStyle12"};
    public static final int ATTR_PRIORITY_NONE = 0;
    public static final int ATTR_PRIORITY_COLOR = 1;
    private int attrPriority = 0;

    public static Color SAS2JavaColor(String colStr) {
        return sasColor.getColor(colStr);
    }

    public Style getGraphStyle() {
        return this.graphStyle;
    }

    public void setGraphStyle(Style style) {
        this.graphStyle = style;
        this.graphStyle.setFallbackEnabled(true);
        this.resetCounters();
        this.fillColorList = style.getDataFillColors();
        this.contrastColorList = style.getDataLineColors();
        this.markerSymbolList = style.getDataMarkerSymbols();
        int numLines = style.getDataLinePatterns().length;
        this.lineStyleList = new LineAttrs[numLines];
        for (int i = 0; i < numLines; ++i) {
            this.lineStyleList[i] = new LineAttrs(style.getDataLinePatterns()[i]);
        }
        String[] patternNames = style.getDataFillPatterns();
        int numFillPatterns = patternNames.length;
        this.fillPatternList = new int[numFillPatterns];
        for (int i = 0; i < numFillPatterns; ++i) {
            int fp = FillPatternAttrs.getPattern((String)patternNames[i]);
            if (fp < 0) {
                fp = FillPatternAttrs.getPattern((String)"E");
            }
            this.fillPatternList[i] = fp;
        }
        this.attrPriority = 0;
        String ap = style.getAttrPriority();
        if (ap != null && ap.equalsIgnoreCase("COLOR")) {
            this.attrPriority = 1;
        }
    }

    public void resetCounters() {
        this.fillColorCnt = 0;
        this.contrastColorCnt = 0;
        this.markerSymbolCnt = 0;
        this.lineStyleCnt = 0;
        this.fillPatternCnt = 0;
        this.contextCnt = 0;
    }

    public void recordCurrentCounters() {
        this.currentFillColorCnt = this.fillColorCnt;
        this.currentContrastColorCnt = this.contrastColorCnt;
        this.currentMarkerSymbolCnt = this.markerSymbolCnt;
        this.currentLineStyleCnt = this.lineStyleCnt;
        this.currentFillPatternCnt = this.fillPatternCnt;
    }

    public void resetToCurrentCounters() {
        this.fillColorCnt = this.currentFillColorCnt;
        this.contrastColorCnt = this.currentContrastColorCnt;
        this.markerSymbolCnt = this.currentMarkerSymbolCnt;
        this.lineStyleCnt = this.currentLineStyleCnt;
        this.fillPatternCnt = this.currentFillPatternCnt;
    }

    public void setCycleAttrs(boolean cycle) {
        this.cycleAttrs = cycle;
    }

    public boolean isCycleAttrs() {
        return this.cycleAttrs;
    }

    public String getContextName() {
        if (this.cycleAttrs) {
            return "GraphDataStyle" + (1 + this.contextCnt++);
        }
        return "GraphDataStyleDefault";
    }

    public int getContextCount() {
        return this.contextCnt == 0 ? this.contextCnt : this.contextCnt - 1;
    }

    public void setContextCount(int count) {
        this.contextCnt = count;
        this.contextCnt %= contextNames.length;
    }

    public void setContrastColorCount(int count) {
        this.contrastColorCnt = count;
    }

    public int getContrastColorCount() {
        return this.contrastColorCnt;
    }

    public Color getNextFillColor() {
        if (this.cycleAttrs) {
            return this.fillColorList[this.contextCnt++ % this.fillColorList.length];
        }
        return this.getGraphStyle().getDataStyleElement(this.fillColorCnt++).getFillColor();
    }

    public Color getNextContrastColor() {
        if (this.cycleAttrs) {
            return this.contrastColorList[this.contextCnt++ % this.contrastColorList.length];
        }
        return this.contrastColorList[this.contrastColorCnt++ % this.contrastColorList.length];
    }

    public int getNextMarkerSymbol() {
        if (this.cycleAttrs) {
            return this.markerSymbolList[this.contextCnt++ % this.markerSymbolList.length];
        }
        return this.markerSymbolList[this.markerSymbolCnt++ % this.markerSymbolList.length];
    }

    public LineAttrs getNextLineStyle() {
        if (this.cycleAttrs) {
            return this.lineStyleList[this.contextCnt++ % this.lineStyleList.length];
        }
        return this.lineStyleList[this.lineStyleCnt++ % this.lineStyleList.length];
    }

    public int getNextFillPattern() {
        if (this.cycleAttrs) {
            return this.fillPatternList[this.contextCnt++ % this.fillPatternList.length];
        }
        return this.fillPatternList[this.fillPatternCnt++ % this.fillPatternList.length];
    }

    public String getStyleAttribute(String context, String attr) {
        if (context == null) {
            return null;
        }
        StyleElement elem = this.graphStyle.getStyleElement(context);
        return elem.getAttribute(attr);
    }

    public Color[] getRampColors(String elemName, String defaultElemName) {
        RampStyleElement rampElem = this.graphStyle.getRampStyleElement("GraphDataStyleDefault");
        if (defaultElemName != null) {
            rampElem = rampElem.mergeWith((StyleElement)this.graphStyle.getRampStyleElement(defaultElemName)).getAsRampStyle();
        }
        if (elemName != null && elemName.length() > 0) {
            rampElem = rampElem.mergeWith((StyleElement)this.graphStyle.getRampStyleElement(elemName)).getAsRampStyle();
        }
        return rampElem.getThreeColors();
    }

    public static String parseStyleElementName(String str) {
        int index = str.indexOf(styleRefSeparator);
        String en = str.substring(0, index);
        return en;
    }

    public static String parseStyleAttributeName(String str) {
        int index = str.indexOf(styleRefSeparator);
        String an = str.substring(index + 1);
        return an;
    }

    public static void setDefaultTextStyle(StatGraph graph, String styleElem, TextAttrs textStyle, String defaultStyleElem) {
        if (graph.style == null) {
            return;
        }
        TextStyleElement textElem = graph.style.graphStyle.getTextStyleElement("ValueText");
        if (defaultStyleElem != null && defaultStyleElem.length() > 0) {
            textElem = textElem.mergeWith((StyleElement)graph.style.graphStyle.getTextStyleElement(defaultStyleElem)).getAsTextStyle();
        }
        if (styleElem != null && styleElem.length() > 0) {
            textElem = textElem.mergeWith((StyleElement)graph.style.graphStyle.getTextStyleElement(styleElem)).getAsTextStyle();
        }
        textElem.useFontLookupTable = graph.useFontLookupTable;
        textStyle.setColor(textElem.getTextColor());
        textStyle.setAltColor(textElem.getAltTextColor());
        String family = textElem.getFontFamily();
        int weight = textElem.getFontWeight();
        int style = textElem.getFontStyle();
        int size = textElem.getFontSize().toPoints(graph.getDPI(), graph.size.height);
        size = graph.scaleFontSize(size);
        int fontStyle = 0;
        if (style == 2) {
            fontStyle |= 2;
        }
        if (weight == 1) {
            fontStyle |= 1;
        }
        if (StatGraph.useFontManager) {
            textStyle.setFont(FontManager.getFont((String)family, (int)fontStyle, (int)size));
        } else {
            textStyle.setFont(new Font(family, fontStyle, size));
        }
    }

    public static void setDefaultTextStyle(StatGraph graph, String styleElem, TextStyle textStyle, String defaultStyleElem) {
        TextAttrs ta = new TextAttrs();
        GraphStyle.setDefaultTextStyle(graph, styleElem, ta, defaultStyleElem);
        textStyle.setColor(ta.getColor());
        textStyle.setAltColor(ta.getAltColor());
        textStyle.setFont(ta.getFont());
    }

    public static void updateTextStyle(StatGraph graph, TextAttrs ts, String context) {
        if (context == null || context.length() == 0) {
            return;
        }
        TextStyleElement elem = graph.style.graphStyle.getStyleElement(context).getAsTextStyle();
        elem.useFontLookupTable = graph.useFontLookupTable;
        ts.setColor(elem.getColorAttribute("textColor", ts.getColor()));
        ts.setAltColor(elem.getColorAttribute("altTextColor", ts.getAltColor()));
        Font oldFont = ts.getFont();
        int fontStyle = oldFont.getStyle();
        String oldWeight = "normal";
        String oldStyle = "normal";
        if (fontStyle == 1) {
            oldWeight = "bold";
        } else if (fontStyle == 2) {
            oldStyle = "italic";
        } else if (fontStyle == 3) {
            oldWeight = "bold";
            oldStyle = "italic";
        }
        String fFamily = elem.getFontFamily(oldFont.getFamily());
        String fWeight = elem.getAttribute("fontWeight", oldWeight);
        String fStyle = elem.getAttribute("fontStyle", oldStyle);
        String fSize = elem.getAttribute("fontSize", String.valueOf(oldFont.getSize()));
        int size = graph.unit2FontSize(fSize);
        if (fStyle.length() > 0 || fWeight.length() > 0) {
            boolean italic = fStyle.equals("italic");
            boolean bold = fWeight.equals("bold");
            fontStyle = 0;
            if (bold) {
                fontStyle |= 1;
            }
            if (italic) {
                fontStyle |= 2;
            }
        }
        if (StatGraph.useFontManager) {
            ts.setFont(FontManager.getFont((String)fFamily, (int)fontStyle, (int)size));
        } else {
            ts.setFont(new Font(fFamily, fontStyle, size));
        }
    }

    public static void updateTextStyle(StatGraph graph, TextStyle ts, String context) {
        if (context == null || context.length() == 0) {
            return;
        }
        TextAttrs ta = new TextAttrs();
        ta.setColor(ts.getColor());
        ta.setFont(ts.getFont());
        GraphStyle.updateTextStyle(graph, ta, context);
        ts.setColor(ta.getColor());
        ts.setFont(ta.getFont());
    }

    public static void setDefaultLineStyle(StatGraph graph, String styleElem, LineAttrs lineStyle, String defaultStyleElem) {
        GraphStyle.setDefaultLineStyle(graph, styleElem, lineStyle, "Default", defaultStyleElem);
    }

    public static void setDefaultDataLineStyle(StatGraph graph, String styleElem, LineAttrs lineStyle, String defaultStyleElem) {
        GraphStyle.setDefaultLineStyle(graph, styleElem, lineStyle, "Data", defaultStyleElem);
    }

    private static void setDefaultLineStyle(StatGraph graph, String styleElem, LineAttrs lineStyle, String type, String defaultStyleElem) {
        if (graph.style == null) {
            return;
        }
        if (type.equalsIgnoreCase("Data")) {
            DataStyleElement ds;
            DataStyleElement lineElem = graph.style.graphStyle.getDataStyleElement("GraphDataStyleDefault");
            if (defaultStyleElem != null) {
                ds = graph.style.graphStyle.getDataStyleElement(defaultStyleElem);
                ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "line", defaultStyleElem);
                lineElem = lineElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            if (styleElem != null && styleElem.length() > 0) {
                ds = graph.style.graphStyle.getDataStyleElement(styleElem);
                ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "line", styleElem);
                lineElem = lineElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            lineStyle.setColor(lineElem.getLineColor());
            lineStyle.setLinePattern(lineElem.getLineStyle());
            int lt = lineElem.getLineThickness().toPixels(graph.getDPI(), graph.size.height);
            lineStyle.setWidth(graph.scaleLineThickness(lt));
        } else {
            DataStyleElement lineElem = graph.style.graphStyle.getDataStyleElement(defaultStyleElem);
            lineElem = graph.style.graphStyle.getRemappedGraphDataElement(lineElem, "line", defaultStyleElem);
            if (styleElem != null && styleElem.length() > 0) {
                lineElem = graph.style.graphStyle.getDataStyleElement(styleElem);
                lineElem = graph.style.graphStyle.getRemappedGraphDataElement(lineElem, "line", styleElem);
                lineElem = lineElem.mergeWith((StyleElement)lineElem).getAsDataStyle();
            }
            lineStyle.setColor(lineElem.getLineColor());
            lineStyle.setLinePattern(lineElem.getLineStyle());
            int lt = lineElem.getLineThickness().toPixels(graph.getDPI(), graph.size.height);
            lineStyle.setWidth(graph.scaleLineThickness(lt));
        }
    }

    public static void setDefaultMarkerStyle(StatGraph graph, String styleElem, MarkerAttrs markerStyle, String defaultStyleElem) {
        DataStyleElement ds;
        if (graph.style == null) {
            return;
        }
        MarkerStyleElement markerElem = graph.style.graphStyle.getMarkerStyleElement("GraphDataStyleDefault");
        if (defaultStyleElem != null) {
            ds = graph.style.graphStyle.getDataStyleElement(defaultStyleElem);
            ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "marker", defaultStyleElem);
            markerElem = markerElem.mergeWith((StyleElement)ds).getAsMarkerStyle();
        }
        if (styleElem != null && styleElem.length() > 0) {
            ds = graph.style.graphStyle.getDataStyleElement(styleElem);
            ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "marker", styleElem);
            markerElem = markerElem.mergeWith((StyleElement)ds).getAsMarkerStyle();
        }
        markerStyle.setColor(markerElem.getMarkerColor());
        int ms = markerElem.getMarkerSize().toPixels(graph.getDPI(), graph.size.height);
        markerStyle.setSize(graph.scaleMarkerSize(ms));
        markerStyle.setShape(markerElem.getMarkerSymbol());
    }

    public static void setDefaultFillStyle(StatGraph graph, String styleElem, FillAttrs fillStyle, String defaultStyleElem) {
        GraphStyle.setDefaultFillStyle(graph, styleElem, fillStyle, "Default", defaultStyleElem);
    }

    public static void setDefaultDataFillStyle(StatGraph graph, String styleElem, FillAttrs fillStyle, String defaultStyleElem) {
        GraphStyle.setDefaultFillStyle(graph, styleElem, fillStyle, "Data", defaultStyleElem);
    }

    public static void setDefaultFillStyle(StatGraph graph, String styleElem, FillAttrs fillStyle, String type, String defaultStyleElem) {
        if (graph.style == null) {
            return;
        }
        if (type.equalsIgnoreCase("Data")) {
            DataStyleElement ds;
            DataStyleElement fillElem = graph.style.graphStyle.getDataStyleElement("GraphDataStyleDefault");
            if (defaultStyleElem != null) {
                ds = graph.style.graphStyle.getDataStyleElement(defaultStyleElem);
                ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "fill", defaultStyleElem);
                fillElem = fillElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            if (styleElem != null && styleElem.length() > 0) {
                ds = graph.style.graphStyle.getDataStyleElement(styleElem);
                ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "fill", styleElem);
                fillElem = fillElem.mergeWith((StyleElement)ds).getAsDataStyle();
            }
            fillStyle.setColor(fillElem.getFillColor());
        } else {
            FillStyleElement fillElem = graph.style.graphStyle.getFillStyleElement(defaultStyleElem);
            if (styleElem != null && styleElem.length() > 0) {
                fillElem = fillElem.mergeWith((StyleElement)graph.style.graphStyle.getFillStyleElement(styleElem)).getAsFillStyle();
            }
            fillStyle.setColor(fillElem.getFillColor());
        }
    }

    public static void setDefaultFillPatternStyle(StatGraph graph, String styleElem, FillPatternAttrs fillPatternStyle, String defaultStyleElem) {
        DataStyleElement ds;
        if (graph.style == null) {
            return;
        }
        DataStyleElement fillElem = graph.style.graphStyle.getDataStyleElement("GraphDataStyleDefault");
        if (defaultStyleElem != null) {
            ds = graph.style.graphStyle.getDataStyleElement(defaultStyleElem);
            ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "fillPattern", defaultStyleElem);
            fillElem = fillElem.mergeWith((StyleElement)ds).getAsDataStyle();
        }
        if (styleElem != null && styleElem.length() > 0) {
            ds = graph.style.graphStyle.getDataStyleElement(styleElem);
            ds = graph.style.graphStyle.getRemappedGraphDataElement(ds, "fillPattern", styleElem);
            fillElem = fillElem.mergeWith((StyleElement)ds).getAsDataStyle();
        }
        fillPatternStyle.setColor(fillElem.getContrastColor());
        int fp = FillPatternAttrs.getPattern((String)fillElem.getFillPattern());
        if (fp < 0) {
            fp = FillPatternAttrs.getPattern((String)"E");
        }
        fillPatternStyle.setPattern(fp);
    }

    private static Element getStyleElementByName(Element styleRoot, String name) {
        NodeList children = styleRoot.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase("style:Style") || !e.hasAttribute("name") || !e.getAttribute("name").startsWith(name)) continue;
            return e;
        }
        return null;
    }

    private static Element getStyleElement(Element styleRoot, String context) {
        NodeList children = styleRoot.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase("style:Style") || !e.hasAttribute("context") || !context.equalsIgnoreCase(e.getAttribute("context"))) continue;
            return e;
        }
        return null;
    }

    private static Object[] getGraphDataElements(Element styleRoot) {
        Element se = null;
        int current = 1;
        Vector<Element> list = new Vector<Element>();
        while ((se = GraphStyle.getStyleElement(styleRoot, "GraphDataStyle" + current)) != null) {
            list.addElement(se);
            ++current;
        }
        return list.toArray();
    }

    private static String resolveStyleReference(Element styleRoot, String attrValue) {
        if (attrValue.indexOf(styleRefSeparator) >= 0) {
            Element elem;
            String en = GraphStyle.parseStyleElementName(attrValue);
            String an = GraphStyle.parseStyleAttributeName(attrValue);
            attrValue = null;
            if (en != null && (elem = GraphStyle.getStyleElement(styleRoot, en)) != null && elem.hasAttribute(an)) {
                attrValue = elem.getAttribute(an);
            }
        }
        return attrValue;
    }

    public int getAttrPriority() {
        return this.attrPriority;
    }

    public void setAttrPriority(int attrPriority) {
        this.attrPriority = attrPriority;
    }

    public Color getGroupNextFillColor() {
        if (this.attrPriority == 0 || this.attrPriority == 1) {
            return this.getNextFillColor();
        }
        return null;
    }

    public Color getGroupNextContrastColor() {
        if (this.attrPriority == 0 || this.attrPriority == 1) {
            return this.getNextContrastColor();
        }
        return null;
    }

    public int getColorCount() {
        int num_colors = Math.min(this.fillColorList.length, this.contrastColorList.length);
        if (num_colors == 0) {
            num_colors = Math.max(this.fillColorList.length, this.contrastColorList.length);
        }
        return num_colors;
    }

    public int getGroupNextMarkerSymbol() {
        if (this.attrPriority == 0) {
            return this.getNextMarkerSymbol();
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.getNextMarkerSymbol();
        }
        int colorCycle = this.cycleAttrs ? this.contextCnt++ / nc : this.markerSymbolCnt++ / nc;
        return this.markerSymbolList[colorCycle % this.markerSymbolList.length];
    }

    public LineAttrs getGroupNextLineStyle() {
        if (this.attrPriority == 0) {
            return this.getNextLineStyle();
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.getNextLineStyle();
        }
        int colorCycle = this.cycleAttrs ? this.contextCnt++ / nc : this.lineStyleCnt++ / nc;
        return this.lineStyleList[colorCycle % this.lineStyleList.length];
    }

    public int getGroupNextFillPattern() {
        if (this.attrPriority == 0) {
            return this.getNextFillPattern();
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.getNextFillPattern();
        }
        int colorCycle = this.cycleAttrs ? this.contextCnt++ / nc : this.fillPatternCnt++ / nc;
        return this.fillPatternList[colorCycle % this.fillPatternList.length];
    }

    public Color[] getGroupFillColorList() {
        if (this.attrPriority == 0 || this.attrPriority == 1) {
            return this.fillColorList;
        }
        return null;
    }

    public Color[] getGroupContrastColorList() {
        if (this.attrPriority == 0 || this.attrPriority == 1) {
            return this.contrastColorList;
        }
        return null;
    }

    public int[] getGroupMarkerSymbolList() {
        if (this.attrPriority == 0) {
            return this.markerSymbolList;
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.markerSymbolList;
        }
        int nm = nc * this.markerSymbolList.length;
        int[] markerSymbols = new int[nm];
        for (int i = 0; i < nm; ++i) {
            int colorCycle = i / nc;
            markerSymbols[i] = this.markerSymbolList[colorCycle];
        }
        return markerSymbols;
    }

    public LineAttrs[] getGroupLineStyleList() {
        if (this.attrPriority == 0) {
            return this.lineStyleList;
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.lineStyleList;
        }
        int nl = nc * this.lineStyleList.length;
        LineAttrs[] lineStyles = new LineAttrs[nl];
        for (int i = 0; i < nl; ++i) {
            int colorCycle = i / nc;
            lineStyles[i] = this.lineStyleList[colorCycle];
        }
        return lineStyles;
    }

    public int[] getGroupFillPatternList() {
        if (this.attrPriority == 0) {
            return this.fillPatternList;
        }
        int nc = this.getColorCount();
        if (nc == 0) {
            return this.fillPatternList;
        }
        int nf = nc * this.fillPatternList.length;
        int[] fillPatterns = new int[nf];
        for (int i = 0; i < nf; ++i) {
            int colorCycle = i / nc;
            fillPatterns[i] = this.fillPatternList[colorCycle];
        }
        return fillPatterns;
    }

    public static void updateGraphDataStyles(Element schemeRoot, String attrPriority, String[] dataColors, String[] dataContrastColors, String[] dataSymbols, String[] dataLinePatterns, String dataSkin) {
        GraphStyle.updateGraphDataStyles(schemeRoot, false, attrPriority, dataColors, dataContrastColors, dataSymbols, dataLinePatterns, dataSkin);
    }

    public static void updateGraphDataStyles(Element schemeRoot, String attrPriority, String[] dataColors, String[] dataContrastColors, String[] dataSymbols, String[] dataLinePatterns, String[] dataFillPatterns, String dataSkin) {
        GraphStyle.updateGraphDataStyles(schemeRoot, false, attrPriority, dataColors, dataContrastColors, dataSymbols, dataLinePatterns, dataFillPatterns, dataSkin);
    }

    public static void updateGraphDataStyles(Element schemeOrStyleRoot, boolean isRoot, String attrPriority, String[] dataColors, String[] dataContrastColors, String[] dataSymbols, String[] dataLinePatterns, String dataSkin) {
        GraphStyle.updateGraphDataStyles(schemeOrStyleRoot, isRoot, attrPriority, dataColors, dataContrastColors, dataSymbols, dataLinePatterns, null, dataSkin);
    }

    public static void updateGraphDataStyles(Element schemeOrStyleRoot, boolean isRoot, String attrPriority, String[] dataColors, String[] dataContrastColors, String[] dataSymbols, String[] dataLinePatterns, String[] dataFillPatterns, String dataSkin) {
        Document d;
        int i;
        Element styleRoot;
        Element element = styleRoot = isRoot ? schemeOrStyleRoot : GraphStyle.getStyleElementByName(schemeOrStyleRoot, "StatGraphStyle");
        if (attrPriority.length() != 0 && !attrPriority.equalsIgnoreCase("AUTO")) {
            if (attrPriority.equalsIgnoreCase("COLOR")) {
                styleRoot.setAttribute("styleAttrPriority", "Color");
            } else if (attrPriority.equalsIgnoreCase("NONE")) {
                styleRoot.removeAttribute("styleAttrPriority");
            }
        }
        int num = 0;
        if (dataColors != null && dataColors.length > 0) {
            num = Math.max(num, dataColors.length);
            for (i = 0; i < dataColors.length; ++i) {
                dataColors[i] = GraphStyle.resolveStyleReference(styleRoot, dataColors[i]);
            }
        }
        if (dataContrastColors != null && dataContrastColors.length > 0) {
            num = Math.max(num, dataContrastColors.length);
            for (i = 0; i < dataContrastColors.length; ++i) {
                dataContrastColors[i] = GraphStyle.resolveStyleReference(styleRoot, dataContrastColors[i]);
            }
        }
        if (dataSymbols != null && dataSymbols.length > 0) {
            num = Math.max(num, dataSymbols.length);
            for (i = 0; i < dataSymbols.length; ++i) {
                dataSymbols[i] = GraphStyle.resolveStyleReference(styleRoot, dataSymbols[i]);
            }
        }
        if (dataLinePatterns != null && dataLinePatterns.length > 0) {
            num = Math.max(num, dataLinePatterns.length);
            for (i = 0; i < dataLinePatterns.length; ++i) {
                dataLinePatterns[i] = GraphStyle.resolveStyleReference(styleRoot, dataLinePatterns[i]);
            }
        }
        if (dataFillPatterns != null && dataFillPatterns.length > 0) {
            num = Math.max(num, dataFillPatterns.length);
            for (i = 0; i < dataFillPatterns.length; ++i) {
                dataFillPatterns[i] = GraphStyle.resolveStyleReference(styleRoot, dataFillPatterns[i]);
            }
        }
        if ((d = schemeOrStyleRoot.getOwnerDocument()) == null) {
            return;
        }
        if ((dataSkin = dataSkin.toUpperCase()).length() != 0 && (dataSkin.equals("NONE") || dataSkin.equals("PRESSED") || dataSkin.equals("SHEEN") || dataSkin.equals("CRISP") || dataSkin.equals("GLOSS") || dataSkin.equals("MATTE"))) {
            Element se = GraphStyle.getStyleElement(styleRoot, "Skins");
            if (se == null) {
                se = d.createElement("style:Style");
                se.setAttribute("context", "Skins");
                styleRoot.appendChild(se);
            }
            se.setAttribute("dataSkin", dataSkin);
        }
        if (num == 0) {
            return;
        }
        Object[] graphDataElements = GraphStyle.getGraphDataElements(styleRoot);
        int numGraphDataElements = Math.max(num, graphDataElements.length);
        if (numGraphDataElements > graphDataElements.length) {
            int start = graphDataElements.length + 1;
            for (int i2 = 0; i2 < numGraphDataElements - graphDataElements.length; ++i2) {
                Element e = d.createElement("style:Style");
                e.setAttribute("context", "GraphDataStyle" + start++);
                styleRoot.appendChild(e);
            }
        }
        for (int i3 = 1; i3 <= numGraphDataElements; ++i3) {
            Element gdElem = GraphStyle.getStyleElement(styleRoot, "GraphDataStyle" + i3);
            if (dataColors != null && dataColors.length > 0) {
                if (i3 <= dataColors.length) {
                    if (dataColors[i3 - 1] != null) {
                        gdElem.setAttribute("color", dataColors[i3 - 1]);
                        gdElem.setAttribute("fillColor", dataColors[i3 - 1]);
                    }
                } else {
                    gdElem.removeAttribute("color");
                    gdElem.removeAttribute("fillColor");
                }
            }
            if (dataContrastColors != null && dataContrastColors.length > 0) {
                if (i3 <= dataContrastColors.length) {
                    if (dataContrastColors[i3 - 1] != null) {
                        gdElem.setAttribute("altColor", dataContrastColors[i3 - 1]);
                        gdElem.setAttribute("textColor", dataContrastColors[i3 - 1]);
                        gdElem.setAttribute("markerColor", dataContrastColors[i3 - 1]);
                        gdElem.setAttribute("lineColor", dataContrastColors[i3 - 1]);
                    }
                } else {
                    gdElem.removeAttribute("altColor");
                    gdElem.removeAttribute("textColor");
                    gdElem.removeAttribute("markerColor");
                    gdElem.removeAttribute("lineColor");
                }
            }
            if (dataSymbols != null && dataSymbols.length > 0) {
                if (i3 <= dataSymbols.length) {
                    if (dataSymbols[i3 - 1] != null) {
                        gdElem.setAttribute("markerSymbol", dataSymbols[i3 - 1]);
                    }
                } else {
                    gdElem.removeAttribute("markerSymbol");
                }
            }
            if (dataLinePatterns != null && dataLinePatterns.length > 0) {
                if (i3 <= dataLinePatterns.length) {
                    if (dataLinePatterns[i3 - 1] != null && StatGraph.isNumber(dataLinePatterns[i3 - 1])) {
                        gdElem.setAttribute("lineStyle", dataLinePatterns[i3 - 1]);
                    }
                } else {
                    gdElem.removeAttribute("lineStyle");
                }
            }
            if (dataFillPatterns == null || dataFillPatterns.length <= 0) continue;
            if (i3 <= dataFillPatterns.length) {
                if (dataFillPatterns[i3 - 1] == null) continue;
                gdElem.setAttribute("fillPattern", dataFillPatterns[i3 - 1]);
                continue;
            }
            gdElem.removeAttribute("fillPattern");
        }
    }
}

