/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellAlignmentInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import java.awt.Color;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class GraphComponentParser {
    public static final String RB_KEY = "GraphComponentParser.";

    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container) {
        return GraphComponentParser.load(graph, element, component, container, 0.5f, 0.5f);
    }

    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container, float defXAlignment, float defYAlignment) {
        float f;
        Element bgAttrs;
        String str = element.getAttribute("opaque");
        if (str.length() == 0 && component instanceof Legend) {
            if (!element.getAttribute("location").equalsIgnoreCase("INSIDE") || !(container instanceof BaseOverlayContainer) && !(container instanceof RegionContainer)) {
                component.setOpaque(true);
            }
        } else if (str.equalsIgnoreCase("true")) {
            component.setOpaque(true);
        }
        FillAttrs fillStyle = new FillAttrs();
        if (component instanceof Legend || component instanceof LegendComponent) {
            GraphStyle.setDefaultFillStyle(graph, "", fillStyle, "LegendFill");
        } else {
            GraphStyle.setDefaultFillStyle(graph, element.getAttribute("backgroundAttrs"), fillStyle, "Backfill");
        }
        Color bgColor = StatGraph.parseAttrColor("backgroundColor", graph, element);
        if (bgColor == null) {
            bgColor = fillStyle.getColor();
        }
        if ((bgAttrs = StatGraph.getOptionAttrsElement(element, "BackgroundAttrs")) != null) {
            StatGraph.parseFillAttrs(graph, bgAttrs, fillStyle);
            if (bgAttrs.hasAttribute("color")) {
                bgColor = fillStyle.getColor();
            }
            if (fillStyle.getTransparency() == 1.0) {
                component.setOpaque(false);
            } else {
                component.setOpaque(true);
            }
        }
        component.setBackground(bgColor);
        str = element.getAttribute("width");
        if (str.length() > 0 && component instanceof AbstractSGComponent) {
            int w = graph.scaleMarkerSize(Integer.parseInt(str));
            ((AbstractSGComponent)component).setUserWidth(w);
        }
        if ((str = element.getAttribute("height")).length() > 0 && component instanceof AbstractSGComponent) {
            int h = graph.scaleMarkerSize(Integer.parseInt(str));
            ((AbstractSGComponent)component).setUserHeight(h);
        }
        float align = defXAlignment;
        str = element.getAttribute("hAlign").toLowerCase();
        if (str.length() > 0) {
            float f2 = str.equals("left") ? 0.0f : (str.equals("center") ? 0.5f : (align = str.equals("right") ? 1.0f : Float.NaN));
        }
        if (Float.isNaN(align)) {
            if (StatGraph.isNumber(str) && GraphComponentParser.isFloatingAlignmentSupported(element)) {
                f = Float.parseFloat(str);
                if (f >= 0.0f && f <= 1.0f) {
                    if (component instanceof CellAlignmentInterface) {
                        ((CellAlignmentInterface)component).setFractionalHAlignment(true);
                    }
                    align = f;
                } else {
                    align = defXAlignment;
                    StatGraph.printOptionError("HALIGN", str);
                }
            } else {
                align = defXAlignment;
                StatGraph.printOptionError("HALIGN", str);
            }
        }
        component.setAlignmentX(align);
        align = defYAlignment;
        str = element.getAttribute("vAlign").toLowerCase();
        if (str.length() > 0) {
            float f3 = str.equals("top") ? 0.0f : (str.equals("center") ? 0.5f : (align = str.equals("bottom") ? 1.0f : Float.NaN));
        }
        if (Float.isNaN(align)) {
            if (StatGraph.isNumber(str) && GraphComponentParser.isFloatingAlignmentSupported(element)) {
                f = Float.parseFloat(str);
                if (f >= 0.0f && f <= 1.0f) {
                    if (component instanceof CellAlignmentInterface) {
                        ((CellAlignmentInterface)component).setFractionalVAlignment(true);
                    }
                    align = 1.0f - f;
                } else {
                    align = defYAlignment;
                    StatGraph.printOptionError("VALIGN", str);
                }
            } else {
                align = defYAlignment;
                StatGraph.printOptionError("VALIGN", str);
            }
        }
        component.setAlignmentY(align);
        str = element.getAttribute("orient");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("horizontal")) {
                ((AbstractSGComponent)component).setHorizontal(true);
            } else if (str.equalsIgnoreCase("vertical")) {
                ((AbstractSGComponent)component).setHorizontal(false);
            } else {
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        if ((str = element.getAttribute("autoAlign").toLowerCase()).length() > 0 && component instanceof CellAlignmentInterface) {
            int alignStrategy = str.equals("auto") ? 2 : (str.equals("none") ? 0 : 1);
            ((CellAlignmentInterface)component).setAutoAlignStrategy(alignStrategy);
            if (alignStrategy == 1) {
                String[] opts = StatGraph.parseList2String(str);
                boolean ok = true;
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("topleft") || opts[i].equalsIgnoreCase("top") || opts[i].equalsIgnoreCase("topright") || opts[i].equalsIgnoreCase("left") || opts[i].equalsIgnoreCase("center") || opts[i].equalsIgnoreCase("right") || opts[i].equalsIgnoreCase("bottomleft") || opts[i].equalsIgnoreCase("bottom") || opts[i].equalsIgnoreCase("bottomright")) continue;
                    ok = false;
                    StatGraph.printOptionError("AUTOALIGN", opts[i]);
                    break;
                }
                if (ok) {
                    ((CellAlignmentInterface)component).setPreferredLocations(opts);
                } else {
                    ((CellAlignmentInterface)component).setAutoAlignStrategy(0);
                }
            }
        }
        return true;
    }

    private static boolean isFloatingAlignmentSupported(Element elem) {
        String parentName = ((Element)elem.getParentNode()).getTagName().toLowerCase();
        if (parentName.indexOf("overlay") < 0 && !parentName.equalsIgnoreCase("layoutregion")) {
            return false;
        }
        String elemName = elem.getTagName();
        if (elemName.equalsIgnoreCase("DiscreteLegend") || elemName.equalsIgnoreCase("MergedLegend") || elemName.equalsIgnoreCase("AutoLegend") || elemName.equalsIgnoreCase("ContinuousLegend") || elemName.equalsIgnoreCase("AxisLegend")) {
            return elem.getAttribute("location").equalsIgnoreCase("inside");
        }
        if (elemName.equalsIgnoreCase("LayoutGridded")) {
            return !elem.getAttribute("location").equalsIgnoreCase("outside");
        }
        return true;
    }
}

