/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.text.SASUserDefinedFormat;
import java.text.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class FormatParser {
    public static void load(StatGraph graph, Element elem) {
        String name = elem.getAttribute("name");
        StringBuffer sb = new StringBuffer();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("Type")) {
                Node child = node.getFirstChild();
                sb.append(child.getNodeValue()).append(" ");
                sb.append(name).append(" ");
                continue;
            }
            if (elemTag.equals("Name-Options")) {
                FormatParser.loadNameOptions((Element)node, sb);
                continue;
            }
            if (!elemTag.equals("Mapping")) continue;
            FormatParser.loadMapping((Element)node, sb);
        }
        try {
            SASUserDefinedFormat.createFormat((String)sb.toString());
        }
        catch (ParseException pe) {
            StatGraph.printDebug(pe.getMessage());
        }
    }

    static void loadNameOptions(Element elem, StringBuffer sb) {
        if (elem.hasAttributes()) {
            sb.append("(");
            String str = elem.getAttribute("default");
            if (str.length() > 0) {
                sb.append("default=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("fuzz")).length() > 0) {
                sb.append("fuzz=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("min")).length() > 0) {
                sb.append("min=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("max")).length() > 0) {
                sb.append("max=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("multiLabel")).equalsIgnoreCase("true")) {
                sb.append("multilabel").append(" ");
            }
            if ((str = elem.getAttribute("notSorted")).equalsIgnoreCase("true")) {
                sb.append("notsorted").append(" ");
            }
            if ((str = elem.getAttribute("round")).equalsIgnoreCase("true")) {
                sb.append("round").append(" ");
            }
            sb.append(") ");
        }
    }

    static void loadMapping(Element elem, StringBuffer sb) {
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("Range")) {
                FormatParser.loadRange((Element)node, sb);
                continue;
            }
            if (elemTag.equals("Label")) {
                FormatParser.loadLabel((Element)node, sb);
                continue;
            }
            if (!elemTag.equals("Label-Options")) continue;
            FormatParser.loadLabelOptions((Element)node, sb);
        }
    }

    static void loadRange(Element elem, StringBuffer sb) {
        Node child = elem.getFirstChild();
        if (child != null) {
            if (child.getNodeValue().trim().length() == 0) {
                sb.append("' '=");
            } else {
                sb.append(child.getNodeValue()).append("=");
            }
        }
    }

    static void loadLabel(Element elem, StringBuffer sb) {
        Node child = elem.getFirstChild();
        if (child != null) {
            sb.append(child.getNodeValue()).append(" ");
        }
    }

    static void loadLabelOptions(Element elem, StringBuffer sb) {
        if (elem.hasAttributes()) {
            sb.append("(");
            String str = elem.getAttribute("dataType");
            if (str.length() > 0) {
                sb.append("datatype=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("decSep")).length() > 0) {
                sb.append("decsep=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("dig3Sep")).length() > 0) {
                sb.append("dig3sep=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("language")).length() > 0) {
                sb.append("language=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("fill")).length() > 0) {
                sb.append("fill=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("mult")).length() > 0) {
                sb.append("mult=").append(str).append(" ");
            }
            if ((str = elem.getAttribute("noEdit")).equalsIgnoreCase("true")) {
                sb.append("noedit").append(" ");
            }
            if ((str = elem.getAttribute("prefix")).length() > 0) {
                sb.append("prefix=").append("'").append(str).append("'").append(" ");
            }
            sb.append(") ");
        }
    }
}

