/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.EntryItemParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.RotatedJTextPane;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EntryConcatParser {
    public static final String RB_KEY = "EntryConcatParser.";
    public static final int ENTRY_TEXT = 0;
    public static final int TITLE_TEXT = 1;
    public static final int FOOTNOTE_TEXT = 2;
    public static TextStyle defaultTextStyle = null;
    public static int MAX_CHARACTERS = Integer.MAX_VALUE;

    public static void load(StatGraph graph, Element element, JComponent component, JComponent container, int type) {
        Entry entryItem;
        Element eiElem;
        Node node;
        Element padAttrs;
        Font defaultFont = (Font)UIManager.get("TextPane.font");
        GraphComponentParser.load(graph, element, component, container);
        EntryComposite oc = (EntryComposite)component;
        boolean opaque = oc.isComponentOpaque();
        double theta = 0.0;
        if (element.hasAttribute("rotate")) {
            String angle = element.getAttribute("rotate");
            if (angle.equals("0") || angle.equals("90") || angle.equals("180") || angle.equals("270")) {
                theta = Double.parseDouble(angle);
            } else {
                StatGraph.printOptionError("ROTATE", angle);
            }
        }
        if ((padAttrs = StatGraph.getOptionAttrsElement(element, "PadAttrs")) == null) {
            if (!element.hasAttribute("pad")) {
                padAttrs = element.getOwnerDocument().createElement("PadAttrs");
                if (theta == 0.0) {
                    padAttrs.setAttribute("left", "3");
                    padAttrs.setAttribute("right", "3");
                } else {
                    padAttrs.setAttribute("top", "3");
                    padAttrs.setAttribute("bottom", "3");
                }
                element.appendChild(padAttrs);
            }
        } else if (theta == 0.0) {
            if (!padAttrs.hasAttribute("left")) {
                padAttrs.setAttribute("left", "3");
            }
            if (!padAttrs.hasAttribute("right")) {
                padAttrs.setAttribute("right", "3");
            }
        } else {
            if (!padAttrs.hasAttribute("top")) {
                padAttrs.setAttribute("top", "3");
            }
            if (!padAttrs.hasAttribute("bottom")) {
                padAttrs.setAttribute("bottom", "3");
            }
        }
        StatGraph.parseBorderOpts(graph, oc, element, null);
        Border border = oc.getBorder();
        oc.setBorder(null);
        String str = element.getAttribute("hAlignCenter");
        if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
            if (str.equalsIgnoreCase("GRAPH")) {
                oc.setCenterOnGraph(true);
            } else {
                StatGraph.printOptionError("HALIGNCENTER", str);
            }
        }
        if (!((str = element.getAttribute("textFitPolicy")).length() <= 0 || str.equalsIgnoreCase("WRAP") || str.equalsIgnoreCase("SHORT") || str.equalsIgnoreCase("TRUNCATE"))) {
            StatGraph.printOptionError("TEXTFITPOLICY", str);
        }
        int shortenPolicy = type == 0 ? 3 : 0;
        DefaultStyledDocument shortDoc = null;
        Element ste = null;
        TextStyle truncationTextStyle = null;
        if (str.equalsIgnoreCase("SHORT")) {
            ste = StatGraph.getOptionAttrsElement(element, "ShortText");
            if (ste != null) {
                shortDoc = new DefaultStyledDocument();
                shortenPolicy = 1;
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "short.txt"));
            }
        } else if (str.equalsIgnoreCase("TRUNCATE")) {
            shortenPolicy = 2;
            truncationTextStyle = new TextStyle();
            if (type == 0) {
                GraphStyle.setDefaultTextStyle(graph, "", truncationTextStyle, "ValueText");
            } else if (type == 1) {
                GraphStyle.setDefaultTextStyle(graph, "", truncationTextStyle, "TitleText");
            } else {
                GraphStyle.setDefaultTextStyle(graph, "", truncationTextStyle, "FootnoteText");
            }
        }
        TextStyle textAttrs = new TextStyle();
        if (type == 0) {
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("textAttrs"), textAttrs, "ValueText");
        } else if (type == 1) {
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("textAttrs"), textAttrs, "TitleText");
            oc.setAlignmentY(0.0f);
        } else {
            GraphStyle.setDefaultTextStyle(graph, element.getAttribute("textAttrs"), textAttrs, "FootnoteText");
            oc.setAlignmentY(1.0f);
        }
        Element tae = StatGraph.getOptionAttrsElement(element, "TextAttrs");
        if (tae != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        defaultTextStyle = textAttrs;
        TextStyle defaultTextAttrs = new TextStyle(textAttrs);
        float prevHAlign = 0.5f;
        String elemTag = "";
        boolean truncated = false;
        JTextComponent left = null;
        JTextComponent center = null;
        JTextComponent right = null;
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("EntryItem") && !elemTag.equals("Sup") && !elemTag.equals("Sub")) continue;
            eiElem = (Element)node;
            entryItem = (Entry)graph.getObjectFromElement(eiElem);
            if (entryItem == null) {
                entryItem = new Entry();
            }
            textAttrs = (tae = StatGraph.getOptionAttrsElement(eiElem, "TextAttrs")) != null ? EntryItemParser.load(graph, eiElem, (JComponent)entryItem, (JComponent)oc, defaultTextAttrs, elemTag) : EntryItemParser.load(graph, eiElem, (JComponent)entryItem, (JComponent)oc, textAttrs, elemTag);
            if (!eiElem.hasAttribute("hAlign")) {
                entryItem.setAlignmentX(prevHAlign);
            }
            prevHAlign = entryItem.getAlignmentX();
            Color bgc = null;
            if (entryItem.isComponentOpaque()) {
                bgc = entryItem.getBackground();
            }
            boolean superscript = elemTag.equals("Sup");
            boolean subscript = elemTag.equals("Sub");
            boolean underline = ((Element)node).getAttribute("underline").equalsIgnoreCase("true");
            boolean strikeThrough = ((Element)node).getAttribute("strikeThrough").equalsIgnoreCase("true");
            SimpleAttributeSet set = EntryConcatParser.createAttributeSet(textAttrs, bgc, superscript, subscript, underline, strikeThrough);
            JTextComponent cur = null;
            if (entryItem.getAlignmentX() == 0.0f) {
                if (left == null) {
                    if (StatGraph.useFontManager) {
                        UIManager.put("TextPane.font", textAttrs.getFont());
                    }
                    left = new RotatedJTextPane();
                    ((RotatedJTextPane)left).setShortenPolicy(shortenPolicy);
                    left.setOpaque(opaque);
                    ((RotatedJTextPane)left).setAntialiased(graph.axisAntialiased);
                    left.setAlignmentX(0.0f);
                    ((RotatedJTextPane)left).setHAlign(0.0);
                    ((RotatedJTextPane)left).setUnderOutmostLayout(type != 0);
                    ((RotatedJTextPane)left).setTruncationTextStyle(truncationTextStyle);
                }
                cur = left;
            } else if (entryItem.getAlignmentX() == 0.5f) {
                if (center == null) {
                    if (StatGraph.useFontManager) {
                        UIManager.put("TextPane.font", textAttrs.getFont());
                    }
                    center = new RotatedJTextPane();
                    ((RotatedJTextPane)center).setShortenPolicy(shortenPolicy);
                    center.setOpaque(opaque);
                    ((RotatedJTextPane)center).setAntialiased(graph.axisAntialiased);
                    center.setAlignmentX(0.5f);
                    ((RotatedJTextPane)center).setHAlign(0.5);
                    ((RotatedJTextPane)center).setUnderOutmostLayout(type != 0);
                    ((RotatedJTextPane)center).setTruncationTextStyle(truncationTextStyle);
                }
                cur = center;
            } else {
                if (right == null) {
                    if (StatGraph.useFontManager) {
                        UIManager.put("TextPane.font", textAttrs.getFont());
                    }
                    right = new RotatedJTextPane();
                    ((RotatedJTextPane)right).setShortenPolicy(shortenPolicy);
                    right.setOpaque(opaque);
                    ((RotatedJTextPane)right).setAntialiased(graph.axisAntialiased);
                    right.setAlignmentX(1.0f);
                    ((RotatedJTextPane)right).setHAlign(1.0);
                    ((RotatedJTextPane)right).setUnderOutmostLayout(type != 0);
                    ((RotatedJTextPane)right).setTruncationTextStyle(truncationTextStyle);
                }
                cur = right;
            }
            String jus = ((Element)node).getAttribute("justification");
            if (jus.length() > 0) {
                if (jus.equalsIgnoreCase("left")) {
                    StyleConstants.setAlignment(set, 0);
                } else if (jus.equalsIgnoreCase("right")) {
                    StyleConstants.setAlignment(set, 2);
                } else {
                    StyleConstants.setAlignment(set, 1);
                }
                ((JTextPane)cur).setParagraphAttributes(set, false);
            }
            Document doc = cur.getDocument();
            try {
                if (doc.getLength() == MAX_CHARACTERS) {
                    truncated = true;
                    continue;
                }
                if (entryItem.getText() != null && doc.getLength() + entryItem.getText().length() > MAX_CHARACTERS) {
                    String trucatedString = entryItem.getText().substring(0, MAX_CHARACTERS - doc.getLength());
                    doc.insertString(doc.getLength(), trucatedString, set);
                    truncated = true;
                    continue;
                }
                doc.insertString(doc.getLength(), entryItem.getText(), set);
                continue;
            }
            catch (BadLocationException ex) {
                StatGraph.printDebug(ex.getMessage());
            }
        }
        if (truncated) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "maxchars.fmt.txt"));
            String stmt = type == 1 ? "ENTRYTITLE" : (type == 2 ? "ENTRYFOOTNOTE" : "ENTRY");
            StatGraph.printWarning(msg.toString((Object)stmt, (Object)Integer.toString(MAX_CHARACTERS)));
        }
        if (shortenPolicy == 1) {
            textAttrs = new TextStyle(defaultTextAttrs);
            for (node = ste.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("EntryItem") && !elemTag.equals("Sup") && !elemTag.equals("Sub")) continue;
                eiElem = (Element)node;
                entryItem = new Entry();
                tae = StatGraph.getOptionAttrsElement(eiElem, "TextAttrs");
                textAttrs = tae != null ? EntryItemParser.load(graph, eiElem, (JComponent)entryItem, (JComponent)oc, defaultTextAttrs, elemTag) : EntryItemParser.load(graph, eiElem, (JComponent)entryItem, (JComponent)oc, textAttrs, elemTag);
                boolean superscript = elemTag.equals("Sup");
                boolean subscript = elemTag.equals("Sub");
                boolean underline = ((Element)node).getAttribute("underline").equalsIgnoreCase("true");
                boolean strikeThrough = ((Element)node).getAttribute("strikeThrough").equalsIgnoreCase("true");
                SimpleAttributeSet set = EntryConcatParser.createAttributeSet(textAttrs, null, superscript, subscript, underline, strikeThrough);
                try {
                    shortDoc.insertString(shortDoc.getLength(), entryItem.getText(), set);
                    continue;
                }
                catch (BadLocationException ex) {
                    StatGraph.printDebug(ex.getMessage());
                }
            }
        }
        Color bgc = oc.getBackground();
        if (left != null && left.getDocument().getLength() > 0) {
            left.setBorder(border);
            left.setBackground(bgc);
            ((RotatedJTextPane)left).setTheta(theta);
            ((RotatedJTextPane)left).setShortText(shortDoc);
            oc.add(left);
        }
        if (center != null && center.getDocument().getLength() > 0) {
            center.setBorder(border);
            center.setBackground(bgc);
            ((RotatedJTextPane)center).setTheta(theta);
            ((RotatedJTextPane)center).setShortText(shortDoc);
            oc.add(center);
        }
        if (right != null && right.getDocument().getLength() > 0) {
            right.setBorder(border);
            right.setBackground(bgc);
            ((RotatedJTextPane)right).setTheta(theta);
            ((RotatedJTextPane)right).setShortText(shortDoc);
            oc.add(right);
        }
        oc.setOpaque(false);
        if (oc.getComponentCount() == 1) {
            oc.setAlignmentX(oc.getComponents()[0].getAlignmentX());
        }
        if (StatGraph.useFontManager) {
            UIManager.put("TextPane.font", defaultFont);
        }
    }

    public static SimpleAttributeSet createAttributeSet(TextStyle textAttrs, Color bgc, boolean superscript, boolean subscript, boolean underline, boolean strikeThrough) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        Font f = textAttrs.getFont();
        StyleConstants.setForeground(set, textAttrs.getColor());
        if (!StatGraph.useFontManager) {
            StyleConstants.setFontFamily(set, f.getFamily());
        }
        StyleConstants.setBold(set, f.isBold());
        StyleConstants.setItalic(set, f.isItalic());
        StyleConstants.setFontSize(set, f.getSize());
        if (bgc != null) {
            StyleConstants.setBackground(set, bgc);
        }
        StyleConstants.setSuperscript(set, superscript);
        StyleConstants.setSubscript(set, subscript);
        StyleConstants.setUnderline(set, underline);
        StyleConstants.setStrikeThrough(set, strikeThrough);
        return set;
    }
}

