/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DendrogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.text.Message;
import org.w3c.dom.Element;

public class DendrogramParser {
    public static final String RB_KEY = "DendrogramParser.";

    public static DendrogramOverlay load(StatGraph graph, Element elem) {
        DendrogramOverlay dendrogram = (DendrogramOverlay)graph.getObjectFromElement(elem);
        if (dendrogram == null) {
            dendrogram = new DendrogramOverlay();
        }
        return DendrogramParser.load(graph, dendrogram, elem) ? dendrogram : null;
    }

    public static boolean load(StatGraph graph, DendrogramOverlay dendrogram, Element elem) {
        Element cutOptsElem;
        String str;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = DendrogramParser.parseRequiredVariables(dendrogram, graph, elem, map);
        if (m == null) {
            return false;
        }
        if (graph.isCASData()) {
            dendrogram.setSortNodeIDs(true);
        }
        if (elem.hasAttribute("clusters")) {
            str = elem.getAttribute("clusters");
            String nClustersVar = StatGraph.getVarID(str);
            int nClustersCol = m.getColumn(nClustersVar);
            map.map(59, nClustersCol);
            dendrogram.addRole("NUMCLUSTERS", m.getColumnLabel(nClustersCol));
        }
        str = elem.getAttribute("primary");
        dendrogram.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, dendrogram);
        str = elem.getAttribute("orient");
        if ("HORIZONTAL".equalsIgnoreCase(str)) {
            dendrogram.setOrientation(1);
        }
        if ("TRIANGULAR".equalsIgnoreCase(str = elem.getAttribute("treeType"))) {
            dendrogram.setConnectType(2);
        }
        LineAttrs lineAttrs = dendrogram.getLineAttrs();
        DendrogramParser.parseLineAttrs(graph, elem, dendrogram, "lineAttrs", "LineAttrs", "GraphDataStyleDefault", lineAttrs);
        str = elem.getAttribute("cut");
        if ("true".equalsIgnoreCase(str) && (cutOptsElem = StatGraph.getOptionAttrsElement(elem, "CutOpts")) != null) {
            str = cutOptsElem.getAttribute("type");
            if ("nClusters".equalsIgnoreCase(str) && cutOptsElem.hasAttribute("nClusters")) {
                str = cutOptsElem.getAttribute("nClusters");
                dendrogram.setCutClusters(Integer.parseInt(str));
            } else if ("cutHeight".equalsIgnoreCase(str) && cutOptsElem.hasAttribute("cutHeight")) {
                str = cutOptsElem.getAttribute("cutHeight");
                dendrogram.setCutHeight(Double.parseDouble(str));
            }
            LineAttrs cutLineAttrs = dendrogram.getCutLineAttrs();
            DendrogramParser.parseLineAttrs(graph, cutOptsElem, dendrogram, "outlineAttrs", "OutlineAttrs", "CutLine", cutLineAttrs);
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, dendrogram);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, dendrogram);
        str = elem.getAttribute("dataSelectable");
        if (str.equalsIgnoreCase("true")) {
            dendrogram.setDataSelectable(true);
        }
        dendrogram.setModel(crd);
        if (!dendrogram.areNodeIdsUnique()) {
            graph.removeNamedGraph(dendrogram);
            Message msg = new Message(RB.getStringResource(RB_KEY, "NonUniqueIdVar.fmt.txt"));
            String varID = StatGraph.getVarID(elem.getAttribute("nodeID"));
            StatGraph.printWarning(msg.toString((Object)"NODEID", (Object)varID), false);
            return false;
        }
        if (!dendrogram.isSingleRootedTree()) {
            graph.removeNamedGraph(dendrogram);
            String varID = StatGraph.getVarID(elem.getAttribute("nodeID"));
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "MultipleRootsFound.txt"), false);
            return false;
        }
        return true;
    }

    private static DataModel parseRequiredVariables(DendrogramOverlay dendrogram, StatGraph graph, Element elem, RoleColumnMap map) {
        String str = elem.getAttribute("nodeID");
        String dataName = StatGraph.getDataName(str);
        String nodeIDVar = StatGraph.getVarID(str);
        str = elem.getAttribute("parentID");
        String parentIDVar = StatGraph.getVarID(str);
        str = elem.getAttribute("clusterHeight");
        String heightVar = StatGraph.getVarID(str);
        DataModel model = graph.getData(dataName);
        int nodeIDCol = model.getColumn(nodeIDVar);
        int parentIDCol = model.getColumn(parentIDVar);
        int heightCol = model.getColumn(heightVar);
        if (!(StatGraph.checkVariable("nodeID", model.getColumnLabel(nodeIDCol), null, 1, true) && StatGraph.checkVariable("parentID", model.getColumnLabel(parentIDCol), null, 1, true) && StatGraph.checkVariable("height", model.getColumnLabel(heightCol), Double.class, 1, true))) {
            return null;
        }
        map.map(56, nodeIDCol);
        map.map(57, parentIDCol);
        map.map(58, heightCol);
        dendrogram.addRole("NODEID", model.getColumnLabel(nodeIDCol));
        dendrogram.addRole("PARENTID", model.getColumnLabel(parentIDCol));
        dendrogram.addRole("HEIGHT", model.getColumnLabel(heightCol));
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int heightColumnIndex;
        ColumnMetadata cmd;
        int[] types = new int[3];
        String attributeValue = elem.getAttribute("height");
        String dataName = StatGraph.getDataName(attributeValue);
        DataModel model = graph.getData(dataName);
        String heightVarID = StatGraph.getVarID(attributeValue);
        if (heightVarID.length() > 0 && (cmd = (ColumnMetadata)model.getColumnLabel(heightColumnIndex = model.getColumn(heightVarID))).getType() == 2) {
            return null;
        }
        attributeValue = elem.getAttribute("orient");
        if (attributeValue.equalsIgnoreCase("Horizontal")) {
            types[0] = 0;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = 0;
        }
        types[2] = 0;
        return types;
    }

    private static LineAttrs parseLineAttrs(StatGraph graph, Element elem, Overlay overlay, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        if (la == null) {
            la = new LineAttrs();
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        la.setColor(overlay.applyDataTransparency(la.getColor()));
        return la;
    }
}

