/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.EmbeddedGeometryProvider;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class DataParser
extends DefaultHandler {
    StatGraph graph;
    DataModel model;
    int[] colNobs;
    int[] colMissings;
    double[] minValues;
    double[] maxValues;
    Class[] colClasses;
    protected static StringBuffer m_contentBuffer = new StringBuffer(32);
    private int NOBS = 0;
    private int maxNobs = -2147483647;
    private int rows = 0;
    private int columns = 0;
    private int col = 0;
    private boolean missing = true;
    private int numObs = 0;
    private StatGraph[] graphList;
    private int graphIndex = -1;
    private int loadedGraph = 0;
    private int numGraph;
    private int[] requestedGraphIDs;
    private boolean parsing;
    private double version = 0.0;

    public DataParser(StatGraph graph) {
        this(new StatGraph[]{graph});
    }

    public DataParser(StatGraph[] gList) {
        this(gList, null);
    }

    public DataParser(StatGraph[] gList, int[] ids) {
        this.graphList = gList;
        this.numGraph = this.graphList.length;
        this.requestedGraphIDs = ids;
    }

    public int getNOBS() {
        return this.NOBS;
    }

    public void setNOBS(int nobs) {
        this.NOBS = nobs;
    }

    @Override
    public void startElement(String uri, String lname, String qname, Attributes attributes) {
        this.missing = true;
        if (qname.equals("SASReport")) {
            this.version = 1.0;
            String ver = attributes.getValue("version");
            if (ver != null) {
                this.version = Double.parseDouble(ver);
            }
        } else if (qname.equals("DataModel")) {
            ++this.graphIndex;
            this.parsing = false;
            if (this.requestedGraphIDs == null) {
                this.parsing = true;
            } else if (this.loadedGraph < this.numGraph) {
                for (int i = 0; i < this.requestedGraphIDs.length; ++i) {
                    if (this.graphIndex != this.requestedGraphIDs[i]) continue;
                    this.parsing = true;
                    break;
                }
            }
            if (!this.parsing) {
                return;
            }
            this.graph = this.graphList[this.loadedGraph];
            ++this.loadedGraph;
        } else if (qname.equals("IQData")) {
            if (!this.parsing) {
                return;
            }
            String name = attributes.getValue("name").trim();
            this.model = new DataModel();
            this.model.name = name;
            this.graph.addData(this.model);
            String nObs = attributes.getValue("valuesCount");
            if (nObs != null) {
                this.numObs = Integer.parseInt(nObs);
            }
        } else if (qname.equals("EmbeddedGeometryProvider")) {
            if (!this.parsing) {
                return;
            }
            String name = attributes.getValue("name").trim();
            EmbeddedGeometryProvider provider = new EmbeddedGeometryProvider();
            provider.setName(name);
            String dataID = attributes.getValue("dataId").trim();
            provider.setDataModel(this.graph.getData(dataID));
            this.graph.addMapProvider(provider);
        } else if (qname.equals("Variable")) {
            if (!this.parsing) {
                return;
            }
            String varName = attributes.getValue("name").toUpperCase();
            if (varName.length() == 0) {
                return;
            }
            String varFormat = attributes.getValue("SASFormat");
            if (varFormat != null) {
                varFormat = varFormat.trim();
            }
            String varLabel = attributes.getValue("label");
            String varType = attributes.getValue("type").trim();
            Class varClass = Double.class;
            if (varType != null && (varType.equals("Character") || varType.equalsIgnoreCase("String"))) {
                varClass = String.class;
            }
            String nObs = attributes.getValue("valuesCount");
            int nobs = Integer.MAX_VALUE;
            nobs = nObs != null ? Integer.parseInt(nObs) : this.numObs;
            this.maxNobs = Math.max(nobs, this.maxNobs);
            String strLen = attributes.getValue("length");
            int length = 12;
            if (strLen != null) {
                length = Integer.parseInt(strLen);
            }
            ColumnMetadata cmd = new ColumnMetadata(varName, varClass == String.class ? (byte)2 : 1);
            if (varFormat != null && varFormat.length() > 0) {
                cmd.setFormat(varFormat);
            }
            if (varLabel != null && varLabel.length() > 0) {
                cmd.setLabel(varLabel);
            }
            cmd.setNobs(nobs);
            cmd.setLength(length);
            this.model.addColumn(varClass, cmd);
            this.model.varLookup.put(varName, new Integer(this.columns));
            ++this.columns;
        } else if (qname.equals("ValuesList")) {
            String nObs = attributes.getValue("valuesCount");
            if (nObs != null) {
                this.maxNobs = Integer.parseInt(nObs);
            } else {
                StatGraph.printDebug("valuesCOunt= is needed on <ValuesList>");
            }
            this.model.setSize(this.maxNobs, this.columns);
            this.colClasses = this.model.getColumnClasses();
            Object[] cmds = this.model.getColumnLabels();
            this.colNobs = new int[this.columns];
            this.colMissings = new int[this.columns];
            this.minValues = new double[this.columns];
            this.maxValues = new double[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                ((ColumnMetadata)cmds[i]).setNobs(this.maxNobs);
                this.colNobs[i] = this.maxNobs;
                this.colMissings[i] = 0;
                this.minValues[i] = Double.MAX_VALUE;
                this.maxValues[i] = -1.7976931348623157E308;
            }
        } else if (qname.equals("V")) {
            if (!this.parsing) {
                return;
            }
            if (this.rows < this.colNobs[this.col] && attributes.getIndex("M") < 0) {
                this.missing = false;
                m_contentBuffer = new StringBuffer(32);
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (!this.missing) {
            m_contentBuffer.append(chars, start, length);
        }
    }

    @Override
    public void endElement(String uri, String lname, String qname) {
        if (!this.parsing) {
            return;
        }
        if (qname.equals("Variables")) {
            if (this.version == 0.0) {
                if (this.maxNobs == Integer.MAX_VALUE) {
                    this.maxNobs = this.NOBS;
                }
                this.model.setSize(this.maxNobs, this.columns);
                this.colClasses = this.model.getColumnClasses();
                Object[] cmds = this.model.getColumnLabels();
                this.colNobs = new int[this.columns];
                this.colMissings = new int[this.columns];
                this.minValues = new double[this.columns];
                this.maxValues = new double[this.columns];
                for (int i = 0; i < this.columns; ++i) {
                    this.colNobs[i] = ((ColumnMetadata)cmds[i]).getNobs();
                    this.colMissings[i] = 0;
                    this.minValues[i] = Double.MAX_VALUE;
                    this.maxValues[i] = -1.7976931348623157E308;
                }
            }
        } else if (qname.equals("V")) {
            if (this.rows < this.maxNobs) {
                if (this.missing || m_contentBuffer.length() == 0) {
                    int n = this.col;
                    this.colMissings[n] = this.colMissings[n] + 1;
                    if (this.colClasses[this.col] == String.class) {
                        this.model.setStringValueAt(null, this.rows, this.col);
                    } else {
                        this.model.setDoubleValueAt(Double.NaN, this.rows, this.col);
                    }
                } else if (this.colClasses[this.col] == String.class) {
                    this.model.setStringValueAt(m_contentBuffer.toString(), this.rows, this.col);
                } else {
                    double dVal = Double.parseDouble(m_contentBuffer.toString());
                    if (dVal < this.minValues[this.col]) {
                        this.minValues[this.col] = dVal;
                    }
                    if (dVal > this.maxValues[this.col]) {
                        this.maxValues[this.col] = dVal;
                    }
                    this.model.setDoubleValueAt(dVal, this.rows, this.col);
                }
            }
            if (++this.col == this.columns) {
                this.col = 0;
                ++this.rows;
            }
        } else if (qname.equals("IQData")) {
            for (int i = 0; i < this.columns; ++i) {
                ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(i);
                cmd.setMin(this.minValues[i]);
                cmd.setMax(this.maxValues[i]);
                cmd.setMissings(this.colMissings[i]);
            }
            this.colNobs = null;
            this.colClasses = null;
            this.minValues = null;
            this.maxValues = null;
            this.columns = 0;
            this.rows = 0;
            this.col = 0;
            this.maxNobs = -2147483647;
        } else if (qname.equals("DataModel")) {
            // empty if block
        }
    }
}

