/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ContourOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.OContour;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.SASFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ContourParser {
    public static final String RB_KEY = "ContourParser.";

    public static ContourOverlay load(StatGraph graph, Element elem) {
        return ContourParser.load(graph, elem, null, null);
    }

    public static ContourOverlay load(StatGraph graph, Element elem, boolean[] log, double[] base) {
        OContour contour = (OContour)graph.getObjectFromElement(elem);
        if (contour == null) {
            contour = new OContour();
        }
        return ContourParser.load(graph, contour, elem, log, base) ? contour : null;
    }

    public static boolean needsSmoothFill(StatGraph graph, Element elem) {
        String str = elem.getAttribute("contourType").toLowerCase();
        if (str.length() == 0 && (str = graph.style.getStyleAttribute("Contour", "displayOpts")) == null) {
            str = "LabeledLineGradient";
        }
        return (str = str.toLowerCase()).indexOf("gradient") > -1;
    }

    public static boolean load(StatGraph graph, OContour contour, Element elem) {
        return ContourParser.load(graph, contour, elem, null, null);
    }

    public static boolean load(StatGraph graph, OContour contour, Element elem, boolean[] log, double[] base) {
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, contour);
        if (log != null && base != null) {
            if (log != null && log[0] && contour.getXAxis().equalsIgnoreCase("x")) {
                contour.setLogXAxis(true);
                contour.setLogBaseX(base[0]);
            } else if (log != null && log[1] && contour.getXAxis().equalsIgnoreCase("x2")) {
                contour.setLogXAxis(true);
                contour.setLogBaseX(base[1]);
            }
            if (log != null && log[2] && contour.getYAxis().equalsIgnoreCase("y")) {
                contour.setLogYAxis(true);
                contour.setLogBaseX(base[2]);
            } else if (log != null && log[3] && contour.getYAxis().equalsIgnoreCase("y2")) {
                contour.setLogYAxis(true);
                contour.setLogBaseX(base[3]);
            }
        }
        String str = elem.getAttribute("primary");
        contour.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("z");
        String zVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        int zcol = m.getColumn(zVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            graph.removeNamedGraph(contour);
            return false;
        }
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
            graph.removeNamedGraph(contour);
            return false;
        }
        if (!StatGraph.checkVariable("Z", m.getColumnLabel(zcol), Double.class, 1, true)) {
            graph.removeNamedGraph(contour);
            return false;
        }
        map.map(10, xcol);
        map.map(11, ycol);
        map.map(12, zcol);
        if (graph.casData) {
            contour.setPresortData(true);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, contour);
        str = elem.getAttribute("gridded");
        if (str.equalsIgnoreCase("false")) {
            contour.setGridded(false);
        }
        contour.setMaxXGridCount(graph.size.width);
        contour.setMaxYGridCount(graph.size.height);
        contour.setModel(crd);
        str = elem.getAttribute("contourType");
        if (str.length() == 0 && (str = graph.style.getStyleAttribute("Contour", "displayOpts")) == null) {
            str = "";
        }
        contour.hasLines = false;
        contour.hasLineLabels = false;
        contour.hasAreaFill = false;
        contour.hasSmoothFill = false;
        if (str.equalsIgnoreCase("line")) {
            contour.hasLines = true;
        } else if (str.equalsIgnoreCase("labeledline")) {
            contour.hasLines = true;
            contour.hasLineLabels = true;
        } else if (str.equalsIgnoreCase("fill")) {
            contour.hasAreaFill = true;
        } else if (str.equalsIgnoreCase("gradient")) {
            contour.hasSmoothFill = true;
        } else if (str.equalsIgnoreCase("linefill")) {
            contour.hasLines = true;
            contour.hasAreaFill = true;
        } else if (str.equalsIgnoreCase("linegradient")) {
            contour.hasLines = true;
            contour.hasSmoothFill = true;
        } else if (str.equalsIgnoreCase("labeledlinefill")) {
            contour.hasLines = true;
            contour.hasLineLabels = true;
            contour.hasAreaFill = true;
        } else if (str.equalsIgnoreCase("labeledlinegradient")) {
            contour.hasLines = true;
            contour.hasLineLabels = true;
            contour.hasSmoothFill = true;
        } else {
            contour.hasLines = true;
            contour.hasLineLabels = true;
            contour.hasSmoothFill = true;
            if (str.length() > 0) {
                StatGraph.printOptionError("CONTOURTYPE", str);
            }
        }
        contour.setDisableAA(!contour.hasLines || contour.hasSmoothFill);
        contour.numLev = 7;
        contour.numLevHint = true;
        str = elem.getAttribute("nHint");
        if (StatGraph.isNumber(str)) {
            int numLev;
            contour.numLev = numLev = Integer.parseInt(str);
            contour.numLevHint = true;
        }
        String elemTag = "";
        boolean userLevels = false;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            double[] levels;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("Levels") || (levels = StatGraph.parseDoubleValueList((Element)node, "Value", true)) == null || levels.length <= 0) continue;
            userLevels = contour.setLevels(levels);
        }
        if (!userLevels && StatGraph.isNumber(str = elem.getAttribute("nLevels"))) {
            int numLev;
            contour.numLev = numLev = Integer.parseInt(str);
            contour.numLevHint = false;
        }
        String contextName = graph.style.getContextName();
        contour.setContextName(contextName);
        if (contour.hasLines) {
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), ls, contextName);
            Element lineElem = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, ls);
            }
            contour.lineColor = ls.getColor();
            contour.lineStyle = ls.getLinePattern();
            contour.lineThickness = ls.getWidth();
            if (contour.hasLineLabels) {
                contour.labelStyle = 1;
                str = elem.getAttribute("lineLabelBaseline").toLowerCase();
                if (str.equals("horizontal")) {
                    contour.labelOrientation = 0;
                } else if (str.equals("tangent")) {
                    contour.labelOrientation = 1;
                } else {
                    contour.labelOrientation = 0;
                    if (str.length() > 0) {
                        StatGraph.printOptionError("LINELABELBASELINE", str);
                    }
                }
                str = elem.getAttribute("lineLabelPosition").toLowerCase();
                if (str.length() > 0) {
                    if (str.equals("begin")) {
                        contour.labelPosition = 0;
                    } else if (str.equals("middle")) {
                        contour.labelPosition = 1;
                    } else if (str.equals("end")) {
                        contour.labelPosition = 2;
                    } else {
                        StatGraph.printOptionError("LINELABELPOSITION", str);
                    }
                }
                if ((str = elem.getAttribute("lineLabelFormat")).length() > 0) {
                    contour.labelFormat = SASFormat.getInstance((String)str);
                } else {
                    ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(zcol);
                    contour.labelFormat = cmd.getFormat();
                }
                TextStyle labelStyle = new TextStyle();
                GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("lineLabelAttrs"), labelStyle, "ValueText");
                Element textElem = StatGraph.getOptionAttrsElement(elem, "LineLabelAttrs");
                if (textElem != null) {
                    StatGraph.parseTextAttrs(graph, textElem, labelStyle);
                }
                contour.labelTextStyle = labelStyle;
            }
        }
        if (contour.hasAreaFill || contour.hasSmoothFill) {
            Color[] colors;
            str = elem.getAttribute("colorModel");
            Color[] cl = graph.style.getRampColors(str, "ThreeColorRamp");
            str = elem.getAttribute("reverseColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            Element cmElem = StatGraph.getOptionAttrsElement(elem, "ColorModel");
            if (cmElem != null && (colors = StatGraph.parseColorValueList(graph, cmElem, "Value")) != null && colors.length > 0) {
                cl = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
            }
            contour.rampColors = new Color[cl.length];
            for (int i = 0; i < cl.length; ++i) {
                int idx = reverse ? cl.length - 1 - i : i;
                contour.rampColors[i] = contour.applyDataTransparency(cl[idx]);
            }
        }
        return true;
    }
}

