/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class BoxParser {
    public static final String RB_KEY = "BoxParser.";

    public static BoxOverlay load(StatGraph graph, Element elem) {
        BoxOverlay box = (BoxOverlay)graph.getObjectFromElement(elem);
        if (box == null) {
            box = new BoxOverlay();
        }
        return BoxParser.load(graph, box, elem) ? box : null;
    }

    public static boolean load(StatGraph graph, BoxOverlay box, Element elem) {
        int i;
        String indexVarID;
        int ii;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, box);
        String str = elem.getAttribute("primary");
        box.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("y");
        String dataName = StatGraph.getDataName(str);
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("stat");
        String sVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("x");
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("dataLabel");
        String lVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("group");
        String gVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int ycol = m.getColumn(yVarID);
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 2, true)) {
            graph.removeNamedGraph(box);
            return false;
        }
        map.map(11, ycol);
        box.addRole("Y", m.getColumnLabel(ycol));
        int scol = m.getColumn(sVarID);
        if (!StatGraph.checkVariable("STAT", m.getColumnLabel(scol), String.class, -1, true, true)) {
            graph.removeNamedGraph(box);
            return false;
        }
        map.map(47, scol);
        box.addRole("STAT", m.getColumnLabel(scol));
        if (!xVarID.equals("")) {
            int xcol = m.getColumn(xVarID);
            if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), null, 2, true)) {
                graph.removeNamedGraph(box);
                return false;
            }
            map.map(10, xcol);
            box.addRole("X", m.getColumnLabel(xcol));
        }
        boolean labelsOn = false;
        if (!lVarID.equals("")) {
            int lcol = m.getColumn(lVarID);
            map.map(5, lcol);
            labelsOn = true;
            box.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        if (!gVarID.equals("")) {
            int gcol = m.getColumn(gVarID);
            map.map(3, gcol);
            map.map(6, gcol);
            map.map(36, gcol);
            map.map(46, gcol);
            map.map(45, gcol);
            map.map(68, gcol);
            map.map(8, gcol);
            map.map(111, gcol);
            map.map(112, gcol);
            box.addRole("GROUP", m.getColumnLabel(gcol));
            str = elem.getAttribute("includeMissingGroup");
            if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                box.setMissingGroupOn(false);
            }
            if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                box.addAttrVar("TUKEYGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                box.addAttrVar("OUTLIERGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : gVarID;
                DAMDatasetParser.addInternalAttrVar(graph, box, "TUKEYGROUP", originalGroup);
                DAMDatasetParser.addInternalAttrVar(graph, box, "OUTLIERGROUP", originalGroup);
            }
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    box.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    box.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    box.setGroupOrder(0);
                } else if (str.equalsIgnoreCase("ReverseData")) {
                    box.setGroupOrder(3);
                } else {
                    box.setGroupOrder(0);
                    StatGraph.printOptionError("GROUPORDER", str);
                }
            }
            if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
                box.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                box.setGroupDisplay(0);
            } else {
                box.setGroupDisplay(1);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            map.map(44, ii);
            box.addRole("INDEX", m.getColumnLabel(ii));
        }
        BoxParser.parseRoleTipStuff(elem, m, map, box);
        StatGraph.parseURLOpt(elem, m, map, box);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        str = elem.getAttribute("panelByCount");
        if (StatGraph.isNumber(str)) {
            StatGraph.MPC = Integer.parseInt(str);
        }
        String oldWhereExp = graph.whereExpression;
        String oldModel = graph.whereDataModelName;
        StringVariable[] oldWhereVars = graph.whereVars;
        if (StatGraph.MPC > 0) {
            int page = 0;
            str = elem.getAttribute("panelNumber");
            if (str.length() > 0) {
                if (!StatGraph.isNumber(str)) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "page.fmt.txt"));
                    StatGraph.printWarning(msg.toString((Object)str));
                    graph.removeNamedGraph(box);
                    return false;
                }
                page = Integer.parseInt(str) - 1;
                if (page < 0) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "page.fmt.txt"));
                    StatGraph.printWarning(msg.toString((Object)str));
                    graph.removeNamedGraph(box);
                    return false;
                }
            }
            graph.whereDataModelName = crd.getSrcModel().name;
            int xcol = crd.getSrcModel().getColumn(xVarID);
            ColumnMetadata cmd = (ColumnMetadata)crd.getSrcModel().getColumnLabel(xcol);
            StringVectorVariable xWhereVar = new StringVectorVariable();
            xWhereVar.setName(cmd.getName());
            xWhereVar.setLabel(cmd.getLabel());
            xWhereVar.connectFrom(crd.getSrcModel().getColumnAsClassColumn(xcol, StatGraph.includeMissingDiscrete));
            graph.whereExpression = BoxParser.buildWhereExpression(xWhereVar, StatGraph.MPC, page, graph);
            graph.whereVars = new StringVectorVariable[]{xWhereVar};
        }
        if (graph.whereExpression != null) {
            LayoutOverlayParser.parseWhere(graph, crd, box);
        }
        graph.whereExpression = oldWhereExp;
        graph.whereDataModelName = oldModel;
        graph.whereVars = oldWhereVars;
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            box.setOrientation(1);
        } else if (str.equalsIgnoreCase("Vertical")) {
            box.setOrientation(0);
        } else {
            box.setOrientation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        str = elem.getAttribute("sortRole");
        if (str.length() > 0 && str.equalsIgnoreCase("x")) {
            crd.setSortRole(10);
        }
        if (labelsOn && (str = elem.getAttribute("labelFar")).equalsIgnoreCase("true")) {
            box.setLabelFar(true);
        }
        if ((str = elem.getAttribute("spread")).equalsIgnoreCase("true")) {
            box.setSpread(true);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("boxWidth"))) {
            double width = Double.parseDouble(str);
            box.setBoxWidth(width);
            box.setUserBoxScale(true);
        } else if (gVarID.equals("")) {
            box.setBoxWidth(0.4);
        } else {
            box.setBoxWidth(0.6);
        }
        str = elem.getAttribute("intervalBoxWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            if (width >= 0.0) {
                box.setIntervalBoxWidth(width);
            }
        } else if (str.equalsIgnoreCase("auto")) {
            box.setIntervalBoxWidth(-1.0);
        }
        if (box.getOrientation() == 0) {
            if (box.getXAxis().equalsIgnoreCase("x2")) {
                box.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
            } else {
                box.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
            }
        } else if (box.getYAxis().equalsIgnoreCase("y2")) {
            box.setDiscreteX(LayoutOverlayParser.y2AxisType == 2);
        } else {
            box.setDiscreteX(LayoutOverlayParser.yAxisType == 2);
        }
        StatGraph.parseDataSkinOpt(graph, elem, box);
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                BoxParser.setDisplayAll(box, true);
            } else if (str.equalsIgnoreCase("none")) {
                BoxParser.setDisplayAll(box, false);
            } else {
                String[] opts = StatGraph.parseList2String(str);
                BoxParser.setDisplayAll(box, false);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("connect")) {
                        box.setConnectOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("caps")) {
                        box.setCapOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        box.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("median")) {
                        box.setMedianOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("mean")) {
                        box.setMeanOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("outliers")) {
                        box.setMarkersOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("notches")) {
                        box.setNotched(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        box.setFillPatternOn(true);
                        continue;
                    }
                    BoxParser.setDisplayAll(box, false);
                    box.setCapOn(true);
                    box.setFillOn(true);
                    box.setMeanOn(true);
                    box.setMedianOn(true);
                    box.setMarkersOn(true);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Box", "displayOpts");
            if (str != null) {
                String[] opts = StatGraph.parseList2String(str);
                BoxParser.setDisplayAll(box, false);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("connect")) {
                        box.setConnectOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("caps")) {
                        box.setCapOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        box.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("median")) {
                        box.setMedianOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("mean")) {
                        box.setMeanOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("outliers")) {
                        box.setMarkersOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("notches")) {
                        box.setNotched(true);
                        continue;
                    }
                    if (!opts[i].equalsIgnoreCase("fillPattern")) continue;
                    box.setFillPatternOn(true);
                }
                if (!BoxParser.isBoxOn(box)) {
                    box.setCapOn(true);
                    box.setFillOn(true);
                    box.setMeanOn(true);
                    box.setMedianOn(true);
                    box.setMarkersOn(true);
                }
            }
        }
        if (gVarID.equals("") && box.isDiscreteX() && (str = elem.getAttribute("categoryOrderRole")).length() > 0) {
            if (str.equalsIgnoreCase("MEAN")) {
                box.setCategoryOrderRole(BoxOverlay.ORDER_MEAN);
            } else if (str.equalsIgnoreCase("MEDIAN")) {
                box.setCategoryOrderRole(BoxOverlay.ORDER_MEDIAN);
            } else if (str.equalsIgnoreCase("AUTO")) {
                box.setCategoryOrderRole(BoxOverlay.ORDER_AUTO);
            } else {
                StatGraph.printOptionError("CATEGORYORDERROLE", str);
            }
        }
        box.setModel(crd);
        FillAttrs fillStyle = null;
        String contextName = graph.style.getContextName();
        box.setContextName(contextName);
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), box.getOutlineStyle(), contextName);
            LineAttrs ls = new LineAttrs();
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), ls, "Outlines");
            if (box.isFillOn()) {
                box.getOutlineStyle().setLinePattern(ls.getLinePattern());
            }
            box.getOutlineStyle().setWidth(ls.getWidth());
        } else {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), box.getOutlineStyle(), "Outlines");
        }
        if (box.isFillOn()) {
            fillStyle = box.getFillStyle();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
        }
        if (box.isCapOn()) {
            int capShape = 1;
            str = elem.getAttribute("capShape");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("line")) {
                    capShape = 2;
                } else if (str.equalsIgnoreCase("bracket")) {
                    capShape = 3;
                } else if (str.equalsIgnoreCase("serif")) {
                    capShape = 1;
                } else if (str.equalsIgnoreCase("none")) {
                    capShape = 0;
                } else {
                    StatGraph.printOptionError("CAPSHAPE", str);
                }
            } else {
                str = graph.style.getStyleAttribute("Box", "capStyle");
                if (str != null) {
                    if (str.equalsIgnoreCase("line")) {
                        capShape = 2;
                    } else if (str.equalsIgnoreCase("bracket")) {
                        capShape = 3;
                    }
                }
            }
            box.setCapShape(capShape);
            str = elem.getAttribute("capScale");
            if (StatGraph.isNumber(str)) {
                box.setCapScale(Double.parseDouble(str));
            }
        }
        if (box.isWhiskersOn()) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), box.getWhiskerStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), ls, "BoxWhisker");
                if (box.isFillOn()) {
                    box.getWhiskerStyle().setLinePattern(ls.getLinePattern());
                }
                box.getWhiskerStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("whiskerAttrs"), box.getWhiskerStyle(), "BoxWhisker");
            }
        }
        if (box.isMedianOn()) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), box.getMedianStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), ls, "BoxMedian");
                if (box.isFillOn()) {
                    box.getMedianStyle().setLinePattern(ls.getLinePattern());
                }
                box.getMedianStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("medianAttrs"), box.getMedianStyle(), "BoxMedian");
            }
        }
        MarkerAttrs meanStyle = null;
        if (box.isMeanOn()) {
            meanStyle = new MarkerAttrs();
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), meanStyle, contextName);
                MarkerAttrs ms = new MarkerAttrs();
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), ms, "BoxMean");
                box.setMeanColor(meanStyle.getColor());
                box.setMeanSymbol(meanStyle.getShape());
                box.setMeanSize(ms.getSize());
                box.setMeanWeight(ms.getWeight());
            } else {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("meanAttrs"), meanStyle, "BoxMean");
                box.setMeanColor(meanStyle.getColor());
                box.setMeanSymbol(meanStyle.getShape());
                box.setMeanSize(meanStyle.getSize());
                box.setMeanWeight(meanStyle.getWeight());
            }
        }
        if (box.isFillPatternOn()) {
            GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), box.getFillPatternStyle(), contextName);
        }
        boolean extreme = false;
        str = elem.getAttribute("extreme");
        if (str.equalsIgnoreCase("true")) {
            extreme = true;
            box.setExtreme(extreme);
        }
        MarkerAttrs outlierStyle = null;
        if (box.isMarkersOn() && !extreme) {
            outlierStyle = new MarkerAttrs();
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("outlierAttrs"), outlierStyle, contextName);
            } else {
                GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("outlierAttrs"), outlierStyle, "Outlier");
            }
            box.setMarkerColor(outlierStyle.getColor());
            box.setMarkerSymbol(outlierStyle.getShape());
            box.setMarkerSize(outlierStyle.getSize());
            box.setMarkerWeight(outlierStyle.getWeight());
        }
        if (box.isConnectOn()) {
            int connect = 6;
            str = elem.getAttribute("connect");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("min")) {
                    connect = 1;
                } else if (str.equalsIgnoreCase("q1")) {
                    connect = 2;
                } else if (str.equalsIgnoreCase("median")) {
                    connect = 3;
                } else if (str.equalsIgnoreCase("q3")) {
                    connect = 4;
                } else if (str.equalsIgnoreCase("max")) {
                    connect = 5;
                } else if (str.equalsIgnoreCase("mean")) {
                    connect = 6;
                } else {
                    StatGraph.printOptionError("CONNECT", str);
                }
                box.setConnectBy(connect);
            } else {
                str = graph.style.getStyleAttribute("Box", "connect");
                if (str != null) {
                    connect = str.equalsIgnoreCase("min") ? 1 : (str.equalsIgnoreCase("q1") ? 2 : (str.equalsIgnoreCase("median") ? 3 : (str.equalsIgnoreCase("q3") ? 4 : (str.equalsIgnoreCase("max") ? 5 : (str.equalsIgnoreCase("mean") ? 6 : 6)))));
                    box.setConnectBy(connect);
                }
            }
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), box.getLineStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), ls, "ConnectLine");
                if (box.isFillOn()) {
                    box.getLineStyle().setLinePattern(ls.getLinePattern());
                }
                box.getLineStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), box.getLineStyle(), "ConnectLine");
            }
            str = elem.getAttribute("connectBreak");
            if (str.equalsIgnoreCase("true")) {
                box.setConnectSkipMiss(true);
            }
        }
        if (labelsOn) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), box.getLabelStyle(), contextName);
            } else {
                GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), box.getLabelStyle(), "DataText");
            }
            str = elem.getAttribute("dataLabelFormat");
            if (str.length() > 0) {
                box.setLabelFormat(SASFormat.getInstance((String)str));
            }
            ScatterParser.parseDataLabelSplitting(box, elem);
        }
        box.setUseDataLabelColor(StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color"));
        box.setUseOutlineColor(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color"));
        box.setUseOutlinePattern(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "pattern") || box.isFillOn() || box.isFillPatternOn());
        box.setUseOutlineSize(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        box.setUseConnectLineColor(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "color"));
        box.setUseConnectLinePattern(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "pattern") || box.isFillOn());
        box.setUseConnectLineSize(StatGraph.isBundleAttributeFixed(elem, "connectAttrs", "thickness"));
        box.setUseWhiskerColor(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "color"));
        box.setUseWhiskerPattern(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "pattern") || box.isFillOn());
        box.setUseWhiskerSize(StatGraph.isBundleAttributeFixed(elem, "whiskerAttrs", "thickness"));
        box.setUseMedianColor(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "color"));
        box.setUseMedianPattern(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "pattern") || box.isFillOn());
        box.setUseMedianSize(StatGraph.isBundleAttributeFixed(elem, "medianAttrs", "thickness"));
        box.setUseMeanSymbol(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "symbol"));
        box.setUseMeanColor(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "color"));
        box.setUseMeanSize(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "size"));
        box.setUseMeanWeight(StatGraph.isBundleAttributeFixed(elem, "meanAttrs", "weight", true));
        box.setUseMeanTransparency(StatGraph.isTransparencyFixed(elem, "MeanAttrs"));
        box.setUseOutlierSymbol(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "symbol"));
        box.setUseOutlierColor(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "color"));
        box.setUseOutlierSize(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "size"));
        box.setUseOutlierWeight(StatGraph.isBundleAttributeFixed(elem, "outlierAttrs", "weight", true));
        box.setUseOutlierTransparency(StatGraph.isTransparencyFixed(elem, "OutlierAttrs"));
        box.setUseFillColor(StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color"));
        box.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        box.setUseFillPatternColor(StatGraph.isBundleAttributeFixed(elem, "fillPatternAttrs", "color"));
        box.setUseFillPattern(StatGraph.isBundleAttributeFixed(elem, "fillPatternAttrs", "pattern"));
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs") && labelsOn) {
                StatGraph.parseTextAttrs(graph, (Element)node, box.getLabelStyle());
                continue;
            }
            if (elemTag.equals("OutlineAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, box.getOutlineStyle());
                continue;
            }
            if (elemTag.equals("ConnectAttrs") && box.isConnectOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, box.getLineStyle());
                continue;
            }
            if (elemTag.equals("WhiskerAttrs") && box.isWhiskersOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, box.getWhiskerStyle());
                continue;
            }
            if (elemTag.equals("MedianAttrs") && box.isMedianOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, box.getMedianStyle());
                continue;
            }
            if (elemTag.equals("MeanAttrs") && box.isMeanOn()) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, meanStyle);
                box.setMeanColor(meanStyle.getColor());
                if (((Element)node).hasAttribute("symbol")) {
                    box.setMeanSymbol(meanStyle.getShape());
                }
                if (((Element)node).hasAttribute("size")) {
                    box.setMeanSize(meanStyle.getSize());
                }
                if (((Element)node).hasAttribute("weight")) {
                    box.setMeanWeight(meanStyle.getWeight());
                }
                if (!((Element)node).hasAttribute("transparency")) continue;
                box.setMeanTransparency(meanStyle.getTransparency());
                continue;
            }
            if (elemTag.equals("OutlierAttrs") && box.isMarkersOn() && !extreme) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, outlierStyle);
                box.setMarkerColor(outlierStyle.getColor());
                if (((Element)node).hasAttribute("symbol")) {
                    box.setMarkerSymbol(outlierStyle.getShape());
                }
                if (((Element)node).hasAttribute("size")) {
                    box.setMarkerSize(outlierStyle.getSize());
                }
                if (((Element)node).hasAttribute("weight")) {
                    box.setMarkerWeight(outlierStyle.getWeight());
                }
                if (!((Element)node).hasAttribute("transparency")) continue;
                box.setMarkerTransparency(outlierStyle.getTransparency());
                continue;
            }
            if (elemTag.equals("FillAttrs") && box.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, fillStyle);
                continue;
            }
            if (!elemTag.equals("FillPatternAttrs") || !box.isFillPatternOn()) continue;
            StatGraph.parseFillPatternAttrs(graph, (Element)node, box.getFillPatternStyle());
        }
        if (box.isCapOn()) {
            box.getCapStyle().setColor(box.getWhiskerStyle().getColor());
            box.getCapStyle().setWidth(box.getWhiskerStyle().getWidth());
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0) {
            String dStat = elem.getAttribute("displayStats");
            if (dStat.length() > 0 && !dStat.equalsIgnoreCase("none")) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)str));
            } else if (StatGraph.isNumber(str)) {
                double offset = Double.parseDouble(str);
                if (offset >= -0.5 && offset <= 0.5) {
                    box.setDiscreteOffset(offset);
                } else {
                    StatGraph.printOptionError("DISCRETEOFFSET", str);
                }
            } else if (str.length() > 0) {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        }
        if ((str = elem.getAttribute("displayStats")).length() > 0 && !str.equalsIgnoreCase("none")) {
            boolean haveStats = true;
            if (!gVarID.equals("")) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "statgroup.txt"));
                haveStats = false;
            }
            if (haveStats) {
                Object[] xValues;
                String[] opts = str.equalsIgnoreCase("all") ? new String[]{"SumWGT", "N", "DataMin", "Min", "Q1", "Median", "Q3", "Max", "DataMax", "Mean", "STD", "Range", "IQR"} : (str.equalsIgnoreCase("standard") ? new String[]{"N", "mean", "STD"} : StatGraph.parseList2String(str));
                DataModel model = new DataModel();
                if (box.isContinuousBox()) {
                    xValues = box.getDoubleXValues();
                    ContinuousRange cr = box.getDoubleXValueRange();
                    model.addDoubleColumn("X", "X", null, cr.getMin(), cr.getMax(), 0, (double[])xValues);
                } else {
                    xValues = box.getXValues();
                    model.addStringColumn("X", "X", null, xValues.length, 0, (String[])xValues);
                }
                ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(ycol);
                String fmt = NumericFormat.isNamedFormat((SASFormat)cmd.getFormat()) ? cmd.getFormat().getName() : DataModel.defaultFormat.getName();
                int num = 0;
                for (int i2 = 0; i2 < opts.length; ++i2) {
                    String[] sValues;
                    if (!BoxParser.isValidStatistic(opts[i2])) continue;
                    if (opts[i2].equalsIgnoreCase("N")) {
                        sValues = box.getNumberOfObservations();
                        model.addStringColumn(opts[i2], BoxParser.getNLSName(opts[i2]), null, sValues.length, 0, sValues);
                    } else {
                        sValues = (String[])box.getStatistics(opts[i2]);
                        model.addDoubleColumn(opts[i2], BoxParser.getNLSName(opts[i2]), fmt, -1.0, -1.0, 0, (double[])sValues);
                    }
                    ++num;
                }
                if (num >= 1) {
                    TextAttrs valueAttrs = new TextAttrs();
                    GraphStyle.setDefaultTextStyle(graph, "", valueAttrs, "DataText");
                    TextAttrs labelAttrs = new TextAttrs();
                    GraphStyle.setDefaultTextStyle(graph, "", labelAttrs, "ValueText");
                    HashMap widthMap = null;
                    if (box.getOrientation() == 1) {
                        widthMap = BoxParser.getStatValueWidth(m, yVarID, sVarID, SASFormat.getInstance((String)fmt), valueAttrs, opts);
                    }
                    Overlay[] imOverlays = new AxisTable[num];
                    num = 0;
                    for (int i3 = opts.length - 1; i3 >= 0; --i3) {
                        if (!BoxParser.isValidStatistic(opts[i3])) continue;
                        imOverlays[num] = new AxisTable();
                        if (box.getOrientation() == 1) {
                            ((AxisTable)imOverlays[num]).setAxis(3);
                            imOverlays[num].setDiscreteY(!box.isContinuousBox());
                        } else {
                            imOverlays[num].setDiscreteX(!box.isContinuousBox());
                        }
                        RoleColumnMap map2 = new RoleColumnMap();
                        int xcol = model.getColumn("X");
                        map2.map(114, xcol);
                        imOverlays[num].addRole("X", model.getColumnLabel(xcol));
                        int lcol = model.getColumn(opts[i3]);
                        map2.map(115, lcol);
                        imOverlays[num].addRole("COLUMN", model.getColumnLabel(lcol));
                        CRD crd2 = new CRD();
                        crd2.setSrcModel(model);
                        crd2.setSrcMap(map2);
                        ((AxisTable)imOverlays[num]).setModel(crd2);
                        ((AxisTable)imOverlays[num]).setValueAttrs(valueAttrs);
                        ((AxisTable)imOverlays[num]).setLabelAttrs(labelAttrs);
                        if (box.getOrientation() == 1) {
                            ((AxisTable)imOverlays[num]).setUserValueTextWidth((Integer)widthMap.get(opts[i3]));
                            imOverlays[num].setOverlayJustification(3);
                            ((AxisTable)imOverlays[num]).setValueJustify(AxisTable.ALIGN_H_RIGHT);
                            ((AxisTable)imOverlays[num]).setLabelJustify(AxisTable.ALIGN_H_RIGHT);
                            imOverlays[num].setYAxis(box.getYAxis());
                            if (box.getXAxis().equalsIgnoreCase("X2")) {
                                ((AxisTable)imOverlays[num]).setLabelPosition(2);
                            }
                        } else {
                            imOverlays[num].setOverlayJustification(2);
                            imOverlays[num].setXAxis(box.getXAxis());
                            if (box.getYAxis().equalsIgnoreCase("Y2")) {
                                ((AxisTable)imOverlays[num]).setLabelPosition(2);
                            }
                        }
                        ++num;
                    }
                    box.setBlockOverlays(imOverlays);
                }
            }
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)box, (byte)4, box.getFillStyle().getTransparency());
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, box, (byte)15);
        }
        int contrastColorCnt = graph.style.getContrastColorCount();
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, box, (byte)17);
            ColorEncoder lcEncoder = box.getLineColorEncoder();
            DiscreteRange dr = (DiscreteRange)lcEncoder.getInput();
            HashMap lcTable = lcEncoder.colorList;
            HashMap scTable = new HashMap();
            HashMap sc2Table = new HashMap();
            for (Object key : lcTable.keySet()) {
                Color c = (Color)lcTable.get(key);
                scTable.put(key, box.applyDataTransparency(c, box.getMeanTransparency()));
                sc2Table.put(key, box.applyDataTransparency(c, box.getMarkerTransparency()));
            }
            ColorEncoder scEncoder = new ColorEncoder(dr, scTable);
            scEncoder.colorArray = lcEncoder.colorArray;
            box.setEncoder((byte)16, scEncoder);
            ColorEncoder s2cEncoder = new ColorEncoder(dr, sc2Table);
            s2cEncoder.colorArray = lcEncoder.colorArray;
            box.setEncoder((byte)23, s2cEncoder);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, box, (byte)6);
        }
        graph.style.setContrastColorCount(contrastColorCnt);
        if (crd.isAvailable(112)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, box, (byte)22);
        }
        if (crd.isAvailable(111)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, box, (byte)21);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    private static HashMap getStatValueWidth(DataModel model, String yCol, String statCol, SASFormat fmt, TextAttrs valueAttrs, String[] opts) {
        FontMetrics fm = StatGraph.getFontMetrics(valueAttrs.getFont());
        int index = model.getColumn(statCol);
        String[] stats = model.getStringAsClassColumn(index, true);
        index = model.getColumn(yCol);
        double[] values = model.getDoubleColumn(index);
        int[] width = new int[opts.length];
        for (int i = 0; i < width.length; ++i) {
            width[i] = 0;
        }
        int minW = 0;
        int maxW = 0;
        int q1W = 0;
        int q3W = 0;
        block1: for (int i = 0; i < values.length; ++i) {
            String s = stats[i];
            String v = s.equalsIgnoreCase("N") ? (Double.isNaN(values[i]) ? "." : Integer.toString((int)values[i])) : fmt.format((Object)values[i]).trim();
            if (v.equals(".")) {
                v = StatGraph.missingOption;
            }
            for (int j = 0; j < opts.length; ++j) {
                if (opts[j].equalsIgnoreCase(s)) {
                    width[j] = Math.max(width[j], fm.stringWidth(v));
                    continue block1;
                }
                if (opts[j].equalsIgnoreCase("Range")) {
                    if (s.equalsIgnoreCase("MIN")) {
                        minW = Math.max(minW, fm.stringWidth(v));
                        continue block1;
                    }
                    if (!s.equalsIgnoreCase("MAX")) continue;
                    maxW = Math.max(maxW, fm.stringWidth(v));
                    continue block1;
                }
                if (!opts[j].equalsIgnoreCase("IQR")) continue;
                if (s.equalsIgnoreCase("Q1")) {
                    q1W = Math.max(q1W, fm.stringWidth(v));
                    continue block1;
                }
                if (!s.equalsIgnoreCase("Q3")) continue;
                q3W = Math.max(q3W, fm.stringWidth(v));
                continue block1;
            }
        }
        HashMap<String, Integer> widthMap = new HashMap<String, Integer>();
        for (int i = 0; i < opts.length; ++i) {
            if (opts[i].equalsIgnoreCase("Range")) {
                widthMap.put(opts[i], Math.max(minW, maxW));
                continue;
            }
            if (opts[i].equalsIgnoreCase("IQR")) {
                widthMap.put(opts[i], Math.max(q1W, q3W));
                continue;
            }
            widthMap.put(opts[i], width[i]);
        }
        return widthMap;
    }

    private static void setDisplayAll(BoxOverlay box, boolean on) {
        box.setCapOn(on);
        box.setConnectOn(on);
        box.setMedianOn(on);
        box.setMeanOn(on);
        box.setMarkersOn(on);
        box.setFillOn(on);
        box.setNotched(on);
        box.setFillPatternOn(on);
    }

    private static boolean isBoxOn(BoxOverlay box) {
        return box.isCapOn() || box.isConnectOn() || box.isMedianOn() || box.isMeanOn() || box.isMarkersOn() || box.isFillOn() || box.isNotched();
    }

    private static boolean isValidStatistic(String statname) {
        return statname.equalsIgnoreCase("MIN") || statname.equalsIgnoreCase("Q1") || statname.equalsIgnoreCase("MEDIAN") || statname.equalsIgnoreCase("Q3") || statname.equalsIgnoreCase("MAX") || statname.equalsIgnoreCase("MEAN") || statname.equalsIgnoreCase("N") || statname.equalsIgnoreCase("STD") || statname.equalsIgnoreCase("RANGE") || statname.equalsIgnoreCase("IQR") || statname.equalsIgnoreCase("SUMWGT") || statname.equalsIgnoreCase("DATAMIN") || statname.equalsIgnoreCase("DATAMAX");
    }

    private static String getNLSName(String name) {
        String NLS = name;
        if (name.equalsIgnoreCase("MIN")) {
            NLS = RB.getStringResource(RB_KEY, "MIN.txt");
        } else if (name.equalsIgnoreCase("Q1")) {
            NLS = RB.getStringResource(RB_KEY, "Q1.txt");
        } else if (name.equalsIgnoreCase("MEDIAN")) {
            NLS = RB.getStringResource(RB_KEY, "MEDIAN.txt");
        } else if (name.equalsIgnoreCase("Q3")) {
            NLS = RB.getStringResource(RB_KEY, "Q3.txt");
        } else if (name.equalsIgnoreCase("MAX")) {
            NLS = RB.getStringResource(RB_KEY, "MAX.txt");
        } else if (name.equalsIgnoreCase("MEAN")) {
            NLS = RB.getStringResource(RB_KEY, "MEAN.txt");
        } else if (name.equalsIgnoreCase("N")) {
            NLS = RB.getStringResource(RB_KEY, "N.txt");
        } else if (name.equalsIgnoreCase("STD")) {
            NLS = RB.getStringResource(RB_KEY, "STD.txt");
        } else if (name.equalsIgnoreCase("RANGE")) {
            NLS = RB.getStringResource(RB_KEY, "RANGE.txt");
        } else if (name.equalsIgnoreCase("IQR")) {
            NLS = RB.getStringResource(RB_KEY, "IQR.txt");
        } else if (name.equalsIgnoreCase("SUMWGT")) {
            NLS = RB.getStringResource(RB_KEY, "SUMWGT.txt");
        } else if (name.equalsIgnoreCase("DATAMIN")) {
            NLS = RB.getStringResource(RB_KEY, "DATAMIN.txt");
        } else if (name.equalsIgnoreCase("DATAMAX")) {
            NLS = RB.getStringResource(RB_KEY, "DATAMAX.txt");
        }
        return NLS;
    }

    private static String buildWhereExpression(StringVectorVariable whereVar, int mpc, int page, StatGraph graph) {
        int n = whereVar.getUniqueValueCount();
        if (mpc >= n) {
            return null;
        }
        int maxPages = (int)Math.ceil((double)n / (double)mpc);
        if (page >= maxPages) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "page2.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
            page = maxPages - 1;
        }
        graph.pageNo = page;
        StringBuffer where = new StringBuffer();
        int s = mpc * page;
        int e = Math.min(s + mpc, n);
        String v = "";
        for (int i = s; i < e; ++i) {
            try {
                v = whereVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException mve) {
                continue;
            }
            if (where.length() > 0) {
                where = where.append(" OR ");
            }
            where = where.append(whereVar.getColumnName() + " = \"" + v + "\"");
        }
        return where.toString();
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        String yVarID;
        int ycol;
        int[] types = new int[3];
        String str = elem.getAttribute("y");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        if (!StatGraph.checkVariable("Y", model.getColumnLabel(ycol = model.getColumn(yVarID = StatGraph.getVarID(str))), Double.class, 2, true)) {
            return null;
        }
        str = elem.getAttribute("x");
        String xVarID = StatGraph.getVarID(str);
        if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[2] = 0;
        return types;
    }

    private static boolean isStat(String name) {
        return name.equalsIgnoreCase("MIN") || name.equalsIgnoreCase("Q1") || name.equalsIgnoreCase("MEDIAN") || name.equalsIgnoreCase("MEAN") || name.equalsIgnoreCase("Q3") || name.equalsIgnoreCase("MAX") || name.equalsIgnoreCase("STD") || name.equalsIgnoreCase("N") || name.equalsIgnoreCase("DATAMIN") || name.equalsIgnoreCase("DATAMAX") || name.equalsIgnoreCase("SUMWGT");
    }

    private static boolean isOtherStat(String name) {
        return name.equalsIgnoreCase("OUTLIER") || name.equalsIgnoreCase("FAROUTLIER") || name.equalsIgnoreCase("BOXWIDTH");
    }

    private static void parseRoleTipStuff(Element elem, DataModel model, RoleColumnMap map, BoxOverlay overlay) {
        String tipVarID;
        ColumnMetadata cmd;
        HashMap<Integer, String> roleMap;
        String[] tipRoles;
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement(elem, "Roles");
        if (roleElem != null) {
            LayoutOverlayParser.parseRoleNames(roleElem, model, overlay);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement(elem, "TipFormats")) != null) {
            String elemTag = "";
            HashMap<String, String> formatMap = null;
            for (Node node = formatElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String format = child.getNodeValue();
                if (BoxParser.isStat(role.toUpperCase())) {
                    if (formatMap == null) {
                        formatMap = new HashMap<String, String>();
                    }
                    formatMap.put(role.toUpperCase(), format);
                    continue;
                }
                ColumnMetadata cmd2 = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd2 == null) continue;
                cmd2.setFormat(format);
            }
            overlay.setStatTipFormat(formatMap);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement(elem, "TipLabels")) != null) {
            String elemTag = "";
            HashMap<String, String> labelMap = null;
            for (Node node = labelElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String label = child.getNodeValue();
                if (BoxParser.isStat(role.toUpperCase())) {
                    if (labelMap == null) {
                        labelMap = new HashMap<String, String>();
                    }
                    labelMap.put(role.toUpperCase(), label);
                    continue;
                }
                ColumnMetadata cmd3 = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd3 == null) continue;
                cmd3.setLabel(label);
            }
            overlay.setStatTipLabel(labelMap);
        }
        overlay.clearStatTips();
        String str = elem.getAttribute("tip");
        if (str.length() > 0) {
            tipRoles = StatGraph.parseList2String(str);
            overlay.setCustomTips(true);
            int cnt = 0;
            roleMap = new HashMap<Integer, String>();
            for (int i = 0; i < tipRoles.length; ++i) {
                if (BoxParser.isStat(tipRoles[i].toUpperCase())) {
                    overlay.addStatTip(tipRoles[i].toUpperCase());
                    continue;
                }
                if (BoxParser.isOtherStat(tipRoles[i].toUpperCase())) {
                    tipRoles[i] = null;
                    continue;
                }
                cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(300 + cnt), tipRoles[i].toUpperCase());
                tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(300 + cnt++, tipcol);
            }
            overlay.setCustomTipList(tipRoles);
            overlay.setTipRoleMap(roleMap);
        }
        if ((str = elem.getAttribute("outlierTip")).length() > 0) {
            tipRoles = StatGraph.parseList2String(str);
            overlay.setCustomOutlierTips(true);
            int cnt = 0;
            roleMap = new HashMap();
            for (int i = 0; i < tipRoles.length; ++i) {
                cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(350 + cnt), tipRoles[i].toUpperCase());
                tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(350 + cnt++, tipcol);
            }
            overlay.setOutlierTipRoleMap(roleMap);
        }
    }
}

