/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class BarParser {
    public static final String RB_KEY = "BarParser.";

    public static BarOverlay load(StatGraph graph, Element elem) {
        BarOverlay bar = (BarOverlay)graph.getObjectFromElement(elem);
        if (bar == null) {
            bar = new BarOverlay();
        }
        return BarParser.load(graph, bar, elem) ? bar : null;
    }

    public static boolean load(StatGraph graph, BarOverlay bar, Element elem) {
        Color c;
        int i;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, bar);
        String str = elem.getAttribute("primary");
        bar.setPrimary(str.equalsIgnoreCase("true"));
        if (BarParser.isUnderDataMatrix(elem)) {
            bar.setWeightedByCategories(true);
        }
        str = elem.getAttribute("category");
        String categoryRoleName = "CATEGORY";
        if (str.length() == 0) {
            str = elem.getAttribute("x");
            categoryRoleName = "X";
        }
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        DataModel m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        }
        RoleColumnMap map = new RoleColumnMap();
        if (StatGraph.isOLAP()) {
            map.map(1, xVarID);
        } else {
            int xcol = m.getColumn(xVarID);
            if (!StatGraph.checkVariable(categoryRoleName, m.getColumnLabel(xcol), null, 1, true)) {
                graph.removeNamedGraph(bar);
                return false;
            }
            map.map(1, xcol);
            bar.addRole(categoryRoleName, m.getColumnLabel(xcol));
        }
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                bar.setEdgeOn(true);
                bar.setFillOn(true);
                bar.setFillPatternOn(true);
                bar.setConnectOn(true);
            } else {
                bar.setEdgeOn(false);
                bar.setFillOn(false);
                bar.setFillPatternOn(false);
                bar.setConnectOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        bar.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        bar.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        bar.setFillPatternOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("connect")) {
                        bar.setConnectOn(true);
                        continue;
                    }
                    bar.setEdgeOn(true);
                    bar.setFillOn(true);
                    bar.setFillPatternOn(false);
                    bar.setConnectOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Bar", "displayOpts");
            if (str != null) {
                bar.setEdgeOn(false);
                bar.setFillOn(false);
                bar.setFillPatternOn(false);
                bar.setConnectOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        bar.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        bar.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        bar.setFillPatternOn(true);
                        continue;
                    }
                    if (!opts[i].equalsIgnoreCase("connect")) continue;
                    bar.setConnectOn(true);
                }
                if (!bar.isEdgeOn() && !bar.isFillOn()) {
                    bar.setEdgeOn(true);
                    bar.setFillOn(true);
                }
            } else {
                bar.setEdgeOn(true);
                bar.setFillOn(true);
            }
        }
        boolean validResponse = true;
        boolean gotGroup = false;
        boolean gradientColor = false;
        String yVarID = "";
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null || StatGraph.parseStringValueList(rElem, "Value").length == 1) {
            String indexVarID;
            int ii;
            int crcol;
            str = elem.getAttribute("response");
            String responseRoleName = "RESPONSE";
            if (str.length() == 0) {
                if (rElem == null) {
                    str = elem.getAttribute("y");
                    responseRoleName = "Y";
                } else {
                    str = StatGraph.parseStringValueList(rElem, "Value")[0];
                }
            }
            if ((yVarID = StatGraph.getVarID(str)).length() > 0) {
                if (StatGraph.isOLAP()) {
                    map.map(2, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable(responseRoleName, m.getColumnLabel(ycol), Double.class, 1, true)) {
                        if (((ColumnMetadata)m.getColumnLabel(ycol)).getType() == 1) {
                            validResponse = false;
                        } else {
                            graph.removeNamedGraph(bar);
                            return false;
                        }
                    }
                    map.map(2, ycol);
                    bar.addRole(responseRoleName, m.getColumnLabel(ycol));
                }
            }
            if ((str = elem.getAttribute("categoryOrderRole")).length() > 0 && (str.equalsIgnoreCase("RESPONSE") || str.equalsIgnoreCase("Y")) && yVarID.length() > 0 && validResponse) {
                int scol = m.getColumn(yVarID);
                map.map(99, scol);
                bar.addRole("CATEGORYORDER", m.getColumnLabel(scol));
            }
            boolean colorResponse = false;
            str = elem.getAttribute("colorResponse");
            String crVarID = StatGraph.getVarID(str);
            if (crVarID.length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
                colorResponse = true;
                if (bar.isFillOn()) {
                    map.map(6, crcol);
                } else {
                    map.map(46, crcol);
                }
                bar.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
                str = elem.getAttribute("colorResponseAttrVar");
                if (str.length() > 0) {
                    bar.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
                }
            }
            str = elem.getAttribute("colorByFreq");
            boolean colorByFreq = str.equalsIgnoreCase("true");
            bar.setColorStatistic(-1);
            if (colorResponse || colorByFreq) {
                str = elem.getAttribute("colorStat");
                if (str.length() > 0) {
                    if (str.equalsIgnoreCase("SUM")) {
                        if (colorResponse) {
                            bar.setColorStatistic(6);
                        } else {
                            StatGraph.printOptionError("COLORSTAT", str);
                            bar.setColorStatistic(2);
                        }
                    } else if (str.equalsIgnoreCase("MEAN")) {
                        if (colorResponse) {
                            bar.setColorStatistic(1);
                        } else {
                            StatGraph.printOptionError("COLORSTAT", str);
                            bar.setColorStatistic(2);
                        }
                    } else if (str.equalsIgnoreCase("FREQ")) {
                        if (colorResponse) {
                            StatGraph.printOptionError("COLORSTAT", str);
                            bar.setColorStatistic(6);
                        } else {
                            bar.setColorStatistic(2);
                        }
                    } else if (str.equalsIgnoreCase("PCT")) {
                        if (colorResponse) {
                            StatGraph.printOptionError("COLORSTAT", str);
                            bar.setColorStatistic(6);
                        } else {
                            bar.setColorStatistic(13);
                        }
                    } else if (str.equalsIgnoreCase("PROPORTION")) {
                        if (colorResponse) {
                            StatGraph.printOptionError("COLORSTAT", str);
                            bar.setColorStatistic(6);
                        } else {
                            bar.setColorStatistic(3);
                        }
                    } else {
                        bar.setColorStatistic(colorResponse ? 6 : 2);
                        StatGraph.printOptionError("COLORSTAT", str);
                    }
                } else if (elem.getAttribute("_stmt").equalsIgnoreCase("BarChart")) {
                    bar.setColorStatistic(colorResponse ? 6 : 2);
                }
            }
            gradientColor = bar.getColorStatistic() != -1 || colorResponse;
            bar.setGradientColor(gradientColor);
            str = elem.getAttribute("group");
            if (str.length() > 0) {
                String gVarID = StatGraph.getVarID(str);
                if (StatGraph.isOLAP()) {
                    gotGroup = true;
                    map.map(3, gVarID);
                    map.map(36, gVarID);
                    if (!gradientColor) {
                        map.map(6, gVarID);
                        map.map(46, gVarID);
                    }
                    map.map(111, gVarID);
                    map.map(112, gVarID);
                } else if (!LayoutOverlayParser.hasTooManyGroups(graph, m, StatGraph.getVarID(str), bar.getStmt())) {
                    gotGroup = true;
                    int gcol = m.getColumn(gVarID);
                    map.map(3, gcol);
                    map.map(36, gcol);
                    if (!gradientColor) {
                        map.map(6, gcol);
                        map.map(46, gcol);
                    }
                    map.map(111, gcol);
                    map.map(112, gcol);
                    bar.addRole("GROUP", m.getColumnLabel(gcol));
                    str = elem.getAttribute("includeMissingGroup");
                    if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                        bar.setMissingGroupOn(false);
                    }
                    if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                        bar.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    } else {
                        String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : gVarID;
                        DAMDatasetParser.addInternalAttrVar(graph, bar, "GROUP", originalGroup);
                    }
                }
            }
            if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                map.map(44, ii);
                bar.addRole("INDEX", m.getColumnLabel(ii));
            }
        } else {
            String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
            int cnt = 0;
            for (int i2 = 0; i2 < multiResponseVars.length; ++i2) {
                str = multiResponseVars[i2];
                yVarID = StatGraph.getVarID(str);
                if (yVarID.length() <= 0) continue;
                if (StatGraph.isOLAP()) {
                    map.map(610 + cnt, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 1, true)) continue;
                    map.map(610 + cnt, ycol);
                    bar.addRole("MULTI_RESPONSE" + cnt, m.getColumnLabel(ycol));
                }
                ++cnt;
            }
            if (cnt == 0) {
                graph.removeNamedGraph(bar);
                return false;
            }
            bar.setResponseCount(cnt);
        }
        str = elem.getAttribute("stat");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("SUM")) {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    bar.setStatistic(6);
                } else {
                    StatGraph.printOptionError("stat", str);
                    bar.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("MEAN")) {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    bar.setStatistic(1);
                } else {
                    StatGraph.printOptionError("stat", str);
                    bar.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("FREQ")) {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    bar.setStatistic(6);
                } else {
                    bar.setStatistic(2);
                }
            } else if (str.equalsIgnoreCase("PCT")) {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    bar.setStatistic(6);
                } else {
                    bar.setStatistic(13);
                }
            } else if (str.equalsIgnoreCase("PROPORTION")) {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    StatGraph.printOptionError("stat", str);
                    bar.setStatistic(6);
                } else {
                    bar.setStatistic(3);
                }
            } else {
                if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                    bar.setStatistic(6);
                } else {
                    bar.setStatistic(2);
                }
                StatGraph.printOptionError("STAT", str);
            }
        } else if (elem.getAttribute("_stmt").equalsIgnoreCase("BarChart")) {
            if (map.isRoleMapped(2) || bar.isMultiResponse()) {
                bar.setStatistic(6);
            } else {
                bar.setStatistic(2);
            }
        }
        StatGraph.parseURLOpt(elem, m, map, bar);
        str = elem.getAttribute("groupDisplay");
        if (str.equalsIgnoreCase("Cluster")) {
            bar.setGroupDisplay((byte)0);
        } else {
            bar.setGroupDisplay((byte)1);
        }
        if (gotGroup) {
            str = elem.getAttribute("group100");
            if (str.equalsIgnoreCase("positive")) {
                bar.setGroup100(true);
                bar.setPositiveGroupOnly(true);
            } else if (str.equalsIgnoreCase("magnitude")) {
                bar.setGroup100(true);
                bar.setPositiveGroupOnly(false);
            } else {
                bar.setGroup100(false);
                bar.setPositiveGroupOnly(false);
            }
        }
        boolean gotErrorBar = false;
        str = elem.getAttribute("errorUpper");
        String yeuVarID = StatGraph.getVarID(str);
        if (!bar.isMultiResponse() && yeuVarID.length() > 0) {
            if (!gotGroup || gotGroup && bar.getGroupDisplay() == 0 && !bar.isGroup100()) {
                int yucol = m.getColumn(yeuVarID);
                if (StatGraph.checkVariable("ERRORUPPER", m.getColumnLabel(yucol), Double.class, false)) {
                    map.map(28, yucol);
                    bar.addRole("ERRORUPPER", m.getColumnLabel(yucol));
                    gotErrorBar = true;
                }
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "errorbar.txt"));
            }
        }
        str = elem.getAttribute("errorLower");
        String yelVarID = StatGraph.getVarID(str);
        if (!bar.isMultiResponse() && yelVarID.length() > 0) {
            if (!gotGroup || gotGroup && bar.getGroupDisplay() == 0 && !bar.isGroup100()) {
                int ylcol = m.getColumn(yelVarID);
                if (StatGraph.checkVariable("ERRORLOWER", m.getColumnLabel(ylcol), Double.class, false)) {
                    map.map(29, ylcol);
                    bar.addRole("ERRORLOWER", m.getColumnLabel(ylcol));
                    gotErrorBar = true;
                }
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "errorbar.txt"));
            }
        }
        boolean gotTarget = false;
        str = elem.getAttribute("target");
        String targetVarID = StatGraph.getVarID(str);
        if (!bar.isMultiResponse() && targetVarID.length() > 0) {
            if (yVarID.length() > 0 && (!gotGroup || gotGroup && bar.getGroupDisplay() == 0 && !bar.isGroup100())) {
                int targetcol = m.getColumn(targetVarID);
                if (StatGraph.checkVariable("TARGET", m.getColumnLabel(targetcol), Double.class, false)) {
                    map.map(55, targetcol);
                    bar.addRole("TARGET", m.getColumnLabel(targetcol));
                    gotTarget = true;
                }
            } else {
                Message msg = new Message(RB.getStringResource(RB_KEY, "target.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
            }
        }
        if (!validResponse && !gotTarget) {
            graph.removeNamedGraph(bar);
            return false;
        }
        boolean dataLabelByColumn = true;
        str = elem.getAttribute("dataLabelType");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("auto")) {
                dataLabelByColumn = false;
                if (!gotErrorBar) {
                    bar.setShowBarValue(true);
                } else {
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "datalabel.txt"));
                }
            } else if (!str.equalsIgnoreCase("column")) {
                StatGraph.printOptionError("DATALABELTYPE", str);
            }
        }
        boolean gotDataLabel = false;
        if (dataLabelByColumn) {
            str = elem.getAttribute("dataLabel");
            String labelVarID = StatGraph.getVarID(str);
            if (!(gotGroup && bar.getGroupDisplay() != 0 || bar.isMultiResponse() || labelVarID.length() <= 0)) {
                if (!gotErrorBar) {
                    int lcol = m.getColumn(labelVarID);
                    map.map(5, lcol);
                    bar.addRole("DATALABEL", m.getColumnLabel(lcol));
                    gotDataLabel = true;
                } else {
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "datalabel.txt"));
                }
            } else if (labelVarID.length() > 0 && gotGroup && bar.getGroupDisplay() == 1) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "datalabel2.txt"));
            }
        } else {
            gotDataLabel = true;
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, bar);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, bar);
        str = elem.getAttribute("displayBaseline");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("on")) {
                bar.setBaselineOn(true);
            } else if (str.equalsIgnoreCase("off")) {
                bar.setBaselineOn(false);
            } else if (str.equalsIgnoreCase("auto")) {
                bar.setAutoBaseline(true);
            } else {
                bar.setBaselineOn(true);
                StatGraph.printOptionError("DISPLAYBASELINE", str);
            }
        }
        str = elem.getAttribute("baselineIntercept");
        if (bar.getGroupDisplay() == 0 && !bar.isGroup100() || !crd.isAvailable(3)) {
            if (str.length() > 0) {
                if (StatGraph.isNumber(str)) {
                    bar.setBaseline(Double.parseDouble(str));
                } else {
                    StatGraph.printOptionError("BASELINEINTERCEPT", str);
                }
            }
        } else if (str.length() > 0) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "baseline.txt"));
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("baselineAttrs"), bar.getBaselineStyle(), "AxisLines");
        str = elem.getAttribute("clusterWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            bar.setClusterWidth(width);
        }
        if (!gotGroup && !bar.isMultiResponse() || bar.getGroupDisplay() == 1) {
            bar.setClusterWidth(1.0);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("barWidth"))) {
            double width = Double.parseDouble(str);
            bar.setBarWidth(width);
        } else if (gotGroup && bar.getGroupDisplay() == 0) {
            bar.setBarWidth(1.0);
        }
        str = elem.getAttribute("orient");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Horizontal")) {
                bar.setOrientation((byte)1);
            } else if (str.equalsIgnoreCase("Vertical")) {
                bar.setOrientation((byte)0);
            } else {
                bar.setOrientation((byte)0);
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        if (bar.getOrientation() == 0) {
            if (bar.getXAxis().equalsIgnoreCase("x2")) {
                bar.setDiscreteCategory(LayoutOverlayParser.x2AxisType == 2);
            } else {
                bar.setDiscreteCategory(LayoutOverlayParser.xAxisType == 2);
            }
        } else if (bar.getYAxis().equalsIgnoreCase("y2")) {
            bar.setDiscreteCategory(LayoutOverlayParser.y2AxisType == 2);
        } else {
            bar.setDiscreteCategory(LayoutOverlayParser.yAxisType == 2);
        }
        if (crd.getColumnClass(1) != Double.class) {
            bar.setDiscreteCategory(true);
        }
        if (!bar.isDiscreteCategory()) {
            str = elem.getAttribute("intervalBarWidth");
            if (StatGraph.isNumber(str)) {
                bar.setIntervalBarWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("bin")).equalsIgnoreCase("true")) {
                bar.setBinCategory(true);
                bar.setIntervalBarWidth(-1.0);
                bar.setBarWidth(1.0);
                bar.setClusterWidth(1.0);
                bar.setGroupDisplay((byte)1);
                Element binOptsElem = StatGraph.getOptionAttrsElement(elem, "BinOpts");
                if (binOptsElem != null) {
                    double nbh;
                    double nb;
                    double bw;
                    double bs;
                    double catMax = crd.getColumnMax((short)1);
                    str = binOptsElem.getAttribute("start");
                    if (StatGraph.isNumber(str) && (bs = Double.parseDouble(str)) < catMax) {
                        bar.setBinStart(bs);
                    }
                    if (StatGraph.isNumber(str = binOptsElem.getAttribute("width")) && (bw = Double.parseDouble(str)) > 0.0) {
                        bar.setBinWidth(bw);
                    }
                    if (StatGraph.isNumber(str = binOptsElem.getAttribute("n")) && (nb = Double.parseDouble(str)) >= 1.0) {
                        bar.setNBins(nb);
                    }
                    if (StatGraph.isNumber(str = binOptsElem.getAttribute("nHint")) && (nbh = Double.parseDouble(str)) >= 1.0) {
                        bar.setNBinsHint((int)nbh);
                    }
                }
            }
        }
        if ((str = elem.getAttribute("skin")).length() > 0) {
            if (str.equalsIgnoreCase("modern")) {
                bar.setSkinType(1);
            } else if (str.equalsIgnoreCase("satin")) {
                bar.setSkinType(2);
            } else if (!str.equalsIgnoreCase("none")) {
                StatGraph.printOptionError("SKIN", str);
            }
        }
        StatGraph.parseDataSkinOpt(graph, elem, bar);
        if (bar.isFillOn()) {
            str = elem.getAttribute("fillType");
            if (str.equalsIgnoreCase("gradient") || str.equalsIgnoreCase("colorGradient")) {
                bar.setFillType(BarOverlay.FILL_GRADIENT);
                if (bar.getSkinType() == 4) {
                    bar.setSkinType(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "gradientskin.txt"));
                }
            } else if (str.equalsIgnoreCase("alphagradient")) {
                bar.setFillType(BarOverlay.FILL_ALPHAGRADIENT);
                if (bar.getSkinType() == 4) {
                    bar.setSkinType(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "gradientskin.txt"));
                }
            } else if (str.length() > 0 && !str.equalsIgnoreCase("solid")) {
                StatGraph.printOptionError("FILLTYPE", str);
            }
        }
        if (elem.hasAttribute("fillEndColor") && (c = StatGraph.parseAttrColor("fillEndColor", graph, elem)) != null) {
            bar.setGradientEndColor(c);
        }
        if ((str = elem.getAttribute("order")).equalsIgnoreCase("XAscending")) {
            bar.setOrder(4);
        } else if (str.equalsIgnoreCase("XDescending")) {
            bar.setOrder(5);
        }
        if (str.equalsIgnoreCase("YAscending")) {
            bar.setOrder(6);
        } else if (str.equalsIgnoreCase("YDescending")) {
            bar.setOrder(7);
        }
        str = elem.getAttribute("groupOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Ascending")) {
                bar.setGroupOrder(1);
            } else if (str.equalsIgnoreCase("Descending")) {
                bar.setGroupOrder(2);
            } else if (str.equalsIgnoreCase("Data")) {
                bar.setGroupOrder(0);
            } else if (str.equalsIgnoreCase("ReverseData")) {
                bar.setGroupOrder(3);
            } else {
                bar.setGroupOrder(0);
                StatGraph.printOptionError("GROUPORDER", str);
            }
        } else if (graph.isCASData()) {
            bar.setGroupOrder(1);
        }
        bar.setModel(crd);
        if (!gotDataLabel) {
            str = elem.getAttribute("barLabel");
            if (str.length() > 0 && str.equalsIgnoreCase("true")) {
                if (!gotErrorBar) {
                    bar.setShowBarValue(true);
                } else {
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "barlabel.txt"));
                }
            }
            if ((str = elem.getAttribute("barLabelFitPolicy")).length() > 0 && str.equalsIgnoreCase("none")) {
                bar.setAutoRotateLabel(false);
                bar.setRotateLabelAsNeeded(false);
            } else if (str.length() > 0 && str.equalsIgnoreCase("rotate") && bar.getOrientation() == 0) {
                bar.setRotateLabelAsNeeded(true);
                bar.setAutoRotateLabel(false);
            } else if (str.length() > 0 && str.equalsIgnoreCase("insidePreferred")) {
                bar.setLabelInsidePreferred(true);
                bar.setAutoRotateLabel(true);
            } else {
                bar.setAutoRotateLabel(true);
                bar.setRotateLabelAsNeeded(false);
            }
        } else {
            str = elem.getAttribute("dataLabelFitPolicy");
            if (dataLabelByColumn) {
                if (str.length() > 0) {
                    if (str.equalsIgnoreCase("none")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_NONE);
                    } else if (str.equalsIgnoreCase("auto")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_AUTO);
                    } else if (str.equalsIgnoreCase("split")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_SPLIT);
                    } else if (str.equalsIgnoreCase("splitalways")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_SPLITALWAYS);
                    } else if (str.equalsIgnoreCase("rotate")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_ROTATE);
                    } else if (str.equalsIgnoreCase("insidePreferred")) {
                        bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_INSIDEPREFERRED);
                    } else {
                        StatGraph.printOptionError("DATALABELFITPOLICY", str);
                    }
                } else {
                    bar.setDataLabelFitPolicy(BarOverlay.DATALABEL_FIT_AUTO);
                }
                ScatterParser.parseDataLabelSplitting(bar, elem);
            } else if (str.length() > 0) {
                if (str.equalsIgnoreCase("split") || str.equalsIgnoreCase("splitalways")) {
                    bar.setAutoRotateLabel(true);
                    bar.setRotateLabelAsNeeded(false);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "datalabelfitpolicy.txt"));
                } else if (str.equalsIgnoreCase("none")) {
                    bar.setAutoRotateLabel(false);
                    bar.setRotateLabelAsNeeded(false);
                } else if (str.equalsIgnoreCase("auto")) {
                    bar.setAutoRotateLabel(true);
                    bar.setRotateLabelAsNeeded(false);
                } else if (str.equalsIgnoreCase("rotate")) {
                    if (bar.getOrientation() == 0) {
                        bar.setRotateLabelAsNeeded(true);
                        bar.setAutoRotateLabel(false);
                    } else {
                        bar.setAutoRotateLabel(true);
                        bar.setRotateLabelAsNeeded(false);
                    }
                } else if (str.equalsIgnoreCase("insidePreferred")) {
                    bar.setLabelInsidePreferred(true);
                    bar.setAutoRotateLabel(true);
                } else {
                    StatGraph.printOptionError("DATALABELFITPOLICY", str);
                }
            } else {
                bar.setAutoRotateLabel(true);
                bar.setRotateLabelAsNeeded(false);
            }
        }
        str = elem.getAttribute("segmentLabel");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            bar.setShowSegmentLabel(true);
        }
        if ((str = elem.getAttribute("segmentLabelType")).length() > 0) {
            if (str.equalsIgnoreCase("auto")) {
                bar.setShowSegmentLabel(true);
            } else if (str.equalsIgnoreCase("none")) {
                bar.setShowSegmentLabel(false);
            } else {
                StatGraph.printOptionError("SEGMENTLABELTYPE", str);
            }
        }
        if (bar.isShowSegmentLabel()) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("segmentLabelAttrs"), bar.getSegmentLabelStyle(), "DataText");
            str = elem.getAttribute("segmentLabelFitPolicy");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("none")) {
                    bar.setSegmentLabelFitPolicy(BarOverlay.SEGMENTLABEL_FIT_NONE);
                } else if (str.equalsIgnoreCase("thin")) {
                    bar.setSegmentLabelFitPolicy(BarOverlay.SEGMENTLABEL_FIT_THIN);
                } else if (str.equalsIgnoreCase("noclip")) {
                    bar.setSegmentLabelFitPolicy(BarOverlay.SEGMENTLABEL_FIT_NOCLIP);
                } else {
                    StatGraph.printOptionError("SEGMENTLABELFITPOLICY", str);
                }
            }
            if ((str = elem.getAttribute("segmentLabelFormat")).length() > 0) {
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"SEGMENTLABELFORMAT", (Object)str));
                } else if (fmt.isCharacterFormat()) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "formattype.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"SEGMENTLABELFORMAT", (Object)str));
                } else {
                    bar.setSegmentLabelFormat(fmt);
                }
            }
        }
        boolean gotColor = elem.hasAttribute("fillAttrs");
        FillAttrs fillStyle = null;
        String contextName = graph.style.getContextName();
        bar.setContextName(contextName);
        if (bar.isFillOn()) {
            fillStyle = bar.getFillStyle();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
        }
        boolean gotFillPattern = elem.hasAttribute("fillPatternAttrs");
        boolean gotFillPatternColor = elem.hasAttribute("fillPatternAttrs");
        if (bar.isFillPatternOn()) {
            GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), bar.getFillPatternStyle(), contextName);
        }
        GraphStyle.setDefaultLineStyle(graph, null, bar.getReferenceStyle(), "AxisLines");
        boolean gotLine = elem.hasAttribute("outlineAttrs");
        boolean gotLineColor = elem.hasAttribute("outlineAttrs");
        if (bar.isEdgeOn() || gotGroup || gotTarget) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), bar.getEdgeStyle(), contextName);
                LineAttrs ls = new LineAttrs();
                GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), ls, "Outlines");
                if (bar.isFillOn()) {
                    bar.getEdgeStyle().setLinePattern(ls.getLinePattern());
                }
                bar.getEdgeStyle().setWidth(ls.getWidth());
            } else {
                GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), bar.getEdgeStyle(), "Outlines");
            }
        }
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("errorBarAttrs"), bar.getErrorStyle(), "Error");
        str = elem.getAttribute("errorBarCapShape");
        if (str.equalsIgnoreCase("none")) {
            bar.setErrorCapVisible(false);
        } else if (str.equalsIgnoreCase("serif")) {
            bar.setErrorCapVisible(true);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("errorBarCapeShape", str);
        } else {
            str = graph.style.getStyleAttribute("Error", "capStyle");
            if (str != null && str.length() > 0) {
                if (str.equalsIgnoreCase("none")) {
                    bar.setErrorCapVisible(false);
                } else if (str.equalsIgnoreCase("serif")) {
                    bar.setErrorCapVisible(true);
                }
            }
        }
        str = elem.getAttribute("errorBarCapScale");
        if (StatGraph.isNumber(str)) {
            bar.setCapScale(Double.parseDouble(str));
        }
        if (bar.isConnectOn()) {
            if (gotGroup) {
                bar.getConnectStyle().setColor(null);
            } else {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("connectAttrs"), bar.getConnectStyle(), "ConnectLine");
            }
            str = elem.getAttribute("connectBreak");
            if (str.equalsIgnoreCase("true")) {
                bar.setConnectSkipMiss(true);
            }
        }
        if (bar.isShowBarValue() || gotDataLabel) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), bar.getLabelStyle(), "DataText");
            bar.setUseLabelColor(true);
        }
        if (bar.isShowBarValue() && (str = elem.getAttribute("barLabelFormat")).length() > 0) {
            Message msg;
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt == null) {
                msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"BARLABELFORMAT", (Object)str));
            } else if (fmt.isCharacterFormat()) {
                msg = new Message(RB.getStringResource("LayoutOverlayParser.", "formattype.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"BARLABELFORMAT", (Object)str));
            } else {
                bar.setLabelFormat(fmt);
            }
        }
        if ((str = elem.getAttribute("displayZeroLengthBar")).length() > 0 && str.equalsIgnoreCase("false")) {
            bar.setDisplayZeroHeightBar(false);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs") && bar.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, fillStyle);
                if (!((Element)node).hasAttribute("color")) continue;
                gotColor = true;
                continue;
            }
            if (elemTag.equals("FillPatternAttrs") && bar.isFillPatternOn()) {
                StatGraph.parseFillPatternAttrs(graph, (Element)node, bar.getFillPatternStyle());
                if (((Element)node).hasAttribute("pattern")) {
                    gotFillPattern = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotFillPatternColor = true;
                continue;
            }
            if (elemTag.equals("OutlineAttrs") && (bar.isEdgeOn() || gotGroup || gotTarget)) {
                StatGraph.parseLineAttrs(graph, (Element)node, bar.getEdgeStyle());
                if (((Element)node).hasAttribute("pattern")) {
                    gotLine = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotLineColor = true;
                continue;
            }
            if (elemTag.equals("ConnectAttrs") && bar.isConnectOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, bar.getConnectStyle());
                continue;
            }
            if (elemTag.equals("ErrorBarAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, bar.getErrorStyle());
                continue;
            }
            if (elemTag.equals("DataLabelAttrs") && (bar.isShowBarValue() || gotDataLabel)) {
                StatGraph.parseTextAttrs(graph, (Element)node, bar.getLabelStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                bar.setUseLabelColor(true);
                continue;
            }
            if (elemTag.equals("SegmentLabelAttrs") && bar.isShowSegmentLabel()) {
                StatGraph.parseTextAttrs(graph, (Element)node, bar.getSegmentLabelStyle());
                continue;
            }
            if (!elemTag.equals("BaselineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, bar.getBaselineStyle());
        }
        bar.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        bar.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        bar.setTargetColor(bar.getEdgeStyle().getColor());
        str = elem.getAttribute("discreteOffset");
        if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                bar.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (gradientColor) {
            Color missingColor;
            ColorEncoder encoder = null;
            if (bar.isFillOn()) {
                missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor();
                encoder = bar.getFillStyle() != null && bar.getFillStyle().getTransparency() >= 0.0 ? StatGraph.parseColorModelOpt((byte)4, graph, elem, bar, bar.getFillStyle().getTransparency()) : StatGraph.parseColorModelOpt((byte)4, graph, elem, bar);
                if (encoder != null) {
                    bar.setEncoder((byte)4, encoder);
                }
            } else {
                missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
                encoder = StatGraph.parseColorModelOpt((byte)17, graph, elem, bar);
                if (encoder != null) {
                    bar.setEncoder((byte)17, encoder);
                }
            }
            if (bar.isFillOn() && bar.getFillStyle().getTransparency() >= 0.0) {
                bar.setMissingColorResponseColor(BarOverlay.applyTransparency(missingColor, bar.getFillStyle().getTransparency()));
            } else {
                bar.setMissingColorResponseColor(bar.applyDataTransparency(missingColor));
            }
        } else {
            if (!gotColor && (crd.isAvailable(6) || bar.isMultiResponse())) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bar, (byte)4, bar.getFillStyle().getTransparency());
            }
            int contrastColorCnt = graph.style.getContrastColorCount();
            if (!gotLineColor && (crd.isAvailable(46) || bar.isMultiResponse())) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, bar, (byte)17);
                if (gotLineColor) {
                    bar.setUseEdgeColor(true);
                }
            }
            graph.style.setContrastColorCount(contrastColorCnt);
            if (!gotFillPatternColor && (crd.isAvailable(112) || bar.isMultiResponse())) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bar, (byte)22, bar.getFillPatternStyle().getTransparency());
                if (!gotFillPatternColor) {
                    bar.getFillPatternStyle().setColor(null);
                }
            }
        }
        if (!gotLine && (crd.isAvailable(36) || bar.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, bar, (byte)15);
            if (gotLine) {
                bar.setUseEdgePattern(true);
            }
        }
        if (!gotFillPattern && (crd.isAvailable(111) || bar.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, bar, (byte)21);
        }
        if (crd.isAvailable(28)) {
            LayoutOverlayParser.setContinuousEncoder(graph, bar, (byte)9);
        }
        if (crd.isAvailable(29)) {
            LayoutOverlayParser.setContinuousEncoder(graph, bar, (byte)10);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String xVarID = StatGraph.getVarID(str);
        String dataName = StatGraph.getDataName(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        DataModel model = graph.getData(dataName);
        if (model == null) {
            model = graph.getData(StatGraph.getDataName(str));
        }
        if (model == null) {
            str = elem.getAttribute("orient");
            if (str.equalsIgnoreCase("Horizontal")) {
                types[0] = 0;
                types[1] = 2;
            } else {
                types[0] = 2;
                types[1] = 0;
            }
            types[2] = 0;
            return types;
        }
        if (yVarID.length() > 0) {
            int ycol = model.getColumn(yVarID);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol);
            if (cmd.getType() == 2) {
                return null;
            }
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        } else {
            type = 0;
        }
        if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
            return null;
        }
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            types[0] = type;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }

    private static boolean transposeData(StatGraph graph, Element elem) {
        int i;
        Object[] newx;
        Object[] oldx;
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null) {
            return true;
        }
        elem.removeAttribute("index");
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
        DataModel old_dm = graph.getData(dataName);
        dataName = dataName + "_MULTI_RESPONSES";
        DataModel dm = new DataModel();
        dm.name = dataName;
        graph.addData(dm);
        int oldOBS = old_dm.getRowCount();
        int newOBS = oldOBS * multiResponseVars.length;
        int oldXCol = old_dm.getColumn(xVarID);
        ColumnMetadata cmd = (ColumnMetadata)old_dm.getColumnLabel(oldXCol);
        String fmtName = cmd.getFormat() == null ? null : cmd.getFormat().getName();
        byte type = cmd.getType();
        if (type == 1) {
            oldx = old_dm.getDoubleColumn(oldXCol);
            newx = new double[newOBS];
            for (i = 0; i < newOBS; ++i) {
                newx[i] = oldx[i % oldOBS];
            }
            dm.addDoubleColumn("CATEGORY", cmd.getLabel(), fmtName, cmd.getMin(), cmd.getMax(), cmd.getMissings() * multiResponseVars.length, (double[])newx);
        } else {
            oldx = old_dm.getStringColumn(oldXCol);
            newx = new String[newOBS];
            for (i = 0; i < newOBS; ++i) {
                newx[i] = oldx[i % oldOBS];
            }
            dm.addStringColumn("CATEGORY", cmd.getLabel(), fmtName, cmd.getLength(), cmd.getMissings() * multiResponseVars.length, (String[])newx);
        }
        double[] newy = new double[newOBS];
        String[] groups = new String[newOBS];
        double min = Double.MAX_VALUE;
        double max = -min;
        int nmiss = 0;
        String label = null;
        int glen = 0;
        int rcnt = 0;
        for (int i2 = 0; i2 < multiResponseVars.length; ++i2) {
            String rVarID = StatGraph.getVarID(multiResponseVars[i2]);
            int rcol = old_dm.getColumn(rVarID);
            cmd = (ColumnMetadata)old_dm.getColumnLabel(rcol);
            if (cmd.getType() == 2) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "dt.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"RESPONSE", (Object)cmd.getName()));
                continue;
            }
            ++rcnt;
            double[] oldx2 = old_dm.getDoubleColumn(rcol);
            if (i2 == 0) {
                fmtName = cmd.getFormat() == null ? null : cmd.getFormat().getName();
                label = cmd.getLabel();
            } else {
                label = label + ", " + cmd.getLabel();
            }
            min = Math.min(min, cmd.getMin());
            max = Math.max(max, cmd.getMax());
            nmiss += cmd.getMissings();
            glen = Math.max(glen, cmd.getLabel().length());
            for (int j = 0; j < oldOBS; ++j) {
                newy[i2 * oldOBS + j] = oldx2[j];
                groups[i2 * oldOBS + j] = cmd.getLabel();
            }
        }
        if (rcnt == 0) {
            return false;
        }
        dm.addDoubleColumn("RESPONSE", label, fmtName, min, max, nmiss, newy);
        dm.addStringColumn("GROUP", "GROUP", null, glen, 0, groups);
        String newXName = dataName + "#CATEGORY";
        String newYName = dataName + "#RESPONSE";
        String newGName = dataName + "#GROUP";
        elem.setAttribute("x", newXName);
        elem.setAttribute("y", newYName);
        elem.setAttribute("group", newGName);
        return true;
    }

    public static boolean isUnderDataMatrix(Element elem) {
        Node parentNode = elem.getParentNode();
        String name = parentNode.getNodeName();
        return name.equalsIgnoreCase("LayoutPrototypeOverlay2D");
    }
}

