/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BandOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class BandParser {
    public static final String RB_KEY = "BandParser.";

    public static BandOverlay load(StatGraph graph, Element elem, int autoCurveLabelPosition) {
        BandOverlay band = (BandOverlay)graph.getObjectFromElement(elem);
        if (band == null) {
            band = new BandOverlay();
        }
        return BandParser.load(graph, band, elem, autoCurveLabelPosition) ? band : null;
    }

    public static boolean load(StatGraph graph, BandOverlay band, Element elem, int autoCurveLabelPosition) {
        int maxVertices;
        String indexVarID;
        int ii;
        String val;
        int type;
        String roleName;
        int i;
        String[] opts;
        graph.addSupportedGraph();
        boolean vertical = false;
        LayoutOverlayParser.parseGraphOpts(graph, elem, band);
        if (band.getXAxis().equalsIgnoreCase("x2")) {
            band.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            band.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (band.getYAxis().equalsIgnoreCase("y2")) {
            band.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            band.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        String str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                band.setJoinVisible(true);
                band.setFillOn(true);
                band.setFillPatternOn(true);
            } else {
                band.setJoinVisible(false);
                band.setFillOn(false);
                band.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        band.setJoinVisible(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        band.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        band.setFillPatternOn(true);
                        continue;
                    }
                    band.setJoinVisible(false);
                    band.setFillOn(true);
                    band.setFillPatternOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Band", "displayOpts");
            if (str != null) {
                band.setJoinVisible(false);
                band.setFillOn(false);
                band.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        band.setJoinVisible(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        band.setFillOn(true);
                        continue;
                    }
                    if (!opts[i].equalsIgnoreCase("fillPattern")) continue;
                    band.setFillPatternOn(true);
                }
                if (!(band.isJoinVisible() || band.isFillOn() || band.isFillPatternOn())) {
                    band.setJoinVisible(false);
                    band.setFillOn(true);
                    band.setFillPatternOn(false);
                }
            } else {
                band.setJoinVisible(false);
                band.setFillOn(true);
                band.setFillPatternOn(false);
            }
        }
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            vertical = true;
            str = elem.getAttribute("y");
            dataName = StatGraph.getDataName(str);
            if (dataName.length() == 0) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
                graph.removeNamedGraph(band);
                return false;
            }
        }
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        String varID = StatGraph.getVarID(str);
        int varcol = m.getColumn(varID);
        String string = roleName = vertical ? "Y" : "X";
        if (!StatGraph.checkVariable(roleName, m.getColumnLabel(varcol), null, 1, true)) {
            graph.removeNamedGraph(band);
            return false;
        }
        int varRole = vertical ? 11 : 10;
        map.map(varRole, varcol);
        band.addRole(roleName, m.getColumnLabel(varcol));
        boolean constantLimitUpper = false;
        str = elem.getAttribute("limitUpper");
        if (StatGraph.getDataName(str).length() > 0) {
            String luVarID = StatGraph.getVarID(str);
            int lucol = m.getColumn(luVarID);
            if (!StatGraph.checkVariable("LIMITUPPER", m.getColumnLabel(lucol), Double.class, 1, true)) {
                graph.removeNamedGraph(band);
                return false;
            }
            int role = vertical ? 32 : 34;
            map.map(role, lucol);
            band.addRole("LIMITUPPER", m.getColumnLabel(lucol));
        } else if (StatGraph.isNumber(str)) {
            if (vertical) {
                band.setXUpperLimit(Double.parseDouble(str));
            } else {
                band.setYUpperLimit(Double.parseDouble(str));
            }
            constantLimitUpper = true;
        } else {
            Message msg = new Message(RB.getStringResource(RB_KEY, "upper.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)str));
            graph.removeNamedGraph(band);
            return false;
        }
        boolean constantLimitLower = false;
        str = elem.getAttribute("limitLower");
        if (StatGraph.getDataName(str).length() > 0) {
            String llVarID = StatGraph.getVarID(str);
            int llcol = m.getColumn(llVarID);
            if (!StatGraph.checkVariable("LIMITLOWER", m.getColumnLabel(llcol), Double.class, 1, true)) {
                graph.removeNamedGraph(band);
                return false;
            }
            int role = vertical ? 33 : 35;
            map.map(role, llcol);
            band.addRole("LIMITLOWER", m.getColumnLabel(llcol));
        } else if (StatGraph.isNumber(str)) {
            if (vertical) {
                band.setXLowerLimit(Double.parseDouble(str));
            } else {
                band.setYLowerLimit(Double.parseDouble(str));
            }
            constantLimitLower = true;
        } else {
            Message msg = new Message(RB.getStringResource(RB_KEY, "lower.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)str));
            graph.removeNamedGraph(band);
            return false;
        }
        str = elem.getAttribute("group");
        String groupVarID = StatGraph.getVarID(str);
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, band.getStmt())) {
            groupVarID = "";
        }
        if (groupVarID.length() > 0 && constantLimitLower && constantLimitUpper) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "group.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
            groupVarID = "";
        }
        Element fillElem = null;
        Element lineElem = null;
        Element curveLabelElem = null;
        Element fillPatternElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OutlineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("CurveLabelAttrs")) {
                curveLabelElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("FillPatternAttrs")) continue;
            fillPatternElem = (Element)node;
        }
        String fillAttr = elem.getAttribute("fillAttrs");
        String outlineAttr = elem.getAttribute("outlineAttrs");
        String fillPatternAttr = elem.getAttribute("fillPatternAttrs");
        if (groupVarID.length() > 0) {
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            if (band.isJoinVisible()) {
                if (!(lineElem != null && lineElem.hasAttribute("color") || outlineAttr.length() != 0)) {
                    map.map(46, gcol);
                    groupMapped = true;
                }
                if (!(lineElem != null && lineElem.hasAttribute("pattern") || outlineAttr.length() != 0)) {
                    map.map(36, gcol);
                    groupMapped = true;
                }
            }
            if (band.isFillOn() && (fillElem == null || !fillElem.hasAttribute("color")) && fillAttr.length() == 0) {
                map.map(6, gcol);
                groupMapped = true;
            }
            if (band.isFillPatternOn()) {
                if (!(fillPatternElem != null && fillPatternElem.hasAttribute("color") || fillPatternAttr.length() != 0)) {
                    map.map(112, gcol);
                    groupMapped = true;
                }
                if (!(fillPatternElem != null && fillPatternElem.hasAttribute("pattern") || fillPatternAttr.length() != 0)) {
                    map.map(111, gcol);
                    groupMapped = true;
                }
            }
            map.map(3, gcol);
            band.addRole("GROUP", m.getColumnLabel(gcol));
            str = elem.getAttribute("includeMissingGroup");
            if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                band.setMissingGroupOn(false);
            }
            if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                band.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : groupVarID;
                DAMDatasetParser.addInternalAttrVar(graph, band, "GROUP", originalGroup);
            }
            if (graph.isCASData()) {
                band.setGroupOrder(1);
                band.setDrawByGroupOrder(true);
            }
        }
        if ((str = elem.getAttribute("curveLabelUpper")).length() > 0) {
            type = StatGraph.getAttributeType(elem, "curveLabelUpper");
            if (type < 0) {
                if (StatGraph.getDataName(str).length() > 0) {
                    if (constantLimitUpper) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper3.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    } else if (groupVarID.length() > 0) {
                        String curveLabelVarID = StatGraph.getVarID(str);
                        if (m.hasColumn(curveLabelVarID)) {
                            int clcol = m.getColumn(curveLabelVarID);
                            map.map(49, clcol);
                            band.addRole("CURVELABEL", m.getColumnLabel(clcol));
                        }
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper1.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    }
                } else if (groupVarID.length() > 0) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper2.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                } else {
                    band.setCurveUpperLabelString(str);
                }
            } else if (type == 0) {
                if (constantLimitUpper) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper3.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                } else if (groupVarID.length() > 0) {
                    String curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(49, clcol);
                        band.addRole("CURVELABEL", m.getColumnLabel(clcol));
                    }
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper1.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                }
            } else if (groupVarID.length() > 0) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "labelupper2.fmt.txt"));
                val = type == 2 ? str : "'" + str + "'";
                StatGraph.printNote(msg.toString((Object)val));
            } else {
                band.setCurveUpperLabelString(str);
            }
        }
        if ((str = elem.getAttribute("curveLabelLower")).length() > 0) {
            type = StatGraph.getAttributeType(elem, "curveLabelLower");
            if (type < 0) {
                if (StatGraph.getDataName(str).length() > 0) {
                    if (constantLimitLower) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "labellower3.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    } else if (groupVarID.length() > 0) {
                        String curveLabelVarID = StatGraph.getVarID(str);
                        if (m.hasColumn(curveLabelVarID)) {
                            int clcol = m.getColumn(curveLabelVarID);
                            map.map(50, clcol);
                        }
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "labellower1.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    }
                } else if (groupVarID.length() > 0) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labellower2.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)str));
                } else {
                    band.setCurveLowerLabelString(str);
                }
            } else if (type == 0) {
                if (constantLimitLower) {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labellower3.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                } else if (groupVarID.length() > 0) {
                    String curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(50, clcol);
                    }
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "labellower1.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                }
            } else if (groupVarID.length() > 0) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "labellower2.fmt.txt"));
                val = type == 2 ? str : "'" + str + "'";
                StatGraph.printNote(msg.toString((Object)val));
            } else {
                band.setCurveLowerLabelString(str);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            map.map(44, ii);
            band.addRole("INDEX", m.getColumnLabel(ii));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, band);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, band);
        str = elem.getAttribute("sortRole");
        if (str.length() > 0 && !str.equalsIgnoreCase("none")) {
            if (str.equalsIgnoreCase("x") && !vertical) {
                crd.setSortRole(10);
            } else if (str.equalsIgnoreCase("y") && vertical) {
                crd.setSortRole(11);
            }
        }
        if (band.isTooltipEnabled()) {
            band.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        band.setModel(crd);
        str = elem.getAttribute("connectOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("AXIS")) {
                band.setConnectOrder(1);
            } else if (str.equalsIgnoreCase("VALUES")) {
                band.setConnectOrder(0);
            } else {
                band.setConnectOrder(0);
                StatGraph.printOptionError("CONNECTORDER", str);
            }
        } else if (graph.isCASData()) {
            band.setConnectOrder(1);
        }
        str = elem.getAttribute("_stmt");
        String contextName = graph.style.isCycleAttrs() ? graph.style.getContextName() : "Confidence";
        band.setContextName(contextName);
        if (band.isJoinVisible()) {
            GraphStyle.setDefaultDataLineStyle(graph, outlineAttr, band.getJoinStyle(), contextName);
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, band.getJoinStyle());
            }
        }
        if (band.isFillPatternOn()) {
            GraphStyle.setDefaultFillPatternStyle(graph, fillPatternAttr, band.getFillPatternStyle(), contextName);
            if (fillPatternElem != null) {
                StatGraph.parseFillPatternAttrs(graph, fillPatternElem, band.getFillPatternStyle());
            }
        }
        if (outlineAttr.length() > 0 || lineElem != null && lineElem.hasAttribute("thickness")) {
            band.setUseLineThickness(true);
        } else {
            band.setUseLineThickness(false);
        }
        if (band.isFillOn()) {
            FillAttrs fillStyle = band.getFillStyle();
            GraphStyle.setDefaultDataFillStyle(graph, fillAttr, fillStyle, contextName);
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fillStyle);
            }
        }
        band.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        str = elem.getAttribute("curveLabelLocation");
        if (str.equalsIgnoreCase("INSIDE")) {
            band.setCurveLabelLocation(0);
        } else if (str.equalsIgnoreCase("OUTSIDE")) {
            if (BandParser.isUnderLatticeLayout(elem)) {
                band.setCurveLabelLocation(0);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "outsidelabel.txt"));
            } else {
                band.setCurveLabelLocation(1);
            }
        } else {
            band.setCurveLabelLocation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("CURVELABELLOCATION", str);
            }
        }
        str = elem.getAttribute("curveLabelPosition");
        if (str.equalsIgnoreCase("MIN")) {
            band.setCurveLabelPosition(0);
        } else if (str.equalsIgnoreCase("MAX")) {
            band.setCurveLabelPosition(1);
        } else if (str.equalsIgnoreCase("START") && band.getCurveLabelLocation() == 0) {
            band.setCurveLabelPosition(2);
        } else if (str.equalsIgnoreCase("END") && band.getCurveLabelLocation() == 0) {
            band.setCurveLabelPosition(3);
        } else if (str.equalsIgnoreCase("AUTO") && band.getCurveLabelLocation() == 1) {
            band.setCurveLabelPosition(autoCurveLabelPosition);
        } else {
            if (band.getCurveLabelLocation() == 1) {
                band.setCurveLabelPosition(autoCurveLabelPosition);
            } else {
                band.setCurveLabelPosition(3);
            }
            if (str.length() > 0) {
                StatGraph.printOptionError("CURVELABELPOSITION", str);
            }
        }
        ScatterParser.parseCurveLabelSplitting(graph, band, elem);
        if (band.isCurveLabeled()) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("curveLabelAttrs"), band.getCurveLabelStyle(), "ValueText");
            if (graph.style.isCycleAttrs()) {
                band.getCurveLabelStyle().setColor(band.getJoinStyle().getColor());
            }
            if (curveLabelElem != null) {
                StatGraph.parseTextAttrs(graph, curveLabelElem, band.getCurveLabelStyle());
            }
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "curveLabelAttrs", "color")) {
                band.setUseCurveLabelColor(true);
            }
        }
        if ((str = elem.getAttribute("extend")).equalsIgnoreCase("true")) {
            if ((!vertical && band.isDiscreteX() || vertical && band.isDiscreteY()) && (!constantLimitUpper || !constantLimitLower)) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "extend.txt"));
            } else if (band.isCurveLabeled() && band.getCurveLabelLocation() == 0) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "extend2.txt"));
            } else {
                band.setExtreme(true);
            }
        }
        if (!band.isExtreme() && (str = elem.getAttribute("displayTail")).equalsIgnoreCase("false")) {
            band.setTailOn(false);
        }
        if (graph.isSALabeling()) {
            band.setProtectedLine(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)band, (byte)4, band.getFillStyle().getTransparency());
        }
        int contrastColorCnt = graph.style.getContrastColorCount();
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, band, (byte)17);
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, band, (byte)15);
        }
        graph.style.setContrastColorCount(contrastColorCnt);
        if (crd.isAvailable(112)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, band, (byte)22);
        }
        if (crd.isAvailable(111)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, band, (byte)21);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        str = elem.getAttribute("modelName");
        if (str.length() > 0) {
            graph.addGraphReference(band, str);
        } else {
            str = elem.getAttribute("type");
            if (str.equalsIgnoreCase("STEP")) {
                str = elem.getAttribute("justify");
                if (str.equalsIgnoreCase("CENTER")) {
                    band.setJoinType((byte)3);
                } else if (str.equalsIgnoreCase("RIGHT")) {
                    band.setJoinType((byte)2);
                } else if (str.equalsIgnoreCase("LEFT")) {
                    band.setJoinType((byte)1);
                } else {
                    band.setJoinType((byte)1);
                    if (str.length() > 0) {
                        StatGraph.printOptionError("JUSTIFY", str);
                    }
                }
            } else if (str.equalsIgnoreCase("SERIES")) {
                band.setJoinType((byte)0);
            } else {
                band.setJoinType((byte)0);
                if (str.length() > 0) {
                    StatGraph.printOptionError("TYPE", str);
                }
            }
        }
        if (!StatGraph.suppressWarningMsg && (maxVertices = band.getMaxVerticesPerGroup(graph.linePatternOBSMax, true)) > graph.linePatternOBSMax) {
            graph.removeNamedGraph(band);
            Message msg = new Message(RB.getStringResource("SeriesParser.", "linepatternmax.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)elem.getAttribute("_stmt").toUpperCase(), (Object)String.valueOf(StatGraph.roundToNextHundreds(maxVertices))), false);
            return false;
        }
        if (!StatGraph.suppressWarningMsg && band.isFillPatternOn() && band.getConnectOrder() == 0 && (maxVertices = band.getMaxVerticesPerGroup(graph.fillPatternOBSMax, false)) > graph.fillPatternOBSMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "fillpatternmax.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)elem.getAttribute("_stmt").toUpperCase()), false);
        }
        return true;
    }

    public static boolean isUnderLatticeLayout(Element elem) {
        Node parentNode = elem.getParentNode();
        String name = parentNode.getNodeName();
        if (name.equalsIgnoreCase("LayoutPrototype") || name.equalsIgnoreCase("LayoutPrototypeOverlay2D")) {
            return true;
        }
        if (name.equalsIgnoreCase("LayoutLattice")) {
            return true;
        }
        return name.equalsIgnoreCase("LayoutOverlay") && (name = (parentNode = parentNode.getParentNode()).getNodeName()).equalsIgnoreCase("LayoutLattice");
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        int limitCol = -1;
        DataModel model = null;
        String str = elem.getAttribute("limitUpper");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() > 0) {
            model = graph.getData(dataName);
            String luVarID = StatGraph.getVarID(str);
            limitCol = model.getColumn(luVarID);
        } else {
            str = elem.getAttribute("limitLower");
            dataName = StatGraph.getDataName(str);
            if (dataName.length() > 0) {
                model = graph.getData(dataName);
                String llVarID = StatGraph.getVarID(str);
                limitCol = model.getColumn(llVarID);
            }
        }
        int type = 0;
        if (limitCol >= 0) {
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(limitCol);
            if (cmd.getType() == 2) {
                return null;
            }
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        boolean vertical = false;
        str = elem.getAttribute("x");
        dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            String yVarID;
            int ycol;
            vertical = true;
            str = elem.getAttribute("y");
            dataName = StatGraph.getDataName(str);
            model = graph.getData(dataName);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol = model.getColumn(yVarID = StatGraph.getVarID(str)));
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                    return null;
                }
                types[1] = 2;
            } else {
                types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            }
        } else {
            String xVarID;
            int xcol;
            dataName = StatGraph.getDataName(str);
            model = graph.getData(dataName);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol = model.getColumn(xVarID = StatGraph.getVarID(str)));
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                    return null;
                }
                types[0] = 2;
            } else {
                types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            }
        }
        if (vertical) {
            types[0] = type;
        } else {
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }
}

