/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.text.MessageFormat;
import org.w3c.dom.Element;

public final class AxisTableParser {
    public static final String RB_KEY = "AxisTableParser.";

    public static AxisTable load(StatGraph graph, Element elem) {
        return AxisTableParser.load(graph, elem, 0);
    }

    public static AxisTable load(StatGraph graph, Element elem, int justification) {
        AxisTable axisTable = (AxisTable)graph.getObjectFromElement(elem);
        if (axisTable == null) {
            axisTable = new AxisTable();
        }
        return AxisTableParser.load(graph, axisTable, elem, justification) ? axisTable : null;
    }

    public static boolean load(StatGraph graph, AxisTable axisTable, Element elem) {
        return AxisTableParser.load(graph, axisTable, elem, 0);
    }

    public static boolean load(StatGraph graph, AxisTable axisTable, Element elem, int overlayJustification) {
        String indentWtId;
        int indentWtCol;
        String classId;
        int classcol;
        String s;
        int varCol;
        String varId;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, axisTable);
        if (axisTable.getXAxis().equalsIgnoreCase("x2")) {
            axisTable.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            axisTable.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (axisTable.getYAxis().equalsIgnoreCase("y2")) {
            axisTable.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            axisTable.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        boolean drop = false;
        String str = elem.getAttribute("dropOnMissing");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            drop = true;
        }
        str = elem.getAttribute("value");
        String dataName = StatGraph.getDataName(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        String columnId = StatGraph.getVarID(str);
        int columnCol = m.getColumn(columnId);
        if (!StatGraph.checkVariable("COLUMN", m.getColumnLabel(columnCol), null, drop ? 1 : 0, true)) {
            graph.removeNamedGraph(axisTable);
            return false;
        }
        map.map(115, columnCol);
        axisTable.addRole("COLUMN", m.getColumnLabel(columnCol));
        boolean xVar = false;
        boolean yVar = false;
        if (elem.hasAttribute("x")) {
            str = elem.getAttribute("x");
            varId = StatGraph.getVarID(str);
            varCol = m.getColumn(varId);
            if (!StatGraph.checkVariable("VAR", m.getColumnLabel(varCol), null, 1, true)) {
                graph.removeNamedGraph(axisTable);
                return false;
            }
            map.map(114, varCol);
            axisTable.addRole("VAR", m.getColumnLabel(varCol));
            xVar = true;
        } else if (elem.hasAttribute("y")) {
            str = elem.getAttribute("y");
            varId = StatGraph.getVarID(str);
            varCol = m.getColumn(varId);
            if (!StatGraph.checkVariable("VAR", m.getColumnLabel(varCol), null, 1, true)) {
                graph.removeNamedGraph(axisTable);
                return false;
            }
            map.map(114, varCol);
            axisTable.addRole("VAR", m.getColumnLabel(varCol));
            yVar = true;
        }
        if (elem.hasAttribute("stat") && "MEAN".equalsIgnoreCase(str = elem.getAttribute("stat"))) {
            axisTable.setStat(1);
        }
        if ((overlayJustification == 3 || overlayJustification == 4) && xVar) {
            s = RB.getStringResource(RB_KEY, "MismatchInnerMarginAlign.fmt.txt");
            StatGraph.printWarning(MessageFormat.format(s, "X", str));
            return false;
        }
        if ((overlayJustification == 1 || overlayJustification == 2) && yVar) {
            s = RB.getStringResource(RB_KEY, "MismatchInnerMarginAlign.fmt.txt");
            StatGraph.printWarning(MessageFormat.format(s, "Y", str));
            return false;
        }
        if (elem.hasAttribute("class") && StatGraph.checkVariable("CATEGORY", m.getColumnLabel(classcol = m.getColumn(classId = StatGraph.getVarID(str = elem.getAttribute("class")))), null, 0, false)) {
            map.map(1, classcol);
            axisTable.addRole("CATEGORY", m.getColumnLabel(classcol));
        }
        if (elem.hasAttribute("colorGroup")) {
            str = elem.getAttribute("colorGroup");
            String groupId = StatGraph.getVarID(str);
            int groupCol = m.getColumn(groupId);
            if (StatGraph.checkVariable("GROUP", m.getColumnLabel(groupCol), null, 0, false)) {
                map.map(3, groupCol);
                axisTable.addRole("GROUP", m.getColumnLabel(groupCol));
            }
            if ((str = elem.getAttribute("colorGroupAttrVar")).length() > 0) {
                axisTable.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                String originalGroup = elem.hasAttribute("_originalColorGroup") ? elem.getAttribute("_originalColorGroup") : groupId;
                DAMDatasetParser.addInternalAttrVar(graph, axisTable, "GROUP", originalGroup);
            }
        }
        if (elem.hasAttribute("textGroup")) {
            String tgav = elem.getAttribute("textGroupAttrVar");
            if (tgav.length() > 0) {
                axisTable.addAttrVar("TEXTGROUP", (AttrMapper)graph.getDiscreteAttrVar(tgav));
                str = elem.getAttribute("textGroup");
                String textGroupId = StatGraph.getVarID(str);
                int textGroupCol = m.getColumn(textGroupId);
                if (StatGraph.checkVariable("TEXTGROUP", m.getColumnLabel(textGroupCol), null, 0, false)) {
                    map.map(116, textGroupCol);
                    axisTable.addRole("TEXTRGOUP", m.getColumnLabel(textGroupCol));
                }
            } else {
                str = elem.getAttribute("textGroup");
                if (str.length() > 0) {
                    String textGroupId = StatGraph.getVarID(str);
                    DAMDatasetParser.addInternalAttrVar(graph, axisTable, "TEXTGROUP", StatGraph.getVarID(textGroupId));
                }
            }
        }
        if (elem.hasAttribute("indentWeight") && StatGraph.checkVariable("INDENTWEIGHT", m.getColumnLabel(indentWtCol = m.getColumn(indentWtId = StatGraph.getVarID(str = elem.getAttribute("indentWeight")))), Double.class, 0, false, false)) {
            map.map(117, indentWtCol);
            axisTable.addRole("INDENTWEIGHT", m.getColumnLabel(indentWtCol));
        }
        if (yVar) {
            if (elem.hasAttribute("yAxis")) {
                str = elem.getAttribute("yAxis");
                if ("y2".equalsIgnoreCase(str)) {
                    axisTable.setAxis(4);
                } else {
                    axisTable.setAxis(3);
                }
            } else {
                axisTable.setAxis(3);
            }
        } else if (xVar && elem.hasAttribute("xAxis")) {
            str = elem.getAttribute("xAxis");
            if ("x2".equalsIgnoreCase(str)) {
                axisTable.setAxis(2);
            } else {
                axisTable.setAxis(1);
            }
        }
        if (elem.hasAttribute("labelPosition") && "MAX".equalsIgnoreCase(str = elem.getAttribute("labelPosition"))) {
            axisTable.setLabelPosition(2);
        }
        if (elem.hasAttribute("position")) {
            str = elem.getAttribute("position");
            axisTable.setOffsetPosition(Double.parseDouble(str));
        }
        if (elem.hasAttribute("headerLabel")) {
            axisTable.setHeaderLabel(elem.getAttribute("headerLabel"));
        }
        if (elem.hasAttribute("title")) {
            axisTable.setHeaderLabel(elem.getAttribute("title"));
        }
        if (elem.hasAttribute("titleHAlign")) {
            str = elem.getAttribute("titleHAlign");
            if (str.equalsIgnoreCase("AUTO")) {
                axisTable.setHeaderHAlign(AxisTable.ALIGN_H_AUTO);
            } else if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setHeaderHAlign(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setHeaderHAlign(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setHeaderHAlign(AxisTable.ALIGN_H_RIGHT);
            } else {
                axisTable.setHeaderHAlign(AxisTable.ALIGN_H_AUTO);
                StatGraph.printOptionError("TITLEHALIGN", str);
            }
        }
        if (yVar && elem.hasAttribute("labelHAlign")) {
            str = elem.getAttribute("labelHAlign");
            if (str.equalsIgnoreCase("AUTO")) {
                axisTable.setLabelHAlign(AxisTable.ALIGN_H_AUTO);
            } else if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setLabelHAlign(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setLabelHAlign(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setLabelHAlign(AxisTable.ALIGN_H_RIGHT);
            } else {
                axisTable.setLabelHAlign(AxisTable.ALIGN_H_AUTO);
                StatGraph.printOptionError("LABELHALIGN", str);
            }
        }
        if (yVar && elem.hasAttribute("valueHAlign")) {
            str = elem.getAttribute("valueHAlign");
            if (str.equalsIgnoreCase("AUTO")) {
                axisTable.setValueHAlign(AxisTable.ALIGN_H_AUTO);
            } else if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setValueHAlign(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setValueHAlign(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setValueHAlign(AxisTable.ALIGN_H_RIGHT);
            } else {
                axisTable.setValueHAlign(AxisTable.ALIGN_H_AUTO);
                StatGraph.printOptionError("VALUEHALIGN", str);
            }
        }
        if (elem.hasAttribute("titleJustify")) {
            str = elem.getAttribute("titleJustify");
            if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setHeaderJustify(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setHeaderJustify(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setHeaderJustify(AxisTable.ALIGN_H_RIGHT);
            } else {
                axisTable.setHeaderJustify(AxisTable.ALIGN_H_LEFT);
                StatGraph.printOptionError("TITLEJUSTIFY", str);
            }
        }
        if (elem.hasAttribute("labelJustify")) {
            str = elem.getAttribute("labelJustify");
            if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setLabelJustify(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setLabelJustify(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setLabelJustify(AxisTable.ALIGN_H_RIGHT);
            } else {
                if (yVar) {
                    axisTable.setLabelJustify(AxisTable.ALIGN_H_CENTER);
                } else {
                    axisTable.setLabelJustify(AxisTable.ALIGN_H_AUTO);
                }
                StatGraph.printOptionError("LABELJUSTIFY", str);
            }
        } else if (!yVar) {
            axisTable.setLabelJustify(AxisTable.ALIGN_H_AUTO);
        }
        if (elem.hasAttribute("valueJustify")) {
            str = elem.getAttribute("valueJustify");
            if (str.equalsIgnoreCase("AUTO")) {
                axisTable.setValueJustify(AxisTable.ALIGN_H_AUTO);
            } else if (str.equalsIgnoreCase("LEFT")) {
                axisTable.setValueJustify(AxisTable.ALIGN_H_LEFT);
            } else if (str.equalsIgnoreCase("CENTER")) {
                axisTable.setValueJustify(AxisTable.ALIGN_H_CENTER);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                axisTable.setValueJustify(AxisTable.ALIGN_H_RIGHT);
            } else {
                axisTable.setValueJustify(AxisTable.ALIGN_H_AUTO);
                StatGraph.printOptionError("VALUEJUSTIFY", str);
            }
        }
        if (elem.hasAttribute("showMissing") && (str = elem.getAttribute("showMissing")).length() > 0 && str.equalsIgnoreCase("false")) {
            axisTable.setShowMissing(false);
        }
        if (elem.hasAttribute("gutter") && StatGraph.isLineThickness(str = elem.getAttribute("gutter"))) {
            axisTable.setClassGutter(graph.unit2GapThickness(str));
        }
        if ((str = elem.getAttribute("pad")).length() > 0 && StatGraph.isLineThickness(str)) {
            int pad = graph.unit2GapThickness(str);
            axisTable.setPad(pad, pad, pad, pad);
        } else {
            Element padAttrs = StatGraph.getOptionAttrsElement(elem, "PadAttrs");
            if (padAttrs != null) {
                int top = -1;
                int left = -1;
                int bottom = -1;
                int right = -1;
                str = padAttrs.getAttribute("top");
                if (StatGraph.isLineThickness(str)) {
                    top = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("left"))) {
                    left = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("bottom"))) {
                    bottom = graph.unit2GapThickness(str);
                }
                if (StatGraph.isLineThickness(str = padAttrs.getAttribute("right"))) {
                    right = graph.unit2GapThickness(str);
                }
                axisTable.setPad(top, left, bottom, right);
            }
        }
        if (elem.hasAttribute("label")) {
            axisTable.setLabel(elem.getAttribute("label"));
        }
        if (elem.hasAttribute("indent")) {
            axisTable.setIndentPixels(Integer.parseInt(elem.getAttribute("indent")));
        } else {
            axisTable.setIndentPixels((int)(0.125 * (double)graph.getDPI()));
        }
        str = elem.getAttribute("classDisplay");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Cluster")) {
                axisTable.setClassDisplay(1);
            } else if (str.equalsIgnoreCase("Stack")) {
                axisTable.setClassDisplay(0);
            } else {
                axisTable.setClassDisplay(0);
                StatGraph.printOptionError("CLASSDISPLAY", str);
            }
        }
        if ((str = elem.getAttribute("classOrder")).length() > 0) {
            if (str.equalsIgnoreCase("Ascending")) {
                axisTable.setClassOrder(1);
            } else if (str.equalsIgnoreCase("Descending")) {
                axisTable.setClassOrder(2);
            } else if (str.equalsIgnoreCase("Data")) {
                axisTable.setClassOrder(0);
            } else if (str.equalsIgnoreCase("ReverseData")) {
                axisTable.setClassOrder(3);
            } else {
                axisTable.setClassOrder(0);
                StatGraph.printOptionError("CLASSORDER", str);
            }
        } else if (graph.isCASData()) {
            axisTable.setClassOrder(1);
        }
        str = elem.getAttribute("clusterWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            axisTable.setClusterWidth(width);
        }
        if ((str = elem.getAttribute("includeMissingClass")).length() > 0 && str.equalsIgnoreCase("false")) {
            axisTable.setMissingClassOn(false);
        }
        if ((str = elem.getAttribute("valueFormat")).length() > 0) {
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt == null) {
                Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"VALUEFORMAT", (Object)str));
            } else {
                axisTable.setValueFormat(fmt);
            }
        }
        if (elem.hasAttribute("display")) {
            axisTable.setDisplayMode(elem.getAttribute("display"));
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, axisTable);
        axisTable.setModel(crd);
        String styleElem = elem.getAttribute("titleAttrs");
        if (styleElem.length() == 0) {
            styleElem = elem.getAttribute("headerLabelAttrs");
        }
        TextAttrs headerAttrs = axisTable.getHeaderLabelAttrs();
        GraphStyle.setDefaultTextStyle(graph, styleElem, headerAttrs, "LabelText");
        Element headerElem = StatGraph.getOptionAttrsElement(elem, "TitleAttrs");
        if (headerElem == null) {
            headerElem = StatGraph.getOptionAttrsElement(elem, "HeaderLabelAttrs");
        }
        if (headerElem != null) {
            StatGraph.parseTextAttrs(graph, headerElem, headerAttrs);
        }
        axisTable.setHeaderLabelAttrs(headerAttrs);
        TextAttrs labelAttrs = axisTable.getLabelAttrs();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), labelAttrs, "ValueText");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "LabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, labelAttrs);
        }
        axisTable.setLabelAttrs(labelAttrs);
        TextAttrs valueAttrs = axisTable.getValueAttrs();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("valueAttrs"), valueAttrs, "DataText");
        Element valueElem = StatGraph.getOptionAttrsElement(elem, "ValueAttrs");
        if (valueElem != null) {
            StatGraph.parseTextAttrs(graph, valueElem, valueAttrs);
        }
        axisTable.setValueAttrs(valueAttrs);
        if (elem.hasAttribute("valueAttrs") || valueElem != null && valueElem.hasAttribute("color")) {
            axisTable.setValueAttrsColorOverride(true);
        }
        if (elem.hasAttribute("valueAttrs") || valueElem != null && valueElem.hasAttribute("weight")) {
            axisTable.setValueAttrsWeightOverride(true);
        }
        if (elem.hasAttribute("valueAttrs") || valueElem != null && valueElem.hasAttribute("style")) {
            axisTable.setValueAttrsStyleOverride(true);
        }
        if (elem.hasAttribute("valueAttrs") || valueElem != null && valueElem.hasAttribute("family")) {
            axisTable.setValueAttrsFontFamilyOverride(true);
        }
        if (elem.hasAttribute("valueAttrs")) {
            axisTable.setValueAttrsOverride(true);
        }
        graph.style.recordCurrentCounters();
        if (crd.isAvailable(3)) {
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)axisTable, (byte)17, (short)3);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        int[] types = new int[3];
        String str = elem.getAttribute("value");
        String dataName = StatGraph.getDataName(str);
        DataModel m = graph.getData(dataName);
        boolean isX = false;
        if (elem.hasAttribute("x")) {
            str = elem.getAttribute("x");
            isX = true;
        } else if (elem.hasAttribute("y")) {
            str = elem.getAttribute("y");
            isX = false;
        }
        String varId = StatGraph.getVarID(str);
        int varCol = m.getColumn(varId);
        ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(varCol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, m, varId)) {
                return null;
            }
            type = 2;
        } else {
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        if (isX) {
            types[0] = type;
            types[1] = -1;
        } else {
            types[0] = -1;
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }
}

