/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.util.gtk.TextStyle;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class AxisLegendParser {
    public static final String RB_KEY = "AxisLegendParser.";

    public static boolean load(StatGraph graph, Element elem, JComponent component, JComponent container) {
        boolean ok = GraphComponentParser.load(graph, elem, component, container);
        AxisLegend legend = (AxisLegend)component;
        String s = elem.getAttribute("axisName");
        if (s.length() == 0) {
            return false;
        }
        graph.addAxisReference(legend, s);
        s = elem.getAttribute("base");
        if (s.length() > 0) {
            legend.setBase(s);
        }
        if ((s = elem.getAttribute("title")).length() > 0) {
            legend.setTitle(s);
        }
        StatGraph.parseBorderOpts(graph, component, elem, null);
        legend.setAntialiased(graph.axisAntialiased);
        TextStyle valueStyle = legend.getValueStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("valueAttrs"), valueStyle, "ValueText");
        Element valAttrs = StatGraph.getOptionAttrsElement(elem, "ValueAttrs");
        if (valAttrs != null) {
            StatGraph.parseTextAttrs(graph, valAttrs, valueStyle);
        }
        TextStyle titleStyle = legend.getTitleStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("titleAttrs"), titleStyle, "LabelText");
        Element titleAttrs = StatGraph.getOptionAttrsElement(elem, "TitleAttrs");
        if (titleAttrs != null) {
            StatGraph.parseTextAttrs(graph, titleAttrs, titleStyle);
        }
        if ((s = elem.getAttribute("order")).equalsIgnoreCase("columnMajor")) {
            legend.setOrder(1);
        } else if (s.equalsIgnoreCase("rowMajor")) {
            legend.setOrder(0);
        } else {
            legend.setOrder(0);
            if (s.length() > 0) {
                StatGraph.printOptionError("ORDER", s);
            }
        }
        s = elem.getAttribute("across");
        if (!s.equals("")) {
            legend.setAcross(Integer.parseInt(s));
        }
        if (!(s = elem.getAttribute("down")).equals("")) {
            legend.setDown(Integer.parseInt(s));
        }
        s = elem.getAttribute("displayClipped");
        legend.setClippingAllowed(s.equalsIgnoreCase("true"));
        return ok;
    }
}

